// |reftest| skip -- Temporal is not supported
// Copyright (C) 2021 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-temporal.instant.prototype.tostring
description: Rounding for fractionalSecondDigits option
info: |
    sec-getstringornumberoption step 3.b:
      b. Return floor(ℝ(_value_)).
    sec-temporal-tosecondsstringprecision step 9:
      9. Let _digits_ be ? GetStringOrNumberOption(_normalizedOptions_, *"fractionalSecondDigits"*, « *"auto"* », 0, 9, *"auto"*).
    sec-temporal.instant.prototype.tostring step 6:
      6. Let _precision_ be ? ToSecondsStringPrecision(_options_).
features: [Temporal]
---*/

const instant = new Temporal.Instant(1_000_000_000_987_650_000n);

let string = instant.toString({ fractionalSecondDigits: 2.5 });
assert.sameValue(string, "2001-09-09T01:46:40.98Z", "fractionalSecondDigits 2.5 truncates to 2");

string = instant.toString({ fractionalSecondDigits: 9.7 });
assert.sameValue(string, "2001-09-09T01:46:40.987650000Z", "fractionalSecondDigits 9.7 truncates to 9 and is not out of range");

string = instant.toString({ fractionalSecondDigits: -0.6 });
assert.sameValue(string, "2001-09-09T01:46:40Z", "fractionalSecondDigits -0.6 truncates to 0 and is not out of range");

reportCompare(0, 0);
