// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!



"use strict";

var EXPORTED_SYMBOLS = [];

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a TabsStore pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerTabsStore() {
        const pointerId = 0; // tabs:TabsStore
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a TabsStore pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerTabsStore(value) {
        const pointerId = 0; // tabs:TabsStore
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a TabsBridgedEngine pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerTabsBridgedEngine() {
        const pointerId = 1; // tabs:TabsBridgedEngine
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a TabsBridgedEngine pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerTabsBridgedEngine(value) {
        const pointerId = 1; // tabs:TabsBridgedEngine
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    static checkType(name, value) {
        if (value === undefined ) {
            throw TypeError(`${name} is undefined`);
        }
        if (value === null ) {
            throw TypeError(`${name} is null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");

class FfiConverterI64 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isSafeInteger(value)) {
            throw TypeError(`${name} exceeds the safe integer bounds (${value})`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterI64");

class FfiConverterString extends FfiConverter {
    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterString");

class TabsBridgedEngine {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    lastSync() {
    const liftResult = (result) => FfiConverterI64.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            7, // tabs:tabs_edc9_TabsBridgedEngine_last_sync
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    setLastSync(lastSync) {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterI64.checkType("lastSync", lastSync);
        return UniFFIScaffolding.callAsync(
            8, // tabs:tabs_edc9_TabsBridgedEngine_set_last_sync
            FfiConverterTypeTabsBridgedEngine.lower(this),
            FfiConverterI64.lower(lastSync),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    syncId() {
    const liftResult = (result) => FfiConverterOptionalstring.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            9, // tabs:tabs_edc9_TabsBridgedEngine_sync_id
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    resetSyncId() {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            10, // tabs:tabs_edc9_TabsBridgedEngine_reset_sync_id
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    ensureCurrentSyncId(newSyncId) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterString.checkType("newSyncId", newSyncId);
        return UniFFIScaffolding.callAsync(
            11, // tabs:tabs_edc9_TabsBridgedEngine_ensure_current_sync_id
            FfiConverterTypeTabsBridgedEngine.lower(this),
            FfiConverterString.lower(newSyncId),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    prepareForSync(clientData) {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterString.checkType("clientData", clientData);
        return UniFFIScaffolding.callAsync(
            12, // tabs:tabs_edc9_TabsBridgedEngine_prepare_for_sync
            FfiConverterTypeTabsBridgedEngine.lower(this),
            FfiConverterString.lower(clientData),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    syncStarted() {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            13, // tabs:tabs_edc9_TabsBridgedEngine_sync_started
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    storeIncoming(incomingEnvelopesAsJson) {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterSequencestring.checkType("incomingEnvelopesAsJson", incomingEnvelopesAsJson);
        return UniFFIScaffolding.callAsync(
            14, // tabs:tabs_edc9_TabsBridgedEngine_store_incoming
            FfiConverterTypeTabsBridgedEngine.lower(this),
            FfiConverterSequencestring.lower(incomingEnvelopesAsJson),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    apply() {
    const liftResult = (result) => FfiConverterSequencestring.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            15, // tabs:tabs_edc9_TabsBridgedEngine_apply
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    setUploaded(newTimestamp,uploadedIds) {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterI64.checkType("newTimestamp", newTimestamp);
        FfiConverterSequenceTypeTabsGuid.checkType("uploadedIds", uploadedIds);
        return UniFFIScaffolding.callAsync(
            16, // tabs:tabs_edc9_TabsBridgedEngine_set_uploaded
            FfiConverterTypeTabsBridgedEngine.lower(this),
            FfiConverterI64.lower(newTimestamp),
            FfiConverterSequenceTypeTabsGuid.lower(uploadedIds),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    syncFinished() {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            17, // tabs:tabs_edc9_TabsBridgedEngine_sync_finished
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    reset() {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            18, // tabs:tabs_edc9_TabsBridgedEngine_reset
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    wipe() {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            19, // tabs:tabs_edc9_TabsBridgedEngine_wipe
            FfiConverterTypeTabsBridgedEngine.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeTabsBridgedEngine extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new TabsBridgedEngine(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerTabsBridgedEngine());
    }

    static write(dataStream, value) {
        dataStream.writePointerTabsBridgedEngine(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("TabsBridgedEngine");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeTabsBridgedEngine");

class TabsStore {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for TabsStore.
     * 
     * @returns {Promise<TabsStore>}: A promise that resolves
     *      to a newly constructed TabsStore
     */
    static init(path) {
    const liftResult = (result) => FfiConverterTypeTabsStore.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterString.checkType("path", path);
        return UniFFIScaffolding.callAsync(
            0, // tabs:tabs_edc9_TabsStore_new
            FfiConverterString.lower(path),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    getAll() {
    const liftResult = (result) => FfiConverterSequenceTypeClientRemoteTabs.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            1, // tabs:tabs_edc9_TabsStore_get_all
            FfiConverterTypeTabsStore.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    setLocalTabs(remoteTabs) {
    const liftResult = (result) => undefined;
    const liftError = null;
    const functionCall = () => {
        FfiConverterSequenceTypeRemoteTabRecord.checkType("remoteTabs", remoteTabs);
        return UniFFIScaffolding.callAsync(
            2, // tabs:tabs_edc9_TabsStore_set_local_tabs
            FfiConverterTypeTabsStore.lower(this),
            FfiConverterSequenceTypeRemoteTabRecord.lower(remoteTabs),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    registerWithSyncManager() {
    const liftResult = (result) => undefined;
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            3, // tabs:tabs_edc9_TabsStore_register_with_sync_manager
            FfiConverterTypeTabsStore.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    reset() {
    const liftResult = (result) => undefined;
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            4, // tabs:tabs_edc9_TabsStore_reset
            FfiConverterTypeTabsStore.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sync(keyId,accessToken,syncKey,tokenserverUrl,localId) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = (data) => FfiConverterTypeTabsApiError.lift(data);
    const functionCall = () => {
        FfiConverterString.checkType("keyId", keyId);
        FfiConverterString.checkType("accessToken", accessToken);
        FfiConverterString.checkType("syncKey", syncKey);
        FfiConverterString.checkType("tokenserverUrl", tokenserverUrl);
        FfiConverterString.checkType("localId", localId);
        return UniFFIScaffolding.callAsync(
            5, // tabs:tabs_edc9_TabsStore_sync
            FfiConverterTypeTabsStore.lower(this),
            FfiConverterString.lower(keyId),
            FfiConverterString.lower(accessToken),
            FfiConverterString.lower(syncKey),
            FfiConverterString.lower(tokenserverUrl),
            FfiConverterString.lower(localId),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    bridgedEngine() {
    const liftResult = (result) => FfiConverterTypeTabsBridgedEngine.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            6, // tabs:tabs_edc9_TabsStore_bridged_engine
            FfiConverterTypeTabsStore.lower(this),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeTabsStore extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new TabsStore(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerTabsStore());
    }

    static write(dataStream, value) {
        dataStream.writePointerTabsStore(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("TabsStore");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeTabsStore");

class ClientRemoteTabs {
    constructor(clientId,clientName,deviceType,lastModified,remoteTabs) {
        FfiConverterString.checkType("clientId", clientId);
        FfiConverterString.checkType("clientName", clientName);
        FfiConverterTypeTabsDeviceType.checkType("deviceType", deviceType);
        FfiConverterI64.checkType("lastModified", lastModified);
        FfiConverterSequenceTypeRemoteTabRecord.checkType("remoteTabs", remoteTabs);
        this.clientId = clientId;
        this.clientName = clientName;
        this.deviceType = deviceType;
        this.lastModified = lastModified;
        this.remoteTabs = remoteTabs;
    }
    equals(other) {
        return (
            this.clientId == other.clientId &&
            this.clientName == other.clientName &&
            this.deviceType == other.deviceType &&
            this.lastModified == other.lastModified &&
            this.remoteTabs == other.remoteTabs
        )
    }
}

class FfiConverterTypeClientRemoteTabs extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new ClientRemoteTabs(
            FfiConverterString.read(dataStream), 
            FfiConverterString.read(dataStream), 
            FfiConverterTypeTabsDeviceType.read(dataStream), 
            FfiConverterI64.read(dataStream), 
            FfiConverterSequenceTypeRemoteTabRecord.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.clientId);
        FfiConverterString.write(dataStream, value.clientName);
        FfiConverterTypeTabsDeviceType.write(dataStream, value.deviceType);
        FfiConverterI64.write(dataStream, value.lastModified);
        FfiConverterSequenceTypeRemoteTabRecord.write(dataStream, value.remoteTabs);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.clientId);
        totalSize += FfiConverterString.computeSize(value.clientName);
        totalSize += FfiConverterTypeTabsDeviceType.computeSize(value.deviceType);
        totalSize += FfiConverterI64.computeSize(value.lastModified);
        totalSize += FfiConverterSequenceTypeRemoteTabRecord.computeSize(value.remoteTabs);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("ClientRemoteTabs");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeClientRemoteTabs");

class RemoteTabRecord {
    constructor(title,urlHistory,icon,lastUsed) {
        FfiConverterString.checkType("title", title);
        FfiConverterSequencestring.checkType("urlHistory", urlHistory);
        FfiConverterOptionalstring.checkType("icon", icon);
        FfiConverterI64.checkType("lastUsed", lastUsed);
        this.title = title;
        this.urlHistory = urlHistory;
        this.icon = icon;
        this.lastUsed = lastUsed;
    }
    equals(other) {
        return (
            this.title == other.title &&
            this.urlHistory == other.urlHistory &&
            this.icon == other.icon &&
            this.lastUsed == other.lastUsed
        )
    }
}

class FfiConverterTypeRemoteTabRecord extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new RemoteTabRecord(
            FfiConverterString.read(dataStream), 
            FfiConverterSequencestring.read(dataStream), 
            FfiConverterOptionalstring.read(dataStream), 
            FfiConverterI64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value.title);
        FfiConverterSequencestring.write(dataStream, value.urlHistory);
        FfiConverterOptionalstring.write(dataStream, value.icon);
        FfiConverterI64.write(dataStream, value.lastUsed);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterString.computeSize(value.title);
        totalSize += FfiConverterSequencestring.computeSize(value.urlHistory);
        totalSize += FfiConverterOptionalstring.computeSize(value.icon);
        totalSize += FfiConverterI64.computeSize(value.lastUsed);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("RemoteTabRecord");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeRemoteTabRecord");

const TabsDeviceType = {
    DESKTOP: 1,
    MOBILE: 2,
    TABLET: 3,
    VR: 4,
    TV: 5,
    UNKNOWN: 6,
};

Object.freeze(TabsDeviceType);
class FfiConverterTypeTabsDeviceType extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return TabsDeviceType.DESKTOP
            case 2:
                return TabsDeviceType.MOBILE
            case 3:
                return TabsDeviceType.TABLET
            case 4:
                return TabsDeviceType.VR
            case 5:
                return TabsDeviceType.TV
            case 6:
                return TabsDeviceType.UNKNOWN
            default:
                return new Error("Unknown TabsDeviceType variant");
        }
    }

    static write(dataStream, value) {
        if (value === TabsDeviceType.DESKTOP) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === TabsDeviceType.MOBILE) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === TabsDeviceType.TABLET) {
            dataStream.writeInt32(3);
            return;
        }
        if (value === TabsDeviceType.VR) {
            dataStream.writeInt32(4);
            return;
        }
        if (value === TabsDeviceType.TV) {
            dataStream.writeInt32(5);
            return;
        }
        if (value === TabsDeviceType.UNKNOWN) {
            dataStream.writeInt32(6);
            return;
        }
        return new Error("Unknown TabsDeviceType variant");
    }

    static computeSize(value) {
        return 4;
    }
}

EXPORTED_SYMBOLS.push("TabsDeviceType");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeTabsDeviceType");



class TabsApiError extends Error {}
EXPORTED_SYMBOLS.push("TabsApiError");


class SyncError extends TabsApiError {
    
    constructor(
        reason,
        ...params
        ) {
            super(...params);
            this.reason = reason;
        }
}
EXPORTED_SYMBOLS.push("SyncError");
class SqlError extends TabsApiError {
    
    constructor(
        reason,
        ...params
        ) {
            super(...params);
            this.reason = reason;
        }
}
EXPORTED_SYMBOLS.push("SqlError");
class UnexpectedTabsError extends TabsApiError {
    
    constructor(
        reason,
        ...params
        ) {
            super(...params);
            this.reason = reason;
        }
}
EXPORTED_SYMBOLS.push("UnexpectedTabsError");

class FfiConverterTypeTabsApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new SyncError(
                    FfiConverterString.read(dataStream)
                    );
            case 2:
                return new SqlError(
                    FfiConverterString.read(dataStream)
                    );
            case 3:
                return new UnexpectedTabsError(
                    FfiConverterString.read(dataStream)
                    );
            default:
                return new Error("Unknown TabsApiError variant");
        }
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeTabsApiError");

class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(name, value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(name, value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterOptionalstring");

class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequencestring");

class FfiConverterSequenceTypeClientRemoteTabs extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeClientRemoteTabs.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeClientRemoteTabs.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeClientRemoteTabs.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequenceTypeClientRemoteTabs");

class FfiConverterSequenceTypeRemoteTabRecord extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeRemoteTabRecord.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeRemoteTabRecord.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeRemoteTabRecord.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequenceTypeRemoteTabRecord");

class FfiConverterSequenceTypeTabsGuid extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeTabsGuid.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeTabsGuid.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeTabsGuid.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequenceTypeTabsGuid");

class FfiConverterTypeTabsGuid extends FfiConverter {

    static lift(buf) {  
        return FfiConverterString.lift(buf);    
    }
    
    static lower(buf) {
        return FfiConverterString.lower(buf);
    }
    
    static write(dataStream, value) {
        FfiConverterString.write(dataStream, value);
    } 
    
    static read(buf) {
        return FfiConverterString.read(buf);
    }
    
    static computeSize(value) {
        return FfiConverterString.computeSize(value);
    }
}
// TODO: We should also allow JS to customize the type eventually.

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeTabsGuid");




