// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!



"use strict";

var EXPORTED_SYMBOLS = [];

// Write/Read data to/from an ArrayBuffer
class ArrayBufferDataStream {
    constructor(arrayBuffer) {
        this.dataView = new DataView(arrayBuffer);
        this.pos = 0;
    }

    readUint8() {
        let rv = this.dataView.getUint8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeUint8(value) {
        this.dataView.setUint8(this.pos, value);
        this.pos += 1;
    }

    readUint16() {
        let rv = this.dataView.getUint16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeUint16(value) {
        this.dataView.setUint16(this.pos, value);
        this.pos += 2;
    }

    readUint32() {
        let rv = this.dataView.getUint32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeUint32(value) {
        this.dataView.setUint32(this.pos, value);
        this.pos += 4;
    }

    readUint64() {
        let rv = this.dataView.getBigUint64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeUint64(value) {
        this.dataView.setBigUint64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readInt8() {
        let rv = this.dataView.getInt8(this.pos);
        this.pos += 1;
        return rv;
    }

    writeInt8(value) {
        this.dataView.setInt8(this.pos, value);
        this.pos += 1;
    }

    readInt16() {
        let rv = this.dataView.getInt16(this.pos);
        this.pos += 2;
        return rv;
    }

    writeInt16(value) {
        this.dataView.setInt16(this.pos, value);
        this.pos += 2;
    }

    readInt32() {
        let rv = this.dataView.getInt32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeInt32(value) {
        this.dataView.setInt32(this.pos, value);
        this.pos += 4;
    }

    readInt64() {
        let rv = this.dataView.getBigInt64(this.pos);
        this.pos += 8;
        return Number(rv);
    }

    writeInt64(value) {
        this.dataView.setBigInt64(this.pos, BigInt(value));
        this.pos += 8;
    }


    readFloat32() {
        let rv = this.dataView.getFloat32(this.pos);
        this.pos += 4;
        return rv;
    }

    writeFloat32(value) {
        this.dataView.setFloat32(this.pos, value);
        this.pos += 4;
    }

    readFloat64() {
        let rv = this.dataView.getFloat64(this.pos);
        this.pos += 8;
        return rv;
    }

    writeFloat64(value) {
        this.dataView.setFloat64(this.pos, value);
        this.pos += 8;
    }


    writeString(value) {
      const encoder = new TextEncoder();
      // Note: in order to efficiently write this data, we first write the
      // string data, reserving 4 bytes for the size.
      const dest = new Uint8Array(this.dataView.buffer, this.pos + 4);
      const encodeResult = encoder.encodeInto(value, dest);
      if (encodeResult.read != value.length) {
        throw new UniFFIError(
            "writeString: out of space when writing to ArrayBuffer.  Did the computeSize() method returned the wrong result?"
        );
      }
      const size = encodeResult.written;
      // Next, go back and write the size before the string data
      this.dataView.setUint32(this.pos, size);
      // Finally, advance our position past both the size and string data
      this.pos += size + 4;
    }

    readString() {
      const decoder = new TextDecoder();
      const size = this.readUint32();
      const source = new Uint8Array(this.dataView.buffer, this.pos, size)
      const value = decoder.decode(source);
      this.pos += size;
      return value;
    }

    // Reads a Retourneur pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerRetourneur() {
        const pointerId = 2; // rondpoint:Retourneur
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Retourneur pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerRetourneur(value) {
        const pointerId = 2; // rondpoint:Retourneur
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a Stringifier pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerStringifier() {
        const pointerId = 3; // rondpoint:Stringifier
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Stringifier pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerStringifier(value) {
        const pointerId = 3; // rondpoint:Stringifier
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    

    // Reads a Optionneur pointer from the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    readPointerOptionneur() {
        const pointerId = 4; // rondpoint:Optionneur
        const res = UniFFIScaffolding.readPointer(pointerId, this.dataView.buffer, this.pos);
        this.pos += 8;
        return res;
    }

    // Writes a Optionneur pointer into the data stream
    // UniFFI Pointers are **always** 8 bytes long. That is enforced
    // by the C++ and Rust Scaffolding code.
    writePointerOptionneur(value) {
        const pointerId = 4; // rondpoint:Optionneur
        UniFFIScaffolding.writePointer(pointerId, value, this.dataView.buffer, this.pos);
        this.pos += 8;
    }
    
}

function handleRustResult(result, liftCallback, liftErrCallback) {
    switch (result.code) {
        case "success":
            return liftCallback(result.data);

        case "error":
            throw liftErrCallback(result.data);

        case "internal-error":
            let message = result.internalErrorMessage;
            if (message) {
                throw new UniFFIInternalError(message);
            } else {
                throw new UniFFIInternalError("Unknown error");
            }

        default:
            throw new UniFFIError(`Unexpected status code: ${result.code}`);
    }
}

class UniFFIError {
    constructor(message) {
        this.message = message;
    }
}

class UniFFIInternalError extends UniFFIError {}

// Base class for FFI converters
class FfiConverter {
    static checkType(name, value) {
        if (value === undefined ) {
            throw TypeError(`${name} is undefined`);
        }
        if (value === null ) {
            throw TypeError(`${name} is null`);
        }
    }
}

// Base class for FFI converters that lift/lower by reading/writing to an ArrayBuffer
class FfiConverterArrayBuffer extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }

    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
}

// Symbols that are used to ensure that Object constructors
// can only be used with a proper UniFFI pointer
const uniffiObjectPtr = Symbol("uniffiObjectPtr");
const constructUniffiObject = Symbol("constructUniffiObject");

class FfiConverterU8 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < 0 || value > 256) {
            throw TypeError(`${name} exceeds the U8 bounds (${value})`);
        }
    }
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint8(value)
    }
    static read(dataStream) {
        return dataStream.readUint8()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterU8");

class FfiConverterI8 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < -128 || value > 127) {
            throw TypeError(`${name} exceeds the I8 bounds (${value})`);
        }
    }
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt8(value)
    }
    static read(dataStream) {
        return dataStream.readInt8()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterI8");

class FfiConverterU16 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < 0 || value > 65535) {
            throw TypeError(`${name} exceeds the U16 bounds (${value})`);
        }
    }
    static computeSize() {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint16(value)
    }
    static read(dataStream) {
        return dataStream.readUint16()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterU16");

class FfiConverterI16 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < -32768 || value > 32767) {
            throw TypeError(`${name} exceeds the I16 bounds (${value})`);
        }
    }
    static computeSize() {
        return 2;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt16(value)
    }
    static read(dataStream) {
        return dataStream.readInt16()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterI16");

class FfiConverterU32 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < 0 || value > 4294967295) {
            throw TypeError(`${name} exceeds the U32 bounds (${value})`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint32(value)
    }
    static read(dataStream) {
        return dataStream.readUint32()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterU32");

class FfiConverterI32 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isInteger(value)) {
            throw TypeError(`${name} is not an integer(${value})`);
        }
        if (value < -2147483648 || value > 2147483647) {
            throw TypeError(`${name} exceeds the I32 bounds (${value})`);
        }
    }
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt32(value)
    }
    static read(dataStream) {
        return dataStream.readInt32()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterI32");

class FfiConverterU64 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isSafeInteger(value)) {
            throw TypeError(`${name} exceeds the safe integer bounds (${value})`);
        }
        if (value < 0) {
            throw TypeError(`${name} exceeds the U64 bounds (${value})`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeUint64(value)
    }
    static read(dataStream) {
        return dataStream.readUint64()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterU64");

class FfiConverterI64 extends FfiConverter {
    static checkType(name, value) {
        super.checkType(name, value);
        if (!Number.isSafeInteger(value)) {
            throw TypeError(`${name} exceeds the safe integer bounds (${value})`);
        }
    }
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeInt64(value)
    }
    static read(dataStream) {
        return dataStream.readInt64()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterI64");

class FfiConverterF32 extends FfiConverter {
    static computeSize() {
        return 4;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat32(value)
    }
    static read(dataStream) {
        return dataStream.readFloat32()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterF32");

class FfiConverterF64 extends FfiConverter {
    static computeSize() {
        return 8;
    }
    static lift(value) {
        return value;
    }
    static lower(value) {
        return value;
    }
    static write(dataStream, value) {
        dataStream.writeFloat64(value)
    }
    static read(dataStream) {
        return dataStream.readFloat64()
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterF64");

class FfiConverterBool extends FfiConverter {
    static computeSize() {
        return 1;
    }
    static lift(value) {
        return value == 1;
    }
    static lower(value) {
        if (value) {
            return 1;
        } else {
            return 0;
        }
    }
    static write(dataStream, value) {
        dataStream.writeUint8(this.lower(value))
    }
    static read(dataStream) {
        return this.lift(dataStream.readUint8())
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterBool");

class FfiConverterString extends FfiConverter {
    static lift(buf) {
        const decoder = new TextDecoder();
        const utf8Arr = new Uint8Array(buf);
        return decoder.decode(utf8Arr);
    }
    static lower(value) {
        const encoder = new TextEncoder();
        return encoder.encode(value).buffer;
    }

    static write(dataStream, value) {
        dataStream.writeString(value);
    }

    static read(dataStream) {
        return dataStream.readString();
    }

    static computeSize(value) {
        const encoder = new TextEncoder();
        return 4 + encoder.encode(value).length
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterString");

class Optionneur {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for Optionneur.
     * 
     * @returns {Promise<Optionneur>}: A promise that resolves
     *      to a newly constructed Optionneur
     */
    static init() {
    const liftResult = (result) => FfiConverterTypeOptionneur.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            55, // rondpoint:rondpoint_c6ef_Optionneur_new
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonBoolean(value = false) {
    const liftResult = (result) => FfiConverterBool.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterBool.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            56, // rondpoint:rondpoint_c6ef_Optionneur_sinon_boolean
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterBool.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonString(value = "default") {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterString.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            57, // rondpoint:rondpoint_c6ef_Optionneur_sinon_string
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterString.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonSequence(value = []) {
    const liftResult = (result) => FfiConverterSequencestring.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterSequencestring.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            58, // rondpoint:rondpoint_c6ef_Optionneur_sinon_sequence
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterSequencestring.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonNull(value = null) {
    const liftResult = (result) => FfiConverterOptionalstring.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterOptionalstring.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            59, // rondpoint:rondpoint_c6ef_Optionneur_sinon_null
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterOptionalstring.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonZero(value = 0) {
    const liftResult = (result) => FfiConverterOptionali32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterOptionali32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            60, // rondpoint:rondpoint_c6ef_Optionneur_sinon_zero
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterOptionali32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU8Dec(value = 42) {
    const liftResult = (result) => FfiConverterU8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            61, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u8_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI8Dec(value = -42) {
    const liftResult = (result) => FfiConverterI8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            62, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i8_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU16Dec(value = 42) {
    const liftResult = (result) => FfiConverterU16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            63, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u16_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI16Dec(value = 42) {
    const liftResult = (result) => FfiConverterI16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            64, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i16_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU32Dec(value = 42) {
    const liftResult = (result) => FfiConverterU32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            65, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u32_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI32Dec(value = 42) {
    const liftResult = (result) => FfiConverterI32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            66, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i32_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU64Dec(value = 42) {
    const liftResult = (result) => FfiConverterU64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            67, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u64_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI64Dec(value = 42) {
    const liftResult = (result) => FfiConverterI64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            68, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i64_dec
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU8Hex(value = 0xff) {
    const liftResult = (result) => FfiConverterU8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            69, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u8_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI8Hex(value = -127) {
    const liftResult = (result) => FfiConverterI8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            70, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i8_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU16Hex(value = 0xffff) {
    const liftResult = (result) => FfiConverterU16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            71, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u16_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI16Hex(value = 0x7f) {
    const liftResult = (result) => FfiConverterI16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            72, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i16_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU32Hex(value = 0xffffffff) {
    const liftResult = (result) => FfiConverterU32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            73, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u32_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI32Hex(value = 0x7fffffff) {
    const liftResult = (result) => FfiConverterI32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            74, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i32_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU64Hex(value = 0xffffffffffffffff) {
    const liftResult = (result) => FfiConverterU64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            75, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u64_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonI64Hex(value = 0x7fffffffffffffff) {
    const liftResult = (result) => FfiConverterI64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            76, // rondpoint:rondpoint_c6ef_Optionneur_sinon_i64_hex
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterI64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonU32Oct(value = 0o755) {
    const liftResult = (result) => FfiConverterU32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            77, // rondpoint:rondpoint_c6ef_Optionneur_sinon_u32_oct
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterU32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonF32(value = 42.0) {
    const liftResult = (result) => FfiConverterF32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            78, // rondpoint:rondpoint_c6ef_Optionneur_sinon_f32
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterF32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonF64(value = 42.1) {
    const liftResult = (result) => FfiConverterF64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            79, // rondpoint:rondpoint_c6ef_Optionneur_sinon_f64
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterF64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    sinonEnum(value = Enumeration.TROIS) {
    const liftResult = (result) => FfiConverterTypeEnumeration.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeEnumeration.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            80, // rondpoint:rondpoint_c6ef_Optionneur_sinon_enum
            FfiConverterTypeOptionneur.lower(this),
            FfiConverterTypeEnumeration.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeOptionneur extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Optionneur(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerOptionneur());
    }

    static write(dataStream, value) {
        dataStream.writePointerOptionneur(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("Optionneur");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeOptionneur");

class Retourneur {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for Retourneur.
     * 
     * @returns {Promise<Retourneur>}: A promise that resolves
     *      to a newly constructed Retourneur
     */
    static init() {
    const liftResult = (result) => FfiConverterTypeRetourneur.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            26, // rondpoint:rondpoint_c6ef_Retourneur_new
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueI8(value) {
    const liftResult = (result) => FfiConverterI8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            27, // rondpoint:rondpoint_c6ef_Retourneur_identique_i8
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterI8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueU8(value) {
    const liftResult = (result) => FfiConverterU8.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            28, // rondpoint:rondpoint_c6ef_Retourneur_identique_u8
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterU8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueI16(value) {
    const liftResult = (result) => FfiConverterI16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            29, // rondpoint:rondpoint_c6ef_Retourneur_identique_i16
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterI16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueU16(value) {
    const liftResult = (result) => FfiConverterU16.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            30, // rondpoint:rondpoint_c6ef_Retourneur_identique_u16
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterU16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueI32(value) {
    const liftResult = (result) => FfiConverterI32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            31, // rondpoint:rondpoint_c6ef_Retourneur_identique_i32
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterI32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueU32(value) {
    const liftResult = (result) => FfiConverterU32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            32, // rondpoint:rondpoint_c6ef_Retourneur_identique_u32
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterU32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueI64(value) {
    const liftResult = (result) => FfiConverterI64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            33, // rondpoint:rondpoint_c6ef_Retourneur_identique_i64
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterI64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueU64(value) {
    const liftResult = (result) => FfiConverterU64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            34, // rondpoint:rondpoint_c6ef_Retourneur_identique_u64
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterU64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueFloat(value) {
    const liftResult = (result) => FfiConverterF32.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            35, // rondpoint:rondpoint_c6ef_Retourneur_identique_float
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterF32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueDouble(value) {
    const liftResult = (result) => FfiConverterF64.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            36, // rondpoint:rondpoint_c6ef_Retourneur_identique_double
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterF64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueBoolean(value) {
    const liftResult = (result) => FfiConverterBool.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterBool.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            37, // rondpoint:rondpoint_c6ef_Retourneur_identique_boolean
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterBool.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueString(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterString.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            38, // rondpoint:rondpoint_c6ef_Retourneur_identique_string
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterString.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueNombresSignes(value) {
    const liftResult = (result) => FfiConverterTypeDictionnaireNombresSignes.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeDictionnaireNombresSignes.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            39, // rondpoint:rondpoint_c6ef_Retourneur_identique_nombres_signes
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterTypeDictionnaireNombresSignes.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueNombres(value) {
    const liftResult = (result) => FfiConverterTypeDictionnaireNombres.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeDictionnaireNombres.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            40, // rondpoint:rondpoint_c6ef_Retourneur_identique_nombres
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterTypeDictionnaireNombres.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    identiqueOptionneurDictionnaire(value) {
    const liftResult = (result) => FfiConverterTypeOptionneurDictionnaire.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeOptionneurDictionnaire.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            41, // rondpoint:rondpoint_c6ef_Retourneur_identique_optionneur_dictionnaire
            FfiConverterTypeRetourneur.lower(this),
            FfiConverterTypeOptionneurDictionnaire.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeRetourneur extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Retourneur(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerRetourneur());
    }

    static write(dataStream, value) {
        dataStream.writePointerRetourneur(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("Retourneur");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeRetourneur");

class Stringifier {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an object using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!opts[constructUniffiObject] instanceof UniFFIPointer) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * An async constructor for Stringifier.
     * 
     * @returns {Promise<Stringifier>}: A promise that resolves
     *      to a newly constructed Stringifier
     */
    static init() {
    const liftResult = (result) => FfiConverterTypeStringifier.lift(result);
    const liftError = null;
    const functionCall = () => {
        return UniFFIScaffolding.callAsync(
            42, // rondpoint:rondpoint_c6ef_Stringifier_new
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    wellKnownString(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterString.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            43, // rondpoint:rondpoint_c6ef_Stringifier_well_known_string
            FfiConverterTypeStringifier.lower(this),
            FfiConverterString.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringI8(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            44, // rondpoint:rondpoint_c6ef_Stringifier_to_string_i8
            FfiConverterTypeStringifier.lower(this),
            FfiConverterI8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringU8(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU8.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            45, // rondpoint:rondpoint_c6ef_Stringifier_to_string_u8
            FfiConverterTypeStringifier.lower(this),
            FfiConverterU8.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringI16(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            46, // rondpoint:rondpoint_c6ef_Stringifier_to_string_i16
            FfiConverterTypeStringifier.lower(this),
            FfiConverterI16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringU16(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU16.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            47, // rondpoint:rondpoint_c6ef_Stringifier_to_string_u16
            FfiConverterTypeStringifier.lower(this),
            FfiConverterU16.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringI32(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            48, // rondpoint:rondpoint_c6ef_Stringifier_to_string_i32
            FfiConverterTypeStringifier.lower(this),
            FfiConverterI32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringU32(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            49, // rondpoint:rondpoint_c6ef_Stringifier_to_string_u32
            FfiConverterTypeStringifier.lower(this),
            FfiConverterU32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringI64(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterI64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            50, // rondpoint:rondpoint_c6ef_Stringifier_to_string_i64
            FfiConverterTypeStringifier.lower(this),
            FfiConverterI64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringU64(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterU64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            51, // rondpoint:rondpoint_c6ef_Stringifier_to_string_u64
            FfiConverterTypeStringifier.lower(this),
            FfiConverterU64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringFloat(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF32.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            52, // rondpoint:rondpoint_c6ef_Stringifier_to_string_float
            FfiConverterTypeStringifier.lower(this),
            FfiConverterF32.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringDouble(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterF64.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            53, // rondpoint:rondpoint_c6ef_Stringifier_to_string_double
            FfiConverterTypeStringifier.lower(this),
            FfiConverterF64.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}
    toStringBoolean(value) {
    const liftResult = (result) => FfiConverterString.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterBool.checkType("value", value);
        return UniFFIScaffolding.callAsync(
            54, // rondpoint:rondpoint_c6ef_Stringifier_to_string_boolean
            FfiConverterTypeStringifier.lower(this),
            FfiConverterBool.lower(value),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }}

}

class FfiConverterTypeStringifier extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new Stringifier(opts);
    }

    static lower(value) {
        return value[uniffiObjectPtr];
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointerStringifier());
    }

    static write(dataStream, value) {
        dataStream.writePointerStringifier(value[uniffiObjectPtr]);
    }

    static computeSize(value) {
        return 8;
    }
}

EXPORTED_SYMBOLS.push("Stringifier");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeStringifier");

class Dictionnaire {
    constructor(un,deux,petitNombre,grosNombre) {
        FfiConverterTypeEnumeration.checkType("un", un);
        FfiConverterBool.checkType("deux", deux);
        FfiConverterU8.checkType("petitNombre", petitNombre);
        FfiConverterU64.checkType("grosNombre", grosNombre);
        this.un = un;
        this.deux = deux;
        this.petitNombre = petitNombre;
        this.grosNombre = grosNombre;
    }
    equals(other) {
        return (
            this.un == other.un &&
            this.deux == other.deux &&
            this.petitNombre == other.petitNombre &&
            this.grosNombre == other.grosNombre
        )
    }
}

class FfiConverterTypeDictionnaire extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new Dictionnaire(
            FfiConverterTypeEnumeration.read(dataStream), 
            FfiConverterBool.read(dataStream), 
            FfiConverterU8.read(dataStream), 
            FfiConverterU64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterTypeEnumeration.write(dataStream, value.un);
        FfiConverterBool.write(dataStream, value.deux);
        FfiConverterU8.write(dataStream, value.petitNombre);
        FfiConverterU64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterTypeEnumeration.computeSize(value.un);
        totalSize += FfiConverterBool.computeSize(value.deux);
        totalSize += FfiConverterU8.computeSize(value.petitNombre);
        totalSize += FfiConverterU64.computeSize(value.grosNombre);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("Dictionnaire");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeDictionnaire");

class DictionnaireNombres {
    constructor(petitNombre,courtNombre,nombreSimple,grosNombre) {
        FfiConverterU8.checkType("petitNombre", petitNombre);
        FfiConverterU16.checkType("courtNombre", courtNombre);
        FfiConverterU32.checkType("nombreSimple", nombreSimple);
        FfiConverterU64.checkType("grosNombre", grosNombre);
        this.petitNombre = petitNombre;
        this.courtNombre = courtNombre;
        this.nombreSimple = nombreSimple;
        this.grosNombre = grosNombre;
    }
    equals(other) {
        return (
            this.petitNombre == other.petitNombre &&
            this.courtNombre == other.courtNombre &&
            this.nombreSimple == other.nombreSimple &&
            this.grosNombre == other.grosNombre
        )
    }
}

class FfiConverterTypeDictionnaireNombres extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new DictionnaireNombres(
            FfiConverterU8.read(dataStream), 
            FfiConverterU16.read(dataStream), 
            FfiConverterU32.read(dataStream), 
            FfiConverterU64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterU8.write(dataStream, value.petitNombre);
        FfiConverterU16.write(dataStream, value.courtNombre);
        FfiConverterU32.write(dataStream, value.nombreSimple);
        FfiConverterU64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterU8.computeSize(value.petitNombre);
        totalSize += FfiConverterU16.computeSize(value.courtNombre);
        totalSize += FfiConverterU32.computeSize(value.nombreSimple);
        totalSize += FfiConverterU64.computeSize(value.grosNombre);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("DictionnaireNombres");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeDictionnaireNombres");

class DictionnaireNombresSignes {
    constructor(petitNombre,courtNombre,nombreSimple,grosNombre) {
        FfiConverterI8.checkType("petitNombre", petitNombre);
        FfiConverterI16.checkType("courtNombre", courtNombre);
        FfiConverterI32.checkType("nombreSimple", nombreSimple);
        FfiConverterI64.checkType("grosNombre", grosNombre);
        this.petitNombre = petitNombre;
        this.courtNombre = courtNombre;
        this.nombreSimple = nombreSimple;
        this.grosNombre = grosNombre;
    }
    equals(other) {
        return (
            this.petitNombre == other.petitNombre &&
            this.courtNombre == other.courtNombre &&
            this.nombreSimple == other.nombreSimple &&
            this.grosNombre == other.grosNombre
        )
    }
}

class FfiConverterTypeDictionnaireNombresSignes extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new DictionnaireNombresSignes(
            FfiConverterI8.read(dataStream), 
            FfiConverterI16.read(dataStream), 
            FfiConverterI32.read(dataStream), 
            FfiConverterI64.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterI8.write(dataStream, value.petitNombre);
        FfiConverterI16.write(dataStream, value.courtNombre);
        FfiConverterI32.write(dataStream, value.nombreSimple);
        FfiConverterI64.write(dataStream, value.grosNombre);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI8.computeSize(value.petitNombre);
        totalSize += FfiConverterI16.computeSize(value.courtNombre);
        totalSize += FfiConverterI32.computeSize(value.nombreSimple);
        totalSize += FfiConverterI64.computeSize(value.grosNombre);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("DictionnaireNombresSignes");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeDictionnaireNombresSignes");

class OptionneurDictionnaire {
    constructor(i8Var = -8,u8Var = 8,i16Var = -16,u16Var = 0x10,i32Var = -32,u32Var = 32,i64Var = -64,u64Var = 64,floatVar = 4.0,doubleVar = 8.0,booleanVar = true,stringVar = "default",listVar = [],enumerationVar = Enumeration.DEUX,dictionnaireVar = null) {
        FfiConverterI8.checkType("i8Var", i8Var);
        FfiConverterU8.checkType("u8Var", u8Var);
        FfiConverterI16.checkType("i16Var", i16Var);
        FfiConverterU16.checkType("u16Var", u16Var);
        FfiConverterI32.checkType("i32Var", i32Var);
        FfiConverterU32.checkType("u32Var", u32Var);
        FfiConverterI64.checkType("i64Var", i64Var);
        FfiConverterU64.checkType("u64Var", u64Var);
        FfiConverterF32.checkType("floatVar", floatVar);
        FfiConverterF64.checkType("doubleVar", doubleVar);
        FfiConverterBool.checkType("booleanVar", booleanVar);
        FfiConverterString.checkType("stringVar", stringVar);
        FfiConverterSequencestring.checkType("listVar", listVar);
        FfiConverterTypeEnumeration.checkType("enumerationVar", enumerationVar);
        FfiConverterOptionalTypeminusculeMajusculeEnum.checkType("dictionnaireVar", dictionnaireVar);
        this.i8Var = i8Var;
        this.u8Var = u8Var;
        this.i16Var = i16Var;
        this.u16Var = u16Var;
        this.i32Var = i32Var;
        this.u32Var = u32Var;
        this.i64Var = i64Var;
        this.u64Var = u64Var;
        this.floatVar = floatVar;
        this.doubleVar = doubleVar;
        this.booleanVar = booleanVar;
        this.stringVar = stringVar;
        this.listVar = listVar;
        this.enumerationVar = enumerationVar;
        this.dictionnaireVar = dictionnaireVar;
    }
    equals(other) {
        return (
            this.i8Var == other.i8Var &&
            this.u8Var == other.u8Var &&
            this.i16Var == other.i16Var &&
            this.u16Var == other.u16Var &&
            this.i32Var == other.i32Var &&
            this.u32Var == other.u32Var &&
            this.i64Var == other.i64Var &&
            this.u64Var == other.u64Var &&
            this.floatVar == other.floatVar &&
            this.doubleVar == other.doubleVar &&
            this.booleanVar == other.booleanVar &&
            this.stringVar == other.stringVar &&
            this.listVar == other.listVar &&
            this.enumerationVar == other.enumerationVar &&
            this.dictionnaireVar == other.dictionnaireVar
        )
    }
}

class FfiConverterTypeOptionneurDictionnaire extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new OptionneurDictionnaire(
            FfiConverterI8.read(dataStream), 
            FfiConverterU8.read(dataStream), 
            FfiConverterI16.read(dataStream), 
            FfiConverterU16.read(dataStream), 
            FfiConverterI32.read(dataStream), 
            FfiConverterU32.read(dataStream), 
            FfiConverterI64.read(dataStream), 
            FfiConverterU64.read(dataStream), 
            FfiConverterF32.read(dataStream), 
            FfiConverterF64.read(dataStream), 
            FfiConverterBool.read(dataStream), 
            FfiConverterString.read(dataStream), 
            FfiConverterSequencestring.read(dataStream), 
            FfiConverterTypeEnumeration.read(dataStream), 
            FfiConverterOptionalTypeminusculeMajusculeEnum.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterI8.write(dataStream, value.i8Var);
        FfiConverterU8.write(dataStream, value.u8Var);
        FfiConverterI16.write(dataStream, value.i16Var);
        FfiConverterU16.write(dataStream, value.u16Var);
        FfiConverterI32.write(dataStream, value.i32Var);
        FfiConverterU32.write(dataStream, value.u32Var);
        FfiConverterI64.write(dataStream, value.i64Var);
        FfiConverterU64.write(dataStream, value.u64Var);
        FfiConverterF32.write(dataStream, value.floatVar);
        FfiConverterF64.write(dataStream, value.doubleVar);
        FfiConverterBool.write(dataStream, value.booleanVar);
        FfiConverterString.write(dataStream, value.stringVar);
        FfiConverterSequencestring.write(dataStream, value.listVar);
        FfiConverterTypeEnumeration.write(dataStream, value.enumerationVar);
        FfiConverterOptionalTypeminusculeMajusculeEnum.write(dataStream, value.dictionnaireVar);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterI8.computeSize(value.i8Var);
        totalSize += FfiConverterU8.computeSize(value.u8Var);
        totalSize += FfiConverterI16.computeSize(value.i16Var);
        totalSize += FfiConverterU16.computeSize(value.u16Var);
        totalSize += FfiConverterI32.computeSize(value.i32Var);
        totalSize += FfiConverterU32.computeSize(value.u32Var);
        totalSize += FfiConverterI64.computeSize(value.i64Var);
        totalSize += FfiConverterU64.computeSize(value.u64Var);
        totalSize += FfiConverterF32.computeSize(value.floatVar);
        totalSize += FfiConverterF64.computeSize(value.doubleVar);
        totalSize += FfiConverterBool.computeSize(value.booleanVar);
        totalSize += FfiConverterString.computeSize(value.stringVar);
        totalSize += FfiConverterSequencestring.computeSize(value.listVar);
        totalSize += FfiConverterTypeEnumeration.computeSize(value.enumerationVar);
        totalSize += FfiConverterOptionalTypeminusculeMajusculeEnum.computeSize(value.dictionnaireVar);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("OptionneurDictionnaire");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeOptionneurDictionnaire");

class MinusculeMajusculeDict {
    constructor(minusculeMajusculeField) {
        FfiConverterBool.checkType("minusculeMajusculeField", minusculeMajusculeField);
        this.minusculeMajusculeField = minusculeMajusculeField;
    }
    equals(other) {
        return (
            this.minusculeMajusculeField == other.minusculeMajusculeField
        )
    }
}

class FfiConverterTypeminusculeMajusculeDict extends FfiConverter {
    static lift(buf) {
        return this.read(new ArrayBufferDataStream(buf));
    }
    static lower(value) {
        const buf = new ArrayBuffer(this.computeSize(value));
        const dataStream = new ArrayBufferDataStream(buf);
        this.write(dataStream, value);
        return buf;
    }
    static read(dataStream) {
        return new MinusculeMajusculeDict(
            FfiConverterBool.read(dataStream)
        );
    }
    static write(dataStream, value) {
        FfiConverterBool.write(dataStream, value.minusculeMajusculeField);
    }

    static computeSize(value) {
        let totalSize = 0;
        totalSize += FfiConverterBool.computeSize(value.minusculeMajusculeField);
        return totalSize
    }
}

EXPORTED_SYMBOLS.push("MinusculeMajusculeDict");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeminusculeMajusculeDict");

const Enumeration = {
    UN: 1,
    DEUX: 2,
    TROIS: 3,
};

Object.freeze(Enumeration);
class FfiConverterTypeEnumeration extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return Enumeration.UN
            case 2:
                return Enumeration.DEUX
            case 3:
                return Enumeration.TROIS
            default:
                return new Error("Unknown Enumeration variant");
        }
    }

    static write(dataStream, value) {
        if (value === Enumeration.UN) {
            dataStream.writeInt32(1);
            return;
        }
        if (value === Enumeration.DEUX) {
            dataStream.writeInt32(2);
            return;
        }
        if (value === Enumeration.TROIS) {
            dataStream.writeInt32(3);
            return;
        }
        return new Error("Unknown Enumeration variant");
    }

    static computeSize(value) {
        return 4;
    }
}

EXPORTED_SYMBOLS.push("Enumeration");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeEnumeration");

class EnumerationAvecDonnees {}
EnumerationAvecDonnees.Zero = class extends EnumerationAvecDonnees{
    constructor(
        ) {
            super();
        }
}
EnumerationAvecDonnees.Un = class extends EnumerationAvecDonnees{
    constructor(
        premier
        ) {
            super();
            this.premier = premier;
        }
}
EnumerationAvecDonnees.Deux = class extends EnumerationAvecDonnees{
    constructor(
        premier,
        second
        ) {
            super();
            this.premier = premier;
            this.second = second;
        }
}

class FfiConverterTypeEnumerationAvecDonnees extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new EnumerationAvecDonnees.Zero(
                    );
            case 2:
                return new EnumerationAvecDonnees.Un(
                    FfiConverterU32.read(dataStream)
                    );
            case 3:
                return new EnumerationAvecDonnees.Deux(
                    FfiConverterU32.read(dataStream),
                    FfiConverterString.read(dataStream)
                    );
            default:
                return new Error("Unknown EnumerationAvecDonnees variant");
        }
    }

    static write(dataStream, value) {
        if (value instanceof EnumerationAvecDonnees.Zero) {
            dataStream.writeInt32(1);
            return;
        }
        if (value instanceof EnumerationAvecDonnees.Un) {
            dataStream.writeInt32(2);
            FfiConverterU32.write(dataStream, value.premier);
            return;
        }
        if (value instanceof EnumerationAvecDonnees.Deux) {
            dataStream.writeInt32(3);
            FfiConverterU32.write(dataStream, value.premier);
            FfiConverterString.write(dataStream, value.second);
            return;
        }
        return new Error("Unknown EnumerationAvecDonnees variant");
    }

    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof EnumerationAvecDonnees.Zero) {
            return totalSize;
        }
        if (value instanceof EnumerationAvecDonnees.Un) {
            totalSize += FfiConverterU32.computeSize(value.premier);
            return totalSize;
        }
        if (value instanceof EnumerationAvecDonnees.Deux) {
            totalSize += FfiConverterU32.computeSize(value.premier);
            totalSize += FfiConverterString.computeSize(value.second);
            return totalSize;
        }
        return new Error("Unknown EnumerationAvecDonnees variant");
    }
}

EXPORTED_SYMBOLS.push("EnumerationAvecDonnees");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeEnumerationAvecDonnees");

const MinusculeMajusculeEnum = {
    MINUSCULE_MAJUSCULE_VARIANT: 1,
};

Object.freeze(MinusculeMajusculeEnum);
class FfiConverterTypeminusculeMajusculeEnum extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return MinusculeMajusculeEnum.MINUSCULE_MAJUSCULE_VARIANT
            default:
                return new Error("Unknown MinusculeMajusculeEnum variant");
        }
    }

    static write(dataStream, value) {
        if (value === MinusculeMajusculeEnum.MINUSCULE_MAJUSCULE_VARIANT) {
            dataStream.writeInt32(1);
            return;
        }
        return new Error("Unknown MinusculeMajusculeEnum variant");
    }

    static computeSize(value) {
        return 4;
    }
}

EXPORTED_SYMBOLS.push("MinusculeMajusculeEnum");

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterTypeminusculeMajusculeEnum");

class FfiConverterOptionali32 extends FfiConverterArrayBuffer {
    static checkType(name, value) {
        if (value !== undefined && value !== null) {
            FfiConverterI32.checkType(name, value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterI32.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterI32.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterI32.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterOptionali32");

class FfiConverterOptionalstring extends FfiConverterArrayBuffer {
    static checkType(name, value) {
        if (value !== undefined && value !== null) {
            FfiConverterString.checkType(name, value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterString.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterString.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterString.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterOptionalstring");

class FfiConverterOptionalTypeminusculeMajusculeEnum extends FfiConverterArrayBuffer {
    static checkType(name, value) {
        if (value !== undefined && value !== null) {
            FfiConverterTypeminusculeMajusculeEnum.checkType(name, value)
        }
    }

    static read(dataStream) {
        const code = dataStream.readUint8(0);
        switch (code) {
            case 0:
                return null
            case 1:
                return FfiConverterTypeminusculeMajusculeEnum.read(dataStream)
            default:
                throw UniFFIError(`Unexpected code: ${code}`);
        }
    }

    static write(dataStream, value) {
        if (value === null || value === undefined) {
            dataStream.writeUint8(0);
            return;
        }
        dataStream.writeUint8(1);
        FfiConverterTypeminusculeMajusculeEnum.write(dataStream, value)
    }

    static computeSize(value) {
        if (value === null || value === undefined) {
            return 1;
        }
        return 1 + FfiConverterTypeminusculeMajusculeEnum.computeSize(value)
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterOptionalTypeminusculeMajusculeEnum");

class FfiConverterSequencestring extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterString.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterString.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterString.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequencestring");

class FfiConverterSequenceTypeEnumeration extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const arr = [];
        for (let i = 0; i < len; i++) {
            arr.push(FfiConverterTypeEnumeration.read(dataStream));
        }
        return arr;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(value.length);
        value.forEach((innerValue) => {
            FfiConverterTypeEnumeration.write(dataStream, innerValue);
        })
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const innerValue of value) {
            size += FfiConverterTypeEnumeration.computeSize(innerValue);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterSequenceTypeEnumeration");

class FfiConverterMapStringTypeEnumerationAvecDonnees extends FfiConverterArrayBuffer {
    static read(dataStream) {
        const len = dataStream.readInt32();
        const map = {};
        for (let i = 0; i < len; i++) {
            const key = FfiConverterString.read(dataStream);
            const value = FfiConverterTypeEnumerationAvecDonnees.read(dataStream);
            map[key] = value;
        }

        return map;
    }

    static write(dataStream, value) {
        dataStream.writeInt32(Object.keys(value).length);
        for (const key in value) {
            FfiConverterString.write(dataStream, key);
            FfiConverterTypeEnumerationAvecDonnees.write(dataStream, value[key]);
        }
    }

    static computeSize(value) {
        // The size of the length
        let size = 4;
        for (const key in value) {
            size += FfiConverterString.computeSize(key);
            size += FfiConverterTypeEnumerationAvecDonnees.computeSize(value[key]);
        }
        return size;
    }
}

// Export the FFIConverter object to make external types work.
EXPORTED_SYMBOLS.push("FfiConverterMapStringTypeEnumerationAvecDonnees");




function copieDictionnaire(d) {
    
    const liftResult = (result) => FfiConverterTypeDictionnaire.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeDictionnaire.checkType("d", d);
        return UniFFIScaffolding.callAsync(
            81, // rondpoint:rondpoint_c6ef_copie_dictionnaire
            FfiConverterTypeDictionnaire.lower(d),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("copieDictionnaire");
function copieEnumeration(e) {
    
    const liftResult = (result) => FfiConverterTypeEnumeration.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterTypeEnumeration.checkType("e", e);
        return UniFFIScaffolding.callAsync(
            82, // rondpoint:rondpoint_c6ef_copie_enumeration
            FfiConverterTypeEnumeration.lower(e),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("copieEnumeration");
function copieEnumerations(e) {
    
    const liftResult = (result) => FfiConverterSequenceTypeEnumeration.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterSequenceTypeEnumeration.checkType("e", e);
        return UniFFIScaffolding.callAsync(
            83, // rondpoint:rondpoint_c6ef_copie_enumerations
            FfiConverterSequenceTypeEnumeration.lower(e),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("copieEnumerations");
function copieCarte(c) {
    
    const liftResult = (result) => FfiConverterMapStringTypeEnumerationAvecDonnees.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterMapStringTypeEnumerationAvecDonnees.checkType("c", c);
        return UniFFIScaffolding.callAsync(
            84, // rondpoint:rondpoint_c6ef_copie_carte
            FfiConverterMapStringTypeEnumerationAvecDonnees.lower(c),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("copieCarte");
function switcheroo(b) {
    
    const liftResult = (result) => FfiConverterBool.lift(result);
    const liftError = null;
    const functionCall = () => {
        FfiConverterBool.checkType("b", b);
        return UniFFIScaffolding.callAsync(
            85, // rondpoint:rondpoint_c6ef_switcheroo
            FfiConverterBool.lower(b),
        )
    }
    try {
        return functionCall().then((result) => handleRustResult(result, liftResult, liftError));
    }  catch (error) {
        return Promise.reject(error)
    }
}

EXPORTED_SYMBOLS.push("switcheroo");
