// This file was autogenerated by the `uniffi-bindgen-gecko-js` crate.
// Trust me, you don't want to mess with it!

import {
  ArrayBufferDataStream,
  FfiConverter,
  FfiConverterArrayBuffer,
  FfiConverterInt8,
  FfiConverterUInt8,
  FfiConverterInt16,
  FfiConverterUInt16,
  FfiConverterInt32,
  FfiConverterUInt32,
  FfiConverterInt64,
  FfiConverterUInt64,
  FfiConverterFloat32,
  FfiConverterFloat64,
  FfiConverterBoolean,
  FfiConverterBytes,
  FfiConverterString,
  UniFFICallbackHandler,
  UniFFICallbackMethodHandler,
  UniFFIError,
  UniFFIInternalError,
  UniFFITypeError,
  constructUniffiObject,
  handleRustResult,
  uniffiObjectPtr,
} from "moz-src:///toolkit/components/uniffi-js/js/UniFFI.sys.mjs";

// Objects intended to be used in the unit tests
export var UnitTestObjs = {
    uniffiObjectPtr,
};




/**
 * Public error class
 */
export class ApiError extends Error {}


/**
 * Other
 */
export class Other extends ApiError {

    constructor(
        reason,
        ...params
    ) {
        const message = `reason: ${ reason }`;
        super(message, ...params);
        this.reason = reason;
    }
    toString() {
        return `Other: ${super.toString()}`
    }
}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeApiError extends FfiConverterArrayBuffer {
    static read(dataStream) {
        switch (dataStream.readInt32()) {
            case 1:
                return new Other(
                    FfiConverterString.read(dataStream)
                    );
            default:
                throw new UniFFITypeError("Unknown ApiError variant");
        }
    }
    static computeSize(value) {
        // Size of the Int indicating the variant
        let totalSize = 4;
        if (value instanceof Other) {
            totalSize += FfiConverterString.computeSize(value.reason);
            return totalSize;
        }
        throw new UniFFITypeError("Unknown ApiError variant");
    }
    static write(dataStream, value) {
        if (value instanceof Other) {
            dataStream.writeInt32(1);
            FfiConverterString.write(dataStream, value.reason);
            return;
        }
        throw new UniFFITypeError("Unknown ApiError variant");
    }

    static errorClass = ApiError;
}



/**
 * FilterAdultComponentInterface
 */
export class FilterAdultComponentInterface {
    /**
     * Check if a URL is in the adult domain list
     * @param {string} baseDomainToCheck
     * @returns {boolean}
     */
    contains(
        baseDomainToCheck) {
      throw Error("contains not implemented");
    }

}

/**
 * FilterAdultComponent
 */
export class FilterAdultComponent extends FilterAdultComponentInterface {
    // Use `init` to instantiate this class.
    // DO NOT USE THIS CONSTRUCTOR DIRECTLY
    constructor(opts) {
        super();
        if (!Object.prototype.hasOwnProperty.call(opts, constructUniffiObject)) {
            throw new UniFFIError("Attempting to construct an int using the JavaScript constructor directly" +
            "Please use a UDL defined constructor, or the init function for the primary constructor")
        }
        if (!(opts[constructUniffiObject] instanceof UniFFIPointer)) {
            throw new UniFFIError("Attempting to create a UniFFI object with a pointer that is not an instance of UniFFIPointer")
        }
        this[uniffiObjectPtr] = opts[constructUniffiObject];
    }
    /**
     * Construct a new FilterAdultComponent
     * @returns {FilterAdultComponent}
     */
    static init() {
       
        const result = UniFFIScaffolding.callSync(
            7, // uniffi_filter_adult_fn_constructor_filteradultcomponent_new
        )
        return handleRustResult(
            result,
            FfiConverterTypeFilterAdultComponent.lift.bind(FfiConverterTypeFilterAdultComponent),
            FfiConverterTypeApiError.lift.bind(FfiConverterTypeApiError),
        )
    }

    /**
     * Check if a URL is in the adult domain list
     * @param {string} baseDomainToCheck
     * @returns {boolean}
     */
    contains(
        baseDomainToCheck) {
       
        FfiConverterString.checkType(baseDomainToCheck);
        const result = UniFFIScaffolding.callSync(
            8, // uniffi_filter_adult_fn_method_filteradultcomponent_contains
            FfiConverterTypeFilterAdultComponent.lowerReceiver(this),
            FfiConverterString.lower(baseDomainToCheck),
        )
        return handleRustResult(
            result,
            FfiConverterBoolean.lift.bind(FfiConverterBoolean),
            FfiConverterTypeApiError.lift.bind(FfiConverterTypeApiError),
        )
    }

}

// Export the FFIConverter object to make external types work.
export class FfiConverterTypeFilterAdultComponent extends FfiConverter {
    static lift(value) {
        const opts = {};
        opts[constructUniffiObject] = value;
        return new FilterAdultComponent(opts);
    }

    static lower(value) {
        const ptr = value[uniffiObjectPtr];
        if (!(ptr instanceof UniFFIPointer)) {
            throw new UniFFITypeError("Object is not a 'FilterAdultComponent' instance");
        }
        return ptr;
    }

    static lowerReceiver(value) {
        // This works exactly the same as lower for non-trait interfaces
        return this.lower(value);
    }

    static read(dataStream) {
        return this.lift(dataStream.readPointer(2));
    }

    static write(dataStream, value) {
        dataStream.writePointer(2, this.lower(value));
    }

    static computeSize(value) {
        return 8;
    }
}



