/**
 * @file Defines the environment for privileges JS files.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

export default {
  globals: {
    // WebAssembly is available everywhere but is not a webIDL definition.
    WebAssembly: "readonly",
    // This list of items is currently obtained manually from the list of
    // mozilla::dom::constructor::id::ID enumerations in an object directory
    // generated dom/bindings/RegisterBindings.cpp
    APZHitResultFlags: "readonly",
    AbortController: "readonly",
    AbortSignal: "readonly",
    AccessibleNode: "readonly",
    Addon: "readonly",
    AddonEvent: "readonly",
    AddonInstall: "readonly",
    AddonManager: "writeable",
    AddonManagerPermissions: "readonly",
    AnalyserNode: "readonly",
    Animation: "readonly",
    AnimationEffect: "readonly",
    AnimationEvent: "readonly",
    AnimationPlaybackEvent: "readonly",
    AnimationTimeline: "readonly",
    AnonymousContent: "readonly",
    Attr: "readonly",
    AudioBuffer: "readonly",
    AudioBufferSourceNode: "readonly",
    AudioContext: "readonly",
    AudioDecoder: "readonly",
    AudioDestinationNode: "readonly",
    AudioData: "readonly",
    AudioEncoder: "readonly",
    AudioListener: "readonly",
    AudioNode: "readonly",
    AudioParam: "readonly",
    AudioParamMap: "readonly",
    AudioProcessingEvent: "readonly",
    AudioScheduledSourceNode: "readonly",
    AudioTrack: "readonly",
    AudioTrackList: "readonly",
    AudioWorklet: "readonly",
    AudioWorkletNode: "readonly",
    AuthenticatorAssertionResponse: "readonly",
    AuthenticatorAttestationResponse: "readonly",
    AuthenticatorResponse: "readonly",
    BarProp: "readonly",
    BaseAudioContext: "readonly",
    BatteryManager: "readonly",
    BeforeUnloadEvent: "readonly",
    BiquadFilterNode: "readonly",
    Blob: "readonly",
    BlobEvent: "readonly",
    BoxObject: "readonly",
    BroadcastChannel: "readonly",
    BrowsingContext: "readonly",
    ByteLengthQueuingStrategy: "readonly",
    CanonicalBrowsingContext: "readonly",
    CDATASection: "readonly",
    CSS: "readonly",
    CSS2Properties: "readonly",
    CSSAnimation: "readonly",
    CSSConditionRule: "readonly",
    CSSCounterStyleRule: "readonly",
    CSSFontFaceRule: "readonly",
    CSSFontFeatureValuesRule: "readonly",
    CSSGroupingRule: "readonly",
    CSSImportRule: "readonly",
    CSSKeyframeRule: "readonly",
    CSSKeyframesRule: "readonly",
    CSSMediaRule: "readonly",
    CSSMozDocumentRule: "readonly",
    CSSNamespaceRule: "readonly",
    CSSPageRule: "readonly",
    CSSPseudoElement: "readonly",
    CSSRule: "readonly",
    CSSRuleList: "readonly",
    CSSStyleDeclaration: "readonly",
    CSSStyleRule: "readonly",
    CSSStyleSheet: "readonly",
    CSSSupportsRule: "readonly",
    CSSTransition: "readonly",
    Cache: "readonly",
    CacheStorage: "readonly",
    CanvasCaptureMediaStream: "readonly",
    CanvasGradient: "readonly",
    CanvasPattern: "readonly",
    CanvasRenderingContext2D: "readonly",
    CaretPosition: "readonly",
    CaretStateChangedEvent: "readonly",
    ChannelMergerNode: "readonly",
    ChannelSplitterNode: "readonly",
    ChannelWrapper: "readonly",
    CharacterData: "readonly",
    CheckerboardReportService: "readonly",
    ChildProcessMessageManager: "readonly",
    ChildSHistory: "readonly",
    ChromeMessageBroadcaster: "readonly",
    ChromeMessageSender: "readonly",
    ChromeNodeList: "readonly",
    ChromeUtils: "readonly",
    ChromeWorker: "readonly",
    Clipboard: "readonly",
    ClipboardEvent: "readonly",
    ClonedErrorHolder: "readonly",
    CloseEvent: "readonly",
    CommandEvent: "readonly",
    Comment: "readonly",
    CompositionEvent: "readonly",
    ConsoleInstance: "readonly",
    ConstantSourceNode: "readonly",
    ContentFrameMessageManager: "readonly",
    ContentProcessMessageManager: "readonly",
    ConvolverNode: "readonly",
    CountQueuingStrategy: "readonly",
    CreateOfferRequest: "readonly",
    Credential: "readonly",
    CredentialsContainer: "readonly",
    Crypto: "readonly",
    CryptoKey: "readonly",
    CustomElementRegistry: "readonly",
    CustomEvent: "readonly",
    DOMError: "readonly",
    DOMException: "readonly",
    DOMImplementation: "readonly",
    DOMLocalization: "readonly",
    DOMMatrix: "readonly",
    DOMMatrixReadOnly: "readonly",
    DOMParser: "readonly",
    DOMPoint: "readonly",
    DOMPointReadOnly: "readonly",
    DOMQuad: "readonly",
    DOMRect: "readonly",
    DOMRectList: "readonly",
    DOMRectReadOnly: "readonly",
    DOMStringList: "readonly",
    DOMStringMap: "readonly",
    DOMTokenList: "readonly",
    DataTransfer: "readonly",
    DataTransferItem: "readonly",
    DataTransferItemList: "readonly",
    DebuggerNotificationObserver: "readonly",
    DelayNode: "readonly",
    DeprecationReportBody: "readonly",
    DeviceLightEvent: "readonly",
    DeviceMotionEvent: "readonly",
    DeviceOrientationEvent: "readonly",
    DeviceProximityEvent: "readonly",
    Directory: "readonly",
    Document: "readonly",
    DocumentFragment: "readonly",
    DocumentTimeline: "readonly",
    DocumentType: "readonly",
    DominatorTree: "readonly",
    DragEvent: "readonly",
    DynamicsCompressorNode: "readonly",
    Element: "readonly",
    EncodedAudioChunk: "readonly",
    EncodedVideoChunk: "readonly",
    ErrorEvent: "readonly",
    Event: "readonly",
    EventSource: "readonly",
    EventTarget: "readonly",
    FeaturePolicyViolationReportBody: "readonly",
    FetchObserver: "readonly",
    File: "readonly",
    FileList: "readonly",
    FileReader: "readonly",
    FileSystem: "readonly",
    FileSystemDirectoryEntry: "readonly",
    FileSystemDirectoryReader: "readonly",
    FileSystemEntry: "readonly",
    FileSystemFileEntry: "readonly",
    Flex: "readonly",
    FlexItemValues: "readonly",
    FlexLineValues: "readonly",
    FluentBundle: "readonly",
    FluentResource: "readonly",
    FocusEvent: "readonly",
    FontFace: "readonly",
    FontFaceSet: "readonly",
    FontFaceSetLoadEvent: "readonly",
    FormData: "readonly",
    FrameCrashedEvent: "readonly",
    FrameLoader: "readonly",
    GainNode: "readonly",
    Gamepad: "readonly",
    GamepadAxisMoveEvent: "readonly",
    GamepadButton: "readonly",
    GamepadButtonEvent: "readonly",
    GamepadEvent: "readonly",
    GamepadHapticActuator: "readonly",
    GamepadPose: "readonly",
    GamepadServiceTest: "readonly",
    Glean: "readonly",
    GleanPings: "readonly",
    Grid: "readonly",
    GridArea: "readonly",
    GridDimension: "readonly",
    GridLine: "readonly",
    GridLines: "readonly",
    GridTrack: "readonly",
    GridTracks: "readonly",
    HTMLAllCollection: "readonly",
    HTMLAnchorElement: "readonly",
    HTMLAreaElement: "readonly",
    HTMLAudioElement: "readonly",
    Audio: "readonly",
    HTMLBRElement: "readonly",
    HTMLBaseElement: "readonly",
    HTMLBodyElement: "readonly",
    HTMLButtonElement: "readonly",
    HTMLCanvasElement: "readonly",
    HTMLCollection: "readonly",
    HTMLDListElement: "readonly",
    HTMLDataElement: "readonly",
    HTMLDataListElement: "readonly",
    HTMLDetailsElement: "readonly",
    HTMLDialogElement: "readonly",
    HTMLDirectoryElement: "readonly",
    HTMLDivElement: "readonly",
    HTMLDocument: "readonly",
    HTMLElement: "readonly",
    HTMLEmbedElement: "readonly",
    HTMLFieldSetElement: "readonly",
    HTMLFontElement: "readonly",
    HTMLFormControlsCollection: "readonly",
    HTMLFormElement: "readonly",
    HTMLFrameElement: "readonly",
    HTMLFrameSetElement: "readonly",
    HTMLHRElement: "readonly",
    HTMLHeadElement: "readonly",
    HTMLHeadingElement: "readonly",
    HTMLHtmlElement: "readonly",
    HTMLIFrameElement: "readonly",
    HTMLImageElement: "readonly",
    Image: "readonly",
    HTMLInputElement: "readonly",
    HTMLLIElement: "readonly",
    HTMLLabelElement: "readonly",
    HTMLLegendElement: "readonly",
    HTMLLinkElement: "readonly",
    HTMLMapElement: "readonly",
    HTMLMarqueeElement: "readonly",
    HTMLMediaElement: "readonly",
    HTMLMenuElement: "readonly",
    HTMLMenuItemElement: "readonly",
    HTMLMetaElement: "readonly",
    HTMLMeterElement: "readonly",
    HTMLModElement: "readonly",
    HTMLOListElement: "readonly",
    HTMLObjectElement: "readonly",
    HTMLOptGroupElement: "readonly",
    HTMLOptionElement: "readonly",
    Option: "readonly",
    HTMLOptionsCollection: "readonly",
    HTMLOutputElement: "readonly",
    HTMLParagraphElement: "readonly",
    HTMLParamElement: "readonly",
    HTMLPictureElement: "readonly",
    HTMLPreElement: "readonly",
    HTMLProgressElement: "readonly",
    HTMLQuoteElement: "readonly",
    HTMLScriptElement: "readonly",
    HTMLSelectElement: "readonly",
    HTMLSlotElement: "readonly",
    HTMLSourceElement: "readonly",
    HTMLSpanElement: "readonly",
    HTMLStyleElement: "readonly",
    HTMLTableCaptionElement: "readonly",
    HTMLTableCellElement: "readonly",
    HTMLTableColElement: "readonly",
    HTMLTableElement: "readonly",
    HTMLTableRowElement: "readonly",
    HTMLTableSectionElement: "readonly",
    HTMLTemplateElement: "readonly",
    HTMLTextAreaElement: "readonly",
    HTMLTimeElement: "readonly",
    HTMLTitleElement: "readonly",
    HTMLTrackElement: "readonly",
    HTMLUListElement: "readonly",
    HTMLUnknownElement: "readonly",
    HTMLVideoElement: "readonly",
    HashChangeEvent: "readonly",
    Headers: "readonly",
    HeapSnapshot: "readonly",
    History: "readonly",
    IDBCursor: "readonly",
    IDBCursorWithValue: "readonly",
    IDBDatabase: "readonly",
    IDBFactory: "readonly",
    IDBFileHandle: "readonly",
    IDBFileRequest: "readonly",
    IDBIndex: "readonly",
    IDBKeyRange: "readonly",
    IDBMutableFile: "readonly",
    IDBObjectStore: "readonly",
    IDBOpenDBRequest: "readonly",
    IDBRequest: "readonly",
    IDBTransaction: "readonly",
    IDBVersionChangeEvent: "readonly",
    IIRFilterNode: "readonly",
    IdleDeadline: "readonly",
    ImageBitmap: "readonly",
    ImageBitmapRenderingContext: "readonly",
    ImageCapture: "readonly",
    ImageCaptureErrorEvent: "readonly",
    ImageData: "readonly",
    ImageDocument: "readonly",
    InputEvent: "readonly",
    InspectorCSSParser: "readonly",
    InspectorFontFace: "readonly",
    InspectorUtils: "readonly",
    InstallTriggerImpl: "readonly",
    IntersectionObserver: "readonly",
    IntersectionObserverEntry: "readonly",
    IOUtils: "readonly",
    JSProcessActorChild: "readonly",
    JSProcessActorParent: "readonly",
    JSWindowActorChild: "readonly",
    JSWindowActorParent: "readonly",
    KeyEvent: "readonly",
    KeyboardEvent: "readonly",
    KeyframeEffect: "readonly",
    L10nFileSource: "readonly",
    L10nRegistry: "readonly",
    Localization: "readonly",
    Location: "readonly",
    MIDIAccess: "readonly",
    MIDIConnectionEvent: "readonly",
    MIDIInput: "readonly",
    MIDIInputMap: "readonly",
    MIDIMessageEvent: "readonly",
    MIDIOutput: "readonly",
    MIDIOutputMap: "readonly",
    MIDIPort: "readonly",
    MatchGlob: "readonly",
    MatchPattern: "readonly",
    MatchPatternSet: "readonly",
    MediaCapabilities: "readonly",
    MediaCapabilitiesInfo: "readonly",
    MediaControlService: "readonly",
    MediaDeviceInfo: "readonly",
    MediaDevices: "readonly",
    MediaElementAudioSourceNode: "readonly",
    MediaEncryptedEvent: "readonly",
    MediaError: "readonly",
    MediaKeyError: "readonly",
    MediaKeyMessageEvent: "readonly",
    MediaKeySession: "readonly",
    MediaKeyStatusMap: "readonly",
    MediaKeySystemAccess: "readonly",
    MediaKeys: "readonly",
    MediaList: "readonly",
    MediaQueryList: "readonly",
    MediaQueryListEvent: "readonly",
    MediaRecorder: "readonly",
    MediaRecorderErrorEvent: "readonly",
    MediaSource: "readonly",
    MediaStream: "readonly",
    MediaStreamAudioDestinationNode: "readonly",
    MediaStreamAudioSourceNode: "readonly",
    MediaStreamEvent: "readonly",
    MediaStreamTrack: "readonly",
    MediaStreamTrackAudioSourceNode: "readonly",
    MediaStreamTrackEvent: "readonly",
    MerchantValidationEvent: "readonly",
    MessageBroadcaster: "readonly",
    MessageChannel: "readonly",
    MessageEvent: "readonly",
    MessageListenerManager: "readonly",
    MessagePort: "readonly",
    MessageSender: "readonly",
    MimeType: "readonly",
    MimeTypeArray: "readonly",
    MouseEvent: "readonly",
    MouseScrollEvent: "readonly",
    MozCanvasPrintState: "readonly",
    MozDocumentMatcher: "readonly",
    MozDocumentObserver: "readonly",
    MozQueryInterface: "readonly",
    MozSharedMap: "readonly",
    MozSharedMapChangeEvent: "readonly",
    MozStorageAsyncStatementParams: "readonly",
    MozStorageStatementParams: "readonly",
    MozStorageStatementRow: "readonly",
    MozWritableSharedMap: "readonly",
    MutationEvent: "readonly",
    MutationObserver: "readonly",
    MutationRecord: "readonly",
    NamedNodeMap: "readonly",
    Navigator: "readonly",
    NetworkInformation: "readonly",
    Node: "readonly",
    NodeFilter: "readonly",
    NodeIterator: "readonly",
    NodeList: "readonly",
    Notification: "readonly",
    NotifyPaintEvent: "readonly",
    OfflineAudioCompletionEvent: "readonly",
    OfflineAudioContext: "readonly",
    OfflineResourceList: "readonly",
    OffscreenCanvas: "readonly",
    OscillatorNode: "readonly",
    PageTransitionEvent: "readonly",
    PaintRequest: "readonly",
    PaintRequestList: "readonly",
    PannerNode: "readonly",
    ParentProcessMessageManager: "readonly",
    Path2D: "readonly",
    PathUtils: "readonly",
    PaymentAddress: "readonly",
    PaymentMethodChangeEvent: "readonly",
    PaymentRequest: "readonly",
    PaymentRequestUpdateEvent: "readonly",
    PaymentResponse: "readonly",
    PeerConnectionImpl: "readonly",
    PeerConnectionObserver: "readonly",
    Performance: "readonly",
    PerformanceEntry: "readonly",
    PerformanceEntryEvent: "readonly",
    PerformanceMark: "readonly",
    PerformanceMeasure: "readonly",
    PerformanceNavigation: "readonly",
    PerformanceNavigationTiming: "readonly",
    PerformanceObserver: "readonly",
    PerformanceObserverEntryList: "readonly",
    PerformanceResourceTiming: "readonly",
    PerformanceServerTiming: "readonly",
    PerformanceTiming: "readonly",
    PeriodicWave: "readonly",
    PermissionStatus: "readonly",
    Permissions: "readonly",
    PlacesBookmark: "readonly",
    PlacesBookmarkAddition: "readonly",
    PlacesBookmarkGuid: "readonly",
    PlacesBookmarkKeyword: "readonly",
    PlacesBookmarkMoved: "readonly",
    PlacesBookmarkRemoved: "readonly",
    PlacesBookmarkTags: "readonly",
    PlacesBookmarkTime: "readonly",
    PlacesBookmarkTitle: "readonly",
    PlacesBookmarkUrl: "readonly",
    PlacesEvent: "readonly",
    PlacesHistoryCleared: "readonly",
    PlacesObservers: "readonly",
    PlacesPurgeCaches: "readonly",
    PlacesRanking: "readonly",
    PlacesVisit: "readonly",
    PlacesVisitRemoved: "readonly",
    PlacesVisitTitle: "readonly",
    PlacesWeakCallbackWrapper: "readonly",
    Plugin: "readonly",
    PluginArray: "readonly",
    PluginCrashedEvent: "readonly",
    PointerEvent: "readonly",
    PopStateEvent: "readonly",
    PopupBlockedEvent: "readonly",
    PrecompiledScript: "readonly",
    Presentation: "readonly",
    PresentationAvailability: "readonly",
    PresentationConnection: "readonly",
    PresentationConnectionAvailableEvent: "readonly",
    PresentationConnectionCloseEvent: "readonly",
    PresentationConnectionList: "readonly",
    PresentationReceiver: "readonly",
    PresentationRequest: "readonly",
    PrioEncoder: "readonly",
    ProcessMessageManager: "readonly",
    ProcessingInstruction: "readonly",
    ProgressEvent: "readonly",
    PromiseDebugging: "readonly",
    PromiseRejectionEvent: "readonly",
    PublicKeyCredential: "readonly",
    PushManager: "readonly",
    PushManagerImpl: "readonly",
    PushSubscription: "readonly",
    PushSubscriptionOptions: "readonly",
    RTCCertificate: "readonly",
    RTCDTMFSender: "readonly",
    RTCDTMFToneChangeEvent: "readonly",
    RTCDataChannel: "readonly",
    RTCDataChannelEvent: "readonly",
    RTCIceCandidate: "readonly",
    RTCPeerConnection: "readonly",
    RTCPeerConnectionIceEvent: "readonly",
    RTCPeerConnectionStatic: "readonly",
    RTCRtpReceiver: "readonly",
    RTCRtpSender: "readonly",
    RTCRtpTransceiver: "readonly",
    RTCSessionDescription: "readonly",
    RTCStatsReport: "readonly",
    RTCTrackEvent: "readonly",
    RadioNodeList: "readonly",
    Range: "readonly",
    ReadableStreamBYOBReader: "readonly",
    ReadableStreamBYOBRequest: "readonly",
    ReadableByteStreamController: "readonly",
    ReadableStream: "readonly",
    ReadableStreamDefaultController: "readonly",
    ReadableStreamDefaultReader: "readonly",
    Report: "readonly",
    ReportBody: "readonly",
    ReportingObserver: "readonly",
    Request: "readonly",
    Response: "readonly",
    SessionStoreUtils: "readonly",
    SVGAElement: "readonly",
    SVGAngle: "readonly",
    SVGAnimateElement: "readonly",
    SVGAnimateMotionElement: "readonly",
    SVGAnimateTransformElement: "readonly",
    SVGAnimatedAngle: "readonly",
    SVGAnimatedBoolean: "readonly",
    SVGAnimatedEnumeration: "readonly",
    SVGAnimatedInteger: "readonly",
    SVGAnimatedLength: "readonly",
    SVGAnimatedLengthList: "readonly",
    SVGAnimatedNumber: "readonly",
    SVGAnimatedNumberList: "readonly",
    SVGAnimatedPreserveAspectRatio: "readonly",
    SVGAnimatedRect: "readonly",
    SVGAnimatedString: "readonly",
    SVGAnimatedTransformList: "readonly",
    SVGAnimationElement: "readonly",
    SVGCircleElement: "readonly",
    SVGClipPathElement: "readonly",
    SVGComponentTransferFunctionElement: "readonly",
    SVGDefsElement: "readonly",
    SVGDescElement: "readonly",
    SVGElement: "readonly",
    SVGEllipseElement: "readonly",
    SVGFEBlendElement: "readonly",
    SVGFEColorMatrixElement: "readonly",
    SVGFEComponentTransferElement: "readonly",
    SVGFECompositeElement: "readonly",
    SVGFEConvolveMatrixElement: "readonly",
    SVGFEDiffuseLightingElement: "readonly",
    SVGFEDisplacementMapElement: "readonly",
    SVGFEDistantLightElement: "readonly",
    SVGFEDropShadowElement: "readonly",
    SVGFEFloodElement: "readonly",
    SVGFEFuncAElement: "readonly",
    SVGFEFuncBElement: "readonly",
    SVGFEFuncGElement: "readonly",
    SVGFEFuncRElement: "readonly",
    SVGFEGaussianBlurElement: "readonly",
    SVGFEImageElement: "readonly",
    SVGFEMergeElement: "readonly",
    SVGFEMergeNodeElement: "readonly",
    SVGFEMorphologyElement: "readonly",
    SVGFEOffsetElement: "readonly",
    SVGFEPointLightElement: "readonly",
    SVGFESpecularLightingElement: "readonly",
    SVGFESpotLightElement: "readonly",
    SVGFETileElement: "readonly",
    SVGFETurbulenceElement: "readonly",
    SVGFilterElement: "readonly",
    SVGForeignObjectElement: "readonly",
    SVGGElement: "readonly",
    SVGGeometryElement: "readonly",
    SVGGradientElement: "readonly",
    SVGGraphicsElement: "readonly",
    SVGImageElement: "readonly",
    SVGLength: "readonly",
    SVGLengthList: "readonly",
    SVGLineElement: "readonly",
    SVGLinearGradientElement: "readonly",
    SVGMPathElement: "readonly",
    SVGMarkerElement: "readonly",
    SVGMaskElement: "readonly",
    SVGMatrix: "readonly",
    SVGMetadataElement: "readonly",
    SVGNumber: "readonly",
    SVGNumberList: "readonly",
    SVGPathElement: "readonly",
    SVGPathSegList: "readonly",
    SVGPatternElement: "readonly",
    SVGPoint: "readonly",
    SVGPointList: "readonly",
    SVGPolygonElement: "readonly",
    SVGPolylineElement: "readonly",
    SVGPreserveAspectRatio: "readonly",
    SVGRadialGradientElement: "readonly",
    SVGRect: "readonly",
    SVGRectElement: "readonly",
    SVGSVGElement: "readonly",
    SVGScriptElement: "readonly",
    SVGSetElement: "readonly",
    SVGStopElement: "readonly",
    SVGStringList: "readonly",
    SVGStyleElement: "readonly",
    SVGSwitchElement: "readonly",
    SVGSymbolElement: "readonly",
    SVGTSpanElement: "readonly",
    SVGTextContentElement: "readonly",
    SVGTextElement: "readonly",
    SVGTextPathElement: "readonly",
    SVGTextPositioningElement: "readonly",
    SVGTitleElement: "readonly",
    SVGTransform: "readonly",
    SVGTransformList: "readonly",
    SVGUnitTypes: "readonly",
    SVGUseElement: "readonly",
    SVGViewElement: "readonly",
    SVGZoomAndPan: "readonly",
    Screen: "readonly",
    ScreenLuminance: "readonly",
    ScreenOrientation: "readonly",
    ScriptProcessorNode: "readonly",
    ScrollAreaEvent: "readonly",
    ScrollViewChangeEvent: "readonly",
    SecurityPolicyViolationEvent: "readonly",
    Selection: "readonly",
    ServiceWorker: "readonly",
    ServiceWorkerContainer: "readonly",
    ServiceWorkerRegistration: "readonly",
    ShadowRoot: "readonly",
    SharedWorker: "readonly",
    SimpleGestureEvent: "readonly",
    SourceBuffer: "readonly",
    SourceBufferList: "readonly",
    SpeechGrammar: "readonly",
    SpeechGrammarList: "readonly",
    SpeechRecognition: "readonly",
    SpeechRecognitionAlternative: "readonly",
    SpeechRecognitionError: "readonly",
    SpeechRecognitionEvent: "readonly",
    SpeechRecognitionResult: "readonly",
    SpeechRecognitionResultList: "readonly",
    SpeechSynthesis: "readonly",
    SpeechSynthesisErrorEvent: "readonly",
    SpeechSynthesisEvent: "readonly",
    SpeechSynthesisUtterance: "readonly",
    SpeechSynthesisVoice: "readonly",
    StereoPannerNode: "readonly",
    Storage: "readonly",
    StorageEvent: "readonly",
    StorageManager: "readonly",
    StreamFilter: "readonly",
    StreamFilterDataEvent: "readonly",
    StructuredCloneHolder: "readonly",
    StructuredCloneTester: "readonly",
    StyleSheet: "readonly",
    StyleSheetApplicableStateChangeEvent: "readonly",
    StyleSheetList: "readonly",
    StyleSheetRemovedEvent: "readonly",
    SubtleCrypto: "readonly",
    SyncMessageSender: "readonly",
    TCPServerSocket: "readonly",
    TCPServerSocketEvent: "readonly",
    TCPSocket: "readonly",
    TCPSocketErrorEvent: "readonly",
    TCPSocketEvent: "readonly",
    TestingDeprecatedInterface: "readonly",
    Text: "readonly",
    TextClause: "readonly",
    TextDecoder: "readonly",
    TextEncoder: "readonly",
    TextMetrics: "readonly",
    TextTrack: "readonly",
    TextTrackCue: "readonly",
    TextTrackCueList: "readonly",
    TextTrackList: "readonly",
    TimeEvent: "readonly",
    TimeRanges: "readonly",
    Touch: "readonly",
    TouchEvent: "readonly",
    TouchList: "readonly",
    TrackEvent: "readonly",
    TransceiverImpl: "readonly",
    TransformStream: "readonly",
    TransformStreamDefaultController: "readonly",
    TransitionEvent: "readonly",
    TreeColumn: "readonly",
    TreeColumns: "readonly",
    TreeContentView: "readonly",
    TreeWalker: "readonly",
    U2F: "readonly",
    UDPMessageEvent: "readonly",
    UDPSocket: "readonly",
    UIEvent: "readonly",
    URL: "readonly",
    URLSearchParams: "readonly",
    UserInteraction: "readonly",
    UserProximityEvent: "readonly",
    VRDisplay: "readonly",
    VRDisplayCapabilities: "readonly",
    VRDisplayEvent: "readonly",
    VREyeParameters: "readonly",
    VRFieldOfView: "readonly",
    VRFrameData: "readonly",
    VRMockController: "readonly",
    VRMockDisplay: "readonly",
    VRPose: "readonly",
    VRServiceTest: "readonly",
    VRStageParameters: "readonly",
    VRSubmitFrameResult: "readonly",
    VTTCue: "readonly",
    VTTRegion: "readonly",
    ValidityState: "readonly",
    VideoColorSpace: "readonly",
    VideoDecoder: "readonly",
    VideoEncoder: "readonly",
    VideoFrame: "readonly",
    VideoPlaybackQuality: "readonly",
    VideoTrack: "readonly",
    VideoTrackList: "readonly",
    VisualViewport: "readonly",
    WaveShaperNode: "readonly",
    WebExtensionContentScript: "readonly",
    WebExtensionPolicy: "readonly",
    WebGL2RenderingContext: "readonly",
    WebGLActiveInfo: "readonly",
    WebGLBuffer: "readonly",
    WebGLContextEvent: "readonly",
    WebGLFramebuffer: "readonly",
    WebGLProgram: "readonly",
    WebGLQuery: "readonly",
    WebGLRenderbuffer: "readonly",
    WebGLRenderingContext: "readonly",
    WebGLSampler: "readonly",
    WebGLShader: "readonly",
    WebGLShaderPrecisionFormat: "readonly",
    WebGLSync: "readonly",
    WebGLTexture: "readonly",
    WebGLTransformFeedback: "readonly",
    WebGLUniformLocation: "readonly",
    WebGLVertexArrayObject: "readonly",
    WebGPU: "readonly",
    WebGPUAdapter: "readonly",
    WebGPUAttachmentState: "readonly",
    WebGPUBindGroup: "readonly",
    WebGPUBindGroupLayout: "readonly",
    WebGPUBindingType: "readonly",
    WebGPUBlendFactor: "readonly",
    WebGPUBlendOperation: "readonly",
    WebGPUBlendState: "readonly",
    WebGPUBuffer: "readonly",
    WebGPUBufferUsage: "readonly",
    WebGPUColorWriteBits: "readonly",
    WebGPUCommandBuffer: "readonly",
    WebGPUCommandEncoder: "readonly",
    WebGPUCompareFunction: "readonly",
    WebGPUComputePipeline: "readonly",
    WebGPUDepthStencilState: "readonly",
    WebGPUDevice: "readonly",
    WebGPUFence: "readonly",
    WebGPUFilterMode: "readonly",
    WebGPUIndexFormat: "readonly",
    WebGPUInputState: "readonly",
    WebGPUInputStepMode: "readonly",
    WebGPULoadOp: "readonly",
    WebGPULogEntry: "readonly",
    WebGPUPipelineLayout: "readonly",
    WebGPUPrimitiveTopology: "readonly",
    WebGPUQueue: "readonly",
    WebGPURenderPipeline: "readonly",
    WebGPUSampler: "readonly",
    WebGPUShaderModule: "readonly",
    WebGPUShaderStage: "readonly",
    WebGPUShaderStageBit: "readonly",
    WebGPUStencilOperation: "readonly",
    WebGPUStoreOp: "readonly",
    WebGPUSwapChain: "readonly",
    WebGPUTexture: "readonly",
    WebGPUTextureDimension: "readonly",
    WebGPUTextureFormat: "readonly",
    WebGPUTextureUsage: "readonly",
    WebGPUTextureView: "readonly",
    WebGPUVertexFormat: "readonly",
    WebKitCSSMatrix: "readonly",
    WebSocket: "readonly",
    WebrtcGlobalInformation: "readonly",
    WheelEvent: "readonly",
    Window: "readonly",
    WindowGlobalChild: "readonly",
    WindowGlobalParent: "readonly",
    WindowRoot: "readonly",
    Worker: "readonly",
    Worklet: "readonly",
    WritableStream: "readonly",
    WritableStreamDefaultController: "readonly",
    WritableStreamDefaultWriter: "readonly",
    XMLDocument: "readonly",
    XMLHttpRequest: "readonly",
    XMLHttpRequestEventTarget: "readonly",
    XMLHttpRequestUpload: "readonly",
    XMLSerializer: "readonly",
    XPathEvaluator: "readonly",
    XPathExpression: "readonly",
    XPathResult: "readonly",
    XSLTProcessor: "readonly",
    XULCommandEvent: "readonly",
    XULElement: "readonly",
    XULFrameElement: "readonly",
    XULMenuElement: "readonly",
    XULPopupElement: "readonly",
    XULScrollElement: "readonly",
    XULTextElement: "readonly",
    console: "readonly",
    // These are hard-coded and available in privileged scopes.
    // See SystemGlobal::Resolve.
    fetch: "readonly",
    crypto: "readonly",
    indexedDB: "readonly",
    structuredClone: "readonly",
    locks: "readonly",
  },
};
