// Copyright (c) 2015 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not be edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#![allow(non_snake_case, unused_imports)]

use eutil;
use interfaces;
use types;
use wrappers::CefWrap;

use libc;
use std::collections::HashMap;
use std::mem;
use std::ptr;

//
// Callback structure used for asynchronous continuation of url requests.
//
#[repr(C)]
pub struct _cef_request_callback_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Continue the url request. If |allow| is true (1) the request will be
  // continued. Otherwise, the request will be canceled.
  //
  pub cont: Option<extern "C" fn(this: *mut cef_request_callback_t,
      allow: libc::c_int) -> ()>,

  //
  // Cancel the url request.
  //
  pub cancel: Option<extern "C" fn(this: *mut cef_request_callback_t) -> ()>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_request_callback_t = _cef_request_callback_t;


//
// Callback structure used for asynchronous continuation of url requests.
//
pub struct CefRequestCallback {
  c_object: *mut cef_request_callback_t,
}

impl Clone for CefRequestCallback {
  fn clone(&self) -> CefRequestCallback{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefRequestCallback {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefRequestCallback {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefRequestCallback {
  pub unsafe fn from_c_object(c_object: *mut cef_request_callback_t) -> CefRequestCallback {
    CefRequestCallback {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_request_callback_t) -> CefRequestCallback {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefRequestCallback {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_request_callback_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_request_callback_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Continue the url request. If |allow| is true (1) the request will be
  // continued. Otherwise, the request will be canceled.
  //
  pub fn cont(&self, allow: libc::c_int) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).cont.unwrap())(
          self.c_object,
          CefWrap::to_c(allow)))
    }
  }

  //
  // Cancel the url request.
  //
  pub fn cancel(&self) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).cancel.unwrap())(
          self.c_object))
    }
  }
} 

impl CefWrap<*mut cef_request_callback_t> for CefRequestCallback {
  fn to_c(rust_object: CefRequestCallback) -> *mut cef_request_callback_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_request_callback_t) -> CefRequestCallback {
    CefRequestCallback::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_request_callback_t> for Option<CefRequestCallback> {
  fn to_c(rust_object: Option<CefRequestCallback>) -> *mut cef_request_callback_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_request_callback_t) -> Option<CefRequestCallback> {
    if c_object.is_null() {
      None
    } else {
      Some(CefRequestCallback::from_c_object_addref(c_object))
    }
  }
}


//
// Implement this structure to handle events related to browser requests. The
// functions of this structure will be called on the thread indicated.
//
#[repr(C)]
pub struct _cef_request_handler_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Called on the UI thread before browser navigation. Return true (1) to
  // cancel the navigation or false (0) to allow the navigation to proceed. The
  // |request| object cannot be modified in this callback.
  // cef_load_handler_t::OnLoadingStateChange will be called twice in all cases.
  // If the navigation is allowed cef_load_handler_t::OnLoadStart and
  // cef_load_handler_t::OnLoadEnd will be called. If the navigation is canceled
  // cef_load_handler_t::OnLoadError will be called with an |errorCode| value of
  // ERR_ABORTED.
  //
  pub on_before_browse: Option<extern "C" fn(this: *mut cef_request_handler_t,
      browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      request: *mut interfaces::cef_request_t,
      is_redirect: libc::c_int) -> libc::c_int>,

  //
  // Called on the UI thread before OnBeforeBrowse in certain limited cases
  // where navigating a new or different browser might be desirable. This
  // includes user-initiated navigation that might open in a special way (e.g.
  // links clicked via middle-click or ctrl + left-click) and certain types of
  // cross-origin navigation initiated from the renderer process (e.g.
  // navigating the top-level frame to/from a file URL). The |browser| and
  // |frame| values represent the source of the navigation. The
  // |target_disposition| value indicates where the user intended to navigate
  // the browser based on standard Chromium behaviors (e.g. current tab, new
  // tab, etc). The |user_gesture| value will be true (1) if the browser
  // navigated via explicit user gesture (e.g. clicking a link) or false (0) if
  // it navigated automatically (e.g. via the DomContentLoaded event). Return
  // true (1) to cancel the navigation or false (0) to allow the navigation to
  // proceed in the source browser's top-level frame.
  //
  pub on_open_urlfrom_tab: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      target_url: *const types::cef_string_t,
      target_disposition: types::cef_window_open_disposition_t,
      user_gesture: libc::c_int) -> libc::c_int>,

  //
  // Called on the IO thread before a resource request is loaded. The |request|
  // object may be modified. Return RV_CONTINUE to continue the request
  // immediately. Return RV_CONTINUE_ASYNC and call cef_request_tCallback::
  // cont() at a later time to continue or cancel the request asynchronously.
  // Return RV_CANCEL to cancel the request immediately.
  //
  //
  pub on_before_resource_load: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      request: *mut interfaces::cef_request_t,
      callback: *mut interfaces::cef_request_callback_t) -> types::cef_return_value_t>,

  //
  // Called on the IO thread before a resource is loaded. To allow the resource
  // to load normally return NULL. To specify a handler for the resource return
  // a cef_resource_handler_t object. The |request| object should not be
  // modified in this callback.
  //
  pub get_resource_handler: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      request: *mut interfaces::cef_request_t) -> *mut interfaces::cef_resource_handler_t>,

  //
  // Called on the IO thread when a resource load is redirected. The |request|
  // parameter will contain the old URL and other request-related information.
  // The |new_url| parameter will contain the new URL and can be changed if
  // desired. The |request| object cannot be modified in this callback.
  //
  pub on_resource_redirect: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      request: *mut interfaces::cef_request_t,
      new_url: *mut types::cef_string_t) -> ()>,

  //
  // Called on the IO thread when a resource response is received. To allow the
  // resource to load normally return false (0). To redirect or retry the
  // resource modify |request| (url, headers or post body) and return true (1).
  // The |response| object cannot be modified in this callback.
  //
  pub on_resource_response: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t,
      request: *mut interfaces::cef_request_t,
      response: *mut interfaces::cef_response_t) -> libc::c_int>,

  //
  // Called on the IO thread when the browser needs credentials from the user.
  // |isProxy| indicates whether the host is a proxy server. |host| contains the
  // hostname and |port| contains the port number. Return true (1) to continue
  // the request and call cef_auth_callback_t::cont() either in this function or
  // at a later time when the authentication information is available. Return
  // false (0) to cancel the request immediately.
  //
  pub get_auth_credentials: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      frame: *mut interfaces::cef_frame_t, isProxy: libc::c_int,
      host: *const types::cef_string_t, port: libc::c_int,
      realm: *const types::cef_string_t, scheme: *const types::cef_string_t,
      callback: *mut interfaces::cef_auth_callback_t) -> libc::c_int>,

  //
  // Called on the IO thread when JavaScript requests a specific storage quota
  // size via the webkitStorageInfo.requestQuota function. |origin_url| is the
  // origin of the page making the request. |new_size| is the requested quota
  // size in bytes. Return true (1) to continue the request and call
  // cef_request_tCallback::cont() either in this function or at a later time to
  // grant or deny the request. Return false (0) to cancel the request
  // immediately.
  //
  pub on_quota_request: Option<extern "C" fn(this: *mut cef_request_handler_t,
      browser: *mut interfaces::cef_browser_t,
      origin_url: *const types::cef_string_t, new_size: i64,
      callback: *mut interfaces::cef_request_callback_t) -> libc::c_int>,

  //
  // Called on the UI thread to handle requests for URLs with an unknown
  // protocol component. Set |allow_os_execution| to true (1) to attempt
  // execution via the registered OS protocol handler, if any. SECURITY WARNING:
  // YOU SHOULD USE THIS METHOD TO ENFORCE RESTRICTIONS BASED ON SCHEME, HOST OR
  // OTHER URL ANALYSIS BEFORE ALLOWING OS EXECUTION.
  //
  pub on_protocol_execution: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      url: *const types::cef_string_t,
      allow_os_execution: *mut libc::c_int) -> ()>,

  //
  // Called on the UI thread to handle requests for URLs with an invalid SSL
  // certificate. Return true (1) and call cef_request_tCallback::cont() either
  // in this function or at a later time to continue or cancel the request.
  // Return false (0) to cancel the request immediately. If |callback| is NULL
  // the error cannot be recovered from and the request will be canceled
  // automatically. If CefSettings.ignore_certificate_errors is set all invalid
  // certificates will be accepted without calling this function.
  //
  pub on_certificate_error: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      cert_error: types::cef_errorcode_t,
      request_url: *const types::cef_string_t,
      ssl_info: *mut interfaces::cef_sslinfo_t,
      callback: *mut interfaces::cef_request_callback_t) -> libc::c_int>,

  //
  // Called on the browser process IO thread before a plugin is loaded. Return
  // true (1) to block loading of the plugin.
  //
  pub on_before_plugin_load: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      url: *const types::cef_string_t, policy_url: *const types::cef_string_t,
      info: *mut interfaces::cef_web_plugin_info_t) -> libc::c_int>,

  //
  // Called on the browser process UI thread when a plugin has crashed.
  // |plugin_path| is the path of the plugin that crashed.
  //
  pub on_plugin_crashed: Option<extern "C" fn(this: *mut cef_request_handler_t,
      browser: *mut interfaces::cef_browser_t,
      plugin_path: *const types::cef_string_t) -> ()>,

  //
  // Called on the browser process UI thread when the render view associated
  // with |browser| is ready to receive/handle IPC messages in the render
  // process.
  //
  pub on_render_view_ready: Option<extern "C" fn(
      this: *mut cef_request_handler_t,
      browser: *mut interfaces::cef_browser_t) -> ()>,

  //
  // Called on the browser process UI thread when the render process terminates
  // unexpectedly. |status| indicates how the process terminated.
  //
  pub on_render_process_terminated: Option<extern "C" fn(
      this: *mut cef_request_handler_t, browser: *mut interfaces::cef_browser_t,
      status: types::cef_termination_status_t) -> ()>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_request_handler_t = _cef_request_handler_t;


//
// Implement this structure to handle events related to browser requests. The
// functions of this structure will be called on the thread indicated.
//
pub struct CefRequestHandler {
  c_object: *mut cef_request_handler_t,
}

impl Clone for CefRequestHandler {
  fn clone(&self) -> CefRequestHandler{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefRequestHandler {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefRequestHandler {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefRequestHandler {
  pub unsafe fn from_c_object(c_object: *mut cef_request_handler_t) -> CefRequestHandler {
    CefRequestHandler {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_request_handler_t) -> CefRequestHandler {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefRequestHandler {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_request_handler_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_request_handler_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Called on the UI thread before browser navigation. Return true (1) to
  // cancel the navigation or false (0) to allow the navigation to proceed. The
  // |request| object cannot be modified in this callback.
  // cef_load_handler_t::OnLoadingStateChange will be called twice in all cases.
  // If the navigation is allowed cef_load_handler_t::OnLoadStart and
  // cef_load_handler_t::OnLoadEnd will be called. If the navigation is canceled
  // cef_load_handler_t::OnLoadError will be called with an |errorCode| value of
  // ERR_ABORTED.
  //
  pub fn on_before_browse(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, request: interfaces::CefRequest,
      is_redirect: libc::c_int) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_before_browse.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(request),
          CefWrap::to_c(is_redirect)))
    }
  }

  //
  // Called on the UI thread before OnBeforeBrowse in certain limited cases
  // where navigating a new or different browser might be desirable. This
  // includes user-initiated navigation that might open in a special way (e.g.
  // links clicked via middle-click or ctrl + left-click) and certain types of
  // cross-origin navigation initiated from the renderer process (e.g.
  // navigating the top-level frame to/from a file URL). The |browser| and
  // |frame| values represent the source of the navigation. The
  // |target_disposition| value indicates where the user intended to navigate
  // the browser based on standard Chromium behaviors (e.g. current tab, new
  // tab, etc). The |user_gesture| value will be true (1) if the browser
  // navigated via explicit user gesture (e.g. clicking a link) or false (0) if
  // it navigated automatically (e.g. via the DomContentLoaded event). Return
  // true (1) to cancel the navigation or false (0) to allow the navigation to
  // proceed in the source browser's top-level frame.
  //
  pub fn on_open_urlfrom_tab(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, target_url: &[u16],
      target_disposition: types::cef_window_open_disposition_t,
      user_gesture: libc::c_int) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_open_urlfrom_tab.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(target_url),
          CefWrap::to_c(target_disposition),
          CefWrap::to_c(user_gesture)))
    }
  }

  //
  // Called on the IO thread before a resource request is loaded. The |request|
  // object may be modified. Return RV_CONTINUE to continue the request
  // immediately. Return RV_CONTINUE_ASYNC and call cef_request_tCallback::
  // cont() at a later time to continue or cancel the request asynchronously.
  // Return RV_CANCEL to cancel the request immediately.
  //
  //
  pub fn on_before_resource_load(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, request: interfaces::CefRequest,
      callback: interfaces::CefRequestCallback) -> types::cef_return_value_t {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_before_resource_load.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(request),
          CefWrap::to_c(callback)))
    }
  }

  //
  // Called on the IO thread before a resource is loaded. To allow the resource
  // to load normally return NULL. To specify a handler for the resource return
  // a cef_resource_handler_t object. The |request| object should not be
  // modified in this callback.
  //
  pub fn get_resource_handler(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame,
      request: interfaces::CefRequest) -> interfaces::CefResourceHandler {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_resource_handler.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(request)))
    }
  }

  //
  // Called on the IO thread when a resource load is redirected. The |request|
  // parameter will contain the old URL and other request-related information.
  // The |new_url| parameter will contain the new URL and can be changed if
  // desired. The |request| object cannot be modified in this callback.
  //
  pub fn on_resource_redirect(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, request: interfaces::CefRequest,
      new_url: *mut types::cef_string_t) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_resource_redirect.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(request),
          CefWrap::to_c(new_url)))
    }
  }

  //
  // Called on the IO thread when a resource response is received. To allow the
  // resource to load normally return false (0). To redirect or retry the
  // resource modify |request| (url, headers or post body) and return true (1).
  // The |response| object cannot be modified in this callback.
  //
  pub fn on_resource_response(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, request: interfaces::CefRequest,
      response: interfaces::CefResponse) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_resource_response.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(request),
          CefWrap::to_c(response)))
    }
  }

  //
  // Called on the IO thread when the browser needs credentials from the user.
  // |isProxy| indicates whether the host is a proxy server. |host| contains the
  // hostname and |port| contains the port number. Return true (1) to continue
  // the request and call cef_auth_callback_t::cont() either in this function or
  // at a later time when the authentication information is available. Return
  // false (0) to cancel the request immediately.
  //
  pub fn get_auth_credentials(&self, browser: interfaces::CefBrowser,
      frame: interfaces::CefFrame, isProxy: libc::c_int, host: &[u16],
      port: libc::c_int, realm: &[u16], scheme: &[u16],
      callback: interfaces::CefAuthCallback) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_auth_credentials.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(frame),
          CefWrap::to_c(isProxy),
          CefWrap::to_c(host),
          CefWrap::to_c(port),
          CefWrap::to_c(realm),
          CefWrap::to_c(scheme),
          CefWrap::to_c(callback)))
    }
  }

  //
  // Called on the IO thread when JavaScript requests a specific storage quota
  // size via the webkitStorageInfo.requestQuota function. |origin_url| is the
  // origin of the page making the request. |new_size| is the requested quota
  // size in bytes. Return true (1) to continue the request and call
  // cef_request_tCallback::cont() either in this function or at a later time to
  // grant or deny the request. Return false (0) to cancel the request
  // immediately.
  //
  pub fn on_quota_request(&self, browser: interfaces::CefBrowser,
      origin_url: &[u16], new_size: i64,
      callback: interfaces::CefRequestCallback) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_quota_request.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(origin_url),
          CefWrap::to_c(new_size),
          CefWrap::to_c(callback)))
    }
  }

  //
  // Called on the UI thread to handle requests for URLs with an unknown
  // protocol component. Set |allow_os_execution| to true (1) to attempt
  // execution via the registered OS protocol handler, if any. SECURITY WARNING:
  // YOU SHOULD USE THIS METHOD TO ENFORCE RESTRICTIONS BASED ON SCHEME, HOST OR
  // OTHER URL ANALYSIS BEFORE ALLOWING OS EXECUTION.
  //
  pub fn on_protocol_execution(&self, browser: interfaces::CefBrowser,
      url: &[u16], allow_os_execution: &mut libc::c_int) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_protocol_execution.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(url),
          CefWrap::to_c(allow_os_execution)))
    }
  }

  //
  // Called on the UI thread to handle requests for URLs with an invalid SSL
  // certificate. Return true (1) and call cef_request_tCallback::cont() either
  // in this function or at a later time to continue or cancel the request.
  // Return false (0) to cancel the request immediately. If |callback| is NULL
  // the error cannot be recovered from and the request will be canceled
  // automatically. If CefSettings.ignore_certificate_errors is set all invalid
  // certificates will be accepted without calling this function.
  //
  pub fn on_certificate_error(&self, browser: interfaces::CefBrowser,
      cert_error: types::cef_errorcode_t, request_url: &[u16],
      ssl_info: interfaces::CefSSLInfo,
      callback: interfaces::CefRequestCallback) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_certificate_error.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(cert_error),
          CefWrap::to_c(request_url),
          CefWrap::to_c(ssl_info),
          CefWrap::to_c(callback)))
    }
  }

  //
  // Called on the browser process IO thread before a plugin is loaded. Return
  // true (1) to block loading of the plugin.
  //
  pub fn on_before_plugin_load(&self, browser: interfaces::CefBrowser,
      url: &[u16], policy_url: &[u16],
      info: interfaces::CefWebPluginInfo) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_before_plugin_load.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(url),
          CefWrap::to_c(policy_url),
          CefWrap::to_c(info)))
    }
  }

  //
  // Called on the browser process UI thread when a plugin has crashed.
  // |plugin_path| is the path of the plugin that crashed.
  //
  pub fn on_plugin_crashed(&self, browser: interfaces::CefBrowser,
      plugin_path: &[u16]) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_plugin_crashed.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(plugin_path)))
    }
  }

  //
  // Called on the browser process UI thread when the render view associated
  // with |browser| is ready to receive/handle IPC messages in the render
  // process.
  //
  pub fn on_render_view_ready(&self, browser: interfaces::CefBrowser) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_render_view_ready.unwrap())(
          self.c_object,
          CefWrap::to_c(browser)))
    }
  }

  //
  // Called on the browser process UI thread when the render process terminates
  // unexpectedly. |status| indicates how the process terminated.
  //
  pub fn on_render_process_terminated(&self, browser: interfaces::CefBrowser,
      status: types::cef_termination_status_t) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_render_process_terminated.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(status)))
    }
  }
} 

impl CefWrap<*mut cef_request_handler_t> for CefRequestHandler {
  fn to_c(rust_object: CefRequestHandler) -> *mut cef_request_handler_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_request_handler_t) -> CefRequestHandler {
    CefRequestHandler::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_request_handler_t> for Option<CefRequestHandler> {
  fn to_c(rust_object: Option<CefRequestHandler>) -> *mut cef_request_handler_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_request_handler_t) -> Option<CefRequestHandler> {
    if c_object.is_null() {
      None
    } else {
      Some(CefRequestHandler::from_c_object_addref(c_object))
    }
  }
}

