# `bindgen`

**`bindgen` automatically generates Rust FFI bindings to C and C++ libraries.**

For example, given the C header `cool.h`:

```c
typedef struct CoolStruct {
    int x;
    int y;
} CoolStruct;

void cool_function(int i, char c, CoolStruct* cs);
```

`bindgen` produces Rust FFI code allowing you to call into the `cool` library's
functions and use its types:

```rust
/* automatically generated by rust-bindgen */

#[repr(C)]
pub struct CoolStruct {
    pub x: ::std::os::raw::c_int,
    pub y: ::std::os::raw::c_int,
}

extern "C" {
    pub fn cool_function(i: ::std::os::raw::c_int,
                         c: ::std::os::raw::c_char,
                         cs: *mut CoolStruct);
}
```

## Users Guide

[📚 Read the `bindgen` users guide here! 📚](https://servo.github.io/rust-bindgen)

## API Reference

[API reference documentation is on docs.rs](https://docs.rs/bindgen)

## Contributing

[See `CONTRIBUTING.md` for hacking on `bindgen`!](./CONTRIBUTING.md)
