/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_PostMessageEvent_h
#define mozilla_dom_PostMessageEvent_h

#include "mozilla/dom/StructuredCloneHolder.h"
#include "nsCOMPtr.h"
#include "mozilla/RefPtr.h"
#include "nsTArray.h"
#include "nsThreadUtils.h"

class nsGlobalWindowOuter;
class nsGlobalWindowInner;
class nsIDocument;
class nsIPrincipal;

namespace mozilla {
namespace dom {

/**
 * Class used to represent events generated by calls to Window.postMessage,
 * which asynchronously creates and dispatches events.
 */
class PostMessageEvent final : public Runnable
                             , public StructuredCloneHolder
{
public:
  NS_DECL_NSIRUNNABLE

  PostMessageEvent(nsGlobalWindowOuter* aSource,
                   const nsAString& aCallerOrigin,
                   nsGlobalWindowOuter* aTargetWindow,
                   nsIPrincipal* aProvidedPrincipal,
                   nsIDocument* aSourceDocument,
                   bool aTrustedCaller);

private:
  ~PostMessageEvent();

  void
  Dispatch(nsGlobalWindowInner* aTargetWindow, Event* aEvent);

  void
  DispatchError(JSContext* aCx, nsGlobalWindowInner* aTargetWindow,
                mozilla::dom::EventTarget* aEventTarget);

  RefPtr<nsGlobalWindowOuter> mSource;
  nsString mCallerOrigin;
  RefPtr<nsGlobalWindowOuter> mTargetWindow;
  nsCOMPtr<nsIPrincipal> mProvidedPrincipal;
  nsCOMPtr<nsIDocument> mSourceDocument;
  bool mTrustedCaller;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PostMessageEvent_h
