// Script from security/manager/tools/crtshToDNStruct/crtshToDNStruct.py
// Invocation: crtshToDNStruct.py 142951186 23635000 5250464 12716200 19602712 19602724 21760447 19602706 19602741

// /C=US/O=Google Inc/CN=Google Internet Authority G2
// SHA256 Fingerprint: 9B:75:9D:41:E3:DE:30:F9:D2:F9:02:02:7D:79:2B:65
//                     D9:50:A9:8B:BB:6D:6D:56:BE:7F:25:28:45:3B:F8:E9
// https://crt.sh/?id=142951186 (crt.sh ID=142951186)
//
// and
//
// /C=US/O=Google Inc/CN=Google Internet Authority G2
// SHA256 Fingerprint: 9F:63:04:26:DF:1D:8A:BF:D8:0A:CE:98:87:1B:A8:33
//                     AB:97:42:CB:34:83:8D:E2:B5:28:5E:D5:4C:0C:7D:CC
// https://crt.sh/?id=23635000 (crt.sh ID=23635000)
static const uint8_t CAGoogleInternetAuthorityG2DN[75] = {
  0x30, 0x49, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
  0x55, 0x53, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0A,
  0x47, 0x6F, 0x6F, 0x67, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x31, 0x25, 0x30,
  0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x1C, 0x47, 0x6F, 0x6F, 0x67, 0x6C,
  0x65, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x65, 0x74, 0x20, 0x41, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x47, 0x32,
};

// /CN=Apple IST CA 2 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: AC:2B:92:2E:CF:D5:E0:17:11:77:2F:EA:8E:D3:72:DE
//                     9D:1E:22:45:FC:E3:F5:7A:9C:DB:EC:77:29:6A:42:4B
// https://crt.sh/?id=5250464 (crt.sh ID=5250464)
static const uint8_t CAAppleISTCA2G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x32, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x13, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 5 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 3D:B7:6D:1D:D7:D3:A7:59:DC:CC:3F:8F:A7:F6:86:75
//                     C0:80:CB:09:5E:48:81:06:3A:6B:85:0F:DD:68:B8:BC
// https://crt.sh/?id=12716200 (crt.sh ID=12716200)
static const uint8_t CAAppleISTCA5G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x35, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x13, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 4 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 61:15:F0:6A:33:8A:64:9E:61:58:52:10:E7:6F:2E:CE
//                     39:89:BC:A6:5A:62:B0:66:04:0C:D7:C5:F4:08:ED:D0
// https://crt.sh/?id=19602712 (crt.sh ID=19602712)
static const uint8_t CAAppleISTCA4G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x34, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x0C, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 7 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 17:F9:66:09:AC:6A:D0:A2:D6:AB:0A:21:B2:D1:B5:B2
//                     94:6B:D0:4D:BF:12:07:03:D1:DE:F6:FB:62:F4:B6:61
// https://crt.sh/?id=19602724 (crt.sh ID=19602724)
static const uint8_t CAAppleISTCA7G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x37, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x0C, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 8 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: A4:FE:7C:7F:15:15:5F:3F:0A:EF:7A:AA:83:CF:6E:06
//                     DE:B9:7C:A3:F9:09:DF:92:0A:C1:49:08:82:D4:88:ED
// https://crt.sh/?id=21760447 (crt.sh ID=21760447)
static const uint8_t CAAppleISTCA8G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x38, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x0C, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 3 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 6D:E9:09:78:91:04:22:A8:9E:26:F2:DF:85:97:14:30
//                     C3:F4:4C:D1:78:5D:AD:94:30:8F:7C:A4:B6:FB:E5:21
// https://crt.sh/?id=19602706 (crt.sh ID=19602706)
static const uint8_t CAAppleISTCA3G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x33, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x0C, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

// /CN=Apple IST CA 6 - G1/OU=Certification Authority/O=Apple Inc./C=US
// SHA256 Fingerprint: 90:4F:B5:A4:37:75:4B:1B:32:B8:0E:BA:E7:41:6D:B6
//                     3D:05:F5:6A:99:39:72:0B:7C:8E:3D:CC:54:F6:A3:D1
// https://crt.sh/?id=19602741 (crt.sh ID=19602741)
static const uint8_t CAAppleISTCA6G1DN[100] = {
  0x30, 0x62, 0x31, 0x1C, 0x30, 0x1A, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x13,
  0x41, 0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x53, 0x54, 0x20, 0x43, 0x41, 0x20,
  0x36, 0x20, 0x2D, 0x20, 0x47, 0x31, 0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55,
  0x04, 0x0B, 0x0C, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74,
  0x79, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x41,
  0x70, 0x70, 0x6C, 0x65, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x31, 0x0B, 0x30, 0x09,
  0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
};

static const DataAndLength RootAppleAndGoogleDNs[]= {
  { CAGoogleInternetAuthorityG2DN,
    sizeof(CAGoogleInternetAuthorityG2DN) },
  { CAAppleISTCA2G1DN,
    sizeof(CAAppleISTCA2G1DN) },
  { CAAppleISTCA5G1DN,
    sizeof(CAAppleISTCA5G1DN) },
  { CAAppleISTCA4G1DN,
    sizeof(CAAppleISTCA4G1DN) },
  { CAAppleISTCA7G1DN,
    sizeof(CAAppleISTCA7G1DN) },
  { CAAppleISTCA8G1DN,
    sizeof(CAAppleISTCA8G1DN) },
  { CAAppleISTCA3G1DN,
    sizeof(CAAppleISTCA3G1DN) },
  { CAAppleISTCA6G1DN,
    sizeof(CAAppleISTCA6G1DN) },
};
