// Script from security/manager/tools/crtshToDNStruct/crtshToDNStruct.py
// Invocation: crtshToDNStruct.py 17 3381895 847444 4350 4174851 4175126 12729019 8983600 12726040 8983601 30 3382830 254193 8984570 68409 26682 2771491 93 1039083

// /C=US/O=GeoTrust Inc./CN=GeoTrust Global CA
// SHA256 Fingerprint: FF:85:6A:2D:25:1D:CD:88:D3:66:56:F4:50:12:67:98
//                     CF:AB:AA:DE:40:79:9C:72:2D:E4:D2:B5:DB:36:A7:3A
// https://crt.sh/?id=17 (crt.sh ID=17)
static const uint8_t CAGeoTrustGlobalCADN[68] = {
  0x30, 0x42, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
  0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0D,
  0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x1B, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x12, 0x47, 0x65,
  0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x47, 0x6C, 0x6F, 0x62, 0x61, 0x6C,
  0x20, 0x43, 0x41,
};

// /C=US/O=GeoTrust Inc./OU=(c) 2007 GeoTrust Inc. - For authorized use only/CN=GeoTrust Primary Certification Authority - G2
// SHA256 Fingerprint: 5E:DB:7A:C4:3B:82:A0:6A:87:61:E8:D7:BE:49:79:EB
//                     F2:61:1F:7D:D7:9B:F9:1C:1C:6B:56:6A:21:9E:D7:66
// https://crt.sh/?id=3381895 (crt.sh ID=3381895)
static const uint8_t CAGeoTrustPrimaryCertificationAuthorityG2DN[155] = {
  0x30, 0x81, 0x98, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0D, 0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63,
  0x2E, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x30, 0x28,
  0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x37, 0x20, 0x47, 0x65, 0x6F, 0x54, 0x72,
  0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F,
  0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20,
  0x75, 0x73, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x36, 0x30, 0x34, 0x06,
  0x03, 0x55, 0x04, 0x03, 0x13, 0x2D, 0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x32,
};

// /C=US/O=GeoTrust Inc./OU=(c) 2008 GeoTrust Inc. - For authorized use only/CN=GeoTrust Primary Certification Authority - G3
// SHA256 Fingerprint: B4:78:B8:12:25:0D:F8:78:63:5C:2A:A7:EC:7D:15:5E
//                     AA:62:5E:E8:29:16:E2:CD:29:43:61:88:6C:D1:FB:D4
// https://crt.sh/?id=847444 (crt.sh ID=847444)
static const uint8_t CAGeoTrustPrimaryCertificationAuthorityG3DN[155] = {
  0x30, 0x81, 0x98, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0D, 0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63,
  0x2E, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x30, 0x28,
  0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x47, 0x65, 0x6F, 0x54, 0x72,
  0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F,
  0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20,
  0x75, 0x73, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x36, 0x30, 0x34, 0x06,
  0x03, 0x55, 0x04, 0x03, 0x13, 0x2D, 0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=GeoTrust Inc./CN=GeoTrust Primary Certification Authority
// SHA256 Fingerprint: 37:D5:10:06:C5:12:EA:AB:62:64:21:F1:EC:8C:92:01
//                     3F:C5:F8:2A:E9:8E:E5:33:EB:46:19:B8:DE:B4:D0:6C
// https://crt.sh/?id=4350 (crt.sh ID=4350)
static const uint8_t CAGeoTrustPrimaryCertificationAuthorityDN[90] = {
  0x30, 0x58, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
  0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0D,
  0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x31, 0x30, 0x2F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x28, 0x47, 0x65,
  0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72,
  0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
  0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79,
};

// /C=US/O=GeoTrust Inc./CN=GeoTrust Universal CA
// SHA256 Fingerprint: A0:45:9B:9F:63:B2:25:59:F5:FA:5D:4C:6D:B3:F9:F7
//                     2F:F1:93:42:03:35:78:F0:73:BF:1D:1B:46:CB:B9:12
// https://crt.sh/?id=4174851 (crt.sh ID=4174851)
static const uint8_t CAGeoTrustUniversalCADN[71] = {
  0x30, 0x45, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
  0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0D,
  0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x1E, 0x30, 0x1C, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x15, 0x47, 0x65,
  0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x55, 0x6E, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x61, 0x6C, 0x20, 0x43, 0x41,
};

// /C=US/O=GeoTrust Inc./CN=GeoTrust Universal CA 2
// SHA256 Fingerprint: A0:23:4F:3B:C8:52:7C:A5:62:8E:EC:81:AD:5D:69:89
//                     5D:A5:68:0D:C9:1D:1C:B8:47:7F:33:F8:78:B9:5B:0B
// https://crt.sh/?id=4175126 (crt.sh ID=4175126)
static const uint8_t CAGeoTrustUniversalCA2DN[73] = {
  0x30, 0x47, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
  0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13, 0x0D,
  0x47, 0x65, 0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x20, 0x30, 0x1E, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x17, 0x47, 0x65,
  0x6F, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x55, 0x6E, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x61, 0x6C, 0x20, 0x43, 0x41, 0x20, 0x32,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G4
// SHA256 Fingerprint: 36:3F:3C:84:9E:AB:03:B0:A2:A0:F6:36:D7:B8:6D:04
//                     D3:AC:7F:CF:E2:6A:0A:91:21:AB:97:95:F6:E1:76:DF
// https://crt.sh/?id=12729019 (crt.sh ID=12729019)
static const uint8_t CASymantecClass1PublicPrimaryCertificationAuthorityG4DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x34,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G6
// SHA256 Fingerprint: 9D:19:0B:2E:31:45:66:68:5B:E8:A8:89:E2:7A:A8:C7
//                     D7:AE:1D:8A:AD:DB:A3:C1:EC:F9:D2:48:63:CD:34:B9
// https://crt.sh/?id=8983600 (crt.sh ID=8983600)
static const uint8_t CASymantecClass1PublicPrimaryCertificationAuthorityG6DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x36,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G4
// SHA256 Fingerprint: FE:86:3D:08:22:FE:7A:23:53:FA:48:4D:59:24:E8:75
//                     65:6D:3D:C9:FB:58:77:1F:6F:61:6F:9D:57:1B:C5:92
// https://crt.sh/?id=12726040 (crt.sh ID=12726040)
static const uint8_t CASymantecClass2PublicPrimaryCertificationAuthorityG4DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x34,
};

// /C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G6
// SHA256 Fingerprint: CB:62:7D:18:B5:8A:D5:6D:DE:33:1A:30:45:6B:C6:5C
//                     60:1A:4E:9B:18:DE:DC:EA:08:E7:DA:AA:07:81:5F:F0
// https://crt.sh/?id=8983601 (crt.sh ID=8983601)
static const uint8_t CASymantecClass2PublicPrimaryCertificationAuthorityG6DN[151] = {
  0x30, 0x81, 0x94, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x14, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6F, 0x72,
  0x70, 0x6F, 0x72, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x31, 0x1F, 0x30, 0x1D, 0x06,
  0x03, 0x55, 0x04, 0x0B, 0x13, 0x16, 0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65,
  0x63, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
  0x72, 0x6B, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3C,
  0x53, 0x79, 0x6D, 0x61, 0x6E, 0x74, 0x65, 0x63, 0x20, 0x43, 0x6C, 0x61, 0x73,
  0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x36,
};

// /C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2006 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA
// SHA256 Fingerprint: 8D:72:2F:81:A9:C1:13:C0:79:1D:F1:36:A2:96:6D:B2
//                     6C:95:0A:97:1D:B4:6B:41:99:F4:EA:54:B7:8B:FB:9F
// https://crt.sh/?id=30 (crt.sh ID=30)
static const uint8_t CAthawtePrimaryRootCADN[172] = {
  0x30, 0x81, 0xA9, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0C, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x1F, 0x43, 0x65,
  0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53,
  0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x44, 0x69, 0x76, 0x69, 0x73,
  0x69, 0x6F, 0x6E, 0x31, 0x38, 0x30, 0x36, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13,
  0x2F, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x36, 0x20, 0x74, 0x68, 0x61,
  0x77, 0x74, 0x65, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46,
  0x6F, 0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64,
  0x20, 0x75, 0x73, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x1F, 0x30, 0x1D,
  0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x16, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65,
  0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x52, 0x6F, 0x6F, 0x74,
  0x20, 0x43, 0x41,
};

// /C=US/O=thawte, Inc./OU=(c) 2007 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA - G2
// SHA256 Fingerprint: A4:31:0D:50:AF:18:A6:44:71:90:37:2A:86:AF:AF:8B
//                     95:1F:FB:43:1D:83:7F:1E:56:88:B4:59:71:ED:15:57
// https://crt.sh/?id=3382830 (crt.sh ID=3382830)
static const uint8_t CAthawtePrimaryRootCAG2DN[135] = {
  0x30, 0x81, 0x84, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0C, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x38, 0x30, 0x36, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x2F, 0x28, 0x63,
  0x29, 0x20, 0x32, 0x30, 0x30, 0x37, 0x20, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65,
  0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20,
  0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73,
  0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55,
  0x04, 0x03, 0x13, 0x1B, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x20, 0x50, 0x72,
  0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x43, 0x41,
  0x20, 0x2D, 0x20, 0x47, 0x32,
};

// /C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2008 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA - G3
// SHA256 Fingerprint: 4B:03:F4:58:07:AD:70:F2:1B:FC:2C:AE:71:C9:FD:E4
//                     60:4C:06:4C:F5:FF:B6:86:BA:E5:DB:AA:D7:FD:D3:4C
// https://crt.sh/?id=254193 (crt.sh ID=254193)
static const uint8_t CAthawtePrimaryRootCAG3DN[177] = {
  0x30, 0x81, 0xAE, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0C, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E,
  0x31, 0x28, 0x30, 0x26, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x1F, 0x43, 0x65,
  0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53,
  0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x44, 0x69, 0x76, 0x69, 0x73,
  0x69, 0x6F, 0x6E, 0x31, 0x38, 0x30, 0x36, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13,
  0x2F, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x74, 0x68, 0x61,
  0x77, 0x74, 0x65, 0x2C, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46,
  0x6F, 0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64,
  0x20, 0x75, 0x73, 0x65, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x24, 0x30, 0x22,
  0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x1B, 0x74, 0x68, 0x61, 0x77, 0x74, 0x65,
  0x20, 0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x52, 0x6F, 0x6F, 0x74,
  0x20, 0x43, 0x41, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 1 Public Primary Certification Authority - G3
// SHA256 Fingerprint: CB:B5:AF:18:5E:94:2A:24:02:F9:EA:CB:C0:ED:5B:B8
//                     76:EE:A3:C1:22:36:23:D0:04:47:E4:F3:BA:55:4B:65
// https://crt.sh/?id=8984570 (crt.sh ID=8984570)
static const uint8_t CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 2 Public Primary Certification Authority - G3
// SHA256 Fingerprint: 92:A9:D9:83:3F:E1:94:4D:B3:66:E8:BF:AE:7A:95:B6
//                     48:0C:2D:6C:6C:2A:1B:E6:5D:42:36:B6:08:FC:A1:BB
// https://crt.sh/?id=68409 (crt.sh ID=68409)
static const uint8_t CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G3
// SHA256 Fingerprint: EB:04:CF:5E:B1:F3:9A:FA:76:2F:2B:B1:20:F2:96:CB
//                     A5:20:C1:B9:7D:B1:58:95:65:B8:1C:B9:A1:7B:72:44
// https://crt.sh/?id=26682 (crt.sh ID=26682)
static const uint8_t CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
  0x39, 0x39, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x33,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2007 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G4
// SHA256 Fingerprint: 69:DD:D7:EA:90:BB:57:C9:3E:13:5D:C8:5E:A6:FC:D5
//                     48:0B:60:32:39:BD:C4:54:FC:75:8B:2A:26:CF:7F:79
// https://crt.sh/?id=2771491 (crt.sh ID=2771491)
static const uint8_t CAVeriSignClass3PublicPrimaryCertificationAuthorityG4DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30,
  0x30, 0x37, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x34,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2006 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G5
// SHA256 Fingerprint: 9A:CF:AB:7E:43:C8:D8:80:D0:6B:26:2A:94:DE:EE:E4
//                     B4:65:99:89:C3:D0:CA:F1:9B:AF:64:05:E4:1A:B7:DF
// https://crt.sh/?id=93 (crt.sh ID=93)
static const uint8_t CAVeriSignClass3PublicPrimaryCertificationAuthorityG5DN[205] = {
  0x30, 0x81, 0xCA, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30,
  0x30, 0x36, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x3C, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x43, 0x6C,
  0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20,
  0x50, 0x72, 0x69, 0x6D, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x41, 0x75, 0x74, 0x68,
  0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2D, 0x20, 0x47, 0x35,
};

// /C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2008 VeriSign, Inc. - For authorized use only/CN=VeriSign Universal Root Certification Authority
// SHA256 Fingerprint: 23:99:56:11:27:A5:71:25:DE:8C:EF:EA:61:0D:DF:2F
//                     A0:78:B5:C8:06:7F:4E:82:82:90:BF:B8:60:E8:4B:3C
// https://crt.sh/?id=1039083 (crt.sh ID=1039083)
static const uint8_t CAVeriSignUniversalRootCertificationAuthorityDN[192] = {
  0x30, 0x81, 0xBD, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
  0x02, 0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x13,
  0x0E, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x49, 0x6E,
  0x63, 0x2E, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x16,
  0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x54, 0x72, 0x75, 0x73,
  0x74, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x31, 0x3A, 0x30, 0x38,
  0x06, 0x03, 0x55, 0x04, 0x0B, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30,
  0x30, 0x38, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20,
  0x49, 0x6E, 0x63, 0x2E, 0x20, 0x2D, 0x20, 0x46, 0x6F, 0x72, 0x20, 0x61, 0x75,
  0x74, 0x68, 0x6F, 0x72, 0x69, 0x7A, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6F, 0x6E, 0x6C, 0x79, 0x31, 0x38, 0x30, 0x36, 0x06, 0x03, 0x55, 0x04, 0x03,
  0x13, 0x2F, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6E, 0x20, 0x55, 0x6E,
  0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x6C, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20,
  0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E,
  0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79,
};

static const DataAndLength RootSymantecDNs[]= {
  { CAGeoTrustGlobalCADN,
    sizeof(CAGeoTrustGlobalCADN) },
  { CAGeoTrustPrimaryCertificationAuthorityG2DN,
    sizeof(CAGeoTrustPrimaryCertificationAuthorityG2DN) },
  { CAGeoTrustPrimaryCertificationAuthorityG3DN,
    sizeof(CAGeoTrustPrimaryCertificationAuthorityG3DN) },
  { CAGeoTrustPrimaryCertificationAuthorityDN,
    sizeof(CAGeoTrustPrimaryCertificationAuthorityDN) },
  { CAGeoTrustUniversalCADN,
    sizeof(CAGeoTrustUniversalCADN) },
  { CAGeoTrustUniversalCA2DN,
    sizeof(CAGeoTrustUniversalCA2DN) },
  { CASymantecClass1PublicPrimaryCertificationAuthorityG4DN,
    sizeof(CASymantecClass1PublicPrimaryCertificationAuthorityG4DN) },
  { CASymantecClass1PublicPrimaryCertificationAuthorityG6DN,
    sizeof(CASymantecClass1PublicPrimaryCertificationAuthorityG6DN) },
  { CASymantecClass2PublicPrimaryCertificationAuthorityG4DN,
    sizeof(CASymantecClass2PublicPrimaryCertificationAuthorityG4DN) },
  { CASymantecClass2PublicPrimaryCertificationAuthorityG6DN,
    sizeof(CASymantecClass2PublicPrimaryCertificationAuthorityG6DN) },
  { CAthawtePrimaryRootCADN,
    sizeof(CAthawtePrimaryRootCADN) },
  { CAthawtePrimaryRootCAG2DN,
    sizeof(CAthawtePrimaryRootCAG2DN) },
  { CAthawtePrimaryRootCAG3DN,
    sizeof(CAthawtePrimaryRootCAG3DN) },
  { CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass1PublicPrimaryCertificationAuthorityG3DN) },
  { CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass2PublicPrimaryCertificationAuthorityG3DN) },
  { CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN,
    sizeof(CAVeriSignClass3PublicPrimaryCertificationAuthorityG3DN) },
  { CAVeriSignClass3PublicPrimaryCertificationAuthorityG4DN,
    sizeof(CAVeriSignClass3PublicPrimaryCertificationAuthorityG4DN) },
  { CAVeriSignClass3PublicPrimaryCertificationAuthorityG5DN,
    sizeof(CAVeriSignClass3PublicPrimaryCertificationAuthorityG5DN) },
  { CAVeriSignUniversalRootCertificationAuthorityDN,
    sizeof(CAVeriSignUniversalRootCertificationAuthorityDN) },
};
