// Copyright (c) 2015 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not be edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#![allow(non_snake_case, unused_imports)]

use eutil;
use interfaces;
use types;
use wrappers::CefWrap;

use libc;
use std::collections::HashMap;
use std::mem;
use std::ptr;

//
// Callback structure for asynchronous continuation of file dialog requests.
//
#[repr(C)]
pub struct _cef_file_dialog_callback_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Continue the file selection. |selected_accept_filter| should be the 0-based
  // index of the value selected from the accept filters array passed to
  // cef_dialog_handler_t::OnFileDialog. |file_paths| should be a single value
  // or a list of values depending on the dialog mode. An NULL |file_paths|
  // value is treated the same as calling cancel().
  //
  pub cont: Option<extern "C" fn(this: *mut cef_file_dialog_callback_t,
      selected_accept_filter: libc::c_int,
      file_paths: &types::cef_string_list_t) -> ()>,

  //
  // Cancel the file selection.
  //
  pub cancel: Option<extern "C" fn(this: *mut cef_file_dialog_callback_t) -> (
      )>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_file_dialog_callback_t = _cef_file_dialog_callback_t;


//
// Callback structure for asynchronous continuation of file dialog requests.
//
pub struct CefFileDialogCallback {
  c_object: *mut cef_file_dialog_callback_t,
}

impl Clone for CefFileDialogCallback {
  fn clone(&self) -> CefFileDialogCallback{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefFileDialogCallback {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefFileDialogCallback {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefFileDialogCallback {
  pub unsafe fn from_c_object(c_object: *mut cef_file_dialog_callback_t) -> CefFileDialogCallback {
    CefFileDialogCallback {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_file_dialog_callback_t) -> CefFileDialogCallback {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefFileDialogCallback {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_file_dialog_callback_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_file_dialog_callback_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Continue the file selection. |selected_accept_filter| should be the 0-based
  // index of the value selected from the accept filters array passed to
  // cef_dialog_handler_t::OnFileDialog. |file_paths| should be a single value
  // or a list of values depending on the dialog mode. An NULL |file_paths|
  // value is treated the same as calling cancel().
  //
  pub fn cont(&self, selected_accept_filter: libc::c_int,
      file_paths: &Vec<String>) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).cont.unwrap())(
          self.c_object,
          CefWrap::to_c(selected_accept_filter),
          CefWrap::to_c(file_paths)))
    }
  }

  //
  // Cancel the file selection.
  //
  pub fn cancel(&self) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).cancel.unwrap())(
          self.c_object))
    }
  }
} 

impl CefWrap<*mut cef_file_dialog_callback_t> for CefFileDialogCallback {
  fn to_c(rust_object: CefFileDialogCallback) -> *mut cef_file_dialog_callback_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_file_dialog_callback_t) -> CefFileDialogCallback {
    CefFileDialogCallback::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_file_dialog_callback_t> for Option<CefFileDialogCallback> {
  fn to_c(rust_object: Option<CefFileDialogCallback>) -> *mut cef_file_dialog_callback_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_file_dialog_callback_t) -> Option<CefFileDialogCallback> {
    if c_object.is_null() {
      None
    } else {
      Some(CefFileDialogCallback::from_c_object_addref(c_object))
    }
  }
}


//
// Implement this structure to handle dialog events. The functions of this
// structure will be called on the browser process UI thread.
//
#[repr(C)]
pub struct _cef_dialog_handler_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Called to run a file chooser dialog. |mode| represents the type of dialog
  // to display. |title| to the title to be used for the dialog and may be NULL
  // to show the default title ("Open" or "Save" depending on the mode).
  // |default_file_path| is the path with optional directory and/or file name
  // component that should be initially selected in the dialog. |accept_filters|
  // are used to restrict the selectable file types and may any combination of
  // (a) valid lower-cased MIME types (e.g. "text/*" or "image/*"), (b)
  // individual file extensions (e.g. ".txt" or ".png"), or (c) combined
  // description and file extension delimited using "|" and ";" (e.g. "Image
  // Types|.png;.gif;.jpg"). |selected_accept_filter| is the 0-based index of
  // the filter that should be selected by default. To display a custom dialog
  // return true (1) and execute |callback| either inline or at a later time. To
  // display the default dialog return false (0).
  //
  pub on_file_dialog: Option<extern "C" fn(this: *mut cef_dialog_handler_t,
      browser: *mut interfaces::cef_browser_t,
      mode: types::cef_file_dialog_mode_t, title: *const types::cef_string_t,
      default_file_path: *const types::cef_string_t,
      accept_filters: &types::cef_string_list_t,
      selected_accept_filter: libc::c_int,
      callback: *mut interfaces::cef_file_dialog_callback_t) -> libc::c_int>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_dialog_handler_t = _cef_dialog_handler_t;


//
// Implement this structure to handle dialog events. The functions of this
// structure will be called on the browser process UI thread.
//
pub struct CefDialogHandler {
  c_object: *mut cef_dialog_handler_t,
}

impl Clone for CefDialogHandler {
  fn clone(&self) -> CefDialogHandler{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefDialogHandler {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefDialogHandler {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefDialogHandler {
  pub unsafe fn from_c_object(c_object: *mut cef_dialog_handler_t) -> CefDialogHandler {
    CefDialogHandler {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_dialog_handler_t) -> CefDialogHandler {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefDialogHandler {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_dialog_handler_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_dialog_handler_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Called to run a file chooser dialog. |mode| represents the type of dialog
  // to display. |title| to the title to be used for the dialog and may be NULL
  // to show the default title ("Open" or "Save" depending on the mode).
  // |default_file_path| is the path with optional directory and/or file name
  // component that should be initially selected in the dialog. |accept_filters|
  // are used to restrict the selectable file types and may any combination of
  // (a) valid lower-cased MIME types (e.g. "text/*" or "image/*"), (b)
  // individual file extensions (e.g. ".txt" or ".png"), or (c) combined
  // description and file extension delimited using "|" and ";" (e.g. "Image
  // Types|.png;.gif;.jpg"). |selected_accept_filter| is the 0-based index of
  // the filter that should be selected by default. To display a custom dialog
  // return true (1) and execute |callback| either inline or at a later time. To
  // display the default dialog return false (0).
  //
  pub fn on_file_dialog(&self, browser: interfaces::CefBrowser,
      mode: types::cef_file_dialog_mode_t, title: &[u16],
      default_file_path: &[u16], accept_filters: &Vec<String>,
      selected_accept_filter: libc::c_int,
      callback: interfaces::CefFileDialogCallback) -> libc::c_int {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).on_file_dialog.unwrap())(
          self.c_object,
          CefWrap::to_c(browser),
          CefWrap::to_c(mode),
          CefWrap::to_c(title),
          CefWrap::to_c(default_file_path),
          CefWrap::to_c(accept_filters),
          CefWrap::to_c(selected_accept_filter),
          CefWrap::to_c(callback)))
    }
  }
} 

impl CefWrap<*mut cef_dialog_handler_t> for CefDialogHandler {
  fn to_c(rust_object: CefDialogHandler) -> *mut cef_dialog_handler_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_dialog_handler_t) -> CefDialogHandler {
    CefDialogHandler::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_dialog_handler_t> for Option<CefDialogHandler> {
  fn to_c(rust_object: Option<CefDialogHandler>) -> *mut cef_dialog_handler_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_dialog_handler_t) -> Option<CefDialogHandler> {
    if c_object.is_null() {
      None
    } else {
      Some(CefDialogHandler::from_c_object_addref(c_object))
    }
  }
}

