// Copyright (c) 2015 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not be edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//

#![allow(non_snake_case, unused_imports)]

use eutil;
use interfaces;
use types;
use wrappers::CefWrap;

use libc;
use std::collections::HashMap;
use std::mem;
use std::ptr;

//
// Structure representing the issuer or subject field of an X.509 certificate.
//
#[repr(C)]
pub struct _cef_sslcert_principal_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Returns a name that can be used to represent the issuer.  It tries in this
  // order: CN, O and OU and returns the first non-NULL one found.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_display_name: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t) -> types::cef_string_userfree_t>,

  //
  // Returns the common name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_common_name: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t) -> types::cef_string_userfree_t>,

  //
  // Returns the locality name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_locality_name: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t) -> types::cef_string_userfree_t>,

  //
  // Returns the state or province name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_state_or_province_name: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t) -> types::cef_string_userfree_t>,

  //
  // Returns the country name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub get_country_name: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t) -> types::cef_string_userfree_t>,

  //
  // Retrieve the list of street addresses.
  //
  pub get_street_addresses: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t,
      addresses: &types::cef_string_list_t) -> ()>,

  //
  // Retrieve the list of organization names.
  //
  pub get_organization_names: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t, names: &types::cef_string_list_t) -> (
      )>,

  //
  // Retrieve the list of organization unit names.
  //
  pub get_organization_unit_names: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t, names: &types::cef_string_list_t) -> (
      )>,

  //
  // Retrieve the list of domain components.
  //
  pub get_domain_components: Option<extern "C" fn(
      this: *mut cef_sslcert_principal_t,
      components: &types::cef_string_list_t) -> ()>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_sslcert_principal_t = _cef_sslcert_principal_t;


//
// Structure representing the issuer or subject field of an X.509 certificate.
//
pub struct CefSSLCertPrincipal {
  c_object: *mut cef_sslcert_principal_t,
}

impl Clone for CefSSLCertPrincipal {
  fn clone(&self) -> CefSSLCertPrincipal{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefSSLCertPrincipal {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefSSLCertPrincipal {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefSSLCertPrincipal {
  pub unsafe fn from_c_object(c_object: *mut cef_sslcert_principal_t) -> CefSSLCertPrincipal {
    CefSSLCertPrincipal {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_sslcert_principal_t) -> CefSSLCertPrincipal {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefSSLCertPrincipal {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_sslcert_principal_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_sslcert_principal_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Returns a name that can be used to represent the issuer.  It tries in this
  // order: CN, O and OU and returns the first non-NULL one found.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_display_name(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_display_name.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the common name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_common_name(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_common_name.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the locality name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_locality_name(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_locality_name.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the state or province name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_state_or_province_name(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_state_or_province_name.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the country name.
  //
  // The resulting string must be freed by calling cef_string_userfree_free().
  pub fn get_country_name(&self) -> String {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_country_name.unwrap())(
          self.c_object))
    }
  }

  //
  // Retrieve the list of street addresses.
  //
  pub fn get_street_addresses(&self, addresses: &Vec<String>) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_street_addresses.unwrap())(
          self.c_object,
          CefWrap::to_c(addresses)))
    }
  }

  //
  // Retrieve the list of organization names.
  //
  pub fn get_organization_names(&self, names: &Vec<String>) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_organization_names.unwrap())(
          self.c_object,
          CefWrap::to_c(names)))
    }
  }

  //
  // Retrieve the list of organization unit names.
  //
  pub fn get_organization_unit_names(&self, names: &Vec<String>) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_organization_unit_names.unwrap())(
          self.c_object,
          CefWrap::to_c(names)))
    }
  }

  //
  // Retrieve the list of domain components.
  //
  pub fn get_domain_components(&self, components: &Vec<String>) -> () {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_domain_components.unwrap())(
          self.c_object,
          CefWrap::to_c(components)))
    }
  }
} 

impl CefWrap<*mut cef_sslcert_principal_t> for CefSSLCertPrincipal {
  fn to_c(rust_object: CefSSLCertPrincipal) -> *mut cef_sslcert_principal_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_sslcert_principal_t) -> CefSSLCertPrincipal {
    CefSSLCertPrincipal::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_sslcert_principal_t> for Option<CefSSLCertPrincipal> {
  fn to_c(rust_object: Option<CefSSLCertPrincipal>) -> *mut cef_sslcert_principal_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_sslcert_principal_t) -> Option<CefSSLCertPrincipal> {
    if c_object.is_null() {
      None
    } else {
      Some(CefSSLCertPrincipal::from_c_object_addref(c_object))
    }
  }
}


//
// Structure representing SSL information.
//
#[repr(C)]
pub struct _cef_sslinfo_t {
  //
  // Base structure.
  //
  pub base: types::cef_base_t,

  //
  // Returns the subject of the X.509 certificate. For HTTPS server certificates
  // this represents the web server.  The common name of the subject should
  // match the host name of the web server.
  //
  pub get_subject: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> *mut interfaces::cef_sslcert_principal_t>,

  //
  // Returns the issuer of the X.509 certificate.
  //
  pub get_issuer: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> *mut interfaces::cef_sslcert_principal_t>,

  //
  // Returns the DER encoded serial number for the X.509 certificate. The value
  // possibly includes a leading 00 byte.
  //
  pub get_serial_number: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> *mut interfaces::cef_binary_value_t>,

  //
  // Returns the date before which the X.509 certificate is invalid.
  // CefTime.GetTimeT() will return 0 if no date was specified.
  //
  pub get_valid_start: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> types::cef_time_t>,

  //
  // Returns the date after which the X.509 certificate is invalid.
  // CefTime.GetTimeT() will return 0 if no date was specified.
  //
  pub get_valid_expiry: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> types::cef_time_t>,

  //
  // Returns the DER encoded data for the X.509 certificate.
  //
  pub get_derencoded: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> *mut interfaces::cef_binary_value_t>,

  //
  // Returns the PEM encoded data for the X.509 certificate.
  //
  pub get_pemencoded: Option<extern "C" fn(
      this: *mut cef_sslinfo_t) -> *mut interfaces::cef_binary_value_t>,

  //
  // The reference count. This will only be present for Rust instances!
  //
  pub ref_count: u32,

  //
  // Extra data. This will only be present for Rust instances!
  //
  pub extra: u8,
}

pub type cef_sslinfo_t = _cef_sslinfo_t;


//
// Structure representing SSL information.
//
pub struct CefSSLInfo {
  c_object: *mut cef_sslinfo_t,
}

impl Clone for CefSSLInfo {
  fn clone(&self) -> CefSSLInfo{
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.add_ref.unwrap())(&mut (*self.c_object).base);
      }
      CefSSLInfo {
        c_object: self.c_object,
      }
    }
  }
}

impl Drop for CefSSLInfo {
  fn drop(&mut self) {
    unsafe {
      if !self.c_object.is_null() {
        ((*self.c_object).base.release.unwrap())(&mut (*self.c_object).base);
      }
    }
  }
}

impl CefSSLInfo {
  pub unsafe fn from_c_object(c_object: *mut cef_sslinfo_t) -> CefSSLInfo {
    CefSSLInfo {
      c_object: c_object,
    }
  }

  pub unsafe fn from_c_object_addref(c_object: *mut cef_sslinfo_t) -> CefSSLInfo {
    if !c_object.is_null() {
      ((*c_object).base.add_ref.unwrap())(&mut (*c_object).base);
    }
    CefSSLInfo {
      c_object: c_object,
    }
  }

  pub fn c_object(&self) -> *mut cef_sslinfo_t {
    self.c_object
  }

  pub fn c_object_addrefed(&self) -> *mut cef_sslinfo_t {
    unsafe {
      if !self.c_object.is_null() {
        eutil::add_ref(self.c_object as *mut types::cef_base_t);
      }
      self.c_object
    }
  }

  pub fn is_null_cef_object(&self) -> bool {
    self.c_object.is_null()
  }
  pub fn is_not_null_cef_object(&self) -> bool {
    !self.c_object.is_null()
  }

  //
  // Returns the subject of the X.509 certificate. For HTTPS server certificates
  // this represents the web server.  The common name of the subject should
  // match the host name of the web server.
  //
  pub fn get_subject(&self) -> interfaces::CefSSLCertPrincipal {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_subject.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the issuer of the X.509 certificate.
  //
  pub fn get_issuer(&self) -> interfaces::CefSSLCertPrincipal {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_issuer.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the DER encoded serial number for the X.509 certificate. The value
  // possibly includes a leading 00 byte.
  //
  pub fn get_serial_number(&self) -> interfaces::CefBinaryValue {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_serial_number.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the date before which the X.509 certificate is invalid.
  // CefTime.GetTimeT() will return 0 if no date was specified.
  //
  pub fn get_valid_start(&self) -> types::cef_time_t {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_valid_start.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the date after which the X.509 certificate is invalid.
  // CefTime.GetTimeT() will return 0 if no date was specified.
  //
  pub fn get_valid_expiry(&self) -> types::cef_time_t {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_valid_expiry.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the DER encoded data for the X.509 certificate.
  //
  pub fn get_derencoded(&self) -> interfaces::CefBinaryValue {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_derencoded.unwrap())(
          self.c_object))
    }
  }

  //
  // Returns the PEM encoded data for the X.509 certificate.
  //
  pub fn get_pemencoded(&self) -> interfaces::CefBinaryValue {
    if self.c_object.is_null() {
      panic!("called a CEF method on a null object")
    }
    unsafe {
      CefWrap::to_rust(
        ((*self.c_object).get_pemencoded.unwrap())(
          self.c_object))
    }
  }
} 

impl CefWrap<*mut cef_sslinfo_t> for CefSSLInfo {
  fn to_c(rust_object: CefSSLInfo) -> *mut cef_sslinfo_t {
    rust_object.c_object_addrefed()
  }
  unsafe fn to_rust(c_object: *mut cef_sslinfo_t) -> CefSSLInfo {
    CefSSLInfo::from_c_object_addref(c_object)
  }
}
impl CefWrap<*mut cef_sslinfo_t> for Option<CefSSLInfo> {
  fn to_c(rust_object: Option<CefSSLInfo>) -> *mut cef_sslinfo_t {
    match rust_object {
      None => ptr::null_mut(),
      Some(rust_object) => rust_object.c_object_addrefed(),
    }
  }
  unsafe fn to_rust(c_object: *mut cef_sslinfo_t) -> Option<CefSSLInfo> {
    if c_object.is_null() {
      None
    } else {
      Some(CefSSLInfo::from_c_object_addref(c_object))
    }
  }
}

