/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#include "av1/common/ncobmc_kernels.h"

// The kernels are only used in the experiment "ncobmc-adapt-weight", which
// blends four predictions to form a final prediction for an inter-block
// The indices of the default kernels correspond to
// 1. the index of the size of the kernels (ADAPT_OVERLAP_BLOCKS )
// 2. the interpolation modes (NCOBMC_MODE)
// 3. the prediction the kernels applies to

static int16_t default_ncobmc_krnl_0_0_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5684, 3601, 1367, 364, 1509, 2313, 4007, 5080 },
  { 3728, 2486, 827, 196, 1434, 2034, 2868, 3000 },
  { 1643, 1465, 726, 208, 890, 1386, 1242, 1293 },
  { 794, 723, 277, -237, 206, 487, 749, 896 },
  { 1176, 730, 286, 136, 281, 262, 724, 953 },
  { 2086, 1958, 783, 539, 751, 984, 1143, 1491 },
  { 2665, 2520, 1402, 1037, 939, 1223, 1593, 1937 },
  { 3451, 3172, 2350, 1291, 1069, 1916, 2672, 3223 }
};
static int16_t default_ncobmc_krnl_0_0_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5541, 8123, 10470, 11908, 11291, 10382, 8800, 6446 },
  { 3338, 5536, 7249, 8080, 7671, 6428, 5280, 3900 },
  { 1732, 3087, 3842, 4325, 4034, 2929, 2318, 1800 },
  { 744, 1217, 1559, 2215, 1957, 1352, 707, 322 },
  { 685, 1082, 1792, 2300, 1975, 1350, 738, 671 },
  { 1168, 2336, 3303, 3965, 3790, 3098, 2909, 2141 },
  { 3005, 4370, 5806, 6716, 6282, 5553, 4782, 3453 },
  { 4748, 6650, 7779, 9010, 9208, 8184, 6987, 5197 }
};
static int16_t default_ncobmc_krnl_0_0_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 6026, 4784, 2400, 1250, 1002, 2371, 3320, 5285 },
  { 8638, 6094, 3257, 1498, 1297, 3145, 5252, 7625 },
  { 10859, 7249, 3868, 1871, 1813, 3569, 6577, 8858 },
  { 11432, 8123, 4216, 1786, 2477, 4370, 6669, 9366 },
  { 11894, 8466, 4870, 1917, 2479, 4656, 7057, 9383 },
  { 11109, 7432, 3924, 1288, 2018, 3946, 6660, 9877 },
  { 10138, 6548, 2830, 461, 2087, 3810, 6170, 9255 },
  { 8613, 5163, 1658, 279, 1694, 3082, 4807, 7897 }
};
static int16_t default_ncobmc_krnl_0_0_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { -833, -80, 2193, 2907, 2623, 1359, 298, -383 },
  { 705, 2300, 5090, 6649, 6024, 4820, 3020, 1892 },
  { 2189, 4625, 7990, 10015, 9679, 8539, 6284, 4464 },
  { 3445, 6356, 10371, 12660, 11773, 10205, 8287, 5828 },
  { 2664, 6149, 9483, 12064, 11681, 10156, 7908, 5409 },
  { 2040, 4690, 8405, 10631, 9862, 8396, 5711, 2909 },
  { 626, 2993, 6387, 8212, 7123, 5840, 3877, 1788 },
  { -402, 1431, 4636, 5850, 4461, 3246, 1964, 122 }
};
static int16_t default_ncobmc_krnl_0_1_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 1465, 553, -76, 10, 635, 756, 1843, 3144 },
  { 687, 117, -404, -300, 238, 280, 696, 1415 },
  { 49, -38, -224, -241, -135, -209, -237, 382 },
  { 48, 37, -266, -273, -235, -137, -208, -94 },
  { 555, -3, -132, -172, -98, 93, 347, 313 },
  { 887, 256, -266, -307, 304, 222, -98, 82 },
  { 1701, 816, 454, 501, 119, 230, 450, 551 },
  { 2732, 1502, 1174, 540, 323, 709, 1002, 936 }
};
static int16_t default_ncobmc_krnl_0_1_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 7707, 10467, 11036, 10942, 10165, 9420, 8728, 5835 },
  { 3167, 5146, 5854, 5771, 4914, 4684, 4357, 3154 },
  { 900, 1646, 2412, 2014, 1974, 1986, 1776, 1005 },
  { -198, -179, 488, 737, 866, 784, 828, 236 },
  { -469, 32, 402, 574, 738, 495, 242, -187 },
  { 186, 1078, 1378, 1480, 1226, 1506, 1656, 745 },
  { 1531, 2525, 3139, 3367, 3535, 3519, 3095, 2171 },
  { 3152, 5453, 6176, 7089, 7310, 6879, 6483, 4916 }
};
static int16_t default_ncobmc_krnl_0_1_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 7378, 3775, 1232, 453, 133, 936, 1688, 4950 },
  { 10336, 5944, 2400, 1175, 168, 954, 2894, 6436 },
  { 11176, 6145, 2051, 829, 543, 1193, 3403, 6517 },
  { 10387, 6062, 2036, 646, 507, 1077, 2998, 6029 },
  { 10768, 6277, 2226, 677, 321, 982, 2845, 6378 },
  { 10072, 5808, 1937, 873, 372, 1396, 3498, 7298 },
  { 8951, 4724, 1216, 104, 656, 1830, 3722, 7558 },
  { 7447, 3372, 468, -135, 99, 1177, 2980, 7260 }
};
static int16_t default_ncobmc_krnl_0_1_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { -229, 1545, 4135, 4921, 5405, 5226, 4081, 2418 },
  { 2120, 5121, 8485, 9692, 11018, 10406, 8380, 5338 },
  { 4205, 8593, 12099, 13717, 13936, 13366, 11402, 8436 },
  { 6068, 10382, 14047, 15190, 15155, 14577, 12684, 10145 },
  { 5458, 10012, 13836, 15243, 15361, 14752, 12876, 9818 },
  { 5153, 9162, 13256, 14256, 14385, 13170, 11245, 8186 },
  { 4140, 8257, 11521, 12362, 12028, 10762, 9062, 6053 },
  { 2966, 5975, 8490, 8807, 8561, 7529, 5836, 3204 }
};
static int16_t default_ncobmc_krnl_1_0_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 4414, 2642, 2518, 1763, 1089, 644, 355, 254, -234, 454, 399, 228, 525, 785,
    558, 919 },
  { 2989, 3035, 2685, 1476, 1872, 768, 820, -309, -107, 273, 87, 286, 499, 638,
    929, 1025 },
  { 1779, 1672, 1713, 645, 953, 151, 617, 79, -91, 185, 18, 307, 794, 681, 484,
    521 },
  { 1429, 1571, 1893, 1493, 949, 288, -232, -248, -152, 179, -50, 74, 107, 329,
    539, 822 },
  { 1444, 852, 1022, 688, 850, 205, 135, -629, 334, 96, 106, 337, 259, 300, 150,
    680 },
  { 962, 367, 329, 921, 591, -79, 146, 201, 296, 179, -190, 143, 46, -107, 215,
    853 },
  { 915, 865, 463, 169, 498, -390, 12, 202, 225, 490, 410, 483, 52, 99, 293,
    569 },
  { 728, -135, 241, 383, 288, -69, 33, 421, 523, 506, 376, 58, 143, -4, 151,
    218 },
  { 337, 65, 255, 282, 173, 267, 237, 15, 38, 114, 253, 110, 32, 227, 92, -48 },
  { 317, 115, 295, 231, 380, 435, 331, -97, 392, 393, 51, 59, 276, 41, -33,
    46 },
  { 31, -14, 86, 250, -36, -214, 210, -79, -117, 401, 193, 440, 171, 200, 8,
    112 },
  { 46, 19, 165, -6, 75, 180, 266, -98, 76, 276, 6, 29, 230, -49, 177, 168 },
  { 104, -243, -121, 295, -8, 180, 16, -44, 232, 315, 176, 10, 0, -95, -154,
    141 },
  { 248, 201, 361, 430, -20, -45, 209, -44, 222, 540, 527, 297, 240, 625, 531,
    409 },
  { 91, 37, 193, 177, 233, 210, -299, 120, 327, 214, 293, 189, 86, 123, 206,
    356 },
  { 501, 779, 295, 199, 148, 81, -31, 70, 211, 309, 300, 110, 227, 30, 242,
    261 }
};
static int16_t default_ncobmc_krnl_1_0_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 6603, 7905, 7762, 8159, 8426, 10334, 10792, 10984, 12097, 10534, 11216,
    10624, 9514, 8715, 8672, 8846 },
  { 5897, 6238, 6272, 7323, 7162, 8091, 9465, 9845, 9929, 9747, 10562, 10737,
    9059, 7651, 7330, 7314 },
  { 5572, 6017, 5568, 7112, 6617, 6501, 7334, 8494, 8900, 8826, 9852, 8034,
    6956, 7691, 7513, 6106 },
  { 4564, 3877, 4682, 4586, 5135, 5795, 7968, 7859, 7720, 6548, 6306, 5639,
    6357, 6514, 6493, 5609 },
  { 4142, 4154, 3332, 4193, 3873, 4977, 4685, 5787, 5707, 5300, 5854, 4720,
    5452, 5642, 4810, 4250 },
  { 2993, 3176, 3012, 2637, 2664, 4336, 4207, 3687, 4627, 4487, 4847, 4120,
    4079, 3931, 3730, 3205 },
  { 2479, 2268, 1858, 1737, 2266, 2806, 2919, 3017, 3231, 2964, 3181, 3423,
    3096, 3025, 2684, 2353 },
  { 1969, 2001, 1997, 1959, 1323, 1565, 1963, 1351, 1957, 1711, 2093, 2057,
    1762, 1926, 1118, 1367 },
  { 1473, 816, 655, 1628, 1252, 1764, 1723, 1675, 2559, 3029, 1951, 2160, 2305,
    2299, 1688, 1048 },
  { 3073, 1667, 1324, 1360, 1562, 1774, 2154, 2740, 3281, 3434, 3258, 4095,
    2823, 2443, 2894, 2449 },
  { 3813, 2830, 3352, 2125, 2627, 2974, 3847, 3720, 4592, 4846, 4787, 5066,
    4598, 4229, 4032, 3478 },
  { 3415, 2733, 3827, 3637, 3381, 3743, 3768, 4732, 5055, 5445, 5870, 5937,
    5734, 5980, 5010, 4954 },
  { 4878, 3604, 5532, 4558, 4210, 4880, 4847, 5771, 5136, 6486, 7096, 6426,
    5765, 6824, 6094, 5753 },
  { 6076, 5817, 5318, 5268, 5784, 5482, 6453, 6582, 6803, 7077, 8113, 8173,
    8329, 7653, 6448, 6476 },
  { 7549, 5758, 5554, 6383, 7113, 7664, 7123, 6712, 8539, 8997, 9047, 8794,
    8700, 8760, 7600, 7995 },
  { 7698, 7133, 7048, 7498, 7821, 8401, 9152, 8647, 8934, 8874, 8595, 8789,
    8828, 8766, 9019, 8783 }
};
static int16_t default_ncobmc_krnl_1_0_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5573, 5972, 5705, 5033, 5738, 3189, 2009, 1476, 2057, 2178, 1869, 2927,
    3305, 4036, 4017, 5328 },
  { 7539, 7568, 7302, 5564, 4410, 3954, 2153, 2693, 622, 1831, 1753, 1636, 3552,
    4374, 4319, 6015 },
  { 8753, 7544, 6620, 5710, 6142, 5819, 2731, 2898, 1702, 1487, 2249, 1688,
    4110, 4483, 5108, 5621 },
  { 9273, 7922, 6245, 6310, 6442, 5272, 3068, 2649, 1599, 2693, 3219, 4501,
    4588, 4310, 5647, 6894 },
  { 9697, 8245, 7267, 6551, 5199, 4626, 3466, 3256, 2099, 3125, 3608, 4297,
    3944, 5468, 6056, 7545 },
  { 8831, 8583, 7466, 6937, 6056, 5482, 3407, 3324, 1802, 3128, 3078, 4560,
    4560, 5901, 6131, 7612 },
  { 9556, 7457, 6602, 7342, 5370, 4431, 3573, 3339, 1668, 3172, 3779, 4564,
    5744, 7244, 8522, 8407 },
  { 10238, 8809, 7064, 6643, 4885, 4246, 2737, 2684, 2501, 3443, 3761, 6174,
    5891, 6882, 7585, 8821 },
  { 10151, 10001, 8289, 6859, 6054, 4903, 3809, 3540, 2644, 3424, 3542, 4649,
    5389, 5384, 6733, 8360 },
  { 9635, 9516, 7609, 7438, 6181, 4529, 4140, 3439, 2568, 3338, 3789, 5195,
    5510, 6181, 7566, 8512 },
  { 9988, 8848, 6807, 6731, 6139, 5355, 3797, 4097, 3364, 3319, 4230, 5136,
    5581, 6125, 7748, 8229 },
  { 10252, 9244, 7204, 7260, 6478, 6040, 4659, 3920, 2869, 3263, 4068, 5475,
    5714, 7183, 7153, 8318 },
  { 9682, 9366, 7096, 6059, 6036, 4463, 3898, 3477, 2065, 2704, 4434, 5167,
    5502, 6743, 8002, 7443 },
  { 9252, 8211, 6399, 6747, 6498, 5626, 4016, 3880, 2172, 2557, 3576, 4270,
    4968, 5115, 6840, 7550 },
  { 8753, 8157, 7097, 6500, 5779, 5174, 4190, 2645, 2380, 3239, 4155, 5263,
    5437, 5337, 5663, 6667 },
  { 9680, 7710, 6921, 5657, 4863, 3990, 3485, 2172, 2620, 3003, 3328, 4112,
    4806, 6020, 6833, 7212 }
};
static int16_t default_ncobmc_krnl_1_0_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { -219, -121, 416, 1445, 1150, 2238, 3251, 3695, 2496, 3247, 2925, 2639, 3064,
    2869, 3167, 1320 },
  { -68, -450, 130, 2039, 2952, 3584, 3966, 4171, 5961, 4555, 3995, 3732, 3281,
    3731, 3827, 2052 },
  { 262, 1161, 2497, 2934, 2690, 3939, 5735, 4938, 5906, 5924, 4296, 6388, 4553,
    3551, 3297, 4164 },
  { 1091, 3025, 3566, 4005, 3874, 5040, 5600, 6151, 7241, 6990, 6924, 6186,
    5356, 5256, 3726, 3083 },
  { 1079, 3140, 4769, 4958, 6480, 6589, 8111, 7988, 8255, 7879, 6838, 7052,
    6751, 5005, 5393, 3931 },
  { 3566, 4255, 5572, 5909, 7098, 6653, 8641, 9199, 9689, 8617, 8673, 7591,
    7733, 6676, 6324, 4737 },
  { 3411, 5802, 7481, 7149, 8259, 9553, 9900, 9854, 11285, 9779, 9040, 7939,
    7515, 6037, 4902, 5075 },
  { 3417, 5718, 7095, 7425, 9913, 10666, 11679, 11951, 11429, 10749, 10173,
    8116, 8610, 7605, 7548, 5992 },
  { 4408, 5515, 7201, 7627, 8922, 9470, 10636, 11166, 11159, 9844, 10673, 9502,
    8693, 8503, 7905, 7046 },
  { 3340, 5097, 7171, 7366, 8273, 9660, 9784, 10332, 10155, 9232, 9301, 7056,
    7798, 7746, 5981, 5402 },
  { 2531, 4732, 6148, 7284, 7672, 8287, 8551, 8672, 8567, 7846, 7199, 5757,
    6057, 5863, 4613, 4578 },
  { 2646, 4394, 5195, 5511, 6471, 6443, 7713, 7854, 8408, 7427, 6461, 4968,
    4731, 3294, 4066, 2960 },
  { 1692, 3664, 3881, 5480, 6162, 6871, 7635, 7198, 8963, 6891, 4694, 4801,
    5141, 2932, 2459, 3060 },
  { 769, 2144, 4310, 3945, 4125, 5329, 5712, 5975, 7200, 6220, 4179, 3662, 2868,
    3007, 2579, 1958 },
  { -45, 2434, 3549, 3335, 3273, 3357, 5394, 6931, 5159, 3956, 2912, 2164, 2187,
    2187, 2935, 1388 },
  { -1514, 786, 2135, 3045, 3561, 3922, 3800, 5515, 4650, 4225, 4169, 3387,
    2539, 1590, 317, 161 }
};
static int16_t default_ncobmc_krnl_1_1_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 2375, 1912, 1469, 213, 933, -507, -173, -369, -333, 187, -128, 427, 999,
    1166, 1515, 2728 },
  { 1857, 1085, 817, 454, 598, 479, 53, -218, -611, 240, 76, 31, 284, 1347,
    1738, 1317 },
  { 1911, 531, 453, 89, 639, -361, -331, -605, -162, 63, -154, 259, 446, 390,
    708, 1113 },
  { 818, 1304, 871, 665, 1006, -114, -405, -407, 331, 203, 304, 506, 476, 1053,
    1155, 879 },
  { 1054, 874, 714, -162, 624, -144, -306, -541, 30, -281, 296, 812, 418, 858,
    755, 252 },
  { 967, 388, 354, 878, 31, -691, -244, -307, 425, 281, 0, -50, 110, -107, 279,
    255 },
  { 152, -53, 156, 266, 192, -864, -236, -110, 397, 484, -129, 14, 22, 44, -90,
    278 },
  { 203, -54, 103, -142, -598, -741, -546, -26, 545, 253, -43, -234, -391, -504,
    -158, -143 },
  { 387, 275, 136, 69, -289, -9, -210, -364, 39, 3, 4, 61, -66, -102, -94,
    -215 },
  { 195, 213, 433, 158, 128, -131, -203, -266, -132, -285, -301, -367, -315,
    -249, -144, -9 },
  { 600, 145, 418, 277, 156, -118, 85, -20, 119, 260, 41, 72, -85, 316, -97,
    -41 },
  { 682, 610, 356, 880, 527, 272, 90, 92, -124, 314, -204, -339, -590, -384,
    -248, -192 },
  { 999, 423, 208, 752, 623, 409, 91, -57, -3, -124, 148, 255, -7, 112, -128,
    -144 },
  { 1007, 710, 609, 766, 264, -163, 324, 291, 219, -61, 24, 507, 74, 109, 127,
    629 },
  { 2211, 878, 853, 462, 86, 203, -71, 122, -36, 131, 308, 267, 210, 369, 50,
    -96 },
  { 1810, 1630, 1123, 645, 610, 217, -93, -37, -220, -341, -250, -110, 135, 0,
    112, 93 }
};
static int16_t default_ncobmc_krnl_1_1_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5824, 7106, 8063, 8929, 8632, 9731, 10164, 11047, 11088, 10239, 10606, 8987,
    8411, 7117, 6115, 5322 },
  { 4980, 6239, 7135, 7245, 7418, 8526, 9440, 9438, 8119, 8336, 7993, 8057,
    6686, 5210, 4193, 4841 },
  { 2436, 4500, 5019, 5908, 5578, 7270, 7391, 7974, 7281, 6871, 6705, 6327,
    4867, 4521, 4286, 3605 },
  { 2298, 3501, 4714, 4692, 4835, 5278, 5830, 4968, 4435, 4824, 4373, 4085,
    3825, 2657, 2539, 2557 },
  { 1643, 2741, 2604, 2664, 1877, 3334, 2995, 3162, 3367, 3104, 3356, 2827,
    3577, 2359, 1755, 2140 },
  { 742, 1397, 1315, 1332, 1864, 3032, 2472, 2253, 1692, 2071, 2260, 2426, 1951,
    1610, 1189, 1275 },
  { 482, 869, 598, 288, 769, 1490, 1284, 1692, 883, 1061, 1259, 1239, 1118, 585,
    219, 571 },
  { 178, 278, 580, 915, 717, 873, 1012, 721, 52, 348, 624, 540, 691, 102, -108,
    383 },
  { -718, -648, -223, -520, -1000, -754, -688, -639, -528, -414, -440, -365,
    -268, -546, -672, -332 },
  { -256, -226, -395, -158, -311, -325, -66, 87, 533, 705, 261, 344, 484, 692,
    155, 507 },
  { 204, 448, 131, -571, 889, 712, 626, 349, 261, 578, 240, 1012, 849, 900, 889,
    977 },
  { 132, 1395, 1847, 1181, 845, 1203, 1920, 2068, 2141, 2071, 1834, 2191, 2130,
    2522, 1537, 1326 },
  { 140, 1278, 2440, 2063, 1581, 2204, 2781, 2532, 1677, 2426, 2538, 2210, 1568,
    2564, 2394, 1945 },
  { 2943, 3776, 3833, 3310, 3900, 4118, 4161, 3571, 4059, 4143, 4145, 4273,
    4034, 3940, 3720, 2418 },
  { 3437, 3906, 4106, 4294, 5303, 5257, 4956, 4027, 5935, 5373, 4102, 4853,
    5331, 5251, 3964, 4748 },
  { 5493, 5799, 5966, 6535, 7015, 7397, 8011, 6526, 5832, 6257, 6247, 7097,
    6499, 6272, 5963, 5593 }
};
static int16_t default_ncobmc_krnl_1_1_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 6049, 4906, 3617, 2960, 2187, 1950, 556, 497, 688, 355, 503, 1054, 1170,
    1641, 2343, 4226 },
  { 7459, 6408, 4326, 3635, 2042, 1565, 492, 572, 746, 338, 719, 797, 2540,
    2283, 2301, 4089 },
  { 8025, 6914, 5072, 4249, 2793, 1910, 430, 1137, -150, 451, 1061, 872, 1515,
    2805, 3823, 4550 },
  { 9615, 6936, 5226, 3388, 2611, 2061, 801, 1003, -537, 72, 736, 1347, 2215,
    3509, 4262, 5097 },
  { 9677, 6521, 5633, 5223, 2996, 2449, 1300, 1136, 160, 918, 488, 801, 2306,
    3781, 4818, 6441 },
  { 9988, 7509, 6019, 4950, 3376, 2777, 1427, 1395, -118, 310, 393, 1626, 3387,
    3649, 4737, 7431 },
  { 10542, 7745, 5192, 4494, 1637, 1960, 1212, 1056, -309, 383, 1166, 2107,
    4048, 4030, 7206, 7851 },
  { 9350, 7480, 4343, 3589, 1748, 1687, 1057, 898, 592, 776, 680, 1960, 3804,
    4598, 5688, 7834 },
  { 8769, 7236, 5518, 4182, 2776, 2412, 915, 1370, 789, 561, 520, 1146, 3139,
    4730, 5542, 7514 },
  { 9580, 7116, 5910, 4623, 3085, 2450, 1703, 745, 419, 600, 1077, 1208, 3256,
    4261, 5611, 6709 },
  { 9725, 7053, 5594, 4217, 2573, 1834, 562, 512, 496, 356, 883, 1360, 3323,
    4866, 5632, 7594 },
  { 10110, 7367, 5622, 3858, 3720, 2398, 1075, 1687, 616, 461, 1082, 1786, 2570,
    4242, 5731, 8319 },
  { 9416, 7582, 6054, 3915, 3283, 2035, 1335, 1138, 317, 92, 253, 483, 1715,
    3597, 5613, 8103 },
  { 8693, 6881, 4626, 3505, 2663, 1949, 751, 792, -343, 55, 303, 460, 2027,
    3584, 6230, 8704 },
  { 7368, 6609, 5087, 3861, 2790, 1746, 1487, 518, 497, -165, 439, 904, 2514,
    3735, 6082, 6914 },
  { 7004, 5321, 3472, 2621, 1221, 999, 1172, 377, 850, 864, 866, 647, 2574,
    3977, 6416, 7777 }
};
static int16_t default_ncobmc_krnl_1_1_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 2085, 2421, 3201, 4245, 4593, 5179, 5800, 5172, 4904, 5558, 5357, 5889,
    5769, 6415, 6377, 4080 },
  { 2031, 2607, 4062, 5018, 6279, 5766, 6373, 6562, 8085, 7434, 7557, 7449,
    6834, 7509, 8119, 6106 },
  { 3960, 4394, 5800, 6108, 7339, 7531, 8876, 7849, 9371, 8973, 8753, 8896,
    9525, 8636, 7540, 7092 },
  { 3599, 4610, 5527, 7597, 7898, 9121, 10115, 10783, 12123, 11248, 10928,
    10406, 9827, 9129, 8401, 7814 },
  { 3953, 6203, 7382, 8619, 10852, 10722, 12369, 12580, 12777, 12605, 12198,
    11899, 10047, 9350, 9018, 7521 },
  { 4615, 7038, 8644, 9190, 11073, 11216, 12685, 13003, 14345, 13679, 13689,
    12344, 10902, 11188, 10148, 7399 },
  { 5141, 7775, 10402, 11309, 13751, 13759, 14094, 13720, 15371, 14418, 14061,
    12988, 11166, 11692, 9019, 7665 },
  { 6591, 8644, 11320, 11985, 14476, 14526, 14816, 14745, 15159, 14966, 15071,
    14071, 12238, 12154, 10931, 8266 },
  { 7897, 9483, 10910, 12615, 14865, 14701, 16336, 15966, 16036, 16200, 16266,
    15506, 13546, 12270, 11580, 9377 },
  { 6808, 9239, 10394, 11719, 13438, 14348, 14923, 15789, 15519, 15341, 15316,
    15166, 12927, 11656, 10736, 9138 },
  { 5796, 8696, 10198, 12417, 12722, 13926, 15077, 15506, 15468, 15155, 15184,
    13906, 12262, 10270, 9924, 7815 },
  { 5386, 6960, 8500, 10429, 11262, 12474, 13263, 12505, 13713, 13502, 13632,
    12702, 12233, 9964, 9329, 6889 },
  { 5768, 7049, 7630, 9626, 10868, 11697, 12128, 12718, 14351, 13953, 13402,
    13389, 13063, 10072, 8470, 6445 },
  { 3665, 4962, 7272, 8760, 9507, 10431, 11095, 11676, 12400, 12216, 11874,
    11099, 10214, 8725, 6279, 4598 },
  { 3293, 4948, 6288, 7711, 8156, 9140, 9976, 11683, 9946, 11003, 11496, 10325,
    8287, 6988, 6251, 4796 },
  { 2010, 3599, 5789, 6548, 7490, 7725, 7264, 9488, 9893, 9573, 9487, 8725,
    7145, 6110, 3858, 2891 }
};
static int16_t default_ncobmc_krnl_2_0_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 3437, 3490, 4578, 2066,  1672, 1354, 1502, 2345, 2273, -600, 52,
    272,  484,  2214, -1553, -197, 165,  278,  306,  384,  73,   415,
    -213, 357,  497,  288,   714,  6,    -82,  -118, 170,  181 },
  { 2505,  3488, 306,   3011,  2631, 181,  636,  2608, 1663, -964, 594,
    -1455, 1057, -1198, -1647, 187,  404,  412,  177,  -32,  269,  -24,
    148,   233,  -290,  -359,  -178, -164, -362, -19,  -408, 106 },
  { 2588, 3528, 3391, 3134, 1812, 2387, -34, -298, -13,  -955, 40,
    -475, 1243, 283,  -247, -484, 200,  -46, 36,   -642, -386, -438,
    34,   295,  93,   -528, -13,  412,  -8,  41,   -457, 28 },
  { 796, 3353, 435,  3473,  458,  1851, 519,  1061, 259,  942,  416,
    195, 390,  -151, -1141, -710, 716,  -401, 33,   -771, -759, -336,
    88,  -124, -139, -372,  -223, -505, -164, -100, -512, -465 },
  { 3233,  3990, 2698, -107,  -448, 297, 331, -13, -530, -383, -464,
    -1530, 715,  -899, -1978, -879, 43,  93,  -77, -138, -425, -97,
    -167,  -348, -460, -95,   280,  -45, 235, 172, -357, -200 },
  { 868,   4162,  1417,  487,  -1446, -355, 392, -159, 202,  704,  -814,
    -3095, -1052, -1482, -745, -1403, -199, -27, -38,  -387, -208, 20,
    -64,   -130,  -265,  81,   -20,   238,  49,  121,  -137, 495 },
  { 2774, 3478, 2072, 1229, 819,  1359, 106,  -222, -1445, -1559, 924,
    -98,  44,   -347, 455,  -862, -318, -288, -31,  281,   -144,  -107,
    148,  103,  -171, -239, -134, 25,   125,  108,  -142,  -129 },
  { 610,  990,  -703,  1003,  437,  -275, -179, -233, -2041, -445, -1145,
    -488, 335,  -2684, -1339, -294, -176, -195, -36,  -65,   -276, 10,
    -111, -277, -134,  -222,  -51,  31,   -369, -279, -105,  69 },
  { 420,  2773, 375,   -372, 489,  989,  -900, 1075, 182,  119,  -529,
    -470, -504, -2225, 225,  101,  -264, -417, -253, -459, -317, -205,
    -528, -7,   -43,   -268, -116, -857, -608, -208, -216, 220 },
  { 2969, 1927, -314,  -476, 402,   -637, -838, 835,  1229, 1200, 135,
    -299, -324, -2136, 340,  -1563, -309, -98,  -408, -137, -154, 668,
    101,  -90,  245,   112,  -51,   -37,  -525, -254, -244, -126 },
  { 1404, -258, 2333,  2019,  309,   -29,  -2468, 18,   -494, 70,  -260,
    245,  515,  -1984, -1759, -1003, -504, 104,   472,  197,  -38, 265,
    378,  6,    50,    -183,  -204,  -17,  -383,  -318, -396, 142 },
  { 807,  637,  712,   1237,  -971, -176, -1160, -210, -2072, -782, -959,
    -372, -590, -1159, -1017, -889, -750, -399,  -98,  -15,   2,    -172,
    -48,  -488, -628,  -12,   -25,  136,  229,   -200, -212,  -472 },
  { -1464, 333,  -1978, -1394, -281, -1820, -124, 385,  97,   -297, -1497,
    -3,    -916, -660,  -949,  -504, 117,   11,   86,   88,   2,    219,
    333,   -120, -224,  71,    237,  -507,  13,   -381, -207, -113 },
  { 1100, -717,  -1827, -1908, -1030, -1562, 404,  794,  4,    -682, -1306,
    -612, -1197, 8,     -131,  525,   159,   -345, -91,  9,    -222, -482,
    -69,  482,   593,   -32,   -239,  -408,  -522, -692, -126, 712 },
  { -798, -735, -174, -1695, 819,   -737, -15, -426, -750, 876, 34,
    -622, 448,  -71,  -950,  -2094, 74,   170, 18,   57,   156, 443,
    -85,  -374, -416, -537,  -348,  -126, 62,  -381, 399,  -53 },
  { -552, -1352, 536,  -1,    -322, -1094, -428, 309,  -142, -752, 354,
    900,  473,   -137, -1263, -370, -731,  -864, -30,  -101, 354,  -321,
    -523, 377,   9,    -415,  -87,  -145,  -154, -286, 100,  23 },
  { 44,  607,  316,  -268, -246, -497, 267, 154, 160, 717,  324,
    240, -130, -218, -107, -252, -64,  4,   113, -57, -162, 123,
    -5,  143,  -312, -66,  -230, -33,  -57, 60,  153, 85 },
  { 158,  14,  -307, -240, -85, -416, 304, -402, -461, -221, 193,
    -123, 384, -142, 48,   -77, -378, 36,  -56,  20,   2,    -240,
    -88,  -1,  -185, 87,   6,   94,   -22, 82,   191,  194 },
  { 417,  259,  -85,  -170, -45,  -151, -402, 136, 28,   -40, 101,
    224,  -337, 97,   98,   51,   -401, 95,   -77, -153, 357, -99,
    -473, -142, -289, -80,  -349, -76,  -87,  97,  40,   198 },
  { -236, 62,  -104, -8,  98,  68,  128, 116, 47,  54,  -121,
    -150, -20, -120, 196, -80, 37,  290, 231, 247, 131, -113,
    -126, -87, 65,   250, 260, 102, -68, 234, 76,  -87 },
  { 245, 486, 38,   -10,  -135, 106, 217,  -187, -200, 96,   20,
    117, -40, -97,  68,   -139, 276, 8,    -55,  -53,  -187, -20,
    -41, 1,   -145, -246, -106, -45, -145, -353, 185,  -35 },
  { 448,  -172, -496, -63, -84, -106, 151,  9,   -143, -180, -38,
    -276, -223, 269,  100, 38,  -236, -66,  124, -59,  475,  -78,
    -407, -20,  -119, -19, 162, -4,   -226, 101, 247,  78 },
  { -348, -156, -324, -260, -173, 0,   -41,  63,  235,  -114, 109,
    -362, -96,  279,  -277, 36,   394, 394,  240, 30,   -88,  209,
    29,   176,  59,   -20,  -244, 50,  -104, 192, -157, 48 },
  { -376, -176, 269, -426, -159, -108, -18,  -163, 93,  130, -222,
    -40,  539,  176, 164,  -62,  -709, -354, 502,  664, 243, -414,
    -51,  192,  33,  54,   -10,  -57,  -141, -3,   144, 71 },
  { -137, -636, 627,  6,    -129, -159, -45, -150, -15,  402, 207,
    20,   202,  1,    -203, 88,   183,  62,  -76,  120,  418, -196,
    -104, -154, -433, -338, -73,  1,    -79, -14,  -200, 84 },
  { 184, -334, 175,  114,  -274, -60, -429, 176,  36,   373, 468,
    134, 110,  -11,  -201, -94,  352, 109,  115,  91,   187, -83,
    21,  0,    -154, -180, 288,  0,   -61,  -197, -246, 42 },
  { -143, 26,   190,  -110, -335, -385, -357, 27,   103,  -66, -96,
    -189, -337, -150, 129,  -104, -176, -418, -216, -118, 28,  126,
    -112, -130, 110,  17,   141,  111,  -82,  238,  22,   -50 },
  { 104, -95, 48,   -239, -40, -148, -327, 244,  323,  -102, 244,
    151, 113, -150, -74,  223, -81,  -328, -178, 140,  -233, -165,
    182, 514, 216,  -129, -8,  141,  -81,  451,  -110, -71 },
  { -116, 84,   -228, 177, 318, 62,   134, -3,   239,  14,  338,
    278,  -439, -254, 3,   -82, -210, -62, -236, -124, 5,   -60,
    112,  -18,  -115, -31, 5,   -65,  278, 4,    -19,  -130 },
  { 236, -64,  -147, -519, 147,  -27, 71,  -567, -133, 24, -199,
    229, -107, 126,  -141, -148, -35, -34, 68,   230,  8,  72,
    40,  -148, 203,  97,   84,   107, 32,  17,   -58,  -18 },
  { -43,  -408, -101, 120, 118, 168,  -170, -233, -323, -120, -339,
    80,   -294, -151, 85,  52,  -420, 79,   -162, -233, -237, -47,
    -131, -53,  -199, 14,  85,  -80,  93,   -150, -15,  318 },
  { -106, 107,  -6,   189, 53,  -109, 22,  -474, -335, -102, -279,
    -321, -66,  186,  -65, -13, 61,   167, 43,   -159, -57,  -13,
    37,   -125, -137, 132, 161, -156, -27, -276, -89,  15 }
};
static int16_t default_ncobmc_krnl_2_0_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5401, 5987, 4279, 6550, 4858, 4986,  5733,  7172,  8194, 7631, 7549,
    6971, 9288, 7485, 8583, 9244, 12058, 11530, 10461, 8453, 8304, 11724,
    8999, 9457, 5018, 6922, 8375, 7860,  7915,  6921,  7703, 8963 },
  { 2308, 2670,  5018,  5298, 3883, 6449,  4267,  4119, 9252, 10082, 7844,
    7414, 9050,  9261,  8739, 7808, 10974, 10279, 8627, 8840, 9203,  9406,
    9360, 10574, 10156, 7673, 6238, 8876,  6800,  6423, 6931, 8589 },
  { 6608,  4325, 3372, 5227, 6182, 3670, 5595, 5758, 8575, 8025, 8251,
    10711, 5449, 6965, 5443, 7178, 9099, 8842, 7132, 7830, 5795, 9882,
    8939,  8323, 7507, 7248, 8750, 6786, 6940, 4942, 7125, 6399 },
  { 3977, 3060, 4962, 7094, 7211, 6388, 6256, 3960, 7672, 7814, 7711,
    7237, 7088, 7232, 5716, 6040, 9565, 6643, 8113, 7841, 9849, 10144,
    8297, 7676, 6792, 8447, 7805, 5475, 5499, 4728, 5379, 7645 },
  { 4598, 4391, 3660, 6284, 6694, 8302, 5610,  5341, 7466, 6298, 6406,
    7734, 5743, 5155, 5257, 6958, 9035, 11566, 9636, 7825, 8147, 9427,
    6612, 5526, 7635, 7259, 7696, 7853, 5505,  6744, 9265, 5394 },
  { 5980, 2356, 2746, 5955, 4045, 4283, 5117, 3799, 5386, 5594, 7671,
    6984, 6232, 6028, 3101, 3391, 5757, 9530, 7408, 6206, 5512, 7867,
    5144, 8011, 6690, 6994, 4877, 5063, 6175, 5205, 1965, 859 },
  { 2619, 4096, 4225, 4712, 5637, 6418, 6649, 3904, 5463, 5102, 4785,
    4100, 5127, 3858, 3419, 5301, 6002, 7649, 8260, 6241, 4168, 4551,
    6153, 5016, 7113, 7845, 5201, 5455, 5069, 2335, 3311, 5194 },
  { 1278, 4942, 4441, 3456, 3791, 5620, 5275, 2243, 5080, 4619, 5834,
    4859, 4320, 5092, 1481, 846,  4969, 4835, 3646, 5940, 5736, 5862,
    3628, 5918, 5865, 4945, 4385, 4699, 4342, 5415, 8383, 4711 },
  { 3855, 1678, 2560, 4631, 2765, 1444, 1449, 1895, 4494, 5706, 4813,
    4882, 3532, 2264, 3222, 5444, 4097, 5236, 5036, 3713, 6547, 4371,
    5311, 2363, 5113, 6290, 3743, 5343, 5369, 2813, 2486, 1647 },
  { -651, 1098, 2116, 3495, 2289, 1836, 4507, 4057, 5225, 4553, 2631,
    2791, 2984, 3605, 3416, 3611, 4358, 4719, 3450, 4146, 3973, 3263,
    3826, 5881, 6402, 4584, 4396, 3689, 2020, 1960, 2100, 4304 },
  { -622, 1848, 379,  112,  -1474, 1013, 6023, 260,  1035, 1984, 3811,
    2362, 1394, 2546, 3347, 2472,  1865, 755,  2251, 1139, 1933, 2252,
    1163, 3003, 4091, 4792, 3801,  3517, 4247, 3798, 5216, 4543 },
  { 1342, 2229, 1014, 1212, 260,  432,  1975, 99,   2798, 818,  2455,
    3858, 2231, 3773, 136,  857,  2171, 815,  1966, 1825, 1711, 964,
    2142, 2514, 5367, 3539, 3241, 3116, 3982, 3839, 3553, 3535 },
  { 1800, 27,   321,  111,  1003, 528,  254,  979,  2444, 2413, 3807,
    961,  1961, 1173, 2156, 3935, 259,  263,  1815, 1979, 1218, 2393,
    3738, 1109, 4444, 3726, 3647, 3428, 2966, 4602, 4903, 5851 },
  { 1340, 753,  317,  1318, 738,  1880,  -500, -691, 1108, 38,   412,
    890,  494,  291,  -131, 759,  -111,  221,  -95,  2575, 3099, 3223,
    3140, 3156, 3952, 1942, 2615, -2313, 2991, 6367, 5744, 4528 },
  { 752,  490,  1255, 2396, 14,   3819, 1319,  1239, 3491, 2464, 3243,
    3083, 392,  1273, 1712, -226, -931, -2130, 710,  864,  385,  265,
    1431, 1796, 3063, 3531, 3879, 3986, 3503,  4045, 2539, 3489 },
  { 1943, 170,  358,  1884, 2344, 1566, 92,   1721, 1381, 1115, 723,
    1670, 2294, 1497, 1697, 973,  1286, 2306, 381,  2582, 2551, 3852,
    2481, 3432, 2273, 3079, 2076, 3014, 3365, 3906, 2241, 2250 },
  { 1741, -705, 595,  956, 2038, 793,  1518, 148,   -524, -881, -487,
    711,  720,  773,  431, 2181, -435, -841, -1106, -552, 434,  -2007,
    -41,  -234, -960, -23, 394,  -655, 792,  934,   1495, 1947 },
  { 2086, 1360,  97,   1352, -95,  1800, -729, -916, -152, 956,  196,
    1746, -1973, -690, 472,  1788, -28,  385,  781,  589,  -320, 1167,
    -484, 66,    1136, 1038, 1741, 888,  3056, 2114, 3495, 1297 },
  { 1900, 1373, 983,  3718, 1409,  2096, 932,  -604,  -1370, 1153, 109,
    58,   104,  2851, 602,  -2071, 252,  -888, 1428,  2724,  1344, 1567,
    563,  1902, 1370, 519,  -294,  393,  1153, -1032, 2129,  335 },
  { 2652, 2620,  3178,  2344,  2466, 2241, 1145, -101, -635, 306, -1036,
    638,  -2606, -1921, -1098, -328, -324, 2598, 1092, 1832, 493, 2507,
    1152, 1461,  -796,  2126,  -742, 1182, 2078, 1549, 2665, 2366 },
  { 1080, 798,  1934, 568,  1218, 3206, 155, 1844, 2313, 3509, 1090,
    650,  1166, 2515, 1846, 1025, 259,  720, 1587, 3010, 4955, 6457,
    2952, 2764, -396, 1937, 1563, 673,  828, 4062, 2711, 1548 },
  { 871,  657,  2761, 1756, 2349, 198,   -1003, -1105, -1181, -69,  146,
    3201, -27,  1493, 13,   291,  -2260, -468,  1178,  928,   2665, 3887,
    3140, 1334, 1969, 2687, 544,  3842,  2885,  733,   3419,  1963 },
  { 1491, 1698, 302,  2127, 1256, 907,  1607, 1833, 2061, -536, 988,
    4380, 2723, -195, 962,  1769, 2466, 1735, 2707, -369, -713, 1599,
    3031, 2924, 2023, 2045, 5259, 1733, 3517, 4274, 440,  412 },
  { 2163, 1,    167,  1755, 5694, 3272, 739,  4235, 6123,  3811, 4611,
    5800, 2424, 2409, 1458, 2152, 104,  115,  466,  -998,  -806, 2824,
    4473, 2511, 4878, 3258, 5014, 3559, 1003, 2074, -2091, 1403 },
  { 964,  1051, -1527, 1266, 3883, 2349, 1054, 1972,  1929, -249, 3796,
    2861, 1542, 449,   539,  1942, -16,  58,   2080,  56,   1106, 4248,
    580,  2540, 3095,  4536, 152,  354,  4067, -2246, 1505, 1981 },
  { 1081, 1440, 324,  736,  2839, 2597, 3712, 2282, 3717, 2483,  1247,
    4456, 3604, 3415, 2487, 3715, 2073, 2928, 2372, 828,  -2700, 2054,
    4315, -125, 1777, 2211, 2992, 7336, 4216, 3571, 2657, 6780 },
  { 1997, 2104, 1255, 1942, 1335, 1450, 3567, 1447, 3812, 6083, 5233,
    4484, 3536, 3564, 3290, 4062, 2589, 2816, 3971, 4406, 3481, 2664,
    1245, 1759, 3353, 1036, 2054, 1299, 2263, 4010, 4171, 3972 },
  { 1519, 4826, -750, 988,  1338, 2999, 212,  3858, 5202, 5306,  5717,
    3066, 2629, 6461, 6043, 6637, 8388, 7252, 4890, 4161, -1056, 4615,
    2538, 5633, 3389, 6439, 2985, 7148, 5149, 4509, 8001, 8863 },
  { 1047, 876,  2713, 3913, 2232, 1084, 1702, 2626, 1983,  3744, 2044,
    3690, 2087, 4497, 2656, 5592, 6247, 4584, 4218, 6097,  6884, 6277,
    2412, 5097, 7400, 2789, 6089, 6157, 7247, 9712, 11393, 5627 },
  { 2876, 4288, 2443, 3081, 1569, 1823, 1050, 2325,  2558, 2591, 4223,
    6300, 4237, 4354, 4411, 7502, 4175, 3350, 4208,  1100, 6473, 6664,
    5460, 4207, 5297, 8047, 6850, 6496, 7866, 10375, 7455, 2868 },
  { 3282, 5838, 6486, 6479, 3474, 4665, 3790, 2882,  5116, 4457, 4649,
    4208, 4520, 7271, 4363, 7125, 8799, 6540, 10158, 5716, 6794, 5762,
    6462, 8561, 2742, 7002, 9454, 8451, 8560, 7973,  7759, 6679 },
  { 5957, 7221, 5126, 7057, 5824, 4274,  5374,  6023, 7549, 6239, 7666,
    6368, 4014, 5338, 7150, 9793, 10608, 9838,  6748, 9691, 5465, 4631,
    7964, 7692, 8173, 9362, 8989, 11677, 10282, 9960, 6666, 9276 }
};
static int16_t default_ncobmc_krnl_2_0_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 7499, 5941, 5384,  4566, 4006, 3634, 2288, 4112, 2127,  3001, 2639,
    1927, 467,  -1639, 1484, 1143, 66,   -316, 626,  1721,  1208, 193,
    1591, 3903, 8472,  3945, 1882, 4378, 6453, 8972, 11867, 10110 },
  { 7919, 6226, 8601, 3825, 4644, 4380, 3957, 2964, 1316, 3586, 2268,
    2802, 2193, 1427, 1479, 1353, -55,  373,  271,  979,  526,  1827,
    2463, 1938, 3963, 4851, 5040, 4192, 3731, 4522, 8903, 6733 },
  { 6373, 4994, 6414, 4822, 4923, 4881, 4383, 6117, 3342, 5068, 2353,
    2370, 2231, 758,  1768, 1338, 742,  1498, 454,  1453, 1466, -213,
    177,  1223, 512,  5366, 2462, 4667, 5671, 5039, 6065, 6874 },
  { 9299, 8698, 12939, 6170, 7063, 3147, 3256, 3492, 2696, 4498, 3705,
    3176, 2797, 1099,  2852, 1331, 527,  1272, -388, 1619, 110,  -406,
    390,  3801, 4468,  3193, 2944, 7284, 7144, 4560, 6320, 8073 },
  { 5937, 4572, 5212, 6678, 5291, 2561, 2752, 4892, 2713, 5203, 4202,
    1527, -470, 2424, 2850, 1217, 401,  587,  191,  1122, 1314, 1854,
    3860, 4579, 2455, 5427, 1614, 5037, 5073, 5074, 3101, 7734 },
  { 7035, 5229, 7515, 6523, 7587, 5653, 5311, 4945, 4097, 4237, 2836,
    2667, 1959, 4095, 1669, 1484, 57,   467,  1028, 642,  2843, 2782,
    3604, -825, 1592, 4305, 2202, 4432, 4683, 3867, 3520, 9281 },
  { 7248, 3787, 4243, 4710, 3288, 1975, 2766, 4057, 1506, 2644, 1436,
    818,  1150, 2159, 787,  920,  98,   137,  1065, 306,  3880, 537,
    3871, 1060, 3821, 3395, 2484, 3532, 4072, 3339, 2638, 3982 },
  { 8810, 5802, 5538, 4090,  3659, 3742, 3818, 6827, 6474, 4756, 4093,
    3735, 4063, 4586, -1945, 470,  328,  -163, 958,  511,  2541, 3057,
    2972, 4349, 4754, 5115,  5847, 6843, 7299, 6652, 5891, 5655 },
  { 9091, 5007, 6438, 4749, 5610, 3664, 6151, 5188, 3686, 2005, 2670,
    -245, 1788, 3724, 2626, 679,  -52,  -839, -145, 356,  3488, 1970,
    1988, 2126, 1099, 2578, 5401, 6965, 4908, 5526, 6748, 5968 },
  { 6412, 7516, 8029, 8748, 6742, 7509, 6552, 4078, 4300, 5066, 4786,
    3270, 4270, 3875, 2319, 4282, 1640, -843, -439, 427,  1587, 520,
    -28,  2251, 3358, 3049, 4407, 7286, 8994, 7802, 5924, 6824 },
  { 8467, 6838, 3934, 2952, 7200, 5407, 4593, 5882, 3353, 3865, 1870,
    1535, 2130, 4121, 3527, 1799, -637, -937, 513,  247,  169,  607,
    2947, 3530, 3717, 6082, 9703, 6867, 2729, 6292, 3084, 4879 },
  { 9934, 8638, 7508, 6894, 7343, 5306, 6208, 6136, 5240, 7136, 3958,
    1811, 3171, 1064, 2246, 882,  1681, 727,  1694, 769,  1700, 1370,
    1901, 5812, 3852, 6468, 5875, 5416, 6007, 3348, 3600, 6661 },
  { 10978, 9383, 9741, 10746, 5208, 8469, 4608, 5824, 4424, 3460, 3841,
    4037,  3687, 1582, 3784,  988,  1974, 1292, 2272, 2128, 2210, 2888,
    -967,  5864, 5568, 4693,  3796, 6361, 4816, 2697, 4559, 6437 },
  { 8329, 9809, 8672, 9375, 7503, 5775, 3454, 4596, 5093, 5033, 4021,
    2860, 2833, 2782, 3056, -617, 1644, 1759, 2434, 2570, 3312, 3807,
    3518, 3521, 1126, 2830, 3378, 4432, 3261, 5211, 4073, 10050 },
  { 9992, 8148, 7951, 7194, 5624, 5032, 3296, 2981, 5388, 3910, 2274,
    1436, 1425, 1053, 2111, 2806, 1606, 1446, 1681, -211, 1877, 1541,
    1700, 2736, 2088, 2551, 1045, 2977, 2632, 1719, 4896, 5378 },
  { 9403, 8846, 8061, 7478, 5269, 6655, 6312, 4110, 3529, 5802, 3108,
    3246, 1943, 909,  2436, 1678, 1513, 1243, 797,  213,  3888, 4015,
    2775, 2082, 2395, 2792, 2136, 2475, 1657, 2156, 1878, 2587 },
  { 9499, 9075, 5426, 6962, 8206, 8057, 3968, 5184, 2759, 2277, 2744,
    3531, 2518, 367,  1075, 2118, 900,  901,  2964, 3641, 5282, 2186,
    2416, 2312, 2366, 2149, 1024, 1912, 1119, 220,  401,  727 },
  { 7615, 8271, 8148, 7699, 7063, 7658, 5473, 7497, 7302, 5841, 4165,
    3092, 734,  2215, 3316, 2226, 1197, 1236, 2996, 5007, 2872, 3460,
    2371, 1898, 1917, 1442, 853,  1412, 700,  620,  317,  1237 },
  { 8331, 8530, 8633, 7185, 6863, 9076, 5328,  5045, 5378, 4004, 4089,
    1469, 1341, -333, 2689, 1982, 115,  -1158, 383,  1548, 1118, 2864,
    3154, 1803, 2079, 1676, 1450, 1165, 967,   795,  136,  1184 },
  { 8763, 9102, 6716, 8961, 5448, 6366, 3438, 5722, 5374, 5651, 5422,
    1728, 1751, 2444, 1024, 1118, 424,  2288, 3655, 2719, 2254, 1313,
    3476, 1983, 1975, 1502, 1172, 2333, 937,  594,  122,  149 },
  { 8146, 9931, 7629, 8882, 6328, 7491, 5646, 5494, 7238, 7355, 4478,
    2019, 2646, 3486, 4193, 1121, 562,  1823, 2787, 1720, 2228, 3627,
    4470, 3351, 2439, 2214, 1926, 2118, 1771, 767,  353,  1062 },
  { 10816, 9814, 10917, 7424, 8207, 9717, 8537, 8728, 7356, 7376, 7246,
    3223,  1981, 277,   1282, 951,  515,  222,  1392, 789,  4372, 2112,
    4083,  2706, 3234,  2414, 2655, 1407, 702,  1369, 121,  676 },
  { 11362, 10078, 7520, 7828, 10705, 7300, 7358,  6559, 8337, 7569, 5067,
    3465,  2417,  1956, 2165, 759,   -106, -1282, 1822, 3225, 4767, 5619,
    4119,  3383,  3877, 2702, 2410,  2459, 1441,  1392, 945,  216 },
  { 10112, 8115, 3762, 5107, 7443, 7676, 7498, 7380, 6235, 7523, 6246,
    3574,  2749, 3853, 303,  1558, 1896, 1107, 462,  2172, 2388, 4222,
    2000,  1688, 3560, 2297, 1593, 3679, 3628, 1507, 1549, -188 },
  { 7794, 6437, 6605, 5381, 6404, 4410, 6677, 4233, 4949, 3000, 2812,
    3756, 1805, 2877, 2098, 1737, 1809, 1427, 378,  2031, 2115, 5006,
    3159, 3602, 6343, 3503, 3356, 5971, 3138, 3932, 1028, 699 },
  { 6757, 7738, 6538, 8248, 6959, 6557, 5264, 3092, 3765, 1895, 1865,
    901,  2485, 2217, 1699, 1946, 3573, 1501, 2141, 2177, 180,  1003,
    1816, 4793, 2112, 4560, 3820, 2881, 4376, 2091, 681,  623 },
  { 9057, 8917, 7385, 7072, 6324, 5492, 5283, 5053, 5785, 4277, 3322,
    1267, 1946, 1894, 3701, 472,  1658, 1154, 777,  2193, 2349, 3611,
    3129, 3719, 1781, 5389, 3418, 2463, 3734, 3644, 3365, 2247 },
  { 9444, 9439, 8598, 9152, 6982,  8451, 8279, 6129, 5172, 3730, 2416,
    2483, 2775, 1913, 1041, -1110, -392, 1068, 556,  598,  4171, 2377,
    1870, 1906, 5449, 5413, 2589,  3564, 6473, 6692, 3140, 2665 },
  { 10567, 10001, 8225, 8289, 6898, 6856, 3920, 4547, 4297, 1456, 2348,
    1526,  2343,  2863, 1429, 312,  57,   930,  1619, 1189, 596,  1815,
    2589,  3141,  1662, 3349, 1311, 4091, 4596, 7321, 5911, 6965 },
  { 9593, 9214, 9132, 8273, 8030, 8135, 5179,  5564,  4052, 4155, 4052,
    2249, 2178, 1680, 439,  822,  -378, -1210, -1149, 3709, 2830, 747,
    2987, 5873, 795,  5124, 4233, 3887, 5573,  5312,  7258, 11014 },
  { 8373, 8033, 8934, 7880, 7434, 6144, 7528, 5163, 2591,  4301, 2489,
    4137, 1295, 760,  703,  805,  -308, -320, 2205, -1113, 362,  581,
    2567, 689,  5949, 2652, 1996, 2138, 7469, 4835, 8058,  11132 },
  { 8586, 6026, 7656, 7201, 8141, 7249, 5995, 4896, 3152,  4255, 1711,
    3498, 3933, 1852, 1444, 715,  -104, -695, 4021, 3937,  6478, 1755,
    935,  384,  1002, 2595, 3359, 4532, 7103, 5192, 12241, 14373 }
};
static int16_t default_ncobmc_krnl_2_0_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { -18,  921,  2116, 3151, 5822, 6391, 6844, 2748, 3794,  6358, 6115,
    7194, 6145, 8324, 7847, 6181, 4052, 4867, 4967, 5823,  6786, 4035,
    5989, 2636, 2376, 5222, 5409, 4121, 2105, 626,  -3363, -2857 },
  { 3594, 3991, 2433, 4231, 5187, 5335, 7496, 6672, 4132, 3625, 5649,
    7621, 4052, 6868, 7772, 7010, 5041, 5311, 7273, 6593, 6376, 5150,
    4421, 3618, 2523, 4188, 5275, 3469, 6209, 5459, 953,  947 },
  { 786,  3510, 3161, 3162, 3435, 5439, 6415, 4784, 4467, 4232, 5708,
    3775, 7437, 8362, 9398, 8331, 6300, 6049, 8740, 7748, 9508, 7139,
    7232, 6528, 8257, 4296, 5180, 4497, 3755, 6329, 3620, 3050 },
  { 2273, 1239, -1997, -385, 1641, 4987, 6332, 7869, 5742, 3115, 4523,
    5739, 6076, 8184,  8936, 9733, 5577, 8872, 8635, 7679, 7192, 6961,
    7586, 5022, 5256,  5107, 5842, 4127, 3898, 7191, 5184, 1097 },
  { 2576, 3444,  4787, 3494,  4843, 5213, 7669, 6154, 6713, 5224, 6221,
    8653, 10387, 9676, 10219, 9062, 6899, 4115, 6617, 7548, 7319, 5169,
    6051, 6609,  6735, 3759,  6779, 3520, 5518, 4355, 4386, 3459 },
  { 2457, 4623, 4686, 3390,  6167,  6776,  5546, 7755, 6678,  5831, 6667,
    9797, 9222, 7728, 12319, 12899, 10764, 6383, 7947, 9907,  8225, 5677,
    7690, 9312, 8324, 4971,  9288,  6616,  5448, 7180, 11014, 5709 },
  { 3687,  5015,  5834,  5702,  6619,  6602,  6844, 8607,  10828, 10170, 9206,
    11527, 10057, 10677, 11683, 11009, 10585, 8869, 7057,  9542,  8465,  11391,
    6180,  10182, 5594,  5353,  8810,  7358,  7118, 10591, 10569, 7318 },
  { 5659, 4619, 7090, 7819,  8483,  7258,  7446,  7530,  6847, 7424, 7586,
    8261, 7644, 9373, 18173, 15351, 11259, 11899, 11787, 9977, 8370, 7422,
    9853, 6375, 5873, 6503,  6194,  4792,  5082,  4563,  2192, 5942 },
  { 3004,  6927,  6994,  7359,  7505,  10247, 9661,  8199,  7979,  8529, 9388,
    12192, 11555, 12591, 10308, 10143, 12579, 12379, 11700, 12735, 6629, 10209,
    9592,  11878, 10187, 7755,  7344,  4922,  6699,  8240,  7341,  8532 },
  { 7590,  5795, 6512,  4587,  6933,  7660,  6141,  7410,  5605,  5542,  8790,
    10597, 9438, 10999, 10270, 10028, 10678, 12591, 13767, 11933, 10966, 11898,
    12452, 8305, 6352,  8621,  7598,  5409,  5869,  6860,  8606,  5371 },
  { 7095,  7927,  9729,  11290, 10321, 9966,  8226,  10211, 12468, 10459, 10959,
    12232, 12326, 11686, 11247, 13106, 15660, 16448, 13119, 14772, 14295, 13233,
    11880, 9805,  8498,  5650,  3043,  5995,  9756,  6592,  8450,  6801 },
  { 4251,  4844,  7130,  7033,  9742,  10794, 9341,  10350, 10410, 9188,  10907,
    11059, 11547, 12685, 14995, 15511, 13256, 15229, 12788, 13792, 12937, 14179,
    12355, 8519,  7767,  6376,  7293,  7706,  6134,  9392,  9423,  6656 },
  { 5032,  6597,  8267,  6875,  10431, 9182,  11606, 9174,  9394,  10754, 10214,
    11384, 11633, 14256, 11377, 11933, 13999, 14801, 12182, 12170, 12927, 10856,
    13248, 9493,  6586,  7871,  8697,  7094,  8561,  9451,  7116,  4183 },
  { 5550,  6479,  9188,  7562,  9126,  10236, 12984, 11667, 10146, 11981, 13257,
    13227, 14228, 13278, 13571, 15730, 14696, 14740, 14122, 11230, 10186, 9795,
    9766,  9187,  10707, 11612, 10594, 14651, 10618, 5465,  6640,  1085 },
  { 6402,  8472,  7318,  8449,  9884,  8237,  11776, 12579, 8248,  9119,  10813,
    12464, 14087, 14122, 13487, 15884, 15630, 16883, 13968, 15663, 13943, 14099,
    13309, 12222, 11647, 10827, 11813, 9543,  10171, 10991, 8523,  7564 },
  { 5558,  8716,  7398,  7003,  9081,  9234,  10389, 10222, 11602, 10189, 12165,
    10551, 11676, 14110, 13499, 14107, 14297, 13673, 15239, 13669, 9564,  8809,
    11609, 10482, 11688, 10885, 12257, 11025, 11490, 10586, 12134, 11499 },
  { 5054,  7370,  10001, 8690,  6346,  7990,  10600, 10877, 13977, 14230, 13786,
    11880, 13256, 15455, 14951, 12311, 15970, 16289, 14385, 13318, 10806, 16058,
    14004, 14150, 15275, 14285, 15169, 15124, 14484, 15130, 14320, 13627 },
  { 6472,  6714,  8422,  7520,  9468,  7309,  11310, 10173, 9680,  9775,  11809,
    11641, 17217, 14973, 12511, 12431, 15565, 14706, 12653, 10736, 13799, 11984,
    14576, 14406, 13494, 13775, 13748, 13952, 12627, 13551, 12343, 13637 },
  { 5691,  6196,  6840,  5618,  8130,  5337,  10502, 11764, 12309, 11243, 12058,
    14603, 15254, 13730, 12988, 16426, 16398, 18336, 14653, 12258, 13528, 12015,
    13122, 12816, 13238, 14265, 15564, 14875, 14346, 16501, 14057, 14664 },
  { 5142,  4576,  6578,  5068,  8343,  7665,  11649, 10611, 11541, 10331, 12078,
    14129, 17221, 15930, 16224, 15649, 16231, 11200, 11389, 11572, 13476, 12629,
    11861, 13013, 15114, 12486, 15663, 12735, 13401, 13979, 13507, 13952 },
  { 6851,  5162,  6778,  6922,  8951,  5567,  10360, 9216,  7036,  5410, 10771,
    13577, 12588, 10477, 10248, 14359, 15261, 13795, 12048, 11716, 9361, 6278,
    8997,  10237, 14438, 12459, 12976, 13600, 13892, 11879, 13127, 13802 },
  { 4195,  6070,  3151,  7247,  5889,  6549,  8672,  8715,  10338, 9229, 9026,
    10246, 14651, 14345, 15001, 15116, 18364, 16684, 13657, 14718, 8840, 10437,
    9581,  12367, 11264, 11291, 13002, 11111, 13027, 14172, 12590, 13651 },
  { 3818, 4756,  8879,  6693,  4570,  8158,  7459,  7913,  5727,  9446,  10204,
    8887, 11326, 14337, 13524, 13813, 13628, 15506, 11578, 13470, 12391, 8927,
    9166, 9882,  10411, 11665, 8963,  12141, 11521, 10521, 15132, 15679 },
  { 4425, 8428,  12163, 9947,  3396,  5526,  8133,  4898,  3913,  4891,  5711,
    7034, 10657, 9932,  14435, 12716, 15058, 15501, 14937, 14530, 14536, 9746,
    9923, 11968, 7869,  10734, 9735,  9164,  11842, 12786, 16768, 15073 },
  { 7712,  9515,  10650, 9707,  6201,  9752,  8700,  10334, 9503,  13202, 9555,
    9748,  12814, 13027, 13920, 12593, 14370, 14808, 13965, 14154, 12735, 7319,
    12721, 10395, 7361,  8678,  12937, 10057, 9234,  14695, 14044, 13613 },
  { 8309,  7528,  9323,  7254,  6829,  7276,  7831,  10824, 8851,  11605, 12763,
    10865, 10153, 10736, 12379, 10799, 10370, 11817, 11734, 13290, 18692, 13378,
    10209, 11690, 12616, 9779,  9257,  6142,  7818,  10903, 13276, 8893 },
  { 5420,  5315,  7529,  7453, 9027,  9825,  7865,  9813,  6673, 6090,  7914,
    10790, 11205, 11064, 9239, 11947, 12306, 12802, 11856, 9896, 10502, 9968,
    12099, 11011, 11103, 9920, 10747, 12477, 10458, 8485,  8805, 10199 },
  { 5275,  2169,  8448, 6454, 8077,  5060, 8189, 6133,  5673,  7424,  7993,
    10659, 10836, 8138, 9347, 10570, 8447, 8359, 11071, 11453, 13480, 9521,
    11755, 8294,  7308, 4637, 10781, 5515, 4843, 4737,  5330,  4893 },
  { 4846,  5401,  5671, 3987,  6910,  8363,  10605, 9189,  9832, 11154, 11632,
    10874, 12377, 9266, 12273, 10543, 10287, 10912, 10745, 9206, 8851,  8327,
    11242, 8123,  7431, 10266, 8947,  6186,  4259,  -682,  -920, 3901 },
  { 3634, 2920,  4925,  5515,  6626, 6450,  10063, 9047,  9880,  9577, 8277,
    7582, 10044, 10186, 11630, 8182, 12589, 14249, 13236, 11328, 7042, 8880,
    7868, 6442,  10067, 3096,  5190, 5874,  2890,  668,   1718,  2480 },
  { 4732, 2901,  1056, 1878,  5356, 5406, 5212,  8538, 8974,  7742, 9588,
    7933, 10867, 8487, 11203, 8392, 8301, 10070, 4166, 11993, 9436, 10071,
    7464, 7158,  7848, 6669,  4825, 5838, 236,   3720, 562,   -1751 },
  { 1899, 3004, 3605, 1918, 2347, 4957, 5010, 5918, 6020,  5972, 7291,
    6820, 8455, 8985, 7833, 5877, 5796, 7048, 5548, 2886,  4467, 10008,
    7443, 8399, 7314, 4277, 3852, 296,  -983, 1487, -2474, -7290 }
};
static int16_t default_ncobmc_krnl_2_1_0[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 4140, 3361, 5678, 1978,  3443, 3453, 2905, 2131, 4836, 2612, 1530,
    -831, -257, 584,  -1193, -391, 107,  -47,  32,   125,  282,  684,
    161,  23,   -22,  -95,   555,  -405, 569,  -268, -92,  105 },
  { 4680, 4183, 4456, 4730, 4264, 4681, 2310, 2034, 3081, 2493, 2012,
    1397, 1521, -881, -976, -668, -606, -768, -273, 256,  -4,   -290,
    64,   -55,  -444, -989, -316, -496, 206,  -169, -158, -87 },
  { 3199, 3846,  3775, 632,  2359, 3492, 3355, 53,   -1201, 145,  263,
    -93,  -1435, 415,  -844, 954,  -241, -483, -165, -191,  -561, -185,
    -300, -258,  -154, -654, 308,  -64,  -36,  -150, 95,    146 },
  { 680,  2863, 889,  1721, 3444, 2472,  -27,  2458, 816,  -186, 123,
    3214, 2029, 2485, -631, 323,  1030,  -275, 196,  -532, -537, 153,
    274,  61,   -453, -283, -533, -1062, -145, -388, 158,  0 },
  { 1962, 4004, 1406, -535, 1315, 2669, 2522, 654, 3394, 4205, 2731,
    -40,  -118, 599,  -511, 618,  162,  840,  43,  253,  -59,  222,
    64,   -21,  -671, -179, 241,  283,  902,  226, 305,  -204 },
  { 516,  1205, 3201, -5,   1479, 945,  2129, -628, 3181, 900, 1439,
    1128, 799,  -158, -431, 347,  -118, 527,  389,  268,  -73, 2,
    534,  133,  -287, -19,  561,  329,  394,  -120, 38,   -461 },
  { 2130, 2022, 1966, 210, 447,  402,  1249, 1677, 2353, 1113, 1723,
    1300, 2060, -144, 420, 2008, -417, -74,  -197, 135,  217,  310,
    152,  339,  -99,  -81, 279,  44,   54,   -160, -82,  4 },
  { 2134, -1849, -990, -93,  1932, 2119, 2954, -371, -1021, -831, 1662,
    1330, 1634,  246,  -777, 852,  130,  -67,  191,  -316,  -429, -240,
    -147, -198,  92,   -15,  310,  141,  -10,  146,  35,    85 },
  { 2763, 4779, 994, 1054, 2625, 2031, 1784, -161, 1142, 1052, 2300,
    2462, 1943, 516, 816,  27,   18,   171,  158,  -311, -636, 20,
    -463, -235, 145, 339,  240,  -354, -110, 41,   404,  353 },
  { 3625, 3557, 2333, 950,  2020, 2445, 2562, 1506, 2571, 1559, 4781,
    2030, 1325, 2507, 2045, 1896, -526, -22,  -272, -143, -189, 17,
    10,   405,  143,  414,  -95,  -229, -215, 0,    -347, 83 },
  { 2808, 1062, 1502, 411, 1139, 998, 1577, 1233, 1637, 998,  1846,
    2487, 3868, 2225, 533, -51,  -6,  -180, -30,  186,  -175, 247,
    352,  57,   83,   290, 330,  160, 165,  354,  -465, 131 },
  { 2809, 2966, 2929, 1435, 2875, 1948, 130,  1168, 252,  1276, 2838,
    3507, 3001, 1410, 312,  1941, -336, -431, -190, -194, -130, -336,
    238,  75,   -472, -189, 123,  61,   -583, 147,  305,  200 },
  { -23,  2306, 2169, 33,   1848, 1832, 2721, 49,  1435, 585, 1036,
    2116, 1658, 1011, 815,  920,  101,  108,  262, 299,  283, 357,
    268,  141,  -71,  -285, 205,  142,  -71,  224, 252,  156 },
  { 1447, 2625, 4643, 2096, -847, -154, 2876, 1050, 104,  -873, -327,
    146,  -596, 622,  -337, 1317, -61,  9,    -201, 110,  90,   644,
    337,  204,  155,  278,  320,  -306, -504, 357,  -108, 132 },
  { -16, 2815, 1344, -2044, 2236, -549, 586,  409, 30,  152,  1588,
    243, -115, 291,  -30,   -170, -96,  -10,  433, 205, -134, 17,
    528, -16,  -22,  -198,  -43,  -143, -224, 270, 153, 37 },
  { 1478, 829,  628, 1055, 1323, -406, -282, -12,  418,  40,  -795,
    -286, -627, -41, -448, 454,  -267, -258, -129, -57,  -44, -406,
    -260, -67,  134, -196, -236, -125, 35,   -62,  -137, -5 },
  { 220,  26,  -380, -257, -90,  -453, -196, -56,  -193, 37,   131,
    151,  -88, -695, 66,   -113, -200, -144, 132,  -48,  -244, -207,
    -178, 268, -107, -1,   69,   337,  -84,  -197, 87,   119 },
  { 7,    3,   -85,  -185, 334,  -86, -69, 152, -320, -239, 587,
    415,  246, 290,  -146, -134, -9,  -69, -66, -148, -41,  -206,
    -148, 283, -144, -287, -73,  93,  -23, 247, 398,  174 },
  { 46,  -256, -114, -61,  -532, 103,  32,   -223, 24,   -20,  132,
    339, 61,   -381, -711, -160, -200, -334, 78,   173,  -281, -139,
    -27, 134,  -120, 96,   110,  -251, -114, -32,  -299, -183 },
  { -193, 28,  -134, 200,  155,  -316, -363, 285,  268, 665, 233,
    -127, 436, -20,  -536, -163, 51,   -40,  162,  78,  -27, 192,
    -34,  -40, -17,  -205, 203,  106,  -62,  -211, -84, 60 },
  { -440, 312, -195, 221,  251, -388, -116, -252, -101, 92,  -244,
    -694, -27, 198,  -3,   255, -257, -17,  0,    143,  -20, 48,
    -68,  110, -130, -340, 136, -45,  -138, 251,  -111, -2 },
  { 325,  219,  -68,  215,  -177, -206, 14,   108,  -291, 211, 92,
    -62,  -166, -218, -158, -220, -279, 199,  113,  -263, 271, 153,
    -433, -16,  19,   -322, -28,  258,  -295, -300, -285, -123 },
  { -345, 543,  356, -541, -726, -205, -332, -397, -10, -132, 232,
    132,  308,  324, 229,  79,   -151, 161,  143,  -40, -144, -464,
    32,   -364, -11, -99,  -285, 61,   -258, 182,  -28, 107 },
  { -55, 70,   -78,  -269, -709, -52,  351,  94,   80,  268, 249,
    -56, 189,  -191, -60,  -88,  15,   -205, 111,  -62, 21,  85,
    77,  -107, -35,  -13,  -107, -472, -546, -197, 5,   115 },
  { -363, -297, 246,  -84, -419, -230, 283,  -128, 34,   -27, 112,
    125,  166,  163,  176, -422, 14,   -238, -80,  -153, 313, -366,
    -208, -54,  -260, 48,  -176, 21,   -91,  -295, -270, 40 },
  { 85,   242,  107,  -41,  -283, -390, -105, 360, 181,  -720, -582,
    27,   -96,  -350, -217, -189, -135, -12,  280, 86,   3,    25,
    -126, -213, -384, 41,   -15,  101,  -68,  143, -211, 86 },
  { -183, 13,  274,  -46, -86,  -633, 181,  -232, -90, -106, -22,
    332,  -12, -16,  -30, 87,   5,    46,   37,   -99, 27,   292,
    -74,  -94, -237, -16, -145, 76,   -106, 227,  -52, 168 },
  { 40,  -258, -140, -6,   203,  146,  -64, -88, -183, 221,  62,
    67,  114,  -216, -307, -560, -197, -46, 149, -126, -120, -316,
    -36, -227, -200, 115,  -41,  -51,  97,  123, -47,  103 },
  { -51, 44,  -99,  -230, -156, -46, -145, -412, -56,  48, -239,
    222, 83,  -339, -196, -64,  175, 149,  -140, -316, 6,  -62,
    -27, -56, -21,  -269, 229,  -7,  122,  -18,  -129, 86 },
  { -372, 106, 18,  172,  364,  19,  -245, -73,  -124, 164, -9,
    14,   214, -67, -217, -175, -45, 119,  -194, 36,   18,  -83,
    126,  196, 112, -297, -102, 104, -74,  -152, 19,   199 },
  { 314,  81,  -49,  -188, 48,  -82, -4,   107, -221, -4,  207,
    -245, 197, -37,  -185, -50, -56, -214, 100, -231, -31, -2,
    21,   -53, -215, -77,  168, -23, 82,   5,   155,  169 },
  { 258, 188, -27,  -27,  165,  29,  -17,  100, -27, -80, -80,
    196, 23,  -391, -533, -171, 84,  -137, 0,   14,  251, 99,
    35,  88,  -28,  1,    144,  -96, -235, 176, 103, -85 }
};
static int16_t default_ncobmc_krnl_2_1_1[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 5724, 6155, 5101, 6937, 3616, 3940, 3066, 5662, 7104, 5021, 4979,
    5907, 4968, 7085, 6582, 7719, 9143, 4128, 6447, 4879, 7061, 11362,
    7837, 9965, 7152, 6477, 6581, 5803, 1819, 5309, 8559, 10776 },
  { 1775, 3231, 4026, 2629, 4438, 6309, 5114, 2895, 5657, 6541, 6734,
    5994, 7468, 4555, 9911, 5200, 5402, 1698, 4298, 6112, 6417, 6691,
    4816, 6195, 4139, 5856, 3358, 1993, 1542, 661,  1660, 4762 },
  { 1953, 726,  336,  2519, 4189, -753, 2993, 4957, 5850, 4298, 3651,
    5353, 3255, 5491, 7815, 3406, 3928, 2987, 4148, 4276, 3530, 8058,
    5079, 5821, 4622, 3354, 3146, 2460, 489,  1550, 1587, 1399 },
  { -801, 328,  103,  886,  1381, 2280, 4320, 2452, 1215, 6261, 2206,
    4849, 4488, 3829, 6128, 5213, 1739, 3173, 4425, 4567, 5845, 5197,
    5910, 6147, 4260, 3730, 4240, 5420, 307,  672,  963,  3278 },
  { -1721, -2596, -155, 3029, 3428, 2390, 2321, 3757, 1383, -1283, -1621,
    1418,  2475,  4188, 5570, 3575, 799,  4017, 2856, 1426, 2012,  2722,
    3669,  4104,  3800, 4116, 3275, 3739, 326,  95,   2421, 3075 },
  { -551, -927, -520, 2944, 2518, -722, -215, 1875, 137,  2182, 2761,
    159,  762,  3693, 1681, 2600, 880,  3273, 4470, 5007, 4272, 3074,
    2474, 4254, 6828, 4219, 3671, 2407, 1044, 129,  -478, 2814 },
  { -2686, -1229, 1372, 4761, 4668, 1462, 509,  2727, 930,  2438, 3542,
    1456,  1961,  541,  1063, 1426, 3603, 2873, 2412, 2999, 2101, 3739,
    2385,  5494,  5444, 5655, 5034, 381,  321,  90,   2585, 4160 },
  { -4203, 479,  1122, 2688, 2124, 942,  -2136, -1643, -491, 2581, -2155,
    -2375, 559,  582,  2202, 2081, 3774, 3330,  1101,  894,  3410, 3691,
    2509,  5195, 6226, 5471, 5022, 2525, 778,   1212,  2736, 3350 },
  { -2415, -2903, 4719, 5860, 4006, 2692, 4035, 4143, 2498, 4377, 2058,
    488,   1429,  3199, -11,  2009, 2087, 2903, 155,  522,  4521, 2221,
    2310,  3124,  2870, 1941, 3262, 2258, 1515, 2257, 1584, 1048 },
  { -1469, -2652, -561,  2135, 389,  -522, -589, 447,  -847, 268,  -1641,
    -1540, -1513, -1334, -599, -581, 2848, 2828, 1416, 2157, 2198, 925,
    2421,  1437,  1963,  369,  2195, -548, 2051, 868,  824,  2683 },
  { -2620, -3631, -4548, -885, 629, 523,  -528, -2178, -1743, 1644, 353,
    -2687, -3041, -1722, 283,  178, 1594, 1190, 968,   -386,  2305, 1317,
    245,   1443,  968,   800,  471, 521,  1564, 669,   903,   243 },
  { -1791, -3282, -4140, -1753, -1006, -374, 1027,  -176,  -1477, -891, 191,
    -912,  497,   96,    359,   1045,  1467, 172,   1303,  2510,  3516, 3671,
    789,   -807,  2670,  1483,  547,   -521, -1219, -1856, 1008,  1053 },
  { -1427, -2698, -3949, -436, 801,  -614, -1548, 523,  -176, -683, 423,
    -871,  820,   -2279, -143, 375,  768,  2306,  5249, 1302, -338, -396,
    -1590, -608,  1469,  2344, -187, -693, 599,   -661, -458, 160 },
  { -3491, -3877, -2952, 1252, 767,   -3037, -3638, 188, 587,  710,  1416,
    1176,  -319,  -473,  1873, -1997, 725,   596,   -94, 1875, 2992, -519,
    -139,  1938,  1025,  521,  760,   1090,  3648,  392, 564,  902 },
  { -2186, -3264, -1742, 2634, -36,  -51,  -1253, -314, -908, -459, -1701,
    -1437, -991,  84,    1265, -964, 402,  1454,  -772, -927, 1765, 1543,
    484,   2346,  3310,  1887, 1754, 3058, 1474,  728,  -466, -1646 },
  { -1826, -332, 48,   744,  -618, -97, -165, -155, -908,  -143, 1285,
    1739,  1185, 885,  1134, -531, -15, -526, 543,  1438,  2026, 3022,
    558,   1827, -139, 1792, 2022, 769, 2400, 444,  -1572, 598 },
  { 165,  -357, 15,  666, 1315, 1155, 376,  -7,  991,  213,  1687,
    -34,  452,  352, 203, 1605, 1484, -498, 581, 533,  467,  1744,
    1315, 874,  82,  900, 1437, -692, -417, 456, -271, -1132 },
  { 646, 210,   320,  1208, 145,  971,   396, -448, 557, 1876, -1791,
    913, -1288, -452, 1015, 925,  -1197, -49, -285, 442, 1093, -410,
    125, 519,   -52,  513,  1497, -1337, 298, -402, 820, 732 },
  { -796, 627, -1017, 2972, 4463, 2331, 1387, 1496, 1796, 1608, 1681,
    -877, 881, -160,  -581, -433, 949,  471,  307,  140,  -946, -597,
    247,  650, 1143,  694,  10,   -682, 890,  409,  617,  810 },
  { 1653, 4435,  2388,  294,  2578, 1229, 1072, 1871, 465,  1650, 1524,
    -430, -1195, -3427, -116, 1117, 217,  967,  -254, 259,  -55,  1425,
    1583, -1261, -1773, 1232, 2886, 646,  1346, 1518, 2090, -837 },
  { 2020, 728,   2038,  316, 5725, 4193, 890,  1490, 584,  2705, 694,
    -892, 34,    2041,  972, 332,  -295, -218, -756, 2193, 1672, 1440,
    2310, -2136, -2204, 399, -753, 743,  3155, 2521, 3534, 166 },
  { 824,  1664, 991,  853,  700,  -80,   148, -908, -194, -620, 1053,
    -368, 1616, 1250, 1449, 3140, -1065, 286, 2226, -590, -570, -1131,
    477,  -61,  -708, 519,  586,  1148,  898, 1653, 4697, 1581 },
  { 2014, 1921, -210, 556,  686,  -561, -1239, -1345, -664,  -138, -215,
    -343, 1019, 1294, 519,  -179, 212,  -299,  -2160, -1450, -329, 293,
    691,  162,  -645, 1079, 2005, 1466, 1127,  2263,  730,   179 },
  { 5629, 4670, 597,  2030, 3873, 3698, 54,   2714, 62,   352,   2177,
    908,  1306, 1504, 1464, -288, -106, -69,  -179, -900, -1340, -4,
    877,  487,  2606, 358,  2055, 1131, 1421, 931,  -477, 1173 },
  { 757,  -493, 1510, 2513, 4514, 4649, -478, 2069, 124, -1186, 2855,
    1906, 1420, 1738, 19,   1916, 1195, -519, 32,   512, 230,   528,
    43,   -263, 1314, 1350, 137,  -256, 939,  256,  168, -201 },
  { 663, 947,  699,  3239, 4730, 5279, 1739, 1659, 2774,  -1660, -1677,
    185, 3745, 1319, 2347, 477,  364,  531,  608,  -520,  -783,  -123,
    -59, -345, 1202, 1766, 88,   883,  654,  1399, -1082, 658 },
  { 4534, 5694, 5332, 4909, 4828, 4761, 7376, 3834, 2327, 4737, 7135,
    5306, 6337, 5240, 5578, 4321, 2107, -205, 1387, 597,  1112, 904,
    1567, 610,  461,  371,  250,  602,  358,  1807, -617, -59 },
  { 6124, 8363, 9624, 5674, 7043, 4437, 3846, 3121, 3477, 2818, 5445,
    3618, 5067, 3996, 5759, 7185, 2150, 785,  1581, 2084, 3321, 4828,
    -545, 510,  2309, 2501, 1594, 2028, 528,  113,  248,  550 },
  { 8154,  9890, 6292, 6421, 8295, 4403, 7503, 5496, 7256, 3699, 2845,
    3725,  5365, 5905, 7170, 2903, 733,  4614, 3856, 4346, 7099, -902,
    -1492, 1703, 2321, 1842, 3488, 1690, 982,  524,  -467, -687 },
  { 5338, 10331, 7754, 7014, 3581, 5660, 5471, 5420, 3976, 2548, 6486,
    9144, 6584,  5442, 6795, 4845, 5182, 2855, 8246, 3660, 5417, 1845,
    1803, 288,   1434, 639,  1404, 2752, 923,  1055, 741,  -984 },
  { 4457, 7110, 5195, 5959, 6818, 8562, 5548, 2071, 5544, 8734, 7080,
    4737, 9481, 7672, 8374, 7638, 4204, 3562, 3758, 3598, 5016, 2863,
    3927, 5001, 4677, 4444, 2481, 1773, 2525, 3142, 4840, 3965 },
  { 1134, 3249, 4702, 5483, 4471, 7234, 7281, 6240, 5891, 7577, 3826,
    5886, 4798, 7117, 6319, 7264, 4115, 5613, 4674, 4999, 4518, 2501,
    6830, 4913, 2356, 789,  1926, 2190, 1914, 1434, 987,  1761 }
};
static int16_t default_ncobmc_krnl_2_1_2[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 6131, 7769, 6548, 6297, 4967, 4708, 3127, 5937, 697,  748,  1850,
    2290, 2945, -80,  216,  377,  318,  1009, 2112, 2962, -886, 849,
    510,  4160, 2257, 2875, 4589, 5345, 7363, 5350, 6815, 1644 },
  { 6949, 8044, 7295, 7318, 3142, 2084, 1819, 3048, 1654, 1831, 1344,
    3344, 2065, 2889, -88,  3746, 696,  1143, 232,  1444, 1587, 4125,
    3991, 3840, 5642, 4933, 3560, 6540, 5865, 6663, 6729, 5520 },
  { 7816, 4894, 7089, 7533, 4271, 6814, 1972, 3845,  3755, 3498, 3571,
    1884, 3171, 1843, 70,   2358, 2622, 1241, 143,   2657, 3804, 2968,
    1781, 262,  2864, 4345, 1302, 5434, 7815, 10560, 9211, 8202 },
  { 10656, 7490, 8639, 7975, 4318, 7432, 6148,  3321, 3776, 2781, 3544,
    246,   2350, 793,  1600, 1266, 2372, -1382, -983, 1926, 493,  447,
    2275,  3510, 4789, 3766, 878,  2353, 3314,  6282, 5853, 3709 },
  { 11083, 7270, 6211, 6170, 4927, 4198, 3939, 4605, 1734, 2009, 2950,
    546,   722,  99,   550,  597,  2350, 41,   1314, 1148, -183, 1143,
    5392,  3550, 3102, 1161, -556, 1700, 7598, 8412, 6019, 9654 },
  { 10358, 7350, 6589, 5975, 3587, 6201, 4603, 3974, 2262, 886,  1815,
    1899,  1642, 2894, 1557, 228,  1625, 1879, 838,  182,  919,  1168,
    3272,  1155, 889,  2292, 128,  4478, 5205, 7668, 8767, 10921 },
  { 8569, 4702, 5397, 5147, 2577, 4301, 2139, 1630, 721,  1721, -218,
    1595, 275,  1133, 1051, -777, 1556, -245, 972,  106,  2205, 385,
    1410, 366,  3348, 2139, -164, 3111, 2656, 5036, 6021, 4847 },
  { 7654, 5535, 5975, 4580, 3005, 5483, 4637, 5560, 6252, 4946, 4508,
    3600, 1824, 1528, 338,  131,  1290, 309,  344,  3110, 3607, 2484,
    1062, 1267, 1426, -860, 1155, 6137, 2415, 5482, 6846, 4916 },
  { 8060,  5296,  4396, 2040, 867,  1189, 3555, 3397, 3438, 664,  -1931,
    -1938, -1414, 1317, 762,  -312, -655, -801, -243, 2795, 1663, 1314,
    1478,  2856,  562,  1075, 3211, 7482, 2988, 3880, 4156, 3289 },
  { 8146, 7596, 7056,  7622, 5755, 7181, 7862, 4736, 4932, 3146, 1043,
    -422, -813, -2152, 1444, 441,  3599, 395,  2173, 755,  4245, 3047,
    1545, 1062, 1159,  1621, 209,  6521, 7385, 7730, 6511, 8959 },
  { 9567,  8044, 7535, 6969, 3284, 4284, 4734, 4758, 5177, 2342, 230,
    -1852, -839, -769, 222,  255,  -315, -16,  1101, -28,  3561, 2004,
    -260,  789,  1856, 1960, 4962, 4207, 2425, 8406, 6771, 7796 },
  { 8019,  7612,  8357,  5521, 4711,  3374, 4391, 7093, 5013, 3608, 238,
    -1564, -1662, -1373, -198, -1045, 100,  2694, 1251, 489,  2110, 1670,
    188,   -1362, 953,   2340, 3361,  3595, 6405, 7676, 1634, 7730 },
  { 10177, 6488, 5822, 5121, 2615,  2725, 3372, 4849, 2232, 2548, 2841,
    874,   895,  307,  1293, -150,  411,  -981, -815, -24,  936,  -2339,
    254,   3019, 5892, 4302, -2171, 6747, 7198, 5638, 4832, 9538 },
  { 7260,  9945, 2818, 1106, 6179, 6331, 5106, 1814, 5997, 4045, 1456,
    -230,  297,  1045, 1918, -126, 752,  1014, 999,  -506, 198,  -732,
    -1900, 139,  749,  3999, 5614, 5241, 6339, 8316, 3673, 7681 },
  { 11101, 6954, 7475,  5729, 4242, 6118, 4569, 2348, 5307, 3762, 2933,
    -1610, 988,  -1178, -104, -151, -507, 491,  -906, 1236, 3075, 1525,
    1631,  2901, 2758,  1303, 1578, 6405, 3807, 7189, 8468, 9262 },
  { 6835, 4602, 5501, 5568, 4338, 6143, 4304, 3557, 3258, 3797, 1242,
    968,  1683, -251, 1218, 301,  1257, 1924, 985,  1251, 3051, 433,
    1756, 167,  -660, 3884, 3450, 7202, 6544, 5184, 7556, 9366 },
  { 5991, 6762, 3854, 4856, 6714, 5701, 4072, 2489, 422,  -365, 1488,
    1660, 725,  1157, -778, 654,  313,  -18,  3162, 3065, 2925, 2391,
    827,  5547, 461,  2487, 1492, 5810, 7042, 5284, 3995, 6870 },
  { 6435, 8283, 4732, 5896, 5599, 4229, 4798, 3309, 3128, 941,  2565,
    394,  257,  2477, 721,  1494, 3161, 1409, 1306, 2534, 1261, 2719,
    756,  4388, 570,  5416, 3719, 6067, 4092, 2565, 6299, 10504 },
  { 6042, 7417, 5391, 4671, 3245, 7547,  3777,  3203, 2044, 583,  2083,
    1971, 1721, 1948, -169, 1197, -1141, -480,  2155, 1033, 1313, 268,
    1857, 4493, 3083, 2005, 5347, 4397,  10144, 4828, 6622, 9817 },
  { 7202, 5045, 6601, 6937, 3704, 5796, 5061, 3575, 2383, 1389, 3111,
    1751, 1603, 2813, 174,  706,  -569, 2620, 1735, 1418, 1871, -1542,
    168,  2156, 5107, 6329, 4968, 7018, 6279, 6864, 5898, 9157 },
  { 5722, 5683, 4189, 4814, 2883, 5508, 5100, 1625, 2169, 3680, 1884,
    2109, 462,  1145, 334,  515,  191,  441,  1058, 917,  1528, -96,
    1843, 5395, 4498, 5681, 4193, 5196, 8356, 5303, 7262, 10141 },
  { 5879, 5779,  7257, 3873, 6911, 6238, 5672,  3583, 3261, 3048, 2536,
    -310, -1046, -69,  -660, 417,  -719, -2058, 1740, 888,  2746, 1367,
    1668, 1090,  1830, 1153, 5047, 7336, 3380,  7160, 4422, 9401 },
  { 7809, 7945, 8385, 8535, 7803, 3953, 5065, 3185,  2013,  1659, 1648,
    769,  292,  -135, 114,  -579, 713,  1407, -1181, 1569,  3525, 5630,
    219,  3518, 3739, 3432, 7282, 6357, 619,  5779,  10116, 6448 },
  { 9496,  7224, 5342, 5960, 5092,  4225, 4353, 3995, 3631, 1662, 1413,
    762,   534,  126,  -551, -1025, 2327, 602,  -452, 1285, 2103, 2579,
    -1369, 2724, 6353, 3925, 4631,  9139, 4974, 6630, 7755, 4125 },
  { 5226, 7729, 5768,  5815, 4531, 2948, 3029,  2603, 2549, 1366, 119,
    405,  21,   -1831, -327, -287, -415, -1317, -214, 3017, 1586, 2436,
    868,  1094, 290,   668,  2117, 756,  1228,  2700, 5743, 8052 },
  { 6262, 5531, 4454, 4616, 3913, 2022, 4240, 2241, 4201, 2506, 1810,
    628,  -496, -779, -471, 394,  756,  1666, -445, 490,  575,  -478,
    894,  1182, 822,  626,  1782, 1781, 5333, 5482, 1760, 8187 },
  { 6488,  6875,  4960, 6837,  4564, 1871, 390,  2940, 4330, 1634, 131,
    -1102, -1451, -928, -1067, -419, -614, -2,   1017, 1066, 1051, 917,
    1097,  844,   465,  513,   2377, 1031, 3548, 5088, 4516, 10564 },
  { 6497, 6047,  5649, 7156, 4974, 3683, 2875, 4421, 1502, 1244, 668,
    -30,  -1465, -59,  -399, -721, 954,  -281, -2,   664,  1039, 814,
    758,  1911,  319,  4247, 1848, 1606, 2536, 2189, 1372, 7759 },
  { 5994, 5659,  6777, 6693, 4758, 2986, 1463, 1186, 2116, -166, 499,
    73,   -1151, -164, 279,  -895, -169, 339,  1194, 1772, 752,  1649,
    1696, -2615, 1581, 1740, 1789, 1832, 1899, 510,  2135, 7149 },
  { 9107,  4250, 5418, 4334,  613,   2618, 3395, 4809, 1724, 873, -78,
    -1146, -431, -547, -1104, -1128, -6,   -290, 945,  794,  564, 1670,
    737,   4540, 1574, 6285,  2596,  2859, 1191, 1428, 5614, 8419 },
  { 5905, 4490, 6470,  3636, 2119,  1731, 3532, 2461, 2391, 473,  176,
    -562, 389,  -1300, -916, -1436, 371,  567,  1038, 866,  59,   195,
    679,  -721, 2994,  3260, 1813,  1589, 850,  1982, 7410, 11546 },
  { 7265, 8775, 6672, 6657, 6182, 3732, 3222, 4564, 2644, 790,  924,
    -596, 628,  -681, -57,  -236, 103,  364,  603,  1420, 309,  787,
    1257, 770,  2453, 3401, 1175, 434,  792,  4019, 8792, 11773 }
};
static int16_t default_ncobmc_krnl_2_1_3[MAX_SB_SIZE][MAX_SB_SIZE] = {
  { 391,  -894, -939, 1155,  4362, 4297, 7296,  2684, 3758, 8010, 8044,
    9041, 8748, 8816, 10796, 8701, 6840, 11306, 7814, 8456, 9952, 3511,
    7870, 2227, 7018, 7148,  4672, 5660, 6657,  6007, 1098, 3866 },
  { 2970, 945,  619,  1701, 4540, 3326,  7140,  8401,  6001, 5524, 6311,
    5657, 5333, 9833, 7547, 8127, 10894, 14326, 12130, 8591, 8408, 5873,
    7524, 6398, 7054, 6594, 9788, 8347,  8784,  9253,  8154, 6170 },
  { 3423, 6928,  5192, 5699, 5575,  6852,  8083,  7546,  8019, 8464, 8910,
    9251, 11401, 8637, 9356, 9671,  10065, 12652, 12275, 9662, 9627, 5550,
    9836, 10565, 9075, 9350, 11656, 8549,  8120,  4437,  5501, 6658 },
  { 5859, 5714, 6766, 5830, 7266,  4208,  5956,  8173,  10615, 7557,  10533,
    8101, 7530, 9292, 9312, 9603,  11268, 14896, 12761, 10435, 10584, 10602,
    7945, 6677, 7798, 9184, 11805, 9688,  12921, 9831,  9425,  9409 },
  { 5068,  7732,  8953,  7750,  6739,  7145,  7635,  7400,  9896,  11465, 12344,
    14483, 13309, 11497, 10778, 11614, 13096, 11519, 12197, 13573, 14652, 12324,
    7270,  8764,  10162, 11289, 13446, 10681, 7564,  7663,  7650,  3879 },
  { 6073,  8775,  7134, 7485,  8815,  9982,  9893,  11182, 10807, 12415, 10385,
    13211, 13198, 9974, 13590, 13229, 14029, 10733, 10710, 10950, 11286, 12150,
    10133, 10858, 8958, 9903,  12033, 9177,  9756,  8710,  8055,  3108 },
  { 8368,  10916, 7650,  6261,  8713,  10236, 12507, 10373, 12385, 11135, 11343,
    12039, 12114, 14871, 13861, 13742, 11649, 13839, 13207, 13160, 11863, 11950,
    12423, 10188, 7712,  8705,  11270, 12864, 13370, 11422, 7881,  7390 },
  { 10805, 12233, 10301, 9238,  9352,  7871,  10959, 12870, 11641, 9692, 12373,
    13839, 12380, 14055, 14653, 13348, 11227, 12844, 14769, 12714, 9815, 10484,
    12966, 10123, 8644,  11791, 9911,  7598,  13225, 9539,  6774,  8055 },
  { 7987,  9257,  6281,  7446,  8911,  10506, 7039,  9031,  9319,  10294, 13979,
    15391, 14445, 11372, 14852, 14690, 14954, 14129, 16319, 13385, 10855, 12837,
    13065, 10647, 12815, 13043, 9686,  7003,  12028, 10211, 10237, 11699 },
  { 6073,  7893,  7571,  5698,  8244,  7305,  6581,  9719,  9746,  11432, 12215,
    16346, 17408, 17379, 13508, 14637, 10471, 13204, 13089, 13632, 10135, 12397,
    12431, 13511, 13140, 13999, 14081, 10639, 7173,  7807,  9433,  4659 },
  { 6634,  10941, 11920, 9920,  11356, 10608, 10624, 12593, 11330, 11413, 13971,
    18455, 16400, 16654, 15373, 16023, 15144, 15413, 14357, 16626, 10718, 12841,
    16053, 14104, 13496, 13334, 10605, 11490, 12221, 6956,  9178,  8213 },
  { 7366,  9121,  9253,  11198, 9839,  11458, 10864, 8319,  12656, 12437, 13128,
    15378, 14565, 16278, 15940, 14457, 15156, 13972, 14035, 13587, 10888, 11376,
    15176, 18483, 13236, 12754, 12347, 13247, 11785, 10432, 13455, 7419 },
  { 7665,  10318, 12372, 11702, 11166, 12470, 11859, 10983, 12921, 13947, 12106,
    14300, 13037, 17367, 14444, 15259, 15107, 14974, 11715, 14835, 15525, 18775,
    17479, 13835, 9101,  10034, 18554, 10201, 8666,  11181, 11767, 6530 },
  { 11169, 7696,  11879, 11938, 10302, 13271, 12067, 13360, 9715,  12528, 13879,
    15312, 17012, 15194, 12951, 17211, 14989, 14796, 15695, 14942, 13140, 17003,
    18104, 14131, 14490, 11607, 9697,  10346, 6890,  7337,  12248, 7668 },
  { 7494,  9902,  9327,  10081, 9955,  10895, 12521, 13971, 11975, 12950, 13579,
    19214, 16537, 17208, 15292, 17698, 16633, 14485, 17676, 15920, 11698, 13314,
    13747, 11163, 10360, 13396, 13119, 7073,  11331, 8217,  8258,  8754 },
  { 9934,  11319, 10239, 9047,  11387, 10784, 12566, 13038, 13663, 12717, 14675,
    14008, 14178, 15820, 14510, 16181, 15440, 15283, 15009, 13767, 11372, 13359,
    14352, 14480, 17066, 10914, 11175, 8554,  7428,  10827, 10561, 6443 },
  { 10016, 9986,  12912, 11133, 8475,  9995,  12150, 14006, 15182, 16531, 13117,
    14634, 15313, 15598, 16928, 14269, 14814, 17080, 12532, 12849, 13261, 12479,
    14442, 9716,  15960, 13029, 13398, 10927, 9854,  10849, 12580, 10547 },
  { 9295,  7913,  11422, 9455,  10319, 11278, 11274, 13394, 13038, 13821, 15044,
    14686, 17187, 14091, 14823, 14137, 14455, 15111, 15447, 13582, 14076, 14295,
    15643, 11185, 16015, 10747, 11235, 11551, 12009, 13990, 8881,  5003 },
  { 11095, 8615,  12138, 8821,  9239,  6419,  11207, 11937, 12556, 14236, 12501,
    14976, 13740, 15006, 17876, 15826, 16800, 16761, 13880, 15072, 16296, 16857,
    14333, 11125, 12310, 13605, 10932, 12928, 5472,  11185, 9435,  5957 },
  { 7725,  6887,  7535,  8957,  9967,  9700,  10640, 10680, 13275, 12682, 11517,
    15207, 15552, 17018, 16856, 14725, 16692, 12845, 14748, 14656, 14606, 16310,
    14672, 15510, 13069, 9039,  8315,  8606,  8826,  8214,  8487,  7999 },
  { 9071,  9686,  10375, 11046, 7539,  7106,  10540, 13531, 13747, 9927,  14071,
    15876, 15935, 13026, 15104, 15296, 16773, 16198, 16098, 13165, 13227, 15002,
    12319, 13015, 14240, 10673, 12818, 10497, 5016,  8298,  5706,  6088 },
  { 9366,  8741,  8215,  11450, 8961,  10464, 10575, 13631, 13635, 13752, 12735,
    17169, 16010, 15438, 15786, 13083, 18481, 17990, 12316, 16370, 13953, 16000,
    14693, 15392, 15242, 15049, 10809, 7658,  12399, 7866,  7570,  5544 },
  { 6903,  5972,  7864,  7864,  8655,  13231, 12904, 14949, 15064, 15007, 14738,
    15847, 14769, 14910, 15543, 17103, 15630, 15115, 19594, 16319, 13352, 10936,
    15453, 13064, 13305, 12008, 7408,  8514,  14898, 8171,  5583,  9657 },
  { 1309,  4431,  10551, 8701,  8152,  8547,  11642, 9601,  12635, 14116, 12560,
    14796, 14370, 14959, 15558, 17801, 14148, 16067, 16927, 16084, 15633, 13749,
    16805, 13274, 7467,  12136, 9815,  6584,  10514, 9020,  9109,  10981 },
  { 10778, 9464,  8877,  8157,  7779,  9056,  13584, 11871, 13714, 16259, 13305,
    13956, 14785, 16328, 16541, 15199, 15586, 18478, 16668, 13019, 14279, 13814,
    15684, 15613, 15050, 14345, 14327, 15869, 14316, 13744, 10738, 8497 },
  { 9411,  9691,  11139, 8582,  8038,  9492,  10534, 12154, 9249,  16286, 16839,
    15572, 13252, 16207, 14760, 15743, 15428, 14223, 15971, 16378, 16607, 16993,
    15698, 15766, 14771, 13969, 14551, 13631, 10451, 9360,  15908, 7460 },
  { 5565,  3814,  5832,  4698,  7091,  10412, 8442,  9852,  9831,  10137, 9167,
    11864, 11520, 12092, 11930, 12431, 14914, 16568, 13978, 14847, 14215, 14290,
    13812, 15033, 15711, 15541, 13908, 14681, 12577, 9266,  12542, 5718 },
  { 3740,  2245,  1259,  3575,  4190,  8150,  9742,  8948,  11592, 12108, 10225,
    12748, 12684, 12687, 11339, 10475, 13481, 15937, 14669, 13780, 12167, 11074,
    16225, 14201, 13966, 9544,  12974, 12797, 13248, 13990, 14819, 7995 },
  { 2296,  817,   3435,  3505,  3507,  9072,  7580,  10139, 7087,  12821, 13297,
    12396, 12113, 10999, 9149,  14466, 15677, 11290, 11487, 10612, 8552,  15725,
    16233, 17367, 12511, 13088, 10898, 12875, 13386, 15384, 14845, 9849 },
  { 2320,  1714,  3209,  4858,  11853, 8126,  7775,  6246,  10834, 12812, 9996,
    8379,  10020, 11558, 10914, 12851, 11272, 13723, 7409,  11919, 10393, 12987,
    13756, 11382, 13258, 9754,  12513, 10697, 14356, 14065, 10023, 8748 },
  { 5715,  4721,  4773,  6968, 7426,  6196,  7322,  11771, 8704,  7198,  8944,
    12478, 6336,  10064, 9132, 10252, 11884, 12483, 11504, 12168, 11346, 13354,
    11779, 12178, 8942,  8770, 11937, 13047, 12938, 11277, 4002,  710 },
  { 7743,  4184,  5058,  4276,  5576,  5393,  5919,  5500,  7881, 8102,  11726,
    10912, 10943, 10344, 10654, 9537,  12118, 10565, 11112, 9964, 11328, 13005,
    8273,  10626, 11596, 12198, 13157, 13884, 13912, 10737, 6497, 2938 }
};

void get_default_ncobmc_kernels(AV1_COMMON *cm) {
  av1_copy(cm->ncobmc_kernels[0][0].KERNEL[0], default_ncobmc_krnl_0_0_0);
  av1_copy(cm->ncobmc_kernels[0][0].KERNEL[1], default_ncobmc_krnl_0_0_1);
  av1_copy(cm->ncobmc_kernels[0][0].KERNEL[2], default_ncobmc_krnl_0_0_2);
  av1_copy(cm->ncobmc_kernels[0][0].KERNEL[3], default_ncobmc_krnl_0_0_3);
  av1_copy(cm->ncobmc_kernels[0][1].KERNEL[0], default_ncobmc_krnl_0_1_0);
  av1_copy(cm->ncobmc_kernels[0][1].KERNEL[1], default_ncobmc_krnl_0_1_1);
  av1_copy(cm->ncobmc_kernels[0][1].KERNEL[2], default_ncobmc_krnl_0_1_2);
  av1_copy(cm->ncobmc_kernels[0][1].KERNEL[3], default_ncobmc_krnl_0_1_3);
  av1_copy(cm->ncobmc_kernels[1][0].KERNEL[0], default_ncobmc_krnl_1_0_0);
  av1_copy(cm->ncobmc_kernels[1][0].KERNEL[1], default_ncobmc_krnl_1_0_1);
  av1_copy(cm->ncobmc_kernels[1][0].KERNEL[2], default_ncobmc_krnl_1_0_2);
  av1_copy(cm->ncobmc_kernels[1][0].KERNEL[3], default_ncobmc_krnl_1_0_3);
  av1_copy(cm->ncobmc_kernels[1][1].KERNEL[0], default_ncobmc_krnl_1_1_0);
  av1_copy(cm->ncobmc_kernels[1][1].KERNEL[1], default_ncobmc_krnl_1_1_1);
  av1_copy(cm->ncobmc_kernels[1][1].KERNEL[2], default_ncobmc_krnl_1_1_2);
  av1_copy(cm->ncobmc_kernels[1][1].KERNEL[3], default_ncobmc_krnl_1_1_3);
  av1_copy(cm->ncobmc_kernels[2][0].KERNEL[0], default_ncobmc_krnl_2_0_0);
  av1_copy(cm->ncobmc_kernels[2][0].KERNEL[1], default_ncobmc_krnl_2_0_1);
  av1_copy(cm->ncobmc_kernels[2][0].KERNEL[2], default_ncobmc_krnl_2_0_2);
  av1_copy(cm->ncobmc_kernels[2][0].KERNEL[3], default_ncobmc_krnl_2_0_3);
  av1_copy(cm->ncobmc_kernels[2][1].KERNEL[0], default_ncobmc_krnl_2_1_0);
  av1_copy(cm->ncobmc_kernels[2][1].KERNEL[1], default_ncobmc_krnl_2_1_1);
  av1_copy(cm->ncobmc_kernels[2][1].KERNEL[2], default_ncobmc_krnl_2_1_2);
  av1_copy(cm->ncobmc_kernels[2][1].KERNEL[3], default_ncobmc_krnl_2_1_3);
}
