# Metrics we collect

We adhere to [Activity Stream's data collection policy](https://github.com/mozilla/activity-stream/blob/master/docs/v2-system-addon/data_events.md). Data about your specific browsing behavior or the sites you visit is **never transmitted to any Mozilla server**.  At any time, it is easy to **turn off** this data collection by [opting out of Firefox telemetry](https://support.mozilla.org/kb/share-telemetry-data-mozilla-help-improve-firefox).

## User event pings

The Onboarding system add-on sends 2 types of pings(HTTPS POST) to the backend [Onyx server](https://github.com/mozilla/onyx) :
- a `session` ping that describes the ending of an Onboarding session (a new tab is closed or refreshed, an overlay is closed, a notification bar is closed), and
- an `event` ping that records specific data about individual user interactions while interacting with Onboarding

For reference, Onyx is a Mozilla owned service to serve tiles for the current newtab in Firefox. It also receives all the telemetry from the about:newtab and about:home page as well as Activity Stream. It's operated and monitored by the Cloud Services team.

# Example Onboarding `session` Log

```js
{
  // These fields are sent from the client
  "addon_version": "1.0.0",
  "category": ["onboarding-interactions"|"overlay-interactions"|"notification-interactions"],
  "client_id": "374dc4d8-0cb2-4ac5-a3cf-c5a9bc3c602e",
  "locale": "en-US",
  "type": ["onboarding_session" | "overlay_session" | "notification_session"],
  "page": ["about:newtab" | "about:home" | "about:welcome"],
  "parent_session_id": "{45cddbeb-2bec-4f3a-bada-fb87d4b79a6c}",
  "root_session_id": "{45cddbeb-2bec-4f3a-bada-fb87d4b79a6c}",
  "session_begin": 1505440017018,
  "session_end": 1505440021992,
  "session_id": "{12dasd-213asda-213dkakj}",
  "tour_type" ["new" | "update"],

  // These fields are generated on the server
  "date": "2016-03-07",
  "ip": "10.192.171.13",
  "ua": "python-requests/2.9.1",
  "receive_at": 1457396660000
}
```

| KEY | DESCRIPTION | &nbsp; |
|-----|-------------|:-----:|
| `addon_version` | [Required] The version of the Onboarding addon. | :one:
| `category` | [Required] Either ["", "overlay-interactions", "notification-interactions"] to identify which kind of the interaction | :one:
| `client_id` | [Required] An identifier generated by [ClientID](https://github.com/mozilla/gecko-dev/blob/master/toolkit/modules/ClientID.jsm) module to provide an identifier for this device. This data is automatically appended by `ping-centre` module | :one:
| `ip` | [Auto populated by Onyx] The IP address of the client. Onyx does use (with the permission) the IP address to infer user's geo-information so that it could prepare the corresponding tiles for the country she lives in. However, Ping-centre will NOT store IP address in the database, where only authorized Mozilla employees can access the telemetry data, and all the raw logs are being strictly managed by the Ops team and will expire according to the Mozilla's data retention policy.| :two:
| `locale` | The browser chrome's language (e.g. en-US). | :two:
| `page` | [Required] One of ["about:newtab", "about:home", "about:welcome"]| :one:
| `parent_session_id` | [Required] The unique identifier generated by `gUUIDGenerator` service to identify this event belongs to which parent session. Events happen upon overlay will have the `overlay session uuid` as its `parent_session_id`. Events happen upon notification will have the `notification session uuid` as its `parent_session_id`. | :one:
| `root_session_id` | [Required] The unique identifier generated by `gUUIDGenerator` service to identify this event belongs to which root session. Every event will have the same `onboarding session uuid` as its `root_session_id` when interact in the same tab. | :one:
| `session_begin` | [Required] Timestamp in (integer) milliseconds when onboarding/overlay/notification becoming visible. | :one:
| `session_end` | [Required] Timestamp in (integer) milliseconds when onboarding/overlay/notification losing focus. | :one:
| `session_id` | [Required] The unique identifier generated by `gUUIDGenerator` service to identify the specific user session. We will log different uuid when onboarding is inited/when the overlay is opened/when notification is shown. | :one:
| `tour_type` | [Required] One of ["new", "update"] indicates the user is a `new` user or the `update` user upgrade from the older version | :one:
| `type` | [Required] The type of event. Allowed event strings are defined in the below section | :one:
| `ua` | [Auto populated by Onyx] The user agent string. | :two:
| `ver` | [Auto populated by Onyx] The version of the Onyx API the ping was sent to. | :one:

# Example Onboarding `event` Log

```js
{
  "addon_version": "1.0.0",
  "bubble_state": ["bubble" | "dot" | "hide"],
  "category": ["logo-interactions"|"overlay-interactions"|"notification-interactions"],
  "client_id": "374dc4d8-0cb2-4ac5-a3cf-c5a9bc3c602e",
  "locale": "en-US",
  "logo_state": ["logo" | "watermark"],
  "notification_impression": [1-8],
  "notification_state": ["show" | "hide" | "finished"],
  "page": ["about:newtab" | "about:home" | "about:welcome"],
  "parent_session_id": "{45cddbeb-2bec-4f3a-bada-fb87d4b79a6c}",
  "root_session_id": "{45cddbeb-2bec-4f3a-bada-fb87d4b79a6c}",
  "current_tour_id": ["onboarding-tour-private-browsing" | "onboarding-tour-addons"|...], // tour ids defined in 'onboardingTourset'
  "target_tour_id": ["onboarding-tour-private-browsing" | "onboarding-tour-addons"|...], // tour ids defined in 'onboardingTourset',
  "tour_id": ["onboarding-tour-private-browsing" | "onboarding-tour-addons"|...], // tour ids defined in 'onboardingTourset'
  "timestamp": 1505440017019,
  "tour_type" ["new" | "update"],
  "type": ["notification-cta-click" | "overlay-cta-click" | "overlay-nav-click" | "overlay-skip-tour"...],
  "width": 950,

  // These fields are generated on the server
  "ip": "10.192.171.13",
  "ua": "python-requests/2.9.1",
  "receive_at": 1457396660000,
  "date": "2016-03-07",
}
```


| KEY | DESCRIPTION | &nbsp; |
|-----|-------------|:-----:|
| `addon_version` | [Required] The version of the Onboarding addon. | :one:
| `bubble_state` | [Optional] | One of ["bubble", "dot", "hide"] indicates the current visual state of the speach bubble (content dialog besides the onboarding logo). | :one:
| `category` | [Required] Either ("overlay-interactions", "notification-interactions") to identify which kind of the interaction | :one:
| `client_id` | [Required] An identifier generated by [ClientID](https://github.com/mozilla/gecko-dev/blob/master/toolkit/modules/ClientID.jsm) module to provide an identifier for this device. This data is automatically appended by `ping-centre` module | :one:
| `current_tour_id` | [Optional] id of the current tour. We put "" when this field is not relevant to this event. | :one:
| `ip` | [Auto populated by Onyx] The IP address of the client. Onyx does use (with the permission) the IP address to infer user's geo-information so that it could prepare the corresponding tiles for the country she lives in. However, Ping-centre will NOT store IP address in the database, where only authorized Mozilla employees can access the telemetry data, and all the raw logs are being strictly managed by the Ops team and will expire according to the Mozilla's data retention policy.| :two:
| `locale` | The browser chrome's language (e.g. en-US). | :two:
| `logo_state` | [Optional] One of ["logo", "watermark"] indicates the overlay is opened while in the default or the watermark state. | :one:
| `notification_impression` | [Optional] An integer to record how many times the current notification tour is shown to the user. Each Notification tour can show not more than 8 times. We put `-1` when this field is not relevant to this event | :one:
| `notification_state` | [Optional] One of ["show", "hide", "finished"] indicates the current notification bar state. | :one:
| `page` | [Required] One of ["about:newtab", "about:home"]| :one:
| `parent_session_id` | [Required] The unique identifier generated by `gUUIDGenerator` service to identify this event belongs to which parent session. Events happen upon overlay will have the `overlay session uuid` as its `parent_session_id`. Events happen upon notification will have the `notification session uuid` as its `parent_session_id`. | :one:
| `root_session_id` | [Required] The unique identifier generated by `gUUIDGenerator` service to identify this event belongs to which root session. Every event will have the same `onboarding session uuid` as its `root_session_id` when interact in the same tab. | :one:
| `target_tour_id` | [Optional] id of the target switched tour. We put "" when this field is not relevant to this event. | :one:
| `timestamp` | [Required] Timestamp in (integer) milliseconds when the event triggered | :one:
| `tour_type` | [Required] One of ["new", "update"] indicates the user is a `new` user or the `update` user upgrade from the older version | :one:
| `type` | [Required] The type of event. Allowed event strings are defined in the below section | :one:
| `ua` | [Auto populated by Onyx] The user agent string. | :two:
| `ver` | [Auto populated by Onyx] The version of the Onyx API the ping was sent to. | :one:
| `width` | [Required] Current browser window width rounded by 50 pixels. Collecting rounded values reduces the risk to use these values to derive a unique user identifier. | :one:

**Where:**

:one: Firefox data
:two: HTTP protocol data

## Event types

Here are all allowed event `type` strings that defined in `OnboardingTelemetry::EVENT_WHITELIST`.

### Onboarding events

| EVENT | DESCRIPTION |
|-----------|---------------------|
| `onboarding-logo-click` | event is triggered when a user clicks the logo to open the overlay. |
| `onboarding-register-session` | internal event triggered when loading the onboarding module, will not send out any data. |
| `onboarding-session` | event is sent when the tab unload to track the start and end time of the onboarding session. |
| `onboarding-session-begin` | internal event triggered when the onboarding starts, will not send out any data. |
| `onboarding-session-end` | internal event triggered when the onboarding ends, `onboarding-session` event is the actual event that send to the server. |

### Overlay events

| EVENT | DESCRIPTION |
|-----------|---------------------|
| `overlay-close-button-click` | event is triggered when a user clicks close overlay button. |
| `overlay-close-outside-click` | event is triggered when a user clicks outside the overlay area to end the tour. |
| `overlay-cta-click` | event is triggered when a user clicks overlay's Call-To-Action button. |
| `overlay-current-tour` | event is sent when a tour is shown in the overlay. |
| `overlay-nav-click` | event is sent when a user clicks a navigation button in the overlay. |
| `overlay-session` | event is sent when an overlay is closed to track the start and end time of the overlay session. |
| `overlay-session-begin` | internal event triggered when open the overlay, will not send out any data. |
| `overlay-session-end` | internal event is triggered when an overlay session ends. `overlay-session` event is the actual event that send to the server. |
| `overlay-skip-tour` | event is sent when a user clicks `Skip Tour` button in the overlay. |

### Notification events

| EVENT | DESCRIPTION |
|-----------|---------------------|
| `notification-appear` | event is sent when a notification appears. |
| `notification-close-button-click` | event is sent when a user clicks close notification button. |
| `notification-cta-click` | event is sent when a user clicks the notification's Call-To-Action button. |
| `notification-session` | event is sent when user closes the notification  to track the start and end time of the notification session. |
| `notification-session-begin` | internal event triggered when user open the notification, will not send out any data. |
| `notification-session-end` | internal event is triggered when a notification session ends. `notification-session` event is the actual event that send to the server. |
