/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#include <assert.h>

#include "av1/common/common_data.h"
#include "av1/common/scan.h"

#if CONFIG_CHROMA_2X2
DECLARE_ALIGNED(16, static const int16_t, default_scan_2x2[4]) = {
  0, 1, 2, 3,
};
#endif

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x4[16]) = {
  0, 4, 1, 5, 8, 2, 12, 9, 3, 6, 13, 10, 7, 14, 11, 15,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x4[16]) = {
  0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x4[16]) = {
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, col_scan_4x4[16]) = {
  0, 4, 8, 1, 12, 5, 9, 2, 13, 6, 10, 3, 7, 14, 11, 15,
};

DECLARE_ALIGNED(16, static const int16_t, row_scan_4x4[16]) = {
  0, 1, 4, 2, 5, 3, 6, 8, 9, 7, 12, 10, 13, 11, 14, 15,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x8[32]) = {
  0,  1,  4,  5,  2,  8,  6,  9,  10, 3,  12, 7,  13, 11, 14, 16,
  17, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x8[32]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 1, 5, 9,  13, 17, 21, 25, 29,
  2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x8[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x4[32]) = {
  0,  1,  8,  9, 2,  16, 10, 17, 18, 3,  24, 11, 25, 19, 26, 4,
  12, 27, 20, 5, 28, 13, 21, 29, 6,  14, 22, 30, 7,  15, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x4[32]) = {
  0, 8,  16, 24, 1, 9,  17, 25, 2, 10, 18, 26, 3, 11, 19, 27,
  4, 12, 20, 28, 5, 13, 21, 29, 6, 14, 22, 30, 7, 15, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x4[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_4x16[64]) = {
  0,  1,  4,  5,  2,  8,  6,  9,  10, 3,  12, 7,  13, 11, 14, 16,
  17, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x4[64]) = {
  0,  1,  16, 17, 2,  32, 18, 33, 34, 3,  48, 19, 49, 35, 50, 4,
  20, 51, 36, 5,  52, 21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mrow_scan_4x16[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x4[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_4x16[64]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  1, 5, 9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x4[64]) = {
  0,  16, 32, 48, 1,  17, 33, 49, 2,  18, 34, 50, 3,  19, 35, 51,
  4,  20, 36, 52, 5,  21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x32[256]) = {
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 128, 87,  94,  101, 108, 115, 122, 129, 136, 95,  102, 109, 116,
  123, 130, 137, 144, 103, 110, 117, 124, 131, 138, 145, 152, 111, 118, 125,
  132, 139, 146, 153, 160, 119, 126, 133, 140, 147, 154, 161, 168, 127, 134,
  141, 148, 155, 162, 169, 176, 135, 142, 149, 156, 163, 170, 177, 184, 143,
  150, 157, 164, 171, 178, 185, 192, 151, 158, 165, 172, 179, 186, 193, 200,
  159, 166, 173, 180, 187, 194, 201, 208, 167, 174, 181, 188, 195, 202, 209,
  216, 175, 182, 189, 196, 203, 210, 217, 224, 183, 190, 197, 204, 211, 218,
  225, 232, 191, 198, 205, 212, 219, 226, 233, 240, 199, 206, 213, 220, 227,
  234, 241, 248, 207, 214, 221, 228, 235, 242, 249, 215, 222, 229, 236, 243,
  250, 223, 230, 237, 244, 251, 231, 238, 245, 252, 239, 246, 253, 247, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x8[256]) = {
  0,   1,   32,  2,   33,  64,  3,   34,  65,  96,  4,   35,  66,  97,  128,
  5,   36,  67,  98,  129, 160, 6,   37,  68,  99,  130, 161, 192, 7,   38,
  69,  100, 131, 162, 193, 224, 8,   39,  70,  101, 132, 163, 194, 225, 9,
  40,  71,  102, 133, 164, 195, 226, 10,  41,  72,  103, 134, 165, 196, 227,
  11,  42,  73,  104, 135, 166, 197, 228, 12,  43,  74,  105, 136, 167, 198,
  229, 13,  44,  75,  106, 137, 168, 199, 230, 14,  45,  76,  107, 138, 169,
  200, 231, 15,  46,  77,  108, 139, 170, 201, 232, 16,  47,  78,  109, 140,
  171, 202, 233, 17,  48,  79,  110, 141, 172, 203, 234, 18,  49,  80,  111,
  142, 173, 204, 235, 19,  50,  81,  112, 143, 174, 205, 236, 20,  51,  82,
  113, 144, 175, 206, 237, 21,  52,  83,  114, 145, 176, 207, 238, 22,  53,
  84,  115, 146, 177, 208, 239, 23,  54,  85,  116, 147, 178, 209, 240, 24,
  55,  86,  117, 148, 179, 210, 241, 25,  56,  87,  118, 149, 180, 211, 242,
  26,  57,  88,  119, 150, 181, 212, 243, 27,  58,  89,  120, 151, 182, 213,
  244, 28,  59,  90,  121, 152, 183, 214, 245, 29,  60,  91,  122, 153, 184,
  215, 246, 30,  61,  92,  123, 154, 185, 216, 247, 31,  62,  93,  124, 155,
  186, 217, 248, 63,  94,  125, 156, 187, 218, 249, 95,  126, 157, 188, 219,
  250, 127, 158, 189, 220, 251, 159, 190, 221, 252, 191, 222, 253, 223, 254,
  255,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x32[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x8[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x32[256]) = {
  0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96,  104, 112,
  120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232,
  240, 248, 1,   9,   17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  97,
  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193, 201, 209, 217,
  225, 233, 241, 249, 2,   10,  18,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 242, 250, 3,   11,  19,  27,  35,  43,  51,  59,  67,
  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187,
  195, 203, 211, 219, 227, 235, 243, 251, 4,   12,  20,  28,  36,  44,  52,
  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172,
  180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 5,   13,  21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 237, 245, 253, 6,   14,  22,
  30,  38,  46,  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142,
  150, 158, 166, 174, 182, 190, 198, 206, 214, 222, 230, 238, 246, 254, 7,
  15,  23,  31,  39,  47,  55,  63,  71,  79,  87,  95,  103, 111, 119, 127,
  135, 143, 151, 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 239, 247,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x8[256]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 1,  33, 65, 97,  129, 161, 193, 225,
  2,  34, 66, 98,  130, 162, 194, 226, 3,  35, 67, 99,  131, 163, 195, 227,
  4,  36, 68, 100, 132, 164, 196, 228, 5,  37, 69, 101, 133, 165, 197, 229,
  6,  38, 70, 102, 134, 166, 198, 230, 7,  39, 71, 103, 135, 167, 199, 231,
  8,  40, 72, 104, 136, 168, 200, 232, 9,  41, 73, 105, 137, 169, 201, 233,
  10, 42, 74, 106, 138, 170, 202, 234, 11, 43, 75, 107, 139, 171, 203, 235,
  12, 44, 76, 108, 140, 172, 204, 236, 13, 45, 77, 109, 141, 173, 205, 237,
  14, 46, 78, 110, 142, 174, 206, 238, 15, 47, 79, 111, 143, 175, 207, 239,
  16, 48, 80, 112, 144, 176, 208, 240, 17, 49, 81, 113, 145, 177, 209, 241,
  18, 50, 82, 114, 146, 178, 210, 242, 19, 51, 83, 115, 147, 179, 211, 243,
  20, 52, 84, 116, 148, 180, 212, 244, 21, 53, 85, 117, 149, 181, 213, 245,
  22, 54, 86, 118, 150, 182, 214, 246, 23, 55, 87, 119, 151, 183, 215, 247,
  24, 56, 88, 120, 152, 184, 216, 248, 25, 57, 89, 121, 153, 185, 217, 249,
  26, 58, 90, 122, 154, 186, 218, 250, 27, 59, 91, 123, 155, 187, 219, 251,
  28, 60, 92, 124, 156, 188, 220, 252, 29, 61, 93, 125, 157, 189, 221, 253,
  30, 62, 94, 126, 158, 190, 222, 254, 31, 63, 95, 127, 159, 191, 223, 255,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x8[64]) = {
  0,  8,  1,  16, 9,  2,  17, 24, 10, 3,  18, 25, 32, 11, 4,  26,
  33, 19, 40, 12, 34, 27, 5,  41, 20, 48, 13, 35, 42, 28, 21, 6,
  49, 56, 36, 43, 29, 7,  14, 50, 57, 44, 22, 37, 15, 51, 58, 30,
  45, 23, 52, 59, 38, 31, 60, 53, 46, 39, 61, 54, 47, 62, 55, 63,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x8[64]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 1, 9,  17, 25, 33, 41, 49, 57,
  2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
  4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
  6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x8[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, col_scan_8x8[64]) = {
  0,  8,  16, 1,  24, 9,  32, 17, 2,  40, 25, 10, 33, 18, 48, 3,
  26, 41, 11, 56, 19, 34, 4,  49, 27, 42, 12, 35, 20, 57, 50, 28,
  5,  43, 13, 36, 58, 51, 21, 44, 6,  29, 59, 37, 14, 52, 22, 7,
  45, 60, 30, 15, 38, 53, 23, 46, 31, 61, 39, 54, 47, 62, 55, 63,
};

DECLARE_ALIGNED(16, static const int16_t, row_scan_8x8[64]) = {
  0,  1,  2,  8,  9,  3,  16, 10, 4,  17, 11, 24, 5,  18, 25, 12,
  19, 26, 32, 6,  13, 20, 33, 27, 7,  34, 40, 21, 28, 41, 14, 35,
  48, 42, 29, 36, 49, 22, 43, 15, 56, 37, 50, 44, 30, 57, 23, 51,
  58, 45, 38, 52, 31, 59, 53, 46, 60, 39, 61, 47, 54, 55, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_8x16[128]) = {
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 87,  94,  101, 108, 115, 122, 95,  102, 109, 116, 123, 103, 110,
  117, 124, 111, 118, 125, 119, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x8[128]) = {
  0,   1,  16,  2,   17,  32,  3,  18, 33,  48,  4,   19,  34,  49,  64,  5,
  20,  35, 50,  65,  80,  6,   21, 36, 51,  66,  81,  96,  7,   22,  37,  52,
  67,  82, 97,  112, 8,   23,  38, 53, 68,  83,  98,  113, 9,   24,  39,  54,
  69,  84, 99,  114, 10,  25,  40, 55, 70,  85,  100, 115, 11,  26,  41,  56,
  71,  86, 101, 116, 12,  27,  42, 57, 72,  87,  102, 117, 13,  28,  43,  58,
  73,  88, 103, 118, 14,  29,  44, 59, 74,  89,  104, 119, 15,  30,  45,  60,
  75,  90, 105, 120, 31,  46,  61, 76, 91,  106, 121, 47,  62,  77,  92,  107,
  122, 63, 78,  93,  108, 123, 79, 94, 109, 124, 95,  110, 125, 111, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_8x16[128]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96,  104, 112, 120,
  1, 9,  17, 25, 33, 41, 49, 57, 65, 73, 81, 89, 97,  105, 113, 121,
  2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98,  106, 114, 122,
  3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 99,  107, 115, 123,
  4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 108, 116, 124,
  5, 13, 21, 29, 37, 45, 53, 61, 69, 77, 85, 93, 101, 109, 117, 125,
  6, 14, 22, 30, 38, 46, 54, 62, 70, 78, 86, 94, 102, 110, 118, 126,
  7, 15, 23, 31, 39, 47, 55, 63, 71, 79, 87, 95, 103, 111, 119, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x8[128]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 1,  17, 33, 49, 65, 81, 97,  113,
  2,  18, 34, 50, 66, 82, 98,  114, 3,  19, 35, 51, 67, 83, 99,  115,
  4,  20, 36, 52, 68, 84, 100, 116, 5,  21, 37, 53, 69, 85, 101, 117,
  6,  22, 38, 54, 70, 86, 102, 118, 7,  23, 39, 55, 71, 87, 103, 119,
  8,  24, 40, 56, 72, 88, 104, 120, 9,  25, 41, 57, 73, 89, 105, 121,
  10, 26, 42, 58, 74, 90, 106, 122, 11, 27, 43, 59, 75, 91, 107, 123,
  12, 28, 44, 60, 76, 92, 108, 124, 13, 29, 45, 61, 77, 93, 109, 125,
  14, 30, 46, 62, 78, 94, 110, 126, 15, 31, 47, 63, 79, 95, 111, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_8x16[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x8[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x32[512]) = {
  0,   1,   16,  2,   17,  32,  3,   18,  33,  48,  4,   19,  34,  49,  64,
  5,   20,  35,  50,  65,  80,  6,   21,  36,  51,  66,  81,  96,  7,   22,
  37,  52,  67,  82,  97,  112, 8,   23,  38,  53,  68,  83,  98,  113, 128,
  9,   24,  39,  54,  69,  84,  99,  114, 129, 144, 10,  25,  40,  55,  70,
  85,  100, 115, 130, 145, 160, 11,  26,  41,  56,  71,  86,  101, 116, 131,
  146, 161, 176, 12,  27,  42,  57,  72,  87,  102, 117, 132, 147, 162, 177,
  192, 13,  28,  43,  58,  73,  88,  103, 118, 133, 148, 163, 178, 193, 208,
  14,  29,  44,  59,  74,  89,  104, 119, 134, 149, 164, 179, 194, 209, 224,
  15,  30,  45,  60,  75,  90,  105, 120, 135, 150, 165, 180, 195, 210, 225,
  240, 31,  46,  61,  76,  91,  106, 121, 136, 151, 166, 181, 196, 211, 226,
  241, 256, 47,  62,  77,  92,  107, 122, 137, 152, 167, 182, 197, 212, 227,
  242, 257, 272, 63,  78,  93,  108, 123, 138, 153, 168, 183, 198, 213, 228,
  243, 258, 273, 288, 79,  94,  109, 124, 139, 154, 169, 184, 199, 214, 229,
  244, 259, 274, 289, 304, 95,  110, 125, 140, 155, 170, 185, 200, 215, 230,
  245, 260, 275, 290, 305, 320, 111, 126, 141, 156, 171, 186, 201, 216, 231,
  246, 261, 276, 291, 306, 321, 336, 127, 142, 157, 172, 187, 202, 217, 232,
  247, 262, 277, 292, 307, 322, 337, 352, 143, 158, 173, 188, 203, 218, 233,
  248, 263, 278, 293, 308, 323, 338, 353, 368, 159, 174, 189, 204, 219, 234,
  249, 264, 279, 294, 309, 324, 339, 354, 369, 384, 175, 190, 205, 220, 235,
  250, 265, 280, 295, 310, 325, 340, 355, 370, 385, 400, 191, 206, 221, 236,
  251, 266, 281, 296, 311, 326, 341, 356, 371, 386, 401, 416, 207, 222, 237,
  252, 267, 282, 297, 312, 327, 342, 357, 372, 387, 402, 417, 432, 223, 238,
  253, 268, 283, 298, 313, 328, 343, 358, 373, 388, 403, 418, 433, 448, 239,
  254, 269, 284, 299, 314, 329, 344, 359, 374, 389, 404, 419, 434, 449, 464,
  255, 270, 285, 300, 315, 330, 345, 360, 375, 390, 405, 420, 435, 450, 465,
  480, 271, 286, 301, 316, 331, 346, 361, 376, 391, 406, 421, 436, 451, 466,
  481, 496, 287, 302, 317, 332, 347, 362, 377, 392, 407, 422, 437, 452, 467,
  482, 497, 303, 318, 333, 348, 363, 378, 393, 408, 423, 438, 453, 468, 483,
  498, 319, 334, 349, 364, 379, 394, 409, 424, 439, 454, 469, 484, 499, 335,
  350, 365, 380, 395, 410, 425, 440, 455, 470, 485, 500, 351, 366, 381, 396,
  411, 426, 441, 456, 471, 486, 501, 367, 382, 397, 412, 427, 442, 457, 472,
  487, 502, 383, 398, 413, 428, 443, 458, 473, 488, 503, 399, 414, 429, 444,
  459, 474, 489, 504, 415, 430, 445, 460, 475, 490, 505, 431, 446, 461, 476,
  491, 506, 447, 462, 477, 492, 507, 463, 478, 493, 508, 479, 494, 509, 495,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x16[512]) = {
  0,   1,   32,  2,   33,  64,  3,   34,  65,  96,  4,   35,  66,  97,  128,
  5,   36,  67,  98,  129, 160, 6,   37,  68,  99,  130, 161, 192, 7,   38,
  69,  100, 131, 162, 193, 224, 8,   39,  70,  101, 132, 163, 194, 225, 256,
  9,   40,  71,  102, 133, 164, 195, 226, 257, 288, 10,  41,  72,  103, 134,
  165, 196, 227, 258, 289, 320, 11,  42,  73,  104, 135, 166, 197, 228, 259,
  290, 321, 352, 12,  43,  74,  105, 136, 167, 198, 229, 260, 291, 322, 353,
  384, 13,  44,  75,  106, 137, 168, 199, 230, 261, 292, 323, 354, 385, 416,
  14,  45,  76,  107, 138, 169, 200, 231, 262, 293, 324, 355, 386, 417, 448,
  15,  46,  77,  108, 139, 170, 201, 232, 263, 294, 325, 356, 387, 418, 449,
  480, 16,  47,  78,  109, 140, 171, 202, 233, 264, 295, 326, 357, 388, 419,
  450, 481, 17,  48,  79,  110, 141, 172, 203, 234, 265, 296, 327, 358, 389,
  420, 451, 482, 18,  49,  80,  111, 142, 173, 204, 235, 266, 297, 328, 359,
  390, 421, 452, 483, 19,  50,  81,  112, 143, 174, 205, 236, 267, 298, 329,
  360, 391, 422, 453, 484, 20,  51,  82,  113, 144, 175, 206, 237, 268, 299,
  330, 361, 392, 423, 454, 485, 21,  52,  83,  114, 145, 176, 207, 238, 269,
  300, 331, 362, 393, 424, 455, 486, 22,  53,  84,  115, 146, 177, 208, 239,
  270, 301, 332, 363, 394, 425, 456, 487, 23,  54,  85,  116, 147, 178, 209,
  240, 271, 302, 333, 364, 395, 426, 457, 488, 24,  55,  86,  117, 148, 179,
  210, 241, 272, 303, 334, 365, 396, 427, 458, 489, 25,  56,  87,  118, 149,
  180, 211, 242, 273, 304, 335, 366, 397, 428, 459, 490, 26,  57,  88,  119,
  150, 181, 212, 243, 274, 305, 336, 367, 398, 429, 460, 491, 27,  58,  89,
  120, 151, 182, 213, 244, 275, 306, 337, 368, 399, 430, 461, 492, 28,  59,
  90,  121, 152, 183, 214, 245, 276, 307, 338, 369, 400, 431, 462, 493, 29,
  60,  91,  122, 153, 184, 215, 246, 277, 308, 339, 370, 401, 432, 463, 494,
  30,  61,  92,  123, 154, 185, 216, 247, 278, 309, 340, 371, 402, 433, 464,
  495, 31,  62,  93,  124, 155, 186, 217, 248, 279, 310, 341, 372, 403, 434,
  465, 496, 63,  94,  125, 156, 187, 218, 249, 280, 311, 342, 373, 404, 435,
  466, 497, 95,  126, 157, 188, 219, 250, 281, 312, 343, 374, 405, 436, 467,
  498, 127, 158, 189, 220, 251, 282, 313, 344, 375, 406, 437, 468, 499, 159,
  190, 221, 252, 283, 314, 345, 376, 407, 438, 469, 500, 191, 222, 253, 284,
  315, 346, 377, 408, 439, 470, 501, 223, 254, 285, 316, 347, 378, 409, 440,
  471, 502, 255, 286, 317, 348, 379, 410, 441, 472, 503, 287, 318, 349, 380,
  411, 442, 473, 504, 319, 350, 381, 412, 443, 474, 505, 351, 382, 413, 444,
  475, 506, 383, 414, 445, 476, 507, 415, 446, 477, 508, 447, 478, 509, 479,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x32[512]) = {
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464,
  480, 496, 1,   17,  33,  49,  65,  81,  97,  113, 129, 145, 161, 177, 193,
  209, 225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433,
  449, 465, 481, 497, 2,   18,  34,  50,  66,  82,  98,  114, 130, 146, 162,
  178, 194, 210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 402,
  418, 434, 450, 466, 482, 498, 3,   19,  35,  51,  67,  83,  99,  115, 131,
  147, 163, 179, 195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371,
  387, 403, 419, 435, 451, 467, 483, 499, 4,   20,  36,  52,  68,  84,  100,
  116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340,
  356, 372, 388, 404, 420, 436, 452, 468, 484, 500, 5,   21,  37,  53,  69,
  85,  101, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309,
  325, 341, 357, 373, 389, 405, 421, 437, 453, 469, 485, 501, 6,   22,  38,
  54,  70,  86,  102, 118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278,
  294, 310, 326, 342, 358, 374, 390, 406, 422, 438, 454, 470, 486, 502, 7,
  23,  39,  55,  71,  87,  103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  263, 279, 295, 311, 327, 343, 359, 375, 391, 407, 423, 439, 455, 471, 487,
  503, 8,   24,  40,  56,  72,  88,  104, 120, 136, 152, 168, 184, 200, 216,
  232, 248, 264, 280, 296, 312, 328, 344, 360, 376, 392, 408, 424, 440, 456,
  472, 488, 504, 9,   25,  41,  57,  73,  89,  105, 121, 137, 153, 169, 185,
  201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361, 377, 393, 409, 425,
  441, 457, 473, 489, 505, 10,  26,  42,  58,  74,  90,  106, 122, 138, 154,
  170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378, 394,
  410, 426, 442, 458, 474, 490, 506, 11,  27,  43,  59,  75,  91,  107, 123,
  139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363,
  379, 395, 411, 427, 443, 459, 475, 491, 507, 12,  28,  44,  60,  76,  92,
  108, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284, 300, 316, 332,
  348, 364, 380, 396, 412, 428, 444, 460, 476, 492, 508, 13,  29,  45,  61,
  77,  93,  109, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269, 285, 301,
  317, 333, 349, 365, 381, 397, 413, 429, 445, 461, 477, 493, 509, 14,  30,
  46,  62,  78,  94,  110, 126, 142, 158, 174, 190, 206, 222, 238, 254, 270,
  286, 302, 318, 334, 350, 366, 382, 398, 414, 430, 446, 462, 478, 494, 510,
  15,  31,  47,  63,  79,  95,  111, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479,
  495, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x16[512]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480,
  1,  33, 65, 97,  129, 161, 193, 225, 257, 289, 321, 353, 385, 417, 449, 481,
  2,  34, 66, 98,  130, 162, 194, 226, 258, 290, 322, 354, 386, 418, 450, 482,
  3,  35, 67, 99,  131, 163, 195, 227, 259, 291, 323, 355, 387, 419, 451, 483,
  4,  36, 68, 100, 132, 164, 196, 228, 260, 292, 324, 356, 388, 420, 452, 484,
  5,  37, 69, 101, 133, 165, 197, 229, 261, 293, 325, 357, 389, 421, 453, 485,
  6,  38, 70, 102, 134, 166, 198, 230, 262, 294, 326, 358, 390, 422, 454, 486,
  7,  39, 71, 103, 135, 167, 199, 231, 263, 295, 327, 359, 391, 423, 455, 487,
  8,  40, 72, 104, 136, 168, 200, 232, 264, 296, 328, 360, 392, 424, 456, 488,
  9,  41, 73, 105, 137, 169, 201, 233, 265, 297, 329, 361, 393, 425, 457, 489,
  10, 42, 74, 106, 138, 170, 202, 234, 266, 298, 330, 362, 394, 426, 458, 490,
  11, 43, 75, 107, 139, 171, 203, 235, 267, 299, 331, 363, 395, 427, 459, 491,
  12, 44, 76, 108, 140, 172, 204, 236, 268, 300, 332, 364, 396, 428, 460, 492,
  13, 45, 77, 109, 141, 173, 205, 237, 269, 301, 333, 365, 397, 429, 461, 493,
  14, 46, 78, 110, 142, 174, 206, 238, 270, 302, 334, 366, 398, 430, 462, 494,
  15, 47, 79, 111, 143, 175, 207, 239, 271, 303, 335, 367, 399, 431, 463, 495,
  16, 48, 80, 112, 144, 176, 208, 240, 272, 304, 336, 368, 400, 432, 464, 496,
  17, 49, 81, 113, 145, 177, 209, 241, 273, 305, 337, 369, 401, 433, 465, 497,
  18, 50, 82, 114, 146, 178, 210, 242, 274, 306, 338, 370, 402, 434, 466, 498,
  19, 51, 83, 115, 147, 179, 211, 243, 275, 307, 339, 371, 403, 435, 467, 499,
  20, 52, 84, 116, 148, 180, 212, 244, 276, 308, 340, 372, 404, 436, 468, 500,
  21, 53, 85, 117, 149, 181, 213, 245, 277, 309, 341, 373, 405, 437, 469, 501,
  22, 54, 86, 118, 150, 182, 214, 246, 278, 310, 342, 374, 406, 438, 470, 502,
  23, 55, 87, 119, 151, 183, 215, 247, 279, 311, 343, 375, 407, 439, 471, 503,
  24, 56, 88, 120, 152, 184, 216, 248, 280, 312, 344, 376, 408, 440, 472, 504,
  25, 57, 89, 121, 153, 185, 217, 249, 281, 313, 345, 377, 409, 441, 473, 505,
  26, 58, 90, 122, 154, 186, 218, 250, 282, 314, 346, 378, 410, 442, 474, 506,
  27, 59, 91, 123, 155, 187, 219, 251, 283, 315, 347, 379, 411, 443, 475, 507,
  28, 60, 92, 124, 156, 188, 220, 252, 284, 316, 348, 380, 412, 444, 476, 508,
  29, 61, 93, 125, 157, 189, 221, 253, 285, 317, 349, 381, 413, 445, 477, 509,
  30, 62, 94, 126, 158, 190, 222, 254, 286, 318, 350, 382, 414, 446, 478, 510,
  31, 63, 95, 127, 159, 191, 223, 255, 287, 319, 351, 383, 415, 447, 479, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x32[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x16[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_16x16[256]) = {
  0,   16,  1,   32,  17,  2,   48,  33,  18,  3,   64,  34,  49,  19,  65,
  80,  50,  4,   35,  66,  20,  81,  96,  51,  5,   36,  82,  97,  67,  112,
  21,  52,  98,  37,  83,  113, 6,   68,  128, 53,  22,  99,  114, 84,  7,
  129, 38,  69,  100, 115, 144, 130, 85,  54,  23,  8,   145, 39,  70,  116,
  101, 131, 160, 146, 55,  86,  24,  71,  132, 117, 161, 40,  9,   102, 147,
  176, 162, 87,  56,  25,  133, 118, 177, 148, 72,  103, 41,  163, 10,  192,
  178, 88,  57,  134, 149, 119, 26,  164, 73,  104, 193, 42,  179, 208, 11,
  135, 89,  165, 120, 150, 58,  194, 180, 27,  74,  209, 105, 151, 136, 43,
  90,  224, 166, 195, 181, 121, 210, 59,  12,  152, 106, 167, 196, 75,  137,
  225, 211, 240, 182, 122, 91,  28,  197, 13,  226, 168, 183, 153, 44,  212,
  138, 107, 241, 60,  29,  123, 198, 184, 227, 169, 242, 76,  213, 154, 45,
  92,  14,  199, 139, 61,  228, 214, 170, 185, 243, 108, 77,  155, 30,  15,
  200, 229, 124, 215, 244, 93,  46,  186, 171, 201, 109, 140, 230, 62,  216,
  245, 31,  125, 78,  156, 231, 47,  187, 202, 217, 94,  246, 141, 63,  232,
  172, 110, 247, 157, 79,  218, 203, 126, 233, 188, 248, 95,  173, 142, 219,
  111, 249, 234, 158, 127, 189, 204, 250, 235, 143, 174, 220, 205, 159, 251,
  190, 221, 175, 236, 237, 191, 206, 252, 222, 253, 207, 238, 223, 254, 239,
  255,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mcol_scan_16x16[256]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  1,  17, 33, 49, 65, 81, 97,  113, 129, 145, 161, 177, 193, 209, 225, 241,
  2,  18, 34, 50, 66, 82, 98,  114, 130, 146, 162, 178, 194, 210, 226, 242,
  3,  19, 35, 51, 67, 83, 99,  115, 131, 147, 163, 179, 195, 211, 227, 243,
  4,  20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244,
  5,  21, 37, 53, 69, 85, 101, 117, 133, 149, 165, 181, 197, 213, 229, 245,
  6,  22, 38, 54, 70, 86, 102, 118, 134, 150, 166, 182, 198, 214, 230, 246,
  7,  23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  8,  24, 40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232, 248,
  9,  25, 41, 57, 73, 89, 105, 121, 137, 153, 169, 185, 201, 217, 233, 249,
  10, 26, 42, 58, 74, 90, 106, 122, 138, 154, 170, 186, 202, 218, 234, 250,
  11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251,
  12, 28, 44, 60, 76, 92, 108, 124, 140, 156, 172, 188, 204, 220, 236, 252,
  13, 29, 45, 61, 77, 93, 109, 125, 141, 157, 173, 189, 205, 221, 237, 253,
  14, 30, 46, 62, 78, 94, 110, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_16x16[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, col_scan_16x16[256]) = {
  0,   16,  32,  48,  1,   64,  17,  80,  33,  96,  49,  2,   65,  112, 18,
  81,  34,  128, 50,  97,  3,   66,  144, 19,  113, 35,  82,  160, 98,  51,
  129, 4,   67,  176, 20,  114, 145, 83,  36,  99,  130, 52,  192, 5,   161,
  68,  115, 21,  146, 84,  208, 177, 37,  131, 100, 53,  162, 224, 69,  6,
  116, 193, 147, 85,  22,  240, 132, 38,  178, 101, 163, 54,  209, 117, 70,
  7,   148, 194, 86,  179, 225, 23,  133, 39,  164, 8,   102, 210, 241, 55,
  195, 118, 149, 71,  180, 24,  87,  226, 134, 165, 211, 40,  103, 56,  72,
  150, 196, 242, 119, 9,   181, 227, 88,  166, 25,  135, 41,  104, 212, 57,
  151, 197, 120, 73,  243, 182, 136, 167, 213, 89,  10,  228, 105, 152, 198,
  26,  42,  121, 183, 244, 168, 58,  137, 229, 74,  214, 90,  153, 199, 184,
  11,  106, 245, 27,  122, 230, 169, 43,  215, 59,  200, 138, 185, 246, 75,
  12,  91,  154, 216, 231, 107, 28,  44,  201, 123, 170, 60,  247, 232, 76,
  139, 13,  92,  217, 186, 248, 155, 108, 29,  124, 45,  202, 233, 171, 61,
  14,  77,  140, 15,  249, 93,  30,  187, 156, 218, 46,  109, 125, 62,  172,
  78,  203, 31,  141, 234, 94,  47,  188, 63,  157, 110, 250, 219, 79,  126,
  204, 173, 142, 95,  189, 111, 235, 158, 220, 251, 127, 174, 143, 205, 236,
  159, 190, 221, 252, 175, 206, 237, 191, 253, 222, 238, 207, 254, 223, 239,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, row_scan_16x16[256]) = {
  0,   1,   2,   16,  3,   17,  4,   18,  32,  5,   33,  19,  6,   34,  48,
  20,  49,  7,   35,  21,  50,  64,  8,   36,  65,  22,  51,  37,  80,  9,
  66,  52,  23,  38,  81,  67,  10,  53,  24,  82,  68,  96,  39,  11,  54,
  83,  97,  69,  25,  98,  84,  40,  112, 55,  12,  70,  99,  113, 85,  26,
  41,  56,  114, 100, 13,  71,  128, 86,  27,  115, 101, 129, 42,  57,  72,
  116, 14,  87,  130, 102, 144, 73,  131, 117, 28,  58,  15,  88,  43,  145,
  103, 132, 146, 118, 74,  160, 89,  133, 104, 29,  59,  147, 119, 44,  161,
  148, 90,  105, 134, 162, 120, 176, 75,  135, 149, 30,  60,  163, 177, 45,
  121, 91,  106, 164, 178, 150, 192, 136, 165, 179, 31,  151, 193, 76,  122,
  61,  137, 194, 107, 152, 180, 208, 46,  166, 167, 195, 92,  181, 138, 209,
  123, 153, 224, 196, 77,  168, 210, 182, 240, 108, 197, 62,  154, 225, 183,
  169, 211, 47,  139, 93,  184, 226, 212, 241, 198, 170, 124, 155, 199, 78,
  213, 185, 109, 227, 200, 63,  228, 242, 140, 214, 171, 186, 156, 229, 243,
  125, 94,  201, 244, 215, 216, 230, 141, 187, 202, 79,  172, 110, 157, 245,
  217, 231, 95,  246, 232, 126, 203, 247, 233, 173, 218, 142, 111, 158, 188,
  248, 127, 234, 219, 249, 189, 204, 143, 174, 159, 250, 235, 205, 220, 175,
  190, 251, 221, 191, 206, 236, 207, 237, 252, 222, 253, 223, 238, 239, 254,
  255,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, mcol_scan_32x32[1024]) = {
  0,   32,   64,  96,   128, 160,  192, 224,  256, 288,  320, 352,  384, 416,
  448, 480,  512, 544,  576, 608,  640, 672,  704, 736,  768, 800,  832, 864,
  896, 928,  960, 992,  1,   33,   65,  97,   129, 161,  193, 225,  257, 289,
  321, 353,  385, 417,  449, 481,  513, 545,  577, 609,  641, 673,  705, 737,
  769, 801,  833, 865,  897, 929,  961, 993,  2,   34,   66,  98,   130, 162,
  194, 226,  258, 290,  322, 354,  386, 418,  450, 482,  514, 546,  578, 610,
  642, 674,  706, 738,  770, 802,  834, 866,  898, 930,  962, 994,  3,   35,
  67,  99,   131, 163,  195, 227,  259, 291,  323, 355,  387, 419,  451, 483,
  515, 547,  579, 611,  643, 675,  707, 739,  771, 803,  835, 867,  899, 931,
  963, 995,  4,   36,   68,  100,  132, 164,  196, 228,  260, 292,  324, 356,
  388, 420,  452, 484,  516, 548,  580, 612,  644, 676,  708, 740,  772, 804,
  836, 868,  900, 932,  964, 996,  5,   37,   69,  101,  133, 165,  197, 229,
  261, 293,  325, 357,  389, 421,  453, 485,  517, 549,  581, 613,  645, 677,
  709, 741,  773, 805,  837, 869,  901, 933,  965, 997,  6,   38,   70,  102,
  134, 166,  198, 230,  262, 294,  326, 358,  390, 422,  454, 486,  518, 550,
  582, 614,  646, 678,  710, 742,  774, 806,  838, 870,  902, 934,  966, 998,
  7,   39,   71,  103,  135, 167,  199, 231,  263, 295,  327, 359,  391, 423,
  455, 487,  519, 551,  583, 615,  647, 679,  711, 743,  775, 807,  839, 871,
  903, 935,  967, 999,  8,   40,   72,  104,  136, 168,  200, 232,  264, 296,
  328, 360,  392, 424,  456, 488,  520, 552,  584, 616,  648, 680,  712, 744,
  776, 808,  840, 872,  904, 936,  968, 1000, 9,   41,   73,  105,  137, 169,
  201, 233,  265, 297,  329, 361,  393, 425,  457, 489,  521, 553,  585, 617,
  649, 681,  713, 745,  777, 809,  841, 873,  905, 937,  969, 1001, 10,  42,
  74,  106,  138, 170,  202, 234,  266, 298,  330, 362,  394, 426,  458, 490,
  522, 554,  586, 618,  650, 682,  714, 746,  778, 810,  842, 874,  906, 938,
  970, 1002, 11,  43,   75,  107,  139, 171,  203, 235,  267, 299,  331, 363,
  395, 427,  459, 491,  523, 555,  587, 619,  651, 683,  715, 747,  779, 811,
  843, 875,  907, 939,  971, 1003, 12,  44,   76,  108,  140, 172,  204, 236,
  268, 300,  332, 364,  396, 428,  460, 492,  524, 556,  588, 620,  652, 684,
  716, 748,  780, 812,  844, 876,  908, 940,  972, 1004, 13,  45,   77,  109,
  141, 173,  205, 237,  269, 301,  333, 365,  397, 429,  461, 493,  525, 557,
  589, 621,  653, 685,  717, 749,  781, 813,  845, 877,  909, 941,  973, 1005,
  14,  46,   78,  110,  142, 174,  206, 238,  270, 302,  334, 366,  398, 430,
  462, 494,  526, 558,  590, 622,  654, 686,  718, 750,  782, 814,  846, 878,
  910, 942,  974, 1006, 15,  47,   79,  111,  143, 175,  207, 239,  271, 303,
  335, 367,  399, 431,  463, 495,  527, 559,  591, 623,  655, 687,  719, 751,
  783, 815,  847, 879,  911, 943,  975, 1007, 16,  48,   80,  112,  144, 176,
  208, 240,  272, 304,  336, 368,  400, 432,  464, 496,  528, 560,  592, 624,
  656, 688,  720, 752,  784, 816,  848, 880,  912, 944,  976, 1008, 17,  49,
  81,  113,  145, 177,  209, 241,  273, 305,  337, 369,  401, 433,  465, 497,
  529, 561,  593, 625,  657, 689,  721, 753,  785, 817,  849, 881,  913, 945,
  977, 1009, 18,  50,   82,  114,  146, 178,  210, 242,  274, 306,  338, 370,
  402, 434,  466, 498,  530, 562,  594, 626,  658, 690,  722, 754,  786, 818,
  850, 882,  914, 946,  978, 1010, 19,  51,   83,  115,  147, 179,  211, 243,
  275, 307,  339, 371,  403, 435,  467, 499,  531, 563,  595, 627,  659, 691,
  723, 755,  787, 819,  851, 883,  915, 947,  979, 1011, 20,  52,   84,  116,
  148, 180,  212, 244,  276, 308,  340, 372,  404, 436,  468, 500,  532, 564,
  596, 628,  660, 692,  724, 756,  788, 820,  852, 884,  916, 948,  980, 1012,
  21,  53,   85,  117,  149, 181,  213, 245,  277, 309,  341, 373,  405, 437,
  469, 501,  533, 565,  597, 629,  661, 693,  725, 757,  789, 821,  853, 885,
  917, 949,  981, 1013, 22,  54,   86,  118,  150, 182,  214, 246,  278, 310,
  342, 374,  406, 438,  470, 502,  534, 566,  598, 630,  662, 694,  726, 758,
  790, 822,  854, 886,  918, 950,  982, 1014, 23,  55,   87,  119,  151, 183,
  215, 247,  279, 311,  343, 375,  407, 439,  471, 503,  535, 567,  599, 631,
  663, 695,  727, 759,  791, 823,  855, 887,  919, 951,  983, 1015, 24,  56,
  88,  120,  152, 184,  216, 248,  280, 312,  344, 376,  408, 440,  472, 504,
  536, 568,  600, 632,  664, 696,  728, 760,  792, 824,  856, 888,  920, 952,
  984, 1016, 25,  57,   89,  121,  153, 185,  217, 249,  281, 313,  345, 377,
  409, 441,  473, 505,  537, 569,  601, 633,  665, 697,  729, 761,  793, 825,
  857, 889,  921, 953,  985, 1017, 26,  58,   90,  122,  154, 186,  218, 250,
  282, 314,  346, 378,  410, 442,  474, 506,  538, 570,  602, 634,  666, 698,
  730, 762,  794, 826,  858, 890,  922, 954,  986, 1018, 27,  59,   91,  123,
  155, 187,  219, 251,  283, 315,  347, 379,  411, 443,  475, 507,  539, 571,
  603, 635,  667, 699,  731, 763,  795, 827,  859, 891,  923, 955,  987, 1019,
  28,  60,   92,  124,  156, 188,  220, 252,  284, 316,  348, 380,  412, 444,
  476, 508,  540, 572,  604, 636,  668, 700,  732, 764,  796, 828,  860, 892,
  924, 956,  988, 1020, 29,  61,   93,  125,  157, 189,  221, 253,  285, 317,
  349, 381,  413, 445,  477, 509,  541, 573,  605, 637,  669, 701,  733, 765,
  797, 829,  861, 893,  925, 957,  989, 1021, 30,  62,   94,  126,  158, 190,
  222, 254,  286, 318,  350, 382,  414, 446,  478, 510,  542, 574,  606, 638,
  670, 702,  734, 766,  798, 830,  862, 894,  926, 958,  990, 1022, 31,  63,
  95,  127,  159, 191,  223, 255,  287, 319,  351, 383,  415, 447,  479, 511,
  543, 575,  607, 639,  671, 703,  735, 767,  799, 831,  863, 895,  927, 959,
  991, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, mrow_scan_32x32[1024]) = {
  0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,
  13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
  26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
  39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
  52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
  65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
  78,   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
  91,   92,   93,   94,   95,   96,   97,   98,   99,   100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,
  156,  157,  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,  168,
  169,  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
  208,  209,  210,  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  249,  250,  251,  252,  253,  254,  255,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  420,  421,  422,  423,  424,  425,  426,  427,  428,
  429,  430,  431,  432,  433,  434,  435,  436,  437,  438,  439,  440,  441,
  442,  443,  444,  445,  446,  447,  448,  449,  450,  451,  452,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,  465,  466,  467,
  468,  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,  479,  480,
  481,  482,  483,  484,  485,  486,  487,  488,  489,  490,  491,  492,  493,
  494,  495,  496,  497,  498,  499,  500,  501,  502,  503,  504,  505,  506,
  507,  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,  518,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,  532,
  533,  534,  535,  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  551,  552,  553,  554,  555,  556,  557,  558,
  559,  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,  573,  574,  575,  576,  577,  578,  579,  580,  581,  582,  583,  584,
  585,  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,  610,
  611,  612,  613,  614,  615,  616,  617,  618,  619,  620,  621,  622,  623,
  624,  625,  626,  627,  628,  629,  630,  631,  632,  633,  634,  635,  636,
  637,  638,  639,  640,  641,  642,  643,  644,  645,  646,  647,  648,  649,
  650,  651,  652,  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
  676,  677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,
  689,  690,  691,  692,  693,  694,  695,  696,  697,  698,  699,  700,  701,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,  712,  713,  714,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,  727,
  728,  729,  730,  731,  732,  733,  734,  735,  736,  737,  738,  739,  740,
  741,  742,  743,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,
  754,  755,  756,  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  767,  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,  778,  779,
  780,  781,  782,  783,  784,  785,  786,  787,  788,  789,  790,  791,  792,
  793,  794,  795,  796,  797,  798,  799,  800,  801,  802,  803,  804,  805,
  806,  807,  808,  809,  810,  811,  812,  813,  814,  815,  816,  817,  818,
  819,  820,  821,  822,  823,  824,  825,  826,  827,  828,  829,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,  842,  843,  844,
  845,  846,  847,  848,  849,  850,  851,  852,  853,  854,  855,  856,  857,
  858,  859,  860,  861,  862,  863,  864,  865,  866,  867,  868,  869,  870,
  871,  872,  873,  874,  875,  876,  877,  878,  879,  880,  881,  882,  883,
  884,  885,  886,  887,  888,  889,  890,  891,  892,  893,  894,  895,  896,
  897,  898,  899,  900,  901,  902,  903,  904,  905,  906,  907,  908,  909,
  910,  911,  912,  913,  914,  915,  916,  917,  918,  919,  920,  921,  922,
  923,  924,  925,  926,  927,  928,  929,  930,  931,  932,  933,  934,  935,
  936,  937,  938,  939,  940,  941,  942,  943,  944,  945,  946,  947,  948,
  949,  950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,
  962,  963,  964,  965,  966,  967,  968,  969,  970,  971,  972,  973,  974,
  975,  976,  977,  978,  979,  980,  981,  982,  983,  984,  985,  986,  987,
  988,  989,  990,  991,  992,  993,  994,  995,  996,  997,  998,  999,  1000,
  1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
  1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, default_scan_32x32[1024]) = {
  0,    32,   1,    64,  33,   2,    96,   65,   34,   128,  3,    97,   66,
  160,  129,  35,   98,  4,    67,   130,  161,  192,  36,   99,   224,  5,
  162,  193,  68,   131, 37,   100,  225,  194,  256,  163,  69,   132,  6,
  226,  257,  288,  195, 101,  164,  38,   258,  7,    227,  289,  133,  320,
  70,   196,  165,  290, 259,  228,  39,   321,  102,  352,  8,    197,  71,
  134,  322,  291,  260, 353,  384,  229,  166,  103,  40,   354,  323,  292,
  135,  385,  198,  261, 72,   9,    416,  167,  386,  355,  230,  324,  104,
  293,  41,   417,  199, 136,  262,  387,  448,  325,  356,  10,   73,   418,
  231,  168,  449,  294, 388,  105,  419,  263,  42,   200,  357,  450,  137,
  480,  74,   326,  232, 11,   389,  169,  295,  420,  106,  451,  481,  358,
  264,  327,  201,  43,  138,  512,  482,  390,  296,  233,  170,  421,  75,
  452,  359,  12,   513, 265,  483,  328,  107,  202,  514,  544,  422,  391,
  453,  139,  44,   234, 484,  297,  360,  171,  76,   515,  545,  266,  329,
  454,  13,   423,  203, 108,  546,  485,  576,  298,  235,  140,  361,  330,
  172,  547,  45,   455, 267,  577,  486,  77,   204,  362,  608,  14,   299,
  578,  109,  236,  487, 609,  331,  141,  579,  46,   15,   173,  610,  363,
  78,   205,  16,   110, 237,  611,  142,  47,   174,  79,   206,  17,   111,
  238,  48,   143,  80,  175,  112,  207,  49,   18,   239,  81,   113,  19,
  50,   82,   114,  51,  83,   115,  640,  516,  392,  268,  144,  20,   672,
  641,  548,  517,  424, 393,  300,  269,  176,  145,  52,   21,   704,  673,
  642,  580,  549,  518, 456,  425,  394,  332,  301,  270,  208,  177,  146,
  84,   53,   22,   736, 705,  674,  643,  612,  581,  550,  519,  488,  457,
  426,  395,  364,  333, 302,  271,  240,  209,  178,  147,  116,  85,   54,
  23,   737,  706,  675, 613,  582,  551,  489,  458,  427,  365,  334,  303,
  241,  210,  179,  117, 86,   55,   738,  707,  614,  583,  490,  459,  366,
  335,  242,  211,  118, 87,   739,  615,  491,  367,  243,  119,  768,  644,
  520,  396,  272,  148, 24,   800,  769,  676,  645,  552,  521,  428,  397,
  304,  273,  180,  149, 56,   25,   832,  801,  770,  708,  677,  646,  584,
  553,  522,  460,  429, 398,  336,  305,  274,  212,  181,  150,  88,   57,
  26,   864,  833,  802, 771,  740,  709,  678,  647,  616,  585,  554,  523,
  492,  461,  430,  399, 368,  337,  306,  275,  244,  213,  182,  151,  120,
  89,   58,   27,   865, 834,  803,  741,  710,  679,  617,  586,  555,  493,
  462,  431,  369,  338, 307,  245,  214,  183,  121,  90,   59,   866,  835,
  742,  711,  618,  587, 494,  463,  370,  339,  246,  215,  122,  91,   867,
  743,  619,  495,  371, 247,  123,  896,  772,  648,  524,  400,  276,  152,
  28,   928,  897,  804, 773,  680,  649,  556,  525,  432,  401,  308,  277,
  184,  153,  60,   29,  960,  929,  898,  836,  805,  774,  712,  681,  650,
  588,  557,  526,  464, 433,  402,  340,  309,  278,  216,  185,  154,  92,
  61,   30,   992,  961, 930,  899,  868,  837,  806,  775,  744,  713,  682,
  651,  620,  589,  558, 527,  496,  465,  434,  403,  372,  341,  310,  279,
  248,  217,  186,  155, 124,  93,   62,   31,   993,  962,  931,  869,  838,
  807,  745,  714,  683, 621,  590,  559,  497,  466,  435,  373,  342,  311,
  249,  218,  187,  125, 94,   63,   994,  963,  870,  839,  746,  715,  622,
  591,  498,  467,  374, 343,  250,  219,  126,  95,   995,  871,  747,  623,
  499,  375,  251,  127, 900,  776,  652,  528,  404,  280,  156,  932,  901,
  808,  777,  684,  653, 560,  529,  436,  405,  312,  281,  188,  157,  964,
  933,  902,  840,  809, 778,  716,  685,  654,  592,  561,  530,  468,  437,
  406,  344,  313,  282, 220,  189,  158,  996,  965,  934,  903,  872,  841,
  810,  779,  748,  717, 686,  655,  624,  593,  562,  531,  500,  469,  438,
  407,  376,  345,  314, 283,  252,  221,  190,  159,  997,  966,  935,  873,
  842,  811,  749,  718, 687,  625,  594,  563,  501,  470,  439,  377,  346,
  315,  253,  222,  191, 998,  967,  874,  843,  750,  719,  626,  595,  502,
  471,  378,  347,  254, 223,  999,  875,  751,  627,  503,  379,  255,  904,
  780,  656,  532,  408, 284,  936,  905,  812,  781,  688,  657,  564,  533,
  440,  409,  316,  285, 968,  937,  906,  844,  813,  782,  720,  689,  658,
  596,  565,  534,  472, 441,  410,  348,  317,  286,  1000, 969,  938,  907,
  876,  845,  814,  783, 752,  721,  690,  659,  628,  597,  566,  535,  504,
  473,  442,  411,  380, 349,  318,  287,  1001, 970,  939,  877,  846,  815,
  753,  722,  691,  629, 598,  567,  505,  474,  443,  381,  350,  319,  1002,
  971,  878,  847,  754, 723,  630,  599,  506,  475,  382,  351,  1003, 879,
  755,  631,  507,  383, 908,  784,  660,  536,  412,  940,  909,  816,  785,
  692,  661,  568,  537, 444,  413,  972,  941,  910,  848,  817,  786,  724,
  693,  662,  600,  569, 538,  476,  445,  414,  1004, 973,  942,  911,  880,
  849,  818,  787,  756, 725,  694,  663,  632,  601,  570,  539,  508,  477,
  446,  415,  1005, 974, 943,  881,  850,  819,  757,  726,  695,  633,  602,
  571,  509,  478,  447, 1006, 975,  882,  851,  758,  727,  634,  603,  510,
  479,  1007, 883,  759, 635,  511,  912,  788,  664,  540,  944,  913,  820,
  789,  696,  665,  572, 541,  976,  945,  914,  852,  821,  790,  728,  697,
  666,  604,  573,  542, 1008, 977,  946,  915,  884,  853,  822,  791,  760,
  729,  698,  667,  636, 605,  574,  543,  1009, 978,  947,  885,  854,  823,
  761,  730,  699,  637, 606,  575,  1010, 979,  886,  855,  762,  731,  638,
  607,  1011, 887,  763, 639,  916,  792,  668,  948,  917,  824,  793,  700,
  669,  980,  949,  918, 856,  825,  794,  732,  701,  670,  1012, 981,  950,
  919,  888,  857,  826, 795,  764,  733,  702,  671,  1013, 982,  951,  889,
  858,  827,  765,  734, 703,  1014, 983,  890,  859,  766,  735,  1015, 891,
  767,  920,  796,  952, 921,  828,  797,  984,  953,  922,  860,  829,  798,
  1016, 985,  954,  923, 892,  861,  830,  799,  1017, 986,  955,  893,  862,
  831,  1018, 987,  894, 863,  1019, 895,  924,  956,  925,  988,  957,  926,
  1020, 989,  958,  927, 1021, 990,  959,  1022, 991,  1023,
};

// Scan over two rectangular vertical partitions one after the other
DECLARE_ALIGNED(16, static const int16_t, v2_scan_32x32[1024]) = {
  0,    1,    32,   33,   2,    64,   34,   65,   66,   3,    96,   35,   97,
  67,   98,   4,    128,  36,   129,  99,   68,   130,  5,    100,  131,  160,
  37,   161,  69,   162,  132,  101,  163,  6,    192,  38,   193,  70,   194,
  133,  164,  102,  195,  7,    224,  39,   165,  225,  134,  196,  71,   226,
  103,  227,  166,  197,  8,    256,  40,   135,  228,  257,  72,   258,  198,
  104,  259,  167,  229,  136,  260,  9,    288,  41,   289,  73,   199,  230,
  290,  168,  261,  105,  291,  137,  292,  231,  10,   200,  262,  320,  42,
  321,  74,   322,  169,  293,  106,  323,  232,  263,  138,  324,  201,  294,
  11,   352,  43,   353,  75,   170,  325,  354,  264,  107,  233,  295,  355,
  202,  326,  139,  356,  12,   384,  44,   265,  296,  385,  171,  357,  76,
  386,  234,  327,  108,  387,  203,  358,  140,  388,  297,  266,  328,  13,
  172,  389,  416,  45,   235,  359,  417,  77,   418,  109,  419,  204,  390,
  298,  329,  141,  267,  360,  420,  236,  391,  173,  421,  14,   448,  46,
  449,  78,   330,  450,  299,  361,  110,  205,  422,  451,  268,  392,  142,
  452,  237,  423,  174,  331,  362,  453,  15,   300,  393,  480,  47,   481,
  79,   482,  206,  454,  269,  424,  111,  483,  143,  484,  363,  332,  394,
  238,  455,  175,  301,  425,  485,  512,  513,  270,  456,  514,  207,  486,
  364,  395,  515,  333,  426,  516,  239,  487,  302,  457,  517,  396,  271,
  488,  544,  365,  427,  545,  518,  546,  334,  458,  547,  519,  548,  303,
  489,  397,  428,  549,  366,  459,  520,  576,  335,  490,  550,  577,  578,
  579,  521,  429,  551,  398,  460,  580,  367,  491,  581,  552,  522,  582,
  608,  609,  430,  461,  610,  399,  492,  553,  611,  583,  523,  612,  613,
  584,  554,  462,  431,  493,  614,  524,  640,  641,  642,  585,  643,  555,
  615,  644,  463,  494,  586,  525,  616,  645,  556,  646,  672,  617,  673,
  587,  674,  647,  495,  675,  526,  676,  557,  618,  648,  677,  588,  678,
  527,  649,  619,  704,  558,  705,  706,  679,  589,  707,  650,  708,  620,
  680,  709,  559,  590,  710,  651,  681,  736,  621,  737,  711,  738,  739,
  682,  652,  740,  712,  591,  741,  622,  683,  713,  742,  653,  768,  769,
  743,  770,  714,  684,  771,  623,  772,  744,  654,  773,  715,  685,  745,
  774,  655,  775,  800,  801,  716,  746,  802,  803,  686,  776,  804,  747,
  805,  717,  777,  806,  687,  748,  807,  778,  832,  833,  718,  834,  835,
  808,  836,  779,  749,  837,  809,  719,  838,  780,  750,  810,  839,  864,
  865,  866,  867,  840,  781,  868,  811,  751,  869,  841,  870,  812,  782,
  842,  871,  896,  897,  898,  872,  899,  813,  843,  900,  783,  901,  873,
  844,  902,  814,  874,  903,  928,  929,  845,  930,  904,  815,  875,  931,
  932,  905,  933,  846,  876,  934,  906,  935,  877,  960,  847,  961,  962,
  907,  936,  963,  964,  937,  878,  965,  908,  966,  938,  967,  909,  879,
  992,  939,  993,  968,  994,  995,  996,  910,  969,  940,  997,  998,  970,
  911,  941,  999,  971,  1000, 942,  1001, 972,  1002, 943,  973,  1003, 974,
  1004, 975,  1005, 1006, 1007, 16,   48,   80,   112,  144,  176,  17,   49,
  208,  81,   113,  145,  240,  177,  272,  18,   50,   209,  82,   114,  304,
  241,  146,  178,  273,  336,  210,  19,   51,   83,   115,  305,  242,  147,
  368,  179,  274,  337,  211,  20,   400,  52,   84,   306,  116,  243,  369,
  148,  338,  180,  275,  432,  401,  212,  21,   53,   307,  85,   370,  244,
  117,  464,  149,  433,  339,  276,  181,  402,  213,  308,  496,  371,  22,
  54,   465,  86,   245,  118,  434,  150,  340,  277,  403,  182,  528,  497,
  214,  466,  372,  309,  23,   55,   435,  87,   246,  119,  341,  404,  151,
  529,  560,  278,  498,  183,  467,  373,  215,  310,  436,  24,   56,   247,
  561,  88,   530,  592,  342,  120,  405,  499,  152,  279,  468,  184,  374,
  311,  437,  216,  562,  593,  531,  624,  25,   248,  500,  57,   406,  89,
  343,  121,  469,  280,  153,  594,  185,  375,  563,  625,  438,  532,  656,
  312,  217,  501,  407,  249,  26,   344,  58,   90,   470,  122,  595,  626,
  281,  564,  657,  154,  376,  533,  688,  439,  186,  313,  502,  218,  408,
  627,  596,  658,  250,  345,  471,  27,   59,   565,  689,  91,   123,  282,
  534,  720,  155,  440,  377,  187,  503,  314,  628,  659,  219,  597,  690,
  409,  472,  566,  721,  346,  251,  28,   60,   535,  752,  92,   124,  283,
  441,  378,  156,  660,  504,  629,  691,  598,  722,  188,  315,  567,  753,
  220,  410,  473,  347,  536,  784,  252,  29,   661,  692,  61,   93,   442,
  630,  723,  284,  125,  379,  505,  599,  754,  157,  316,  568,  785,  189,
  474,  411,  221,  537,  816,  693,  348,  662,  724,  253,  631,  755,  443,
  30,   600,  786,  62,   506,  94,   285,  380,  126,  569,  817,  158,  317,
  190,  475,  694,  725,  412,  663,  756,  538,  848,  222,  632,  787,  349,
  254,  601,  818,  444,  507,  31,   63,   381,  286,  95,   570,  849,  726,
  127,  695,  757,  664,  788,  159,  476,  318,  413,  539,  880,  191,  633,
  819,  223,  350,  602,  850,  508,  255,  445,  727,  758,  696,  789,  571,
  881,  382,  287,  665,  820,  477,  634,  851,  540,  912,  319,  414,  603,
  882,  759,  728,  790,  351,  509,  697,  821,  446,  572,  913,  666,  852,
  383,  635,  883,  478,  541,  944,  415,  760,  791,  604,  914,  729,  822,
  698,  853,  510,  667,  884,  447,  573,  945,  636,  915,  792,  761,  823,
  542,  976,  479,  730,  854,  605,  946,  699,  885,  668,  916,  511,  574,
  977,  793,  824,  637,  947,  762,  855,  731,  886,  543,  1008, 606,  978,
  700,  917,  669,  948,  575,  825,  1009, 794,  856,  763,  887,  638,  979,
  732,  918,  701,  949,  607,  1010, 670,  980,  826,  857,  795,  888,  764,
  919,  639,  1011, 733,  950,  702,  981,  858,  827,  889,  796,  920,  671,
  1012, 765,  951,  734,  982,  703,  1013, 859,  890,  828,  921,  797,  952,
  766,  983,  735,  1014, 891,  860,  922,  829,  953,  798,  984,  767,  1015,
  892,  923,  861,  954,  830,  985,  799,  1016, 924,  893,  955,  862,  986,
  831,  1017, 925,  956,  894,  987,  863,  1018, 957,  926,  988,  895,  1019,
  958,  989,  927,  1020, 990,  959,  1021, 991,  1022, 1023,
};

// Scan over two rectangular horizontal partitions one after the other
DECLARE_ALIGNED(16, static const int16_t, h2_scan_32x32[1024]) = {
  0,    1,    32,   33,   2,    64,   34,   65,   66,   3,    96,   35,   97,
  67,   98,   4,    128,  36,   129,  99,   68,   130,  5,    100,  131,  160,
  37,   161,  69,   162,  132,  101,  163,  6,    192,  38,   193,  70,   194,
  133,  164,  102,  195,  7,    224,  39,   165,  225,  134,  196,  71,   226,
  103,  227,  166,  197,  8,    256,  40,   135,  228,  257,  72,   258,  198,
  104,  259,  167,  229,  136,  260,  9,    288,  41,   289,  73,   199,  230,
  290,  168,  261,  105,  291,  137,  292,  231,  10,   200,  262,  320,  42,
  321,  74,   322,  169,  293,  106,  323,  232,  263,  138,  324,  201,  294,
  11,   352,  43,   353,  75,   170,  325,  354,  264,  107,  233,  295,  355,
  202,  326,  139,  356,  12,   384,  44,   265,  296,  385,  171,  357,  76,
  386,  234,  327,  108,  387,  203,  358,  140,  388,  297,  266,  328,  13,
  172,  389,  416,  45,   235,  359,  417,  77,   418,  109,  419,  204,  390,
  298,  329,  141,  267,  360,  420,  236,  391,  173,  421,  14,   448,  46,
  449,  78,   330,  450,  299,  361,  110,  205,  422,  451,  268,  392,  142,
  452,  237,  423,  174,  331,  362,  453,  15,   300,  393,  480,  47,   481,
  79,   482,  206,  454,  269,  424,  111,  483,  143,  484,  363,  332,  394,
  238,  455,  175,  301,  425,  485,  16,   48,   80,   270,  456,  207,  486,
  112,  364,  395,  333,  426,  144,  239,  487,  302,  457,  176,  396,  17,
  271,  488,  49,   365,  427,  208,  81,   334,  458,  113,  145,  240,  303,
  489,  397,  428,  177,  366,  459,  272,  18,   50,   209,  335,  490,  82,
  114,  304,  241,  429,  146,  398,  460,  367,  491,  178,  273,  336,  210,
  19,   51,   83,   430,  461,  399,  492,  115,  305,  242,  147,  368,  179,
  274,  337,  462,  431,  493,  211,  20,   400,  52,   84,   306,  116,  243,
  369,  148,  463,  494,  338,  180,  275,  432,  401,  212,  21,   53,   307,
  85,   370,  244,  117,  495,  464,  149,  433,  339,  276,  181,  402,  213,
  308,  496,  371,  22,   54,   465,  86,   245,  118,  434,  150,  340,  277,
  403,  182,  497,  214,  466,  372,  309,  23,   55,   435,  87,   246,  119,
  341,  404,  151,  278,  498,  183,  467,  373,  215,  310,  436,  24,   56,
  247,  88,   342,  120,  405,  499,  152,  279,  468,  184,  374,  311,  437,
  216,  25,   248,  500,  57,   406,  89,   343,  121,  469,  280,  153,  185,
  375,  438,  312,  217,  501,  407,  249,  26,   344,  58,   90,   470,  122,
  281,  154,  376,  439,  186,  313,  502,  218,  408,  250,  345,  471,  27,
  59,   91,   123,  282,  155,  440,  377,  187,  503,  314,  219,  409,  472,
  346,  251,  28,   60,   92,   124,  283,  441,  378,  156,  504,  188,  315,
  220,  410,  473,  347,  252,  29,   61,   93,   442,  284,  125,  379,  505,
  157,  316,  189,  474,  411,  221,  348,  253,  443,  30,   62,   506,  94,
  285,  380,  126,  158,  317,  190,  475,  412,  222,  349,  254,  444,  507,
  31,   63,   381,  286,  95,   127,  159,  476,  318,  413,  191,  223,  350,
  508,  255,  445,  382,  287,  477,  319,  414,  351,  509,  446,  383,  478,
  415,  510,  447,  479,  511,  512,  513,  514,  515,  516,  517,  544,  545,
  518,  546,  547,  519,  548,  549,  520,  576,  550,  577,  578,  579,  521,
  551,  580,  581,  552,  522,  582,  608,  609,  610,  553,  611,  583,  523,
  612,  613,  584,  554,  614,  524,  640,  641,  642,  585,  643,  555,  615,
  644,  586,  525,  616,  645,  556,  646,  672,  617,  673,  587,  674,  647,
  675,  526,  676,  557,  618,  648,  677,  588,  678,  527,  649,  619,  704,
  558,  705,  706,  679,  589,  707,  650,  708,  620,  680,  709,  528,  559,
  590,  710,  651,  681,  736,  621,  737,  711,  738,  739,  682,  652,  529,
  560,  740,  712,  591,  741,  622,  683,  713,  742,  653,  768,  769,  561,
  743,  530,  592,  770,  714,  684,  771,  623,  772,  744,  654,  773,  715,
  685,  745,  774,  562,  593,  531,  624,  655,  775,  800,  801,  716,  746,
  802,  803,  686,  776,  804,  594,  563,  625,  747,  805,  717,  532,  656,
  777,  806,  687,  748,  807,  778,  832,  833,  718,  834,  595,  626,  835,
  564,  657,  808,  836,  533,  688,  779,  749,  837,  809,  719,  838,  780,
  627,  596,  658,  750,  810,  839,  864,  565,  689,  865,  866,  867,  534,
  720,  840,  781,  868,  811,  751,  869,  841,  628,  659,  597,  690,  870,
  812,  782,  566,  721,  842,  871,  896,  535,  752,  897,  898,  872,  899,
  813,  843,  660,  900,  783,  629,  691,  598,  722,  901,  873,  567,  753,
  844,  902,  814,  874,  536,  784,  903,  661,  692,  928,  929,  630,  723,
  845,  930,  904,  815,  875,  931,  599,  754,  932,  568,  785,  905,  933,
  846,  876,  934,  537,  816,  693,  662,  724,  906,  631,  755,  935,  877,
  600,  786,  960,  847,  961,  962,  907,  936,  963,  569,  817,  964,  937,
  694,  725,  878,  965,  908,  663,  756,  538,  848,  966,  632,  787,  938,
  601,  818,  967,  909,  879,  992,  939,  993,  968,  570,  849,  994,  726,
  695,  757,  995,  664,  788,  996,  910,  969,  539,  880,  940,  633,  819,
  997,  998,  602,  850,  970,  911,  941,  999,  727,  758,  696,  789,  571,
  881,  971,  665,  820,  1000, 634,  851,  942,  540,  912,  1001, 972,  603,
  882,  759,  728,  790,  1002, 697,  821,  943,  973,  572,  913,  666,  852,
  1003, 635,  883,  974,  541,  944,  760,  791,  1004, 604,  914,  729,  822,
  698,  853,  975,  667,  884,  573,  945,  1005, 636,  915,  792,  761,  823,
  542,  976,  1006, 730,  854,  605,  946,  699,  885,  668,  916,  1007, 574,
  977,  793,  824,  637,  947,  762,  855,  731,  886,  543,  1008, 606,  978,
  700,  917,  669,  948,  575,  825,  1009, 794,  856,  763,  887,  638,  979,
  732,  918,  701,  949,  607,  1010, 670,  980,  826,  857,  795,  888,  764,
  919,  639,  1011, 733,  950,  702,  981,  858,  827,  889,  796,  920,  671,
  1012, 765,  951,  734,  982,  703,  1013, 859,  890,  828,  921,  797,  952,
  766,  983,  735,  1014, 891,  860,  922,  829,  953,  798,  984,  767,  1015,
  892,  923,  861,  954,  830,  985,  799,  1016, 924,  893,  955,  862,  986,
  831,  1017, 925,  956,  894,  987,  863,  1018, 957,  926,  988,  895,  1019,
  958,  989,  927,  1020, 990,  959,  1021, 991,  1022, 1023,
};

// Scan where the top left quarter is scanned first
DECLARE_ALIGNED(16, static const int16_t, qtr_scan_32x32[1024]) = {
  0,    1,    32,   33,   2,    64,   34,   65,   66,   3,    96,   35,   97,
  67,   98,   4,    128,  36,   129,  99,   68,   130,  5,    100,  131,  160,
  37,   161,  69,   162,  132,  101,  163,  6,    192,  38,   193,  70,   194,
  133,  164,  102,  195,  7,    224,  39,   165,  225,  134,  196,  71,   226,
  103,  227,  166,  197,  8,    256,  40,   135,  228,  257,  72,   258,  198,
  104,  259,  167,  229,  136,  260,  9,    288,  41,   289,  73,   199,  230,
  290,  168,  261,  105,  291,  137,  292,  231,  10,   200,  262,  320,  42,
  321,  74,   322,  169,  293,  106,  323,  232,  263,  138,  324,  201,  294,
  11,   352,  43,   353,  75,   170,  325,  354,  264,  107,  233,  295,  355,
  202,  326,  139,  356,  12,   384,  44,   265,  296,  385,  171,  357,  76,
  386,  234,  327,  108,  387,  203,  358,  140,  388,  297,  266,  328,  13,
  172,  389,  416,  45,   235,  359,  417,  77,   418,  109,  419,  204,  390,
  298,  329,  141,  267,  360,  420,  236,  391,  173,  421,  14,   448,  46,
  449,  78,   330,  450,  299,  361,  110,  205,  422,  451,  268,  392,  142,
  452,  237,  423,  174,  331,  362,  453,  15,   300,  393,  480,  47,   481,
  79,   482,  206,  454,  269,  424,  111,  483,  143,  484,  363,  332,  394,
  238,  455,  175,  301,  425,  485,  270,  456,  207,  486,  364,  395,  333,
  426,  239,  487,  302,  457,  396,  271,  488,  365,  427,  334,  458,  303,
  489,  397,  428,  366,  459,  335,  490,  429,  398,  460,  367,  491,  430,
  461,  399,  492,  462,  431,  493,  463,  494,  495,  16,   512,  48,   513,
  80,   514,  112,  515,  144,  516,  176,  517,  17,   544,  49,   545,  208,
  518,  81,   546,  113,  547,  145,  240,  519,  548,  177,  549,  272,  520,
  18,   576,  50,   209,  550,  577,  82,   578,  114,  579,  304,  521,  241,
  551,  146,  580,  178,  581,  273,  552,  336,  522,  210,  582,  19,   608,
  51,   609,  83,   610,  115,  305,  553,  611,  242,  583,  147,  368,  523,
  612,  179,  613,  274,  584,  337,  554,  211,  614,  20,   400,  524,  640,
  52,   641,  84,   642,  306,  585,  116,  643,  243,  369,  555,  615,  148,
  644,  338,  586,  180,  275,  432,  525,  616,  645,  401,  556,  212,  646,
  21,   672,  53,   307,  617,  673,  85,   370,  587,  674,  244,  647,  117,
  675,  464,  526,  149,  676,  433,  557,  339,  618,  276,  648,  181,  677,
  402,  588,  213,  678,  308,  496,  527,  649,  371,  619,  22,   704,  54,
  465,  558,  705,  86,   706,  245,  679,  118,  434,  589,  707,  150,  340,
  650,  708,  277,  403,  620,  680,  182,  709,  528,  497,  559,  214,  466,
  590,  710,  372,  651,  309,  681,  23,   736,  55,   435,  621,  737,  87,
  246,  711,  738,  119,  739,  341,  682,  404,  652,  151,  529,  560,  740,
  278,  712,  498,  591,  183,  741,  467,  622,  373,  683,  215,  310,  713,
  742,  436,  653,  24,   768,  56,   769,  247,  561,  743,  88,   530,  592,
  770,  342,  714,  120,  405,  684,  771,  499,  623,  152,  772,  279,  744,
  468,  654,  184,  773,  374,  715,  311,  437,  685,  745,  216,  774,  562,
  593,  531,  624,  25,   248,  500,  655,  775,  800,  57,   801,  406,  716,
  89,   343,  746,  802,  121,  803,  469,  686,  280,  776,  153,  804,  594,
  185,  375,  563,  625,  747,  805,  438,  717,  532,  656,  312,  777,  217,
  806,  501,  687,  407,  748,  249,  807,  26,   344,  778,  832,  58,   833,
  90,   470,  718,  834,  122,  595,  626,  835,  281,  564,  657,  808,  154,
  836,  376,  533,  688,  779,  439,  749,  186,  837,  313,  809,  502,  719,
  218,  838,  408,  780,  627,  596,  658,  250,  345,  471,  750,  810,  839,
  27,   864,  59,   565,  689,  865,  91,   866,  123,  867,  282,  534,  720,
  840,  155,  440,  781,  868,  377,  811,  187,  503,  751,  869,  314,  841,
  628,  659,  219,  597,  690,  870,  409,  812,  472,  782,  566,  721,  346,
  842,  251,  871,  28,   896,  60,   535,  752,  897,  92,   898,  124,  283,
  872,  899,  441,  813,  378,  843,  156,  660,  900,  504,  783,  629,  691,
  598,  722,  188,  901,  315,  873,  567,  753,  220,  410,  844,  902,  473,
  814,  347,  874,  536,  784,  252,  903,  29,   661,  692,  928,  61,   929,
  93,   442,  630,  723,  845,  930,  284,  904,  125,  379,  505,  815,  875,
  931,  599,  754,  157,  932,  316,  568,  785,  905,  189,  933,  474,  846,
  411,  876,  221,  934,  537,  816,  693,  348,  662,  724,  906,  253,  631,
  755,  935,  443,  877,  30,   600,  786,  960,  62,   506,  847,  961,  94,
  962,  285,  380,  907,  936,  126,  963,  569,  817,  158,  964,  317,  937,
  190,  475,  694,  725,  878,  965,  412,  908,  663,  756,  538,  848,  222,
  966,  632,  787,  349,  938,  254,  601,  818,  967,  444,  909,  507,  879,
  31,   992,  63,   381,  939,  993,  286,  968,  95,   570,  849,  994,  726,
  127,  695,  757,  995,  664,  788,  159,  996,  476,  910,  318,  969,  413,
  539,  880,  940,  191,  633,  819,  997,  223,  998,  350,  602,  850,  970,
  508,  911,  255,  445,  941,  999,  727,  758,  696,  789,  571,  881,  382,
  971,  287,  665,  820,  1000, 477,  634,  851,  942,  540,  912,  319,  1001,
  414,  972,  603,  882,  759,  728,  790,  351,  1002, 509,  697,  821,  943,
  446,  973,  572,  913,  666,  852,  383,  1003, 635,  883,  478,  974,  541,
  944,  415,  760,  791,  1004, 604,  914,  729,  822,  698,  853,  510,  975,
  667,  884,  447,  573,  945,  1005, 636,  915,  792,  761,  823,  542,  976,
  479,  1006, 730,  854,  605,  946,  699,  885,  668,  916,  511,  1007, 574,
  977,  793,  824,  637,  947,  762,  855,  731,  886,  543,  1008, 606,  978,
  700,  917,  669,  948,  575,  825,  1009, 794,  856,  763,  887,  638,  979,
  732,  918,  701,  949,  607,  1010, 670,  980,  826,  857,  795,  888,  764,
  919,  639,  1011, 733,  950,  702,  981,  858,  827,  889,  796,  920,  671,
  1012, 765,  951,  734,  982,  703,  1013, 859,  890,  828,  921,  797,  952,
  766,  983,  735,  1014, 891,  860,  922,  829,  953,  798,  984,  767,  1015,
  892,  923,  861,  954,  830,  985,  799,  1016, 924,  893,  955,  862,  986,
  831,  1017, 925,  956,  894,  987,  863,  1018, 957,  926,  988,  895,  1019,
  958,  989,  927,  1020, 990,  959,  1021, 991,  1022, 1023,
};

#if CONFIG_TX64X64
DECLARE_ALIGNED(16, static const int16_t, default_scan_32x64[2048]) = {
  0,    1,    32,   2,    33,   64,   3,    34,   65,   96,   4,    35,   66,
  97,   128,  5,    36,   67,   98,   129,  160,  6,    37,   68,   99,   130,
  161,  192,  7,    38,   69,   100,  131,  162,  193,  224,  8,    39,   70,
  101,  132,  163,  194,  225,  256,  9,    40,   71,   102,  133,  164,  195,
  226,  257,  288,  10,   41,   72,   103,  134,  165,  196,  227,  258,  289,
  320,  11,   42,   73,   104,  135,  166,  197,  228,  259,  290,  321,  352,
  12,   43,   74,   105,  136,  167,  198,  229,  260,  291,  322,  353,  384,
  13,   44,   75,   106,  137,  168,  199,  230,  261,  292,  323,  354,  385,
  416,  14,   45,   76,   107,  138,  169,  200,  231,  262,  293,  324,  355,
  386,  417,  448,  15,   46,   77,   108,  139,  170,  201,  232,  263,  294,
  325,  356,  387,  418,  449,  480,  16,   47,   78,   109,  140,  171,  202,
  233,  264,  295,  326,  357,  388,  419,  450,  481,  512,  17,   48,   79,
  110,  141,  172,  203,  234,  265,  296,  327,  358,  389,  420,  451,  482,
  513,  544,  18,   49,   80,   111,  142,  173,  204,  235,  266,  297,  328,
  359,  390,  421,  452,  483,  514,  545,  576,  19,   50,   81,   112,  143,
  174,  205,  236,  267,  298,  329,  360,  391,  422,  453,  484,  515,  546,
  577,  608,  20,   51,   82,   113,  144,  175,  206,  237,  268,  299,  330,
  361,  392,  423,  454,  485,  516,  547,  578,  609,  640,  21,   52,   83,
  114,  145,  176,  207,  238,  269,  300,  331,  362,  393,  424,  455,  486,
  517,  548,  579,  610,  641,  672,  22,   53,   84,   115,  146,  177,  208,
  239,  270,  301,  332,  363,  394,  425,  456,  487,  518,  549,  580,  611,
  642,  673,  704,  23,   54,   85,   116,  147,  178,  209,  240,  271,  302,
  333,  364,  395,  426,  457,  488,  519,  550,  581,  612,  643,  674,  705,
  736,  24,   55,   86,   117,  148,  179,  210,  241,  272,  303,  334,  365,
  396,  427,  458,  489,  520,  551,  582,  613,  644,  675,  706,  737,  768,
  25,   56,   87,   118,  149,  180,  211,  242,  273,  304,  335,  366,  397,
  428,  459,  490,  521,  552,  583,  614,  645,  676,  707,  738,  769,  800,
  26,   57,   88,   119,  150,  181,  212,  243,  274,  305,  336,  367,  398,
  429,  460,  491,  522,  553,  584,  615,  646,  677,  708,  739,  770,  801,
  832,  27,   58,   89,   120,  151,  182,  213,  244,  275,  306,  337,  368,
  399,  430,  461,  492,  523,  554,  585,  616,  647,  678,  709,  740,  771,
  802,  833,  864,  28,   59,   90,   121,  152,  183,  214,  245,  276,  307,
  338,  369,  400,  431,  462,  493,  524,  555,  586,  617,  648,  679,  710,
  741,  772,  803,  834,  865,  896,  29,   60,   91,   122,  153,  184,  215,
  246,  277,  308,  339,  370,  401,  432,  463,  494,  525,  556,  587,  618,
  649,  680,  711,  742,  773,  804,  835,  866,  897,  928,  30,   61,   92,
  123,  154,  185,  216,  247,  278,  309,  340,  371,  402,  433,  464,  495,
  526,  557,  588,  619,  650,  681,  712,  743,  774,  805,  836,  867,  898,
  929,  960,  31,   62,   93,   124,  155,  186,  217,  248,  279,  310,  341,
  372,  403,  434,  465,  496,  527,  558,  589,  620,  651,  682,  713,  744,
  775,  806,  837,  868,  899,  930,  961,  992,  63,   94,   125,  156,  187,
  218,  249,  280,  311,  342,  373,  404,  435,  466,  497,  528,  559,  590,
  621,  652,  683,  714,  745,  776,  807,  838,  869,  900,  931,  962,  993,
  1024, 95,   126,  157,  188,  219,  250,  281,  312,  343,  374,  405,  436,
  467,  498,  529,  560,  591,  622,  653,  684,  715,  746,  777,  808,  839,
  870,  901,  932,  963,  994,  1025, 1056, 127,  158,  189,  220,  251,  282,
  313,  344,  375,  406,  437,  468,  499,  530,  561,  592,  623,  654,  685,
  716,  747,  778,  809,  840,  871,  902,  933,  964,  995,  1026, 1057, 1088,
  159,  190,  221,  252,  283,  314,  345,  376,  407,  438,  469,  500,  531,
  562,  593,  624,  655,  686,  717,  748,  779,  810,  841,  872,  903,  934,
  965,  996,  1027, 1058, 1089, 1120, 191,  222,  253,  284,  315,  346,  377,
  408,  439,  470,  501,  532,  563,  594,  625,  656,  687,  718,  749,  780,
  811,  842,  873,  904,  935,  966,  997,  1028, 1059, 1090, 1121, 1152, 223,
  254,  285,  316,  347,  378,  409,  440,  471,  502,  533,  564,  595,  626,
  657,  688,  719,  750,  781,  812,  843,  874,  905,  936,  967,  998,  1029,
  1060, 1091, 1122, 1153, 1184, 255,  286,  317,  348,  379,  410,  441,  472,
  503,  534,  565,  596,  627,  658,  689,  720,  751,  782,  813,  844,  875,
  906,  937,  968,  999,  1030, 1061, 1092, 1123, 1154, 1185, 1216, 287,  318,
  349,  380,  411,  442,  473,  504,  535,  566,  597,  628,  659,  690,  721,
  752,  783,  814,  845,  876,  907,  938,  969,  1000, 1031, 1062, 1093, 1124,
  1155, 1186, 1217, 1248, 319,  350,  381,  412,  443,  474,  505,  536,  567,
  598,  629,  660,  691,  722,  753,  784,  815,  846,  877,  908,  939,  970,
  1001, 1032, 1063, 1094, 1125, 1156, 1187, 1218, 1249, 1280, 351,  382,  413,
  444,  475,  506,  537,  568,  599,  630,  661,  692,  723,  754,  785,  816,
  847,  878,  909,  940,  971,  1002, 1033, 1064, 1095, 1126, 1157, 1188, 1219,
  1250, 1281, 1312, 383,  414,  445,  476,  507,  538,  569,  600,  631,  662,
  693,  724,  755,  786,  817,  848,  879,  910,  941,  972,  1003, 1034, 1065,
  1096, 1127, 1158, 1189, 1220, 1251, 1282, 1313, 1344, 415,  446,  477,  508,
  539,  570,  601,  632,  663,  694,  725,  756,  787,  818,  849,  880,  911,
  942,  973,  1004, 1035, 1066, 1097, 1128, 1159, 1190, 1221, 1252, 1283, 1314,
  1345, 1376, 447,  478,  509,  540,  571,  602,  633,  664,  695,  726,  757,
  788,  819,  850,  881,  912,  943,  974,  1005, 1036, 1067, 1098, 1129, 1160,
  1191, 1222, 1253, 1284, 1315, 1346, 1377, 1408, 479,  510,  541,  572,  603,
  634,  665,  696,  727,  758,  789,  820,  851,  882,  913,  944,  975,  1006,
  1037, 1068, 1099, 1130, 1161, 1192, 1223, 1254, 1285, 1316, 1347, 1378, 1409,
  1440, 511,  542,  573,  604,  635,  666,  697,  728,  759,  790,  821,  852,
  883,  914,  945,  976,  1007, 1038, 1069, 1100, 1131, 1162, 1193, 1224, 1255,
  1286, 1317, 1348, 1379, 1410, 1441, 1472, 543,  574,  605,  636,  667,  698,
  729,  760,  791,  822,  853,  884,  915,  946,  977,  1008, 1039, 1070, 1101,
  1132, 1163, 1194, 1225, 1256, 1287, 1318, 1349, 1380, 1411, 1442, 1473, 1504,
  575,  606,  637,  668,  699,  730,  761,  792,  823,  854,  885,  916,  947,
  978,  1009, 1040, 1071, 1102, 1133, 1164, 1195, 1226, 1257, 1288, 1319, 1350,
  1381, 1412, 1443, 1474, 1505, 1536, 607,  638,  669,  700,  731,  762,  793,
  824,  855,  886,  917,  948,  979,  1010, 1041, 1072, 1103, 1134, 1165, 1196,
  1227, 1258, 1289, 1320, 1351, 1382, 1413, 1444, 1475, 1506, 1537, 1568, 639,
  670,  701,  732,  763,  794,  825,  856,  887,  918,  949,  980,  1011, 1042,
  1073, 1104, 1135, 1166, 1197, 1228, 1259, 1290, 1321, 1352, 1383, 1414, 1445,
  1476, 1507, 1538, 1569, 1600, 671,  702,  733,  764,  795,  826,  857,  888,
  919,  950,  981,  1012, 1043, 1074, 1105, 1136, 1167, 1198, 1229, 1260, 1291,
  1322, 1353, 1384, 1415, 1446, 1477, 1508, 1539, 1570, 1601, 1632, 703,  734,
  765,  796,  827,  858,  889,  920,  951,  982,  1013, 1044, 1075, 1106, 1137,
  1168, 1199, 1230, 1261, 1292, 1323, 1354, 1385, 1416, 1447, 1478, 1509, 1540,
  1571, 1602, 1633, 1664, 735,  766,  797,  828,  859,  890,  921,  952,  983,
  1014, 1045, 1076, 1107, 1138, 1169, 1200, 1231, 1262, 1293, 1324, 1355, 1386,
  1417, 1448, 1479, 1510, 1541, 1572, 1603, 1634, 1665, 1696, 767,  798,  829,
  860,  891,  922,  953,  984,  1015, 1046, 1077, 1108, 1139, 1170, 1201, 1232,
  1263, 1294, 1325, 1356, 1387, 1418, 1449, 1480, 1511, 1542, 1573, 1604, 1635,
  1666, 1697, 1728, 799,  830,  861,  892,  923,  954,  985,  1016, 1047, 1078,
  1109, 1140, 1171, 1202, 1233, 1264, 1295, 1326, 1357, 1388, 1419, 1450, 1481,
  1512, 1543, 1574, 1605, 1636, 1667, 1698, 1729, 1760, 831,  862,  893,  924,
  955,  986,  1017, 1048, 1079, 1110, 1141, 1172, 1203, 1234, 1265, 1296, 1327,
  1358, 1389, 1420, 1451, 1482, 1513, 1544, 1575, 1606, 1637, 1668, 1699, 1730,
  1761, 1792, 863,  894,  925,  956,  987,  1018, 1049, 1080, 1111, 1142, 1173,
  1204, 1235, 1266, 1297, 1328, 1359, 1390, 1421, 1452, 1483, 1514, 1545, 1576,
  1607, 1638, 1669, 1700, 1731, 1762, 1793, 1824, 895,  926,  957,  988,  1019,
  1050, 1081, 1112, 1143, 1174, 1205, 1236, 1267, 1298, 1329, 1360, 1391, 1422,
  1453, 1484, 1515, 1546, 1577, 1608, 1639, 1670, 1701, 1732, 1763, 1794, 1825,
  1856, 927,  958,  989,  1020, 1051, 1082, 1113, 1144, 1175, 1206, 1237, 1268,
  1299, 1330, 1361, 1392, 1423, 1454, 1485, 1516, 1547, 1578, 1609, 1640, 1671,
  1702, 1733, 1764, 1795, 1826, 1857, 1888, 959,  990,  1021, 1052, 1083, 1114,
  1145, 1176, 1207, 1238, 1269, 1300, 1331, 1362, 1393, 1424, 1455, 1486, 1517,
  1548, 1579, 1610, 1641, 1672, 1703, 1734, 1765, 1796, 1827, 1858, 1889, 1920,
  991,  1022, 1053, 1084, 1115, 1146, 1177, 1208, 1239, 1270, 1301, 1332, 1363,
  1394, 1425, 1456, 1487, 1518, 1549, 1580, 1611, 1642, 1673, 1704, 1735, 1766,
  1797, 1828, 1859, 1890, 1921, 1952, 1023, 1054, 1085, 1116, 1147, 1178, 1209,
  1240, 1271, 1302, 1333, 1364, 1395, 1426, 1457, 1488, 1519, 1550, 1581, 1612,
  1643, 1674, 1705, 1736, 1767, 1798, 1829, 1860, 1891, 1922, 1953, 1984, 1055,
  1086, 1117, 1148, 1179, 1210, 1241, 1272, 1303, 1334, 1365, 1396, 1427, 1458,
  1489, 1520, 1551, 1582, 1613, 1644, 1675, 1706, 1737, 1768, 1799, 1830, 1861,
  1892, 1923, 1954, 1985, 2016, 1087, 1118, 1149, 1180, 1211, 1242, 1273, 1304,
  1335, 1366, 1397, 1428, 1459, 1490, 1521, 1552, 1583, 1614, 1645, 1676, 1707,
  1738, 1769, 1800, 1831, 1862, 1893, 1924, 1955, 1986, 2017, 1119, 1150, 1181,
  1212, 1243, 1274, 1305, 1336, 1367, 1398, 1429, 1460, 1491, 1522, 1553, 1584,
  1615, 1646, 1677, 1708, 1739, 1770, 1801, 1832, 1863, 1894, 1925, 1956, 1987,
  2018, 1151, 1182, 1213, 1244, 1275, 1306, 1337, 1368, 1399, 1430, 1461, 1492,
  1523, 1554, 1585, 1616, 1647, 1678, 1709, 1740, 1771, 1802, 1833, 1864, 1895,
  1926, 1957, 1988, 2019, 1183, 1214, 1245, 1276, 1307, 1338, 1369, 1400, 1431,
  1462, 1493, 1524, 1555, 1586, 1617, 1648, 1679, 1710, 1741, 1772, 1803, 1834,
  1865, 1896, 1927, 1958, 1989, 2020, 1215, 1246, 1277, 1308, 1339, 1370, 1401,
  1432, 1463, 1494, 1525, 1556, 1587, 1618, 1649, 1680, 1711, 1742, 1773, 1804,
  1835, 1866, 1897, 1928, 1959, 1990, 2021, 1247, 1278, 1309, 1340, 1371, 1402,
  1433, 1464, 1495, 1526, 1557, 1588, 1619, 1650, 1681, 1712, 1743, 1774, 1805,
  1836, 1867, 1898, 1929, 1960, 1991, 2022, 1279, 1310, 1341, 1372, 1403, 1434,
  1465, 1496, 1527, 1558, 1589, 1620, 1651, 1682, 1713, 1744, 1775, 1806, 1837,
  1868, 1899, 1930, 1961, 1992, 2023, 1311, 1342, 1373, 1404, 1435, 1466, 1497,
  1528, 1559, 1590, 1621, 1652, 1683, 1714, 1745, 1776, 1807, 1838, 1869, 1900,
  1931, 1962, 1993, 2024, 1343, 1374, 1405, 1436, 1467, 1498, 1529, 1560, 1591,
  1622, 1653, 1684, 1715, 1746, 1777, 1808, 1839, 1870, 1901, 1932, 1963, 1994,
  2025, 1375, 1406, 1437, 1468, 1499, 1530, 1561, 1592, 1623, 1654, 1685, 1716,
  1747, 1778, 1809, 1840, 1871, 1902, 1933, 1964, 1995, 2026, 1407, 1438, 1469,
  1500, 1531, 1562, 1593, 1624, 1655, 1686, 1717, 1748, 1779, 1810, 1841, 1872,
  1903, 1934, 1965, 1996, 2027, 1439, 1470, 1501, 1532, 1563, 1594, 1625, 1656,
  1687, 1718, 1749, 1780, 1811, 1842, 1873, 1904, 1935, 1966, 1997, 2028, 1471,
  1502, 1533, 1564, 1595, 1626, 1657, 1688, 1719, 1750, 1781, 1812, 1843, 1874,
  1905, 1936, 1967, 1998, 2029, 1503, 1534, 1565, 1596, 1627, 1658, 1689, 1720,
  1751, 1782, 1813, 1844, 1875, 1906, 1937, 1968, 1999, 2030, 1535, 1566, 1597,
  1628, 1659, 1690, 1721, 1752, 1783, 1814, 1845, 1876, 1907, 1938, 1969, 2000,
  2031, 1567, 1598, 1629, 1660, 1691, 1722, 1753, 1784, 1815, 1846, 1877, 1908,
  1939, 1970, 2001, 2032, 1599, 1630, 1661, 1692, 1723, 1754, 1785, 1816, 1847,
  1878, 1909, 1940, 1971, 2002, 2033, 1631, 1662, 1693, 1724, 1755, 1786, 1817,
  1848, 1879, 1910, 1941, 1972, 2003, 2034, 1663, 1694, 1725, 1756, 1787, 1818,
  1849, 1880, 1911, 1942, 1973, 2004, 2035, 1695, 1726, 1757, 1788, 1819, 1850,
  1881, 1912, 1943, 1974, 2005, 2036, 1727, 1758, 1789, 1820, 1851, 1882, 1913,
  1944, 1975, 2006, 2037, 1759, 1790, 1821, 1852, 1883, 1914, 1945, 1976, 2007,
  2038, 1791, 1822, 1853, 1884, 1915, 1946, 1977, 2008, 2039, 1823, 1854, 1885,
  1916, 1947, 1978, 2009, 2040, 1855, 1886, 1917, 1948, 1979, 2010, 2041, 1887,
  1918, 1949, 1980, 2011, 2042, 1919, 1950, 1981, 2012, 2043, 1951, 1982, 2013,
  2044, 1983, 2014, 2045, 2015, 2046, 2047,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_64x32[2048]) = {
  0,    1,    64,   2,    65,   128,  3,    66,   129,  192,  4,    67,   130,
  193,  256,  5,    68,   131,  194,  257,  320,  6,    69,   132,  195,  258,
  321,  384,  7,    70,   133,  196,  259,  322,  385,  448,  8,    71,   134,
  197,  260,  323,  386,  449,  512,  9,    72,   135,  198,  261,  324,  387,
  450,  513,  576,  10,   73,   136,  199,  262,  325,  388,  451,  514,  577,
  640,  11,   74,   137,  200,  263,  326,  389,  452,  515,  578,  641,  704,
  12,   75,   138,  201,  264,  327,  390,  453,  516,  579,  642,  705,  768,
  13,   76,   139,  202,  265,  328,  391,  454,  517,  580,  643,  706,  769,
  832,  14,   77,   140,  203,  266,  329,  392,  455,  518,  581,  644,  707,
  770,  833,  896,  15,   78,   141,  204,  267,  330,  393,  456,  519,  582,
  645,  708,  771,  834,  897,  960,  16,   79,   142,  205,  268,  331,  394,
  457,  520,  583,  646,  709,  772,  835,  898,  961,  1024, 17,   80,   143,
  206,  269,  332,  395,  458,  521,  584,  647,  710,  773,  836,  899,  962,
  1025, 1088, 18,   81,   144,  207,  270,  333,  396,  459,  522,  585,  648,
  711,  774,  837,  900,  963,  1026, 1089, 1152, 19,   82,   145,  208,  271,
  334,  397,  460,  523,  586,  649,  712,  775,  838,  901,  964,  1027, 1090,
  1153, 1216, 20,   83,   146,  209,  272,  335,  398,  461,  524,  587,  650,
  713,  776,  839,  902,  965,  1028, 1091, 1154, 1217, 1280, 21,   84,   147,
  210,  273,  336,  399,  462,  525,  588,  651,  714,  777,  840,  903,  966,
  1029, 1092, 1155, 1218, 1281, 1344, 22,   85,   148,  211,  274,  337,  400,
  463,  526,  589,  652,  715,  778,  841,  904,  967,  1030, 1093, 1156, 1219,
  1282, 1345, 1408, 23,   86,   149,  212,  275,  338,  401,  464,  527,  590,
  653,  716,  779,  842,  905,  968,  1031, 1094, 1157, 1220, 1283, 1346, 1409,
  1472, 24,   87,   150,  213,  276,  339,  402,  465,  528,  591,  654,  717,
  780,  843,  906,  969,  1032, 1095, 1158, 1221, 1284, 1347, 1410, 1473, 1536,
  25,   88,   151,  214,  277,  340,  403,  466,  529,  592,  655,  718,  781,
  844,  907,  970,  1033, 1096, 1159, 1222, 1285, 1348, 1411, 1474, 1537, 1600,
  26,   89,   152,  215,  278,  341,  404,  467,  530,  593,  656,  719,  782,
  845,  908,  971,  1034, 1097, 1160, 1223, 1286, 1349, 1412, 1475, 1538, 1601,
  1664, 27,   90,   153,  216,  279,  342,  405,  468,  531,  594,  657,  720,
  783,  846,  909,  972,  1035, 1098, 1161, 1224, 1287, 1350, 1413, 1476, 1539,
  1602, 1665, 1728, 28,   91,   154,  217,  280,  343,  406,  469,  532,  595,
  658,  721,  784,  847,  910,  973,  1036, 1099, 1162, 1225, 1288, 1351, 1414,
  1477, 1540, 1603, 1666, 1729, 1792, 29,   92,   155,  218,  281,  344,  407,
  470,  533,  596,  659,  722,  785,  848,  911,  974,  1037, 1100, 1163, 1226,
  1289, 1352, 1415, 1478, 1541, 1604, 1667, 1730, 1793, 1856, 30,   93,   156,
  219,  282,  345,  408,  471,  534,  597,  660,  723,  786,  849,  912,  975,
  1038, 1101, 1164, 1227, 1290, 1353, 1416, 1479, 1542, 1605, 1668, 1731, 1794,
  1857, 1920, 31,   94,   157,  220,  283,  346,  409,  472,  535,  598,  661,
  724,  787,  850,  913,  976,  1039, 1102, 1165, 1228, 1291, 1354, 1417, 1480,
  1543, 1606, 1669, 1732, 1795, 1858, 1921, 1984, 32,   95,   158,  221,  284,
  347,  410,  473,  536,  599,  662,  725,  788,  851,  914,  977,  1040, 1103,
  1166, 1229, 1292, 1355, 1418, 1481, 1544, 1607, 1670, 1733, 1796, 1859, 1922,
  1985, 33,   96,   159,  222,  285,  348,  411,  474,  537,  600,  663,  726,
  789,  852,  915,  978,  1041, 1104, 1167, 1230, 1293, 1356, 1419, 1482, 1545,
  1608, 1671, 1734, 1797, 1860, 1923, 1986, 34,   97,   160,  223,  286,  349,
  412,  475,  538,  601,  664,  727,  790,  853,  916,  979,  1042, 1105, 1168,
  1231, 1294, 1357, 1420, 1483, 1546, 1609, 1672, 1735, 1798, 1861, 1924, 1987,
  35,   98,   161,  224,  287,  350,  413,  476,  539,  602,  665,  728,  791,
  854,  917,  980,  1043, 1106, 1169, 1232, 1295, 1358, 1421, 1484, 1547, 1610,
  1673, 1736, 1799, 1862, 1925, 1988, 36,   99,   162,  225,  288,  351,  414,
  477,  540,  603,  666,  729,  792,  855,  918,  981,  1044, 1107, 1170, 1233,
  1296, 1359, 1422, 1485, 1548, 1611, 1674, 1737, 1800, 1863, 1926, 1989, 37,
  100,  163,  226,  289,  352,  415,  478,  541,  604,  667,  730,  793,  856,
  919,  982,  1045, 1108, 1171, 1234, 1297, 1360, 1423, 1486, 1549, 1612, 1675,
  1738, 1801, 1864, 1927, 1990, 38,   101,  164,  227,  290,  353,  416,  479,
  542,  605,  668,  731,  794,  857,  920,  983,  1046, 1109, 1172, 1235, 1298,
  1361, 1424, 1487, 1550, 1613, 1676, 1739, 1802, 1865, 1928, 1991, 39,   102,
  165,  228,  291,  354,  417,  480,  543,  606,  669,  732,  795,  858,  921,
  984,  1047, 1110, 1173, 1236, 1299, 1362, 1425, 1488, 1551, 1614, 1677, 1740,
  1803, 1866, 1929, 1992, 40,   103,  166,  229,  292,  355,  418,  481,  544,
  607,  670,  733,  796,  859,  922,  985,  1048, 1111, 1174, 1237, 1300, 1363,
  1426, 1489, 1552, 1615, 1678, 1741, 1804, 1867, 1930, 1993, 41,   104,  167,
  230,  293,  356,  419,  482,  545,  608,  671,  734,  797,  860,  923,  986,
  1049, 1112, 1175, 1238, 1301, 1364, 1427, 1490, 1553, 1616, 1679, 1742, 1805,
  1868, 1931, 1994, 42,   105,  168,  231,  294,  357,  420,  483,  546,  609,
  672,  735,  798,  861,  924,  987,  1050, 1113, 1176, 1239, 1302, 1365, 1428,
  1491, 1554, 1617, 1680, 1743, 1806, 1869, 1932, 1995, 43,   106,  169,  232,
  295,  358,  421,  484,  547,  610,  673,  736,  799,  862,  925,  988,  1051,
  1114, 1177, 1240, 1303, 1366, 1429, 1492, 1555, 1618, 1681, 1744, 1807, 1870,
  1933, 1996, 44,   107,  170,  233,  296,  359,  422,  485,  548,  611,  674,
  737,  800,  863,  926,  989,  1052, 1115, 1178, 1241, 1304, 1367, 1430, 1493,
  1556, 1619, 1682, 1745, 1808, 1871, 1934, 1997, 45,   108,  171,  234,  297,
  360,  423,  486,  549,  612,  675,  738,  801,  864,  927,  990,  1053, 1116,
  1179, 1242, 1305, 1368, 1431, 1494, 1557, 1620, 1683, 1746, 1809, 1872, 1935,
  1998, 46,   109,  172,  235,  298,  361,  424,  487,  550,  613,  676,  739,
  802,  865,  928,  991,  1054, 1117, 1180, 1243, 1306, 1369, 1432, 1495, 1558,
  1621, 1684, 1747, 1810, 1873, 1936, 1999, 47,   110,  173,  236,  299,  362,
  425,  488,  551,  614,  677,  740,  803,  866,  929,  992,  1055, 1118, 1181,
  1244, 1307, 1370, 1433, 1496, 1559, 1622, 1685, 1748, 1811, 1874, 1937, 2000,
  48,   111,  174,  237,  300,  363,  426,  489,  552,  615,  678,  741,  804,
  867,  930,  993,  1056, 1119, 1182, 1245, 1308, 1371, 1434, 1497, 1560, 1623,
  1686, 1749, 1812, 1875, 1938, 2001, 49,   112,  175,  238,  301,  364,  427,
  490,  553,  616,  679,  742,  805,  868,  931,  994,  1057, 1120, 1183, 1246,
  1309, 1372, 1435, 1498, 1561, 1624, 1687, 1750, 1813, 1876, 1939, 2002, 50,
  113,  176,  239,  302,  365,  428,  491,  554,  617,  680,  743,  806,  869,
  932,  995,  1058, 1121, 1184, 1247, 1310, 1373, 1436, 1499, 1562, 1625, 1688,
  1751, 1814, 1877, 1940, 2003, 51,   114,  177,  240,  303,  366,  429,  492,
  555,  618,  681,  744,  807,  870,  933,  996,  1059, 1122, 1185, 1248, 1311,
  1374, 1437, 1500, 1563, 1626, 1689, 1752, 1815, 1878, 1941, 2004, 52,   115,
  178,  241,  304,  367,  430,  493,  556,  619,  682,  745,  808,  871,  934,
  997,  1060, 1123, 1186, 1249, 1312, 1375, 1438, 1501, 1564, 1627, 1690, 1753,
  1816, 1879, 1942, 2005, 53,   116,  179,  242,  305,  368,  431,  494,  557,
  620,  683,  746,  809,  872,  935,  998,  1061, 1124, 1187, 1250, 1313, 1376,
  1439, 1502, 1565, 1628, 1691, 1754, 1817, 1880, 1943, 2006, 54,   117,  180,
  243,  306,  369,  432,  495,  558,  621,  684,  747,  810,  873,  936,  999,
  1062, 1125, 1188, 1251, 1314, 1377, 1440, 1503, 1566, 1629, 1692, 1755, 1818,
  1881, 1944, 2007, 55,   118,  181,  244,  307,  370,  433,  496,  559,  622,
  685,  748,  811,  874,  937,  1000, 1063, 1126, 1189, 1252, 1315, 1378, 1441,
  1504, 1567, 1630, 1693, 1756, 1819, 1882, 1945, 2008, 56,   119,  182,  245,
  308,  371,  434,  497,  560,  623,  686,  749,  812,  875,  938,  1001, 1064,
  1127, 1190, 1253, 1316, 1379, 1442, 1505, 1568, 1631, 1694, 1757, 1820, 1883,
  1946, 2009, 57,   120,  183,  246,  309,  372,  435,  498,  561,  624,  687,
  750,  813,  876,  939,  1002, 1065, 1128, 1191, 1254, 1317, 1380, 1443, 1506,
  1569, 1632, 1695, 1758, 1821, 1884, 1947, 2010, 58,   121,  184,  247,  310,
  373,  436,  499,  562,  625,  688,  751,  814,  877,  940,  1003, 1066, 1129,
  1192, 1255, 1318, 1381, 1444, 1507, 1570, 1633, 1696, 1759, 1822, 1885, 1948,
  2011, 59,   122,  185,  248,  311,  374,  437,  500,  563,  626,  689,  752,
  815,  878,  941,  1004, 1067, 1130, 1193, 1256, 1319, 1382, 1445, 1508, 1571,
  1634, 1697, 1760, 1823, 1886, 1949, 2012, 60,   123,  186,  249,  312,  375,
  438,  501,  564,  627,  690,  753,  816,  879,  942,  1005, 1068, 1131, 1194,
  1257, 1320, 1383, 1446, 1509, 1572, 1635, 1698, 1761, 1824, 1887, 1950, 2013,
  61,   124,  187,  250,  313,  376,  439,  502,  565,  628,  691,  754,  817,
  880,  943,  1006, 1069, 1132, 1195, 1258, 1321, 1384, 1447, 1510, 1573, 1636,
  1699, 1762, 1825, 1888, 1951, 2014, 62,   125,  188,  251,  314,  377,  440,
  503,  566,  629,  692,  755,  818,  881,  944,  1007, 1070, 1133, 1196, 1259,
  1322, 1385, 1448, 1511, 1574, 1637, 1700, 1763, 1826, 1889, 1952, 2015, 63,
  126,  189,  252,  315,  378,  441,  504,  567,  630,  693,  756,  819,  882,
  945,  1008, 1071, 1134, 1197, 1260, 1323, 1386, 1449, 1512, 1575, 1638, 1701,
  1764, 1827, 1890, 1953, 2016, 127,  190,  253,  316,  379,  442,  505,  568,
  631,  694,  757,  820,  883,  946,  1009, 1072, 1135, 1198, 1261, 1324, 1387,
  1450, 1513, 1576, 1639, 1702, 1765, 1828, 1891, 1954, 2017, 191,  254,  317,
  380,  443,  506,  569,  632,  695,  758,  821,  884,  947,  1010, 1073, 1136,
  1199, 1262, 1325, 1388, 1451, 1514, 1577, 1640, 1703, 1766, 1829, 1892, 1955,
  2018, 255,  318,  381,  444,  507,  570,  633,  696,  759,  822,  885,  948,
  1011, 1074, 1137, 1200, 1263, 1326, 1389, 1452, 1515, 1578, 1641, 1704, 1767,
  1830, 1893, 1956, 2019, 319,  382,  445,  508,  571,  634,  697,  760,  823,
  886,  949,  1012, 1075, 1138, 1201, 1264, 1327, 1390, 1453, 1516, 1579, 1642,
  1705, 1768, 1831, 1894, 1957, 2020, 383,  446,  509,  572,  635,  698,  761,
  824,  887,  950,  1013, 1076, 1139, 1202, 1265, 1328, 1391, 1454, 1517, 1580,
  1643, 1706, 1769, 1832, 1895, 1958, 2021, 447,  510,  573,  636,  699,  762,
  825,  888,  951,  1014, 1077, 1140, 1203, 1266, 1329, 1392, 1455, 1518, 1581,
  1644, 1707, 1770, 1833, 1896, 1959, 2022, 511,  574,  637,  700,  763,  826,
  889,  952,  1015, 1078, 1141, 1204, 1267, 1330, 1393, 1456, 1519, 1582, 1645,
  1708, 1771, 1834, 1897, 1960, 2023, 575,  638,  701,  764,  827,  890,  953,
  1016, 1079, 1142, 1205, 1268, 1331, 1394, 1457, 1520, 1583, 1646, 1709, 1772,
  1835, 1898, 1961, 2024, 639,  702,  765,  828,  891,  954,  1017, 1080, 1143,
  1206, 1269, 1332, 1395, 1458, 1521, 1584, 1647, 1710, 1773, 1836, 1899, 1962,
  2025, 703,  766,  829,  892,  955,  1018, 1081, 1144, 1207, 1270, 1333, 1396,
  1459, 1522, 1585, 1648, 1711, 1774, 1837, 1900, 1963, 2026, 767,  830,  893,
  956,  1019, 1082, 1145, 1208, 1271, 1334, 1397, 1460, 1523, 1586, 1649, 1712,
  1775, 1838, 1901, 1964, 2027, 831,  894,  957,  1020, 1083, 1146, 1209, 1272,
  1335, 1398, 1461, 1524, 1587, 1650, 1713, 1776, 1839, 1902, 1965, 2028, 895,
  958,  1021, 1084, 1147, 1210, 1273, 1336, 1399, 1462, 1525, 1588, 1651, 1714,
  1777, 1840, 1903, 1966, 2029, 959,  1022, 1085, 1148, 1211, 1274, 1337, 1400,
  1463, 1526, 1589, 1652, 1715, 1778, 1841, 1904, 1967, 2030, 1023, 1086, 1149,
  1212, 1275, 1338, 1401, 1464, 1527, 1590, 1653, 1716, 1779, 1842, 1905, 1968,
  2031, 1087, 1150, 1213, 1276, 1339, 1402, 1465, 1528, 1591, 1654, 1717, 1780,
  1843, 1906, 1969, 2032, 1151, 1214, 1277, 1340, 1403, 1466, 1529, 1592, 1655,
  1718, 1781, 1844, 1907, 1970, 2033, 1215, 1278, 1341, 1404, 1467, 1530, 1593,
  1656, 1719, 1782, 1845, 1908, 1971, 2034, 1279, 1342, 1405, 1468, 1531, 1594,
  1657, 1720, 1783, 1846, 1909, 1972, 2035, 1343, 1406, 1469, 1532, 1595, 1658,
  1721, 1784, 1847, 1910, 1973, 2036, 1407, 1470, 1533, 1596, 1659, 1722, 1785,
  1848, 1911, 1974, 2037, 1471, 1534, 1597, 1660, 1723, 1786, 1849, 1912, 1975,
  2038, 1535, 1598, 1661, 1724, 1787, 1850, 1913, 1976, 2039, 1599, 1662, 1725,
  1788, 1851, 1914, 1977, 2040, 1663, 1726, 1789, 1852, 1915, 1978, 2041, 1727,
  1790, 1853, 1916, 1979, 2042, 1791, 1854, 1917, 1980, 2043, 1855, 1918, 1981,
  2044, 1919, 1982, 2045, 1983, 2046, 2047,
};

DECLARE_ALIGNED(16, static const int16_t, default_scan_64x64[4096]) = {
  0,    1,    64,   65,   2,    128,  66,   129,  130,  3,    192,  67,   193,
  131,  194,  4,    256,  68,   257,  195,  132,  258,  5,    196,  259,  320,
  69,   321,  133,  322,  260,  197,  323,  6,    384,  70,   385,  134,  386,
  261,  324,  198,  387,  7,    448,  71,   325,  449,  262,  388,  135,  450,
  199,  451,  326,  389,  8,    512,  72,   263,  452,  513,  136,  514,  390,
  200,  515,  327,  453,  264,  516,  9,    576,  73,   577,  137,  391,  454,
  578,  328,  517,  201,  579,  265,  580,  455,  10,   392,  518,  640,  74,
  641,  138,  642,  329,  581,  202,  643,  456,  519,  266,  644,  393,  582,
  11,   704,  75,   705,  139,  330,  645,  706,  520,  203,  457,  583,  707,
  394,  646,  267,  708,  12,   768,  76,   521,  584,  769,  331,  709,  140,
  770,  458,  647,  204,  771,  395,  710,  268,  772,  585,  522,  648,  13,
  332,  773,  832,  77,   459,  711,  833,  141,  834,  205,  835,  396,  774,
  586,  649,  269,  523,  712,  836,  460,  775,  333,  837,  14,   896,  78,
  897,  142,  650,  898,  587,  713,  206,  397,  838,  899,  524,  776,  270,
  900,  461,  839,  334,  651,  714,  901,  15,   588,  777,  960,  79,   961,
  143,  962,  398,  902,  525,  840,  207,  963,  271,  964,  715,  652,  778,
  462,  903,  335,  589,  841,  965,  16,   1024, 80,   1025, 144,  526,  904,
  1026, 399,  966,  208,  716,  779,  1027, 653,  842,  272,  1028, 463,  967,
  590,  905,  336,  1029, 780,  17,   527,  968,  1088, 81,   717,  843,  1089,
  400,  1030, 145,  1090, 654,  906,  209,  1091, 273,  464,  1031, 1092, 591,
  969,  781,  844,  337,  1093, 718,  907,  528,  1032, 18,   1152, 82,   401,
  655,  970,  1094, 1153, 146,  1154, 210,  1155, 592,  1033, 465,  845,  1095,
  274,  782,  908,  1156, 719,  971,  338,  1157, 529,  1096, 656,  1034, 402,
  1158, 19,   1216, 83,   1217, 147,  846,  909,  1218, 783,  972,  211,  593,
  1097, 1219, 466,  1159, 275,  720,  1035, 1220, 339,  1221, 530,  1160, 657,
  1098, 910,  847,  973,  403,  1222, 20,   784,  1036, 1280, 84,   1281, 148,
  1282, 594,  1161, 212,  1283, 467,  721,  1099, 1223, 276,  1284, 911,  974,
  658,  1162, 340,  531,  848,  1037, 1224, 1285, 785,  1100, 404,  1286, 21,
  1344, 85,   595,  1225, 1345, 149,  722,  1163, 1346, 468,  1287, 213,  975,
  1347, 912,  1038, 277,  1348, 849,  1101, 659,  1226, 532,  1288, 341,  1349,
  786,  1164, 405,  1350, 596,  976,  1039, 1289, 723,  1227, 22,   1408, 86,
  913,  1102, 1409, 150,  1410, 469,  1351, 214,  850,  1165, 1411, 278,  660,
  1290, 1412, 533,  787,  1228, 1352, 342,  1413, 1040, 977,  1103, 406,  914,
  1166, 1414, 724,  1291, 597,  1353, 23,   1472, 87,   851,  1229, 1473, 151,
  470,  1415, 1474, 215,  1475, 661,  1354, 788,  1292, 279,  1041, 1104, 1476,
  534,  1416, 978,  1167, 343,  1477, 915,  1230, 725,  1355, 407,  598,  1417,
  1478, 852,  1293, 24,   1536, 88,   1537, 471,  1105, 1479, 152,  1042, 1168,
  1538, 662,  1418, 216,  789,  1356, 1539, 979,  1231, 280,  1540, 535,  1480,
  916,  1294, 344,  1541, 726,  1419, 599,  853,  1357, 1481, 408,  1542, 1106,
  1169, 1043, 1232, 25,   472,  980,  1295, 1543, 1600, 89,   1601, 790,  1420,
  153,  663,  1482, 1602, 217,  1603, 917,  1358, 536,  1544, 281,  1604, 1170,
  345,  727,  1107, 1233, 1483, 1605, 854,  1421, 1044, 1296, 600,  1545, 409,
  1606, 981,  1359, 791,  1484, 473,  1607, 26,   664,  1546, 1664, 90,   1665,
  154,  918,  1422, 1666, 218,  1171, 1234, 1667, 537,  1108, 1297, 1608, 282,
  1668, 728,  1045, 1360, 1547, 855,  1485, 346,  1669, 601,  1609, 982,  1423,
  410,  1670, 792,  1548, 1235, 1172, 1298, 474,  665,  919,  1486, 1610, 1671,
  27,   1728, 91,   1109, 1361, 1729, 155,  1730, 219,  1731, 538,  1046, 1424,
  1672, 283,  856,  1549, 1732, 729,  1611, 347,  983,  1487, 1733, 602,  1673,
  1236, 1299, 411,  1173, 1362, 1734, 793,  1612, 920,  1550, 1110, 1425, 666,
  1674, 475,  1735, 28,   1792, 92,   1047, 1488, 1793, 156,  1794, 220,  539,
  1736, 1795, 857,  1613, 730,  1675, 284,  1300, 1796, 984,  1551, 1237, 1363,
  1174, 1426, 348,  1797, 603,  1737, 1111, 1489, 412,  794,  1676, 1798, 921,
  1614, 667,  1738, 1048, 1552, 476,  1799, 29,   1301, 1364, 1856, 93,   1857,
  157,  858,  1238, 1427, 1677, 1858, 540,  1800, 221,  731,  985,  1615, 1739,
  1859, 1175, 1490, 285,  1860, 604,  1112, 1553, 1801, 349,  1861, 922,  1678,
  795,  1740, 413,  1862, 1049, 1616, 1365, 668,  1302, 1428, 1802, 477,  1239,
  1491, 1863, 859,  1741, 30,   1176, 1554, 1920, 94,   986,  1679, 1921, 158,
  1922, 541,  732,  1803, 1864, 222,  1923, 1113, 1617, 286,  1924, 605,  1865,
  350,  923,  1366, 1429, 1742, 1925, 796,  1804, 1303, 1492, 1050, 1680, 414,
  1926, 1240, 1555, 669,  1866, 478,  1177, 1618, 1927, 860,  1805, 987,  1743,
  31,   1984, 95,   733,  1867, 1985, 542,  1928, 159,  1114, 1681, 1986, 1430,
  223,  1367, 1493, 1987, 1304, 1556, 287,  1988, 924,  1806, 606,  1929, 797,
  1051, 1744, 1868, 351,  1241, 1619, 1989, 415,  1990, 670,  1178, 1682, 1930,
  988,  1807, 479,  861,  1869, 1991, 1431, 1494, 1368, 1557, 1115, 1745, 734,
  1931, 32,   2048, 96,   543,  1305, 1620, 1992, 2049, 160,  2050, 224,  2051,
  925,  1242, 1683, 1870, 288,  1052, 1808, 2052, 607,  1993, 798,  1932, 352,
  2053, 1179, 1746, 1495, 416,  1432, 1558, 2054, 671,  1994, 989,  1369, 1621,
  1871, 862,  1933, 480,  1116, 1809, 2055, 1306, 1684, 735,  1995, 544,  2056,
  33,   2112, 97,   1243, 1747, 2113, 161,  2114, 926,  1934, 1053, 1872, 225,
  2115, 289,  608,  799,  1496, 1559, 1996, 2057, 2116, 1180, 1810, 1433, 1622,
  353,  2117, 1370, 1685, 672,  2058, 417,  990,  1935, 2118, 1307, 1748, 863,
  1117, 1873, 1997, 481,  2119, 736,  1244, 1811, 2059, 1560, 545,  2120, 1497,
  1623, 34,   1054, 1936, 2176, 98,   927,  1998, 2177, 162,  1434, 1686, 2178,
  226,  1181, 1874, 2179, 800,  2060, 609,  1371, 1749, 2121, 290,  2180, 354,
  2181, 1308, 1812, 991,  1999, 673,  1118, 1937, 2122, 418,  2182, 864,  2061,
  1561, 1624, 1245, 1875, 482,  1498, 1687, 2183, 737,  2123, 1435, 1750, 1055,
  2000, 546,  928,  2062, 2184, 1182, 1938, 35,   1372, 1813, 2240, 99,   2241,
  163,  2242, 801,  2124, 227,  2243, 610,  2185, 291,  1309, 1876, 2244, 992,
  2063, 355,  1119, 1625, 2001, 2245, 1562, 1688, 674,  2186, 865,  1499, 1751,
  2125, 419,  1246, 1939, 2246, 1436, 1814, 483,  2247, 738,  2187, 1056, 2064,
  1373, 1877, 929,  1183, 2002, 2126, 547,  2248, 36,   2304, 100,  2305, 164,
  802,  1310, 1940, 2188, 2306, 1626, 1689, 228,  1563, 1752, 2307, 611,  2249,
  292,  2308, 1120, 1500, 1815, 2065, 993,  2127, 356,  2309, 1247, 2003, 675,
  866,  1437, 1878, 2189, 2250, 420,  2310, 1374, 1941, 484,  1057, 2128, 2311,
  739,  2251, 1184, 2066, 930,  1690, 2190, 1627, 1753, 548,  1564, 1816, 2312,
  1311, 2004, 37,   803,  2252, 2368, 101,  1501, 1879, 2369, 165,  2370, 612,
  2313, 229,  1121, 2129, 2371, 994,  2191, 1438, 1942, 293,  1248, 2067, 2372,
  357,  867,  2253, 2373, 676,  2314, 1375, 2005, 421,  1691, 1754, 2374, 1628,
  1817, 1058, 2192, 1185, 2130, 740,  1565, 1880, 2315, 485,  2375, 931,  2254,
  1312, 2068, 1502, 1943, 549,  2376, 804,  2316, 38,   2432, 102,  1122, 1439,
  2006, 2193, 2433, 166,  2434, 613,  995,  1249, 2131, 2255, 2377, 230,  2435,
  1755, 294,  1692, 1818, 2436, 868,  1376, 2069, 2317, 1629, 1881, 358,  677,
  2378, 2437, 1566, 1944, 422,  1186, 2194, 2438, 1059, 2256, 1313, 2132, 741,
  1503, 2007, 2379, 932,  2318, 486,  2439, 550,  1440, 2070, 2440, 805,  1756,
  1819, 2380, 1123, 2257, 1250, 1693, 1882, 2195, 39,   996,  2319, 2496, 103,
  2497, 167,  614,  1630, 1945, 2441, 2498, 231,  1377, 2133, 2499, 295,  1567,
  2008, 2500, 869,  2381, 678,  2442, 359,  2501, 1187, 2258, 1060, 2320, 1504,
  2071, 1314, 2196, 423,  2502, 742,  933,  2382, 2443, 1820, 487,  1757, 1883,
  2503, 1441, 2134, 1694, 1946, 551,  1124, 2321, 2504, 1251, 1631, 2009, 2259,
  806,  2444, 997,  2383, 1378, 2197, 40,   1568, 2072, 2560, 104,  2561, 615,
  2505, 168,  2562, 232,  2563, 870,  2445, 296,  2564, 1505, 2135, 1188, 2322,
  679,  2506, 360,  1061, 1315, 1821, 1884, 2260, 2384, 2565, 1758, 1947, 424,
  2566, 1695, 2010, 934,  1442, 2198, 2446, 743,  2507, 488,  1632, 2073, 2567,
  1252, 2323, 1125, 2385, 552,  2568, 807,  1569, 2136, 2508, 1379, 2261, 998,
  2447, 41,   616,  2569, 2624, 105,  1885, 2625, 1822, 1948, 169,  1506, 2199,
  2626, 233,  871,  1759, 2011, 2509, 2627, 1189, 2386, 1316, 2324, 297,  2628,
  680,  1062, 1696, 2074, 2448, 2570, 361,  2629, 1443, 2262, 1633, 2137, 425,
  935,  2510, 2630, 744,  2571, 489,  1253, 2387, 2631, 1570, 2200, 1126, 2449,
  1380, 2325, 1886, 1949, 808,  2572, 553,  1823, 2012, 2632, 999,  2511, 1760,
  2075, 1507, 2263, 617,  2633, 42,   2688, 106,  1697, 2138, 2689, 170,  1190,
  2450, 2690, 872,  1317, 2388, 2573, 234,  2691, 1063, 2512, 298,  1444, 2326,
  2692, 681,  1634, 2201, 2634, 362,  2693, 936,  2574, 426,  1950, 2694, 1571,
  2264, 745,  1887, 2013, 2635, 1254, 2451, 1824, 2076, 1127, 1381, 2389, 2513,
  490,  2695, 1761, 2139, 809,  1000, 1508, 2327, 2575, 2636, 554,  2696, 1698,
  2202, 1318, 2452, 618,  1191, 2514, 2697, 43,   2752, 107,  873,  1635, 2265,
  2637, 2753, 171,  1445, 2390, 2754, 1064, 2576, 235,  2755, 1951, 2014, 682,
  2698, 299,  1888, 2077, 2756, 1572, 2328, 1825, 2140, 363,  2757, 937,  2638,
  1255, 2515, 427,  746,  1382, 1762, 2203, 2453, 2699, 2758, 1128, 2577, 491,
  1509, 2391, 2759, 1699, 2266, 1001, 2639, 810,  2700, 555,  2760, 1319, 1636,
  2329, 2516, 2015, 1192, 1952, 2078, 2578, 1446, 2454, 619,  1889, 2141, 2761,
  874,  2701, 44,   2816, 108,  1065, 2640, 2817, 172,  1826, 2204, 2818, 236,
  1573, 2392, 2819, 683,  2762, 300,  2820, 1763, 2267, 938,  2702, 364,  1256,
  2579, 2821, 1383, 2517, 747,  1129, 2641, 2763, 428,  1700, 2330, 2822, 1510,
  2455, 492,  2016, 2079, 2823, 1002, 1953, 2142, 2703, 811,  2764, 1637, 2393,
  1890, 2205, 556,  1320, 2580, 2824, 1193, 1447, 2518, 2642, 1827, 2268, 620,
  2825, 875,  2765, 1066, 1574, 2456, 2704, 45,   1764, 2331, 2880, 109,  2881,
  173,  2882, 237,  2883, 684,  2826, 301,  1384, 2581, 2884, 1257, 2643, 939,
  1701, 2394, 2766, 2080, 365,  1511, 2017, 2143, 2519, 2885, 1130, 2705, 1954,
  2206, 748,  2827, 429,  2886, 1891, 2269, 1638, 2457, 493,  1003, 2767, 2887,
  812,  1828, 2332, 2828, 1321, 2644, 1448, 2582, 1194, 2706, 557,  2888, 1575,
  2520, 1765, 2395, 876,  1067, 2768, 2829, 621,  2889, 2081, 2144, 46,   2944,
  110,  2018, 2207, 2945, 174,  1702, 2458, 2946, 1385, 2645, 238,  685,  1258,
  1955, 2270, 2707, 2890, 2947, 1512, 2583, 302,  940,  2830, 2948, 1892, 2333,
  1131, 2769, 366,  2949, 749,  1639, 2521, 2891, 430,  2950, 1829, 2396, 1004,
  2831, 1322, 2708, 494,  1449, 2646, 2951, 813,  2892, 1195, 1766, 2459, 2770,
  1576, 2584, 2145, 558,  2082, 2208, 2952, 2019, 2271, 1068, 2832, 877,  2893,
  1956, 2334, 622,  1703, 2522, 2953, 1386, 2709, 47,   3008, 111,  1259, 1513,
  1893, 2397, 2647, 2771, 3009, 175,  3010, 686,  2954, 239,  3011, 941,  2894,
  303,  1132, 1640, 2585, 2833, 3012, 1830, 2460, 367,  3013, 750,  2955, 431,
  2146, 2209, 3014, 1450, 2710, 1323, 2083, 2272, 2772, 1005, 1767, 2523, 2895,
  1577, 2020, 2335, 2648, 495,  3015, 814,  1196, 2834, 2956, 1957, 2398, 559,
  3016, 1704, 2586, 1069, 2896, 878,  1894, 2461, 2957, 623,  1387, 2773, 3017,
  1514, 2711, 1260, 2835, 48,   3072, 112,  1831, 2524, 3073, 1641, 2649, 176,
  3074, 687,  3018, 942,  2210, 2958, 240,  3075, 1133, 2147, 2273, 2897, 304,
  2084, 2336, 3076, 368,  1768, 2587, 3077, 751,  2021, 2399, 3019, 1451, 2774,
  1324, 2836, 432,  1578, 2712, 3078, 1006, 2959, 1958, 2462, 1197, 2898, 496,
  815,  3020, 3079, 1705, 2650, 1895, 2525, 560,  3080, 1070, 2960, 1388, 2837,
  879,  1515, 2775, 3021, 2211, 2274, 1832, 2588, 624,  2148, 2337, 3081, 1261,
  2899, 1642, 2713, 2085, 2400, 49,   3136, 113,  3137, 688,  3082, 177,  943,
  1134, 2022, 2463, 2961, 3022, 3138, 241,  1769, 2651, 3139, 305,  3140, 1452,
  2838, 1959, 2526, 752,  1325, 1579, 2776, 2900, 3083, 369,  3141, 1007, 3023,
  433,  3142, 1198, 1706, 2714, 2962, 1896, 2589, 816,  3084, 497,  2275, 3143,
  2212, 2338, 2149, 2401, 561,  1071, 1516, 1833, 2652, 2839, 3024, 3144, 1389,
  2901, 2086, 2464, 880,  3085, 1643, 2777, 1262, 2963, 625,  2023, 2527, 3145,
  1770, 2715, 1135, 3025, 50,   944,  1960, 2590, 3086, 3200, 114,  689,  3146,
  3201, 178,  3202, 242,  1453, 2902, 3203, 1580, 2840, 306,  1326, 2964, 3204,
  2276, 2339, 753,  1897, 2653, 3147, 370,  1707, 2213, 2402, 2778, 3205, 1008,
  3087, 1199, 2150, 2465, 3026, 434,  3206, 817,  2087, 2528, 3148, 1834, 2716,
  498,  3207, 1517, 2903, 1390, 2965, 1072, 3088, 1644, 2024, 2591, 2841, 562,
  3208, 881,  1263, 3027, 3149, 1771, 2779, 626,  1961, 2654, 3209, 2340, 1136,
  3089, 2277, 2403, 945,  3150, 690,  1454, 2214, 2466, 2966, 3210, 51,   1581,
  2904, 3264, 115,  3265, 179,  1898, 2717, 3266, 1327, 3028, 243,  2151, 2529,
  3267, 1708, 2842, 307,  3268, 754,  3211, 2088, 2592, 371,  1009, 3151, 3269,
  1200, 3090, 1835, 2780, 435,  3270, 2025, 2655, 818,  3212, 1518, 2967, 499,
  1391, 1645, 2905, 3029, 3271, 1073, 3152, 1962, 2718, 563,  1264, 1772, 2341,
  2404, 2843, 3091, 3272, 882,  2278, 2467, 3213, 2215, 2530, 627,  3273, 2152,
  2593, 1137, 1899, 2781, 3153, 1582, 2968, 1455, 3030, 946,  3214, 691,  1709,
  2906, 3274, 52,   1328, 3092, 3328, 116,  2089, 2656, 3329, 180,  3330, 244,
  3331, 308,  1836, 2844, 3332, 755,  3275, 1010, 1201, 2026, 2719, 3154, 3215,
  372,  3333, 1519, 2405, 3031, 436,  2342, 2468, 3334, 1646, 2969, 819,  1392,
  3093, 3276, 2279, 2531, 1963, 2782, 500,  3335, 1773, 2907, 1074, 2216, 2594,
  3216, 1265, 3155, 564,  3336, 883,  2153, 2657, 3277, 1900, 2845, 628,  1583,
  3032, 3337, 1456, 2090, 2720, 3094, 1138, 3217, 1710, 2970, 947,  3278, 1329,
  3156, 692,  3338, 53,   1837, 2908, 3392, 117,  2027, 2783, 3393, 181,  2406,
  2469, 3394, 2343, 2532, 245,  3395, 1202, 3218, 309,  756,  2280, 2595, 3339,
  3396, 1011, 3279, 1520, 3095, 373,  1647, 3033, 3397, 1964, 2846, 2217, 2658,
  1393, 3157, 437,  1774, 2971, 3398, 820,  3340, 2154, 2721, 1075, 3280, 501,
  3399, 1266, 3219, 1901, 2909, 565,  884,  2091, 2784, 3341, 3400, 1584, 3096,
  1457, 1711, 3034, 3158, 2470, 629,  1139, 2407, 2533, 3281, 3401, 2344, 2596,
  2028, 2847, 948,  1330, 1838, 2972, 3220, 3342, 2281, 2659, 693,  3402, 54,
  3456, 118,  3457, 182,  2218, 2722, 3458, 246,  1203, 1965, 2910, 3282, 3459,
  1012, 1648, 3097, 3343, 757,  1521, 3159, 3403, 310,  3460, 1775, 2155, 2785,
  3035, 374,  1394, 3221, 3461, 438,  3462, 821,  3404, 1902, 2973, 1076, 2092,
  2848, 3344, 1267, 3283, 502,  2471, 2534, 3463, 2408, 2597, 1585, 2345, 2660,
  3160, 885,  3405, 566,  1712, 3098, 3464, 1458, 3222, 2029, 2911, 2282, 2723,
  1140, 1839, 3036, 3345, 630,  3465, 1331, 3284, 949,  2219, 2786, 3406, 694,
  1966, 2974, 3466, 55,   2156, 2849, 3520, 119,  1649, 3161, 3521, 1204, 3346,
  183,  1522, 3223, 3522, 1776, 3099, 247,  1013, 3407, 3523, 758,  3467, 311,
  3524, 1395, 2535, 3285, 2472, 2598, 2093, 2912, 375,  1903, 2409, 2661, 3037,
  3525, 822,  2346, 2724, 3468, 439,  3526, 1077, 1268, 3347, 3408, 503,  2283,
  2787, 3527, 1586, 3224, 1713, 2030, 2975, 3162, 886,  1459, 3286, 3469, 1840,
  3100, 567,  3528, 2220, 2850, 1141, 3409, 1332, 3348, 631,  3529, 1967, 3038,
  950,  3470, 2157, 2913, 2536, 2599, 695,  1650, 2473, 2662, 3225, 3530, 1523,
  1777, 3163, 3287, 1205, 2410, 2725, 3410, 56,   3584, 120,  3585, 184,  2094,
  2976, 3586, 1014, 3471, 248,  1396, 1904, 2347, 2788, 3101, 3349, 3587, 759,
  3531, 312,  3588, 376,  2284, 2851, 3589, 823,  3532, 1269, 2031, 3039, 3411,
  440,  1078, 3472, 3590, 1714, 3226, 1587, 3288, 2221, 2914, 504,  1841, 3164,
  3591, 1460, 3350, 887,  3533, 568,  2600, 3592, 2537, 2663, 1968, 3102, 1142,
  2158, 2977, 3473, 2474, 2726, 1333, 3412, 632,  3593, 2411, 2789, 951,  3534,
  1651, 3289, 1778, 3227, 2348, 2852, 1524, 2095, 3040, 3351, 696,  3594, 1206,
  3474, 1905, 3165, 57,   3648, 121,  1015, 1397, 2285, 2915, 3413, 3535, 3649,
  185,  3650, 760,  3595, 249,  3651, 313,  2032, 3103, 3652, 2222, 2978, 377,
  3653, 1270, 1715, 3290, 3475, 824,  1588, 3352, 3596, 1079, 2601, 2664, 3536,
  1842, 3228, 441,  2538, 2727, 3654, 1461, 2475, 2790, 3414, 505,  2159, 3041,
  3655, 1969, 3166, 888,  2412, 2853, 3597, 569,  3656, 1143, 3537, 1334, 3476,
  2349, 2916, 2096, 3104, 1652, 3353, 633,  1779, 3291, 3657, 952,  3598, 1525,
  3415, 1906, 2286, 2979, 3229, 697,  1207, 3538, 3658, 1398, 3477, 1016, 3599,
  2033, 2665, 3167, 58,   2602, 2728, 3712, 122,  2223, 3042, 3713, 186,  3714,
  761,  2539, 2791, 3659, 250,  3715, 314,  1716, 2476, 2854, 3354, 3716, 1589,
  1843, 3292, 3416, 1271, 3539, 378,  3717, 1080, 3600, 825,  2160, 3105, 3660,
  2413, 2917, 442,  1462, 1970, 3230, 3478, 3718, 2350, 2980, 506,  3719, 889,
  3661, 1144, 1335, 2097, 3168, 3540, 3601, 570,  3720, 1780, 3355, 1653, 2287,
  3043, 3417, 1907, 3293, 634,  953,  1526, 2666, 2729, 3479, 3662, 3721, 2603,
  2792, 2540, 2855, 1208, 2224, 3106, 3602, 2034, 3231, 698,  3722, 1399, 3541,
  2477, 2918, 1017, 3663, 59,   3776, 123,  3777, 187,  762,  1717, 2414, 2981,
  3418, 3723, 3778, 1844, 3356, 251,  2161, 3169, 3779, 1590, 3480, 315,  1272,
  3603, 3780, 1971, 3294, 1081, 2351, 3044, 3664, 379,  3781, 826,  3724, 1463,
  3542, 443,  3782, 2098, 3232, 2730, 2288, 3107, 507,  2667, 2793, 3783, 890,
  3725, 1336, 2604, 2856, 3604, 1145, 1781, 3419, 3665, 1654, 3481, 571,  1908,
  3357, 3784, 2541, 2919, 1527, 3543, 2225, 3170, 954,  2478, 2982, 3726, 635,
  2035, 3295, 3785, 1209, 3666, 1400, 3605, 2415, 3045, 699,  3786, 1018, 2162,
  3233, 3727, 1718, 3482, 1845, 3420, 60,   2352, 3108, 3840, 124,  1591, 3544,
  3841, 763,  3787, 188,  1972, 3358, 3842, 252,  3843, 1273, 3667, 2731, 2794,
  316,  3844, 2668, 2857, 1082, 1464, 3606, 3728, 380,  827,  2099, 2605, 2920,
  3296, 3788, 3845, 2289, 3171, 444,  3846, 2542, 2983, 1782, 3483, 508,  1337,
  3668, 3847, 891,  1655, 1909, 3421, 3545, 3789, 1146, 2479, 3046, 3729, 2226,
  3234, 572,  3848, 1528, 2036, 3359, 3607, 2416, 3109, 955,  3790, 636,  3849,
  1210, 3730, 1401, 2163, 3297, 3669, 2353, 3172, 2795, 700,  1846, 2732, 2858,
  3484, 3850, 1719, 3546, 1019, 2669, 2921, 3791, 1973, 3422, 1592, 3608, 2606,
  2984, 61,   764,  3851, 3904, 125,  3905, 189,  1274, 2290, 3235, 3731, 3906,
  2100, 3360, 253,  2543, 3047, 3907, 1465, 3670, 317,  1083, 3792, 3908, 828,
  3852, 381,  3909, 2480, 3110, 1783, 3547, 445,  1910, 2227, 3298, 3485, 3910,
  1656, 3609, 1338, 3732, 892,  3853, 509,  1147, 2037, 2417, 3173, 3423, 3793,
  3911, 1529, 3671, 573,  2796, 2859, 3912, 2733, 2922, 2164, 3361, 956,  2354,
  3236, 3854, 2670, 2985, 637,  3913, 1211, 1402, 3733, 3794, 1847, 2607, 3048,
  3548, 1720, 3610, 1974, 3486, 701,  3914, 1020, 1593, 2544, 3111, 3672, 3855,
  2291, 3299, 2101, 3424, 765,  1275, 3795, 3915, 62,   3968, 126,  2481, 3174,
  3969, 190,  1466, 3734, 3970, 254,  3971, 1084, 3856, 318,  2228, 3362, 3972,
  829,  1784, 3611, 3916, 1911, 3549, 382,  2418, 3237, 3973, 2860, 1657, 2797,
  2923, 3673, 2038, 3487, 446,  2734, 2986, 3974, 1339, 3796, 1148, 3857, 893,
  2671, 3049, 3917, 510,  1530, 3735, 3975, 2355, 3300, 2165, 3425, 2608, 3112,
  574,  3976, 957,  3918, 1848, 3612, 1403, 2545, 3175, 3797, 1212, 3858, 638,
  1721, 1975, 3550, 3674, 3977, 2292, 3363, 1594, 2102, 3488, 3736, 702,  2482,
  3238, 3978, 1021, 3919, 1276, 2861, 2924, 3859, 766,  1467, 2229, 2798, 2987,
  3426, 3798, 3979, 63,   4032, 127,  2419, 3301, 4033, 191,  2735, 3050, 4034,
  1085, 1912, 3613, 3920, 255,  1785, 3675, 4035, 319,  2672, 3113, 4036, 2039,
  3551, 830,  3980, 1658, 3737, 383,  4037, 1340, 2356, 3364, 3860, 2609, 3176,
  447,  2166, 3489, 4038, 1149, 1531, 3799, 3921, 894,  3981, 511,  4039, 2546,
  3239, 575,  1849, 3676, 4040, 2293, 3427, 1976, 3614, 958,  1722, 3738, 3982,
  1404, 3861, 1213, 2483, 3302, 3922, 2103, 3552, 639,  2925, 4041, 2862, 2988,
  1595, 3800, 2799, 3051, 2736, 3114, 703,  1022, 3983, 4042, 2230, 3490, 2420,
  3365, 1277, 2673, 3177, 3923, 1468, 3862, 767,  1913, 3677, 4043, 1786, 3739,
  2040, 3615, 1086, 2610, 3240, 3984, 2357, 3428, 1659, 3801, 831,  4044, 2167,
  3553, 1341, 3924, 2547, 3303, 1532, 3863, 1150, 3985, 895,  4045, 2294, 2926,
  2989, 3491, 2863, 3052, 1850, 2484, 3366, 3740, 1977, 3678, 2800, 3115, 1723,
  3802, 2104, 3616, 1405, 3925, 959,  2737, 3178, 4046, 1214, 3986, 1596, 3864,
  2421, 3429, 2231, 2674, 3241, 3554, 1023, 4047, 2611, 3304, 1278, 1469, 1914,
  3741, 3926, 3987, 1787, 2041, 3679, 3803, 2358, 3492, 1087, 1660, 2168, 2548,
  3367, 3617, 3865, 4048, 2990, 2927, 3053, 2864, 3116, 1342, 3988, 1533, 2295,
  2801, 3179, 3555, 3927, 2485, 3430, 1151, 4049, 1978, 2738, 3242, 3742, 1851,
  3804, 2105, 3680, 1724, 3866, 2675, 3305, 1406, 2422, 3493, 3989, 2232, 3618,
  1215, 4050, 1597, 3928, 2612, 3368, 2359, 3556, 1915, 3805, 2042, 2991, 3054,
  3743, 1470, 3990, 1788, 2928, 3117, 3867, 1279, 2549, 3431, 4051, 2865, 3180,
  2169, 3681, 1661, 3929, 2802, 3243, 2486, 3494, 2296, 3619, 2739, 3306, 1343,
  4052, 1534, 3991, 1979, 3806, 1852, 3868, 2676, 3369, 2106, 3744, 2423, 3557,
  1725, 3930, 2233, 3682, 2613, 3432, 1407, 4053, 3055, 1598, 2992, 3118, 3992,
  2929, 3181, 2360, 3620, 2866, 3244, 2550, 3495, 1916, 3869, 2043, 3807, 1789,
  2803, 3307, 3931, 1471, 2170, 3745, 4054, 2740, 3370, 1662, 2487, 3558, 3993,
  2297, 3683, 2677, 3433, 1535, 4055, 1980, 3870, 1853, 2107, 2424, 3621, 3808,
  3932, 3056, 3119, 2614, 3496, 2993, 3182, 1726, 2234, 3746, 3994, 2930, 3245,
  2867, 3308, 1599, 2361, 3684, 4056, 2551, 3559, 2804, 3371, 2044, 3871, 1917,
  3933, 2171, 3809, 1790, 2741, 3434, 3995, 2488, 3622, 2298, 3747, 1663, 4057,
  2678, 3497, 3120, 3057, 3183, 2994, 3246, 2425, 3685, 1981, 3934, 2108, 3872,
  2615, 3560, 2931, 3309, 1854, 3996, 2235, 3810, 2868, 3372, 1727, 4058, 2552,
  3623, 2805, 3435, 2362, 3748, 2742, 3498, 2045, 3935, 1918, 3997, 2172, 3873,
  2489, 3686, 1791, 4059, 3121, 3184, 2299, 2679, 3561, 3811, 3058, 3247, 2995,
  3310, 2932, 3373, 2426, 3749, 2616, 3624, 1982, 3998, 2109, 2869, 3436, 3936,
  1855, 4060, 2236, 3874, 2806, 3499, 2553, 3687, 2363, 3812, 2743, 3562, 3185,
  3122, 3248, 2046, 3999, 2490, 3750, 1919, 2173, 3059, 3311, 3937, 4061, 2680,
  3625, 2996, 3374, 2300, 3875, 2933, 3437, 2617, 3688, 2427, 3813, 2870, 3500,
  2110, 4000, 1983, 4062, 2807, 3563, 2237, 3938, 2554, 3751, 2364, 3876, 2744,
  3626, 3186, 3249, 3123, 3312, 3060, 3375, 2491, 2997, 3438, 3814, 2047, 2681,
  3689, 4063, 2174, 4001, 2934, 3501, 2301, 3939, 2871, 3564, 2618, 3752, 2428,
  3877, 2808, 3627, 2111, 4064, 2238, 3250, 4002, 2555, 3187, 3313, 3815, 3124,
  3376, 2745, 3690, 2365, 3940, 3061, 3439, 2998, 3502, 2492, 3878, 2682, 3753,
  2935, 3565, 2175, 4065, 2302, 4003, 2872, 3628, 2619, 3816, 2429, 3941, 2809,
  3691, 3251, 3314, 3188, 3377, 3125, 3440, 2556, 3879, 2239, 3062, 3503, 4066,
  2746, 3754, 2366, 4004, 2999, 3566, 2936, 3629, 2683, 3817, 2493, 3942, 2873,
  3692, 2303, 4067, 2620, 3880, 3315, 3252, 3378, 3189, 3441, 2430, 2810, 3755,
  4005, 3126, 3504, 3063, 3567, 2557, 3943, 2747, 3818, 3000, 3630, 2367, 4068,
  2937, 3693, 2684, 3881, 2494, 4006, 2874, 3756, 3316, 3379, 3253, 3442, 3190,
  3505, 2621, 3944, 3127, 3568, 2811, 3819, 2431, 4069, 3064, 3631, 2748, 3882,
  2558, 3001, 3694, 4007, 2938, 3757, 2685, 3945, 3380, 3317, 3443, 2495, 4070,
  3254, 3506, 2875, 3820, 3191, 3569, 3128, 3632, 2622, 4008, 2812, 3883, 3065,
  3695, 3002, 3758, 2749, 3946, 2559, 4071, 2939, 3821, 3381, 3444, 3318, 3507,
  2686, 3255, 3570, 4009, 2876, 3884, 3192, 3633, 3129, 3696, 2623, 4072, 2813,
  3947, 3066, 3759, 3003, 3822, 2750, 4010, 3445, 3382, 3508, 2940, 3885, 3319,
  3571, 3256, 3634, 2687, 3193, 3697, 4073, 2877, 3948, 3130, 3760, 3067, 3823,
  2814, 4011, 3004, 3886, 3446, 3509, 3383, 3572, 2751, 4074, 3320, 3635, 2941,
  3949, 3257, 3698, 3194, 3761, 2878, 4012, 3131, 3824, 3068, 3887, 2815, 4075,
  3510, 3447, 3573, 3005, 3950, 3384, 3636, 3321, 3699, 3258, 3762, 2942, 4013,
  3195, 3825, 3132, 3888, 2879, 4076, 3069, 3951, 3511, 3574, 3448, 3637, 3385,
  3700, 3006, 4014, 3322, 3763, 3259, 3826, 2943, 4077, 3196, 3889, 3133, 3952,
  3575, 3512, 3638, 3070, 4015, 3449, 3701, 3386, 3764, 3323, 3827, 3007, 4078,
  3260, 3890, 3197, 3953, 3134, 4016, 3576, 3639, 3513, 3702, 3450, 3765, 3071,
  4079, 3387, 3828, 3324, 3891, 3261, 3954, 3198, 4017, 3640, 3135, 4080, 3577,
  3703, 3514, 3766, 3451, 3829, 3388, 3892, 3325, 3955, 3262, 4018, 3199, 4081,
  3641, 3704, 3578, 3767, 3515, 3830, 3452, 3893, 3389, 3956, 3326, 4019, 3263,
  4082, 3705, 3642, 3768, 3579, 3831, 3516, 3894, 3453, 3957, 3390, 4020, 3327,
  4083, 3706, 3769, 3643, 3832, 3580, 3895, 3517, 3958, 3454, 4021, 3391, 4084,
  3770, 3707, 3833, 3644, 3896, 3581, 3959, 3518, 4022, 3455, 4085, 3771, 3834,
  3708, 3897, 3645, 3960, 3582, 4023, 3519, 4086, 3835, 3772, 3898, 3709, 3961,
  3646, 4024, 3583, 4087, 3836, 3899, 3773, 3962, 3710, 4025, 3647, 4088, 3900,
  3837, 3963, 3774, 4026, 3711, 4089, 3901, 3964, 3838, 4027, 3775, 4090, 3965,
  3902, 4028, 3839, 4091, 3966, 4029, 3903, 4092, 4030, 3967, 4093, 4031, 4094,
  4095,
};
#endif  // CONFIG_TX64X64

#if CONFIG_CHROMA_2X2
DECLARE_ALIGNED(16, static const int16_t,
                default_scan_2x2_neighbors[5 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 0, 1, 1, 2, 0, 0,
};
#endif

// Neighborhood 2-tuples for various scans and blocksizes,
// in {top, left} order for each position in corresponding scan order.
DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 4,  0, 1, 4, 4, 5,  5,  1, 8,  8,  5,  8, 2,
  2, 2, 5, 9, 12, 6, 9, 3, 6, 10, 13, 7, 10, 11, 14, 0, 0,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 4, 4,  8,  8, 0, 0, 1, 4, 5,  8,  9,  12, 1,
  1, 2, 5, 6, 9, 10, 13, 2, 2, 3, 6, 7, 10, 11, 14, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 1, 1, 2,  2, 0, 0, 1,  4,  2,  5,  3,  6, 4,
  4, 5, 8, 6, 9, 7, 10, 8, 8, 9, 12, 10, 13, 11, 14, 0, 0,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                col_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0,  0, 0, 0, 4, 4, 4, 0, 8, 8,  1,  4, 5,  8,  5,  1, 9,
  12, 2, 5, 6, 9, 6, 2, 3, 6, 10, 13, 7, 10, 11, 14, 0, 0,
};

DECLARE_ALIGNED(16, static const int16_t,
                row_scan_4x4_neighbors[17 * MAX_NEIGHBORS]) = {
  0, 0, 0, 0, 0, 1, 1, 1, 1,  4, 2,  2,  2,  5,  4,  5, 5,
  8, 3, 6, 8, 9, 6, 9, 9, 12, 7, 10, 10, 13, 11, 14, 0, 0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  4,  1,  1,  4,  4,  2,  5,  5,  8,  6,
  9,  2,  2,  8,  8,  3,  6,  9,  12, 7,  10, 10, 13, 12, 12, 13, 16,
  11, 14, 14, 17, 15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21,
  24, 22, 25, 23, 26, 24, 24, 25, 28, 26, 29, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0, 0, 0,  0,  4,  4,  8,  8,  12, 12, 16, 16, 20, 20, 24, 24, 0,
  0, 1, 4,  5,  8,  9,  12, 13, 16, 17, 20, 21, 24, 25, 28, 1,  1,
  2, 5, 6,  9,  10, 13, 14, 17, 18, 21, 22, 25, 26, 29, 2,  2,  3,
  6, 7, 10, 11, 14, 15, 18, 19, 22, 23, 26, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x8_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  0,  0,  1,  4,  2,  5,  3,  6,  4,
  4,  5,  8,  6,  9,  7,  10, 8,  8,  9,  12, 10, 13, 11, 14, 12, 12,
  13, 16, 14, 17, 15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21,
  24, 22, 25, 23, 26, 24, 24, 25, 28, 26, 29, 27, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0, 1,  8,  1,  1,  8,  8,  2,  9,  9, 16, 10,
  17, 2,  2,  16, 16, 3, 10, 17, 24, 11, 18, 18, 25, 3,  3, 4,  11,
  19, 26, 12, 19, 4,  4, 20, 27, 5,  12, 13, 20, 21, 28, 5, 5,  6,
  13, 14, 21, 22, 29, 6, 6,  7,  14, 15, 22, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 0,  0,  1,  8,  9,  16, 17, 24, 1,
  1,  2,  9,  10, 17, 18, 25, 2,  2,  3,  10, 11, 18, 19, 26, 3,  3,
  4,  11, 12, 19, 20, 27, 4,  4,  5,  12, 13, 20, 21, 28, 5,  5,  6,
  13, 14, 21, 22, 29, 6,  6,  7,  14, 15, 22, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x4_neighbors[33 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  0,
  0,  1,  8,  2,  9,  3,  10, 4,  11, 5,  12, 6,  13, 7,  14, 8,  8,
  9,  16, 10, 17, 11, 18, 12, 19, 13, 20, 14, 21, 15, 22, 16, 16, 17,
  24, 18, 25, 19, 26, 20, 27, 21, 28, 22, 29, 23, 30, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  4,  1,  1,  4,  4,  2,  5,  5,  8,  6,  9,  2,
  2,  8,  8,  3,  6,  9,  12, 7,  10, 10, 13, 12, 12, 13, 16, 11, 14, 14, 17,
  15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21, 24, 22, 25, 23, 26, 24,
  24, 25, 28, 26, 29, 27, 30, 28, 28, 29, 32, 30, 33, 31, 34, 32, 32, 33, 36,
  34, 37, 35, 38, 36, 36, 37, 40, 38, 41, 39, 42, 40, 40, 41, 44, 42, 45, 43,
  46, 44, 44, 45, 48, 46, 49, 47, 50, 48, 48, 49, 52, 50, 53, 51, 54, 52, 52,
  53, 56, 54, 57, 55, 58, 56, 56, 57, 60, 58, 61, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  0,  0,  1,  16, 1,  1,  16, 16, 2,  17, 17, 32, 18, 33, 2,
  2,  32, 32, 3,  18, 33, 48, 19, 34, 34, 49, 3,  3,  4,  19, 35, 50, 20, 35,
  4,  4,  36, 51, 5,  20, 21, 36, 37, 52, 5,  5,  6,  21, 22, 37, 38, 53, 6,
  6,  7,  22, 23, 38, 39, 54, 7,  7,  8,  23, 24, 39, 40, 55, 8,  8,  9,  24,
  25, 40, 41, 56, 9,  9,  10, 25, 26, 41, 42, 57, 10, 10, 11, 26, 27, 42, 43,
  58, 11, 11, 12, 27, 28, 43, 44, 59, 12, 12, 13, 28, 29, 44, 45, 60, 13, 13,
  14, 29, 30, 45, 46, 61, 14, 14, 15, 30, 31, 46, 47, 62, 0,  0
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  0,  0,  1,  4,  2,  5,  3,  6,  4,  4,  5,
  8,  6,  9,  7,  10, 8,  8,  9,  12, 10, 13, 11, 14, 12, 12, 13, 16, 14, 17,
  15, 18, 16, 16, 17, 20, 18, 21, 19, 22, 20, 20, 21, 24, 22, 25, 23, 26, 24,
  24, 25, 28, 26, 29, 27, 30, 28, 28, 29, 32, 30, 33, 31, 34, 32, 32, 33, 36,
  34, 37, 35, 38, 36, 36, 37, 40, 38, 41, 39, 42, 40, 40, 41, 44, 42, 45, 43,
  46, 44, 44, 45, 48, 46, 49, 47, 50, 48, 48, 49, 52, 50, 53, 51, 54, 52, 52,
  53, 56, 54, 57, 55, 58, 56, 56, 57, 60, 58, 61, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,
  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 0,  0,  1,  16, 2,  17,
  3,  18, 4,  19, 5,  20, 6,  21, 7,  22, 8,  23, 9,  24, 10, 25, 11, 26, 12,
  27, 13, 28, 14, 29, 15, 30, 16, 16, 17, 32, 18, 33, 19, 34, 20, 35, 21, 36,
  22, 37, 23, 38, 24, 39, 25, 40, 26, 41, 27, 42, 28, 43, 29, 44, 30, 45, 31,
  46, 32, 32, 33, 48, 34, 49, 35, 50, 36, 51, 37, 52, 38, 53, 39, 54, 40, 55,
  41, 56, 42, 57, 43, 58, 44, 59, 45, 60, 46, 61, 47, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_4x16_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  4,  4,  8,  8,  12, 12, 16, 16, 20, 20, 24, 24, 28, 28, 32,
  32, 36, 36, 40, 40, 44, 44, 48, 48, 52, 52, 56, 56, 0,  0,  1,  4,  5,  8,
  9,  12, 13, 16, 17, 20, 21, 24, 25, 28, 29, 32, 33, 36, 37, 40, 41, 44, 45,
  48, 49, 52, 53, 56, 57, 60, 1,  1,  2,  5,  6,  9,  10, 13, 14, 17, 18, 21,
  22, 25, 26, 29, 30, 33, 34, 37, 38, 41, 42, 45, 46, 49, 50, 53, 54, 57, 58,
  61, 2,  2,  3,  6,  7,  10, 11, 14, 15, 18, 19, 22, 23, 26, 27, 30, 31, 34,
  35, 38, 39, 42, 43, 46, 47, 50, 51, 54, 55, 58, 59, 62, 0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x4_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  16, 16, 32, 32, 0,  0,  1,  16, 17, 32, 33, 48, 1,  1,  2,
  17, 18, 33, 34, 49, 2,  2,  3,  18, 19, 34, 35, 50, 3,  3,  4,  19, 20, 35,
  36, 51, 4,  4,  5,  20, 21, 36, 37, 52, 5,  5,  6,  21, 22, 37, 38, 53, 6,
  6,  7,  22, 23, 38, 39, 54, 7,  7,  8,  23, 24, 39, 40, 55, 8,  8,  9,  24,
  25, 40, 41, 56, 9,  9,  10, 25, 26, 41, 42, 57, 10, 10, 11, 26, 27, 42, 43,
  58, 11, 11, 12, 27, 28, 43, 44, 59, 12, 12, 13, 28, 29, 44, 45, 60, 13, 13,
  14, 29, 30, 45, 46, 61, 14, 14, 15, 30, 31, 46, 47, 62, 0,  0
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   8,   8,   8,   2,   2,   2,
  9,   9,   16,  16,  16,  3,   3,   3,   10,  10,  17,  17,  24,  24,  24,
  4,   4,   4,   11,  11,  18,  18,  25,  25,  32,  32,  32,  5,   5,   5,
  12,  12,  19,  19,  26,  26,  33,  33,  40,  40,  40,  6,   6,   6,   13,
  13,  20,  20,  27,  27,  34,  34,  41,  41,  48,  48,  48,  7,   14,  14,
  21,  21,  28,  28,  35,  35,  42,  42,  49,  49,  56,  56,  56,  15,  22,
  22,  29,  29,  36,  36,  43,  43,  50,  50,  57,  57,  64,  64,  64,  23,
  30,  30,  37,  37,  44,  44,  51,  51,  58,  58,  65,  65,  72,  72,  72,
  31,  38,  38,  45,  45,  52,  52,  59,  59,  66,  66,  73,  73,  80,  80,
  80,  39,  46,  46,  53,  53,  60,  60,  67,  67,  74,  74,  81,  81,  88,
  88,  88,  47,  54,  54,  61,  61,  68,  68,  75,  75,  82,  82,  89,  89,
  96,  96,  96,  55,  62,  62,  69,  69,  76,  76,  83,  83,  90,  90,  97,
  97,  104, 104, 104, 63,  70,  70,  77,  77,  84,  84,  91,  91,  98,  98,
  105, 105, 112, 112, 112, 71,  78,  78,  85,  85,  92,  92,  99,  99,  106,
  106, 113, 113, 120, 120, 120, 79,  86,  86,  93,  93,  100, 100, 107, 107,
  114, 114, 121, 121, 128, 128, 128, 87,  94,  94,  101, 101, 108, 108, 115,
  115, 122, 122, 129, 129, 136, 136, 136, 95,  102, 102, 109, 109, 116, 116,
  123, 123, 130, 130, 137, 137, 144, 144, 144, 103, 110, 110, 117, 117, 124,
  124, 131, 131, 138, 138, 145, 145, 152, 152, 152, 111, 118, 118, 125, 125,
  132, 132, 139, 139, 146, 146, 153, 153, 160, 160, 160, 119, 126, 126, 133,
  133, 140, 140, 147, 147, 154, 154, 161, 161, 168, 168, 168, 127, 134, 134,
  141, 141, 148, 148, 155, 155, 162, 162, 169, 169, 176, 176, 176, 135, 142,
  142, 149, 149, 156, 156, 163, 163, 170, 170, 177, 177, 184, 184, 184, 143,
  150, 150, 157, 157, 164, 164, 171, 171, 178, 178, 185, 185, 192, 192, 192,
  151, 158, 158, 165, 165, 172, 172, 179, 179, 186, 186, 193, 193, 200, 200,
  200, 159, 166, 166, 173, 173, 180, 180, 187, 187, 194, 194, 201, 201, 208,
  208, 208, 167, 174, 174, 181, 181, 188, 188, 195, 195, 202, 202, 209, 209,
  216, 216, 216, 175, 182, 182, 189, 189, 196, 196, 203, 203, 210, 210, 217,
  217, 224, 224, 224, 183, 190, 190, 197, 197, 204, 204, 211, 211, 218, 218,
  225, 225, 232, 232, 232, 191, 198, 198, 205, 205, 212, 212, 219, 219, 226,
  226, 233, 233, 240, 240, 240, 199, 206, 206, 213, 213, 220, 220, 227, 227,
  234, 234, 241, 241, 248, 207, 214, 214, 221, 221, 228, 228, 235, 235, 242,
  242, 249, 215, 222, 222, 229, 229, 236, 236, 243, 243, 250, 223, 230, 230,
  237, 237, 244, 244, 251, 231, 238, 238, 245, 245, 252, 239, 246, 246, 253,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   32,  32,  32,  2,   2,   2,
  33,  33,  64,  64,  64,  3,   3,   3,   34,  34,  65,  65,  96,  96,  96,
  4,   4,   4,   35,  35,  66,  66,  97,  97,  128, 128, 128, 5,   5,   5,
  36,  36,  67,  67,  98,  98,  129, 129, 160, 160, 160, 6,   6,   6,   37,
  37,  68,  68,  99,  99,  130, 130, 161, 161, 192, 192, 192, 7,   7,   7,
  38,  38,  69,  69,  100, 100, 131, 131, 162, 162, 193, 193, 224, 8,   8,
  8,   39,  39,  70,  70,  101, 101, 132, 132, 163, 163, 194, 194, 225, 9,
  9,   9,   40,  40,  71,  71,  102, 102, 133, 133, 164, 164, 195, 195, 226,
  10,  10,  10,  41,  41,  72,  72,  103, 103, 134, 134, 165, 165, 196, 196,
  227, 11,  11,  11,  42,  42,  73,  73,  104, 104, 135, 135, 166, 166, 197,
  197, 228, 12,  12,  12,  43,  43,  74,  74,  105, 105, 136, 136, 167, 167,
  198, 198, 229, 13,  13,  13,  44,  44,  75,  75,  106, 106, 137, 137, 168,
  168, 199, 199, 230, 14,  14,  14,  45,  45,  76,  76,  107, 107, 138, 138,
  169, 169, 200, 200, 231, 15,  15,  15,  46,  46,  77,  77,  108, 108, 139,
  139, 170, 170, 201, 201, 232, 16,  16,  16,  47,  47,  78,  78,  109, 109,
  140, 140, 171, 171, 202, 202, 233, 17,  17,  17,  48,  48,  79,  79,  110,
  110, 141, 141, 172, 172, 203, 203, 234, 18,  18,  18,  49,  49,  80,  80,
  111, 111, 142, 142, 173, 173, 204, 204, 235, 19,  19,  19,  50,  50,  81,
  81,  112, 112, 143, 143, 174, 174, 205, 205, 236, 20,  20,  20,  51,  51,
  82,  82,  113, 113, 144, 144, 175, 175, 206, 206, 237, 21,  21,  21,  52,
  52,  83,  83,  114, 114, 145, 145, 176, 176, 207, 207, 238, 22,  22,  22,
  53,  53,  84,  84,  115, 115, 146, 146, 177, 177, 208, 208, 239, 23,  23,
  23,  54,  54,  85,  85,  116, 116, 147, 147, 178, 178, 209, 209, 240, 24,
  24,  24,  55,  55,  86,  86,  117, 117, 148, 148, 179, 179, 210, 210, 241,
  25,  25,  25,  56,  56,  87,  87,  118, 118, 149, 149, 180, 180, 211, 211,
  242, 26,  26,  26,  57,  57,  88,  88,  119, 119, 150, 150, 181, 181, 212,
  212, 243, 27,  27,  27,  58,  58,  89,  89,  120, 120, 151, 151, 182, 182,
  213, 213, 244, 28,  28,  28,  59,  59,  90,  90,  121, 121, 152, 152, 183,
  183, 214, 214, 245, 29,  29,  29,  60,  60,  91,  91,  122, 122, 153, 153,
  184, 184, 215, 215, 246, 30,  30,  30,  61,  61,  92,  92,  123, 123, 154,
  154, 185, 185, 216, 216, 247, 31,  62,  62,  93,  93,  124, 124, 155, 155,
  186, 186, 217, 217, 248, 63,  94,  94,  125, 125, 156, 156, 187, 187, 218,
  218, 249, 95,  126, 126, 157, 157, 188, 188, 219, 219, 250, 127, 158, 158,
  189, 189, 220, 220, 251, 159, 190, 190, 221, 221, 252, 191, 222, 222, 253,
  223, 254, 0,   0
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   0,   0,   1,   8,   2,   9,   3,   10,  4,   11,  5,   12,  6,   13,
  7,   14,  8,   8,   9,   16,  10,  17,  11,  18,  12,  19,  13,  20,  14,
  21,  15,  22,  16,  16,  17,  24,  18,  25,  19,  26,  20,  27,  21,  28,
  22,  29,  23,  30,  24,  24,  25,  32,  26,  33,  27,  34,  28,  35,  29,
  36,  30,  37,  31,  38,  32,  32,  33,  40,  34,  41,  35,  42,  36,  43,
  37,  44,  38,  45,  39,  46,  40,  40,  41,  48,  42,  49,  43,  50,  44,
  51,  45,  52,  46,  53,  47,  54,  48,  48,  49,  56,  50,  57,  51,  58,
  52,  59,  53,  60,  54,  61,  55,  62,  56,  56,  57,  64,  58,  65,  59,
  66,  60,  67,  61,  68,  62,  69,  63,  70,  64,  64,  65,  72,  66,  73,
  67,  74,  68,  75,  69,  76,  70,  77,  71,  78,  72,  72,  73,  80,  74,
  81,  75,  82,  76,  83,  77,  84,  78,  85,  79,  86,  80,  80,  81,  88,
  82,  89,  83,  90,  84,  91,  85,  92,  86,  93,  87,  94,  88,  88,  89,
  96,  90,  97,  91,  98,  92,  99,  93,  100, 94,  101, 95,  102, 96,  96,
  97,  104, 98,  105, 99,  106, 100, 107, 101, 108, 102, 109, 103, 110, 104,
  104, 105, 112, 106, 113, 107, 114, 108, 115, 109, 116, 110, 117, 111, 118,
  112, 112, 113, 120, 114, 121, 115, 122, 116, 123, 117, 124, 118, 125, 119,
  126, 120, 120, 121, 128, 122, 129, 123, 130, 124, 131, 125, 132, 126, 133,
  127, 134, 128, 128, 129, 136, 130, 137, 131, 138, 132, 139, 133, 140, 134,
  141, 135, 142, 136, 136, 137, 144, 138, 145, 139, 146, 140, 147, 141, 148,
  142, 149, 143, 150, 144, 144, 145, 152, 146, 153, 147, 154, 148, 155, 149,
  156, 150, 157, 151, 158, 152, 152, 153, 160, 154, 161, 155, 162, 156, 163,
  157, 164, 158, 165, 159, 166, 160, 160, 161, 168, 162, 169, 163, 170, 164,
  171, 165, 172, 166, 173, 167, 174, 168, 168, 169, 176, 170, 177, 171, 178,
  172, 179, 173, 180, 174, 181, 175, 182, 176, 176, 177, 184, 178, 185, 179,
  186, 180, 187, 181, 188, 182, 189, 183, 190, 184, 184, 185, 192, 186, 193,
  187, 194, 188, 195, 189, 196, 190, 197, 191, 198, 192, 192, 193, 200, 194,
  201, 195, 202, 196, 203, 197, 204, 198, 205, 199, 206, 200, 200, 201, 208,
  202, 209, 203, 210, 204, 211, 205, 212, 206, 213, 207, 214, 208, 208, 209,
  216, 210, 217, 211, 218, 212, 219, 213, 220, 214, 221, 215, 222, 216, 216,
  217, 224, 218, 225, 219, 226, 220, 227, 221, 228, 222, 229, 223, 230, 224,
  224, 225, 232, 226, 233, 227, 234, 228, 235, 229, 236, 230, 237, 231, 238,
  232, 232, 233, 240, 234, 241, 235, 242, 236, 243, 237, 244, 238, 245, 239,
  246, 240, 240, 241, 248, 242, 249, 243, 250, 244, 251, 245, 252, 246, 253,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  19,  20,  20,  21,
  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  28,
  29,  29,  30,  30,  0,   0,   1,   32,  2,   33,  3,   34,  4,   35,  5,
  36,  6,   37,  7,   38,  8,   39,  9,   40,  10,  41,  11,  42,  12,  43,
  13,  44,  14,  45,  15,  46,  16,  47,  17,  48,  18,  49,  19,  50,  20,
  51,  21,  52,  22,  53,  23,  54,  24,  55,  25,  56,  26,  57,  27,  58,
  28,  59,  29,  60,  30,  61,  31,  62,  32,  32,  33,  64,  34,  65,  35,
  66,  36,  67,  37,  68,  38,  69,  39,  70,  40,  71,  41,  72,  42,  73,
  43,  74,  44,  75,  45,  76,  46,  77,  47,  78,  48,  79,  49,  80,  50,
  81,  51,  82,  52,  83,  53,  84,  54,  85,  55,  86,  56,  87,  57,  88,
  58,  89,  59,  90,  60,  91,  61,  92,  62,  93,  63,  94,  64,  64,  65,
  96,  66,  97,  67,  98,  68,  99,  69,  100, 70,  101, 71,  102, 72,  103,
  73,  104, 74,  105, 75,  106, 76,  107, 77,  108, 78,  109, 79,  110, 80,
  111, 81,  112, 82,  113, 83,  114, 84,  115, 85,  116, 86,  117, 87,  118,
  88,  119, 89,  120, 90,  121, 91,  122, 92,  123, 93,  124, 94,  125, 95,
  126, 96,  96,  97,  128, 98,  129, 99,  130, 100, 131, 101, 132, 102, 133,
  103, 134, 104, 135, 105, 136, 106, 137, 107, 138, 108, 139, 109, 140, 110,
  141, 111, 142, 112, 143, 113, 144, 114, 145, 115, 146, 116, 147, 117, 148,
  118, 149, 119, 150, 120, 151, 121, 152, 122, 153, 123, 154, 124, 155, 125,
  156, 126, 157, 127, 158, 128, 128, 129, 160, 130, 161, 131, 162, 132, 163,
  133, 164, 134, 165, 135, 166, 136, 167, 137, 168, 138, 169, 139, 170, 140,
  171, 141, 172, 142, 173, 143, 174, 144, 175, 145, 176, 146, 177, 147, 178,
  148, 179, 149, 180, 150, 181, 151, 182, 152, 183, 153, 184, 154, 185, 155,
  186, 156, 187, 157, 188, 158, 189, 159, 190, 160, 160, 161, 192, 162, 193,
  163, 194, 164, 195, 165, 196, 166, 197, 167, 198, 168, 199, 169, 200, 170,
  201, 171, 202, 172, 203, 173, 204, 174, 205, 175, 206, 176, 207, 177, 208,
  178, 209, 179, 210, 180, 211, 181, 212, 182, 213, 183, 214, 184, 215, 185,
  216, 186, 217, 187, 218, 188, 219, 189, 220, 190, 221, 191, 222, 192, 192,
  193, 224, 194, 225, 195, 226, 196, 227, 197, 228, 198, 229, 199, 230, 200,
  231, 201, 232, 202, 233, 203, 234, 204, 235, 205, 236, 206, 237, 207, 238,
  208, 239, 209, 240, 210, 241, 211, 242, 212, 243, 213, 244, 214, 245, 215,
  246, 216, 247, 217, 248, 218, 249, 219, 250, 220, 251, 221, 252, 222, 253,
  223, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x32_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   8,   8,   16,  16,  24,  24,  32,  32,  40,  40,  48,
  48,  56,  56,  64,  64,  72,  72,  80,  80,  88,  88,  96,  96,  104, 104,
  112, 112, 120, 120, 128, 128, 136, 136, 144, 144, 152, 152, 160, 160, 168,
  168, 176, 176, 184, 184, 192, 192, 200, 200, 208, 208, 216, 216, 224, 224,
  232, 232, 240, 240, 0,   0,   1,   8,   9,   16,  17,  24,  25,  32,  33,
  40,  41,  48,  49,  56,  57,  64,  65,  72,  73,  80,  81,  88,  89,  96,
  97,  104, 105, 112, 113, 120, 121, 128, 129, 136, 137, 144, 145, 152, 153,
  160, 161, 168, 169, 176, 177, 184, 185, 192, 193, 200, 201, 208, 209, 216,
  217, 224, 225, 232, 233, 240, 241, 248, 1,   1,   2,   9,   10,  17,  18,
  25,  26,  33,  34,  41,  42,  49,  50,  57,  58,  65,  66,  73,  74,  81,
  82,  89,  90,  97,  98,  105, 106, 113, 114, 121, 122, 129, 130, 137, 138,
  145, 146, 153, 154, 161, 162, 169, 170, 177, 178, 185, 186, 193, 194, 201,
  202, 209, 210, 217, 218, 225, 226, 233, 234, 241, 242, 249, 2,   2,   3,
  10,  11,  18,  19,  26,  27,  34,  35,  42,  43,  50,  51,  58,  59,  66,
  67,  74,  75,  82,  83,  90,  91,  98,  99,  106, 107, 114, 115, 122, 123,
  130, 131, 138, 139, 146, 147, 154, 155, 162, 163, 170, 171, 178, 179, 186,
  187, 194, 195, 202, 203, 210, 211, 218, 219, 226, 227, 234, 235, 242, 243,
  250, 3,   3,   4,   11,  12,  19,  20,  27,  28,  35,  36,  43,  44,  51,
  52,  59,  60,  67,  68,  75,  76,  83,  84,  91,  92,  99,  100, 107, 108,
  115, 116, 123, 124, 131, 132, 139, 140, 147, 148, 155, 156, 163, 164, 171,
  172, 179, 180, 187, 188, 195, 196, 203, 204, 211, 212, 219, 220, 227, 228,
  235, 236, 243, 244, 251, 4,   4,   5,   12,  13,  20,  21,  28,  29,  36,
  37,  44,  45,  52,  53,  60,  61,  68,  69,  76,  77,  84,  85,  92,  93,
  100, 101, 108, 109, 116, 117, 124, 125, 132, 133, 140, 141, 148, 149, 156,
  157, 164, 165, 172, 173, 180, 181, 188, 189, 196, 197, 204, 205, 212, 213,
  220, 221, 228, 229, 236, 237, 244, 245, 252, 5,   5,   6,   13,  14,  21,
  22,  29,  30,  37,  38,  45,  46,  53,  54,  61,  62,  69,  70,  77,  78,
  85,  86,  93,  94,  101, 102, 109, 110, 117, 118, 125, 126, 133, 134, 141,
  142, 149, 150, 157, 158, 165, 166, 173, 174, 181, 182, 189, 190, 197, 198,
  205, 206, 213, 214, 221, 222, 229, 230, 237, 238, 245, 246, 253, 6,   6,
  7,   14,  15,  22,  23,  30,  31,  38,  39,  46,  47,  54,  55,  62,  63,
  70,  71,  78,  79,  86,  87,  94,  95,  102, 103, 110, 111, 118, 119, 126,
  127, 134, 135, 142, 143, 150, 151, 158, 159, 166, 167, 174, 175, 182, 183,
  190, 191, 198, 199, 206, 207, 214, 215, 222, 223, 230, 231, 238, 239, 246,
  247, 254, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x8_neighbors[257 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  32, 32, 64, 64,  96,  96,  128, 128, 160, 160, 192, 192,
  0,  0,  1,  32, 33, 64, 65, 96,  97,  128, 129, 160, 161, 192, 193, 224,
  1,  1,  2,  33, 34, 65, 66, 97,  98,  129, 130, 161, 162, 193, 194, 225,
  2,  2,  3,  34, 35, 66, 67, 98,  99,  130, 131, 162, 163, 194, 195, 226,
  3,  3,  4,  35, 36, 67, 68, 99,  100, 131, 132, 163, 164, 195, 196, 227,
  4,  4,  5,  36, 37, 68, 69, 100, 101, 132, 133, 164, 165, 196, 197, 228,
  5,  5,  6,  37, 38, 69, 70, 101, 102, 133, 134, 165, 166, 197, 198, 229,
  6,  6,  7,  38, 39, 70, 71, 102, 103, 134, 135, 166, 167, 198, 199, 230,
  7,  7,  8,  39, 40, 71, 72, 103, 104, 135, 136, 167, 168, 199, 200, 231,
  8,  8,  9,  40, 41, 72, 73, 104, 105, 136, 137, 168, 169, 200, 201, 232,
  9,  9,  10, 41, 42, 73, 74, 105, 106, 137, 138, 169, 170, 201, 202, 233,
  10, 10, 11, 42, 43, 74, 75, 106, 107, 138, 139, 170, 171, 202, 203, 234,
  11, 11, 12, 43, 44, 75, 76, 107, 108, 139, 140, 171, 172, 203, 204, 235,
  12, 12, 13, 44, 45, 76, 77, 108, 109, 140, 141, 172, 173, 204, 205, 236,
  13, 13, 14, 45, 46, 77, 78, 109, 110, 141, 142, 173, 174, 205, 206, 237,
  14, 14, 15, 46, 47, 78, 79, 110, 111, 142, 143, 174, 175, 206, 207, 238,
  15, 15, 16, 47, 48, 79, 80, 111, 112, 143, 144, 175, 176, 207, 208, 239,
  16, 16, 17, 48, 49, 80, 81, 112, 113, 144, 145, 176, 177, 208, 209, 240,
  17, 17, 18, 49, 50, 81, 82, 113, 114, 145, 146, 177, 178, 209, 210, 241,
  18, 18, 19, 50, 51, 82, 83, 114, 115, 146, 147, 178, 179, 210, 211, 242,
  19, 19, 20, 51, 52, 83, 84, 115, 116, 147, 148, 179, 180, 211, 212, 243,
  20, 20, 21, 52, 53, 84, 85, 116, 117, 148, 149, 180, 181, 212, 213, 244,
  21, 21, 22, 53, 54, 85, 86, 117, 118, 149, 150, 181, 182, 213, 214, 245,
  22, 22, 23, 54, 55, 86, 87, 118, 119, 150, 151, 182, 183, 214, 215, 246,
  23, 23, 24, 55, 56, 87, 88, 119, 120, 151, 152, 183, 184, 215, 216, 247,
  24, 24, 25, 56, 57, 88, 89, 120, 121, 152, 153, 184, 185, 216, 217, 248,
  25, 25, 26, 57, 58, 89, 90, 121, 122, 153, 154, 185, 186, 217, 218, 249,
  26, 26, 27, 58, 59, 90, 91, 122, 123, 154, 155, 186, 187, 218, 219, 250,
  27, 27, 28, 59, 60, 91, 92, 123, 124, 155, 156, 187, 188, 219, 220, 251,
  28, 28, 29, 60, 61, 92, 93, 124, 125, 156, 157, 188, 189, 220, 221, 252,
  29, 29, 30, 61, 62, 93, 94, 125, 126, 157, 158, 189, 190, 221, 222, 253,
  30, 30, 31, 62, 63, 94, 95, 126, 127, 158, 159, 190, 191, 222, 223, 254,
  0,  0
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                col_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  8,  0,  16, 16, 1,  8,  24, 24, 9,  16, 9,  1,  32,
  32, 17, 24, 2,  9,  25, 32, 10, 17, 40, 40, 10, 2,  18, 25, 33, 40, 3,  10,
  48, 48, 11, 18, 26, 33, 11, 3,  41, 48, 19, 26, 34, 41, 4,  11, 27, 34, 12,
  19, 49, 56, 42, 49, 20, 27, 12, 4,  35, 42, 5,  12, 28, 35, 50, 57, 43, 50,
  13, 20, 36, 43, 13, 5,  21, 28, 51, 58, 29, 36, 6,  13, 44, 51, 14, 21, 14,
  6,  37, 44, 52, 59, 22, 29, 7,  14, 30, 37, 45, 52, 15, 22, 38, 45, 23, 30,
  53, 60, 31, 38, 46, 53, 39, 46, 54, 61, 47, 54, 55, 62, 0,  0,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 24, 24, 32, 32, 40, 40, 48, 48, 0,  0,  1,
  8,  9,  16, 17, 24, 25, 32, 33, 40, 41, 48, 49, 56, 1,  1,  2,  9,  10, 17,
  18, 25, 26, 33, 34, 41, 42, 49, 50, 57, 2,  2,  3,  10, 11, 18, 19, 26, 27,
  34, 35, 42, 43, 50, 51, 58, 3,  3,  4,  11, 12, 19, 20, 27, 28, 35, 36, 43,
  44, 51, 52, 59, 4,  4,  5,  12, 13, 20, 21, 28, 29, 36, 37, 44, 45, 52, 53,
  60, 5,  5,  6,  13, 14, 21, 22, 29, 30, 37, 38, 45, 46, 53, 54, 61, 6,  6,
  7,  14, 15, 22, 23, 30, 31, 38, 39, 46, 47, 54, 55, 62, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  0,  0,  1,
  8,  2,  9,  3,  10, 4,  11, 5,  12, 6,  13, 7,  14, 8,  8,  9,  16, 10, 17,
  11, 18, 12, 19, 13, 20, 14, 21, 15, 22, 16, 16, 17, 24, 18, 25, 19, 26, 20,
  27, 21, 28, 22, 29, 23, 30, 24, 24, 25, 32, 26, 33, 27, 34, 28, 35, 29, 36,
  30, 37, 31, 38, 32, 32, 33, 40, 34, 41, 35, 42, 36, 43, 37, 44, 38, 45, 39,
  46, 40, 40, 41, 48, 42, 49, 43, 50, 44, 51, 45, 52, 46, 53, 47, 54, 48, 48,
  49, 56, 50, 57, 51, 58, 52, 59, 53, 60, 54, 61, 55, 62, 0,  0,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                row_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  1,  1,  0,  1,  1,  8,  2,  2,  8,  9,  2,  9,  3,  3,  9,
  16, 3,  10, 16, 17, 4,  4,  10, 17, 17, 24, 4,  11, 11, 18, 18, 25, 24, 25,
  5,  5,  5,  12, 12, 19, 25, 32, 19, 26, 6,  6,  26, 33, 32, 33, 13, 20, 20,
  27, 33, 40, 6,  13, 27, 34, 40, 41, 34, 41, 21, 28, 28, 35, 41, 48, 14, 21,
  35, 42, 7,  14, 48, 49, 29, 36, 42, 49, 36, 43, 22, 29, 49, 56, 15, 22, 43,
  50, 50, 57, 37, 44, 30, 37, 44, 51, 23, 30, 51, 58, 45, 52, 38, 45, 52, 59,
  31, 38, 53, 60, 39, 46, 46, 53, 47, 54, 54, 61, 55, 62, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x8_neighbors[65 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  0,  8,  8,  1,  8,  9,  1,  9,  16, 16, 17, 2,  9,  10,
  2,  10, 17, 17, 24, 24, 25, 3,  10, 11, 3,  18, 25, 25, 32, 11, 18, 32, 33,
  4,  11, 26, 33, 19, 26, 12, 4,  33, 40, 12, 19, 40, 41, 5,  12, 27, 34, 34,
  41, 20, 27, 13, 20, 13, 5,  41, 48, 48, 49, 28, 35, 35, 42, 21, 28, 6,  6,
  6,  13, 42, 49, 49, 56, 36, 43, 14, 21, 29, 36, 7,  14, 43, 50, 50, 57, 22,
  29, 37, 44, 15, 22, 44, 51, 51, 58, 30, 37, 23, 30, 52, 59, 45, 52, 38, 45,
  31, 38, 53, 60, 46, 53, 39, 46, 54, 61, 47, 54, 55, 62, 0,  0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   8,   8,   8,   2,   2,   2,
  9,   9,   16,  16,  16,  3,   3,   3,   10,  10,  17,  17,  24,  24,  24,
  4,   4,   4,   11,  11,  18,  18,  25,  25,  32,  32,  32,  5,   5,   5,
  12,  12,  19,  19,  26,  26,  33,  33,  40,  40,  40,  6,   6,   6,   13,
  13,  20,  20,  27,  27,  34,  34,  41,  41,  48,  48,  48,  7,   14,  14,
  21,  21,  28,  28,  35,  35,  42,  42,  49,  49,  56,  56,  56,  15,  22,
  22,  29,  29,  36,  36,  43,  43,  50,  50,  57,  57,  64,  64,  64,  23,
  30,  30,  37,  37,  44,  44,  51,  51,  58,  58,  65,  65,  72,  72,  72,
  31,  38,  38,  45,  45,  52,  52,  59,  59,  66,  66,  73,  73,  80,  80,
  80,  39,  46,  46,  53,  53,  60,  60,  67,  67,  74,  74,  81,  81,  88,
  88,  88,  47,  54,  54,  61,  61,  68,  68,  75,  75,  82,  82,  89,  89,
  96,  96,  96,  55,  62,  62,  69,  69,  76,  76,  83,  83,  90,  90,  97,
  97,  104, 104, 104, 63,  70,  70,  77,  77,  84,  84,  91,  91,  98,  98,
  105, 105, 112, 112, 112, 71,  78,  78,  85,  85,  92,  92,  99,  99,  106,
  106, 113, 113, 120, 79,  86,  86,  93,  93,  100, 100, 107, 107, 114, 114,
  121, 87,  94,  94,  101, 101, 108, 108, 115, 115, 122, 95,  102, 102, 109,
  109, 116, 116, 123, 103, 110, 110, 117, 117, 124, 111, 118, 118, 125, 119,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,  1,  1,   1,   16,  16,  16,  2,   2,   2,
  17,  17,  32,  32,  32,  3,  3,  3,   18,  18,  33,  33,  48,  48,  48,
  4,   4,   4,   19,  19,  34, 34, 49,  49,  64,  64,  64,  5,   5,   5,
  20,  20,  35,  35,  50,  50, 65, 65,  80,  80,  80,  6,   6,   6,   21,
  21,  36,  36,  51,  51,  66, 66, 81,  81,  96,  96,  96,  7,   7,   7,
  22,  22,  37,  37,  52,  52, 67, 67,  82,  82,  97,  97,  112, 8,   8,
  8,   23,  23,  38,  38,  53, 53, 68,  68,  83,  83,  98,  98,  113, 9,
  9,   9,   24,  24,  39,  39, 54, 54,  69,  69,  84,  84,  99,  99,  114,
  10,  10,  10,  25,  25,  40, 40, 55,  55,  70,  70,  85,  85,  100, 100,
  115, 11,  11,  11,  26,  26, 41, 41,  56,  56,  71,  71,  86,  86,  101,
  101, 116, 12,  12,  12,  27, 27, 42,  42,  57,  57,  72,  72,  87,  87,
  102, 102, 117, 13,  13,  13, 28, 28,  43,  43,  58,  58,  73,  73,  88,
  88,  103, 103, 118, 14,  14, 14, 29,  29,  44,  44,  59,  59,  74,  74,
  89,  89,  104, 104, 119, 15, 30, 30,  45,  45,  60,  60,  75,  75,  90,
  90,  105, 105, 120, 31,  46, 46, 61,  61,  76,  76,  91,  91,  106, 106,
  121, 47,  62,  62,  77,  77, 92, 92,  107, 107, 122, 63,  78,  78,  93,
  93,  108, 108, 123, 79,  94, 94, 109, 109, 124, 95,  110, 110, 125, 111,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  8,  8,  16, 16, 24, 24,  32,  32,  40,  40,  48,  48,
  56, 56, 64, 64, 72, 72, 80, 80, 88, 88,  96,  96,  104, 104, 112, 112,
  0,  0,  1,  8,  9,  16, 17, 24, 25, 32,  33,  40,  41,  48,  49,  56,
  57, 64, 65, 72, 73, 80, 81, 88, 89, 96,  97,  104, 105, 112, 113, 120,
  1,  1,  2,  9,  10, 17, 18, 25, 26, 33,  34,  41,  42,  49,  50,  57,
  58, 65, 66, 73, 74, 81, 82, 89, 90, 97,  98,  105, 106, 113, 114, 121,
  2,  2,  3,  10, 11, 18, 19, 26, 27, 34,  35,  42,  43,  50,  51,  58,
  59, 66, 67, 74, 75, 82, 83, 90, 91, 98,  99,  106, 107, 114, 115, 122,
  3,  3,  4,  11, 12, 19, 20, 27, 28, 35,  36,  43,  44,  51,  52,  59,
  60, 67, 68, 75, 76, 83, 84, 91, 92, 99,  100, 107, 108, 115, 116, 123,
  4,  4,  5,  12, 13, 20, 21, 28, 29, 36,  37,  44,  45,  52,  53,  60,
  61, 68, 69, 76, 77, 84, 85, 92, 93, 100, 101, 108, 109, 116, 117, 124,
  5,  5,  6,  13, 14, 21, 22, 29, 30, 37,  38,  45,  46,  53,  54,  61,
  62, 69, 70, 77, 78, 85, 86, 93, 94, 101, 102, 109, 110, 117, 118, 125,
  6,  6,  7,  14, 15, 22, 23, 30, 31, 38,  39,  46,  47,  54,  55,  62,
  63, 70, 71, 78, 79, 86, 87, 94, 95, 102, 103, 110, 111, 118, 119, 126,
  0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,  0,  0,  0,  16, 16, 32, 32, 48, 48, 64, 64, 80, 80,  96,  96,
  0,  0,  1,  16, 17, 32, 33, 48, 49, 64, 65, 80, 81, 96,  97,  112,
  1,  1,  2,  17, 18, 33, 34, 49, 50, 65, 66, 81, 82, 97,  98,  113,
  2,  2,  3,  18, 19, 34, 35, 50, 51, 66, 67, 82, 83, 98,  99,  114,
  3,  3,  4,  19, 20, 35, 36, 51, 52, 67, 68, 83, 84, 99,  100, 115,
  4,  4,  5,  20, 21, 36, 37, 52, 53, 68, 69, 84, 85, 100, 101, 116,
  5,  5,  6,  21, 22, 37, 38, 53, 54, 69, 70, 85, 86, 101, 102, 117,
  6,  6,  7,  22, 23, 38, 39, 54, 55, 70, 71, 86, 87, 102, 103, 118,
  7,  7,  8,  23, 24, 39, 40, 55, 56, 71, 72, 87, 88, 103, 104, 119,
  8,  8,  9,  24, 25, 40, 41, 56, 57, 72, 73, 88, 89, 104, 105, 120,
  9,  9,  10, 25, 26, 41, 42, 57, 58, 73, 74, 89, 90, 105, 106, 121,
  10, 10, 11, 26, 27, 42, 43, 58, 59, 74, 75, 90, 91, 106, 107, 122,
  11, 11, 12, 27, 28, 43, 44, 59, 60, 75, 76, 91, 92, 107, 108, 123,
  12, 12, 13, 28, 29, 44, 45, 60, 61, 76, 77, 92, 93, 108, 109, 124,
  13, 13, 14, 29, 30, 45, 46, 61, 62, 77, 78, 93, 94, 109, 110, 125,
  14, 14, 15, 30, 31, 46, 47, 62, 63, 78, 79, 94, 95, 110, 111, 126,
  0,  0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_8x16_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   0,   0,   1,   8,   2,   9,   3,   10,  4,   11,  5,   12,  6,   13,
  7,   14,  8,   8,   9,   16,  10,  17,  11,  18,  12,  19,  13,  20,  14,
  21,  15,  22,  16,  16,  17,  24,  18,  25,  19,  26,  20,  27,  21,  28,
  22,  29,  23,  30,  24,  24,  25,  32,  26,  33,  27,  34,  28,  35,  29,
  36,  30,  37,  31,  38,  32,  32,  33,  40,  34,  41,  35,  42,  36,  43,
  37,  44,  38,  45,  39,  46,  40,  40,  41,  48,  42,  49,  43,  50,  44,
  51,  45,  52,  46,  53,  47,  54,  48,  48,  49,  56,  50,  57,  51,  58,
  52,  59,  53,  60,  54,  61,  55,  62,  56,  56,  57,  64,  58,  65,  59,
  66,  60,  67,  61,  68,  62,  69,  63,  70,  64,  64,  65,  72,  66,  73,
  67,  74,  68,  75,  69,  76,  70,  77,  71,  78,  72,  72,  73,  80,  74,
  81,  75,  82,  76,  83,  77,  84,  78,  85,  79,  86,  80,  80,  81,  88,
  82,  89,  83,  90,  84,  91,  85,  92,  86,  93,  87,  94,  88,  88,  89,
  96,  90,  97,  91,  98,  92,  99,  93,  100, 94,  101, 95,  102, 96,  96,
  97,  104, 98,  105, 99,  106, 100, 107, 101, 108, 102, 109, 103, 110, 104,
  104, 105, 112, 106, 113, 107, 114, 108, 115, 109, 116, 110, 117, 111, 118,
  112, 112, 113, 120, 114, 121, 115, 122, 116, 123, 117, 124, 118, 125, 119,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x8_neighbors[129 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   16,  16,  16,  2,   2,   2,
  17,  17,  32,  32,  32,  3,   3,   3,   18,  18,  33,  33,  48,  48,  48,
  4,   4,   4,   19,  19,  34,  34,  49,  49,  64,  64,  64,  5,   5,   5,
  20,  20,  35,  35,  50,  50,  65,  65,  80,  80,  80,  6,   6,   6,   21,
  21,  36,  36,  51,  51,  66,  66,  81,  81,  96,  96,  96,  7,   7,   7,
  22,  22,  37,  37,  52,  52,  67,  67,  82,  82,  97,  97,  112, 112, 112,
  8,   8,   8,   23,  23,  38,  38,  53,  53,  68,  68,  83,  83,  98,  98,
  113, 113, 128, 128, 128, 9,   9,   9,   24,  24,  39,  39,  54,  54,  69,
  69,  84,  84,  99,  99,  114, 114, 129, 129, 144, 144, 144, 10,  10,  10,
  25,  25,  40,  40,  55,  55,  70,  70,  85,  85,  100, 100, 115, 115, 130,
  130, 145, 145, 160, 160, 160, 11,  11,  11,  26,  26,  41,  41,  56,  56,
  71,  71,  86,  86,  101, 101, 116, 116, 131, 131, 146, 146, 161, 161, 176,
  176, 176, 12,  12,  12,  27,  27,  42,  42,  57,  57,  72,  72,  87,  87,
  102, 102, 117, 117, 132, 132, 147, 147, 162, 162, 177, 177, 192, 192, 192,
  13,  13,  13,  28,  28,  43,  43,  58,  58,  73,  73,  88,  88,  103, 103,
  118, 118, 133, 133, 148, 148, 163, 163, 178, 178, 193, 193, 208, 208, 208,
  14,  14,  14,  29,  29,  44,  44,  59,  59,  74,  74,  89,  89,  104, 104,
  119, 119, 134, 134, 149, 149, 164, 164, 179, 179, 194, 194, 209, 209, 224,
  224, 224, 15,  30,  30,  45,  45,  60,  60,  75,  75,  90,  90,  105, 105,
  120, 120, 135, 135, 150, 150, 165, 165, 180, 180, 195, 195, 210, 210, 225,
  225, 240, 240, 240, 31,  46,  46,  61,  61,  76,  76,  91,  91,  106, 106,
  121, 121, 136, 136, 151, 151, 166, 166, 181, 181, 196, 196, 211, 211, 226,
  226, 241, 241, 256, 256, 256, 47,  62,  62,  77,  77,  92,  92,  107, 107,
  122, 122, 137, 137, 152, 152, 167, 167, 182, 182, 197, 197, 212, 212, 227,
  227, 242, 242, 257, 257, 272, 272, 272, 63,  78,  78,  93,  93,  108, 108,
  123, 123, 138, 138, 153, 153, 168, 168, 183, 183, 198, 198, 213, 213, 228,
  228, 243, 243, 258, 258, 273, 273, 288, 288, 288, 79,  94,  94,  109, 109,
  124, 124, 139, 139, 154, 154, 169, 169, 184, 184, 199, 199, 214, 214, 229,
  229, 244, 244, 259, 259, 274, 274, 289, 289, 304, 304, 304, 95,  110, 110,
  125, 125, 140, 140, 155, 155, 170, 170, 185, 185, 200, 200, 215, 215, 230,
  230, 245, 245, 260, 260, 275, 275, 290, 290, 305, 305, 320, 320, 320, 111,
  126, 126, 141, 141, 156, 156, 171, 171, 186, 186, 201, 201, 216, 216, 231,
  231, 246, 246, 261, 261, 276, 276, 291, 291, 306, 306, 321, 321, 336, 336,
  336, 127, 142, 142, 157, 157, 172, 172, 187, 187, 202, 202, 217, 217, 232,
  232, 247, 247, 262, 262, 277, 277, 292, 292, 307, 307, 322, 322, 337, 337,
  352, 352, 352, 143, 158, 158, 173, 173, 188, 188, 203, 203, 218, 218, 233,
  233, 248, 248, 263, 263, 278, 278, 293, 293, 308, 308, 323, 323, 338, 338,
  353, 353, 368, 368, 368, 159, 174, 174, 189, 189, 204, 204, 219, 219, 234,
  234, 249, 249, 264, 264, 279, 279, 294, 294, 309, 309, 324, 324, 339, 339,
  354, 354, 369, 369, 384, 384, 384, 175, 190, 190, 205, 205, 220, 220, 235,
  235, 250, 250, 265, 265, 280, 280, 295, 295, 310, 310, 325, 325, 340, 340,
  355, 355, 370, 370, 385, 385, 400, 400, 400, 191, 206, 206, 221, 221, 236,
  236, 251, 251, 266, 266, 281, 281, 296, 296, 311, 311, 326, 326, 341, 341,
  356, 356, 371, 371, 386, 386, 401, 401, 416, 416, 416, 207, 222, 222, 237,
  237, 252, 252, 267, 267, 282, 282, 297, 297, 312, 312, 327, 327, 342, 342,
  357, 357, 372, 372, 387, 387, 402, 402, 417, 417, 432, 432, 432, 223, 238,
  238, 253, 253, 268, 268, 283, 283, 298, 298, 313, 313, 328, 328, 343, 343,
  358, 358, 373, 373, 388, 388, 403, 403, 418, 418, 433, 433, 448, 448, 448,
  239, 254, 254, 269, 269, 284, 284, 299, 299, 314, 314, 329, 329, 344, 344,
  359, 359, 374, 374, 389, 389, 404, 404, 419, 419, 434, 434, 449, 449, 464,
  464, 464, 255, 270, 270, 285, 285, 300, 300, 315, 315, 330, 330, 345, 345,
  360, 360, 375, 375, 390, 390, 405, 405, 420, 420, 435, 435, 450, 450, 465,
  465, 480, 480, 480, 271, 286, 286, 301, 301, 316, 316, 331, 331, 346, 346,
  361, 361, 376, 376, 391, 391, 406, 406, 421, 421, 436, 436, 451, 451, 466,
  466, 481, 481, 496, 287, 302, 302, 317, 317, 332, 332, 347, 347, 362, 362,
  377, 377, 392, 392, 407, 407, 422, 422, 437, 437, 452, 452, 467, 467, 482,
  482, 497, 303, 318, 318, 333, 333, 348, 348, 363, 363, 378, 378, 393, 393,
  408, 408, 423, 423, 438, 438, 453, 453, 468, 468, 483, 483, 498, 319, 334,
  334, 349, 349, 364, 364, 379, 379, 394, 394, 409, 409, 424, 424, 439, 439,
  454, 454, 469, 469, 484, 484, 499, 335, 350, 350, 365, 365, 380, 380, 395,
  395, 410, 410, 425, 425, 440, 440, 455, 455, 470, 470, 485, 485, 500, 351,
  366, 366, 381, 381, 396, 396, 411, 411, 426, 426, 441, 441, 456, 456, 471,
  471, 486, 486, 501, 367, 382, 382, 397, 397, 412, 412, 427, 427, 442, 442,
  457, 457, 472, 472, 487, 487, 502, 383, 398, 398, 413, 413, 428, 428, 443,
  443, 458, 458, 473, 473, 488, 488, 503, 399, 414, 414, 429, 429, 444, 444,
  459, 459, 474, 474, 489, 489, 504, 415, 430, 430, 445, 445, 460, 460, 475,
  475, 490, 490, 505, 431, 446, 446, 461, 461, 476, 476, 491, 491, 506, 447,
  462, 462, 477, 477, 492, 492, 507, 463, 478, 478, 493, 493, 508, 479, 494,
  494, 509, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   0,   0,   1,   1,   1,   32,  32,  32,  2,   2,   2,
  33,  33,  64,  64,  64,  3,   3,   3,   34,  34,  65,  65,  96,  96,  96,
  4,   4,   4,   35,  35,  66,  66,  97,  97,  128, 128, 128, 5,   5,   5,
  36,  36,  67,  67,  98,  98,  129, 129, 160, 160, 160, 6,   6,   6,   37,
  37,  68,  68,  99,  99,  130, 130, 161, 161, 192, 192, 192, 7,   7,   7,
  38,  38,  69,  69,  100, 100, 131, 131, 162, 162, 193, 193, 224, 224, 224,
  8,   8,   8,   39,  39,  70,  70,  101, 101, 132, 132, 163, 163, 194, 194,
  225, 225, 256, 256, 256, 9,   9,   9,   40,  40,  71,  71,  102, 102, 133,
  133, 164, 164, 195, 195, 226, 226, 257, 257, 288, 288, 288, 10,  10,  10,
  41,  41,  72,  72,  103, 103, 134, 134, 165, 165, 196, 196, 227, 227, 258,
  258, 289, 289, 320, 320, 320, 11,  11,  11,  42,  42,  73,  73,  104, 104,
  135, 135, 166, 166, 197, 197, 228, 228, 259, 259, 290, 290, 321, 321, 352,
  352, 352, 12,  12,  12,  43,  43,  74,  74,  105, 105, 136, 136, 167, 167,
  198, 198, 229, 229, 260, 260, 291, 291, 322, 322, 353, 353, 384, 384, 384,
  13,  13,  13,  44,  44,  75,  75,  106, 106, 137, 137, 168, 168, 199, 199,
  230, 230, 261, 261, 292, 292, 323, 323, 354, 354, 385, 385, 416, 416, 416,
  14,  14,  14,  45,  45,  76,  76,  107, 107, 138, 138, 169, 169, 200, 200,
  231, 231, 262, 262, 293, 293, 324, 324, 355, 355, 386, 386, 417, 417, 448,
  448, 448, 15,  15,  15,  46,  46,  77,  77,  108, 108, 139, 139, 170, 170,
  201, 201, 232, 232, 263, 263, 294, 294, 325, 325, 356, 356, 387, 387, 418,
  418, 449, 449, 480, 16,  16,  16,  47,  47,  78,  78,  109, 109, 140, 140,
  171, 171, 202, 202, 233, 233, 264, 264, 295, 295, 326, 326, 357, 357, 388,
  388, 419, 419, 450, 450, 481, 17,  17,  17,  48,  48,  79,  79,  110, 110,
  141, 141, 172, 172, 203, 203, 234, 234, 265, 265, 296, 296, 327, 327, 358,
  358, 389, 389, 420, 420, 451, 451, 482, 18,  18,  18,  49,  49,  80,  80,
  111, 111, 142, 142, 173, 173, 204, 204, 235, 235, 266, 266, 297, 297, 328,
  328, 359, 359, 390, 390, 421, 421, 452, 452, 483, 19,  19,  19,  50,  50,
  81,  81,  112, 112, 143, 143, 174, 174, 205, 205, 236, 236, 267, 267, 298,
  298, 329, 329, 360, 360, 391, 391, 422, 422, 453, 453, 484, 20,  20,  20,
  51,  51,  82,  82,  113, 113, 144, 144, 175, 175, 206, 206, 237, 237, 268,
  268, 299, 299, 330, 330, 361, 361, 392, 392, 423, 423, 454, 454, 485, 21,
  21,  21,  52,  52,  83,  83,  114, 114, 145, 145, 176, 176, 207, 207, 238,
  238, 269, 269, 300, 300, 331, 331, 362, 362, 393, 393, 424, 424, 455, 455,
  486, 22,  22,  22,  53,  53,  84,  84,  115, 115, 146, 146, 177, 177, 208,
  208, 239, 239, 270, 270, 301, 301, 332, 332, 363, 363, 394, 394, 425, 425,
  456, 456, 487, 23,  23,  23,  54,  54,  85,  85,  116, 116, 147, 147, 178,
  178, 209, 209, 240, 240, 271, 271, 302, 302, 333, 333, 364, 364, 395, 395,
  426, 426, 457, 457, 488, 24,  24,  24,  55,  55,  86,  86,  117, 117, 148,
  148, 179, 179, 210, 210, 241, 241, 272, 272, 303, 303, 334, 334, 365, 365,
  396, 396, 427, 427, 458, 458, 489, 25,  25,  25,  56,  56,  87,  87,  118,
  118, 149, 149, 180, 180, 211, 211, 242, 242, 273, 273, 304, 304, 335, 335,
  366, 366, 397, 397, 428, 428, 459, 459, 490, 26,  26,  26,  57,  57,  88,
  88,  119, 119, 150, 150, 181, 181, 212, 212, 243, 243, 274, 274, 305, 305,
  336, 336, 367, 367, 398, 398, 429, 429, 460, 460, 491, 27,  27,  27,  58,
  58,  89,  89,  120, 120, 151, 151, 182, 182, 213, 213, 244, 244, 275, 275,
  306, 306, 337, 337, 368, 368, 399, 399, 430, 430, 461, 461, 492, 28,  28,
  28,  59,  59,  90,  90,  121, 121, 152, 152, 183, 183, 214, 214, 245, 245,
  276, 276, 307, 307, 338, 338, 369, 369, 400, 400, 431, 431, 462, 462, 493,
  29,  29,  29,  60,  60,  91,  91,  122, 122, 153, 153, 184, 184, 215, 215,
  246, 246, 277, 277, 308, 308, 339, 339, 370, 370, 401, 401, 432, 432, 463,
  463, 494, 30,  30,  30,  61,  61,  92,  92,  123, 123, 154, 154, 185, 185,
  216, 216, 247, 247, 278, 278, 309, 309, 340, 340, 371, 371, 402, 402, 433,
  433, 464, 464, 495, 31,  62,  62,  93,  93,  124, 124, 155, 155, 186, 186,
  217, 217, 248, 248, 279, 279, 310, 310, 341, 341, 372, 372, 403, 403, 434,
  434, 465, 465, 496, 63,  94,  94,  125, 125, 156, 156, 187, 187, 218, 218,
  249, 249, 280, 280, 311, 311, 342, 342, 373, 373, 404, 404, 435, 435, 466,
  466, 497, 95,  126, 126, 157, 157, 188, 188, 219, 219, 250, 250, 281, 281,
  312, 312, 343, 343, 374, 374, 405, 405, 436, 436, 467, 467, 498, 127, 158,
  158, 189, 189, 220, 220, 251, 251, 282, 282, 313, 313, 344, 344, 375, 375,
  406, 406, 437, 437, 468, 468, 499, 159, 190, 190, 221, 221, 252, 252, 283,
  283, 314, 314, 345, 345, 376, 376, 407, 407, 438, 438, 469, 469, 500, 191,
  222, 222, 253, 253, 284, 284, 315, 315, 346, 346, 377, 377, 408, 408, 439,
  439, 470, 470, 501, 223, 254, 254, 285, 285, 316, 316, 347, 347, 378, 378,
  409, 409, 440, 440, 471, 471, 502, 255, 286, 286, 317, 317, 348, 348, 379,
  379, 410, 410, 441, 441, 472, 472, 503, 287, 318, 318, 349, 349, 380, 380,
  411, 411, 442, 442, 473, 473, 504, 319, 350, 350, 381, 381, 412, 412, 443,
  443, 474, 474, 505, 351, 382, 382, 413, 413, 444, 444, 475, 475, 506, 383,
  414, 414, 445, 445, 476, 476, 507, 415, 446, 446, 477, 477, 508, 447, 478,
  478, 509, 479, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  16,  32,  32,  48,  48,  64,  64,  80,  80,  96,
  96,  112, 112, 128, 128, 144, 144, 160, 160, 176, 176, 192, 192, 208, 208,
  224, 224, 240, 240, 256, 256, 272, 272, 288, 288, 304, 304, 320, 320, 336,
  336, 352, 352, 368, 368, 384, 384, 400, 400, 416, 416, 432, 432, 448, 448,
  464, 464, 480, 480, 0,   0,   1,   16,  17,  32,  33,  48,  49,  64,  65,
  80,  81,  96,  97,  112, 113, 128, 129, 144, 145, 160, 161, 176, 177, 192,
  193, 208, 209, 224, 225, 240, 241, 256, 257, 272, 273, 288, 289, 304, 305,
  320, 321, 336, 337, 352, 353, 368, 369, 384, 385, 400, 401, 416, 417, 432,
  433, 448, 449, 464, 465, 480, 481, 496, 1,   1,   2,   17,  18,  33,  34,
  49,  50,  65,  66,  81,  82,  97,  98,  113, 114, 129, 130, 145, 146, 161,
  162, 177, 178, 193, 194, 209, 210, 225, 226, 241, 242, 257, 258, 273, 274,
  289, 290, 305, 306, 321, 322, 337, 338, 353, 354, 369, 370, 385, 386, 401,
  402, 417, 418, 433, 434, 449, 450, 465, 466, 481, 482, 497, 2,   2,   3,
  18,  19,  34,  35,  50,  51,  66,  67,  82,  83,  98,  99,  114, 115, 130,
  131, 146, 147, 162, 163, 178, 179, 194, 195, 210, 211, 226, 227, 242, 243,
  258, 259, 274, 275, 290, 291, 306, 307, 322, 323, 338, 339, 354, 355, 370,
  371, 386, 387, 402, 403, 418, 419, 434, 435, 450, 451, 466, 467, 482, 483,
  498, 3,   3,   4,   19,  20,  35,  36,  51,  52,  67,  68,  83,  84,  99,
  100, 115, 116, 131, 132, 147, 148, 163, 164, 179, 180, 195, 196, 211, 212,
  227, 228, 243, 244, 259, 260, 275, 276, 291, 292, 307, 308, 323, 324, 339,
  340, 355, 356, 371, 372, 387, 388, 403, 404, 419, 420, 435, 436, 451, 452,
  467, 468, 483, 484, 499, 4,   4,   5,   20,  21,  36,  37,  52,  53,  68,
  69,  84,  85,  100, 101, 116, 117, 132, 133, 148, 149, 164, 165, 180, 181,
  196, 197, 212, 213, 228, 229, 244, 245, 260, 261, 276, 277, 292, 293, 308,
  309, 324, 325, 340, 341, 356, 357, 372, 373, 388, 389, 404, 405, 420, 421,
  436, 437, 452, 453, 468, 469, 484, 485, 500, 5,   5,   6,   21,  22,  37,
  38,  53,  54,  69,  70,  85,  86,  101, 102, 117, 118, 133, 134, 149, 150,
  165, 166, 181, 182, 197, 198, 213, 214, 229, 230, 245, 246, 261, 262, 277,
  278, 293, 294, 309, 310, 325, 326, 341, 342, 357, 358, 373, 374, 389, 390,
  405, 406, 421, 422, 437, 438, 453, 454, 469, 470, 485, 486, 501, 6,   6,
  7,   22,  23,  38,  39,  54,  55,  70,  71,  86,  87,  102, 103, 118, 119,
  134, 135, 150, 151, 166, 167, 182, 183, 198, 199, 214, 215, 230, 231, 246,
  247, 262, 263, 278, 279, 294, 295, 310, 311, 326, 327, 342, 343, 358, 359,
  374, 375, 390, 391, 406, 407, 422, 423, 438, 439, 454, 455, 470, 471, 486,
  487, 502, 7,   7,   8,   23,  24,  39,  40,  55,  56,  71,  72,  87,  88,
  103, 104, 119, 120, 135, 136, 151, 152, 167, 168, 183, 184, 199, 200, 215,
  216, 231, 232, 247, 248, 263, 264, 279, 280, 295, 296, 311, 312, 327, 328,
  343, 344, 359, 360, 375, 376, 391, 392, 407, 408, 423, 424, 439, 440, 455,
  456, 471, 472, 487, 488, 503, 8,   8,   9,   24,  25,  40,  41,  56,  57,
  72,  73,  88,  89,  104, 105, 120, 121, 136, 137, 152, 153, 168, 169, 184,
  185, 200, 201, 216, 217, 232, 233, 248, 249, 264, 265, 280, 281, 296, 297,
  312, 313, 328, 329, 344, 345, 360, 361, 376, 377, 392, 393, 408, 409, 424,
  425, 440, 441, 456, 457, 472, 473, 488, 489, 504, 9,   9,   10,  25,  26,
  41,  42,  57,  58,  73,  74,  89,  90,  105, 106, 121, 122, 137, 138, 153,
  154, 169, 170, 185, 186, 201, 202, 217, 218, 233, 234, 249, 250, 265, 266,
  281, 282, 297, 298, 313, 314, 329, 330, 345, 346, 361, 362, 377, 378, 393,
  394, 409, 410, 425, 426, 441, 442, 457, 458, 473, 474, 489, 490, 505, 10,
  10,  11,  26,  27,  42,  43,  58,  59,  74,  75,  90,  91,  106, 107, 122,
  123, 138, 139, 154, 155, 170, 171, 186, 187, 202, 203, 218, 219, 234, 235,
  250, 251, 266, 267, 282, 283, 298, 299, 314, 315, 330, 331, 346, 347, 362,
  363, 378, 379, 394, 395, 410, 411, 426, 427, 442, 443, 458, 459, 474, 475,
  490, 491, 506, 11,  11,  12,  27,  28,  43,  44,  59,  60,  75,  76,  91,
  92,  107, 108, 123, 124, 139, 140, 155, 156, 171, 172, 187, 188, 203, 204,
  219, 220, 235, 236, 251, 252, 267, 268, 283, 284, 299, 300, 315, 316, 331,
  332, 347, 348, 363, 364, 379, 380, 395, 396, 411, 412, 427, 428, 443, 444,
  459, 460, 475, 476, 491, 492, 507, 12,  12,  13,  28,  29,  44,  45,  60,
  61,  76,  77,  92,  93,  108, 109, 124, 125, 140, 141, 156, 157, 172, 173,
  188, 189, 204, 205, 220, 221, 236, 237, 252, 253, 268, 269, 284, 285, 300,
  301, 316, 317, 332, 333, 348, 349, 364, 365, 380, 381, 396, 397, 412, 413,
  428, 429, 444, 445, 460, 461, 476, 477, 492, 493, 508, 13,  13,  14,  29,
  30,  45,  46,  61,  62,  77,  78,  93,  94,  109, 110, 125, 126, 141, 142,
  157, 158, 173, 174, 189, 190, 205, 206, 221, 222, 237, 238, 253, 254, 269,
  270, 285, 286, 301, 302, 317, 318, 333, 334, 349, 350, 365, 366, 381, 382,
  397, 398, 413, 414, 429, 430, 445, 446, 461, 462, 477, 478, 493, 494, 509,
  14,  14,  15,  30,  31,  46,  47,  62,  63,  78,  79,  94,  95,  110, 111,
  126, 127, 142, 143, 158, 159, 174, 175, 190, 191, 206, 207, 222, 223, 238,
  239, 254, 255, 270, 271, 286, 287, 302, 303, 318, 319, 334, 335, 350, 351,
  366, 367, 382, 383, 398, 399, 414, 415, 430, 431, 446, 447, 462, 463, 478,
  479, 494, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   32,  32,  64,  64,  96,  96,  128, 128, 160, 160, 192,
  192, 224, 224, 256, 256, 288, 288, 320, 320, 352, 352, 384, 384, 416, 416,
  448, 448, 0,   0,   1,   32,  33,  64,  65,  96,  97,  128, 129, 160, 161,
  192, 193, 224, 225, 256, 257, 288, 289, 320, 321, 352, 353, 384, 385, 416,
  417, 448, 449, 480, 1,   1,   2,   33,  34,  65,  66,  97,  98,  129, 130,
  161, 162, 193, 194, 225, 226, 257, 258, 289, 290, 321, 322, 353, 354, 385,
  386, 417, 418, 449, 450, 481, 2,   2,   3,   34,  35,  66,  67,  98,  99,
  130, 131, 162, 163, 194, 195, 226, 227, 258, 259, 290, 291, 322, 323, 354,
  355, 386, 387, 418, 419, 450, 451, 482, 3,   3,   4,   35,  36,  67,  68,
  99,  100, 131, 132, 163, 164, 195, 196, 227, 228, 259, 260, 291, 292, 323,
  324, 355, 356, 387, 388, 419, 420, 451, 452, 483, 4,   4,   5,   36,  37,
  68,  69,  100, 101, 132, 133, 164, 165, 196, 197, 228, 229, 260, 261, 292,
  293, 324, 325, 356, 357, 388, 389, 420, 421, 452, 453, 484, 5,   5,   6,
  37,  38,  69,  70,  101, 102, 133, 134, 165, 166, 197, 198, 229, 230, 261,
  262, 293, 294, 325, 326, 357, 358, 389, 390, 421, 422, 453, 454, 485, 6,
  6,   7,   38,  39,  70,  71,  102, 103, 134, 135, 166, 167, 198, 199, 230,
  231, 262, 263, 294, 295, 326, 327, 358, 359, 390, 391, 422, 423, 454, 455,
  486, 7,   7,   8,   39,  40,  71,  72,  103, 104, 135, 136, 167, 168, 199,
  200, 231, 232, 263, 264, 295, 296, 327, 328, 359, 360, 391, 392, 423, 424,
  455, 456, 487, 8,   8,   9,   40,  41,  72,  73,  104, 105, 136, 137, 168,
  169, 200, 201, 232, 233, 264, 265, 296, 297, 328, 329, 360, 361, 392, 393,
  424, 425, 456, 457, 488, 9,   9,   10,  41,  42,  73,  74,  105, 106, 137,
  138, 169, 170, 201, 202, 233, 234, 265, 266, 297, 298, 329, 330, 361, 362,
  393, 394, 425, 426, 457, 458, 489, 10,  10,  11,  42,  43,  74,  75,  106,
  107, 138, 139, 170, 171, 202, 203, 234, 235, 266, 267, 298, 299, 330, 331,
  362, 363, 394, 395, 426, 427, 458, 459, 490, 11,  11,  12,  43,  44,  75,
  76,  107, 108, 139, 140, 171, 172, 203, 204, 235, 236, 267, 268, 299, 300,
  331, 332, 363, 364, 395, 396, 427, 428, 459, 460, 491, 12,  12,  13,  44,
  45,  76,  77,  108, 109, 140, 141, 172, 173, 204, 205, 236, 237, 268, 269,
  300, 301, 332, 333, 364, 365, 396, 397, 428, 429, 460, 461, 492, 13,  13,
  14,  45,  46,  77,  78,  109, 110, 141, 142, 173, 174, 205, 206, 237, 238,
  269, 270, 301, 302, 333, 334, 365, 366, 397, 398, 429, 430, 461, 462, 493,
  14,  14,  15,  46,  47,  78,  79,  110, 111, 142, 143, 174, 175, 206, 207,
  238, 239, 270, 271, 302, 303, 334, 335, 366, 367, 398, 399, 430, 431, 462,
  463, 494, 15,  15,  16,  47,  48,  79,  80,  111, 112, 143, 144, 175, 176,
  207, 208, 239, 240, 271, 272, 303, 304, 335, 336, 367, 368, 399, 400, 431,
  432, 463, 464, 495, 16,  16,  17,  48,  49,  80,  81,  112, 113, 144, 145,
  176, 177, 208, 209, 240, 241, 272, 273, 304, 305, 336, 337, 368, 369, 400,
  401, 432, 433, 464, 465, 496, 17,  17,  18,  49,  50,  81,  82,  113, 114,
  145, 146, 177, 178, 209, 210, 241, 242, 273, 274, 305, 306, 337, 338, 369,
  370, 401, 402, 433, 434, 465, 466, 497, 18,  18,  19,  50,  51,  82,  83,
  114, 115, 146, 147, 178, 179, 210, 211, 242, 243, 274, 275, 306, 307, 338,
  339, 370, 371, 402, 403, 434, 435, 466, 467, 498, 19,  19,  20,  51,  52,
  83,  84,  115, 116, 147, 148, 179, 180, 211, 212, 243, 244, 275, 276, 307,
  308, 339, 340, 371, 372, 403, 404, 435, 436, 467, 468, 499, 20,  20,  21,
  52,  53,  84,  85,  116, 117, 148, 149, 180, 181, 212, 213, 244, 245, 276,
  277, 308, 309, 340, 341, 372, 373, 404, 405, 436, 437, 468, 469, 500, 21,
  21,  22,  53,  54,  85,  86,  117, 118, 149, 150, 181, 182, 213, 214, 245,
  246, 277, 278, 309, 310, 341, 342, 373, 374, 405, 406, 437, 438, 469, 470,
  501, 22,  22,  23,  54,  55,  86,  87,  118, 119, 150, 151, 182, 183, 214,
  215, 246, 247, 278, 279, 310, 311, 342, 343, 374, 375, 406, 407, 438, 439,
  470, 471, 502, 23,  23,  24,  55,  56,  87,  88,  119, 120, 151, 152, 183,
  184, 215, 216, 247, 248, 279, 280, 311, 312, 343, 344, 375, 376, 407, 408,
  439, 440, 471, 472, 503, 24,  24,  25,  56,  57,  88,  89,  120, 121, 152,
  153, 184, 185, 216, 217, 248, 249, 280, 281, 312, 313, 344, 345, 376, 377,
  408, 409, 440, 441, 472, 473, 504, 25,  25,  26,  57,  58,  89,  90,  121,
  122, 153, 154, 185, 186, 217, 218, 249, 250, 281, 282, 313, 314, 345, 346,
  377, 378, 409, 410, 441, 442, 473, 474, 505, 26,  26,  27,  58,  59,  90,
  91,  122, 123, 154, 155, 186, 187, 218, 219, 250, 251, 282, 283, 314, 315,
  346, 347, 378, 379, 410, 411, 442, 443, 474, 475, 506, 27,  27,  28,  59,
  60,  91,  92,  123, 124, 155, 156, 187, 188, 219, 220, 251, 252, 283, 284,
  315, 316, 347, 348, 379, 380, 411, 412, 443, 444, 475, 476, 507, 28,  28,
  29,  60,  61,  92,  93,  124, 125, 156, 157, 188, 189, 220, 221, 252, 253,
  284, 285, 316, 317, 348, 349, 380, 381, 412, 413, 444, 445, 476, 477, 508,
  29,  29,  30,  61,  62,  93,  94,  125, 126, 157, 158, 189, 190, 221, 222,
  253, 254, 285, 286, 317, 318, 349, 350, 381, 382, 413, 414, 445, 446, 477,
  478, 509, 30,  30,  31,  62,  63,  94,  95,  126, 127, 158, 159, 190, 191,
  222, 223, 254, 255, 286, 287, 318, 319, 350, 351, 382, 383, 414, 415, 446,
  447, 478, 479, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x32_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 112, 112, 113, 128, 114, 129, 115, 130, 116, 131, 117, 132, 118, 133,
  119, 134, 120, 135, 121, 136, 122, 137, 123, 138, 124, 139, 125, 140, 126,
  141, 127, 142, 128, 128, 129, 144, 130, 145, 131, 146, 132, 147, 133, 148,
  134, 149, 135, 150, 136, 151, 137, 152, 138, 153, 139, 154, 140, 155, 141,
  156, 142, 157, 143, 158, 144, 144, 145, 160, 146, 161, 147, 162, 148, 163,
  149, 164, 150, 165, 151, 166, 152, 167, 153, 168, 154, 169, 155, 170, 156,
  171, 157, 172, 158, 173, 159, 174, 160, 160, 161, 176, 162, 177, 163, 178,
  164, 179, 165, 180, 166, 181, 167, 182, 168, 183, 169, 184, 170, 185, 171,
  186, 172, 187, 173, 188, 174, 189, 175, 190, 176, 176, 177, 192, 178, 193,
  179, 194, 180, 195, 181, 196, 182, 197, 183, 198, 184, 199, 185, 200, 186,
  201, 187, 202, 188, 203, 189, 204, 190, 205, 191, 206, 192, 192, 193, 208,
  194, 209, 195, 210, 196, 211, 197, 212, 198, 213, 199, 214, 200, 215, 201,
  216, 202, 217, 203, 218, 204, 219, 205, 220, 206, 221, 207, 222, 208, 208,
  209, 224, 210, 225, 211, 226, 212, 227, 213, 228, 214, 229, 215, 230, 216,
  231, 217, 232, 218, 233, 219, 234, 220, 235, 221, 236, 222, 237, 223, 238,
  224, 224, 225, 240, 226, 241, 227, 242, 228, 243, 229, 244, 230, 245, 231,
  246, 232, 247, 233, 248, 234, 249, 235, 250, 236, 251, 237, 252, 238, 253,
  239, 254, 240, 240, 241, 256, 242, 257, 243, 258, 244, 259, 245, 260, 246,
  261, 247, 262, 248, 263, 249, 264, 250, 265, 251, 266, 252, 267, 253, 268,
  254, 269, 255, 270, 256, 256, 257, 272, 258, 273, 259, 274, 260, 275, 261,
  276, 262, 277, 263, 278, 264, 279, 265, 280, 266, 281, 267, 282, 268, 283,
  269, 284, 270, 285, 271, 286, 272, 272, 273, 288, 274, 289, 275, 290, 276,
  291, 277, 292, 278, 293, 279, 294, 280, 295, 281, 296, 282, 297, 283, 298,
  284, 299, 285, 300, 286, 301, 287, 302, 288, 288, 289, 304, 290, 305, 291,
  306, 292, 307, 293, 308, 294, 309, 295, 310, 296, 311, 297, 312, 298, 313,
  299, 314, 300, 315, 301, 316, 302, 317, 303, 318, 304, 304, 305, 320, 306,
  321, 307, 322, 308, 323, 309, 324, 310, 325, 311, 326, 312, 327, 313, 328,
  314, 329, 315, 330, 316, 331, 317, 332, 318, 333, 319, 334, 320, 320, 321,
  336, 322, 337, 323, 338, 324, 339, 325, 340, 326, 341, 327, 342, 328, 343,
  329, 344, 330, 345, 331, 346, 332, 347, 333, 348, 334, 349, 335, 350, 336,
  336, 337, 352, 338, 353, 339, 354, 340, 355, 341, 356, 342, 357, 343, 358,
  344, 359, 345, 360, 346, 361, 347, 362, 348, 363, 349, 364, 350, 365, 351,
  366, 352, 352, 353, 368, 354, 369, 355, 370, 356, 371, 357, 372, 358, 373,
  359, 374, 360, 375, 361, 376, 362, 377, 363, 378, 364, 379, 365, 380, 366,
  381, 367, 382, 368, 368, 369, 384, 370, 385, 371, 386, 372, 387, 373, 388,
  374, 389, 375, 390, 376, 391, 377, 392, 378, 393, 379, 394, 380, 395, 381,
  396, 382, 397, 383, 398, 384, 384, 385, 400, 386, 401, 387, 402, 388, 403,
  389, 404, 390, 405, 391, 406, 392, 407, 393, 408, 394, 409, 395, 410, 396,
  411, 397, 412, 398, 413, 399, 414, 400, 400, 401, 416, 402, 417, 403, 418,
  404, 419, 405, 420, 406, 421, 407, 422, 408, 423, 409, 424, 410, 425, 411,
  426, 412, 427, 413, 428, 414, 429, 415, 430, 416, 416, 417, 432, 418, 433,
  419, 434, 420, 435, 421, 436, 422, 437, 423, 438, 424, 439, 425, 440, 426,
  441, 427, 442, 428, 443, 429, 444, 430, 445, 431, 446, 432, 432, 433, 448,
  434, 449, 435, 450, 436, 451, 437, 452, 438, 453, 439, 454, 440, 455, 441,
  456, 442, 457, 443, 458, 444, 459, 445, 460, 446, 461, 447, 462, 448, 448,
  449, 464, 450, 465, 451, 466, 452, 467, 453, 468, 454, 469, 455, 470, 456,
  471, 457, 472, 458, 473, 459, 474, 460, 475, 461, 476, 462, 477, 463, 478,
  464, 464, 465, 480, 466, 481, 467, 482, 468, 483, 469, 484, 470, 485, 471,
  486, 472, 487, 473, 488, 474, 489, 475, 490, 476, 491, 477, 492, 478, 493,
  479, 494, 480, 480, 481, 496, 482, 497, 483, 498, 484, 499, 485, 500, 486,
  501, 487, 502, 488, 503, 489, 504, 490, 505, 491, 506, 492, 507, 493, 508,
  494, 509, 495, 510, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x16_neighbors[513 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  19,  20,  20,  21,
  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  28,  28,
  29,  29,  30,  30,  0,   0,   1,   32,  2,   33,  3,   34,  4,   35,  5,
  36,  6,   37,  7,   38,  8,   39,  9,   40,  10,  41,  11,  42,  12,  43,
  13,  44,  14,  45,  15,  46,  16,  47,  17,  48,  18,  49,  19,  50,  20,
  51,  21,  52,  22,  53,  23,  54,  24,  55,  25,  56,  26,  57,  27,  58,
  28,  59,  29,  60,  30,  61,  31,  62,  32,  32,  33,  64,  34,  65,  35,
  66,  36,  67,  37,  68,  38,  69,  39,  70,  40,  71,  41,  72,  42,  73,
  43,  74,  44,  75,  45,  76,  46,  77,  47,  78,  48,  79,  49,  80,  50,
  81,  51,  82,  52,  83,  53,  84,  54,  85,  55,  86,  56,  87,  57,  88,
  58,  89,  59,  90,  60,  91,  61,  92,  62,  93,  63,  94,  64,  64,  65,
  96,  66,  97,  67,  98,  68,  99,  69,  100, 70,  101, 71,  102, 72,  103,
  73,  104, 74,  105, 75,  106, 76,  107, 77,  108, 78,  109, 79,  110, 80,
  111, 81,  112, 82,  113, 83,  114, 84,  115, 85,  116, 86,  117, 87,  118,
  88,  119, 89,  120, 90,  121, 91,  122, 92,  123, 93,  124, 94,  125, 95,
  126, 96,  96,  97,  128, 98,  129, 99,  130, 100, 131, 101, 132, 102, 133,
  103, 134, 104, 135, 105, 136, 106, 137, 107, 138, 108, 139, 109, 140, 110,
  141, 111, 142, 112, 143, 113, 144, 114, 145, 115, 146, 116, 147, 117, 148,
  118, 149, 119, 150, 120, 151, 121, 152, 122, 153, 123, 154, 124, 155, 125,
  156, 126, 157, 127, 158, 128, 128, 129, 160, 130, 161, 131, 162, 132, 163,
  133, 164, 134, 165, 135, 166, 136, 167, 137, 168, 138, 169, 139, 170, 140,
  171, 141, 172, 142, 173, 143, 174, 144, 175, 145, 176, 146, 177, 147, 178,
  148, 179, 149, 180, 150, 181, 151, 182, 152, 183, 153, 184, 154, 185, 155,
  186, 156, 187, 157, 188, 158, 189, 159, 190, 160, 160, 161, 192, 162, 193,
  163, 194, 164, 195, 165, 196, 166, 197, 167, 198, 168, 199, 169, 200, 170,
  201, 171, 202, 172, 203, 173, 204, 174, 205, 175, 206, 176, 207, 177, 208,
  178, 209, 179, 210, 180, 211, 181, 212, 182, 213, 183, 214, 184, 215, 185,
  216, 186, 217, 187, 218, 188, 219, 189, 220, 190, 221, 191, 222, 192, 192,
  193, 224, 194, 225, 195, 226, 196, 227, 197, 228, 198, 229, 199, 230, 200,
  231, 201, 232, 202, 233, 203, 234, 204, 235, 205, 236, 206, 237, 207, 238,
  208, 239, 209, 240, 210, 241, 211, 242, 212, 243, 213, 244, 214, 245, 215,
  246, 216, 247, 217, 248, 218, 249, 219, 250, 220, 251, 221, 252, 222, 253,
  223, 254, 224, 224, 225, 256, 226, 257, 227, 258, 228, 259, 229, 260, 230,
  261, 231, 262, 232, 263, 233, 264, 234, 265, 235, 266, 236, 267, 237, 268,
  238, 269, 239, 270, 240, 271, 241, 272, 242, 273, 243, 274, 244, 275, 245,
  276, 246, 277, 247, 278, 248, 279, 249, 280, 250, 281, 251, 282, 252, 283,
  253, 284, 254, 285, 255, 286, 256, 256, 257, 288, 258, 289, 259, 290, 260,
  291, 261, 292, 262, 293, 263, 294, 264, 295, 265, 296, 266, 297, 267, 298,
  268, 299, 269, 300, 270, 301, 271, 302, 272, 303, 273, 304, 274, 305, 275,
  306, 276, 307, 277, 308, 278, 309, 279, 310, 280, 311, 281, 312, 282, 313,
  283, 314, 284, 315, 285, 316, 286, 317, 287, 318, 288, 288, 289, 320, 290,
  321, 291, 322, 292, 323, 293, 324, 294, 325, 295, 326, 296, 327, 297, 328,
  298, 329, 299, 330, 300, 331, 301, 332, 302, 333, 303, 334, 304, 335, 305,
  336, 306, 337, 307, 338, 308, 339, 309, 340, 310, 341, 311, 342, 312, 343,
  313, 344, 314, 345, 315, 346, 316, 347, 317, 348, 318, 349, 319, 350, 320,
  320, 321, 352, 322, 353, 323, 354, 324, 355, 325, 356, 326, 357, 327, 358,
  328, 359, 329, 360, 330, 361, 331, 362, 332, 363, 333, 364, 334, 365, 335,
  366, 336, 367, 337, 368, 338, 369, 339, 370, 340, 371, 341, 372, 342, 373,
  343, 374, 344, 375, 345, 376, 346, 377, 347, 378, 348, 379, 349, 380, 350,
  381, 351, 382, 352, 352, 353, 384, 354, 385, 355, 386, 356, 387, 357, 388,
  358, 389, 359, 390, 360, 391, 361, 392, 362, 393, 363, 394, 364, 395, 365,
  396, 366, 397, 367, 398, 368, 399, 369, 400, 370, 401, 371, 402, 372, 403,
  373, 404, 374, 405, 375, 406, 376, 407, 377, 408, 378, 409, 379, 410, 380,
  411, 381, 412, 382, 413, 383, 414, 384, 384, 385, 416, 386, 417, 387, 418,
  388, 419, 389, 420, 390, 421, 391, 422, 392, 423, 393, 424, 394, 425, 395,
  426, 396, 427, 397, 428, 398, 429, 399, 430, 400, 431, 401, 432, 402, 433,
  403, 434, 404, 435, 405, 436, 406, 437, 407, 438, 408, 439, 409, 440, 410,
  441, 411, 442, 412, 443, 413, 444, 414, 445, 415, 446, 416, 416, 417, 448,
  418, 449, 419, 450, 420, 451, 421, 452, 422, 453, 423, 454, 424, 455, 425,
  456, 426, 457, 427, 458, 428, 459, 429, 460, 430, 461, 431, 462, 432, 463,
  433, 464, 434, 465, 435, 466, 436, 467, 437, 468, 438, 469, 439, 470, 440,
  471, 441, 472, 442, 473, 443, 474, 444, 475, 445, 476, 446, 477, 447, 478,
  448, 448, 449, 480, 450, 481, 451, 482, 452, 483, 453, 484, 454, 485, 455,
  486, 456, 487, 457, 488, 458, 489, 459, 490, 460, 491, 461, 492, 462, 493,
  463, 494, 464, 495, 465, 496, 466, 497, 467, 498, 468, 499, 469, 500, 470,
  501, 471, 502, 472, 503, 473, 504, 474, 505, 475, 506, 476, 507, 477, 508,
  478, 509, 479, 510, 0,   0
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  16,  32,  32,  48,  48,  64,  64,  80,  80,  96,
  96,  112, 112, 128, 128, 144, 144, 160, 160, 176, 176, 192, 192, 208, 208,
  224, 224, 0,   0,   1,   16,  17,  32,  33,  48,  49,  64,  65,  80,  81,
  96,  97,  112, 113, 128, 129, 144, 145, 160, 161, 176, 177, 192, 193, 208,
  209, 224, 225, 240, 1,   1,   2,   17,  18,  33,  34,  49,  50,  65,  66,
  81,  82,  97,  98,  113, 114, 129, 130, 145, 146, 161, 162, 177, 178, 193,
  194, 209, 210, 225, 226, 241, 2,   2,   3,   18,  19,  34,  35,  50,  51,
  66,  67,  82,  83,  98,  99,  114, 115, 130, 131, 146, 147, 162, 163, 178,
  179, 194, 195, 210, 211, 226, 227, 242, 3,   3,   4,   19,  20,  35,  36,
  51,  52,  67,  68,  83,  84,  99,  100, 115, 116, 131, 132, 147, 148, 163,
  164, 179, 180, 195, 196, 211, 212, 227, 228, 243, 4,   4,   5,   20,  21,
  36,  37,  52,  53,  68,  69,  84,  85,  100, 101, 116, 117, 132, 133, 148,
  149, 164, 165, 180, 181, 196, 197, 212, 213, 228, 229, 244, 5,   5,   6,
  21,  22,  37,  38,  53,  54,  69,  70,  85,  86,  101, 102, 117, 118, 133,
  134, 149, 150, 165, 166, 181, 182, 197, 198, 213, 214, 229, 230, 245, 6,
  6,   7,   22,  23,  38,  39,  54,  55,  70,  71,  86,  87,  102, 103, 118,
  119, 134, 135, 150, 151, 166, 167, 182, 183, 198, 199, 214, 215, 230, 231,
  246, 7,   7,   8,   23,  24,  39,  40,  55,  56,  71,  72,  87,  88,  103,
  104, 119, 120, 135, 136, 151, 152, 167, 168, 183, 184, 199, 200, 215, 216,
  231, 232, 247, 8,   8,   9,   24,  25,  40,  41,  56,  57,  72,  73,  88,
  89,  104, 105, 120, 121, 136, 137, 152, 153, 168, 169, 184, 185, 200, 201,
  216, 217, 232, 233, 248, 9,   9,   10,  25,  26,  41,  42,  57,  58,  73,
  74,  89,  90,  105, 106, 121, 122, 137, 138, 153, 154, 169, 170, 185, 186,
  201, 202, 217, 218, 233, 234, 249, 10,  10,  11,  26,  27,  42,  43,  58,
  59,  74,  75,  90,  91,  106, 107, 122, 123, 138, 139, 154, 155, 170, 171,
  186, 187, 202, 203, 218, 219, 234, 235, 250, 11,  11,  12,  27,  28,  43,
  44,  59,  60,  75,  76,  91,  92,  107, 108, 123, 124, 139, 140, 155, 156,
  171, 172, 187, 188, 203, 204, 219, 220, 235, 236, 251, 12,  12,  13,  28,
  29,  44,  45,  60,  61,  76,  77,  92,  93,  108, 109, 124, 125, 140, 141,
  156, 157, 172, 173, 188, 189, 204, 205, 220, 221, 236, 237, 252, 13,  13,
  14,  29,  30,  45,  46,  61,  62,  77,  78,  93,  94,  109, 110, 125, 126,
  141, 142, 157, 158, 173, 174, 189, 190, 205, 206, 221, 222, 237, 238, 253,
  14,  14,  15,  30,  31,  46,  47,  62,  63,  78,  79,  94,  95,  110, 111,
  126, 127, 142, 143, 158, 159, 174, 175, 190, 191, 206, 207, 222, 223, 238,
  239, 254, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,
  6,   7,   7,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,  13,  13,
  14,  14,  0,   0,   1,   16,  2,   17,  3,   18,  4,   19,  5,   20,  6,
  21,  7,   22,  8,   23,  9,   24,  10,  25,  11,  26,  12,  27,  13,  28,
  14,  29,  15,  30,  16,  16,  17,  32,  18,  33,  19,  34,  20,  35,  21,
  36,  22,  37,  23,  38,  24,  39,  25,  40,  26,  41,  27,  42,  28,  43,
  29,  44,  30,  45,  31,  46,  32,  32,  33,  48,  34,  49,  35,  50,  36,
  51,  37,  52,  38,  53,  39,  54,  40,  55,  41,  56,  42,  57,  43,  58,
  44,  59,  45,  60,  46,  61,  47,  62,  48,  48,  49,  64,  50,  65,  51,
  66,  52,  67,  53,  68,  54,  69,  55,  70,  56,  71,  57,  72,  58,  73,
  59,  74,  60,  75,  61,  76,  62,  77,  63,  78,  64,  64,  65,  80,  66,
  81,  67,  82,  68,  83,  69,  84,  70,  85,  71,  86,  72,  87,  73,  88,
  74,  89,  75,  90,  76,  91,  77,  92,  78,  93,  79,  94,  80,  80,  81,
  96,  82,  97,  83,  98,  84,  99,  85,  100, 86,  101, 87,  102, 88,  103,
  89,  104, 90,  105, 91,  106, 92,  107, 93,  108, 94,  109, 95,  110, 96,
  96,  97,  112, 98,  113, 99,  114, 100, 115, 101, 116, 102, 117, 103, 118,
  104, 119, 105, 120, 106, 121, 107, 122, 108, 123, 109, 124, 110, 125, 111,
  126, 112, 112, 113, 128, 114, 129, 115, 130, 116, 131, 117, 132, 118, 133,
  119, 134, 120, 135, 121, 136, 122, 137, 123, 138, 124, 139, 125, 140, 126,
  141, 127, 142, 128, 128, 129, 144, 130, 145, 131, 146, 132, 147, 133, 148,
  134, 149, 135, 150, 136, 151, 137, 152, 138, 153, 139, 154, 140, 155, 141,
  156, 142, 157, 143, 158, 144, 144, 145, 160, 146, 161, 147, 162, 148, 163,
  149, 164, 150, 165, 151, 166, 152, 167, 153, 168, 154, 169, 155, 170, 156,
  171, 157, 172, 158, 173, 159, 174, 160, 160, 161, 176, 162, 177, 163, 178,
  164, 179, 165, 180, 166, 181, 167, 182, 168, 183, 169, 184, 170, 185, 171,
  186, 172, 187, 173, 188, 174, 189, 175, 190, 176, 176, 177, 192, 178, 193,
  179, 194, 180, 195, 181, 196, 182, 197, 183, 198, 184, 199, 185, 200, 186,
  201, 187, 202, 188, 203, 189, 204, 190, 205, 191, 206, 192, 192, 193, 208,
  194, 209, 195, 210, 196, 211, 197, 212, 198, 213, 199, 214, 200, 215, 201,
  216, 202, 217, 203, 218, 204, 219, 205, 220, 206, 221, 207, 222, 208, 208,
  209, 224, 210, 225, 211, 226, 212, 227, 213, 228, 214, 229, 215, 230, 216,
  231, 217, 232, 218, 233, 219, 234, 220, 235, 221, 236, 222, 237, 223, 238,
  224, 224, 225, 240, 226, 241, 227, 242, 228, 243, 229, 244, 230, 245, 231,
  246, 232, 247, 233, 248, 234, 249, 235, 250, 236, 251, 237, 252, 238, 253,
  239, 254, 0,   0,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                col_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  16,  32,  32,  16,  0,   48,  48,  1,   16,  64,
  64,  17,  32,  80,  80,  33,  48,  17,  1,   49,  64,  96,  96,  2,   17,
  65,  80,  18,  33,  112, 112, 34,  49,  81,  96,  18,  2,   50,  65,  128,
  128, 3,   18,  97,  112, 19,  34,  66,  81,  144, 144, 82,  97,  35,  50,
  113, 128, 19,  3,   51,  66,  160, 160, 4,   19,  98,  113, 129, 144, 67,
  82,  20,  35,  83,  98,  114, 129, 36,  51,  176, 176, 20,  4,   145, 160,
  52,  67,  99,  114, 5,   20,  130, 145, 68,  83,  192, 192, 161, 176, 21,
  36,  115, 130, 84,  99,  37,  52,  146, 161, 208, 208, 53,  68,  21,  5,
  100, 115, 177, 192, 131, 146, 69,  84,  6,   21,  224, 224, 116, 131, 22,
  37,  162, 177, 85,  100, 147, 162, 38,  53,  193, 208, 101, 116, 54,  69,
  22,  6,   132, 147, 178, 193, 70,  85,  163, 178, 209, 224, 7,   22,  117,
  132, 23,  38,  148, 163, 23,  7,   86,  101, 194, 209, 225, 240, 39,  54,
  179, 194, 102, 117, 133, 148, 55,  70,  164, 179, 8,   23,  71,  86,  210,
  225, 118, 133, 149, 164, 195, 210, 24,  39,  87,  102, 40,  55,  56,  71,
  134, 149, 180, 195, 226, 241, 103, 118, 24,  8,   165, 180, 211, 226, 72,
  87,  150, 165, 9,   24,  119, 134, 25,  40,  88,  103, 196, 211, 41,  56,
  135, 150, 181, 196, 104, 119, 57,  72,  227, 242, 166, 181, 120, 135, 151,
  166, 197, 212, 73,  88,  25,  9,   212, 227, 89,  104, 136, 151, 182, 197,
  10,  25,  26,  41,  105, 120, 167, 182, 228, 243, 152, 167, 42,  57,  121,
  136, 213, 228, 58,  73,  198, 213, 74,  89,  137, 152, 183, 198, 168, 183,
  26,  10,  90,  105, 229, 244, 11,  26,  106, 121, 214, 229, 153, 168, 27,
  42,  199, 214, 43,  58,  184, 199, 122, 137, 169, 184, 230, 245, 59,  74,
  27,  11,  75,  90,  138, 153, 200, 215, 215, 230, 91,  106, 12,  27,  28,
  43,  185, 200, 107, 122, 154, 169, 44,  59,  231, 246, 216, 231, 60,  75,
  123, 138, 28,  12,  76,  91,  201, 216, 170, 185, 232, 247, 139, 154, 92,
  107, 13,  28,  108, 123, 29,  44,  186, 201, 217, 232, 155, 170, 45,  60,
  29,  13,  61,  76,  124, 139, 14,  14,  233, 248, 77,  92,  14,  29,  171,
  186, 140, 155, 202, 217, 30,  45,  93,  108, 109, 124, 46,  61,  156, 171,
  62,  77,  187, 202, 15,  30,  125, 140, 218, 233, 78,  93,  31,  46,  172,
  187, 47,  62,  141, 156, 94,  109, 234, 249, 203, 218, 63,  78,  110, 125,
  188, 203, 157, 172, 126, 141, 79,  94,  173, 188, 95,  110, 219, 234, 142,
  157, 204, 219, 235, 250, 111, 126, 158, 173, 127, 142, 189, 204, 220, 235,
  143, 158, 174, 189, 205, 220, 236, 251, 159, 174, 190, 205, 221, 236, 175,
  190, 237, 252, 206, 221, 222, 237, 191, 206, 238, 253, 207, 222, 223, 238,
  239, 254, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                row_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   1,   1,   0,   1,   2,   2,   1,   16,  3,   3,   2,
  17,  16,  17,  4,   4,   17,  32,  3,   18,  5,   5,   18,  33,  32,  33,
  4,   19,  33,  48,  6,   6,   19,  34,  5,   20,  34,  49,  48,  49,  7,
  7,   20,  35,  49,  64,  6,   21,  35,  50,  21,  36,  64,  65,  8,   8,
  50,  65,  36,  51,  7,   22,  22,  37,  65,  80,  51,  66,  9,   9,   37,
  52,  8,   23,  66,  81,  52,  67,  80,  81,  23,  38,  10,  10,  38,  53,
  67,  82,  81,  96,  53,  68,  9,   24,  82,  97,  68,  83,  24,  39,  96,
  97,  39,  54,  11,  11,  54,  69,  83,  98,  97,  112, 69,  84,  10,  25,
  25,  40,  40,  55,  98,  113, 84,  99,  12,  12,  55,  70,  112, 113, 70,
  85,  11,  26,  99,  114, 85,  100, 113, 128, 26,  41,  41,  56,  56,  71,
  100, 115, 13,  13,  71,  86,  114, 129, 86,  101, 128, 129, 57,  72,  115,
  130, 101, 116, 12,  27,  42,  57,  14,  14,  72,  87,  27,  42,  129, 144,
  87,  102, 116, 131, 130, 145, 102, 117, 58,  73,  144, 145, 73,  88,  117,
  132, 88,  103, 13,  28,  43,  58,  131, 146, 103, 118, 28,  43,  145, 160,
  132, 147, 74,  89,  89,  104, 118, 133, 146, 161, 104, 119, 160, 161, 59,
  74,  119, 134, 133, 148, 14,  29,  44,  59,  147, 162, 161, 176, 29,  44,
  105, 120, 75,  90,  90,  105, 148, 163, 162, 177, 134, 149, 176, 177, 120,
  135, 149, 164, 163, 178, 15,  30,  135, 150, 177, 192, 60,  75,  106, 121,
  45,  60,  121, 136, 178, 193, 91,  106, 136, 151, 164, 179, 192, 193, 30,
  45,  150, 165, 151, 166, 179, 194, 76,  91,  165, 180, 122, 137, 193, 208,
  107, 122, 137, 152, 208, 209, 180, 195, 61,  76,  152, 167, 194, 209, 166,
  181, 224, 224, 92,  107, 181, 196, 46,  61,  138, 153, 209, 224, 167, 182,
  153, 168, 195, 210, 31,  46,  123, 138, 77,  92,  168, 183, 210, 225, 196,
  211, 225, 240, 182, 197, 154, 169, 108, 123, 139, 154, 183, 198, 62,  77,
  197, 212, 169, 184, 93,  108, 211, 226, 184, 199, 47,  62,  212, 227, 226,
  241, 124, 139, 198, 213, 155, 170, 170, 185, 140, 155, 213, 228, 227, 242,
  109, 124, 78,  93,  185, 200, 228, 243, 199, 214, 200, 215, 214, 229, 125,
  140, 171, 186, 186, 201, 63,  78,  156, 171, 94,  109, 141, 156, 229, 244,
  201, 216, 215, 230, 79,  94,  230, 245, 216, 231, 110, 125, 187, 202, 231,
  246, 217, 232, 157, 172, 202, 217, 126, 141, 95,  110, 142, 157, 172, 187,
  232, 247, 111, 126, 218, 233, 203, 218, 233, 248, 173, 188, 188, 203, 127,
  142, 158, 173, 143, 158, 234, 249, 219, 234, 189, 204, 204, 219, 159, 174,
  174, 189, 235, 250, 205, 220, 175, 190, 190, 205, 220, 235, 191, 206, 221,
  236, 236, 251, 206, 221, 237, 252, 207, 222, 222, 237, 223, 238, 238, 253,
  239, 254, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_16x16_neighbors[257 * MAX_NEIGHBORS]) = {
  0,   0,   0,   0,   16,  0,   16,  16,  1,   16,  17,  1,   32,  32,  17,
  32,  2,   17,  18,  2,   48,  48,  18,  33,  33,  48,  3,   18,  49,  64,
  64,  65,  34,  49,  19,  3,   19,  34,  50,  65,  4,   19,  65,  80,  80,
  81,  35,  50,  20,  4,   20,  35,  66,  81,  81,  96,  51,  66,  96,  97,
  5,   20,  36,  51,  82,  97,  21,  36,  67,  82,  97,  112, 21,  5,   52,
  67,  112, 113, 37,  52,  6,   21,  83,  98,  98,  113, 68,  83,  22,  6,
  113, 128, 22,  37,  53,  68,  84,  99,  99,  114, 128, 129, 114, 129, 69,
  84,  38,  53,  7,   22,  23,  7,   129, 144, 23,  38,  54,  69,  100, 115,
  85,  100, 115, 130, 144, 145, 130, 145, 39,  54,  70,  85,  8,   23,  55,
  70,  116, 131, 101, 116, 145, 160, 24,  39,  24,  8,   86,  101, 131, 146,
  160, 161, 146, 161, 71,  86,  40,  55,  9,   24,  117, 132, 102, 117, 161,
  176, 132, 147, 56,  71,  87,  102, 25,  40,  147, 162, 25,  9,   176, 177,
  162, 177, 72,  87,  41,  56,  118, 133, 133, 148, 103, 118, 10,  25,  148,
  163, 57,  72,  88,  103, 177, 192, 26,  41,  163, 178, 192, 193, 26,  10,
  119, 134, 73,  88,  149, 164, 104, 119, 134, 149, 42,  57,  178, 193, 164,
  179, 11,  26,  58,  73,  193, 208, 89,  104, 135, 150, 120, 135, 27,  42,
  74,  89,  208, 209, 150, 165, 179, 194, 165, 180, 105, 120, 194, 209, 43,
  58,  27,  11,  136, 151, 90,  105, 151, 166, 180, 195, 59,  74,  121, 136,
  209, 224, 195, 210, 224, 225, 166, 181, 106, 121, 75,  90,  12,  27,  181,
  196, 28,  12,  210, 225, 152, 167, 167, 182, 137, 152, 28,  43,  196, 211,
  122, 137, 91,  106, 225, 240, 44,  59,  13,  28,  107, 122, 182, 197, 168,
  183, 211, 226, 153, 168, 226, 241, 60,  75,  197, 212, 138, 153, 29,  44,
  76,  91,  29,  13,  183, 198, 123, 138, 45,  60,  212, 227, 198, 213, 154,
  169, 169, 184, 227, 242, 92,  107, 61,  76,  139, 154, 14,  29,  30,  14,
  184, 199, 213, 228, 108, 123, 199, 214, 228, 243, 77,  92,  30,  45,  170,
  185, 155, 170, 185, 200, 93,  108, 124, 139, 214, 229, 46,  61,  200, 215,
  229, 244, 15,  30,  109, 124, 62,  77,  140, 155, 215, 230, 31,  46,  171,
  186, 186, 201, 201, 216, 78,  93,  230, 245, 125, 140, 47,  62,  216, 231,
  156, 171, 94,  109, 231, 246, 141, 156, 63,  78,  202, 217, 187, 202, 110,
  125, 217, 232, 172, 187, 232, 247, 79,  94,  157, 172, 126, 141, 203, 218,
  95,  110, 233, 248, 218, 233, 142, 157, 111, 126, 173, 188, 188, 203, 234,
  249, 219, 234, 127, 142, 158, 173, 204, 219, 189, 204, 143, 158, 235, 250,
  174, 189, 205, 220, 159, 174, 220, 235, 221, 236, 175, 190, 190, 205, 236,
  251, 206, 221, 237, 252, 191, 206, 222, 237, 207, 222, 238, 253, 223, 238,
  239, 254, 0,   0,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t,
                mcol_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    32,  32,   64,  64,   96,  96,   128, 128,  160, 160,
  192, 192,  224, 224,  256, 256,  288, 288,  320, 320,  352, 352,  384, 384,
  416, 416,  448, 448,  480, 480,  512, 512,  544, 544,  576, 576,  608, 608,
  640, 640,  672, 672,  704, 704,  736, 736,  768, 768,  800, 800,  832, 832,
  864, 864,  896, 896,  928, 928,  960, 960,  0,   0,    1,   32,   33,  64,
  65,  96,   97,  128,  129, 160,  161, 192,  193, 224,  225, 256,  257, 288,
  289, 320,  321, 352,  353, 384,  385, 416,  417, 448,  449, 480,  481, 512,
  513, 544,  545, 576,  577, 608,  609, 640,  641, 672,  673, 704,  705, 736,
  737, 768,  769, 800,  801, 832,  833, 864,  865, 896,  897, 928,  929, 960,
  961, 992,  1,   1,    2,   33,   34,  65,   66,  97,   98,  129,  130, 161,
  162, 193,  194, 225,  226, 257,  258, 289,  290, 321,  322, 353,  354, 385,
  386, 417,  418, 449,  450, 481,  482, 513,  514, 545,  546, 577,  578, 609,
  610, 641,  642, 673,  674, 705,  706, 737,  738, 769,  770, 801,  802, 833,
  834, 865,  866, 897,  898, 929,  930, 961,  962, 993,  2,   2,    3,   34,
  35,  66,   67,  98,   99,  130,  131, 162,  163, 194,  195, 226,  227, 258,
  259, 290,  291, 322,  323, 354,  355, 386,  387, 418,  419, 450,  451, 482,
  483, 514,  515, 546,  547, 578,  579, 610,  611, 642,  643, 674,  675, 706,
  707, 738,  739, 770,  771, 802,  803, 834,  835, 866,  867, 898,  899, 930,
  931, 962,  963, 994,  3,   3,    4,   35,   36,  67,   68,  99,   100, 131,
  132, 163,  164, 195,  196, 227,  228, 259,  260, 291,  292, 323,  324, 355,
  356, 387,  388, 419,  420, 451,  452, 483,  484, 515,  516, 547,  548, 579,
  580, 611,  612, 643,  644, 675,  676, 707,  708, 739,  740, 771,  772, 803,
  804, 835,  836, 867,  868, 899,  900, 931,  932, 963,  964, 995,  4,   4,
  5,   36,   37,  68,   69,  100,  101, 132,  133, 164,  165, 196,  197, 228,
  229, 260,  261, 292,  293, 324,  325, 356,  357, 388,  389, 420,  421, 452,
  453, 484,  485, 516,  517, 548,  549, 580,  581, 612,  613, 644,  645, 676,
  677, 708,  709, 740,  741, 772,  773, 804,  805, 836,  837, 868,  869, 900,
  901, 932,  933, 964,  965, 996,  5,   5,    6,   37,   38,  69,   70,  101,
  102, 133,  134, 165,  166, 197,  198, 229,  230, 261,  262, 293,  294, 325,
  326, 357,  358, 389,  390, 421,  422, 453,  454, 485,  486, 517,  518, 549,
  550, 581,  582, 613,  614, 645,  646, 677,  678, 709,  710, 741,  742, 773,
  774, 805,  806, 837,  838, 869,  870, 901,  902, 933,  934, 965,  966, 997,
  6,   6,    7,   38,   39,  70,   71,  102,  103, 134,  135, 166,  167, 198,
  199, 230,  231, 262,  263, 294,  295, 326,  327, 358,  359, 390,  391, 422,
  423, 454,  455, 486,  487, 518,  519, 550,  551, 582,  583, 614,  615, 646,
  647, 678,  679, 710,  711, 742,  743, 774,  775, 806,  807, 838,  839, 870,
  871, 902,  903, 934,  935, 966,  967, 998,  7,   7,    8,   39,   40,  71,
  72,  103,  104, 135,  136, 167,  168, 199,  200, 231,  232, 263,  264, 295,
  296, 327,  328, 359,  360, 391,  392, 423,  424, 455,  456, 487,  488, 519,
  520, 551,  552, 583,  584, 615,  616, 647,  648, 679,  680, 711,  712, 743,
  744, 775,  776, 807,  808, 839,  840, 871,  872, 903,  904, 935,  936, 967,
  968, 999,  8,   8,    9,   40,   41,  72,   73,  104,  105, 136,  137, 168,
  169, 200,  201, 232,  233, 264,  265, 296,  297, 328,  329, 360,  361, 392,
  393, 424,  425, 456,  457, 488,  489, 520,  521, 552,  553, 584,  585, 616,
  617, 648,  649, 680,  681, 712,  713, 744,  745, 776,  777, 808,  809, 840,
  841, 872,  873, 904,  905, 936,  937, 968,  969, 1000, 9,   9,    10,  41,
  42,  73,   74,  105,  106, 137,  138, 169,  170, 201,  202, 233,  234, 265,
  266, 297,  298, 329,  330, 361,  362, 393,  394, 425,  426, 457,  458, 489,
  490, 521,  522, 553,  554, 585,  586, 617,  618, 649,  650, 681,  682, 713,
  714, 745,  746, 777,  778, 809,  810, 841,  842, 873,  874, 905,  906, 937,
  938, 969,  970, 1001, 10,  10,   11,  42,   43,  74,   75,  106,  107, 138,
  139, 170,  171, 202,  203, 234,  235, 266,  267, 298,  299, 330,  331, 362,
  363, 394,  395, 426,  427, 458,  459, 490,  491, 522,  523, 554,  555, 586,
  587, 618,  619, 650,  651, 682,  683, 714,  715, 746,  747, 778,  779, 810,
  811, 842,  843, 874,  875, 906,  907, 938,  939, 970,  971, 1002, 11,  11,
  12,  43,   44,  75,   76,  107,  108, 139,  140, 171,  172, 203,  204, 235,
  236, 267,  268, 299,  300, 331,  332, 363,  364, 395,  396, 427,  428, 459,
  460, 491,  492, 523,  524, 555,  556, 587,  588, 619,  620, 651,  652, 683,
  684, 715,  716, 747,  748, 779,  780, 811,  812, 843,  844, 875,  876, 907,
  908, 939,  940, 971,  972, 1003, 12,  12,   13,  44,   45,  76,   77,  108,
  109, 140,  141, 172,  173, 204,  205, 236,  237, 268,  269, 300,  301, 332,
  333, 364,  365, 396,  397, 428,  429, 460,  461, 492,  493, 524,  525, 556,
  557, 588,  589, 620,  621, 652,  653, 684,  685, 716,  717, 748,  749, 780,
  781, 812,  813, 844,  845, 876,  877, 908,  909, 940,  941, 972,  973, 1004,
  13,  13,   14,  45,   46,  77,   78,  109,  110, 141,  142, 173,  174, 205,
  206, 237,  238, 269,  270, 301,  302, 333,  334, 365,  366, 397,  398, 429,
  430, 461,  462, 493,  494, 525,  526, 557,  558, 589,  590, 621,  622, 653,
  654, 685,  686, 717,  718, 749,  750, 781,  782, 813,  814, 845,  846, 877,
  878, 909,  910, 941,  942, 973,  974, 1005, 14,  14,   15,  46,   47,  78,
  79,  110,  111, 142,  143, 174,  175, 206,  207, 238,  239, 270,  271, 302,
  303, 334,  335, 366,  367, 398,  399, 430,  431, 462,  463, 494,  495, 526,
  527, 558,  559, 590,  591, 622,  623, 654,  655, 686,  687, 718,  719, 750,
  751, 782,  783, 814,  815, 846,  847, 878,  879, 910,  911, 942,  943, 974,
  975, 1006, 15,  15,   16,  47,   48,  79,   80,  111,  112, 143,  144, 175,
  176, 207,  208, 239,  240, 271,  272, 303,  304, 335,  336, 367,  368, 399,
  400, 431,  432, 463,  464, 495,  496, 527,  528, 559,  560, 591,  592, 623,
  624, 655,  656, 687,  688, 719,  720, 751,  752, 783,  784, 815,  816, 847,
  848, 879,  880, 911,  912, 943,  944, 975,  976, 1007, 16,  16,   17,  48,
  49,  80,   81,  112,  113, 144,  145, 176,  177, 208,  209, 240,  241, 272,
  273, 304,  305, 336,  337, 368,  369, 400,  401, 432,  433, 464,  465, 496,
  497, 528,  529, 560,  561, 592,  593, 624,  625, 656,  657, 688,  689, 720,
  721, 752,  753, 784,  785, 816,  817, 848,  849, 880,  881, 912,  913, 944,
  945, 976,  977, 1008, 17,  17,   18,  49,   50,  81,   82,  113,  114, 145,
  146, 177,  178, 209,  210, 241,  242, 273,  274, 305,  306, 337,  338, 369,
  370, 401,  402, 433,  434, 465,  466, 497,  498, 529,  530, 561,  562, 593,
  594, 625,  626, 657,  658, 689,  690, 721,  722, 753,  754, 785,  786, 817,
  818, 849,  850, 881,  882, 913,  914, 945,  946, 977,  978, 1009, 18,  18,
  19,  50,   51,  82,   83,  114,  115, 146,  147, 178,  179, 210,  211, 242,
  243, 274,  275, 306,  307, 338,  339, 370,  371, 402,  403, 434,  435, 466,
  467, 498,  499, 530,  531, 562,  563, 594,  595, 626,  627, 658,  659, 690,
  691, 722,  723, 754,  755, 786,  787, 818,  819, 850,  851, 882,  883, 914,
  915, 946,  947, 978,  979, 1010, 19,  19,   20,  51,   52,  83,   84,  115,
  116, 147,  148, 179,  180, 211,  212, 243,  244, 275,  276, 307,  308, 339,
  340, 371,  372, 403,  404, 435,  436, 467,  468, 499,  500, 531,  532, 563,
  564, 595,  596, 627,  628, 659,  660, 691,  692, 723,  724, 755,  756, 787,
  788, 819,  820, 851,  852, 883,  884, 915,  916, 947,  948, 979,  980, 1011,
  20,  20,   21,  52,   53,  84,   85,  116,  117, 148,  149, 180,  181, 212,
  213, 244,  245, 276,  277, 308,  309, 340,  341, 372,  373, 404,  405, 436,
  437, 468,  469, 500,  501, 532,  533, 564,  565, 596,  597, 628,  629, 660,
  661, 692,  693, 724,  725, 756,  757, 788,  789, 820,  821, 852,  853, 884,
  885, 916,  917, 948,  949, 980,  981, 1012, 21,  21,   22,  53,   54,  85,
  86,  117,  118, 149,  150, 181,  182, 213,  214, 245,  246, 277,  278, 309,
  310, 341,  342, 373,  374, 405,  406, 437,  438, 469,  470, 501,  502, 533,
  534, 565,  566, 597,  598, 629,  630, 661,  662, 693,  694, 725,  726, 757,
  758, 789,  790, 821,  822, 853,  854, 885,  886, 917,  918, 949,  950, 981,
  982, 1013, 22,  22,   23,  54,   55,  86,   87,  118,  119, 150,  151, 182,
  183, 214,  215, 246,  247, 278,  279, 310,  311, 342,  343, 374,  375, 406,
  407, 438,  439, 470,  471, 502,  503, 534,  535, 566,  567, 598,  599, 630,
  631, 662,  663, 694,  695, 726,  727, 758,  759, 790,  791, 822,  823, 854,
  855, 886,  887, 918,  919, 950,  951, 982,  983, 1014, 23,  23,   24,  55,
  56,  87,   88,  119,  120, 151,  152, 183,  184, 215,  216, 247,  248, 279,
  280, 311,  312, 343,  344, 375,  376, 407,  408, 439,  440, 471,  472, 503,
  504, 535,  536, 567,  568, 599,  600, 631,  632, 663,  664, 695,  696, 727,
  728, 759,  760, 791,  792, 823,  824, 855,  856, 887,  888, 919,  920, 951,
  952, 983,  984, 1015, 24,  24,   25,  56,   57,  88,   89,  120,  121, 152,
  153, 184,  185, 216,  217, 248,  249, 280,  281, 312,  313, 344,  345, 376,
  377, 408,  409, 440,  441, 472,  473, 504,  505, 536,  537, 568,  569, 600,
  601, 632,  633, 664,  665, 696,  697, 728,  729, 760,  761, 792,  793, 824,
  825, 856,  857, 888,  889, 920,  921, 952,  953, 984,  985, 1016, 25,  25,
  26,  57,   58,  89,   90,  121,  122, 153,  154, 185,  186, 217,  218, 249,
  250, 281,  282, 313,  314, 345,  346, 377,  378, 409,  410, 441,  442, 473,
  474, 505,  506, 537,  538, 569,  570, 601,  602, 633,  634, 665,  666, 697,
  698, 729,  730, 761,  762, 793,  794, 825,  826, 857,  858, 889,  890, 921,
  922, 953,  954, 985,  986, 1017, 26,  26,   27,  58,   59,  90,   91,  122,
  123, 154,  155, 186,  187, 218,  219, 250,  251, 282,  283, 314,  315, 346,
  347, 378,  379, 410,  411, 442,  443, 474,  475, 506,  507, 538,  539, 570,
  571, 602,  603, 634,  635, 666,  667, 698,  699, 730,  731, 762,  763, 794,
  795, 826,  827, 858,  859, 890,  891, 922,  923, 954,  955, 986,  987, 1018,
  27,  27,   28,  59,   60,  91,   92,  123,  124, 155,  156, 187,  188, 219,
  220, 251,  252, 283,  284, 315,  316, 347,  348, 379,  380, 411,  412, 443,
  444, 475,  476, 507,  508, 539,  540, 571,  572, 603,  604, 635,  636, 667,
  668, 699,  700, 731,  732, 763,  764, 795,  796, 827,  828, 859,  860, 891,
  892, 923,  924, 955,  956, 987,  988, 1019, 28,  28,   29,  60,   61,  92,
  93,  124,  125, 156,  157, 188,  189, 220,  221, 252,  253, 284,  285, 316,
  317, 348,  349, 380,  381, 412,  413, 444,  445, 476,  477, 508,  509, 540,
  541, 572,  573, 604,  605, 636,  637, 668,  669, 700,  701, 732,  733, 764,
  765, 796,  797, 828,  829, 860,  861, 892,  893, 924,  925, 956,  957, 988,
  989, 1020, 29,  29,   30,  61,   62,  93,   94,  125,  126, 157,  158, 189,
  190, 221,  222, 253,  254, 285,  286, 317,  318, 349,  350, 381,  382, 413,
  414, 445,  446, 477,  478, 509,  510, 541,  542, 573,  574, 605,  606, 637,
  638, 669,  670, 701,  702, 733,  734, 765,  766, 797,  798, 829,  830, 861,
  862, 893,  894, 925,  926, 957,  958, 989,  990, 1021, 30,  30,   31,  62,
  63,  94,   95,  126,  127, 158,  159, 190,  191, 222,  223, 254,  255, 286,
  287, 318,  319, 350,  351, 382,  383, 414,  415, 446,  447, 478,  479, 510,
  511, 542,  543, 574,  575, 606,  607, 638,  639, 670,  671, 702,  703, 734,
  735, 766,  767, 798,  799, 830,  831, 862,  863, 894,  895, 926,  927, 958,
  959, 990,  991, 1022, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                mrow_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    1,   1,    2,   2,    3,   3,    4,   4,    5,   5,
  6,   6,    7,   7,    8,   8,    9,   9,    10,  10,   11,  11,   12,  12,
  13,  13,   14,  14,   15,  15,   16,  16,   17,  17,   18,  18,   19,  19,
  20,  20,   21,  21,   22,  22,   23,  23,   24,  24,   25,  25,   26,  26,
  27,  27,   28,  28,   29,  29,   30,  30,   0,   0,    1,   32,   2,   33,
  3,   34,   4,   35,   5,   36,   6,   37,   7,   38,   8,   39,   9,   40,
  10,  41,   11,  42,   12,  43,   13,  44,   14,  45,   15,  46,   16,  47,
  17,  48,   18,  49,   19,  50,   20,  51,   21,  52,   22,  53,   23,  54,
  24,  55,   25,  56,   26,  57,   27,  58,   28,  59,   29,  60,   30,  61,
  31,  62,   32,  32,   33,  64,   34,  65,   35,  66,   36,  67,   37,  68,
  38,  69,   39,  70,   40,  71,   41,  72,   42,  73,   43,  74,   44,  75,
  45,  76,   46,  77,   47,  78,   48,  79,   49,  80,   50,  81,   51,  82,
  52,  83,   53,  84,   54,  85,   55,  86,   56,  87,   57,  88,   58,  89,
  59,  90,   60,  91,   61,  92,   62,  93,   63,  94,   64,  64,   65,  96,
  66,  97,   67,  98,   68,  99,   69,  100,  70,  101,  71,  102,  72,  103,
  73,  104,  74,  105,  75,  106,  76,  107,  77,  108,  78,  109,  79,  110,
  80,  111,  81,  112,  82,  113,  83,  114,  84,  115,  85,  116,  86,  117,
  87,  118,  88,  119,  89,  120,  90,  121,  91,  122,  92,  123,  93,  124,
  94,  125,  95,  126,  96,  96,   97,  128,  98,  129,  99,  130,  100, 131,
  101, 132,  102, 133,  103, 134,  104, 135,  105, 136,  106, 137,  107, 138,
  108, 139,  109, 140,  110, 141,  111, 142,  112, 143,  113, 144,  114, 145,
  115, 146,  116, 147,  117, 148,  118, 149,  119, 150,  120, 151,  121, 152,
  122, 153,  123, 154,  124, 155,  125, 156,  126, 157,  127, 158,  128, 128,
  129, 160,  130, 161,  131, 162,  132, 163,  133, 164,  134, 165,  135, 166,
  136, 167,  137, 168,  138, 169,  139, 170,  140, 171,  141, 172,  142, 173,
  143, 174,  144, 175,  145, 176,  146, 177,  147, 178,  148, 179,  149, 180,
  150, 181,  151, 182,  152, 183,  153, 184,  154, 185,  155, 186,  156, 187,
  157, 188,  158, 189,  159, 190,  160, 160,  161, 192,  162, 193,  163, 194,
  164, 195,  165, 196,  166, 197,  167, 198,  168, 199,  169, 200,  170, 201,
  171, 202,  172, 203,  173, 204,  174, 205,  175, 206,  176, 207,  177, 208,
  178, 209,  179, 210,  180, 211,  181, 212,  182, 213,  183, 214,  184, 215,
  185, 216,  186, 217,  187, 218,  188, 219,  189, 220,  190, 221,  191, 222,
  192, 192,  193, 224,  194, 225,  195, 226,  196, 227,  197, 228,  198, 229,
  199, 230,  200, 231,  201, 232,  202, 233,  203, 234,  204, 235,  205, 236,
  206, 237,  207, 238,  208, 239,  209, 240,  210, 241,  211, 242,  212, 243,
  213, 244,  214, 245,  215, 246,  216, 247,  217, 248,  218, 249,  219, 250,
  220, 251,  221, 252,  222, 253,  223, 254,  224, 224,  225, 256,  226, 257,
  227, 258,  228, 259,  229, 260,  230, 261,  231, 262,  232, 263,  233, 264,
  234, 265,  235, 266,  236, 267,  237, 268,  238, 269,  239, 270,  240, 271,
  241, 272,  242, 273,  243, 274,  244, 275,  245, 276,  246, 277,  247, 278,
  248, 279,  249, 280,  250, 281,  251, 282,  252, 283,  253, 284,  254, 285,
  255, 286,  256, 256,  257, 288,  258, 289,  259, 290,  260, 291,  261, 292,
  262, 293,  263, 294,  264, 295,  265, 296,  266, 297,  267, 298,  268, 299,
  269, 300,  270, 301,  271, 302,  272, 303,  273, 304,  274, 305,  275, 306,
  276, 307,  277, 308,  278, 309,  279, 310,  280, 311,  281, 312,  282, 313,
  283, 314,  284, 315,  285, 316,  286, 317,  287, 318,  288, 288,  289, 320,
  290, 321,  291, 322,  292, 323,  293, 324,  294, 325,  295, 326,  296, 327,
  297, 328,  298, 329,  299, 330,  300, 331,  301, 332,  302, 333,  303, 334,
  304, 335,  305, 336,  306, 337,  307, 338,  308, 339,  309, 340,  310, 341,
  311, 342,  312, 343,  313, 344,  314, 345,  315, 346,  316, 347,  317, 348,
  318, 349,  319, 350,  320, 320,  321, 352,  322, 353,  323, 354,  324, 355,
  325, 356,  326, 357,  327, 358,  328, 359,  329, 360,  330, 361,  331, 362,
  332, 363,  333, 364,  334, 365,  335, 366,  336, 367,  337, 368,  338, 369,
  339, 370,  340, 371,  341, 372,  342, 373,  343, 374,  344, 375,  345, 376,
  346, 377,  347, 378,  348, 379,  349, 380,  350, 381,  351, 382,  352, 352,
  353, 384,  354, 385,  355, 386,  356, 387,  357, 388,  358, 389,  359, 390,
  360, 391,  361, 392,  362, 393,  363, 394,  364, 395,  365, 396,  366, 397,
  367, 398,  368, 399,  369, 400,  370, 401,  371, 402,  372, 403,  373, 404,
  374, 405,  375, 406,  376, 407,  377, 408,  378, 409,  379, 410,  380, 411,
  381, 412,  382, 413,  383, 414,  384, 384,  385, 416,  386, 417,  387, 418,
  388, 419,  389, 420,  390, 421,  391, 422,  392, 423,  393, 424,  394, 425,
  395, 426,  396, 427,  397, 428,  398, 429,  399, 430,  400, 431,  401, 432,
  402, 433,  403, 434,  404, 435,  405, 436,  406, 437,  407, 438,  408, 439,
  409, 440,  410, 441,  411, 442,  412, 443,  413, 444,  414, 445,  415, 446,
  416, 416,  417, 448,  418, 449,  419, 450,  420, 451,  421, 452,  422, 453,
  423, 454,  424, 455,  425, 456,  426, 457,  427, 458,  428, 459,  429, 460,
  430, 461,  431, 462,  432, 463,  433, 464,  434, 465,  435, 466,  436, 467,
  437, 468,  438, 469,  439, 470,  440, 471,  441, 472,  442, 473,  443, 474,
  444, 475,  445, 476,  446, 477,  447, 478,  448, 448,  449, 480,  450, 481,
  451, 482,  452, 483,  453, 484,  454, 485,  455, 486,  456, 487,  457, 488,
  458, 489,  459, 490,  460, 491,  461, 492,  462, 493,  463, 494,  464, 495,
  465, 496,  466, 497,  467, 498,  468, 499,  469, 500,  470, 501,  471, 502,
  472, 503,  473, 504,  474, 505,  475, 506,  476, 507,  477, 508,  478, 509,
  479, 510,  480, 480,  481, 512,  482, 513,  483, 514,  484, 515,  485, 516,
  486, 517,  487, 518,  488, 519,  489, 520,  490, 521,  491, 522,  492, 523,
  493, 524,  494, 525,  495, 526,  496, 527,  497, 528,  498, 529,  499, 530,
  500, 531,  501, 532,  502, 533,  503, 534,  504, 535,  505, 536,  506, 537,
  507, 538,  508, 539,  509, 540,  510, 541,  511, 542,  512, 512,  513, 544,
  514, 545,  515, 546,  516, 547,  517, 548,  518, 549,  519, 550,  520, 551,
  521, 552,  522, 553,  523, 554,  524, 555,  525, 556,  526, 557,  527, 558,
  528, 559,  529, 560,  530, 561,  531, 562,  532, 563,  533, 564,  534, 565,
  535, 566,  536, 567,  537, 568,  538, 569,  539, 570,  540, 571,  541, 572,
  542, 573,  543, 574,  544, 544,  545, 576,  546, 577,  547, 578,  548, 579,
  549, 580,  550, 581,  551, 582,  552, 583,  553, 584,  554, 585,  555, 586,
  556, 587,  557, 588,  558, 589,  559, 590,  560, 591,  561, 592,  562, 593,
  563, 594,  564, 595,  565, 596,  566, 597,  567, 598,  568, 599,  569, 600,
  570, 601,  571, 602,  572, 603,  573, 604,  574, 605,  575, 606,  576, 576,
  577, 608,  578, 609,  579, 610,  580, 611,  581, 612,  582, 613,  583, 614,
  584, 615,  585, 616,  586, 617,  587, 618,  588, 619,  589, 620,  590, 621,
  591, 622,  592, 623,  593, 624,  594, 625,  595, 626,  596, 627,  597, 628,
  598, 629,  599, 630,  600, 631,  601, 632,  602, 633,  603, 634,  604, 635,
  605, 636,  606, 637,  607, 638,  608, 608,  609, 640,  610, 641,  611, 642,
  612, 643,  613, 644,  614, 645,  615, 646,  616, 647,  617, 648,  618, 649,
  619, 650,  620, 651,  621, 652,  622, 653,  623, 654,  624, 655,  625, 656,
  626, 657,  627, 658,  628, 659,  629, 660,  630, 661,  631, 662,  632, 663,
  633, 664,  634, 665,  635, 666,  636, 667,  637, 668,  638, 669,  639, 670,
  640, 640,  641, 672,  642, 673,  643, 674,  644, 675,  645, 676,  646, 677,
  647, 678,  648, 679,  649, 680,  650, 681,  651, 682,  652, 683,  653, 684,
  654, 685,  655, 686,  656, 687,  657, 688,  658, 689,  659, 690,  660, 691,
  661, 692,  662, 693,  663, 694,  664, 695,  665, 696,  666, 697,  667, 698,
  668, 699,  669, 700,  670, 701,  671, 702,  672, 672,  673, 704,  674, 705,
  675, 706,  676, 707,  677, 708,  678, 709,  679, 710,  680, 711,  681, 712,
  682, 713,  683, 714,  684, 715,  685, 716,  686, 717,  687, 718,  688, 719,
  689, 720,  690, 721,  691, 722,  692, 723,  693, 724,  694, 725,  695, 726,
  696, 727,  697, 728,  698, 729,  699, 730,  700, 731,  701, 732,  702, 733,
  703, 734,  704, 704,  705, 736,  706, 737,  707, 738,  708, 739,  709, 740,
  710, 741,  711, 742,  712, 743,  713, 744,  714, 745,  715, 746,  716, 747,
  717, 748,  718, 749,  719, 750,  720, 751,  721, 752,  722, 753,  723, 754,
  724, 755,  725, 756,  726, 757,  727, 758,  728, 759,  729, 760,  730, 761,
  731, 762,  732, 763,  733, 764,  734, 765,  735, 766,  736, 736,  737, 768,
  738, 769,  739, 770,  740, 771,  741, 772,  742, 773,  743, 774,  744, 775,
  745, 776,  746, 777,  747, 778,  748, 779,  749, 780,  750, 781,  751, 782,
  752, 783,  753, 784,  754, 785,  755, 786,  756, 787,  757, 788,  758, 789,
  759, 790,  760, 791,  761, 792,  762, 793,  763, 794,  764, 795,  765, 796,
  766, 797,  767, 798,  768, 768,  769, 800,  770, 801,  771, 802,  772, 803,
  773, 804,  774, 805,  775, 806,  776, 807,  777, 808,  778, 809,  779, 810,
  780, 811,  781, 812,  782, 813,  783, 814,  784, 815,  785, 816,  786, 817,
  787, 818,  788, 819,  789, 820,  790, 821,  791, 822,  792, 823,  793, 824,
  794, 825,  795, 826,  796, 827,  797, 828,  798, 829,  799, 830,  800, 800,
  801, 832,  802, 833,  803, 834,  804, 835,  805, 836,  806, 837,  807, 838,
  808, 839,  809, 840,  810, 841,  811, 842,  812, 843,  813, 844,  814, 845,
  815, 846,  816, 847,  817, 848,  818, 849,  819, 850,  820, 851,  821, 852,
  822, 853,  823, 854,  824, 855,  825, 856,  826, 857,  827, 858,  828, 859,
  829, 860,  830, 861,  831, 862,  832, 832,  833, 864,  834, 865,  835, 866,
  836, 867,  837, 868,  838, 869,  839, 870,  840, 871,  841, 872,  842, 873,
  843, 874,  844, 875,  845, 876,  846, 877,  847, 878,  848, 879,  849, 880,
  850, 881,  851, 882,  852, 883,  853, 884,  854, 885,  855, 886,  856, 887,
  857, 888,  858, 889,  859, 890,  860, 891,  861, 892,  862, 893,  863, 894,
  864, 864,  865, 896,  866, 897,  867, 898,  868, 899,  869, 900,  870, 901,
  871, 902,  872, 903,  873, 904,  874, 905,  875, 906,  876, 907,  877, 908,
  878, 909,  879, 910,  880, 911,  881, 912,  882, 913,  883, 914,  884, 915,
  885, 916,  886, 917,  887, 918,  888, 919,  889, 920,  890, 921,  891, 922,
  892, 923,  893, 924,  894, 925,  895, 926,  896, 896,  897, 928,  898, 929,
  899, 930,  900, 931,  901, 932,  902, 933,  903, 934,  904, 935,  905, 936,
  906, 937,  907, 938,  908, 939,  909, 940,  910, 941,  911, 942,  912, 943,
  913, 944,  914, 945,  915, 946,  916, 947,  917, 948,  918, 949,  919, 950,
  920, 951,  921, 952,  922, 953,  923, 954,  924, 955,  925, 956,  926, 957,
  927, 958,  928, 928,  929, 960,  930, 961,  931, 962,  932, 963,  933, 964,
  934, 965,  935, 966,  936, 967,  937, 968,  938, 969,  939, 970,  940, 971,
  941, 972,  942, 973,  943, 974,  944, 975,  945, 976,  946, 977,  947, 978,
  948, 979,  949, 980,  950, 981,  951, 982,  952, 983,  953, 984,  954, 985,
  955, 986,  956, 987,  957, 988,  958, 989,  959, 990,  960, 960,  961, 992,
  962, 993,  963, 994,  964, 995,  965, 996,  966, 997,  967, 998,  968, 999,
  969, 1000, 970, 1001, 971, 1002, 972, 1003, 973, 1004, 974, 1005, 975, 1006,
  976, 1007, 977, 1008, 978, 1009, 979, 1010, 980, 1011, 981, 1012, 982, 1013,
  983, 1014, 984, 1015, 985, 1016, 986, 1017, 987, 1018, 988, 1019, 989, 1020,
  990, 1021, 991, 1022, 0,   0,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    32,  0,    32,  32,   1,   32,  33,  1,    64,  64,
  33,  64,   2,   33,   96,  96,   34,  2,    65,  96,  34,  65,   128, 128,
  97,  128,  3,   34,   66,  97,   35,  3,    35,  66,  98,  129,  129, 160,
  160, 161,  4,   35,   67,  98,   192, 192,  36,  4,   130, 161,  161, 192,
  36,  67,   99,  130,  5,   36,   68,  99,   193, 224, 162, 193,  224, 225,
  131, 162,  37,  68,   100, 131,  37,  5,    194, 225, 225, 256,  256, 257,
  163, 194,  69,  100,  132, 163,  6,   37,   226, 257, 38,  6,    195, 226,
  257, 288,  101, 132,  288, 289,  38,  69,   164, 195, 133, 164,  258, 289,
  227, 258,  196, 227,  7,   38,   289, 320,  70,  101, 320, 321,  39,  7,
  165, 196,  39,  70,   102, 133,  290, 321,  259, 290, 228, 259,  321, 352,
  352, 353,  197, 228,  134, 165,  71,  102,  8,   39,  322, 353,  291, 322,
  260, 291,  103, 134,  353, 384,  166, 197,  229, 260, 40,  71,   40,  8,
  384, 385,  135, 166,  354, 385,  323, 354,  198, 229, 292, 323,  72,  103,
  261, 292,  9,   40,   385, 416,  167, 198,  104, 135, 230, 261,  355, 386,
  416, 417,  293, 324,  324, 355,  41,  9,    41,  72,  386, 417,  199, 230,
  136, 167,  417, 448,  262, 293,  356, 387,  73,  104, 387, 418,  231, 262,
  10,  41,   168, 199,  325, 356,  418, 449,  105, 136, 448, 449,  42,  73,
  294, 325,  200, 231,  42,  10,   357, 388,  137, 168, 263, 294,  388, 419,
  74,  105,  419, 450,  449, 480,  326, 357,  232, 263, 295, 326,  169, 200,
  11,  42,   106, 137,  480, 481,  450, 481,  358, 389, 264, 295,  201, 232,
  138, 169,  389, 420,  43,  74,   420, 451,  327, 358, 43,  11,   481, 512,
  233, 264,  451, 482,  296, 327,  75,  106,  170, 201, 482, 513,  512, 513,
  390, 421,  359, 390,  421, 452,  107, 138,  12,  43,  202, 233,  452, 483,
  265, 296,  328, 359,  139, 170,  44,  75,   483, 514, 513, 544,  234, 265,
  297, 328,  422, 453,  44,  12,   391, 422,  171, 202, 76,  107,  514, 545,
  453, 484,  544, 545,  266, 297,  203, 234,  108, 139, 329, 360,  298, 329,
  140, 171,  515, 546,  13,  44,   423, 454,  235, 266, 545, 576,  454, 485,
  45,  76,   172, 203,  330, 361,  576, 577,  45,  13,  267, 298,  546, 577,
  77,  108,  204, 235,  455, 486,  577, 608,  299, 330, 109, 140,  547, 578,
  14,  45,   46,  14,   141, 172,  578, 609,  331, 362, 46,  77,   173, 204,
  15,  15,   78,  109,  205, 236,  579, 610,  110, 141, 15,  46,   142, 173,
  47,  78,   174, 205,  16,  16,   79,  110,  206, 237, 16,  47,   111, 142,
  48,  79,   143, 174,  80,  111,  175, 206,  17,  48,  49,  17,   207, 238,
  49,  80,   81,  112,  18,  18,   18,  49,   50,  81,  82,  113,  19,  50,
  51,  82,   83,  114,  608, 609,  484, 515,  360, 391, 236, 267,  112, 143,
  51,  19,   640, 640,  609, 640,  516, 547,  485, 516, 392, 423,  361, 392,
  268, 299,  237, 268,  144, 175,  113, 144,  20,  51,  52,  20,   672, 672,
  641, 672,  610, 641,  548, 579,  517, 548,  486, 517, 424, 455,  393, 424,
  362, 393,  300, 331,  269, 300,  238, 269,  176, 207, 145, 176,  114, 145,
  52,  83,   21,  52,   53,  21,   704, 704,  673, 704, 642, 673,  611, 642,
  580, 611,  549, 580,  518, 549,  487, 518,  456, 487, 425, 456,  394, 425,
  363, 394,  332, 363,  301, 332,  270, 301,  239, 270, 208, 239,  177, 208,
  146, 177,  115, 146,  84,  115,  53,  84,   22,  53,  54,  22,   705, 736,
  674, 705,  643, 674,  581, 612,  550, 581,  519, 550, 457, 488,  426, 457,
  395, 426,  333, 364,  302, 333,  271, 302,  209, 240, 178, 209,  147, 178,
  85,  116,  54,  85,   23,  54,   706, 737,  675, 706, 582, 613,  551, 582,
  458, 489,  427, 458,  334, 365,  303, 334,  210, 241, 179, 210,  86,  117,
  55,  86,   707, 738,  583, 614,  459, 490,  335, 366, 211, 242,  87,  118,
  736, 737,  612, 643,  488, 519,  364, 395,  240, 271, 116, 147,  55,  23,
  768, 768,  737, 768,  644, 675,  613, 644,  520, 551, 489, 520,  396, 427,
  365, 396,  272, 303,  241, 272,  148, 179,  117, 148, 24,  55,   56,  24,
  800, 800,  769, 800,  738, 769,  676, 707,  645, 676, 614, 645,  552, 583,
  521, 552,  490, 521,  428, 459,  397, 428,  366, 397, 304, 335,  273, 304,
  242, 273,  180, 211,  149, 180,  118, 149,  56,  87,  25,  56,   57,  25,
  832, 832,  801, 832,  770, 801,  739, 770,  708, 739, 677, 708,  646, 677,
  615, 646,  584, 615,  553, 584,  522, 553,  491, 522, 460, 491,  429, 460,
  398, 429,  367, 398,  336, 367,  305, 336,  274, 305, 243, 274,  212, 243,
  181, 212,  150, 181,  119, 150,  88,  119,  57,  88,  26,  57,   58,  26,
  833, 864,  802, 833,  771, 802,  709, 740,  678, 709, 647, 678,  585, 616,
  554, 585,  523, 554,  461, 492,  430, 461,  399, 430, 337, 368,  306, 337,
  275, 306,  213, 244,  182, 213,  151, 182,  89,  120, 58,  89,   27,  58,
  834, 865,  803, 834,  710, 741,  679, 710,  586, 617, 555, 586,  462, 493,
  431, 462,  338, 369,  307, 338,  214, 245,  183, 214, 90,  121,  59,  90,
  835, 866,  711, 742,  587, 618,  463, 494,  339, 370, 215, 246,  91,  122,
  864, 865,  740, 771,  616, 647,  492, 523,  368, 399, 244, 275,  120, 151,
  59,  27,   896, 896,  865, 896,  772, 803,  741, 772, 648, 679,  617, 648,
  524, 555,  493, 524,  400, 431,  369, 400,  276, 307, 245, 276,  152, 183,
  121, 152,  28,  59,   60,  28,   928, 928,  897, 928, 866, 897,  804, 835,
  773, 804,  742, 773,  680, 711,  649, 680,  618, 649, 556, 587,  525, 556,
  494, 525,  432, 463,  401, 432,  370, 401,  308, 339, 277, 308,  246, 277,
  184, 215,  153, 184,  122, 153,  60,  91,   29,  60,  61,  29,   960, 960,
  929, 960,  898, 929,  867, 898,  836, 867,  805, 836, 774, 805,  743, 774,
  712, 743,  681, 712,  650, 681,  619, 650,  588, 619, 557, 588,  526, 557,
  495, 526,  464, 495,  433, 464,  402, 433,  371, 402, 340, 371,  309, 340,
  278, 309,  247, 278,  216, 247,  185, 216,  154, 185, 123, 154,  92,  123,
  61,  92,   30,  61,   62,  30,   961, 992,  930, 961, 899, 930,  837, 868,
  806, 837,  775, 806,  713, 744,  682, 713,  651, 682, 589, 620,  558, 589,
  527, 558,  465, 496,  434, 465,  403, 434,  341, 372, 310, 341,  279, 310,
  217, 248,  186, 217,  155, 186,  93,  124,  62,  93,  31,  62,   962, 993,
  931, 962,  838, 869,  807, 838,  714, 745,  683, 714, 590, 621,  559, 590,
  466, 497,  435, 466,  342, 373,  311, 342,  218, 249, 187, 218,  94,  125,
  63,  94,   963, 994,  839, 870,  715, 746,  591, 622, 467, 498,  343, 374,
  219, 250,  95,  126,  868, 899,  744, 775,  620, 651, 496, 527,  372, 403,
  248, 279,  124, 155,  900, 931,  869, 900,  776, 807, 745, 776,  652, 683,
  621, 652,  528, 559,  497, 528,  404, 435,  373, 404, 280, 311,  249, 280,
  156, 187,  125, 156,  932, 963,  901, 932,  870, 901, 808, 839,  777, 808,
  746, 777,  684, 715,  653, 684,  622, 653,  560, 591, 529, 560,  498, 529,
  436, 467,  405, 436,  374, 405,  312, 343,  281, 312, 250, 281,  188, 219,
  157, 188,  126, 157,  964, 995,  933, 964,  902, 933, 871, 902,  840, 871,
  809, 840,  778, 809,  747, 778,  716, 747,  685, 716, 654, 685,  623, 654,
  592, 623,  561, 592,  530, 561,  499, 530,  468, 499, 437, 468,  406, 437,
  375, 406,  344, 375,  313, 344,  282, 313,  251, 282, 220, 251,  189, 220,
  158, 189,  127, 158,  965, 996,  934, 965,  903, 934, 841, 872,  810, 841,
  779, 810,  717, 748,  686, 717,  655, 686,  593, 624, 562, 593,  531, 562,
  469, 500,  438, 469,  407, 438,  345, 376,  314, 345, 283, 314,  221, 252,
  190, 221,  159, 190,  966, 997,  935, 966,  842, 873, 811, 842,  718, 749,
  687, 718,  594, 625,  563, 594,  470, 501,  439, 470, 346, 377,  315, 346,
  222, 253,  191, 222,  967, 998,  843, 874,  719, 750, 595, 626,  471, 502,
  347, 378,  223, 254,  872, 903,  748, 779,  624, 655, 500, 531,  376, 407,
  252, 283,  904, 935,  873, 904,  780, 811,  749, 780, 656, 687,  625, 656,
  532, 563,  501, 532,  408, 439,  377, 408,  284, 315, 253, 284,  936, 967,
  905, 936,  874, 905,  812, 843,  781, 812,  750, 781, 688, 719,  657, 688,
  626, 657,  564, 595,  533, 564,  502, 533,  440, 471, 409, 440,  378, 409,
  316, 347,  285, 316,  254, 285,  968, 999,  937, 968, 906, 937,  875, 906,
  844, 875,  813, 844,  782, 813,  751, 782,  720, 751, 689, 720,  658, 689,
  627, 658,  596, 627,  565, 596,  534, 565,  503, 534, 472, 503,  441, 472,
  410, 441,  379, 410,  348, 379,  317, 348,  286, 317, 255, 286,  969, 1000,
  938, 969,  907, 938,  845, 876,  814, 845,  783, 814, 721, 752,  690, 721,
  659, 690,  597, 628,  566, 597,  535, 566,  473, 504, 442, 473,  411, 442,
  349, 380,  318, 349,  287, 318,  970, 1001, 939, 970, 846, 877,  815, 846,
  722, 753,  691, 722,  598, 629,  567, 598,  474, 505, 443, 474,  350, 381,
  319, 350,  971, 1002, 847, 878,  723, 754,  599, 630, 475, 506,  351, 382,
  876, 907,  752, 783,  628, 659,  504, 535,  380, 411, 908, 939,  877, 908,
  784, 815,  753, 784,  660, 691,  629, 660,  536, 567, 505, 536,  412, 443,
  381, 412,  940, 971,  909, 940,  878, 909,  816, 847, 785, 816,  754, 785,
  692, 723,  661, 692,  630, 661,  568, 599,  537, 568, 506, 537,  444, 475,
  413, 444,  382, 413,  972, 1003, 941, 972,  910, 941, 879, 910,  848, 879,
  817, 848,  786, 817,  755, 786,  724, 755,  693, 724, 662, 693,  631, 662,
  600, 631,  569, 600,  538, 569,  507, 538,  476, 507, 445, 476,  414, 445,
  383, 414,  973, 1004, 942, 973,  911, 942,  849, 880, 818, 849,  787, 818,
  725, 756,  694, 725,  663, 694,  601, 632,  570, 601, 539, 570,  477, 508,
  446, 477,  415, 446,  974, 1005, 943, 974,  850, 881, 819, 850,  726, 757,
  695, 726,  602, 633,  571, 602,  478, 509,  447, 478, 975, 1006, 851, 882,
  727, 758,  603, 634,  479, 510,  880, 911,  756, 787, 632, 663,  508, 539,
  912, 943,  881, 912,  788, 819,  757, 788,  664, 695, 633, 664,  540, 571,
  509, 540,  944, 975,  913, 944,  882, 913,  820, 851, 789, 820,  758, 789,
  696, 727,  665, 696,  634, 665,  572, 603,  541, 572, 510, 541,  976, 1007,
  945, 976,  914, 945,  883, 914,  852, 883,  821, 852, 790, 821,  759, 790,
  728, 759,  697, 728,  666, 697,  635, 666,  604, 635, 573, 604,  542, 573,
  511, 542,  977, 1008, 946, 977,  915, 946,  853, 884, 822, 853,  791, 822,
  729, 760,  698, 729,  667, 698,  605, 636,  574, 605, 543, 574,  978, 1009,
  947, 978,  854, 885,  823, 854,  730, 761,  699, 730, 606, 637,  575, 606,
  979, 1010, 855, 886,  731, 762,  607, 638,  884, 915, 760, 791,  636, 667,
  916, 947,  885, 916,  792, 823,  761, 792,  668, 699, 637, 668,  948, 979,
  917, 948,  886, 917,  824, 855,  793, 824,  762, 793, 700, 731,  669, 700,
  638, 669,  980, 1011, 949, 980,  918, 949,  887, 918, 856, 887,  825, 856,
  794, 825,  763, 794,  732, 763,  701, 732,  670, 701, 639, 670,  981, 1012,
  950, 981,  919, 950,  857, 888,  826, 857,  795, 826, 733, 764,  702, 733,
  671, 702,  982, 1013, 951, 982,  858, 889,  827, 858, 734, 765,  703, 734,
  983, 1014, 859, 890,  735, 766,  888, 919,  764, 795, 920, 951,  889, 920,
  796, 827,  765, 796,  952, 983,  921, 952,  890, 921, 828, 859,  797, 828,
  766, 797,  984, 1015, 953, 984,  922, 953,  891, 922, 860, 891,  829, 860,
  798, 829,  767, 798,  985, 1016, 954, 985,  923, 954, 861, 892,  830, 861,
  799, 830,  986, 1017, 955, 986,  862, 893,  831, 862, 987, 1018, 863, 894,
  892, 923,  924, 955,  893, 924,  956, 987,  925, 956, 894, 925,  988, 1019,
  957, 988,  926, 957,  895, 926,  989, 1020, 958, 989, 927, 958,  990, 1021,
  959, 990,  991, 1022, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                v2_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    0,   0,    1,   32,   1,   1,   32,  32,   2,   33,
  33,  64,   34,  65,   2,   2,    64,  64,   3,   34,  65,  96,   35,  66,
  66,  97,   3,   3,    96,  96,   4,   35,   97,  128, 67,  98,   36,  67,
  98,  129,  4,   4,    68,  99,   99,  130,  128, 128, 5,   36,   129, 160,
  37,  68,   130, 161,  100, 131,  69,  100,  131, 162, 5,   5,    160, 160,
  6,   37,   161, 192,  38,  69,   162, 193,  101, 132, 132, 163,  70,  101,
  163, 194,  6,   6,    192, 192,  7,   38,   133, 164, 193, 224,  102, 133,
  164, 195,  39,  70,   194, 225,  71,  102,  195, 226, 134, 165,  165, 196,
  7,   7,    224, 224,  8,   39,   103, 134,  196, 227, 225, 256,  40,  71,
  226, 257,  166, 197,  72,  103,  227, 258,  135, 166, 197, 228,  104, 135,
  228, 259,  8,   8,    256, 256,  9,   40,   257, 288, 41,  72,   167, 198,
  198, 229,  258, 289,  136, 167,  229, 260,  73,  104, 259, 290,  105, 136,
  260, 291,  199, 230,  9,   9,    168, 199,  230, 261, 288, 288,  10,  41,
  289, 320,  42,  73,   290, 321,  137, 168,  261, 292, 74,  105,  291, 322,
  200, 231,  231, 262,  106, 137,  292, 323,  169, 200, 262, 293,  10,  10,
  320, 320,  11,  42,   321, 352,  43,  74,   138, 169, 293, 324,  322, 353,
  232, 263,  75,  106,  201, 232,  263, 294,  323, 354, 170, 201,  294, 325,
  107, 138,  324, 355,  11,  11,   352, 352,  12,  43,  233, 264,  264, 295,
  353, 384,  139, 170,  325, 356,  44,  75,   354, 385, 202, 233,  295, 326,
  76,  107,  355, 386,  171, 202,  326, 357,  108, 139, 356, 387,  265, 296,
  234, 265,  296, 327,  12,  12,   140, 171,  357, 388, 384, 384,  13,  44,
  203, 234,  327, 358,  385, 416,  45,  76,   386, 417, 77,  108,  387, 418,
  172, 203,  358, 389,  266, 297,  297, 328,  109, 140, 235, 266,  328, 359,
  388, 419,  204, 235,  359, 390,  141, 172,  389, 420, 13,  13,   416, 416,
  14,  45,   417, 448,  46,  77,   298, 329,  418, 449, 267, 298,  329, 360,
  78,  109,  173, 204,  390, 421,  419, 450,  236, 267, 360, 391,  110, 141,
  420, 451,  205, 236,  391, 422,  142, 173,  299, 330, 330, 361,  421, 452,
  14,  14,   268, 299,  361, 392,  448, 448,  15,  46,  449, 480,  47,  78,
  450, 481,  174, 205,  422, 453,  237, 268,  392, 423, 79,  110,  451, 482,
  111, 142,  452, 483,  331, 362,  300, 331,  362, 393, 206, 237,  423, 454,
  143, 174,  269, 300,  393, 424,  453, 484,  480, 480, 481, 512,  238, 269,
  424, 455,  482, 513,  175, 206,  454, 485,  332, 363, 363, 394,  483, 514,
  301, 332,  394, 425,  484, 515,  207, 238,  455, 486, 270, 301,  425, 456,
  485, 516,  364, 395,  239, 270,  456, 487,  512, 512, 333, 364,  395, 426,
  513, 544,  486, 517,  514, 545,  302, 333,  426, 457, 515, 546,  487, 518,
  516, 547,  271, 302,  457, 488,  365, 396,  396, 427, 517, 548,  334, 365,
  427, 458,  488, 519,  544, 544,  303, 334,  458, 489, 518, 549,  545, 576,
  546, 577,  547, 578,  489, 520,  397, 428,  519, 550, 366, 397,  428, 459,
  548, 579,  335, 366,  459, 490,  549, 580,  520, 551, 490, 521,  550, 581,
  576, 576,  577, 608,  398, 429,  429, 460,  578, 609, 367, 398,  460, 491,
  521, 552,  579, 610,  551, 582,  491, 522,  580, 611, 581, 612,  552, 583,
  522, 553,  430, 461,  399, 430,  461, 492,  582, 613, 492, 523,  608, 608,
  609, 640,  610, 641,  553, 584,  611, 642,  523, 554, 583, 614,  612, 643,
  431, 462,  462, 493,  554, 585,  493, 524,  584, 615, 613, 644,  524, 555,
  614, 645,  640, 640,  585, 616,  641, 672,  555, 586, 642, 673,  615, 646,
  463, 494,  643, 674,  494, 525,  644, 675,  525, 556, 586, 617,  616, 647,
  645, 676,  556, 587,  646, 677,  495, 526,  617, 648, 587, 618,  672, 672,
  526, 557,  673, 704,  674, 705,  647, 678,  557, 588, 675, 706,  618, 649,
  676, 707,  588, 619,  648, 679,  677, 708,  527, 558, 558, 589,  678, 709,
  619, 650,  649, 680,  704, 704,  589, 620,  705, 736, 679, 710,  706, 737,
  707, 738,  650, 681,  620, 651,  708, 739,  680, 711, 559, 590,  709, 740,
  590, 621,  651, 682,  681, 712,  710, 741,  621, 652, 736, 736,  737, 768,
  711, 742,  738, 769,  682, 713,  652, 683,  739, 770, 591, 622,  740, 771,
  712, 743,  622, 653,  741, 772,  683, 714,  653, 684, 713, 744,  742, 773,
  623, 654,  743, 774,  768, 768,  769, 800,  684, 715, 714, 745,  770, 801,
  771, 802,  654, 685,  744, 775,  772, 803,  715, 746, 773, 804,  685, 716,
  745, 776,  774, 805,  655, 686,  716, 747,  775, 806, 746, 777,  800, 800,
  801, 832,  686, 717,  802, 833,  803, 834,  776, 807, 804, 835,  747, 778,
  717, 748,  805, 836,  777, 808,  687, 718,  806, 837, 748, 779,  718, 749,
  778, 809,  807, 838,  832, 832,  833, 864,  834, 865, 835, 866,  808, 839,
  749, 780,  836, 867,  779, 810,  719, 750,  837, 868, 809, 840,  838, 869,
  780, 811,  750, 781,  810, 841,  839, 870,  864, 864, 865, 896,  866, 897,
  840, 871,  867, 898,  781, 812,  811, 842,  868, 899, 751, 782,  869, 900,
  841, 872,  812, 843,  870, 901,  782, 813,  842, 873, 871, 902,  896, 896,
  897, 928,  813, 844,  898, 929,  872, 903,  783, 814, 843, 874,  899, 930,
  900, 931,  873, 904,  901, 932,  814, 845,  844, 875, 902, 933,  874, 905,
  903, 934,  845, 876,  928, 928,  815, 846,  929, 960, 930, 961,  875, 906,
  904, 935,  931, 962,  932, 963,  905, 936,  846, 877, 933, 964,  876, 907,
  934, 965,  906, 937,  935, 966,  877, 908,  847, 878, 960, 960,  907, 938,
  961, 992,  936, 967,  962, 993,  963, 994,  964, 995, 878, 909,  937, 968,
  908, 939,  965, 996,  966, 997,  938, 969,  879, 910, 909, 940,  967, 998,
  939, 970,  968, 999,  910, 941,  969, 1000, 940, 971, 970, 1001, 911, 942,
  941, 972,  971, 1002, 942, 973,  972, 1003, 943, 974, 973, 1004, 974, 1005,
  975, 1006, 15,  15,   16,  47,   48,  79,   80,  111, 112, 143,  144, 175,
  16,  16,   17,  48,   176, 207,  49,  80,   81,  112, 113, 144,  208, 239,
  145, 176,  240, 271,  17,  17,   18,  49,   177, 208, 50,  81,   82,  113,
  272, 303,  209, 240,  114, 145,  146, 177,  241, 272, 304, 335,  178, 209,
  18,  18,   19,  50,   51,  82,   83,  114,  273, 304, 210, 241,  115, 146,
  336, 367,  147, 178,  242, 273,  305, 336,  179, 210, 19,  19,   368, 399,
  20,  51,   52,  83,   274, 305,  84,  115,  211, 242, 337, 368,  116, 147,
  306, 337,  148, 179,  243, 274,  400, 431,  369, 400, 180, 211,  20,  20,
  21,  52,   275, 306,  53,  84,   338, 369,  212, 243, 85,  116,  432, 463,
  117, 148,  401, 432,  307, 338,  244, 275,  149, 180, 370, 401,  181, 212,
  276, 307,  464, 495,  339, 370,  21,  21,   22,  53,  433, 464,  54,  85,
  213, 244,  86,  117,  402, 433,  118, 149,  308, 339, 245, 276,  371, 402,
  150, 181,  496, 527,  465, 496,  182, 213,  434, 465, 340, 371,  277, 308,
  22,  22,   23,  54,   403, 434,  55,  86,   214, 245, 87,  118,  309, 340,
  372, 403,  119, 150,  497, 528,  528, 559,  246, 277, 466, 497,  151, 182,
  435, 466,  341, 372,  183, 214,  278, 309,  404, 435, 23,  23,   24,  55,
  215, 246,  529, 560,  56,  87,   498, 529,  560, 591, 310, 341,  88,  119,
  373, 404,  467, 498,  120, 151,  247, 278,  436, 467, 152, 183,  342, 373,
  279, 310,  405, 436,  184, 215,  530, 561,  561, 592, 499, 530,  592, 623,
  24,  24,   216, 247,  468, 499,  25,  56,   374, 405, 57,  88,   311, 342,
  89,  120,  437, 468,  248, 279,  121, 152,  562, 593, 153, 184,  343, 374,
  531, 562,  593, 624,  406, 437,  500, 531,  624, 655, 280, 311,  185, 216,
  469, 500,  375, 406,  217, 248,  25,  25,   312, 343, 26,  57,   58,  89,
  438, 469,  90,  121,  563, 594,  594, 625,  249, 280, 532, 563,  625, 656,
  122, 153,  344, 375,  501, 532,  656, 687,  407, 438, 154, 185,  281, 312,
  470, 501,  186, 217,  376, 407,  595, 626,  564, 595, 626, 657,  218, 249,
  313, 344,  439, 470,  26,  26,   27,  58,   533, 564, 657, 688,  59,  90,
  91,  122,  250, 281,  502, 533,  688, 719,  123, 154, 408, 439,  345, 376,
  155, 186,  471, 502,  282, 313,  596, 627,  627, 658, 187, 218,  565, 596,
  658, 689,  377, 408,  440, 471,  534, 565,  689, 720, 314, 345,  219, 250,
  27,  27,   28,  59,   503, 534,  720, 751,  60,  91,  92,  123,  251, 282,
  409, 440,  346, 377,  124, 155,  628, 659,  472, 503, 597, 628,  659, 690,
  566, 597,  690, 721,  156, 187,  283, 314,  535, 566, 721, 752,  188, 219,
  378, 409,  441, 472,  315, 346,  504, 535,  752, 783, 220, 251,  28,  28,
  629, 660,  660, 691,  29,  60,   61,  92,   410, 441, 598, 629,  691, 722,
  252, 283,  93,  124,  347, 378,  473, 504,  567, 598, 722, 753,  125, 156,
  284, 315,  536, 567,  753, 784,  157, 188,  442, 473, 379, 410,  189, 220,
  505, 536,  784, 815,  661, 692,  316, 347,  630, 661, 692, 723,  221, 252,
  599, 630,  723, 754,  411, 442,  29,  29,   568, 599, 754, 785,  30,  61,
  474, 505,  62,  93,   253, 284,  348, 379,  94,  125, 537, 568,  785, 816,
  126, 157,  285, 316,  158, 189,  443, 474,  662, 693, 693, 724,  380, 411,
  631, 662,  724, 755,  506, 537,  816, 847,  190, 221, 600, 631,  755, 786,
  317, 348,  222, 253,  569, 600,  786, 817,  412, 443, 475, 506,  30,  30,
  31,  62,   349, 380,  254, 285,  63,  94,   538, 569, 817, 848,  694, 725,
  95,  126,  663, 694,  725, 756,  632, 663,  756, 787, 127, 158,  444, 475,
  286, 317,  381, 412,  507, 538,  848, 879,  159, 190, 601, 632,  787, 818,
  191, 222,  318, 349,  570, 601,  818, 849,  476, 507, 223, 254,  413, 444,
  695, 726,  726, 757,  664, 695,  757, 788,  539, 570, 849, 880,  350, 381,
  255, 286,  633, 664,  788, 819,  445, 476,  602, 633, 819, 850,  508, 539,
  880, 911,  287, 318,  382, 413,  571, 602,  850, 881, 727, 758,  696, 727,
  758, 789,  319, 350,  477, 508,  665, 696,  789, 820, 414, 445,  540, 571,
  881, 912,  634, 665,  820, 851,  351, 382,  603, 634, 851, 882,  446, 477,
  509, 540,  912, 943,  383, 414,  728, 759,  759, 790, 572, 603,  882, 913,
  697, 728,  790, 821,  666, 697,  821, 852,  478, 509, 635, 666,  852, 883,
  415, 446,  541, 572,  913, 944,  604, 635,  883, 914, 760, 791,  729, 760,
  791, 822,  510, 541,  944, 975,  447, 478,  698, 729, 822, 853,  573, 604,
  914, 945,  667, 698,  853, 884,  636, 667,  884, 915, 479, 510,  542, 573,
  945, 976,  761, 792,  792, 823,  605, 636,  915, 946, 730, 761,  823, 854,
  699, 730,  854, 885,  511, 542,  976, 1007, 574, 605, 946, 977,  668, 699,
  885, 916,  637, 668,  916, 947,  543, 574,  793, 824, 977, 1008, 762, 793,
  824, 855,  731, 762,  855, 886,  606, 637,  947, 978, 700, 731,  886, 917,
  669, 700,  917, 948,  575, 606,  978, 1009, 638, 669, 948, 979,  794, 825,
  825, 856,  763, 794,  856, 887,  732, 763,  887, 918, 607, 638,  979, 1010,
  701, 732,  918, 949,  670, 701,  949, 980,  826, 857, 795, 826,  857, 888,
  764, 795,  888, 919,  639, 670,  980, 1011, 733, 764, 919, 950,  702, 733,
  950, 981,  671, 702,  981, 1012, 827, 858,  858, 889, 796, 827,  889, 920,
  765, 796,  920, 951,  734, 765,  951, 982,  703, 734, 982, 1013, 859, 890,
  828, 859,  890, 921,  797, 828,  921, 952,  766, 797, 952, 983,  735, 766,
  983, 1014, 860, 891,  891, 922,  829, 860,  922, 953, 798, 829,  953, 984,
  767, 798,  984, 1015, 892, 923,  861, 892,  923, 954, 830, 861,  954, 985,
  799, 830,  985, 1016, 893, 924,  924, 955,  862, 893, 955, 986,  831, 862,
  986, 1017, 925, 956,  894, 925,  956, 987,  863, 894, 987, 1018, 926, 957,
  957, 988,  895, 926,  988, 1019, 958, 989,  927, 958, 989, 1020, 959, 990,
  990, 1021, 991, 1022, 0,   0,
};

DECLARE_ALIGNED(16, static const int16_t,
                h2_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    0,   0,    1,   32,   1,   1,    32,  32,   2,   33,
  33,  64,   34,  65,   2,   2,    64,  64,   3,   34,   65,  96,   35,  66,
  66,  97,   3,   3,    96,  96,   4,   35,   97,  128,  67,  98,   36,  67,
  98,  129,  4,   4,    68,  99,   99,  130,  128, 128,  5,   36,   129, 160,
  37,  68,   130, 161,  100, 131,  69,  100,  131, 162,  5,   5,    160, 160,
  6,   37,   161, 192,  38,  69,   162, 193,  101, 132,  132, 163,  70,  101,
  163, 194,  6,   6,    192, 192,  7,   38,   133, 164,  193, 224,  102, 133,
  164, 195,  39,  70,   194, 225,  71,  102,  195, 226,  134, 165,  165, 196,
  7,   7,    224, 224,  8,   39,   103, 134,  196, 227,  225, 256,  40,  71,
  226, 257,  166, 197,  72,  103,  227, 258,  135, 166,  197, 228,  104, 135,
  228, 259,  8,   8,    256, 256,  9,   40,   257, 288,  41,  72,   167, 198,
  198, 229,  258, 289,  136, 167,  229, 260,  73,  104,  259, 290,  105, 136,
  260, 291,  199, 230,  9,   9,    168, 199,  230, 261,  288, 288,  10,  41,
  289, 320,  42,  73,   290, 321,  137, 168,  261, 292,  74,  105,  291, 322,
  200, 231,  231, 262,  106, 137,  292, 323,  169, 200,  262, 293,  10,  10,
  320, 320,  11,  42,   321, 352,  43,  74,   138, 169,  293, 324,  322, 353,
  232, 263,  75,  106,  201, 232,  263, 294,  323, 354,  170, 201,  294, 325,
  107, 138,  324, 355,  11,  11,   352, 352,  12,  43,   233, 264,  264, 295,
  353, 384,  139, 170,  325, 356,  44,  75,   354, 385,  202, 233,  295, 326,
  76,  107,  355, 386,  171, 202,  326, 357,  108, 139,  356, 387,  265, 296,
  234, 265,  296, 327,  12,  12,   140, 171,  357, 388,  384, 384,  13,  44,
  203, 234,  327, 358,  385, 416,  45,  76,   386, 417,  77,  108,  387, 418,
  172, 203,  358, 389,  266, 297,  297, 328,  109, 140,  235, 266,  328, 359,
  388, 419,  204, 235,  359, 390,  141, 172,  389, 420,  13,  13,   416, 416,
  14,  45,   417, 448,  46,  77,   298, 329,  418, 449,  267, 298,  329, 360,
  78,  109,  173, 204,  390, 421,  419, 450,  236, 267,  360, 391,  110, 141,
  420, 451,  205, 236,  391, 422,  142, 173,  299, 330,  330, 361,  421, 452,
  14,  14,   268, 299,  361, 392,  448, 448,  15,  46,   449, 480,  47,  78,
  450, 481,  174, 205,  422, 453,  237, 268,  392, 423,  79,  110,  451, 482,
  111, 142,  452, 483,  331, 362,  300, 331,  362, 393,  206, 237,  423, 454,
  143, 174,  269, 300,  393, 424,  453, 484,  15,  15,   16,  47,   48,  79,
  238, 269,  424, 455,  175, 206,  454, 485,  80,  111,  332, 363,  363, 394,
  301, 332,  394, 425,  112, 143,  207, 238,  455, 486,  270, 301,  425, 456,
  144, 175,  364, 395,  16,  16,   239, 270,  456, 487,  17,  48,   333, 364,
  395, 426,  176, 207,  49,  80,   302, 333,  426, 457,  81,  112,  113, 144,
  208, 239,  271, 302,  457, 488,  365, 396,  396, 427,  145, 176,  334, 365,
  427, 458,  240, 271,  17,  17,   18,  49,   177, 208,  303, 334,  458, 489,
  50,  81,   82,  113,  272, 303,  209, 240,  397, 428,  114, 145,  366, 397,
  428, 459,  335, 366,  459, 490,  146, 177,  241, 272,  304, 335,  178, 209,
  18,  18,   19,  50,   51,  82,   398, 429,  429, 460,  367, 398,  460, 491,
  83,  114,  273, 304,  210, 241,  115, 146,  336, 367,  147, 178,  242, 273,
  305, 336,  430, 461,  399, 430,  461, 492,  179, 210,  19,  19,   368, 399,
  20,  51,   52,  83,   274, 305,  84,  115,  211, 242,  337, 368,  116, 147,
  431, 462,  462, 493,  306, 337,  148, 179,  243, 274,  400, 431,  369, 400,
  180, 211,  20,  20,   21,  52,   275, 306,  53,  84,   338, 369,  212, 243,
  85,  116,  463, 494,  432, 463,  117, 148,  401, 432,  307, 338,  244, 275,
  149, 180,  370, 401,  181, 212,  276, 307,  464, 495,  339, 370,  21,  21,
  22,  53,   433, 464,  54,  85,   213, 244,  86,  117,  402, 433,  118, 149,
  308, 339,  245, 276,  371, 402,  150, 181,  465, 496,  182, 213,  434, 465,
  340, 371,  277, 308,  22,  22,   23,  54,   403, 434,  55,  86,   214, 245,
  87,  118,  309, 340,  372, 403,  119, 150,  246, 277,  466, 497,  151, 182,
  435, 466,  341, 372,  183, 214,  278, 309,  404, 435,  23,  23,   24,  55,
  215, 246,  56,  87,   310, 341,  88,  119,  373, 404,  467, 498,  120, 151,
  247, 278,  436, 467,  152, 183,  342, 373,  279, 310,  405, 436,  184, 215,
  24,  24,   216, 247,  468, 499,  25,  56,   374, 405,  57,  88,   311, 342,
  89,  120,  437, 468,  248, 279,  121, 152,  153, 184,  343, 374,  406, 437,
  280, 311,  185, 216,  469, 500,  375, 406,  217, 248,  25,  25,   312, 343,
  26,  57,   58,  89,   438, 469,  90,  121,  249, 280,  122, 153,  344, 375,
  407, 438,  154, 185,  281, 312,  470, 501,  186, 217,  376, 407,  218, 249,
  313, 344,  439, 470,  26,  26,   27,  58,   59,  90,   91,  122,  250, 281,
  123, 154,  408, 439,  345, 376,  155, 186,  471, 502,  282, 313,  187, 218,
  377, 408,  440, 471,  314, 345,  219, 250,  27,  27,   28,  59,   60,  91,
  92,  123,  251, 282,  409, 440,  346, 377,  124, 155,  472, 503,  156, 187,
  283, 314,  188, 219,  378, 409,  441, 472,  315, 346,  220, 251,  28,  28,
  29,  60,   61,  92,   410, 441,  252, 283,  93,  124,  347, 378,  473, 504,
  125, 156,  284, 315,  157, 188,  442, 473,  379, 410,  189, 220,  316, 347,
  221, 252,  411, 442,  29,  29,   30,  61,   474, 505,  62,  93,   253, 284,
  348, 379,  94,  125,  126, 157,  285, 316,  158, 189,  443, 474,  380, 411,
  190, 221,  317, 348,  222, 253,  412, 443,  475, 506,  30,  30,   31,  62,
  349, 380,  254, 285,  63,  94,   95,  126,  127, 158,  444, 475,  286, 317,
  381, 412,  159, 190,  191, 222,  318, 349,  476, 507,  223, 254,  413, 444,
  350, 381,  255, 286,  445, 476,  287, 318,  382, 413,  319, 350,  477, 508,
  414, 445,  351, 382,  446, 477,  383, 414,  478, 509,  415, 446,  447, 478,
  479, 510,  480, 480,  481, 512,  482, 513,  483, 514,  484, 515,  485, 516,
  512, 512,  513, 544,  486, 517,  514, 545,  515, 546,  487, 518,  516, 547,
  517, 548,  488, 519,  544, 544,  518, 549,  545, 576,  546, 577,  547, 578,
  489, 520,  519, 550,  548, 579,  549, 580,  520, 551,  490, 521,  550, 581,
  576, 576,  577, 608,  578, 609,  521, 552,  579, 610,  551, 582,  491, 522,
  580, 611,  581, 612,  552, 583,  522, 553,  582, 613,  492, 523,  608, 608,
  609, 640,  610, 641,  553, 584,  611, 642,  523, 554,  583, 614,  612, 643,
  554, 585,  493, 524,  584, 615,  613, 644,  524, 555,  614, 645,  640, 640,
  585, 616,  641, 672,  555, 586,  642, 673,  615, 646,  643, 674,  494, 525,
  644, 675,  525, 556,  586, 617,  616, 647,  645, 676,  556, 587,  646, 677,
  495, 526,  617, 648,  587, 618,  672, 672,  526, 557,  673, 704,  674, 705,
  647, 678,  557, 588,  675, 706,  618, 649,  676, 707,  588, 619,  648, 679,
  677, 708,  496, 527,  527, 558,  558, 589,  678, 709,  619, 650,  649, 680,
  704, 704,  589, 620,  705, 736,  679, 710,  706, 737,  707, 738,  650, 681,
  620, 651,  497, 528,  528, 559,  708, 739,  680, 711,  559, 590,  709, 740,
  590, 621,  651, 682,  681, 712,  710, 741,  621, 652,  736, 736,  737, 768,
  529, 560,  711, 742,  498, 529,  560, 591,  738, 769,  682, 713,  652, 683,
  739, 770,  591, 622,  740, 771,  712, 743,  622, 653,  741, 772,  683, 714,
  653, 684,  713, 744,  742, 773,  530, 561,  561, 592,  499, 530,  592, 623,
  623, 654,  743, 774,  768, 768,  769, 800,  684, 715,  714, 745,  770, 801,
  771, 802,  654, 685,  744, 775,  772, 803,  562, 593,  531, 562,  593, 624,
  715, 746,  773, 804,  685, 716,  500, 531,  624, 655,  745, 776,  774, 805,
  655, 686,  716, 747,  775, 806,  746, 777,  800, 800,  801, 832,  686, 717,
  802, 833,  563, 594,  594, 625,  803, 834,  532, 563,  625, 656,  776, 807,
  804, 835,  501, 532,  656, 687,  747, 778,  717, 748,  805, 836,  777, 808,
  687, 718,  806, 837,  748, 779,  595, 626,  564, 595,  626, 657,  718, 749,
  778, 809,  807, 838,  832, 832,  533, 564,  657, 688,  833, 864,  834, 865,
  835, 866,  502, 533,  688, 719,  808, 839,  749, 780,  836, 867,  779, 810,
  719, 750,  837, 868,  809, 840,  596, 627,  627, 658,  565, 596,  658, 689,
  838, 869,  780, 811,  750, 781,  534, 565,  689, 720,  810, 841,  839, 870,
  864, 864,  503, 534,  720, 751,  865, 896,  866, 897,  840, 871,  867, 898,
  781, 812,  811, 842,  628, 659,  868, 899,  751, 782,  597, 628,  659, 690,
  566, 597,  690, 721,  869, 900,  841, 872,  535, 566,  721, 752,  812, 843,
  870, 901,  782, 813,  842, 873,  504, 535,  752, 783,  871, 902,  629, 660,
  660, 691,  896, 896,  897, 928,  598, 629,  691, 722,  813, 844,  898, 929,
  872, 903,  783, 814,  843, 874,  899, 930,  567, 598,  722, 753,  900, 931,
  536, 567,  753, 784,  873, 904,  901, 932,  814, 845,  844, 875,  902, 933,
  505, 536,  784, 815,  661, 692,  630, 661,  692, 723,  874, 905,  599, 630,
  723, 754,  903, 934,  845, 876,  568, 599,  754, 785,  928, 928,  815, 846,
  929, 960,  930, 961,  875, 906,  904, 935,  931, 962,  537, 568,  785, 816,
  932, 963,  905, 936,  662, 693,  693, 724,  846, 877,  933, 964,  876, 907,
  631, 662,  724, 755,  506, 537,  816, 847,  934, 965,  600, 631,  755, 786,
  906, 937,  569, 600,  786, 817,  935, 966,  877, 908,  847, 878,  960, 960,
  907, 938,  961, 992,  936, 967,  538, 569,  817, 848,  962, 993,  694, 725,
  663, 694,  725, 756,  963, 994,  632, 663,  756, 787,  964, 995,  878, 909,
  937, 968,  507, 538,  848, 879,  908, 939,  601, 632,  787, 818,  965, 996,
  966, 997,  570, 601,  818, 849,  938, 969,  879, 910,  909, 940,  967, 998,
  695, 726,  726, 757,  664, 695,  757, 788,  539, 570,  849, 880,  939, 970,
  633, 664,  788, 819,  968, 999,  602, 633,  819, 850,  910, 941,  508, 539,
  880, 911,  969, 1000, 940, 971,  571, 602,  850, 881,  727, 758,  696, 727,
  758, 789,  970, 1001, 665, 696,  789, 820,  911, 942,  941, 972,  540, 571,
  881, 912,  634, 665,  820, 851,  971, 1002, 603, 634,  851, 882,  942, 973,
  509, 540,  912, 943,  728, 759,  759, 790,  972, 1003, 572, 603,  882, 913,
  697, 728,  790, 821,  666, 697,  821, 852,  943, 974,  635, 666,  852, 883,
  541, 572,  913, 944,  973, 1004, 604, 635,  883, 914,  760, 791,  729, 760,
  791, 822,  510, 541,  944, 975,  974, 1005, 698, 729,  822, 853,  573, 604,
  914, 945,  667, 698,  853, 884,  636, 667,  884, 915,  975, 1006, 542, 573,
  945, 976,  761, 792,  792, 823,  605, 636,  915, 946,  730, 761,  823, 854,
  699, 730,  854, 885,  511, 542,  976, 1007, 574, 605,  946, 977,  668, 699,
  885, 916,  637, 668,  916, 947,  543, 574,  793, 824,  977, 1008, 762, 793,
  824, 855,  731, 762,  855, 886,  606, 637,  947, 978,  700, 731,  886, 917,
  669, 700,  917, 948,  575, 606,  978, 1009, 638, 669,  948, 979,  794, 825,
  825, 856,  763, 794,  856, 887,  732, 763,  887, 918,  607, 638,  979, 1010,
  701, 732,  918, 949,  670, 701,  949, 980,  826, 857,  795, 826,  857, 888,
  764, 795,  888, 919,  639, 670,  980, 1011, 733, 764,  919, 950,  702, 733,
  950, 981,  671, 702,  981, 1012, 827, 858,  858, 889,  796, 827,  889, 920,
  765, 796,  920, 951,  734, 765,  951, 982,  703, 734,  982, 1013, 859, 890,
  828, 859,  890, 921,  797, 828,  921, 952,  766, 797,  952, 983,  735, 766,
  983, 1014, 860, 891,  891, 922,  829, 860,  922, 953,  798, 829,  953, 984,
  767, 798,  984, 1015, 892, 923,  861, 892,  923, 954,  830, 861,  954, 985,
  799, 830,  985, 1016, 893, 924,  924, 955,  862, 893,  955, 986,  831, 862,
  986, 1017, 925, 956,  894, 925,  956, 987,  863, 894,  987, 1018, 926, 957,
  957, 988,  895, 926,  988, 1019, 958, 989,  927, 958,  989, 1020, 959, 990,
  990, 1021, 991, 1022, 0,   0
};

DECLARE_ALIGNED(16, static const int16_t,
                qtr_scan_32x32_neighbors[1025 * MAX_NEIGHBORS]) = {
  0,   0,    0,   0,    0,   0,    1,   32,   1,   1,    32,  32,   2,   33,
  33,  64,   34,  65,   2,   2,    64,  64,   3,   34,   65,  96,   35,  66,
  66,  97,   3,   3,    96,  96,   4,   35,   97,  128,  67,  98,   36,  67,
  98,  129,  4,   4,    68,  99,   99,  130,  128, 128,  5,   36,   129, 160,
  37,  68,   130, 161,  100, 131,  69,  100,  131, 162,  5,   5,    160, 160,
  6,   37,   161, 192,  38,  69,   162, 193,  101, 132,  132, 163,  70,  101,
  163, 194,  6,   6,    192, 192,  7,   38,   133, 164,  193, 224,  102, 133,
  164, 195,  39,  70,   194, 225,  71,  102,  195, 226,  134, 165,  165, 196,
  7,   7,    224, 224,  8,   39,   103, 134,  196, 227,  225, 256,  40,  71,
  226, 257,  166, 197,  72,  103,  227, 258,  135, 166,  197, 228,  104, 135,
  228, 259,  8,   8,    256, 256,  9,   40,   257, 288,  41,  72,   167, 198,
  198, 229,  258, 289,  136, 167,  229, 260,  73,  104,  259, 290,  105, 136,
  260, 291,  199, 230,  9,   9,    168, 199,  230, 261,  288, 288,  10,  41,
  289, 320,  42,  73,   290, 321,  137, 168,  261, 292,  74,  105,  291, 322,
  200, 231,  231, 262,  106, 137,  292, 323,  169, 200,  262, 293,  10,  10,
  320, 320,  11,  42,   321, 352,  43,  74,   138, 169,  293, 324,  322, 353,
  232, 263,  75,  106,  201, 232,  263, 294,  323, 354,  170, 201,  294, 325,
  107, 138,  324, 355,  11,  11,   352, 352,  12,  43,   233, 264,  264, 295,
  353, 384,  139, 170,  325, 356,  44,  75,   354, 385,  202, 233,  295, 326,
  76,  107,  355, 386,  171, 202,  326, 357,  108, 139,  356, 387,  265, 296,
  234, 265,  296, 327,  12,  12,   140, 171,  357, 388,  384, 384,  13,  44,
  203, 234,  327, 358,  385, 416,  45,  76,   386, 417,  77,  108,  387, 418,
  172, 203,  358, 389,  266, 297,  297, 328,  109, 140,  235, 266,  328, 359,
  388, 419,  204, 235,  359, 390,  141, 172,  389, 420,  13,  13,   416, 416,
  14,  45,   417, 448,  46,  77,   298, 329,  418, 449,  267, 298,  329, 360,
  78,  109,  173, 204,  390, 421,  419, 450,  236, 267,  360, 391,  110, 141,
  420, 451,  205, 236,  391, 422,  142, 173,  299, 330,  330, 361,  421, 452,
  14,  14,   268, 299,  361, 392,  448, 448,  15,  46,   449, 480,  47,  78,
  450, 481,  174, 205,  422, 453,  237, 268,  392, 423,  79,  110,  451, 482,
  111, 142,  452, 483,  331, 362,  300, 331,  362, 393,  206, 237,  423, 454,
  143, 174,  269, 300,  393, 424,  453, 484,  238, 269,  424, 455,  175, 206,
  454, 485,  332, 363,  363, 394,  301, 332,  394, 425,  207, 238,  455, 486,
  270, 301,  425, 456,  364, 395,  239, 270,  456, 487,  333, 364,  395, 426,
  302, 333,  426, 457,  271, 302,  457, 488,  365, 396,  396, 427,  334, 365,
  427, 458,  303, 334,  458, 489,  397, 428,  366, 397,  428, 459,  335, 366,
  459, 490,  398, 429,  429, 460,  367, 398,  460, 491,  430, 461,  399, 430,
  461, 492,  431, 462,  462, 493,  463, 494,  15,  15,   480, 480,  16,  47,
  481, 512,  48,  79,   482, 513,  80,  111,  483, 514,  112, 143,  484, 515,
  144, 175,  485, 516,  16,  16,   512, 512,  17,  48,   513, 544,  176, 207,
  486, 517,  49,  80,   514, 545,  81,  112,  515, 546,  113, 144,  208, 239,
  487, 518,  516, 547,  145, 176,  517, 548,  240, 271,  488, 519,  17,  17,
  544, 544,  18,  49,   177, 208,  518, 549,  545, 576,  50,  81,   546, 577,
  82,  113,  547, 578,  272, 303,  489, 520,  209, 240,  519, 550,  114, 145,
  548, 579,  146, 177,  549, 580,  241, 272,  520, 551,  304, 335,  490, 521,
  178, 209,  550, 581,  18,  18,   576, 576,  19,  50,   577, 608,  51,  82,
  578, 609,  83,  114,  273, 304,  521, 552,  579, 610,  210, 241,  551, 582,
  115, 146,  336, 367,  491, 522,  580, 611,  147, 178,  581, 612,  242, 273,
  552, 583,  305, 336,  522, 553,  179, 210,  582, 613,  19,  19,   368, 399,
  492, 523,  608, 608,  20,  51,   609, 640,  52,  83,   610, 641,  274, 305,
  553, 584,  84,  115,  611, 642,  211, 242,  337, 368,  523, 554,  583, 614,
  116, 147,  612, 643,  306, 337,  554, 585,  148, 179,  243, 274,  400, 431,
  493, 524,  584, 615,  613, 644,  369, 400,  524, 555,  180, 211,  614, 645,
  20,  20,   640, 640,  21,  52,   275, 306,  585, 616,  641, 672,  53,  84,
  338, 369,  555, 586,  642, 673,  212, 243,  615, 646,  85,  116,  643, 674,
  432, 463,  494, 525,  117, 148,  644, 675,  401, 432,  525, 556,  307, 338,
  586, 617,  244, 275,  616, 647,  149, 180,  645, 676,  370, 401,  556, 587,
  181, 212,  646, 677,  276, 307,  464, 495,  495, 526,  617, 648,  339, 370,
  587, 618,  21,  21,   672, 672,  22,  53,   433, 464,  526, 557,  673, 704,
  54,  85,   674, 705,  213, 244,  647, 678,  86,  117,  402, 433,  557, 588,
  675, 706,  118, 149,  308, 339,  618, 649,  676, 707,  245, 276,  371, 402,
  588, 619,  648, 679,  150, 181,  677, 708,  496, 527,  465, 496,  527, 558,
  182, 213,  434, 465,  558, 589,  678, 709,  340, 371,  619, 650,  277, 308,
  649, 680,  22,  22,   704, 704,  23,  54,   403, 434,  589, 620,  705, 736,
  55,  86,   214, 245,  679, 710,  706, 737,  87,  118,  707, 738,  309, 340,
  650, 681,  372, 403,  620, 651,  119, 150,  497, 528,  528, 559,  708, 739,
  246, 277,  680, 711,  466, 497,  559, 590,  151, 182,  709, 740,  435, 466,
  590, 621,  341, 372,  651, 682,  183, 214,  278, 309,  681, 712,  710, 741,
  404, 435,  621, 652,  23,  23,   736, 736,  24,  55,   737, 768,  215, 246,
  529, 560,  711, 742,  56,  87,   498, 529,  560, 591,  738, 769,  310, 341,
  682, 713,  88,  119,  373, 404,  652, 683,  739, 770,  467, 498,  591, 622,
  120, 151,  740, 771,  247, 278,  712, 743,  436, 467,  622, 653,  152, 183,
  741, 772,  342, 373,  683, 714,  279, 310,  405, 436,  653, 684,  713, 744,
  184, 215,  742, 773,  530, 561,  561, 592,  499, 530,  592, 623,  24,  24,
  216, 247,  468, 499,  623, 654,  743, 774,  768, 768,  25,  56,   769, 800,
  374, 405,  684, 715,  57,  88,   311, 342,  714, 745,  770, 801,  89,  120,
  771, 802,  437, 468,  654, 685,  248, 279,  744, 775,  121, 152,  772, 803,
  562, 593,  153, 184,  343, 374,  531, 562,  593, 624,  715, 746,  773, 804,
  406, 437,  685, 716,  500, 531,  624, 655,  280, 311,  745, 776,  185, 216,
  774, 805,  469, 500,  655, 686,  375, 406,  716, 747,  217, 248,  775, 806,
  25,  25,   312, 343,  746, 777,  800, 800,  26,  57,   801, 832,  58,  89,
  438, 469,  686, 717,  802, 833,  90,  121,  563, 594,  594, 625,  803, 834,
  249, 280,  532, 563,  625, 656,  776, 807,  122, 153,  804, 835,  344, 375,
  501, 532,  656, 687,  747, 778,  407, 438,  717, 748,  154, 185,  805, 836,
  281, 312,  777, 808,  470, 501,  687, 718,  186, 217,  806, 837,  376, 407,
  748, 779,  595, 626,  564, 595,  626, 657,  218, 249,  313, 344,  439, 470,
  718, 749,  778, 809,  807, 838,  26,  26,   832, 832,  27,  58,   533, 564,
  657, 688,  833, 864,  59,  90,   834, 865,  91,  122,  835, 866,  250, 281,
  502, 533,  688, 719,  808, 839,  123, 154,  408, 439,  749, 780,  836, 867,
  345, 376,  779, 810,  155, 186,  471, 502,  719, 750,  837, 868,  282, 313,
  809, 840,  596, 627,  627, 658,  187, 218,  565, 596,  658, 689,  838, 869,
  377, 408,  780, 811,  440, 471,  750, 781,  534, 565,  689, 720,  314, 345,
  810, 841,  219, 250,  839, 870,  27,  27,   864, 864,  28,  59,   503, 534,
  720, 751,  865, 896,  60,  91,   866, 897,  92,  123,  251, 282,  840, 871,
  867, 898,  409, 440,  781, 812,  346, 377,  811, 842,  124, 155,  628, 659,
  868, 899,  472, 503,  751, 782,  597, 628,  659, 690,  566, 597,  690, 721,
  156, 187,  869, 900,  283, 314,  841, 872,  535, 566,  721, 752,  188, 219,
  378, 409,  812, 843,  870, 901,  441, 472,  782, 813,  315, 346,  842, 873,
  504, 535,  752, 783,  220, 251,  871, 902,  28,  28,   629, 660,  660, 691,
  896, 896,  29,  60,   897, 928,  61,  92,   410, 441,  598, 629,  691, 722,
  813, 844,  898, 929,  252, 283,  872, 903,  93,  124,  347, 378,  473, 504,
  783, 814,  843, 874,  899, 930,  567, 598,  722, 753,  125, 156,  900, 931,
  284, 315,  536, 567,  753, 784,  873, 904,  157, 188,  901, 932,  442, 473,
  814, 845,  379, 410,  844, 875,  189, 220,  902, 933,  505, 536,  784, 815,
  661, 692,  316, 347,  630, 661,  692, 723,  874, 905,  221, 252,  599, 630,
  723, 754,  903, 934,  411, 442,  845, 876,  29,  29,   568, 599,  754, 785,
  928, 928,  30,  61,   474, 505,  815, 846,  929, 960,  62,  93,   930, 961,
  253, 284,  348, 379,  875, 906,  904, 935,  94,  125,  931, 962,  537, 568,
  785, 816,  126, 157,  932, 963,  285, 316,  905, 936,  158, 189,  443, 474,
  662, 693,  693, 724,  846, 877,  933, 964,  380, 411,  876, 907,  631, 662,
  724, 755,  506, 537,  816, 847,  190, 221,  934, 965,  600, 631,  755, 786,
  317, 348,  906, 937,  222, 253,  569, 600,  786, 817,  935, 966,  412, 443,
  877, 908,  475, 506,  847, 878,  30,  30,   960, 960,  31,  62,   349, 380,
  907, 938,  961, 992,  254, 285,  936, 967,  63,  94,   538, 569,  817, 848,
  962, 993,  694, 725,  95,  126,  663, 694,  725, 756,  963, 994,  632, 663,
  756, 787,  127, 158,  964, 995,  444, 475,  878, 909,  286, 317,  937, 968,
  381, 412,  507, 538,  848, 879,  908, 939,  159, 190,  601, 632,  787, 818,
  965, 996,  191, 222,  966, 997,  318, 349,  570, 601,  818, 849,  938, 969,
  476, 507,  879, 910,  223, 254,  413, 444,  909, 940,  967, 998,  695, 726,
  726, 757,  664, 695,  757, 788,  539, 570,  849, 880,  350, 381,  939, 970,
  255, 286,  633, 664,  788, 819,  968, 999,  445, 476,  602, 633,  819, 850,
  910, 941,  508, 539,  880, 911,  287, 318,  969, 1000, 382, 413,  940, 971,
  571, 602,  850, 881,  727, 758,  696, 727,  758, 789,  319, 350,  970, 1001,
  477, 508,  665, 696,  789, 820,  911, 942,  414, 445,  941, 972,  540, 571,
  881, 912,  634, 665,  820, 851,  351, 382,  971, 1002, 603, 634,  851, 882,
  446, 477,  942, 973,  509, 540,  912, 943,  383, 414,  728, 759,  759, 790,
  972, 1003, 572, 603,  882, 913,  697, 728,  790, 821,  666, 697,  821, 852,
  478, 509,  943, 974,  635, 666,  852, 883,  415, 446,  541, 572,  913, 944,
  973, 1004, 604, 635,  883, 914,  760, 791,  729, 760,  791, 822,  510, 541,
  944, 975,  447, 478,  974, 1005, 698, 729,  822, 853,  573, 604,  914, 945,
  667, 698,  853, 884,  636, 667,  884, 915,  479, 510,  975, 1006, 542, 573,
  945, 976,  761, 792,  792, 823,  605, 636,  915, 946,  730, 761,  823, 854,
  699, 730,  854, 885,  511, 542,  976, 1007, 574, 605,  946, 977,  668, 699,
  885, 916,  637, 668,  916, 947,  543, 574,  793, 824,  977, 1008, 762, 793,
  824, 855,  731, 762,  855, 886,  606, 637,  947, 978,  700, 731,  886, 917,
  669, 700,  917, 948,  575, 606,  978, 1009, 638, 669,  948, 979,  794, 825,
  825, 856,  763, 794,  856, 887,  732, 763,  887, 918,  607, 638,  979, 1010,
  701, 732,  918, 949,  670, 701,  949, 980,  826, 857,  795, 826,  857, 888,
  764, 795,  888, 919,  639, 670,  980, 1011, 733, 764,  919, 950,  702, 733,
  950, 981,  671, 702,  981, 1012, 827, 858,  858, 889,  796, 827,  889, 920,
  765, 796,  920, 951,  734, 765,  951, 982,  703, 734,  982, 1013, 859, 890,
  828, 859,  890, 921,  797, 828,  921, 952,  766, 797,  952, 983,  735, 766,
  983, 1014, 860, 891,  891, 922,  829, 860,  922, 953,  798, 829,  953, 984,
  767, 798,  984, 1015, 892, 923,  861, 892,  923, 954,  830, 861,  954, 985,
  799, 830,  985, 1016, 893, 924,  924, 955,  862, 893,  955, 986,  831, 862,
  986, 1017, 925, 956,  894, 925,  956, 987,  863, 894,  987, 1018, 926, 957,
  957, 988,  895, 926,  988, 1019, 958, 989,  927, 958,  989, 1020, 959, 990,
  990, 1021, 991, 1022, 0,   0
};

#if CONFIG_TX64X64
DECLARE_ALIGNED(16, static const int16_t,
                default_scan_32x64_neighbors[2049 * MAX_NEIGHBORS]) = {
  0,    0,    0,    0,    0,    0,    1,    1,    1,    32,   32,   32,   2,
  2,    2,    33,   33,   64,   64,   64,   3,    3,    3,    34,   34,   65,
  65,   96,   96,   96,   4,    4,    4,    35,   35,   66,   66,   97,   97,
  128,  128,  128,  5,    5,    5,    36,   36,   67,   67,   98,   98,   129,
  129,  160,  160,  160,  6,    6,    6,    37,   37,   68,   68,   99,   99,
  130,  130,  161,  161,  192,  192,  192,  7,    7,    7,    38,   38,   69,
  69,   100,  100,  131,  131,  162,  162,  193,  193,  224,  224,  224,  8,
  8,    8,    39,   39,   70,   70,   101,  101,  132,  132,  163,  163,  194,
  194,  225,  225,  256,  256,  256,  9,    9,    9,    40,   40,   71,   71,
  102,  102,  133,  133,  164,  164,  195,  195,  226,  226,  257,  257,  288,
  288,  288,  10,   10,   10,   41,   41,   72,   72,   103,  103,  134,  134,
  165,  165,  196,  196,  227,  227,  258,  258,  289,  289,  320,  320,  320,
  11,   11,   11,   42,   42,   73,   73,   104,  104,  135,  135,  166,  166,
  197,  197,  228,  228,  259,  259,  290,  290,  321,  321,  352,  352,  352,
  12,   12,   12,   43,   43,   74,   74,   105,  105,  136,  136,  167,  167,
  198,  198,  229,  229,  260,  260,  291,  291,  322,  322,  353,  353,  384,
  384,  384,  13,   13,   13,   44,   44,   75,   75,   106,  106,  137,  137,
  168,  168,  199,  199,  230,  230,  261,  261,  292,  292,  323,  323,  354,
  354,  385,  385,  416,  416,  416,  14,   14,   14,   45,   45,   76,   76,
  107,  107,  138,  138,  169,  169,  200,  200,  231,  231,  262,  262,  293,
  293,  324,  324,  355,  355,  386,  386,  417,  417,  448,  448,  448,  15,
  15,   15,   46,   46,   77,   77,   108,  108,  139,  139,  170,  170,  201,
  201,  232,  232,  263,  263,  294,  294,  325,  325,  356,  356,  387,  387,
  418,  418,  449,  449,  480,  480,  480,  16,   16,   16,   47,   47,   78,
  78,   109,  109,  140,  140,  171,  171,  202,  202,  233,  233,  264,  264,
  295,  295,  326,  326,  357,  357,  388,  388,  419,  419,  450,  450,  481,
  481,  512,  512,  512,  17,   17,   17,   48,   48,   79,   79,   110,  110,
  141,  141,  172,  172,  203,  203,  234,  234,  265,  265,  296,  296,  327,
  327,  358,  358,  389,  389,  420,  420,  451,  451,  482,  482,  513,  513,
  544,  544,  544,  18,   18,   18,   49,   49,   80,   80,   111,  111,  142,
  142,  173,  173,  204,  204,  235,  235,  266,  266,  297,  297,  328,  328,
  359,  359,  390,  390,  421,  421,  452,  452,  483,  483,  514,  514,  545,
  545,  576,  576,  576,  19,   19,   19,   50,   50,   81,   81,   112,  112,
  143,  143,  174,  174,  205,  205,  236,  236,  267,  267,  298,  298,  329,
  329,  360,  360,  391,  391,  422,  422,  453,  453,  484,  484,  515,  515,
  546,  546,  577,  577,  608,  608,  608,  20,   20,   20,   51,   51,   82,
  82,   113,  113,  144,  144,  175,  175,  206,  206,  237,  237,  268,  268,
  299,  299,  330,  330,  361,  361,  392,  392,  423,  423,  454,  454,  485,
  485,  516,  516,  547,  547,  578,  578,  609,  609,  640,  640,  640,  21,
  21,   21,   52,   52,   83,   83,   114,  114,  145,  145,  176,  176,  207,
  207,  238,  238,  269,  269,  300,  300,  331,  331,  362,  362,  393,  393,
  424,  424,  455,  455,  486,  486,  517,  517,  548,  548,  579,  579,  610,
  610,  641,  641,  672,  672,  672,  22,   22,   22,   53,   53,   84,   84,
  115,  115,  146,  146,  177,  177,  208,  208,  239,  239,  270,  270,  301,
  301,  332,  332,  363,  363,  394,  394,  425,  425,  456,  456,  487,  487,
  518,  518,  549,  549,  580,  580,  611,  611,  642,  642,  673,  673,  704,
  704,  704,  23,   23,   23,   54,   54,   85,   85,   116,  116,  147,  147,
  178,  178,  209,  209,  240,  240,  271,  271,  302,  302,  333,  333,  364,
  364,  395,  395,  426,  426,  457,  457,  488,  488,  519,  519,  550,  550,
  581,  581,  612,  612,  643,  643,  674,  674,  705,  705,  736,  736,  736,
  24,   24,   24,   55,   55,   86,   86,   117,  117,  148,  148,  179,  179,
  210,  210,  241,  241,  272,  272,  303,  303,  334,  334,  365,  365,  396,
  396,  427,  427,  458,  458,  489,  489,  520,  520,  551,  551,  582,  582,
  613,  613,  644,  644,  675,  675,  706,  706,  737,  737,  768,  768,  768,
  25,   25,   25,   56,   56,   87,   87,   118,  118,  149,  149,  180,  180,
  211,  211,  242,  242,  273,  273,  304,  304,  335,  335,  366,  366,  397,
  397,  428,  428,  459,  459,  490,  490,  521,  521,  552,  552,  583,  583,
  614,  614,  645,  645,  676,  676,  707,  707,  738,  738,  769,  769,  800,
  800,  800,  26,   26,   26,   57,   57,   88,   88,   119,  119,  150,  150,
  181,  181,  212,  212,  243,  243,  274,  274,  305,  305,  336,  336,  367,
  367,  398,  398,  429,  429,  460,  460,  491,  491,  522,  522,  553,  553,
  584,  584,  615,  615,  646,  646,  677,  677,  708,  708,  739,  739,  770,
  770,  801,  801,  832,  832,  832,  27,   27,   27,   58,   58,   89,   89,
  120,  120,  151,  151,  182,  182,  213,  213,  244,  244,  275,  275,  306,
  306,  337,  337,  368,  368,  399,  399,  430,  430,  461,  461,  492,  492,
  523,  523,  554,  554,  585,  585,  616,  616,  647,  647,  678,  678,  709,
  709,  740,  740,  771,  771,  802,  802,  833,  833,  864,  864,  864,  28,
  28,   28,   59,   59,   90,   90,   121,  121,  152,  152,  183,  183,  214,
  214,  245,  245,  276,  276,  307,  307,  338,  338,  369,  369,  400,  400,
  431,  431,  462,  462,  493,  493,  524,  524,  555,  555,  586,  586,  617,
  617,  648,  648,  679,  679,  710,  710,  741,  741,  772,  772,  803,  803,
  834,  834,  865,  865,  896,  896,  896,  29,   29,   29,   60,   60,   91,
  91,   122,  122,  153,  153,  184,  184,  215,  215,  246,  246,  277,  277,
  308,  308,  339,  339,  370,  370,  401,  401,  432,  432,  463,  463,  494,
  494,  525,  525,  556,  556,  587,  587,  618,  618,  649,  649,  680,  680,
  711,  711,  742,  742,  773,  773,  804,  804,  835,  835,  866,  866,  897,
  897,  928,  928,  928,  30,   30,   30,   61,   61,   92,   92,   123,  123,
  154,  154,  185,  185,  216,  216,  247,  247,  278,  278,  309,  309,  340,
  340,  371,  371,  402,  402,  433,  433,  464,  464,  495,  495,  526,  526,
  557,  557,  588,  588,  619,  619,  650,  650,  681,  681,  712,  712,  743,
  743,  774,  774,  805,  805,  836,  836,  867,  867,  898,  898,  929,  929,
  960,  960,  960,  31,   62,   62,   93,   93,   124,  124,  155,  155,  186,
  186,  217,  217,  248,  248,  279,  279,  310,  310,  341,  341,  372,  372,
  403,  403,  434,  434,  465,  465,  496,  496,  527,  527,  558,  558,  589,
  589,  620,  620,  651,  651,  682,  682,  713,  713,  744,  744,  775,  775,
  806,  806,  837,  837,  868,  868,  899,  899,  930,  930,  961,  961,  992,
  992,  992,  63,   94,   94,   125,  125,  156,  156,  187,  187,  218,  218,
  249,  249,  280,  280,  311,  311,  342,  342,  373,  373,  404,  404,  435,
  435,  466,  466,  497,  497,  528,  528,  559,  559,  590,  590,  621,  621,
  652,  652,  683,  683,  714,  714,  745,  745,  776,  776,  807,  807,  838,
  838,  869,  869,  900,  900,  931,  931,  962,  962,  993,  993,  1024, 1024,
  1024, 95,   126,  126,  157,  157,  188,  188,  219,  219,  250,  250,  281,
  281,  312,  312,  343,  343,  374,  374,  405,  405,  436,  436,  467,  467,
  498,  498,  529,  529,  560,  560,  591,  591,  622,  622,  653,  653,  684,
  684,  715,  715,  746,  746,  777,  777,  808,  808,  839,  839,  870,  870,
  901,  901,  932,  932,  963,  963,  994,  994,  1025, 1025, 1056, 1056, 1056,
  127,  158,  158,  189,  189,  220,  220,  251,  251,  282,  282,  313,  313,
  344,  344,  375,  375,  406,  406,  437,  437,  468,  468,  499,  499,  530,
  530,  561,  561,  592,  592,  623,  623,  654,  654,  685,  685,  716,  716,
  747,  747,  778,  778,  809,  809,  840,  840,  871,  871,  902,  902,  933,
  933,  964,  964,  995,  995,  1026, 1026, 1057, 1057, 1088, 1088, 1088, 159,
  190,  190,  221,  221,  252,  252,  283,  283,  314,  314,  345,  345,  376,
  376,  407,  407,  438,  438,  469,  469,  500,  500,  531,  531,  562,  562,
  593,  593,  624,  624,  655,  655,  686,  686,  717,  717,  748,  748,  779,
  779,  810,  810,  841,  841,  872,  872,  903,  903,  934,  934,  965,  965,
  996,  996,  1027, 1027, 1058, 1058, 1089, 1089, 1120, 1120, 1120, 191,  222,
  222,  253,  253,  284,  284,  315,  315,  346,  346,  377,  377,  408,  408,
  439,  439,  470,  470,  501,  501,  532,  532,  563,  563,  594,  594,  625,
  625,  656,  656,  687,  687,  718,  718,  749,  749,  780,  780,  811,  811,
  842,  842,  873,  873,  904,  904,  935,  935,  966,  966,  997,  997,  1028,
  1028, 1059, 1059, 1090, 1090, 1121, 1121, 1152, 1152, 1152, 223,  254,  254,
  285,  285,  316,  316,  347,  347,  378,  378,  409,  409,  440,  440,  471,
  471,  502,  502,  533,  533,  564,  564,  595,  595,  626,  626,  657,  657,
  688,  688,  719,  719,  750,  750,  781,  781,  812,  812,  843,  843,  874,
  874,  905,  905,  936,  936,  967,  967,  998,  998,  1029, 1029, 1060, 1060,
  1091, 1091, 1122, 1122, 1153, 1153, 1184, 1184, 1184, 255,  286,  286,  317,
  317,  348,  348,  379,  379,  410,  410,  441,  441,  472,  472,  503,  503,
  534,  534,  565,  565,  596,  596,  627,  627,  658,  658,  689,  689,  720,
  720,  751,  751,  782,  782,  813,  813,  844,  844,  875,  875,  906,  906,
  937,  937,  968,  968,  999,  999,  1030, 1030, 1061, 1061, 1092, 1092, 1123,
  1123, 1154, 1154, 1185, 1185, 1216, 1216, 1216, 287,  318,  318,  349,  349,
  380,  380,  411,  411,  442,  442,  473,  473,  504,  504,  535,  535,  566,
  566,  597,  597,  628,  628,  659,  659,  690,  690,  721,  721,  752,  752,
  783,  783,  814,  814,  845,  845,  876,  876,  907,  907,  938,  938,  969,
  969,  1000, 1000, 1031, 1031, 1062, 1062, 1093, 1093, 1124, 1124, 1155, 1155,
  1186, 1186, 1217, 1217, 1248, 1248, 1248, 319,  350,  350,  381,  381,  412,
  412,  443,  443,  474,  474,  505,  505,  536,  536,  567,  567,  598,  598,
  629,  629,  660,  660,  691,  691,  722,  722,  753,  753,  784,  784,  815,
  815,  846,  846,  877,  877,  908,  908,  939,  939,  970,  970,  1001, 1001,
  1032, 1032, 1063, 1063, 1094, 1094, 1125, 1125, 1156, 1156, 1187, 1187, 1218,
  1218, 1249, 1249, 1280, 1280, 1280, 351,  382,  382,  413,  413,  444,  444,
  475,  475,  506,  506,  537,  537,  568,  568,  599,  599,  630,  630,  661,
  661,  692,  692,  723,  723,  754,  754,  785,  785,  816,  816,  847,  847,
  878,  878,  909,  909,  940,  940,  971,  971,  1002, 1002, 1033, 1033, 1064,
  1064, 1095, 1095, 1126, 1126, 1157, 1157, 1188, 1188, 1219, 1219, 1250, 1250,
  1281, 1281, 1312, 1312, 1312, 383,  414,  414,  445,  445,  476,  476,  507,
  507,  538,  538,  569,  569,  600,  600,  631,  631,  662,  662,  693,  693,
  724,  724,  755,  755,  786,  786,  817,  817,  848,  848,  879,  879,  910,
  910,  941,  941,  972,  972,  1003, 1003, 1034, 1034, 1065, 1065, 1096, 1096,
  1127, 1127, 1158, 1158, 1189, 1189, 1220, 1220, 1251, 1251, 1282, 1282, 1313,
  1313, 1344, 1344, 1344, 415,  446,  446,  477,  477,  508,  508,  539,  539,
  570,  570,  601,  601,  632,  632,  663,  663,  694,  694,  725,  725,  756,
  756,  787,  787,  818,  818,  849,  849,  880,  880,  911,  911,  942,  942,
  973,  973,  1004, 1004, 1035, 1035, 1066, 1066, 1097, 1097, 1128, 1128, 1159,
  1159, 1190, 1190, 1221, 1221, 1252, 1252, 1283, 1283, 1314, 1314, 1345, 1345,
  1376, 1376, 1376, 447,  478,  478,  509,  509,  540,  540,  571,  571,  602,
  602,  633,  633,  664,  664,  695,  695,  726,  726,  757,  757,  788,  788,
  819,  819,  850,  850,  881,  881,  912,  912,  943,  943,  974,  974,  1005,
  1005, 1036, 1036, 1067, 1067, 1098, 1098, 1129, 1129, 1160, 1160, 1191, 1191,
  1222, 1222, 1253, 1253, 1284, 1284, 1315, 1315, 1346, 1346, 1377, 1377, 1408,
  1408, 1408, 479,  510,  510,  541,  541,  572,  572,  603,  603,  634,  634,
  665,  665,  696,  696,  727,  727,  758,  758,  789,  789,  820,  820,  851,
  851,  882,  882,  913,  913,  944,  944,  975,  975,  1006, 1006, 1037, 1037,
  1068, 1068, 1099, 1099, 1130, 1130, 1161, 1161, 1192, 1192, 1223, 1223, 1254,
  1254, 1285, 1285, 1316, 1316, 1347, 1347, 1378, 1378, 1409, 1409, 1440, 1440,
  1440, 511,  542,  542,  573,  573,  604,  604,  635,  635,  666,  666,  697,
  697,  728,  728,  759,  759,  790,  790,  821,  821,  852,  852,  883,  883,
  914,  914,  945,  945,  976,  976,  1007, 1007, 1038, 1038, 1069, 1069, 1100,
  1100, 1131, 1131, 1162, 1162, 1193, 1193, 1224, 1224, 1255, 1255, 1286, 1286,
  1317, 1317, 1348, 1348, 1379, 1379, 1410, 1410, 1441, 1441, 1472, 1472, 1472,
  543,  574,  574,  605,  605,  636,  636,  667,  667,  698,  698,  729,  729,
  760,  760,  791,  791,  822,  822,  853,  853,  884,  884,  915,  915,  946,
  946,  977,  977,  1008, 1008, 1039, 1039, 1070, 1070, 1101, 1101, 1132, 1132,
  1163, 1163, 1194, 1194, 1225, 1225, 1256, 1256, 1287, 1287, 1318, 1318, 1349,
  1349, 1380, 1380, 1411, 1411, 1442, 1442, 1473, 1473, 1504, 1504, 1504, 575,
  606,  606,  637,  637,  668,  668,  699,  699,  730,  730,  761,  761,  792,
  792,  823,  823,  854,  854,  885,  885,  916,  916,  947,  947,  978,  978,
  1009, 1009, 1040, 1040, 1071, 1071, 1102, 1102, 1133, 1133, 1164, 1164, 1195,
  1195, 1226, 1226, 1257, 1257, 1288, 1288, 1319, 1319, 1350, 1350, 1381, 1381,
  1412, 1412, 1443, 1443, 1474, 1474, 1505, 1505, 1536, 1536, 1536, 607,  638,
  638,  669,  669,  700,  700,  731,  731,  762,  762,  793,  793,  824,  824,
  855,  855,  886,  886,  917,  917,  948,  948,  979,  979,  1010, 1010, 1041,
  1041, 1072, 1072, 1103, 1103, 1134, 1134, 1165, 1165, 1196, 1196, 1227, 1227,
  1258, 1258, 1289, 1289, 1320, 1320, 1351, 1351, 1382, 1382, 1413, 1413, 1444,
  1444, 1475, 1475, 1506, 1506, 1537, 1537, 1568, 1568, 1568, 639,  670,  670,
  701,  701,  732,  732,  763,  763,  794,  794,  825,  825,  856,  856,  887,
  887,  918,  918,  949,  949,  980,  980,  1011, 1011, 1042, 1042, 1073, 1073,
  1104, 1104, 1135, 1135, 1166, 1166, 1197, 1197, 1228, 1228, 1259, 1259, 1290,
  1290, 1321, 1321, 1352, 1352, 1383, 1383, 1414, 1414, 1445, 1445, 1476, 1476,
  1507, 1507, 1538, 1538, 1569, 1569, 1600, 1600, 1600, 671,  702,  702,  733,
  733,  764,  764,  795,  795,  826,  826,  857,  857,  888,  888,  919,  919,
  950,  950,  981,  981,  1012, 1012, 1043, 1043, 1074, 1074, 1105, 1105, 1136,
  1136, 1167, 1167, 1198, 1198, 1229, 1229, 1260, 1260, 1291, 1291, 1322, 1322,
  1353, 1353, 1384, 1384, 1415, 1415, 1446, 1446, 1477, 1477, 1508, 1508, 1539,
  1539, 1570, 1570, 1601, 1601, 1632, 1632, 1632, 703,  734,  734,  765,  765,
  796,  796,  827,  827,  858,  858,  889,  889,  920,  920,  951,  951,  982,
  982,  1013, 1013, 1044, 1044, 1075, 1075, 1106, 1106, 1137, 1137, 1168, 1168,
  1199, 1199, 1230, 1230, 1261, 1261, 1292, 1292, 1323, 1323, 1354, 1354, 1385,
  1385, 1416, 1416, 1447, 1447, 1478, 1478, 1509, 1509, 1540, 1540, 1571, 1571,
  1602, 1602, 1633, 1633, 1664, 1664, 1664, 735,  766,  766,  797,  797,  828,
  828,  859,  859,  890,  890,  921,  921,  952,  952,  983,  983,  1014, 1014,
  1045, 1045, 1076, 1076, 1107, 1107, 1138, 1138, 1169, 1169, 1200, 1200, 1231,
  1231, 1262, 1262, 1293, 1293, 1324, 1324, 1355, 1355, 1386, 1386, 1417, 1417,
  1448, 1448, 1479, 1479, 1510, 1510, 1541, 1541, 1572, 1572, 1603, 1603, 1634,
  1634, 1665, 1665, 1696, 1696, 1696, 767,  798,  798,  829,  829,  860,  860,
  891,  891,  922,  922,  953,  953,  984,  984,  1015, 1015, 1046, 1046, 1077,
  1077, 1108, 1108, 1139, 1139, 1170, 1170, 1201, 1201, 1232, 1232, 1263, 1263,
  1294, 1294, 1325, 1325, 1356, 1356, 1387, 1387, 1418, 1418, 1449, 1449, 1480,
  1480, 1511, 1511, 1542, 1542, 1573, 1573, 1604, 1604, 1635, 1635, 1666, 1666,
  1697, 1697, 1728, 1728, 1728, 799,  830,  830,  861,  861,  892,  892,  923,
  923,  954,  954,  985,  985,  1016, 1016, 1047, 1047, 1078, 1078, 1109, 1109,
  1140, 1140, 1171, 1171, 1202, 1202, 1233, 1233, 1264, 1264, 1295, 1295, 1326,
  1326, 1357, 1357, 1388, 1388, 1419, 1419, 1450, 1450, 1481, 1481, 1512, 1512,
  1543, 1543, 1574, 1574, 1605, 1605, 1636, 1636, 1667, 1667, 1698, 1698, 1729,
  1729, 1760, 1760, 1760, 831,  862,  862,  893,  893,  924,  924,  955,  955,
  986,  986,  1017, 1017, 1048, 1048, 1079, 1079, 1110, 1110, 1141, 1141, 1172,
  1172, 1203, 1203, 1234, 1234, 1265, 1265, 1296, 1296, 1327, 1327, 1358, 1358,
  1389, 1389, 1420, 1420, 1451, 1451, 1482, 1482, 1513, 1513, 1544, 1544, 1575,
  1575, 1606, 1606, 1637, 1637, 1668, 1668, 1699, 1699, 1730, 1730, 1761, 1761,
  1792, 1792, 1792, 863,  894,  894,  925,  925,  956,  956,  987,  987,  1018,
  1018, 1049, 1049, 1080, 1080, 1111, 1111, 1142, 1142, 1173, 1173, 1204, 1204,
  1235, 1235, 1266, 1266, 1297, 1297, 1328, 1328, 1359, 1359, 1390, 1390, 1421,
  1421, 1452, 1452, 1483, 1483, 1514, 1514, 1545, 1545, 1576, 1576, 1607, 1607,
  1638, 1638, 1669, 1669, 1700, 1700, 1731, 1731, 1762, 1762, 1793, 1793, 1824,
  1824, 1824, 895,  926,  926,  957,  957,  988,  988,  1019, 1019, 1050, 1050,
  1081, 1081, 1112, 1112, 1143, 1143, 1174, 1174, 1205, 1205, 1236, 1236, 1267,
  1267, 1298, 1298, 1329, 1329, 1360, 1360, 1391, 1391, 1422, 1422, 1453, 1453,
  1484, 1484, 1515, 1515, 1546, 1546, 1577, 1577, 1608, 1608, 1639, 1639, 1670,
  1670, 1701, 1701, 1732, 1732, 1763, 1763, 1794, 1794, 1825, 1825, 1856, 1856,
  1856, 927,  958,  958,  989,  989,  1020, 1020, 1051, 1051, 1082, 1082, 1113,
  1113, 1144, 1144, 1175, 1175, 1206, 1206, 1237, 1237, 1268, 1268, 1299, 1299,
  1330, 1330, 1361, 1361, 1392, 1392, 1423, 1423, 1454, 1454, 1485, 1485, 1516,
  1516, 1547, 1547, 1578, 1578, 1609, 1609, 1640, 1640, 1671, 1671, 1702, 1702,
  1733, 1733, 1764, 1764, 1795, 1795, 1826, 1826, 1857, 1857, 1888, 1888, 1888,
  959,  990,  990,  1021, 1021, 1052, 1052, 1083, 1083, 1114, 1114, 1145, 1145,
  1176, 1176, 1207, 1207, 1238, 1238, 1269, 1269, 1300, 1300, 1331, 1331, 1362,
  1362, 1393, 1393, 1424, 1424, 1455, 1455, 1486, 1486, 1517, 1517, 1548, 1548,
  1579, 1579, 1610, 1610, 1641, 1641, 1672, 1672, 1703, 1703, 1734, 1734, 1765,
  1765, 1796, 1796, 1827, 1827, 1858, 1858, 1889, 1889, 1920, 1920, 1920, 991,
  1022, 1022, 1053, 1053, 1084, 1084, 1115, 1115, 1146, 1146, 1177, 1177, 1208,
  1208, 1239, 1239, 1270, 1270, 1301, 1301, 1332, 1332, 1363, 1363, 1394, 1394,
  1425, 1425, 1456, 1456, 1487, 1487, 1518, 1518, 1549, 1549, 1580, 1580, 1611,
  1611, 1642, 1642, 1673, 1673, 1704, 1704, 1735, 1735, 1766, 1766, 1797, 1797,
  1828, 1828, 1859, 1859, 1890, 1890, 1921, 1921, 1952, 1952, 1952, 1023, 1054,
  1054, 1085, 1085, 1116, 1116, 1147, 1147, 1178, 1178, 1209, 1209, 1240, 1240,
  1271, 1271, 1302, 1302, 1333, 1333, 1364, 1364, 1395, 1395, 1426, 1426, 1457,
  1457, 1488, 1488, 1519, 1519, 1550, 1550, 1581, 1581, 1612, 1612, 1643, 1643,
  1674, 1674, 1705, 1705, 1736, 1736, 1767, 1767, 1798, 1798, 1829, 1829, 1860,
  1860, 1891, 1891, 1922, 1922, 1953, 1953, 1984, 1984, 1984, 1055, 1086, 1086,
  1117, 1117, 1148, 1148, 1179, 1179, 1210, 1210, 1241, 1241, 1272, 1272, 1303,
  1303, 1334, 1334, 1365, 1365, 1396, 1396, 1427, 1427, 1458, 1458, 1489, 1489,
  1520, 1520, 1551, 1551, 1582, 1582, 1613, 1613, 1644, 1644, 1675, 1675, 1706,
  1706, 1737, 1737, 1768, 1768, 1799, 1799, 1830, 1830, 1861, 1861, 1892, 1892,
  1923, 1923, 1954, 1954, 1985, 1985, 2016, 1087, 1118, 1118, 1149, 1149, 1180,
  1180, 1211, 1211, 1242, 1242, 1273, 1273, 1304, 1304, 1335, 1335, 1366, 1366,
  1397, 1397, 1428, 1428, 1459, 1459, 1490, 1490, 1521, 1521, 1552, 1552, 1583,
  1583, 1614, 1614, 1645, 1645, 1676, 1676, 1707, 1707, 1738, 1738, 1769, 1769,
  1800, 1800, 1831, 1831, 1862, 1862, 1893, 1893, 1924, 1924, 1955, 1955, 1986,
  1986, 2017, 1119, 1150, 1150, 1181, 1181, 1212, 1212, 1243, 1243, 1274, 1274,
  1305, 1305, 1336, 1336, 1367, 1367, 1398, 1398, 1429, 1429, 1460, 1460, 1491,
  1491, 1522, 1522, 1553, 1553, 1584, 1584, 1615, 1615, 1646, 1646, 1677, 1677,
  1708, 1708, 1739, 1739, 1770, 1770, 1801, 1801, 1832, 1832, 1863, 1863, 1894,
  1894, 1925, 1925, 1956, 1956, 1987, 1987, 2018, 1151, 1182, 1182, 1213, 1213,
  1244, 1244, 1275, 1275, 1306, 1306, 1337, 1337, 1368, 1368, 1399, 1399, 1430,
  1430, 1461, 1461, 1492, 1492, 1523, 1523, 1554, 1554, 1585, 1585, 1616, 1616,
  1647, 1647, 1678, 1678, 1709, 1709, 1740, 1740, 1771, 1771, 1802, 1802, 1833,
  1833, 1864, 1864, 1895, 1895, 1926, 1926, 1957, 1957, 1988, 1988, 2019, 1183,
  1214, 1214, 1245, 1245, 1276, 1276, 1307, 1307, 1338, 1338, 1369, 1369, 1400,
  1400, 1431, 1431, 1462, 1462, 1493, 1493, 1524, 1524, 1555, 1555, 1586, 1586,
  1617, 1617, 1648, 1648, 1679, 1679, 1710, 1710, 1741, 1741, 1772, 1772, 1803,
  1803, 1834, 1834, 1865, 1865, 1896, 1896, 1927, 1927, 1958, 1958, 1989, 1989,
  2020, 1215, 1246, 1246, 1277, 1277, 1308, 1308, 1339, 1339, 1370, 1370, 1401,
  1401, 1432, 1432, 1463, 1463, 1494, 1494, 1525, 1525, 1556, 1556, 1587, 1587,
  1618, 1618, 1649, 1649, 1680, 1680, 1711, 1711, 1742, 1742, 1773, 1773, 1804,
  1804, 1835, 1835, 1866, 1866, 1897, 1897, 1928, 1928, 1959, 1959, 1990, 1990,
  2021, 1247, 1278, 1278, 1309, 1309, 1340, 1340, 1371, 1371, 1402, 1402, 1433,
  1433, 1464, 1464, 1495, 1495, 1526, 1526, 1557, 1557, 1588, 1588, 1619, 1619,
  1650, 1650, 1681, 1681, 1712, 1712, 1743, 1743, 1774, 1774, 1805, 1805, 1836,
  1836, 1867, 1867, 1898, 1898, 1929, 1929, 1960, 1960, 1991, 1991, 2022, 1279,
  1310, 1310, 1341, 1341, 1372, 1372, 1403, 1403, 1434, 1434, 1465, 1465, 1496,
  1496, 1527, 1527, 1558, 1558, 1589, 1589, 1620, 1620, 1651, 1651, 1682, 1682,
  1713, 1713, 1744, 1744, 1775, 1775, 1806, 1806, 1837, 1837, 1868, 1868, 1899,
  1899, 1930, 1930, 1961, 1961, 1992, 1992, 2023, 1311, 1342, 1342, 1373, 1373,
  1404, 1404, 1435, 1435, 1466, 1466, 1497, 1497, 1528, 1528, 1559, 1559, 1590,
  1590, 1621, 1621, 1652, 1652, 1683, 1683, 1714, 1714, 1745, 1745, 1776, 1776,
  1807, 1807, 1838, 1838, 1869, 1869, 1900, 1900, 1931, 1931, 1962, 1962, 1993,
  1993, 2024, 1343, 1374, 1374, 1405, 1405, 1436, 1436, 1467, 1467, 1498, 1498,
  1529, 1529, 1560, 1560, 1591, 1591, 1622, 1622, 1653, 1653, 1684, 1684, 1715,
  1715, 1746, 1746, 1777, 1777, 1808, 1808, 1839, 1839, 1870, 1870, 1901, 1901,
  1932, 1932, 1963, 1963, 1994, 1994, 2025, 1375, 1406, 1406, 1437, 1437, 1468,
  1468, 1499, 1499, 1530, 1530, 1561, 1561, 1592, 1592, 1623, 1623, 1654, 1654,
  1685, 1685, 1716, 1716, 1747, 1747, 1778, 1778, 1809, 1809, 1840, 1840, 1871,
  1871, 1902, 1902, 1933, 1933, 1964, 1964, 1995, 1995, 2026, 1407, 1438, 1438,
  1469, 1469, 1500, 1500, 1531, 1531, 1562, 1562, 1593, 1593, 1624, 1624, 1655,
  1655, 1686, 1686, 1717, 1717, 1748, 1748, 1779, 1779, 1810, 1810, 1841, 1841,
  1872, 1872, 1903, 1903, 1934, 1934, 1965, 1965, 1996, 1996, 2027, 1439, 1470,
  1470, 1501, 1501, 1532, 1532, 1563, 1563, 1594, 1594, 1625, 1625, 1656, 1656,
  1687, 1687, 1718, 1718, 1749, 1749, 1780, 1780, 1811, 1811, 1842, 1842, 1873,
  1873, 1904, 1904, 1935, 1935, 1966, 1966, 1997, 1997, 2028, 1471, 1502, 1502,
  1533, 1533, 1564, 1564, 1595, 1595, 1626, 1626, 1657, 1657, 1688, 1688, 1719,
  1719, 1750, 1750, 1781, 1781, 1812, 1812, 1843, 1843, 1874, 1874, 1905, 1905,
  1936, 1936, 1967, 1967, 1998, 1998, 2029, 1503, 1534, 1534, 1565, 1565, 1596,
  1596, 1627, 1627, 1658, 1658, 1689, 1689, 1720, 1720, 1751, 1751, 1782, 1782,
  1813, 1813, 1844, 1844, 1875, 1875, 1906, 1906, 1937, 1937, 1968, 1968, 1999,
  1999, 2030, 1535, 1566, 1566, 1597, 1597, 1628, 1628, 1659, 1659, 1690, 1690,
  1721, 1721, 1752, 1752, 1783, 1783, 1814, 1814, 1845, 1845, 1876, 1876, 1907,
  1907, 1938, 1938, 1969, 1969, 2000, 2000, 2031, 1567, 1598, 1598, 1629, 1629,
  1660, 1660, 1691, 1691, 1722, 1722, 1753, 1753, 1784, 1784, 1815, 1815, 1846,
  1846, 1877, 1877, 1908, 1908, 1939, 1939, 1970, 1970, 2001, 2001, 2032, 1599,
  1630, 1630, 1661, 1661, 1692, 1692, 1723, 1723, 1754, 1754, 1785, 1785, 1816,
  1816, 1847, 1847, 1878, 1878, 1909, 1909, 1940, 1940, 1971, 1971, 2002, 2002,
  2033, 1631, 1662, 1662, 1693, 1693, 1724, 1724, 1755, 1755, 1786, 1786, 1817,
  1817, 1848, 1848, 1879, 1879, 1910, 1910, 1941, 1941, 1972, 1972, 2003, 2003,
  2034, 1663, 1694, 1694, 1725, 1725, 1756, 1756, 1787, 1787, 1818, 1818, 1849,
  1849, 1880, 1880, 1911, 1911, 1942, 1942, 1973, 1973, 2004, 2004, 2035, 1695,
  1726, 1726, 1757, 1757, 1788, 1788, 1819, 1819, 1850, 1850, 1881, 1881, 1912,
  1912, 1943, 1943, 1974, 1974, 2005, 2005, 2036, 1727, 1758, 1758, 1789, 1789,
  1820, 1820, 1851, 1851, 1882, 1882, 1913, 1913, 1944, 1944, 1975, 1975, 2006,
  2006, 2037, 1759, 1790, 1790, 1821, 1821, 1852, 1852, 1883, 1883, 1914, 1914,
  1945, 1945, 1976, 1976, 2007, 2007, 2038, 1791, 1822, 1822, 1853, 1853, 1884,
  1884, 1915, 1915, 1946, 1946, 1977, 1977, 2008, 2008, 2039, 1823, 1854, 1854,
  1885, 1885, 1916, 1916, 1947, 1947, 1978, 1978, 2009, 2009, 2040, 1855, 1886,
  1886, 1917, 1917, 1948, 1948, 1979, 1979, 2010, 2010, 2041, 1887, 1918, 1918,
  1949, 1949, 1980, 1980, 2011, 2011, 2042, 1919, 1950, 1950, 1981, 1981, 2012,
  2012, 2043, 1951, 1982, 1982, 2013, 2013, 2044, 1983, 2014, 2014, 2045, 2015,
  2046, 0,    0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_64x32_neighbors[2049 * MAX_NEIGHBORS]) = {
  0,    0,    0,    0,    0,    0,    1,    1,    1,    64,   64,   64,   2,
  2,    2,    65,   65,   128,  128,  128,  3,    3,    3,    66,   66,   129,
  129,  192,  192,  192,  4,    4,    4,    67,   67,   130,  130,  193,  193,
  256,  256,  256,  5,    5,    5,    68,   68,   131,  131,  194,  194,  257,
  257,  320,  320,  320,  6,    6,    6,    69,   69,   132,  132,  195,  195,
  258,  258,  321,  321,  384,  384,  384,  7,    7,    7,    70,   70,   133,
  133,  196,  196,  259,  259,  322,  322,  385,  385,  448,  448,  448,  8,
  8,    8,    71,   71,   134,  134,  197,  197,  260,  260,  323,  323,  386,
  386,  449,  449,  512,  512,  512,  9,    9,    9,    72,   72,   135,  135,
  198,  198,  261,  261,  324,  324,  387,  387,  450,  450,  513,  513,  576,
  576,  576,  10,   10,   10,   73,   73,   136,  136,  199,  199,  262,  262,
  325,  325,  388,  388,  451,  451,  514,  514,  577,  577,  640,  640,  640,
  11,   11,   11,   74,   74,   137,  137,  200,  200,  263,  263,  326,  326,
  389,  389,  452,  452,  515,  515,  578,  578,  641,  641,  704,  704,  704,
  12,   12,   12,   75,   75,   138,  138,  201,  201,  264,  264,  327,  327,
  390,  390,  453,  453,  516,  516,  579,  579,  642,  642,  705,  705,  768,
  768,  768,  13,   13,   13,   76,   76,   139,  139,  202,  202,  265,  265,
  328,  328,  391,  391,  454,  454,  517,  517,  580,  580,  643,  643,  706,
  706,  769,  769,  832,  832,  832,  14,   14,   14,   77,   77,   140,  140,
  203,  203,  266,  266,  329,  329,  392,  392,  455,  455,  518,  518,  581,
  581,  644,  644,  707,  707,  770,  770,  833,  833,  896,  896,  896,  15,
  15,   15,   78,   78,   141,  141,  204,  204,  267,  267,  330,  330,  393,
  393,  456,  456,  519,  519,  582,  582,  645,  645,  708,  708,  771,  771,
  834,  834,  897,  897,  960,  960,  960,  16,   16,   16,   79,   79,   142,
  142,  205,  205,  268,  268,  331,  331,  394,  394,  457,  457,  520,  520,
  583,  583,  646,  646,  709,  709,  772,  772,  835,  835,  898,  898,  961,
  961,  1024, 1024, 1024, 17,   17,   17,   80,   80,   143,  143,  206,  206,
  269,  269,  332,  332,  395,  395,  458,  458,  521,  521,  584,  584,  647,
  647,  710,  710,  773,  773,  836,  836,  899,  899,  962,  962,  1025, 1025,
  1088, 1088, 1088, 18,   18,   18,   81,   81,   144,  144,  207,  207,  270,
  270,  333,  333,  396,  396,  459,  459,  522,  522,  585,  585,  648,  648,
  711,  711,  774,  774,  837,  837,  900,  900,  963,  963,  1026, 1026, 1089,
  1089, 1152, 1152, 1152, 19,   19,   19,   82,   82,   145,  145,  208,  208,
  271,  271,  334,  334,  397,  397,  460,  460,  523,  523,  586,  586,  649,
  649,  712,  712,  775,  775,  838,  838,  901,  901,  964,  964,  1027, 1027,
  1090, 1090, 1153, 1153, 1216, 1216, 1216, 20,   20,   20,   83,   83,   146,
  146,  209,  209,  272,  272,  335,  335,  398,  398,  461,  461,  524,  524,
  587,  587,  650,  650,  713,  713,  776,  776,  839,  839,  902,  902,  965,
  965,  1028, 1028, 1091, 1091, 1154, 1154, 1217, 1217, 1280, 1280, 1280, 21,
  21,   21,   84,   84,   147,  147,  210,  210,  273,  273,  336,  336,  399,
  399,  462,  462,  525,  525,  588,  588,  651,  651,  714,  714,  777,  777,
  840,  840,  903,  903,  966,  966,  1029, 1029, 1092, 1092, 1155, 1155, 1218,
  1218, 1281, 1281, 1344, 1344, 1344, 22,   22,   22,   85,   85,   148,  148,
  211,  211,  274,  274,  337,  337,  400,  400,  463,  463,  526,  526,  589,
  589,  652,  652,  715,  715,  778,  778,  841,  841,  904,  904,  967,  967,
  1030, 1030, 1093, 1093, 1156, 1156, 1219, 1219, 1282, 1282, 1345, 1345, 1408,
  1408, 1408, 23,   23,   23,   86,   86,   149,  149,  212,  212,  275,  275,
  338,  338,  401,  401,  464,  464,  527,  527,  590,  590,  653,  653,  716,
  716,  779,  779,  842,  842,  905,  905,  968,  968,  1031, 1031, 1094, 1094,
  1157, 1157, 1220, 1220, 1283, 1283, 1346, 1346, 1409, 1409, 1472, 1472, 1472,
  24,   24,   24,   87,   87,   150,  150,  213,  213,  276,  276,  339,  339,
  402,  402,  465,  465,  528,  528,  591,  591,  654,  654,  717,  717,  780,
  780,  843,  843,  906,  906,  969,  969,  1032, 1032, 1095, 1095, 1158, 1158,
  1221, 1221, 1284, 1284, 1347, 1347, 1410, 1410, 1473, 1473, 1536, 1536, 1536,
  25,   25,   25,   88,   88,   151,  151,  214,  214,  277,  277,  340,  340,
  403,  403,  466,  466,  529,  529,  592,  592,  655,  655,  718,  718,  781,
  781,  844,  844,  907,  907,  970,  970,  1033, 1033, 1096, 1096, 1159, 1159,
  1222, 1222, 1285, 1285, 1348, 1348, 1411, 1411, 1474, 1474, 1537, 1537, 1600,
  1600, 1600, 26,   26,   26,   89,   89,   152,  152,  215,  215,  278,  278,
  341,  341,  404,  404,  467,  467,  530,  530,  593,  593,  656,  656,  719,
  719,  782,  782,  845,  845,  908,  908,  971,  971,  1034, 1034, 1097, 1097,
  1160, 1160, 1223, 1223, 1286, 1286, 1349, 1349, 1412, 1412, 1475, 1475, 1538,
  1538, 1601, 1601, 1664, 1664, 1664, 27,   27,   27,   90,   90,   153,  153,
  216,  216,  279,  279,  342,  342,  405,  405,  468,  468,  531,  531,  594,
  594,  657,  657,  720,  720,  783,  783,  846,  846,  909,  909,  972,  972,
  1035, 1035, 1098, 1098, 1161, 1161, 1224, 1224, 1287, 1287, 1350, 1350, 1413,
  1413, 1476, 1476, 1539, 1539, 1602, 1602, 1665, 1665, 1728, 1728, 1728, 28,
  28,   28,   91,   91,   154,  154,  217,  217,  280,  280,  343,  343,  406,
  406,  469,  469,  532,  532,  595,  595,  658,  658,  721,  721,  784,  784,
  847,  847,  910,  910,  973,  973,  1036, 1036, 1099, 1099, 1162, 1162, 1225,
  1225, 1288, 1288, 1351, 1351, 1414, 1414, 1477, 1477, 1540, 1540, 1603, 1603,
  1666, 1666, 1729, 1729, 1792, 1792, 1792, 29,   29,   29,   92,   92,   155,
  155,  218,  218,  281,  281,  344,  344,  407,  407,  470,  470,  533,  533,
  596,  596,  659,  659,  722,  722,  785,  785,  848,  848,  911,  911,  974,
  974,  1037, 1037, 1100, 1100, 1163, 1163, 1226, 1226, 1289, 1289, 1352, 1352,
  1415, 1415, 1478, 1478, 1541, 1541, 1604, 1604, 1667, 1667, 1730, 1730, 1793,
  1793, 1856, 1856, 1856, 30,   30,   30,   93,   93,   156,  156,  219,  219,
  282,  282,  345,  345,  408,  408,  471,  471,  534,  534,  597,  597,  660,
  660,  723,  723,  786,  786,  849,  849,  912,  912,  975,  975,  1038, 1038,
  1101, 1101, 1164, 1164, 1227, 1227, 1290, 1290, 1353, 1353, 1416, 1416, 1479,
  1479, 1542, 1542, 1605, 1605, 1668, 1668, 1731, 1731, 1794, 1794, 1857, 1857,
  1920, 1920, 1920, 31,   31,   31,   94,   94,   157,  157,  220,  220,  283,
  283,  346,  346,  409,  409,  472,  472,  535,  535,  598,  598,  661,  661,
  724,  724,  787,  787,  850,  850,  913,  913,  976,  976,  1039, 1039, 1102,
  1102, 1165, 1165, 1228, 1228, 1291, 1291, 1354, 1354, 1417, 1417, 1480, 1480,
  1543, 1543, 1606, 1606, 1669, 1669, 1732, 1732, 1795, 1795, 1858, 1858, 1921,
  1921, 1984, 32,   32,   32,   95,   95,   158,  158,  221,  221,  284,  284,
  347,  347,  410,  410,  473,  473,  536,  536,  599,  599,  662,  662,  725,
  725,  788,  788,  851,  851,  914,  914,  977,  977,  1040, 1040, 1103, 1103,
  1166, 1166, 1229, 1229, 1292, 1292, 1355, 1355, 1418, 1418, 1481, 1481, 1544,
  1544, 1607, 1607, 1670, 1670, 1733, 1733, 1796, 1796, 1859, 1859, 1922, 1922,
  1985, 33,   33,   33,   96,   96,   159,  159,  222,  222,  285,  285,  348,
  348,  411,  411,  474,  474,  537,  537,  600,  600,  663,  663,  726,  726,
  789,  789,  852,  852,  915,  915,  978,  978,  1041, 1041, 1104, 1104, 1167,
  1167, 1230, 1230, 1293, 1293, 1356, 1356, 1419, 1419, 1482, 1482, 1545, 1545,
  1608, 1608, 1671, 1671, 1734, 1734, 1797, 1797, 1860, 1860, 1923, 1923, 1986,
  34,   34,   34,   97,   97,   160,  160,  223,  223,  286,  286,  349,  349,
  412,  412,  475,  475,  538,  538,  601,  601,  664,  664,  727,  727,  790,
  790,  853,  853,  916,  916,  979,  979,  1042, 1042, 1105, 1105, 1168, 1168,
  1231, 1231, 1294, 1294, 1357, 1357, 1420, 1420, 1483, 1483, 1546, 1546, 1609,
  1609, 1672, 1672, 1735, 1735, 1798, 1798, 1861, 1861, 1924, 1924, 1987, 35,
  35,   35,   98,   98,   161,  161,  224,  224,  287,  287,  350,  350,  413,
  413,  476,  476,  539,  539,  602,  602,  665,  665,  728,  728,  791,  791,
  854,  854,  917,  917,  980,  980,  1043, 1043, 1106, 1106, 1169, 1169, 1232,
  1232, 1295, 1295, 1358, 1358, 1421, 1421, 1484, 1484, 1547, 1547, 1610, 1610,
  1673, 1673, 1736, 1736, 1799, 1799, 1862, 1862, 1925, 1925, 1988, 36,   36,
  36,   99,   99,   162,  162,  225,  225,  288,  288,  351,  351,  414,  414,
  477,  477,  540,  540,  603,  603,  666,  666,  729,  729,  792,  792,  855,
  855,  918,  918,  981,  981,  1044, 1044, 1107, 1107, 1170, 1170, 1233, 1233,
  1296, 1296, 1359, 1359, 1422, 1422, 1485, 1485, 1548, 1548, 1611, 1611, 1674,
  1674, 1737, 1737, 1800, 1800, 1863, 1863, 1926, 1926, 1989, 37,   37,   37,
  100,  100,  163,  163,  226,  226,  289,  289,  352,  352,  415,  415,  478,
  478,  541,  541,  604,  604,  667,  667,  730,  730,  793,  793,  856,  856,
  919,  919,  982,  982,  1045, 1045, 1108, 1108, 1171, 1171, 1234, 1234, 1297,
  1297, 1360, 1360, 1423, 1423, 1486, 1486, 1549, 1549, 1612, 1612, 1675, 1675,
  1738, 1738, 1801, 1801, 1864, 1864, 1927, 1927, 1990, 38,   38,   38,   101,
  101,  164,  164,  227,  227,  290,  290,  353,  353,  416,  416,  479,  479,
  542,  542,  605,  605,  668,  668,  731,  731,  794,  794,  857,  857,  920,
  920,  983,  983,  1046, 1046, 1109, 1109, 1172, 1172, 1235, 1235, 1298, 1298,
  1361, 1361, 1424, 1424, 1487, 1487, 1550, 1550, 1613, 1613, 1676, 1676, 1739,
  1739, 1802, 1802, 1865, 1865, 1928, 1928, 1991, 39,   39,   39,   102,  102,
  165,  165,  228,  228,  291,  291,  354,  354,  417,  417,  480,  480,  543,
  543,  606,  606,  669,  669,  732,  732,  795,  795,  858,  858,  921,  921,
  984,  984,  1047, 1047, 1110, 1110, 1173, 1173, 1236, 1236, 1299, 1299, 1362,
  1362, 1425, 1425, 1488, 1488, 1551, 1551, 1614, 1614, 1677, 1677, 1740, 1740,
  1803, 1803, 1866, 1866, 1929, 1929, 1992, 40,   40,   40,   103,  103,  166,
  166,  229,  229,  292,  292,  355,  355,  418,  418,  481,  481,  544,  544,
  607,  607,  670,  670,  733,  733,  796,  796,  859,  859,  922,  922,  985,
  985,  1048, 1048, 1111, 1111, 1174, 1174, 1237, 1237, 1300, 1300, 1363, 1363,
  1426, 1426, 1489, 1489, 1552, 1552, 1615, 1615, 1678, 1678, 1741, 1741, 1804,
  1804, 1867, 1867, 1930, 1930, 1993, 41,   41,   41,   104,  104,  167,  167,
  230,  230,  293,  293,  356,  356,  419,  419,  482,  482,  545,  545,  608,
  608,  671,  671,  734,  734,  797,  797,  860,  860,  923,  923,  986,  986,
  1049, 1049, 1112, 1112, 1175, 1175, 1238, 1238, 1301, 1301, 1364, 1364, 1427,
  1427, 1490, 1490, 1553, 1553, 1616, 1616, 1679, 1679, 1742, 1742, 1805, 1805,
  1868, 1868, 1931, 1931, 1994, 42,   42,   42,   105,  105,  168,  168,  231,
  231,  294,  294,  357,  357,  420,  420,  483,  483,  546,  546,  609,  609,
  672,  672,  735,  735,  798,  798,  861,  861,  924,  924,  987,  987,  1050,
  1050, 1113, 1113, 1176, 1176, 1239, 1239, 1302, 1302, 1365, 1365, 1428, 1428,
  1491, 1491, 1554, 1554, 1617, 1617, 1680, 1680, 1743, 1743, 1806, 1806, 1869,
  1869, 1932, 1932, 1995, 43,   43,   43,   106,  106,  169,  169,  232,  232,
  295,  295,  358,  358,  421,  421,  484,  484,  547,  547,  610,  610,  673,
  673,  736,  736,  799,  799,  862,  862,  925,  925,  988,  988,  1051, 1051,
  1114, 1114, 1177, 1177, 1240, 1240, 1303, 1303, 1366, 1366, 1429, 1429, 1492,
  1492, 1555, 1555, 1618, 1618, 1681, 1681, 1744, 1744, 1807, 1807, 1870, 1870,
  1933, 1933, 1996, 44,   44,   44,   107,  107,  170,  170,  233,  233,  296,
  296,  359,  359,  422,  422,  485,  485,  548,  548,  611,  611,  674,  674,
  737,  737,  800,  800,  863,  863,  926,  926,  989,  989,  1052, 1052, 1115,
  1115, 1178, 1178, 1241, 1241, 1304, 1304, 1367, 1367, 1430, 1430, 1493, 1493,
  1556, 1556, 1619, 1619, 1682, 1682, 1745, 1745, 1808, 1808, 1871, 1871, 1934,
  1934, 1997, 45,   45,   45,   108,  108,  171,  171,  234,  234,  297,  297,
  360,  360,  423,  423,  486,  486,  549,  549,  612,  612,  675,  675,  738,
  738,  801,  801,  864,  864,  927,  927,  990,  990,  1053, 1053, 1116, 1116,
  1179, 1179, 1242, 1242, 1305, 1305, 1368, 1368, 1431, 1431, 1494, 1494, 1557,
  1557, 1620, 1620, 1683, 1683, 1746, 1746, 1809, 1809, 1872, 1872, 1935, 1935,
  1998, 46,   46,   46,   109,  109,  172,  172,  235,  235,  298,  298,  361,
  361,  424,  424,  487,  487,  550,  550,  613,  613,  676,  676,  739,  739,
  802,  802,  865,  865,  928,  928,  991,  991,  1054, 1054, 1117, 1117, 1180,
  1180, 1243, 1243, 1306, 1306, 1369, 1369, 1432, 1432, 1495, 1495, 1558, 1558,
  1621, 1621, 1684, 1684, 1747, 1747, 1810, 1810, 1873, 1873, 1936, 1936, 1999,
  47,   47,   47,   110,  110,  173,  173,  236,  236,  299,  299,  362,  362,
  425,  425,  488,  488,  551,  551,  614,  614,  677,  677,  740,  740,  803,
  803,  866,  866,  929,  929,  992,  992,  1055, 1055, 1118, 1118, 1181, 1181,
  1244, 1244, 1307, 1307, 1370, 1370, 1433, 1433, 1496, 1496, 1559, 1559, 1622,
  1622, 1685, 1685, 1748, 1748, 1811, 1811, 1874, 1874, 1937, 1937, 2000, 48,
  48,   48,   111,  111,  174,  174,  237,  237,  300,  300,  363,  363,  426,
  426,  489,  489,  552,  552,  615,  615,  678,  678,  741,  741,  804,  804,
  867,  867,  930,  930,  993,  993,  1056, 1056, 1119, 1119, 1182, 1182, 1245,
  1245, 1308, 1308, 1371, 1371, 1434, 1434, 1497, 1497, 1560, 1560, 1623, 1623,
  1686, 1686, 1749, 1749, 1812, 1812, 1875, 1875, 1938, 1938, 2001, 49,   49,
  49,   112,  112,  175,  175,  238,  238,  301,  301,  364,  364,  427,  427,
  490,  490,  553,  553,  616,  616,  679,  679,  742,  742,  805,  805,  868,
  868,  931,  931,  994,  994,  1057, 1057, 1120, 1120, 1183, 1183, 1246, 1246,
  1309, 1309, 1372, 1372, 1435, 1435, 1498, 1498, 1561, 1561, 1624, 1624, 1687,
  1687, 1750, 1750, 1813, 1813, 1876, 1876, 1939, 1939, 2002, 50,   50,   50,
  113,  113,  176,  176,  239,  239,  302,  302,  365,  365,  428,  428,  491,
  491,  554,  554,  617,  617,  680,  680,  743,  743,  806,  806,  869,  869,
  932,  932,  995,  995,  1058, 1058, 1121, 1121, 1184, 1184, 1247, 1247, 1310,
  1310, 1373, 1373, 1436, 1436, 1499, 1499, 1562, 1562, 1625, 1625, 1688, 1688,
  1751, 1751, 1814, 1814, 1877, 1877, 1940, 1940, 2003, 51,   51,   51,   114,
  114,  177,  177,  240,  240,  303,  303,  366,  366,  429,  429,  492,  492,
  555,  555,  618,  618,  681,  681,  744,  744,  807,  807,  870,  870,  933,
  933,  996,  996,  1059, 1059, 1122, 1122, 1185, 1185, 1248, 1248, 1311, 1311,
  1374, 1374, 1437, 1437, 1500, 1500, 1563, 1563, 1626, 1626, 1689, 1689, 1752,
  1752, 1815, 1815, 1878, 1878, 1941, 1941, 2004, 52,   52,   52,   115,  115,
  178,  178,  241,  241,  304,  304,  367,  367,  430,  430,  493,  493,  556,
  556,  619,  619,  682,  682,  745,  745,  808,  808,  871,  871,  934,  934,
  997,  997,  1060, 1060, 1123, 1123, 1186, 1186, 1249, 1249, 1312, 1312, 1375,
  1375, 1438, 1438, 1501, 1501, 1564, 1564, 1627, 1627, 1690, 1690, 1753, 1753,
  1816, 1816, 1879, 1879, 1942, 1942, 2005, 53,   53,   53,   116,  116,  179,
  179,  242,  242,  305,  305,  368,  368,  431,  431,  494,  494,  557,  557,
  620,  620,  683,  683,  746,  746,  809,  809,  872,  872,  935,  935,  998,
  998,  1061, 1061, 1124, 1124, 1187, 1187, 1250, 1250, 1313, 1313, 1376, 1376,
  1439, 1439, 1502, 1502, 1565, 1565, 1628, 1628, 1691, 1691, 1754, 1754, 1817,
  1817, 1880, 1880, 1943, 1943, 2006, 54,   54,   54,   117,  117,  180,  180,
  243,  243,  306,  306,  369,  369,  432,  432,  495,  495,  558,  558,  621,
  621,  684,  684,  747,  747,  810,  810,  873,  873,  936,  936,  999,  999,
  1062, 1062, 1125, 1125, 1188, 1188, 1251, 1251, 1314, 1314, 1377, 1377, 1440,
  1440, 1503, 1503, 1566, 1566, 1629, 1629, 1692, 1692, 1755, 1755, 1818, 1818,
  1881, 1881, 1944, 1944, 2007, 55,   55,   55,   118,  118,  181,  181,  244,
  244,  307,  307,  370,  370,  433,  433,  496,  496,  559,  559,  622,  622,
  685,  685,  748,  748,  811,  811,  874,  874,  937,  937,  1000, 1000, 1063,
  1063, 1126, 1126, 1189, 1189, 1252, 1252, 1315, 1315, 1378, 1378, 1441, 1441,
  1504, 1504, 1567, 1567, 1630, 1630, 1693, 1693, 1756, 1756, 1819, 1819, 1882,
  1882, 1945, 1945, 2008, 56,   56,   56,   119,  119,  182,  182,  245,  245,
  308,  308,  371,  371,  434,  434,  497,  497,  560,  560,  623,  623,  686,
  686,  749,  749,  812,  812,  875,  875,  938,  938,  1001, 1001, 1064, 1064,
  1127, 1127, 1190, 1190, 1253, 1253, 1316, 1316, 1379, 1379, 1442, 1442, 1505,
  1505, 1568, 1568, 1631, 1631, 1694, 1694, 1757, 1757, 1820, 1820, 1883, 1883,
  1946, 1946, 2009, 57,   57,   57,   120,  120,  183,  183,  246,  246,  309,
  309,  372,  372,  435,  435,  498,  498,  561,  561,  624,  624,  687,  687,
  750,  750,  813,  813,  876,  876,  939,  939,  1002, 1002, 1065, 1065, 1128,
  1128, 1191, 1191, 1254, 1254, 1317, 1317, 1380, 1380, 1443, 1443, 1506, 1506,
  1569, 1569, 1632, 1632, 1695, 1695, 1758, 1758, 1821, 1821, 1884, 1884, 1947,
  1947, 2010, 58,   58,   58,   121,  121,  184,  184,  247,  247,  310,  310,
  373,  373,  436,  436,  499,  499,  562,  562,  625,  625,  688,  688,  751,
  751,  814,  814,  877,  877,  940,  940,  1003, 1003, 1066, 1066, 1129, 1129,
  1192, 1192, 1255, 1255, 1318, 1318, 1381, 1381, 1444, 1444, 1507, 1507, 1570,
  1570, 1633, 1633, 1696, 1696, 1759, 1759, 1822, 1822, 1885, 1885, 1948, 1948,
  2011, 59,   59,   59,   122,  122,  185,  185,  248,  248,  311,  311,  374,
  374,  437,  437,  500,  500,  563,  563,  626,  626,  689,  689,  752,  752,
  815,  815,  878,  878,  941,  941,  1004, 1004, 1067, 1067, 1130, 1130, 1193,
  1193, 1256, 1256, 1319, 1319, 1382, 1382, 1445, 1445, 1508, 1508, 1571, 1571,
  1634, 1634, 1697, 1697, 1760, 1760, 1823, 1823, 1886, 1886, 1949, 1949, 2012,
  60,   60,   60,   123,  123,  186,  186,  249,  249,  312,  312,  375,  375,
  438,  438,  501,  501,  564,  564,  627,  627,  690,  690,  753,  753,  816,
  816,  879,  879,  942,  942,  1005, 1005, 1068, 1068, 1131, 1131, 1194, 1194,
  1257, 1257, 1320, 1320, 1383, 1383, 1446, 1446, 1509, 1509, 1572, 1572, 1635,
  1635, 1698, 1698, 1761, 1761, 1824, 1824, 1887, 1887, 1950, 1950, 2013, 61,
  61,   61,   124,  124,  187,  187,  250,  250,  313,  313,  376,  376,  439,
  439,  502,  502,  565,  565,  628,  628,  691,  691,  754,  754,  817,  817,
  880,  880,  943,  943,  1006, 1006, 1069, 1069, 1132, 1132, 1195, 1195, 1258,
  1258, 1321, 1321, 1384, 1384, 1447, 1447, 1510, 1510, 1573, 1573, 1636, 1636,
  1699, 1699, 1762, 1762, 1825, 1825, 1888, 1888, 1951, 1951, 2014, 62,   62,
  62,   125,  125,  188,  188,  251,  251,  314,  314,  377,  377,  440,  440,
  503,  503,  566,  566,  629,  629,  692,  692,  755,  755,  818,  818,  881,
  881,  944,  944,  1007, 1007, 1070, 1070, 1133, 1133, 1196, 1196, 1259, 1259,
  1322, 1322, 1385, 1385, 1448, 1448, 1511, 1511, 1574, 1574, 1637, 1637, 1700,
  1700, 1763, 1763, 1826, 1826, 1889, 1889, 1952, 1952, 2015, 63,   126,  126,
  189,  189,  252,  252,  315,  315,  378,  378,  441,  441,  504,  504,  567,
  567,  630,  630,  693,  693,  756,  756,  819,  819,  882,  882,  945,  945,
  1008, 1008, 1071, 1071, 1134, 1134, 1197, 1197, 1260, 1260, 1323, 1323, 1386,
  1386, 1449, 1449, 1512, 1512, 1575, 1575, 1638, 1638, 1701, 1701, 1764, 1764,
  1827, 1827, 1890, 1890, 1953, 1953, 2016, 127,  190,  190,  253,  253,  316,
  316,  379,  379,  442,  442,  505,  505,  568,  568,  631,  631,  694,  694,
  757,  757,  820,  820,  883,  883,  946,  946,  1009, 1009, 1072, 1072, 1135,
  1135, 1198, 1198, 1261, 1261, 1324, 1324, 1387, 1387, 1450, 1450, 1513, 1513,
  1576, 1576, 1639, 1639, 1702, 1702, 1765, 1765, 1828, 1828, 1891, 1891, 1954,
  1954, 2017, 191,  254,  254,  317,  317,  380,  380,  443,  443,  506,  506,
  569,  569,  632,  632,  695,  695,  758,  758,  821,  821,  884,  884,  947,
  947,  1010, 1010, 1073, 1073, 1136, 1136, 1199, 1199, 1262, 1262, 1325, 1325,
  1388, 1388, 1451, 1451, 1514, 1514, 1577, 1577, 1640, 1640, 1703, 1703, 1766,
  1766, 1829, 1829, 1892, 1892, 1955, 1955, 2018, 255,  318,  318,  381,  381,
  444,  444,  507,  507,  570,  570,  633,  633,  696,  696,  759,  759,  822,
  822,  885,  885,  948,  948,  1011, 1011, 1074, 1074, 1137, 1137, 1200, 1200,
  1263, 1263, 1326, 1326, 1389, 1389, 1452, 1452, 1515, 1515, 1578, 1578, 1641,
  1641, 1704, 1704, 1767, 1767, 1830, 1830, 1893, 1893, 1956, 1956, 2019, 319,
  382,  382,  445,  445,  508,  508,  571,  571,  634,  634,  697,  697,  760,
  760,  823,  823,  886,  886,  949,  949,  1012, 1012, 1075, 1075, 1138, 1138,
  1201, 1201, 1264, 1264, 1327, 1327, 1390, 1390, 1453, 1453, 1516, 1516, 1579,
  1579, 1642, 1642, 1705, 1705, 1768, 1768, 1831, 1831, 1894, 1894, 1957, 1957,
  2020, 383,  446,  446,  509,  509,  572,  572,  635,  635,  698,  698,  761,
  761,  824,  824,  887,  887,  950,  950,  1013, 1013, 1076, 1076, 1139, 1139,
  1202, 1202, 1265, 1265, 1328, 1328, 1391, 1391, 1454, 1454, 1517, 1517, 1580,
  1580, 1643, 1643, 1706, 1706, 1769, 1769, 1832, 1832, 1895, 1895, 1958, 1958,
  2021, 447,  510,  510,  573,  573,  636,  636,  699,  699,  762,  762,  825,
  825,  888,  888,  951,  951,  1014, 1014, 1077, 1077, 1140, 1140, 1203, 1203,
  1266, 1266, 1329, 1329, 1392, 1392, 1455, 1455, 1518, 1518, 1581, 1581, 1644,
  1644, 1707, 1707, 1770, 1770, 1833, 1833, 1896, 1896, 1959, 1959, 2022, 511,
  574,  574,  637,  637,  700,  700,  763,  763,  826,  826,  889,  889,  952,
  952,  1015, 1015, 1078, 1078, 1141, 1141, 1204, 1204, 1267, 1267, 1330, 1330,
  1393, 1393, 1456, 1456, 1519, 1519, 1582, 1582, 1645, 1645, 1708, 1708, 1771,
  1771, 1834, 1834, 1897, 1897, 1960, 1960, 2023, 575,  638,  638,  701,  701,
  764,  764,  827,  827,  890,  890,  953,  953,  1016, 1016, 1079, 1079, 1142,
  1142, 1205, 1205, 1268, 1268, 1331, 1331, 1394, 1394, 1457, 1457, 1520, 1520,
  1583, 1583, 1646, 1646, 1709, 1709, 1772, 1772, 1835, 1835, 1898, 1898, 1961,
  1961, 2024, 639,  702,  702,  765,  765,  828,  828,  891,  891,  954,  954,
  1017, 1017, 1080, 1080, 1143, 1143, 1206, 1206, 1269, 1269, 1332, 1332, 1395,
  1395, 1458, 1458, 1521, 1521, 1584, 1584, 1647, 1647, 1710, 1710, 1773, 1773,
  1836, 1836, 1899, 1899, 1962, 1962, 2025, 703,  766,  766,  829,  829,  892,
  892,  955,  955,  1018, 1018, 1081, 1081, 1144, 1144, 1207, 1207, 1270, 1270,
  1333, 1333, 1396, 1396, 1459, 1459, 1522, 1522, 1585, 1585, 1648, 1648, 1711,
  1711, 1774, 1774, 1837, 1837, 1900, 1900, 1963, 1963, 2026, 767,  830,  830,
  893,  893,  956,  956,  1019, 1019, 1082, 1082, 1145, 1145, 1208, 1208, 1271,
  1271, 1334, 1334, 1397, 1397, 1460, 1460, 1523, 1523, 1586, 1586, 1649, 1649,
  1712, 1712, 1775, 1775, 1838, 1838, 1901, 1901, 1964, 1964, 2027, 831,  894,
  894,  957,  957,  1020, 1020, 1083, 1083, 1146, 1146, 1209, 1209, 1272, 1272,
  1335, 1335, 1398, 1398, 1461, 1461, 1524, 1524, 1587, 1587, 1650, 1650, 1713,
  1713, 1776, 1776, 1839, 1839, 1902, 1902, 1965, 1965, 2028, 895,  958,  958,
  1021, 1021, 1084, 1084, 1147, 1147, 1210, 1210, 1273, 1273, 1336, 1336, 1399,
  1399, 1462, 1462, 1525, 1525, 1588, 1588, 1651, 1651, 1714, 1714, 1777, 1777,
  1840, 1840, 1903, 1903, 1966, 1966, 2029, 959,  1022, 1022, 1085, 1085, 1148,
  1148, 1211, 1211, 1274, 1274, 1337, 1337, 1400, 1400, 1463, 1463, 1526, 1526,
  1589, 1589, 1652, 1652, 1715, 1715, 1778, 1778, 1841, 1841, 1904, 1904, 1967,
  1967, 2030, 1023, 1086, 1086, 1149, 1149, 1212, 1212, 1275, 1275, 1338, 1338,
  1401, 1401, 1464, 1464, 1527, 1527, 1590, 1590, 1653, 1653, 1716, 1716, 1779,
  1779, 1842, 1842, 1905, 1905, 1968, 1968, 2031, 1087, 1150, 1150, 1213, 1213,
  1276, 1276, 1339, 1339, 1402, 1402, 1465, 1465, 1528, 1528, 1591, 1591, 1654,
  1654, 1717, 1717, 1780, 1780, 1843, 1843, 1906, 1906, 1969, 1969, 2032, 1151,
  1214, 1214, 1277, 1277, 1340, 1340, 1403, 1403, 1466, 1466, 1529, 1529, 1592,
  1592, 1655, 1655, 1718, 1718, 1781, 1781, 1844, 1844, 1907, 1907, 1970, 1970,
  2033, 1215, 1278, 1278, 1341, 1341, 1404, 1404, 1467, 1467, 1530, 1530, 1593,
  1593, 1656, 1656, 1719, 1719, 1782, 1782, 1845, 1845, 1908, 1908, 1971, 1971,
  2034, 1279, 1342, 1342, 1405, 1405, 1468, 1468, 1531, 1531, 1594, 1594, 1657,
  1657, 1720, 1720, 1783, 1783, 1846, 1846, 1909, 1909, 1972, 1972, 2035, 1343,
  1406, 1406, 1469, 1469, 1532, 1532, 1595, 1595, 1658, 1658, 1721, 1721, 1784,
  1784, 1847, 1847, 1910, 1910, 1973, 1973, 2036, 1407, 1470, 1470, 1533, 1533,
  1596, 1596, 1659, 1659, 1722, 1722, 1785, 1785, 1848, 1848, 1911, 1911, 1974,
  1974, 2037, 1471, 1534, 1534, 1597, 1597, 1660, 1660, 1723, 1723, 1786, 1786,
  1849, 1849, 1912, 1912, 1975, 1975, 2038, 1535, 1598, 1598, 1661, 1661, 1724,
  1724, 1787, 1787, 1850, 1850, 1913, 1913, 1976, 1976, 2039, 1599, 1662, 1662,
  1725, 1725, 1788, 1788, 1851, 1851, 1914, 1914, 1977, 1977, 2040, 1663, 1726,
  1726, 1789, 1789, 1852, 1852, 1915, 1915, 1978, 1978, 2041, 1727, 1790, 1790,
  1853, 1853, 1916, 1916, 1979, 1979, 2042, 1791, 1854, 1854, 1917, 1917, 1980,
  1980, 2043, 1855, 1918, 1918, 1981, 1981, 2044, 1919, 1982, 1982, 2045, 1983,
  2046, 0,    0
};

DECLARE_ALIGNED(16, static const int16_t,
                default_scan_64x64_neighbors[4097 * MAX_NEIGHBORS]) = {
  0,    0,    0,    0,    0,    0,    1,    64,   1,    1,    64,   64,   2,
  65,   65,   128,  66,   129,  2,    2,    128,  128,  3,    66,   129,  192,
  67,   130,  130,  193,  3,    3,    192,  192,  4,    67,   193,  256,  131,
  194,  68,   131,  194,  257,  4,    4,    132,  195,  195,  258,  256,  256,
  5,    68,   257,  320,  69,   132,  258,  321,  196,  259,  133,  196,  259,
  322,  5,    5,    320,  320,  6,    69,   321,  384,  70,   133,  322,  385,
  197,  260,  260,  323,  134,  197,  323,  386,  6,    6,    384,  384,  7,
  70,   261,  324,  385,  448,  198,  261,  324,  387,  71,   134,  386,  449,
  135,  198,  387,  450,  262,  325,  325,  388,  7,    7,    448,  448,  8,
  71,   199,  262,  388,  451,  449,  512,  72,   135,  450,  513,  326,  389,
  136,  199,  451,  514,  263,  326,  389,  452,  200,  263,  452,  515,  8,
  8,    512,  512,  9,    72,   513,  576,  73,   136,  327,  390,  390,  453,
  514,  577,  264,  327,  453,  516,  137,  200,  515,  578,  201,  264,  516,
  579,  391,  454,  9,    9,    328,  391,  454,  517,  576,  576,  10,   73,
  577,  640,  74,   137,  578,  641,  265,  328,  517,  580,  138,  201,  579,
  642,  392,  455,  455,  518,  202,  265,  580,  643,  329,  392,  518,  581,
  10,   10,   640,  640,  11,   74,   641,  704,  75,   138,  266,  329,  581,
  644,  642,  705,  456,  519,  139,  202,  393,  456,  519,  582,  643,  706,
  330,  393,  582,  645,  203,  266,  644,  707,  11,   11,   704,  704,  12,
  75,   457,  520,  520,  583,  705,  768,  267,  330,  645,  708,  76,   139,
  706,  769,  394,  457,  583,  646,  140,  203,  707,  770,  331,  394,  646,
  709,  204,  267,  708,  771,  521,  584,  458,  521,  584,  647,  12,   12,
  268,  331,  709,  772,  768,  768,  13,   76,   395,  458,  647,  710,  769,
  832,  77,   140,  770,  833,  141,  204,  771,  834,  332,  395,  710,  773,
  522,  585,  585,  648,  205,  268,  459,  522,  648,  711,  772,  835,  396,
  459,  711,  774,  269,  332,  773,  836,  13,   13,   832,  832,  14,   77,
  833,  896,  78,   141,  586,  649,  834,  897,  523,  586,  649,  712,  142,
  205,  333,  396,  774,  837,  835,  898,  460,  523,  712,  775,  206,  269,
  836,  899,  397,  460,  775,  838,  270,  333,  587,  650,  650,  713,  837,
  900,  14,   14,   524,  587,  713,  776,  896,  896,  15,   78,   897,  960,
  79,   142,  898,  961,  334,  397,  838,  901,  461,  524,  776,  839,  143,
  206,  899,  962,  207,  270,  900,  963,  651,  714,  588,  651,  714,  777,
  398,  461,  839,  902,  271,  334,  525,  588,  777,  840,  901,  964,  15,
  15,   960,  960,  16,   79,   961,  1024, 80,   143,  462,  525,  840,  903,
  962,  1025, 335,  398,  902,  965,  144,  207,  652,  715,  715,  778,  963,
  1026, 589,  652,  778,  841,  208,  271,  964,  1027, 399,  462,  903,  966,
  526,  589,  841,  904,  272,  335,  965,  1028, 716,  779,  16,   16,   463,
  526,  904,  967,  1024, 1024, 17,   80,   653,  716,  779,  842,  1025, 1088,
  336,  399,  966,  1029, 81,   144,  1026, 1089, 590,  653,  842,  905,  145,
  208,  1027, 1090, 209,  272,  400,  463,  967,  1030, 1028, 1091, 527,  590,
  905,  968,  717,  780,  780,  843,  273,  336,  1029, 1092, 654,  717,  843,
  906,  464,  527,  968,  1031, 17,   17,   1088, 1088, 18,   81,   337,  400,
  591,  654,  906,  969,  1030, 1093, 1089, 1152, 82,   145,  1090, 1153, 146,
  209,  1091, 1154, 528,  591,  969,  1032, 401,  464,  781,  844,  1031, 1094,
  210,  273,  718,  781,  844,  907,  1092, 1155, 655,  718,  907,  970,  274,
  337,  1093, 1156, 465,  528,  1032, 1095, 592,  655,  970,  1033, 338,  401,
  1094, 1157, 18,   18,   1152, 1152, 19,   82,   1153, 1216, 83,   146,  782,
  845,  845,  908,  1154, 1217, 719,  782,  908,  971,  147,  210,  529,  592,
  1033, 1096, 1155, 1218, 402,  465,  1095, 1158, 211,  274,  656,  719,  971,
  1034, 1156, 1219, 275,  338,  1157, 1220, 466,  529,  1096, 1159, 593,  656,
  1034, 1097, 846,  909,  783,  846,  909,  972,  339,  402,  1158, 1221, 19,
  19,   720,  783,  972,  1035, 1216, 1216, 20,   83,   1217, 1280, 84,   147,
  1218, 1281, 530,  593,  1097, 1160, 148,  211,  1219, 1282, 403,  466,  657,
  720,  1035, 1098, 1159, 1222, 212,  275,  1220, 1283, 847,  910,  910,  973,
  594,  657,  1098, 1161, 276,  339,  467,  530,  784,  847,  973,  1036, 1160,
  1223, 1221, 1284, 721,  784,  1036, 1099, 340,  403,  1222, 1285, 20,   20,
  1280, 1280, 21,   84,   531,  594,  1161, 1224, 1281, 1344, 85,   148,  658,
  721,  1099, 1162, 1282, 1345, 404,  467,  1223, 1286, 149,  212,  911,  974,
  1283, 1346, 848,  911,  974,  1037, 213,  276,  1284, 1347, 785,  848,  1037,
  1100, 595,  658,  1162, 1225, 468,  531,  1224, 1287, 277,  340,  1285, 1348,
  722,  785,  1100, 1163, 341,  404,  1286, 1349, 532,  595,  912,  975,  975,
  1038, 1225, 1288, 659,  722,  1163, 1226, 21,   21,   1344, 1344, 22,   85,
  849,  912,  1038, 1101, 1345, 1408, 86,   149,  1346, 1409, 405,  468,  1287,
  1350, 150,  213,  786,  849,  1101, 1164, 1347, 1410, 214,  277,  596,  659,
  1226, 1289, 1348, 1411, 469,  532,  723,  786,  1164, 1227, 1288, 1351, 278,
  341,  1349, 1412, 976,  1039, 913,  976,  1039, 1102, 342,  405,  850,  913,
  1102, 1165, 1350, 1413, 660,  723,  1227, 1290, 533,  596,  1289, 1352, 22,
  22,   1408, 1408, 23,   86,   787,  850,  1165, 1228, 1409, 1472, 87,   150,
  406,  469,  1351, 1414, 1410, 1473, 151,  214,  1411, 1474, 597,  660,  1290,
  1353, 724,  787,  1228, 1291, 215,  278,  977,  1040, 1040, 1103, 1412, 1475,
  470,  533,  1352, 1415, 914,  977,  1103, 1166, 279,  342,  1413, 1476, 851,
  914,  1166, 1229, 661,  724,  1291, 1354, 343,  406,  534,  597,  1353, 1416,
  1414, 1477, 788,  851,  1229, 1292, 23,   23,   1472, 1472, 24,   87,   1473,
  1536, 407,  470,  1041, 1104, 1415, 1478, 88,   151,  978,  1041, 1104, 1167,
  1474, 1537, 598,  661,  1354, 1417, 152,  215,  725,  788,  1292, 1355, 1475,
  1538, 915,  978,  1167, 1230, 216,  279,  1476, 1539, 471,  534,  1416, 1479,
  852,  915,  1230, 1293, 280,  343,  1477, 1540, 662,  725,  1355, 1418, 535,
  598,  789,  852,  1293, 1356, 1417, 1480, 344,  407,  1478, 1541, 1042, 1105,
  1105, 1168, 979,  1042, 1168, 1231, 24,   24,   408,  471,  916,  979,  1231,
  1294, 1479, 1542, 1536, 1536, 25,   88,   1537, 1600, 726,  789,  1356, 1419,
  89,   152,  599,  662,  1418, 1481, 1538, 1601, 153,  216,  1539, 1602, 853,
  916,  1294, 1357, 472,  535,  1480, 1543, 217,  280,  1540, 1603, 1106, 1169,
  281,  344,  663,  726,  1043, 1106, 1169, 1232, 1419, 1482, 1541, 1604, 790,
  853,  1357, 1420, 980,  1043, 1232, 1295, 536,  599,  1481, 1544, 345,  408,
  1542, 1605, 917,  980,  1295, 1358, 727,  790,  1420, 1483, 409,  472,  1543,
  1606, 25,   25,   600,  663,  1482, 1545, 1600, 1600, 26,   89,   1601, 1664,
  90,   153,  854,  917,  1358, 1421, 1602, 1665, 154,  217,  1107, 1170, 1170,
  1233, 1603, 1666, 473,  536,  1044, 1107, 1233, 1296, 1544, 1607, 218,  281,
  1604, 1667, 664,  727,  981,  1044, 1296, 1359, 1483, 1546, 791,  854,  1421,
  1484, 282,  345,  1605, 1668, 537,  600,  1545, 1608, 918,  981,  1359, 1422,
  346,  409,  1606, 1669, 728,  791,  1484, 1547, 1171, 1234, 1108, 1171, 1234,
  1297, 410,  473,  601,  664,  855,  918,  1422, 1485, 1546, 1609, 1607, 1670,
  26,   26,   1664, 1664, 27,   90,   1045, 1108, 1297, 1360, 1665, 1728, 91,
  154,  1666, 1729, 155,  218,  1667, 1730, 474,  537,  982,  1045, 1360, 1423,
  1608, 1671, 219,  282,  792,  855,  1485, 1548, 1668, 1731, 665,  728,  1547,
  1610, 283,  346,  919,  982,  1423, 1486, 1669, 1732, 538,  601,  1609, 1672,
  1172, 1235, 1235, 1298, 347,  410,  1109, 1172, 1298, 1361, 1670, 1733, 729,
  792,  1548, 1611, 856,  919,  1486, 1549, 1046, 1109, 1361, 1424, 602,  665,
  1610, 1673, 411,  474,  1671, 1734, 27,   27,   1728, 1728, 28,   91,   983,
  1046, 1424, 1487, 1729, 1792, 92,   155,  1730, 1793, 156,  219,  475,  538,
  1672, 1735, 1731, 1794, 793,  856,  1549, 1612, 666,  729,  1611, 1674, 220,
  283,  1236, 1299, 1732, 1795, 920,  983,  1487, 1550, 1173, 1236, 1299, 1362,
  1110, 1173, 1362, 1425, 284,  347,  1733, 1796, 539,  602,  1673, 1736, 1047,
  1110, 1425, 1488, 348,  411,  730,  793,  1612, 1675, 1734, 1797, 857,  920,
  1550, 1613, 603,  666,  1674, 1737, 984,  1047, 1488, 1551, 412,  475,  1735,
  1798, 28,   28,   1237, 1300, 1300, 1363, 1792, 1792, 29,   92,   1793, 1856,
  93,   156,  794,  857,  1174, 1237, 1363, 1426, 1613, 1676, 1794, 1857, 476,
  539,  1736, 1799, 157,  220,  667,  730,  921,  984,  1551, 1614, 1675, 1738,
  1795, 1858, 1111, 1174, 1426, 1489, 221,  284,  1796, 1859, 540,  603,  1048,
  1111, 1489, 1552, 1737, 1800, 285,  348,  1797, 1860, 858,  921,  1614, 1677,
  731,  794,  1676, 1739, 349,  412,  1798, 1861, 985,  1048, 1552, 1615, 1301,
  1364, 604,  667,  1238, 1301, 1364, 1427, 1738, 1801, 413,  476,  1175, 1238,
  1427, 1490, 1799, 1862, 795,  858,  1677, 1740, 29,   29,   1112, 1175, 1490,
  1553, 1856, 1856, 30,   93,   922,  985,  1615, 1678, 1857, 1920, 94,   157,
  1858, 1921, 477,  540,  668,  731,  1739, 1802, 1800, 1863, 158,  221,  1859,
  1922, 1049, 1112, 1553, 1616, 222,  285,  1860, 1923, 541,  604,  1801, 1864,
  286,  349,  859,  922,  1302, 1365, 1365, 1428, 1678, 1741, 1861, 1924, 732,
  795,  1740, 1803, 1239, 1302, 1428, 1491, 986,  1049, 1616, 1679, 350,  413,
  1862, 1925, 1176, 1239, 1491, 1554, 605,  668,  1802, 1865, 414,  477,  1113,
  1176, 1554, 1617, 1863, 1926, 796,  859,  1741, 1804, 923,  986,  1679, 1742,
  30,   30,   1920, 1920, 31,   94,   669,  732,  1803, 1866, 1921, 1984, 478,
  541,  1864, 1927, 95,   158,  1050, 1113, 1617, 1680, 1922, 1985, 1366, 1429,
  159,  222,  1303, 1366, 1429, 1492, 1923, 1986, 1240, 1303, 1492, 1555, 223,
  286,  1924, 1987, 860,  923,  1742, 1805, 542,  605,  1865, 1928, 733,  796,
  987,  1050, 1680, 1743, 1804, 1867, 287,  350,  1177, 1240, 1555, 1618, 1925,
  1988, 351,  414,  1926, 1989, 606,  669,  1114, 1177, 1618, 1681, 1866, 1929,
  924,  987,  1743, 1806, 415,  478,  797,  860,  1805, 1868, 1927, 1990, 1367,
  1430, 1430, 1493, 1304, 1367, 1493, 1556, 1051, 1114, 1681, 1744, 670,  733,
  1867, 1930, 31,   31,   1984, 1984, 32,   95,   479,  542,  1241, 1304, 1556,
  1619, 1928, 1991, 1985, 2048, 96,   159,  1986, 2049, 160,  223,  1987, 2050,
  861,  924,  1178, 1241, 1619, 1682, 1806, 1869, 224,  287,  988,  1051, 1744,
  1807, 1988, 2051, 543,  606,  1929, 1992, 734,  797,  1868, 1931, 288,  351,
  1989, 2052, 1115, 1178, 1682, 1745, 1431, 1494, 352,  415,  1368, 1431, 1494,
  1557, 1990, 2053, 607,  670,  1930, 1993, 925,  988,  1305, 1368, 1557, 1620,
  1807, 1870, 798,  861,  1869, 1932, 416,  479,  1052, 1115, 1745, 1808, 1991,
  2054, 1242, 1305, 1620, 1683, 671,  734,  1931, 1994, 480,  543,  1992, 2055,
  32,   32,   2048, 2048, 33,   96,   1179, 1242, 1683, 1746, 2049, 2112, 97,
  160,  2050, 2113, 862,  925,  1870, 1933, 989,  1052, 1808, 1871, 161,  224,
  2051, 2114, 225,  288,  544,  607,  735,  798,  1432, 1495, 1495, 1558, 1932,
  1995, 1993, 2056, 2052, 2115, 1116, 1179, 1746, 1809, 1369, 1432, 1558, 1621,
  289,  352,  2053, 2116, 1306, 1369, 1621, 1684, 608,  671,  1994, 2057, 353,
  416,  926,  989,  1871, 1934, 2054, 2117, 1243, 1306, 1684, 1747, 799,  862,
  1053, 1116, 1809, 1872, 1933, 1996, 417,  480,  2055, 2118, 672,  735,  1180,
  1243, 1747, 1810, 1995, 2058, 1496, 1559, 481,  544,  2056, 2119, 1433, 1496,
  1559, 1622, 33,   33,   990,  1053, 1872, 1935, 2112, 2112, 34,   97,   863,
  926,  1934, 1997, 2113, 2176, 98,   161,  1370, 1433, 1622, 1685, 2114, 2177,
  162,  225,  1117, 1180, 1810, 1873, 2115, 2178, 736,  799,  1996, 2059, 545,
  608,  1307, 1370, 1685, 1748, 2057, 2120, 226,  289,  2116, 2179, 290,  353,
  2117, 2180, 1244, 1307, 1748, 1811, 927,  990,  1935, 1998, 609,  672,  1054,
  1117, 1873, 1936, 2058, 2121, 354,  417,  2118, 2181, 800,  863,  1997, 2060,
  1497, 1560, 1560, 1623, 1181, 1244, 1811, 1874, 418,  481,  1434, 1497, 1623,
  1686, 2119, 2182, 673,  736,  2059, 2122, 1371, 1434, 1686, 1749, 991,  1054,
  1936, 1999, 482,  545,  864,  927,  1998, 2061, 2120, 2183, 1118, 1181, 1874,
  1937, 34,   34,   1308, 1371, 1749, 1812, 2176, 2176, 35,   98,   2177, 2240,
  99,   162,  2178, 2241, 737,  800,  2060, 2123, 163,  226,  2179, 2242, 546,
  609,  2121, 2184, 227,  290,  1245, 1308, 1812, 1875, 2180, 2243, 928,  991,
  1999, 2062, 291,  354,  1055, 1118, 1561, 1624, 1937, 2000, 2181, 2244, 1498,
  1561, 1624, 1687, 610,  673,  2122, 2185, 801,  864,  1435, 1498, 1687, 1750,
  2061, 2124, 355,  418,  1182, 1245, 1875, 1938, 2182, 2245, 1372, 1435, 1750,
  1813, 419,  482,  2183, 2246, 674,  737,  2123, 2186, 992,  1055, 2000, 2063,
  1309, 1372, 1813, 1876, 865,  928,  1119, 1182, 1938, 2001, 2062, 2125, 483,
  546,  2184, 2247, 35,   35,   2240, 2240, 36,   99,   2241, 2304, 100,  163,
  738,  801,  1246, 1309, 1876, 1939, 2124, 2187, 2242, 2305, 1562, 1625, 1625,
  1688, 164,  227,  1499, 1562, 1688, 1751, 2243, 2306, 547,  610,  2185, 2248,
  228,  291,  2244, 2307, 1056, 1119, 1436, 1499, 1751, 1814, 2001, 2064, 929,
  992,  2063, 2126, 292,  355,  2245, 2308, 1183, 1246, 1939, 2002, 611,  674,
  802,  865,  1373, 1436, 1814, 1877, 2125, 2188, 2186, 2249, 356,  419,  2246,
  2309, 1310, 1373, 1877, 1940, 420,  483,  993,  1056, 2064, 2127, 2247, 2310,
  675,  738,  2187, 2250, 1120, 1183, 2002, 2065, 866,  929,  1626, 1689, 2126,
  2189, 1563, 1626, 1689, 1752, 484,  547,  1500, 1563, 1752, 1815, 2248, 2311,
  1247, 1310, 1940, 2003, 36,   36,   739,  802,  2188, 2251, 2304, 2304, 37,
  100,  1437, 1500, 1815, 1878, 2305, 2368, 101,  164,  2306, 2369, 548,  611,
  2249, 2312, 165,  228,  1057, 1120, 2065, 2128, 2307, 2370, 930,  993,  2127,
  2190, 1374, 1437, 1878, 1941, 229,  292,  1184, 1247, 2003, 2066, 2308, 2371,
  293,  356,  803,  866,  2189, 2252, 2309, 2372, 612,  675,  2250, 2313, 1311,
  1374, 1941, 2004, 357,  420,  1627, 1690, 1690, 1753, 2310, 2373, 1564, 1627,
  1753, 1816, 994,  1057, 2128, 2191, 1121, 1184, 2066, 2129, 676,  739,  1501,
  1564, 1816, 1879, 2251, 2314, 421,  484,  2311, 2374, 867,  930,  2190, 2253,
  1248, 1311, 2004, 2067, 1438, 1501, 1879, 1942, 485,  548,  2312, 2375, 740,
  803,  2252, 2315, 37,   37,   2368, 2368, 38,   101,  1058, 1121, 1375, 1438,
  1942, 2005, 2129, 2192, 2369, 2432, 102,  165,  2370, 2433, 549,  612,  931,
  994,  1185, 1248, 2067, 2130, 2191, 2254, 2313, 2376, 166,  229,  2371, 2434,
  1691, 1754, 230,  293,  1628, 1691, 1754, 1817, 2372, 2435, 804,  867,  1312,
  1375, 2005, 2068, 2253, 2316, 1565, 1628, 1817, 1880, 294,  357,  613,  676,
  2314, 2377, 2373, 2436, 1502, 1565, 1880, 1943, 358,  421,  1122, 1185, 2130,
  2193, 2374, 2437, 995,  1058, 2192, 2255, 1249, 1312, 2068, 2131, 677,  740,
  1439, 1502, 1943, 2006, 2315, 2378, 868,  931,  2254, 2317, 422,  485,  2375,
  2438, 486,  549,  1376, 1439, 2006, 2069, 2376, 2439, 741,  804,  1692, 1755,
  1755, 1818, 2316, 2379, 1059, 1122, 2193, 2256, 1186, 1249, 1629, 1692, 1818,
  1881, 2131, 2194, 38,   38,   932,  995,  2255, 2318, 2432, 2432, 39,   102,
  2433, 2496, 103,  166,  550,  613,  1566, 1629, 1881, 1944, 2377, 2440, 2434,
  2497, 167,  230,  1313, 1376, 2069, 2132, 2435, 2498, 231,  294,  1503, 1566,
  1944, 2007, 2436, 2499, 805,  868,  2317, 2380, 614,  677,  2378, 2441, 295,
  358,  2437, 2500, 1123, 1186, 2194, 2257, 996,  1059, 2256, 2319, 1440, 1503,
  2007, 2070, 1250, 1313, 2132, 2195, 359,  422,  2438, 2501, 678,  741,  869,
  932,  2318, 2381, 2379, 2442, 1756, 1819, 423,  486,  1693, 1756, 1819, 1882,
  2439, 2502, 1377, 1440, 2070, 2133, 1630, 1693, 1882, 1945, 487,  550,  1060,
  1123, 2257, 2320, 2440, 2503, 1187, 1250, 1567, 1630, 1945, 2008, 2195, 2258,
  742,  805,  2380, 2443, 933,  996,  2319, 2382, 1314, 1377, 2133, 2196, 39,
  39,   1504, 1567, 2008, 2071, 2496, 2496, 40,   103,  2497, 2560, 551,  614,
  2441, 2504, 104,  167,  2498, 2561, 168,  231,  2499, 2562, 806,  869,  2381,
  2444, 232,  295,  2500, 2563, 1441, 1504, 2071, 2134, 1124, 1187, 2258, 2321,
  615,  678,  2442, 2505, 296,  359,  997,  1060, 1251, 1314, 1757, 1820, 1820,
  1883, 2196, 2259, 2320, 2383, 2501, 2564, 1694, 1757, 1883, 1946, 360,  423,
  2502, 2565, 1631, 1694, 1946, 2009, 870,  933,  1378, 1441, 2134, 2197, 2382,
  2445, 679,  742,  2443, 2506, 424,  487,  1568, 1631, 2009, 2072, 2503, 2566,
  1188, 1251, 2259, 2322, 1061, 1124, 2321, 2384, 488,  551,  2504, 2567, 743,
  806,  1505, 1568, 2072, 2135, 2444, 2507, 1315, 1378, 2197, 2260, 934,  997,
  2383, 2446, 40,   40,   552,  615,  2505, 2568, 2560, 2560, 41,   104,  1821,
  1884, 2561, 2624, 1758, 1821, 1884, 1947, 105,  168,  1442, 1505, 2135, 2198,
  2562, 2625, 169,  232,  807,  870,  1695, 1758, 1947, 2010, 2445, 2508, 2563,
  2626, 1125, 1188, 2322, 2385, 1252, 1315, 2260, 2323, 233,  296,  2564, 2627,
  616,  679,  998,  1061, 1632, 1695, 2010, 2073, 2384, 2447, 2506, 2569, 297,
  360,  2565, 2628, 1379, 1442, 2198, 2261, 1569, 1632, 2073, 2136, 361,  424,
  871,  934,  2446, 2509, 2566, 2629, 680,  743,  2507, 2570, 425,  488,  1189,
  1252, 2323, 2386, 2567, 2630, 1506, 1569, 2136, 2199, 1062, 1125, 2385, 2448,
  1316, 1379, 2261, 2324, 1822, 1885, 1885, 1948, 744,  807,  2508, 2571, 489,
  552,  1759, 1822, 1948, 2011, 2568, 2631, 935,  998,  2447, 2510, 1696, 1759,
  2011, 2074, 1443, 1506, 2199, 2262, 553,  616,  2569, 2632, 41,   41,   2624,
  2624, 42,   105,  1633, 1696, 2074, 2137, 2625, 2688, 106,  169,  1126, 1189,
  2386, 2449, 2626, 2689, 808,  871,  1253, 1316, 2324, 2387, 2509, 2572, 170,
  233,  2627, 2690, 999,  1062, 2448, 2511, 234,  297,  1380, 1443, 2262, 2325,
  2628, 2691, 617,  680,  1570, 1633, 2137, 2200, 2570, 2633, 298,  361,  2629,
  2692, 872,  935,  2510, 2573, 362,  425,  1886, 1949, 2630, 2693, 1507, 1570,
  2200, 2263, 681,  744,  1823, 1886, 1949, 2012, 2571, 2634, 1190, 1253, 2387,
  2450, 1760, 1823, 2012, 2075, 1063, 1126, 1317, 1380, 2325, 2388, 2449, 2512,
  426,  489,  2631, 2694, 1697, 1760, 2075, 2138, 745,  808,  936,  999,  1444,
  1507, 2263, 2326, 2511, 2574, 2572, 2635, 490,  553,  2632, 2695, 1634, 1697,
  2138, 2201, 1254, 1317, 2388, 2451, 554,  617,  1127, 1190, 2450, 2513, 2633,
  2696, 42,   42,   2688, 2688, 43,   106,  809,  872,  1571, 1634, 2201, 2264,
  2573, 2636, 2689, 2752, 107,  170,  1381, 1444, 2326, 2389, 2690, 2753, 1000,
  1063, 2512, 2575, 171,  234,  2691, 2754, 1887, 1950, 1950, 2013, 618,  681,
  2634, 2697, 235,  298,  1824, 1887, 2013, 2076, 2692, 2755, 1508, 1571, 2264,
  2327, 1761, 1824, 2076, 2139, 299,  362,  2693, 2756, 873,  936,  2574, 2637,
  1191, 1254, 2451, 2514, 363,  426,  682,  745,  1318, 1381, 1698, 1761, 2139,
  2202, 2389, 2452, 2635, 2698, 2694, 2757, 1064, 1127, 2513, 2576, 427,  490,
  1445, 1508, 2327, 2390, 2695, 2758, 1635, 1698, 2202, 2265, 937,  1000, 2575,
  2638, 746,  809,  2636, 2699, 491,  554,  2696, 2759, 1255, 1318, 1572, 1635,
  2265, 2328, 2452, 2515, 1951, 2014, 1128, 1191, 1888, 1951, 2014, 2077, 2514,
  2577, 1382, 1445, 2390, 2453, 555,  618,  1825, 1888, 2077, 2140, 2697, 2760,
  810,  873,  2637, 2700, 43,   43,   2752, 2752, 44,   107,  1001, 1064, 2576,
  2639, 2753, 2816, 108,  171,  1762, 1825, 2140, 2203, 2754, 2817, 172,  235,
  1509, 1572, 2328, 2391, 2755, 2818, 619,  682,  2698, 2761, 236,  299,  2756,
  2819, 1699, 1762, 2203, 2266, 874,  937,  2638, 2701, 300,  363,  1192, 1255,
  2515, 2578, 2757, 2820, 1319, 1382, 2453, 2516, 683,  746,  1065, 1128, 2577,
  2640, 2699, 2762, 364,  427,  1636, 1699, 2266, 2329, 2758, 2821, 1446, 1509,
  2391, 2454, 428,  491,  1952, 2015, 2015, 2078, 2759, 2822, 938,  1001, 1889,
  1952, 2078, 2141, 2639, 2702, 747,  810,  2700, 2763, 1573, 1636, 2329, 2392,
  1826, 1889, 2141, 2204, 492,  555,  1256, 1319, 2516, 2579, 2760, 2823, 1129,
  1192, 1383, 1446, 2454, 2517, 2578, 2641, 1763, 1826, 2204, 2267, 556,  619,
  2761, 2824, 811,  874,  2701, 2764, 1002, 1065, 1510, 1573, 2392, 2455, 2640,
  2703, 44,   44,   1700, 1763, 2267, 2330, 2816, 2816, 45,   108,  2817, 2880,
  109,  172,  2818, 2881, 173,  236,  2819, 2882, 620,  683,  2762, 2825, 237,
  300,  1320, 1383, 2517, 2580, 2820, 2883, 1193, 1256, 2579, 2642, 875,  938,
  1637, 1700, 2330, 2393, 2702, 2765, 2016, 2079, 301,  364,  1447, 1510, 1953,
  2016, 2079, 2142, 2455, 2518, 2821, 2884, 1066, 1129, 2641, 2704, 1890, 1953,
  2142, 2205, 684,  747,  2763, 2826, 365,  428,  2822, 2885, 1827, 1890, 2205,
  2268, 1574, 1637, 2393, 2456, 429,  492,  939,  1002, 2703, 2766, 2823, 2886,
  748,  811,  1764, 1827, 2268, 2331, 2764, 2827, 1257, 1320, 2580, 2643, 1384,
  1447, 2518, 2581, 1130, 1193, 2642, 2705, 493,  556,  2824, 2887, 1511, 1574,
  2456, 2519, 1701, 1764, 2331, 2394, 812,  875,  1003, 1066, 2704, 2767, 2765,
  2828, 557,  620,  2825, 2888, 2017, 2080, 2080, 2143, 45,   45,   2880, 2880,
  46,   109,  1954, 2017, 2143, 2206, 2881, 2944, 110,  173,  1638, 1701, 2394,
  2457, 2882, 2945, 1321, 1384, 2581, 2644, 174,  237,  621,  684,  1194, 1257,
  1891, 1954, 2206, 2269, 2643, 2706, 2826, 2889, 2883, 2946, 1448, 1511, 2519,
  2582, 238,  301,  876,  939,  2766, 2829, 2884, 2947, 1828, 1891, 2269, 2332,
  1067, 1130, 2705, 2768, 302,  365,  2885, 2948, 685,  748,  1575, 1638, 2457,
  2520, 2827, 2890, 366,  429,  2886, 2949, 1765, 1828, 2332, 2395, 940,  1003,
  2767, 2830, 1258, 1321, 2644, 2707, 430,  493,  1385, 1448, 2582, 2645, 2887,
  2950, 749,  812,  2828, 2891, 1131, 1194, 1702, 1765, 2395, 2458, 2706, 2769,
  1512, 1575, 2520, 2583, 2081, 2144, 494,  557,  2018, 2081, 2144, 2207, 2888,
  2951, 1955, 2018, 2207, 2270, 1004, 1067, 2768, 2831, 813,  876,  2829, 2892,
  1892, 1955, 2270, 2333, 558,  621,  1639, 1702, 2458, 2521, 2889, 2952, 1322,
  1385, 2645, 2708, 46,   46,   2944, 2944, 47,   110,  1195, 1258, 1449, 1512,
  1829, 1892, 2333, 2396, 2583, 2646, 2707, 2770, 2945, 3008, 111,  174,  2946,
  3009, 622,  685,  2890, 2953, 175,  238,  2947, 3010, 877,  940,  2830, 2893,
  239,  302,  1068, 1131, 1576, 1639, 2521, 2584, 2769, 2832, 2948, 3011, 1766,
  1829, 2396, 2459, 303,  366,  2949, 3012, 686,  749,  2891, 2954, 367,  430,
  2082, 2145, 2145, 2208, 2950, 3013, 1386, 1449, 2646, 2709, 1259, 1322, 2019,
  2082, 2208, 2271, 2708, 2771, 941,  1004, 1703, 1766, 2459, 2522, 2831, 2894,
  1513, 1576, 1956, 2019, 2271, 2334, 2584, 2647, 431,  494,  2951, 3014, 750,
  813,  1132, 1195, 2770, 2833, 2892, 2955, 1893, 1956, 2334, 2397, 495,  558,
  2952, 3015, 1640, 1703, 2522, 2585, 1005, 1068, 2832, 2895, 814,  877,  1830,
  1893, 2397, 2460, 2893, 2956, 559,  622,  1323, 1386, 2709, 2772, 2953, 3016,
  1450, 1513, 2647, 2710, 1196, 1259, 2771, 2834, 47,   47,   3008, 3008, 48,
  111,  1767, 1830, 2460, 2523, 3009, 3072, 1577, 1640, 2585, 2648, 112,  175,
  3010, 3073, 623,  686,  2954, 3017, 878,  941,  2146, 2209, 2894, 2957, 176,
  239,  3011, 3074, 1069, 1132, 2083, 2146, 2209, 2272, 2833, 2896, 240,  303,
  2020, 2083, 2272, 2335, 3012, 3075, 304,  367,  1704, 1767, 2523, 2586, 3013,
  3076, 687,  750,  1957, 2020, 2335, 2398, 2955, 3018, 1387, 1450, 2710, 2773,
  1260, 1323, 2772, 2835, 368,  431,  1514, 1577, 2648, 2711, 3014, 3077, 942,
  1005, 2895, 2958, 1894, 1957, 2398, 2461, 1133, 1196, 2834, 2897, 432,  495,
  751,  814,  2956, 3019, 3015, 3078, 1641, 1704, 2586, 2649, 1831, 1894, 2461,
  2524, 496,  559,  3016, 3079, 1006, 1069, 2896, 2959, 1324, 1387, 2773, 2836,
  815,  878,  1451, 1514, 2711, 2774, 2957, 3020, 2147, 2210, 2210, 2273, 1768,
  1831, 2524, 2587, 560,  623,  2084, 2147, 2273, 2336, 3017, 3080, 1197, 1260,
  2835, 2898, 1578, 1641, 2649, 2712, 2021, 2084, 2336, 2399, 48,   48,   3072,
  3072, 49,   112,  3073, 3136, 624,  687,  3018, 3081, 113,  176,  879,  942,
  1070, 1133, 1958, 2021, 2399, 2462, 2897, 2960, 2958, 3021, 3074, 3137, 177,
  240,  1705, 1768, 2587, 2650, 3075, 3138, 241,  304,  3076, 3139, 1388, 1451,
  2774, 2837, 1895, 1958, 2462, 2525, 688,  751,  1261, 1324, 1515, 1578, 2712,
  2775, 2836, 2899, 3019, 3082, 305,  368,  3077, 3140, 943,  1006, 2959, 3022,
  369,  432,  3078, 3141, 1134, 1197, 1642, 1705, 2650, 2713, 2898, 2961, 1832,
  1895, 2525, 2588, 752,  815,  3020, 3083, 433,  496,  2211, 2274, 3079, 3142,
  2148, 2211, 2274, 2337, 2085, 2148, 2337, 2400, 497,  560,  1007, 1070, 1452,
  1515, 1769, 1832, 2588, 2651, 2775, 2838, 2960, 3023, 3080, 3143, 1325, 1388,
  2837, 2900, 2022, 2085, 2400, 2463, 816,  879,  3021, 3084, 1579, 1642, 2713,
  2776, 1198, 1261, 2899, 2962, 561,  624,  1959, 2022, 2463, 2526, 3081, 3144,
  1706, 1769, 2651, 2714, 1071, 1134, 2961, 3024, 49,   49,   880,  943,  1896,
  1959, 2526, 2589, 3022, 3085, 3136, 3136, 50,   113,  625,  688,  3082, 3145,
  3137, 3200, 114,  177,  3138, 3201, 178,  241,  1389, 1452, 2838, 2901, 3139,
  3202, 1516, 1579, 2776, 2839, 242,  305,  1262, 1325, 2900, 2963, 3140, 3203,
  2212, 2275, 2275, 2338, 689,  752,  1833, 1896, 2589, 2652, 3083, 3146, 306,
  369,  1643, 1706, 2149, 2212, 2338, 2401, 2714, 2777, 3141, 3204, 944,  1007,
  3023, 3086, 1135, 1198, 2086, 2149, 2401, 2464, 2962, 3025, 370,  433,  3142,
  3205, 753,  816,  2023, 2086, 2464, 2527, 3084, 3147, 1770, 1833, 2652, 2715,
  434,  497,  3143, 3206, 1453, 1516, 2839, 2902, 1326, 1389, 2901, 2964, 1008,
  1071, 3024, 3087, 1580, 1643, 1960, 2023, 2527, 2590, 2777, 2840, 498,  561,
  3144, 3207, 817,  880,  1199, 1262, 2963, 3026, 3085, 3148, 1707, 1770, 2715,
  2778, 562,  625,  1897, 1960, 2590, 2653, 3145, 3208, 2276, 2339, 1072, 1135,
  3025, 3088, 2213, 2276, 2339, 2402, 881,  944,  3086, 3149, 626,  689,  1390,
  1453, 2150, 2213, 2402, 2465, 2902, 2965, 3146, 3209, 50,   50,   1517, 1580,
  2840, 2903, 3200, 3200, 51,   114,  3201, 3264, 115,  178,  1834, 1897, 2653,
  2716, 3202, 3265, 1263, 1326, 2964, 3027, 179,  242,  2087, 2150, 2465, 2528,
  3203, 3266, 1644, 1707, 2778, 2841, 243,  306,  3204, 3267, 690,  753,  3147,
  3210, 2024, 2087, 2528, 2591, 307,  370,  945,  1008, 3087, 3150, 3205, 3268,
  1136, 1199, 3026, 3089, 1771, 1834, 2716, 2779, 371,  434,  3206, 3269, 1961,
  2024, 2591, 2654, 754,  817,  3148, 3211, 1454, 1517, 2903, 2966, 435,  498,
  1327, 1390, 1581, 1644, 2841, 2904, 2965, 3028, 3207, 3270, 1009, 1072, 3088,
  3151, 1898, 1961, 2654, 2717, 499,  562,  1200, 1263, 1708, 1771, 2277, 2340,
  2340, 2403, 2779, 2842, 3027, 3090, 3208, 3271, 818,  881,  2214, 2277, 2403,
  2466, 3149, 3212, 2151, 2214, 2466, 2529, 563,  626,  3209, 3272, 2088, 2151,
  2529, 2592, 1073, 1136, 1835, 1898, 2717, 2780, 3089, 3152, 1518, 1581, 2904,
  2967, 1391, 1454, 2966, 3029, 882,  945,  3150, 3213, 627,  690,  1645, 1708,
  2842, 2905, 3210, 3273, 51,   51,   1264, 1327, 3028, 3091, 3264, 3264, 52,
  115,  2025, 2088, 2592, 2655, 3265, 3328, 116,  179,  3266, 3329, 180,  243,
  3267, 3330, 244,  307,  1772, 1835, 2780, 2843, 3268, 3331, 691,  754,  3211,
  3274, 946,  1009, 1137, 1200, 1962, 2025, 2655, 2718, 3090, 3153, 3151, 3214,
  308,  371,  3269, 3332, 1455, 1518, 2341, 2404, 2967, 3030, 372,  435,  2278,
  2341, 2404, 2467, 3270, 3333, 1582, 1645, 2905, 2968, 755,  818,  1328, 1391,
  3029, 3092, 3212, 3275, 2215, 2278, 2467, 2530, 1899, 1962, 2718, 2781, 436,
  499,  3271, 3334, 1709, 1772, 2843, 2906, 1010, 1073, 2152, 2215, 2530, 2593,
  3152, 3215, 1201, 1264, 3091, 3154, 500,  563,  3272, 3335, 819,  882,  2089,
  2152, 2593, 2656, 3213, 3276, 1836, 1899, 2781, 2844, 564,  627,  1519, 1582,
  2968, 3031, 3273, 3336, 1392, 1455, 2026, 2089, 2656, 2719, 3030, 3093, 1074,
  1137, 3153, 3216, 1646, 1709, 2906, 2969, 883,  946,  3214, 3277, 1265, 1328,
  3092, 3155, 628,  691,  3274, 3337, 52,   52,   1773, 1836, 2844, 2907, 3328,
  3328, 53,   116,  1963, 2026, 2719, 2782, 3329, 3392, 117,  180,  2342, 2405,
  2405, 2468, 3330, 3393, 2279, 2342, 2468, 2531, 181,  244,  3331, 3394, 1138,
  1201, 3154, 3217, 245,  308,  692,  755,  2216, 2279, 2531, 2594, 3275, 3338,
  3332, 3395, 947,  1010, 3215, 3278, 1456, 1519, 3031, 3094, 309,  372,  1583,
  1646, 2969, 3032, 3333, 3396, 1900, 1963, 2782, 2845, 2153, 2216, 2594, 2657,
  1329, 1392, 3093, 3156, 373,  436,  1710, 1773, 2907, 2970, 3334, 3397, 756,
  819,  3276, 3339, 2090, 2153, 2657, 2720, 1011, 1074, 3216, 3279, 437,  500,
  3335, 3398, 1202, 1265, 3155, 3218, 1837, 1900, 2845, 2908, 501,  564,  820,
  883,  2027, 2090, 2720, 2783, 3277, 3340, 3336, 3399, 1520, 1583, 3032, 3095,
  1393, 1456, 1647, 1710, 2970, 3033, 3094, 3157, 2406, 2469, 565,  628,  1075,
  1138, 2343, 2406, 2469, 2532, 3217, 3280, 3337, 3400, 2280, 2343, 2532, 2595,
  1964, 2027, 2783, 2846, 884,  947,  1266, 1329, 1774, 1837, 2908, 2971, 3156,
  3219, 3278, 3341, 2217, 2280, 2595, 2658, 629,  692,  3338, 3401, 53,   53,
  3392, 3392, 54,   117,  3393, 3456, 118,  181,  2154, 2217, 2658, 2721, 3394,
  3457, 182,  245,  1139, 1202, 1901, 1964, 2846, 2909, 3218, 3281, 3395, 3458,
  948,  1011, 1584, 1647, 3033, 3096, 3279, 3342, 693,  756,  1457, 1520, 3095,
  3158, 3339, 3402, 246,  309,  3396, 3459, 1711, 1774, 2091, 2154, 2721, 2784,
  2971, 3034, 310,  373,  1330, 1393, 3157, 3220, 3397, 3460, 374,  437,  3398,
  3461, 757,  820,  3340, 3403, 1838, 1901, 2909, 2972, 1012, 1075, 2028, 2091,
  2784, 2847, 3280, 3343, 1203, 1266, 3219, 3282, 438,  501,  2407, 2470, 2470,
  2533, 3399, 3462, 2344, 2407, 2533, 2596, 1521, 1584, 2281, 2344, 2596, 2659,
  3096, 3159, 821,  884,  3341, 3404, 502,  565,  1648, 1711, 3034, 3097, 3400,
  3463, 1394, 1457, 3158, 3221, 1965, 2028, 2847, 2910, 2218, 2281, 2659, 2722,
  1076, 1139, 1775, 1838, 2972, 3035, 3281, 3344, 566,  629,  3401, 3464, 1267,
  1330, 3220, 3283, 885,  948,  2155, 2218, 2722, 2785, 3342, 3405, 630,  693,
  1902, 1965, 2910, 2973, 3402, 3465, 54,   54,   2092, 2155, 2785, 2848, 3456,
  3456, 55,   118,  1585, 1648, 3097, 3160, 3457, 3520, 1140, 1203, 3282, 3345,
  119,  182,  1458, 1521, 3159, 3222, 3458, 3521, 1712, 1775, 3035, 3098, 183,
  246,  949,  1012, 3343, 3406, 3459, 3522, 694,  757,  3403, 3466, 247,  310,
  3460, 3523, 1331, 1394, 2471, 2534, 3221, 3284, 2408, 2471, 2534, 2597, 2029,
  2092, 2848, 2911, 311,  374,  1839, 1902, 2345, 2408, 2597, 2660, 2973, 3036,
  3461, 3524, 758,  821,  2282, 2345, 2660, 2723, 3404, 3467, 375,  438,  3462,
  3525, 1013, 1076, 1204, 1267, 3283, 3346, 3344, 3407, 439,  502,  2219, 2282,
  2723, 2786, 3463, 3526, 1522, 1585, 3160, 3223, 1649, 1712, 1966, 2029, 2911,
  2974, 3098, 3161, 822,  885,  1395, 1458, 3222, 3285, 3405, 3468, 1776, 1839,
  3036, 3099, 503,  566,  3464, 3527, 2156, 2219, 2786, 2849, 1077, 1140, 3345,
  3408, 1268, 1331, 3284, 3347, 567,  630,  3465, 3528, 1903, 1966, 2974, 3037,
  886,  949,  3406, 3469, 2093, 2156, 2849, 2912, 2472, 2535, 2535, 2598, 631,
  694,  1586, 1649, 2409, 2472, 2598, 2661, 3161, 3224, 3466, 3529, 1459, 1522,
  1713, 1776, 3099, 3162, 3223, 3286, 1141, 1204, 2346, 2409, 2661, 2724, 3346,
  3409, 55,   55,   3520, 3520, 56,   119,  3521, 3584, 120,  183,  2030, 2093,
  2912, 2975, 3522, 3585, 950,  1013, 3407, 3470, 184,  247,  1332, 1395, 1840,
  1903, 2283, 2346, 2724, 2787, 3037, 3100, 3285, 3348, 3523, 3586, 695,  758,
  3467, 3530, 248,  311,  3524, 3587, 312,  375,  2220, 2283, 2787, 2850, 3525,
  3588, 759,  822,  3468, 3531, 1205, 1268, 1967, 2030, 2975, 3038, 3347, 3410,
  376,  439,  1014, 1077, 3408, 3471, 3526, 3589, 1650, 1713, 3162, 3225, 1523,
  1586, 3224, 3287, 2157, 2220, 2850, 2913, 440,  503,  1777, 1840, 3100, 3163,
  3527, 3590, 1396, 1459, 3286, 3349, 823,  886,  3469, 3532, 504,  567,  2536,
  2599, 3528, 3591, 2473, 2536, 2599, 2662, 1904, 1967, 3038, 3101, 1078, 1141,
  2094, 2157, 2913, 2976, 3409, 3472, 2410, 2473, 2662, 2725, 1269, 1332, 3348,
  3411, 568,  631,  3529, 3592, 2347, 2410, 2725, 2788, 887,  950,  3470, 3533,
  1587, 1650, 3225, 3288, 1714, 1777, 3163, 3226, 2284, 2347, 2788, 2851, 1460,
  1523, 2031, 2094, 2976, 3039, 3287, 3350, 632,  695,  3530, 3593, 1142, 1205,
  3410, 3473, 1841, 1904, 3101, 3164, 56,   56,   3584, 3584, 57,   120,  951,
  1014, 1333, 1396, 2221, 2284, 2851, 2914, 3349, 3412, 3471, 3534, 3585, 3648,
  121,  184,  3586, 3649, 696,  759,  3531, 3594, 185,  248,  3587, 3650, 249,
  312,  1968, 2031, 3039, 3102, 3588, 3651, 2158, 2221, 2914, 2977, 313,  376,
  3589, 3652, 1206, 1269, 1651, 1714, 3226, 3289, 3411, 3474, 760,  823,  1524,
  1587, 3288, 3351, 3532, 3595, 1015, 1078, 2537, 2600, 2600, 2663, 3472, 3535,
  1778, 1841, 3164, 3227, 377,  440,  2474, 2537, 2663, 2726, 3590, 3653, 1397,
  1460, 2411, 2474, 2726, 2789, 3350, 3413, 441,  504,  2095, 2158, 2977, 3040,
  3591, 3654, 1905, 1968, 3102, 3165, 824,  887,  2348, 2411, 2789, 2852, 3533,
  3596, 505,  568,  3592, 3655, 1079, 1142, 3473, 3536, 1270, 1333, 3412, 3475,
  2285, 2348, 2852, 2915, 2032, 2095, 3040, 3103, 1588, 1651, 3289, 3352, 569,
  632,  1715, 1778, 3227, 3290, 3593, 3656, 888,  951,  3534, 3597, 1461, 1524,
  3351, 3414, 1842, 1905, 2222, 2285, 2915, 2978, 3165, 3228, 633,  696,  1143,
  1206, 3474, 3537, 3594, 3657, 1334, 1397, 3413, 3476, 952,  1015, 3535, 3598,
  1969, 2032, 2601, 2664, 3103, 3166, 57,   57,   2538, 2601, 2664, 2727, 3648,
  3648, 58,   121,  2159, 2222, 2978, 3041, 3649, 3712, 122,  185,  3650, 3713,
  697,  760,  2475, 2538, 2727, 2790, 3595, 3658, 186,  249,  3651, 3714, 250,
  313,  1652, 1715, 2412, 2475, 2790, 2853, 3290, 3353, 3652, 3715, 1525, 1588,
  1779, 1842, 3228, 3291, 3352, 3415, 1207, 1270, 3475, 3538, 314,  377,  3653,
  3716, 1016, 1079, 3536, 3599, 761,  824,  2096, 2159, 3041, 3104, 3596, 3659,
  2349, 2412, 2853, 2916, 378,  441,  1398, 1461, 1906, 1969, 3166, 3229, 3414,
  3477, 3654, 3717, 2286, 2349, 2916, 2979, 442,  505,  3655, 3718, 825,  888,
  3597, 3660, 1080, 1143, 1271, 1334, 2033, 2096, 3104, 3167, 3476, 3539, 3537,
  3600, 506,  569,  3656, 3719, 1716, 1779, 3291, 3354, 1589, 1652, 2223, 2286,
  2979, 3042, 3353, 3416, 1843, 1906, 3229, 3292, 570,  633,  889,  952,  1462,
  1525, 2602, 2665, 2665, 2728, 3415, 3478, 3598, 3661, 3657, 3720, 2539, 2602,
  2728, 2791, 2476, 2539, 2791, 2854, 1144, 1207, 2160, 2223, 3042, 3105, 3538,
  3601, 1970, 2033, 3167, 3230, 634,  697,  3658, 3721, 1335, 1398, 3477, 3540,
  2413, 2476, 2854, 2917, 953,  1016, 3599, 3662, 58,   58,   3712, 3712, 59,
  122,  3713, 3776, 123,  186,  698,  761,  1653, 1716, 2350, 2413, 2917, 2980,
  3354, 3417, 3659, 3722, 3714, 3777, 1780, 1843, 3292, 3355, 187,  250,  2097,
  2160, 3105, 3168, 3715, 3778, 1526, 1589, 3416, 3479, 251,  314,  1208, 1271,
  3539, 3602, 3716, 3779, 1907, 1970, 3230, 3293, 1017, 1080, 2287, 2350, 2980,
  3043, 3600, 3663, 315,  378,  3717, 3780, 762,  825,  3660, 3723, 1399, 1462,
  3478, 3541, 379,  442,  3718, 3781, 2034, 2097, 3168, 3231, 2666, 2729, 2224,
  2287, 3043, 3106, 443,  506,  2603, 2666, 2729, 2792, 3719, 3782, 826,  889,
  3661, 3724, 1272, 1335, 2540, 2603, 2792, 2855, 3540, 3603, 1081, 1144, 1717,
  1780, 3355, 3418, 3601, 3664, 1590, 1653, 3417, 3480, 507,  570,  1844, 1907,
  3293, 3356, 3720, 3783, 2477, 2540, 2855, 2918, 1463, 1526, 3479, 3542, 2161,
  2224, 3106, 3169, 890,  953,  2414, 2477, 2918, 2981, 3662, 3725, 571,  634,
  1971, 2034, 3231, 3294, 3721, 3784, 1145, 1208, 3602, 3665, 1336, 1399, 3541,
  3604, 2351, 2414, 2981, 3044, 635,  698,  3722, 3785, 954,  1017, 2098, 2161,
  3169, 3232, 3663, 3726, 1654, 1717, 3418, 3481, 1781, 1844, 3356, 3419, 59,
  59,   2288, 2351, 3044, 3107, 3776, 3776, 60,   123,  1527, 1590, 3480, 3543,
  3777, 3840, 699,  762,  3723, 3786, 124,  187,  1908, 1971, 3294, 3357, 3778,
  3841, 188,  251,  3779, 3842, 1209, 1272, 3603, 3666, 2667, 2730, 2730, 2793,
  252,  315,  3780, 3843, 2604, 2667, 2793, 2856, 1018, 1081, 1400, 1463, 3542,
  3605, 3664, 3727, 316,  379,  763,  826,  2035, 2098, 2541, 2604, 2856, 2919,
  3232, 3295, 3724, 3787, 3781, 3844, 2225, 2288, 3107, 3170, 380,  443,  3782,
  3845, 2478, 2541, 2919, 2982, 1718, 1781, 3419, 3482, 444,  507,  1273, 1336,
  3604, 3667, 3783, 3846, 827,  890,  1591, 1654, 1845, 1908, 3357, 3420, 3481,
  3544, 3725, 3788, 1082, 1145, 2415, 2478, 2982, 3045, 3665, 3728, 2162, 2225,
  3170, 3233, 508,  571,  3784, 3847, 1464, 1527, 1972, 2035, 3295, 3358, 3543,
  3606, 2352, 2415, 3045, 3108, 891,  954,  3726, 3789, 572,  635,  3785, 3848,
  1146, 1209, 3666, 3729, 1337, 1400, 2099, 2162, 3233, 3296, 3605, 3668, 2289,
  2352, 3108, 3171, 2731, 2794, 636,  699,  1782, 1845, 2668, 2731, 2794, 2857,
  3420, 3483, 3786, 3849, 1655, 1718, 3482, 3545, 955,  1018, 2605, 2668, 2857,
  2920, 3727, 3790, 1909, 1972, 3358, 3421, 1528, 1591, 3544, 3607, 2542, 2605,
  2920, 2983, 60,   60,   700,  763,  3787, 3850, 3840, 3840, 61,   124,  3841,
  3904, 125,  188,  1210, 1273, 2226, 2289, 3171, 3234, 3667, 3730, 3842, 3905,
  2036, 2099, 3296, 3359, 189,  252,  2479, 2542, 2983, 3046, 3843, 3906, 1401,
  1464, 3606, 3669, 253,  316,  1019, 1082, 3728, 3791, 3844, 3907, 764,  827,
  3788, 3851, 317,  380,  3845, 3908, 2416, 2479, 3046, 3109, 1719, 1782, 3483,
  3546, 381,  444,  1846, 1909, 2163, 2226, 3234, 3297, 3421, 3484, 3846, 3909,
  1592, 1655, 3545, 3608, 1274, 1337, 3668, 3731, 828,  891,  3789, 3852, 445,
  508,  1083, 1146, 1973, 2036, 2353, 2416, 3109, 3172, 3359, 3422, 3729, 3792,
  3847, 3910, 1465, 1528, 3607, 3670, 509,  572,  2732, 2795, 2795, 2858, 3848,
  3911, 2669, 2732, 2858, 2921, 2100, 2163, 3297, 3360, 892,  955,  2290, 2353,
  3172, 3235, 3790, 3853, 2606, 2669, 2921, 2984, 573,  636,  3849, 3912, 1147,
  1210, 1338, 1401, 3669, 3732, 3730, 3793, 1783, 1846, 2543, 2606, 2984, 3047,
  3484, 3547, 1656, 1719, 3546, 3609, 1910, 1973, 3422, 3485, 637,  700,  3850,
  3913, 956,  1019, 1529, 1592, 2480, 2543, 3047, 3110, 3608, 3671, 3791, 3854,
  2227, 2290, 3235, 3298, 2037, 2100, 3360, 3423, 701,  764,  1211, 1274, 3731,
  3794, 3851, 3914, 61,   61,   3904, 3904, 62,   125,  2417, 2480, 3110, 3173,
  3905, 3968, 126,  189,  1402, 1465, 3670, 3733, 3906, 3969, 190,  253,  3907,
  3970, 1020, 1083, 3792, 3855, 254,  317,  2164, 2227, 3298, 3361, 3908, 3971,
  765,  828,  1720, 1783, 3547, 3610, 3852, 3915, 1847, 1910, 3485, 3548, 318,
  381,  2354, 2417, 3173, 3236, 3909, 3972, 2796, 2859, 1593, 1656, 2733, 2796,
  2859, 2922, 3609, 3672, 1974, 2037, 3423, 3486, 382,  445,  2670, 2733, 2922,
  2985, 3910, 3973, 1275, 1338, 3732, 3795, 1084, 1147, 3793, 3856, 829,  892,
  2607, 2670, 2985, 3048, 3853, 3916, 446,  509,  1466, 1529, 3671, 3734, 3911,
  3974, 2291, 2354, 3236, 3299, 2101, 2164, 3361, 3424, 2544, 2607, 3048, 3111,
  510,  573,  3912, 3975, 893,  956,  3854, 3917, 1784, 1847, 3548, 3611, 1339,
  1402, 2481, 2544, 3111, 3174, 3733, 3796, 1148, 1211, 3794, 3857, 574,  637,
  1657, 1720, 1911, 1974, 3486, 3549, 3610, 3673, 3913, 3976, 2228, 2291, 3299,
  3362, 1530, 1593, 2038, 2101, 3424, 3487, 3672, 3735, 638,  701,  2418, 2481,
  3174, 3237, 3914, 3977, 957,  1020, 3855, 3918, 1212, 1275, 2797, 2860, 2860,
  2923, 3795, 3858, 702,  765,  1403, 1466, 2165, 2228, 2734, 2797, 2923, 2986,
  3362, 3425, 3734, 3797, 3915, 3978, 62,   62,   3968, 3968, 63,   126,  2355,
  2418, 3237, 3300, 3969, 4032, 127,  190,  2671, 2734, 2986, 3049, 3970, 4033,
  1021, 1084, 1848, 1911, 3549, 3612, 3856, 3919, 191,  254,  1721, 1784, 3611,
  3674, 3971, 4034, 255,  318,  2608, 2671, 3049, 3112, 3972, 4035, 1975, 2038,
  3487, 3550, 766,  829,  3916, 3979, 1594, 1657, 3673, 3736, 319,  382,  3973,
  4036, 1276, 1339, 2292, 2355, 3300, 3363, 3796, 3859, 2545, 2608, 3112, 3175,
  383,  446,  2102, 2165, 3425, 3488, 3974, 4037, 1085, 1148, 1467, 1530, 3735,
  3798, 3857, 3920, 830,  893,  3917, 3980, 447,  510,  3975, 4038, 2482, 2545,
  3175, 3238, 511,  574,  1785, 1848, 3612, 3675, 3976, 4039, 2229, 2292, 3363,
  3426, 1912, 1975, 3550, 3613, 894,  957,  1658, 1721, 3674, 3737, 3918, 3981,
  1340, 1403, 3797, 3860, 1149, 1212, 2419, 2482, 3238, 3301, 3858, 3921, 2039,
  2102, 3488, 3551, 575,  638,  2861, 2924, 3977, 4040, 2798, 2861, 2924, 2987,
  1531, 1594, 3736, 3799, 2735, 2798, 2987, 3050, 2672, 2735, 3050, 3113, 639,
  702,  958,  1021, 3919, 3982, 3978, 4041, 2166, 2229, 3426, 3489, 2356, 2419,
  3301, 3364, 1213, 1276, 2609, 2672, 3113, 3176, 3859, 3922, 1404, 1467, 3798,
  3861, 703,  766,  1849, 1912, 3613, 3676, 3979, 4042, 1722, 1785, 3675, 3738,
  1976, 2039, 3551, 3614, 1022, 1085, 2546, 2609, 3176, 3239, 3920, 3983, 2293,
  2356, 3364, 3427, 1595, 1658, 3737, 3800, 767,  830,  3980, 4043, 2103, 2166,
  3489, 3552, 1277, 1340, 3860, 3923, 2483, 2546, 3239, 3302, 1468, 1531, 3799,
  3862, 1086, 1149, 3921, 3984, 831,  894,  3981, 4044, 2230, 2293, 2862, 2925,
  2925, 2988, 3427, 3490, 2799, 2862, 2988, 3051, 1786, 1849, 2420, 2483, 3302,
  3365, 3676, 3739, 1913, 1976, 3614, 3677, 2736, 2799, 3051, 3114, 1659, 1722,
  3738, 3801, 2040, 2103, 3552, 3615, 1341, 1404, 3861, 3924, 895,  958,  2673,
  2736, 3114, 3177, 3982, 4045, 1150, 1213, 3922, 3985, 1532, 1595, 3800, 3863,
  2357, 2420, 3365, 3428, 2167, 2230, 2610, 2673, 3177, 3240, 3490, 3553, 959,
  1022, 3983, 4046, 2547, 2610, 3240, 3303, 1214, 1277, 1405, 1468, 1850, 1913,
  3677, 3740, 3862, 3925, 3923, 3986, 1723, 1786, 1977, 2040, 3615, 3678, 3739,
  3802, 2294, 2357, 3428, 3491, 1023, 1086, 1596, 1659, 2104, 2167, 2484, 2547,
  3303, 3366, 3553, 3616, 3801, 3864, 3984, 4047, 2926, 2989, 2863, 2926, 2989,
  3052, 2800, 2863, 3052, 3115, 1278, 1341, 3924, 3987, 1469, 1532, 2231, 2294,
  2737, 2800, 3115, 3178, 3491, 3554, 3863, 3926, 2421, 2484, 3366, 3429, 1087,
  1150, 3985, 4048, 1914, 1977, 2674, 2737, 3178, 3241, 3678, 3741, 1787, 1850,
  3740, 3803, 2041, 2104, 3616, 3679, 1660, 1723, 3802, 3865, 2611, 2674, 3241,
  3304, 1342, 1405, 2358, 2421, 3429, 3492, 3925, 3988, 2168, 2231, 3554, 3617,
  1151, 1214, 3986, 4049, 1533, 1596, 3864, 3927, 2548, 2611, 3304, 3367, 2295,
  2358, 3492, 3555, 1851, 1914, 3741, 3804, 1978, 2041, 2927, 2990, 2990, 3053,
  3679, 3742, 1406, 1469, 3926, 3989, 1724, 1787, 2864, 2927, 3053, 3116, 3803,
  3866, 1215, 1278, 2485, 2548, 3367, 3430, 3987, 4050, 2801, 2864, 3116, 3179,
  2105, 2168, 3617, 3680, 1597, 1660, 3865, 3928, 2738, 2801, 3179, 3242, 2422,
  2485, 3430, 3493, 2232, 2295, 3555, 3618, 2675, 2738, 3242, 3305, 1279, 1342,
  3988, 4051, 1470, 1533, 3927, 3990, 1915, 1978, 3742, 3805, 1788, 1851, 3804,
  3867, 2612, 2675, 3305, 3368, 2042, 2105, 3680, 3743, 2359, 2422, 3493, 3556,
  1661, 1724, 3866, 3929, 2169, 2232, 3618, 3681, 2549, 2612, 3368, 3431, 1343,
  1406, 3989, 4052, 2991, 3054, 1534, 1597, 2928, 2991, 3054, 3117, 3928, 3991,
  2865, 2928, 3117, 3180, 2296, 2359, 3556, 3619, 2802, 2865, 3180, 3243, 2486,
  2549, 3431, 3494, 1852, 1915, 3805, 3868, 1979, 2042, 3743, 3806, 1725, 1788,
  2739, 2802, 3243, 3306, 3867, 3930, 1407, 1470, 2106, 2169, 3681, 3744, 3990,
  4053, 2676, 2739, 3306, 3369, 1598, 1661, 2423, 2486, 3494, 3557, 3929, 3992,
  2233, 2296, 3619, 3682, 2613, 2676, 3369, 3432, 1471, 1534, 3991, 4054, 1916,
  1979, 3806, 3869, 1789, 1852, 2043, 2106, 2360, 2423, 3557, 3620, 3744, 3807,
  3868, 3931, 2992, 3055, 3055, 3118, 2550, 2613, 3432, 3495, 2929, 2992, 3118,
  3181, 1662, 1725, 2170, 2233, 3682, 3745, 3930, 3993, 2866, 2929, 3181, 3244,
  2803, 2866, 3244, 3307, 1535, 1598, 2297, 2360, 3620, 3683, 3992, 4055, 2487,
  2550, 3495, 3558, 2740, 2803, 3307, 3370, 1980, 2043, 3807, 3870, 1853, 1916,
  3869, 3932, 2107, 2170, 3745, 3808, 1726, 1789, 2677, 2740, 3370, 3433, 3931,
  3994, 2424, 2487, 3558, 3621, 2234, 2297, 3683, 3746, 1599, 1662, 3993, 4056,
  2614, 2677, 3433, 3496, 3056, 3119, 2993, 3056, 3119, 3182, 2930, 2993, 3182,
  3245, 2361, 2424, 3621, 3684, 1917, 1980, 3870, 3933, 2044, 2107, 3808, 3871,
  2551, 2614, 3496, 3559, 2867, 2930, 3245, 3308, 1790, 1853, 3932, 3995, 2171,
  2234, 3746, 3809, 2804, 2867, 3308, 3371, 1663, 1726, 3994, 4057, 2488, 2551,
  3559, 3622, 2741, 2804, 3371, 3434, 2298, 2361, 3684, 3747, 2678, 2741, 3434,
  3497, 1981, 2044, 3871, 3934, 1854, 1917, 3933, 3996, 2108, 2171, 3809, 3872,
  2425, 2488, 3622, 3685, 1727, 1790, 3995, 4058, 3057, 3120, 3120, 3183, 2235,
  2298, 2615, 2678, 3497, 3560, 3747, 3810, 2994, 3057, 3183, 3246, 2931, 2994,
  3246, 3309, 2868, 2931, 3309, 3372, 2362, 2425, 3685, 3748, 2552, 2615, 3560,
  3623, 1918, 1981, 3934, 3997, 2045, 2108, 2805, 2868, 3372, 3435, 3872, 3935,
  1791, 1854, 3996, 4059, 2172, 2235, 3810, 3873, 2742, 2805, 3435, 3498, 2489,
  2552, 3623, 3686, 2299, 2362, 3748, 3811, 2679, 2742, 3498, 3561, 3121, 3184,
  3058, 3121, 3184, 3247, 1982, 2045, 3935, 3998, 2426, 2489, 3686, 3749, 1855,
  1918, 2109, 2172, 2995, 3058, 3247, 3310, 3873, 3936, 3997, 4060, 2616, 2679,
  3561, 3624, 2932, 2995, 3310, 3373, 2236, 2299, 3811, 3874, 2869, 2932, 3373,
  3436, 2553, 2616, 3624, 3687, 2363, 2426, 3749, 3812, 2806, 2869, 3436, 3499,
  2046, 2109, 3936, 3999, 1919, 1982, 3998, 4061, 2743, 2806, 3499, 3562, 2173,
  2236, 3874, 3937, 2490, 2553, 3687, 3750, 2300, 2363, 3812, 3875, 2680, 2743,
  3562, 3625, 3122, 3185, 3185, 3248, 3059, 3122, 3248, 3311, 2996, 3059, 3311,
  3374, 2427, 2490, 2933, 2996, 3374, 3437, 3750, 3813, 1983, 2046, 2617, 2680,
  3625, 3688, 3999, 4062, 2110, 2173, 3937, 4000, 2870, 2933, 3437, 3500, 2237,
  2300, 3875, 3938, 2807, 2870, 3500, 3563, 2554, 2617, 3688, 3751, 2364, 2427,
  3813, 3876, 2744, 2807, 3563, 3626, 2047, 2110, 4000, 4063, 2174, 2237, 3186,
  3249, 3938, 4001, 2491, 2554, 3123, 3186, 3249, 3312, 3751, 3814, 3060, 3123,
  3312, 3375, 2681, 2744, 3626, 3689, 2301, 2364, 3876, 3939, 2997, 3060, 3375,
  3438, 2934, 2997, 3438, 3501, 2428, 2491, 3814, 3877, 2618, 2681, 3689, 3752,
  2871, 2934, 3501, 3564, 2111, 2174, 4001, 4064, 2238, 2301, 3939, 4002, 2808,
  2871, 3564, 3627, 2555, 2618, 3752, 3815, 2365, 2428, 3877, 3940, 2745, 2808,
  3627, 3690, 3187, 3250, 3250, 3313, 3124, 3187, 3313, 3376, 3061, 3124, 3376,
  3439, 2492, 2555, 3815, 3878, 2175, 2238, 2998, 3061, 3439, 3502, 4002, 4065,
  2682, 2745, 3690, 3753, 2302, 2365, 3940, 4003, 2935, 2998, 3502, 3565, 2872,
  2935, 3565, 3628, 2619, 2682, 3753, 3816, 2429, 2492, 3878, 3941, 2809, 2872,
  3628, 3691, 2239, 2302, 4003, 4066, 2556, 2619, 3816, 3879, 3251, 3314, 3188,
  3251, 3314, 3377, 3125, 3188, 3377, 3440, 2366, 2429, 2746, 2809, 3691, 3754,
  3941, 4004, 3062, 3125, 3440, 3503, 2999, 3062, 3503, 3566, 2493, 2556, 3879,
  3942, 2683, 2746, 3754, 3817, 2936, 2999, 3566, 3629, 2303, 2366, 4004, 4067,
  2873, 2936, 3629, 3692, 2620, 2683, 3817, 3880, 2430, 2493, 3942, 4005, 2810,
  2873, 3692, 3755, 3252, 3315, 3315, 3378, 3189, 3252, 3378, 3441, 3126, 3189,
  3441, 3504, 2557, 2620, 3880, 3943, 3063, 3126, 3504, 3567, 2747, 2810, 3755,
  3818, 2367, 2430, 4005, 4068, 3000, 3063, 3567, 3630, 2684, 2747, 3818, 3881,
  2494, 2557, 2937, 3000, 3630, 3693, 3943, 4006, 2874, 2937, 3693, 3756, 2621,
  2684, 3881, 3944, 3316, 3379, 3253, 3316, 3379, 3442, 2431, 2494, 4006, 4069,
  3190, 3253, 3442, 3505, 2811, 2874, 3756, 3819, 3127, 3190, 3505, 3568, 3064,
  3127, 3568, 3631, 2558, 2621, 3944, 4007, 2748, 2811, 3819, 3882, 3001, 3064,
  3631, 3694, 2938, 3001, 3694, 3757, 2685, 2748, 3882, 3945, 2495, 2558, 4007,
  4070, 2875, 2938, 3757, 3820, 3317, 3380, 3380, 3443, 3254, 3317, 3443, 3506,
  2622, 2685, 3191, 3254, 3506, 3569, 3945, 4008, 2812, 2875, 3820, 3883, 3128,
  3191, 3569, 3632, 3065, 3128, 3632, 3695, 2559, 2622, 4008, 4071, 2749, 2812,
  3883, 3946, 3002, 3065, 3695, 3758, 2939, 3002, 3758, 3821, 2686, 2749, 3946,
  4009, 3381, 3444, 3318, 3381, 3444, 3507, 2876, 2939, 3821, 3884, 3255, 3318,
  3507, 3570, 3192, 3255, 3570, 3633, 2623, 2686, 3129, 3192, 3633, 3696, 4009,
  4072, 2813, 2876, 3884, 3947, 3066, 3129, 3696, 3759, 3003, 3066, 3759, 3822,
  2750, 2813, 3947, 4010, 2940, 3003, 3822, 3885, 3382, 3445, 3445, 3508, 3319,
  3382, 3508, 3571, 2687, 2750, 4010, 4073, 3256, 3319, 3571, 3634, 2877, 2940,
  3885, 3948, 3193, 3256, 3634, 3697, 3130, 3193, 3697, 3760, 2814, 2877, 3948,
  4011, 3067, 3130, 3760, 3823, 3004, 3067, 3823, 3886, 2751, 2814, 4011, 4074,
  3446, 3509, 3383, 3446, 3509, 3572, 2941, 3004, 3886, 3949, 3320, 3383, 3572,
  3635, 3257, 3320, 3635, 3698, 3194, 3257, 3698, 3761, 2878, 2941, 3949, 4012,
  3131, 3194, 3761, 3824, 3068, 3131, 3824, 3887, 2815, 2878, 4012, 4075, 3005,
  3068, 3887, 3950, 3447, 3510, 3510, 3573, 3384, 3447, 3573, 3636, 3321, 3384,
  3636, 3699, 2942, 3005, 3950, 4013, 3258, 3321, 3699, 3762, 3195, 3258, 3762,
  3825, 2879, 2942, 4013, 4076, 3132, 3195, 3825, 3888, 3069, 3132, 3888, 3951,
  3511, 3574, 3448, 3511, 3574, 3637, 3006, 3069, 3951, 4014, 3385, 3448, 3637,
  3700, 3322, 3385, 3700, 3763, 3259, 3322, 3763, 3826, 2943, 3006, 4014, 4077,
  3196, 3259, 3826, 3889, 3133, 3196, 3889, 3952, 3070, 3133, 3952, 4015, 3512,
  3575, 3575, 3638, 3449, 3512, 3638, 3701, 3386, 3449, 3701, 3764, 3007, 3070,
  4015, 4078, 3323, 3386, 3764, 3827, 3260, 3323, 3827, 3890, 3197, 3260, 3890,
  3953, 3134, 3197, 3953, 4016, 3576, 3639, 3071, 3134, 4016, 4079, 3513, 3576,
  3639, 3702, 3450, 3513, 3702, 3765, 3387, 3450, 3765, 3828, 3324, 3387, 3828,
  3891, 3261, 3324, 3891, 3954, 3198, 3261, 3954, 4017, 3135, 3198, 4017, 4080,
  3577, 3640, 3640, 3703, 3514, 3577, 3703, 3766, 3451, 3514, 3766, 3829, 3388,
  3451, 3829, 3892, 3325, 3388, 3892, 3955, 3262, 3325, 3955, 4018, 3199, 3262,
  4018, 4081, 3641, 3704, 3578, 3641, 3704, 3767, 3515, 3578, 3767, 3830, 3452,
  3515, 3830, 3893, 3389, 3452, 3893, 3956, 3326, 3389, 3956, 4019, 3263, 3326,
  4019, 4082, 3642, 3705, 3705, 3768, 3579, 3642, 3768, 3831, 3516, 3579, 3831,
  3894, 3453, 3516, 3894, 3957, 3390, 3453, 3957, 4020, 3327, 3390, 4020, 4083,
  3706, 3769, 3643, 3706, 3769, 3832, 3580, 3643, 3832, 3895, 3517, 3580, 3895,
  3958, 3454, 3517, 3958, 4021, 3391, 3454, 4021, 4084, 3707, 3770, 3770, 3833,
  3644, 3707, 3833, 3896, 3581, 3644, 3896, 3959, 3518, 3581, 3959, 4022, 3455,
  3518, 4022, 4085, 3771, 3834, 3708, 3771, 3834, 3897, 3645, 3708, 3897, 3960,
  3582, 3645, 3960, 4023, 3519, 3582, 4023, 4086, 3772, 3835, 3835, 3898, 3709,
  3772, 3898, 3961, 3646, 3709, 3961, 4024, 3583, 3646, 4024, 4087, 3836, 3899,
  3773, 3836, 3899, 3962, 3710, 3773, 3962, 4025, 3647, 3710, 4025, 4088, 3837,
  3900, 3900, 3963, 3774, 3837, 3963, 4026, 3711, 3774, 4026, 4089, 3901, 3964,
  3838, 3901, 3964, 4027, 3775, 3838, 4027, 4090, 3902, 3965, 3965, 4028, 3839,
  3902, 4028, 4091, 3966, 4029, 3903, 3966, 4029, 4092, 3967, 4030, 4030, 4093,
  4031, 4094, 0,    0,
};
#endif  // CONFIG_TX64X64

#if CONFIG_CHROMA_2X2
DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_2x2[4]) = { 0, 1, 2,
                                                                        3 };
#endif

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x4[16]) = {
  0, 2, 5, 8, 1, 3, 9, 12, 4, 7, 11, 14, 6, 10, 13, 15,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x4[16]) = {
  0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x4[16]) = {
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, av1_col_iscan_4x4[16]) = {
  0, 3, 7, 11, 1, 5, 9, 12, 2, 6, 10, 14, 4, 8, 13, 15,
};

DECLARE_ALIGNED(16, static const int16_t, av1_row_iscan_4x4[16]) = {
  0, 1, 3, 5, 2, 4, 6, 9, 7, 8, 11, 13, 10, 12, 14, 15,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x8[32]) = {
  0,  1,  4,  9,  2,  3,  6,  11, 5,  7,  8,  13, 10, 12, 14, 17,
  15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x8[32]) = {
  0, 8,  16, 24, 1, 9,  17, 25, 2, 10, 18, 26, 3, 11, 19, 27,
  4, 12, 20, 28, 5, 13, 21, 29, 6, 14, 22, 30, 7, 15, 23, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x8[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x4[32]) = {
  0, 1, 4, 9,  15, 19, 24, 28, 2,  3,  6,  11, 16, 21, 25, 29,
  5, 7, 8, 13, 18, 22, 26, 30, 10, 12, 14, 17, 20, 23, 27, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x4[32]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 1, 5, 9,  13, 17, 21, 25, 29,
  2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x4[32]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_4x16[64]) = {
  0,  1,  4,  9,  2,  3,  6,  11, 5,  7,  8,  13, 10, 12, 14, 17,
  15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x4[64]) = {
  0,  1,  4,  9,  15, 19, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  2,  3,  6,  11, 16, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  5,  7,  8,  13, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  10, 12, 14, 17, 20, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_4x16[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x4[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_4x16[64]) = {
  0,  16, 32, 48, 1,  17, 33, 49, 2,  18, 34, 50, 3,  19, 35, 51,
  4,  20, 36, 52, 5,  21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x4[64]) = {
  0, 4, 8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  1, 5, 9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x32[256]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  2,   4,   7,   11,  16,  22,  29,
  36,  5,   8,   12,  17,  23,  30,  37,  44,  9,   13,  18,  24,  31,  38,
  45,  52,  14,  19,  25,  32,  39,  46,  53,  60,  20,  26,  33,  40,  47,
  54,  61,  68,  27,  34,  41,  48,  55,  62,  69,  76,  35,  42,  49,  56,
  63,  70,  77,  84,  43,  50,  57,  64,  71,  78,  85,  92,  51,  58,  65,
  72,  79,  86,  93,  100, 59,  66,  73,  80,  87,  94,  101, 108, 67,  74,
  81,  88,  95,  102, 109, 116, 75,  82,  89,  96,  103, 110, 117, 124, 83,
  90,  97,  104, 111, 118, 125, 132, 91,  98,  105, 112, 119, 126, 133, 140,
  99,  106, 113, 120, 127, 134, 141, 148, 107, 114, 121, 128, 135, 142, 149,
  156, 115, 122, 129, 136, 143, 150, 157, 164, 123, 130, 137, 144, 151, 158,
  165, 172, 131, 138, 145, 152, 159, 166, 173, 180, 139, 146, 153, 160, 167,
  174, 181, 188, 147, 154, 161, 168, 175, 182, 189, 196, 155, 162, 169, 176,
  183, 190, 197, 204, 163, 170, 177, 184, 191, 198, 205, 212, 171, 178, 185,
  192, 199, 206, 213, 220, 179, 186, 193, 200, 207, 214, 221, 228, 187, 194,
  201, 208, 215, 222, 229, 235, 195, 202, 209, 216, 223, 230, 236, 241, 203,
  210, 217, 224, 231, 237, 242, 246, 211, 218, 225, 232, 238, 243, 247, 250,
  219, 226, 233, 239, 244, 248, 251, 253, 227, 234, 240, 245, 249, 252, 254,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x8[256]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  36,  44,  52,  60,  68,  76,  84,
  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172, 180, 188, 196, 204,
  212, 220, 2,   4,   7,   11,  16,  22,  29,  37,  45,  53,  61,  69,  77,
  85,  93,  101, 109, 117, 125, 133, 141, 149, 157, 165, 173, 181, 189, 197,
  205, 213, 221, 228, 5,   8,   12,  17,  23,  30,  38,  46,  54,  62,  70,
  78,  86,  94,  102, 110, 118, 126, 134, 142, 150, 158, 166, 174, 182, 190,
  198, 206, 214, 222, 229, 235, 9,   13,  18,  24,  31,  39,  47,  55,  63,
  71,  79,  87,  95,  103, 111, 119, 127, 135, 143, 151, 159, 167, 175, 183,
  191, 199, 207, 215, 223, 230, 236, 241, 14,  19,  25,  32,  40,  48,  56,
  64,  72,  80,  88,  96,  104, 112, 120, 128, 136, 144, 152, 160, 168, 176,
  184, 192, 200, 208, 216, 224, 231, 237, 242, 246, 20,  26,  33,  41,  49,
  57,  65,  73,  81,  89,  97,  105, 113, 121, 129, 137, 145, 153, 161, 169,
  177, 185, 193, 201, 209, 217, 225, 232, 238, 243, 247, 250, 27,  34,  42,
  50,  58,  66,  74,  82,  90,  98,  106, 114, 122, 130, 138, 146, 154, 162,
  170, 178, 186, 194, 202, 210, 218, 226, 233, 239, 244, 248, 251, 253, 35,
  43,  51,  59,  67,  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155,
  163, 171, 179, 187, 195, 203, 211, 219, 227, 234, 240, 245, 249, 252, 254,
  255,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x32[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x8[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x32[256]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 1,  33, 65, 97,  129, 161, 193, 225,
  2,  34, 66, 98,  130, 162, 194, 226, 3,  35, 67, 99,  131, 163, 195, 227,
  4,  36, 68, 100, 132, 164, 196, 228, 5,  37, 69, 101, 133, 165, 197, 229,
  6,  38, 70, 102, 134, 166, 198, 230, 7,  39, 71, 103, 135, 167, 199, 231,
  8,  40, 72, 104, 136, 168, 200, 232, 9,  41, 73, 105, 137, 169, 201, 233,
  10, 42, 74, 106, 138, 170, 202, 234, 11, 43, 75, 107, 139, 171, 203, 235,
  12, 44, 76, 108, 140, 172, 204, 236, 13, 45, 77, 109, 141, 173, 205, 237,
  14, 46, 78, 110, 142, 174, 206, 238, 15, 47, 79, 111, 143, 175, 207, 239,
  16, 48, 80, 112, 144, 176, 208, 240, 17, 49, 81, 113, 145, 177, 209, 241,
  18, 50, 82, 114, 146, 178, 210, 242, 19, 51, 83, 115, 147, 179, 211, 243,
  20, 52, 84, 116, 148, 180, 212, 244, 21, 53, 85, 117, 149, 181, 213, 245,
  22, 54, 86, 118, 150, 182, 214, 246, 23, 55, 87, 119, 151, 183, 215, 247,
  24, 56, 88, 120, 152, 184, 216, 248, 25, 57, 89, 121, 153, 185, 217, 249,
  26, 58, 90, 122, 154, 186, 218, 250, 27, 59, 91, 123, 155, 187, 219, 251,
  28, 60, 92, 124, 156, 188, 220, 252, 29, 61, 93, 125, 157, 189, 221, 253,
  30, 62, 94, 126, 158, 190, 222, 254, 31, 63, 95, 127, 159, 191, 223, 255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x8[256]) = {
  0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96,  104, 112,
  120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232,
  240, 248, 1,   9,   17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  97,
  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193, 201, 209, 217,
  225, 233, 241, 249, 2,   10,  18,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 242, 250, 3,   11,  19,  27,  35,  43,  51,  59,  67,
  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187,
  195, 203, 211, 219, 227, 235, 243, 251, 4,   12,  20,  28,  36,  44,  52,
  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172,
  180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 5,   13,  21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 237, 245, 253, 6,   14,  22,
  30,  38,  46,  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142,
  150, 158, 166, 174, 182, 190, 198, 206, 214, 222, 230, 238, 246, 254, 7,
  15,  23,  31,  39,  47,  55,  63,  71,  79,  87,  95,  103, 111, 119, 127,
  135, 143, 151, 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 239, 247,
  255,
};
#endif  // CONFIG_EXT_TX

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x8[64]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 1, 9,  17, 25, 33, 41, 49, 57,
  2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
  4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
  6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x8[64]) = {
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, av1_col_iscan_8x8[64]) = {
  0,  3,  8,  15, 22, 32, 40, 47, 1,  5,  11, 18, 26, 34, 44, 51,
  2,  7,  13, 20, 28, 38, 46, 54, 4,  10, 16, 24, 31, 41, 50, 56,
  6,  12, 21, 27, 35, 43, 52, 58, 9,  17, 25, 33, 39, 48, 55, 60,
  14, 23, 30, 37, 45, 53, 59, 62, 19, 29, 36, 42, 49, 57, 61, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_row_iscan_8x8[64]) = {
  0,  1,  2,  5,  8,  12, 19, 24, 3,  4,  7,  10, 15, 20, 30, 39,
  6,  9,  13, 16, 21, 27, 37, 46, 11, 14, 17, 23, 28, 34, 44, 52,
  18, 22, 25, 31, 35, 41, 50, 57, 26, 29, 33, 38, 43, 49, 55, 59,
  32, 36, 42, 47, 51, 54, 60, 61, 40, 45, 48, 53, 56, 58, 62, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x8[64]) = {
  0,  2,  5,  9,  14, 22, 31, 37, 1,  4,  8,  13, 19, 26, 38, 44,
  3,  6,  10, 17, 24, 30, 42, 49, 7,  11, 15, 21, 29, 36, 47, 53,
  12, 16, 20, 27, 34, 43, 52, 57, 18, 23, 28, 35, 41, 48, 56, 60,
  25, 32, 39, 45, 50, 55, 59, 62, 33, 40, 46, 51, 54, 58, 61, 63,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_8x16[128]) = {
  0,  1,  3,   6,   10,  15,  21,  28,  2,  4,   7,   11,  16,  22,  29,  36,
  5,  8,  12,  17,  23,  30,  37,  44,  9,  13,  18,  24,  31,  38,  45,  52,
  14, 19, 25,  32,  39,  46,  53,  60,  20, 26,  33,  40,  47,  54,  61,  68,
  27, 34, 41,  48,  55,  62,  69,  76,  35, 42,  49,  56,  63,  70,  77,  84,
  43, 50, 57,  64,  71,  78,  85,  92,  51, 58,  65,  72,  79,  86,  93,  100,
  59, 66, 73,  80,  87,  94,  101, 107, 67, 74,  81,  88,  95,  102, 108, 113,
  75, 82, 89,  96,  103, 109, 114, 118, 83, 90,  97,  104, 110, 115, 119, 122,
  91, 98, 105, 111, 116, 120, 123, 125, 99, 106, 112, 117, 121, 124, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x8[128]) = {
  0,  1,  3,  6,  10, 15, 21, 28, 36, 44,  52,  60,  68,  76,  84,  92,
  2,  4,  7,  11, 16, 22, 29, 37, 45, 53,  61,  69,  77,  85,  93,  100,
  5,  8,  12, 17, 23, 30, 38, 46, 54, 62,  70,  78,  86,  94,  101, 107,
  9,  13, 18, 24, 31, 39, 47, 55, 63, 71,  79,  87,  95,  102, 108, 113,
  14, 19, 25, 32, 40, 48, 56, 64, 72, 80,  88,  96,  103, 109, 114, 118,
  20, 26, 33, 41, 49, 57, 65, 73, 81, 89,  97,  104, 110, 115, 119, 122,
  27, 34, 42, 50, 58, 66, 74, 82, 90, 98,  105, 111, 116, 120, 123, 125,
  35, 43, 51, 59, 67, 75, 83, 91, 99, 106, 112, 117, 121, 124, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_8x16[128]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 1,  17, 33, 49, 65, 81, 97,  113,
  2,  18, 34, 50, 66, 82, 98,  114, 3,  19, 35, 51, 67, 83, 99,  115,
  4,  20, 36, 52, 68, 84, 100, 116, 5,  21, 37, 53, 69, 85, 101, 117,
  6,  22, 38, 54, 70, 86, 102, 118, 7,  23, 39, 55, 71, 87, 103, 119,
  8,  24, 40, 56, 72, 88, 104, 120, 9,  25, 41, 57, 73, 89, 105, 121,
  10, 26, 42, 58, 74, 90, 106, 122, 11, 27, 43, 59, 75, 91, 107, 123,
  12, 28, 44, 60, 76, 92, 108, 124, 13, 29, 45, 61, 77, 93, 109, 125,
  14, 30, 46, 62, 78, 94, 110, 126, 15, 31, 47, 63, 79, 95, 111, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x8[128]) = {
  0, 8,  16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96,  104, 112, 120,
  1, 9,  17, 25, 33, 41, 49, 57, 65, 73, 81, 89, 97,  105, 113, 121,
  2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98,  106, 114, 122,
  3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 99,  107, 115, 123,
  4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 108, 116, 124,
  5, 13, 21, 29, 37, 45, 53, 61, 69, 77, 85, 93, 101, 109, 117, 125,
  6, 14, 22, 30, 38, 46, 54, 62, 70, 78, 86, 94, 102, 110, 118, 126,
  7, 15, 23, 31, 39, 47, 55, 63, 71, 79, 87, 95, 103, 111, 119, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_8x16[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x8[128]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x32[512]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  36,  45,  55,  66,  78,  91,  105,
  120, 2,   4,   7,   11,  16,  22,  29,  37,  46,  56,  67,  79,  92,  106,
  121, 136, 5,   8,   12,  17,  23,  30,  38,  47,  57,  68,  80,  93,  107,
  122, 137, 152, 9,   13,  18,  24,  31,  39,  48,  58,  69,  81,  94,  108,
  123, 138, 153, 168, 14,  19,  25,  32,  40,  49,  59,  70,  82,  95,  109,
  124, 139, 154, 169, 184, 20,  26,  33,  41,  50,  60,  71,  83,  96,  110,
  125, 140, 155, 170, 185, 200, 27,  34,  42,  51,  61,  72,  84,  97,  111,
  126, 141, 156, 171, 186, 201, 216, 35,  43,  52,  62,  73,  85,  98,  112,
  127, 142, 157, 172, 187, 202, 217, 232, 44,  53,  63,  74,  86,  99,  113,
  128, 143, 158, 173, 188, 203, 218, 233, 248, 54,  64,  75,  87,  100, 114,
  129, 144, 159, 174, 189, 204, 219, 234, 249, 264, 65,  76,  88,  101, 115,
  130, 145, 160, 175, 190, 205, 220, 235, 250, 265, 280, 77,  89,  102, 116,
  131, 146, 161, 176, 191, 206, 221, 236, 251, 266, 281, 296, 90,  103, 117,
  132, 147, 162, 177, 192, 207, 222, 237, 252, 267, 282, 297, 312, 104, 118,
  133, 148, 163, 178, 193, 208, 223, 238, 253, 268, 283, 298, 313, 328, 119,
  134, 149, 164, 179, 194, 209, 224, 239, 254, 269, 284, 299, 314, 329, 344,
  135, 150, 165, 180, 195, 210, 225, 240, 255, 270, 285, 300, 315, 330, 345,
  360, 151, 166, 181, 196, 211, 226, 241, 256, 271, 286, 301, 316, 331, 346,
  361, 376, 167, 182, 197, 212, 227, 242, 257, 272, 287, 302, 317, 332, 347,
  362, 377, 392, 183, 198, 213, 228, 243, 258, 273, 288, 303, 318, 333, 348,
  363, 378, 393, 407, 199, 214, 229, 244, 259, 274, 289, 304, 319, 334, 349,
  364, 379, 394, 408, 421, 215, 230, 245, 260, 275, 290, 305, 320, 335, 350,
  365, 380, 395, 409, 422, 434, 231, 246, 261, 276, 291, 306, 321, 336, 351,
  366, 381, 396, 410, 423, 435, 446, 247, 262, 277, 292, 307, 322, 337, 352,
  367, 382, 397, 411, 424, 436, 447, 457, 263, 278, 293, 308, 323, 338, 353,
  368, 383, 398, 412, 425, 437, 448, 458, 467, 279, 294, 309, 324, 339, 354,
  369, 384, 399, 413, 426, 438, 449, 459, 468, 476, 295, 310, 325, 340, 355,
  370, 385, 400, 414, 427, 439, 450, 460, 469, 477, 484, 311, 326, 341, 356,
  371, 386, 401, 415, 428, 440, 451, 461, 470, 478, 485, 491, 327, 342, 357,
  372, 387, 402, 416, 429, 441, 452, 462, 471, 479, 486, 492, 497, 343, 358,
  373, 388, 403, 417, 430, 442, 453, 463, 472, 480, 487, 493, 498, 502, 359,
  374, 389, 404, 418, 431, 443, 454, 464, 473, 481, 488, 494, 499, 503, 506,
  375, 390, 405, 419, 432, 444, 455, 465, 474, 482, 489, 495, 500, 504, 507,
  509, 391, 406, 420, 433, 445, 456, 466, 475, 483, 490, 496, 501, 505, 508,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x16[512]) = {
  0,   1,   3,   6,   10,  15,  21,  28,  36,  45,  55,  66,  78,  91,  105,
  120, 136, 152, 168, 184, 200, 216, 232, 248, 264, 280, 296, 312, 328, 344,
  360, 376, 2,   4,   7,   11,  16,  22,  29,  37,  46,  56,  67,  79,  92,
  106, 121, 137, 153, 169, 185, 201, 217, 233, 249, 265, 281, 297, 313, 329,
  345, 361, 377, 392, 5,   8,   12,  17,  23,  30,  38,  47,  57,  68,  80,
  93,  107, 122, 138, 154, 170, 186, 202, 218, 234, 250, 266, 282, 298, 314,
  330, 346, 362, 378, 393, 407, 9,   13,  18,  24,  31,  39,  48,  58,  69,
  81,  94,  108, 123, 139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299,
  315, 331, 347, 363, 379, 394, 408, 421, 14,  19,  25,  32,  40,  49,  59,
  70,  82,  95,  109, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284,
  300, 316, 332, 348, 364, 380, 395, 409, 422, 434, 20,  26,  33,  41,  50,
  60,  71,  83,  96,  110, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269,
  285, 301, 317, 333, 349, 365, 381, 396, 410, 423, 435, 446, 27,  34,  42,
  51,  61,  72,  84,  97,  111, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  270, 286, 302, 318, 334, 350, 366, 382, 397, 411, 424, 436, 447, 457, 35,
  43,  52,  62,  73,  85,  98,  112, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 398, 412, 425, 437, 448, 458,
  467, 44,  53,  63,  74,  86,  99,  113, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 399, 413, 426, 438, 449,
  459, 468, 476, 54,  64,  75,  87,  100, 114, 129, 145, 161, 177, 193, 209,
  225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 400, 414, 427, 439,
  450, 460, 469, 477, 484, 65,  76,  88,  101, 115, 130, 146, 162, 178, 194,
  210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 401, 415, 428,
  440, 451, 461, 470, 478, 485, 491, 77,  89,  102, 116, 131, 147, 163, 179,
  195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371, 387, 402, 416,
  429, 441, 452, 462, 471, 479, 486, 492, 497, 90,  103, 117, 132, 148, 164,
  180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340, 356, 372, 388, 403,
  417, 430, 442, 453, 463, 472, 480, 487, 493, 498, 502, 104, 118, 133, 149,
  165, 181, 197, 213, 229, 245, 261, 277, 293, 309, 325, 341, 357, 373, 389,
  404, 418, 431, 443, 454, 464, 473, 481, 488, 494, 499, 503, 506, 119, 134,
  150, 166, 182, 198, 214, 230, 246, 262, 278, 294, 310, 326, 342, 358, 374,
  390, 405, 419, 432, 444, 455, 465, 474, 482, 489, 495, 500, 504, 507, 509,
  135, 151, 167, 183, 199, 215, 231, 247, 263, 279, 295, 311, 327, 343, 359,
  375, 391, 406, 420, 433, 445, 456, 466, 475, 483, 490, 496, 501, 505, 508,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x32[512]) = {
  0,  32, 64, 96,  128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480,
  1,  33, 65, 97,  129, 161, 193, 225, 257, 289, 321, 353, 385, 417, 449, 481,
  2,  34, 66, 98,  130, 162, 194, 226, 258, 290, 322, 354, 386, 418, 450, 482,
  3,  35, 67, 99,  131, 163, 195, 227, 259, 291, 323, 355, 387, 419, 451, 483,
  4,  36, 68, 100, 132, 164, 196, 228, 260, 292, 324, 356, 388, 420, 452, 484,
  5,  37, 69, 101, 133, 165, 197, 229, 261, 293, 325, 357, 389, 421, 453, 485,
  6,  38, 70, 102, 134, 166, 198, 230, 262, 294, 326, 358, 390, 422, 454, 486,
  7,  39, 71, 103, 135, 167, 199, 231, 263, 295, 327, 359, 391, 423, 455, 487,
  8,  40, 72, 104, 136, 168, 200, 232, 264, 296, 328, 360, 392, 424, 456, 488,
  9,  41, 73, 105, 137, 169, 201, 233, 265, 297, 329, 361, 393, 425, 457, 489,
  10, 42, 74, 106, 138, 170, 202, 234, 266, 298, 330, 362, 394, 426, 458, 490,
  11, 43, 75, 107, 139, 171, 203, 235, 267, 299, 331, 363, 395, 427, 459, 491,
  12, 44, 76, 108, 140, 172, 204, 236, 268, 300, 332, 364, 396, 428, 460, 492,
  13, 45, 77, 109, 141, 173, 205, 237, 269, 301, 333, 365, 397, 429, 461, 493,
  14, 46, 78, 110, 142, 174, 206, 238, 270, 302, 334, 366, 398, 430, 462, 494,
  15, 47, 79, 111, 143, 175, 207, 239, 271, 303, 335, 367, 399, 431, 463, 495,
  16, 48, 80, 112, 144, 176, 208, 240, 272, 304, 336, 368, 400, 432, 464, 496,
  17, 49, 81, 113, 145, 177, 209, 241, 273, 305, 337, 369, 401, 433, 465, 497,
  18, 50, 82, 114, 146, 178, 210, 242, 274, 306, 338, 370, 402, 434, 466, 498,
  19, 51, 83, 115, 147, 179, 211, 243, 275, 307, 339, 371, 403, 435, 467, 499,
  20, 52, 84, 116, 148, 180, 212, 244, 276, 308, 340, 372, 404, 436, 468, 500,
  21, 53, 85, 117, 149, 181, 213, 245, 277, 309, 341, 373, 405, 437, 469, 501,
  22, 54, 86, 118, 150, 182, 214, 246, 278, 310, 342, 374, 406, 438, 470, 502,
  23, 55, 87, 119, 151, 183, 215, 247, 279, 311, 343, 375, 407, 439, 471, 503,
  24, 56, 88, 120, 152, 184, 216, 248, 280, 312, 344, 376, 408, 440, 472, 504,
  25, 57, 89, 121, 153, 185, 217, 249, 281, 313, 345, 377, 409, 441, 473, 505,
  26, 58, 90, 122, 154, 186, 218, 250, 282, 314, 346, 378, 410, 442, 474, 506,
  27, 59, 91, 123, 155, 187, 219, 251, 283, 315, 347, 379, 411, 443, 475, 507,
  28, 60, 92, 124, 156, 188, 220, 252, 284, 316, 348, 380, 412, 444, 476, 508,
  29, 61, 93, 125, 157, 189, 221, 253, 285, 317, 349, 381, 413, 445, 477, 509,
  30, 62, 94, 126, 158, 190, 222, 254, 286, 318, 350, 382, 414, 446, 478, 510,
  31, 63, 95, 127, 159, 191, 223, 255, 287, 319, 351, 383, 415, 447, 479, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x16[512]) = {
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464,
  480, 496, 1,   17,  33,  49,  65,  81,  97,  113, 129, 145, 161, 177, 193,
  209, 225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433,
  449, 465, 481, 497, 2,   18,  34,  50,  66,  82,  98,  114, 130, 146, 162,
  178, 194, 210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 402,
  418, 434, 450, 466, 482, 498, 3,   19,  35,  51,  67,  83,  99,  115, 131,
  147, 163, 179, 195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371,
  387, 403, 419, 435, 451, 467, 483, 499, 4,   20,  36,  52,  68,  84,  100,
  116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340,
  356, 372, 388, 404, 420, 436, 452, 468, 484, 500, 5,   21,  37,  53,  69,
  85,  101, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309,
  325, 341, 357, 373, 389, 405, 421, 437, 453, 469, 485, 501, 6,   22,  38,
  54,  70,  86,  102, 118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278,
  294, 310, 326, 342, 358, 374, 390, 406, 422, 438, 454, 470, 486, 502, 7,
  23,  39,  55,  71,  87,  103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  263, 279, 295, 311, 327, 343, 359, 375, 391, 407, 423, 439, 455, 471, 487,
  503, 8,   24,  40,  56,  72,  88,  104, 120, 136, 152, 168, 184, 200, 216,
  232, 248, 264, 280, 296, 312, 328, 344, 360, 376, 392, 408, 424, 440, 456,
  472, 488, 504, 9,   25,  41,  57,  73,  89,  105, 121, 137, 153, 169, 185,
  201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361, 377, 393, 409, 425,
  441, 457, 473, 489, 505, 10,  26,  42,  58,  74,  90,  106, 122, 138, 154,
  170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378, 394,
  410, 426, 442, 458, 474, 490, 506, 11,  27,  43,  59,  75,  91,  107, 123,
  139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363,
  379, 395, 411, 427, 443, 459, 475, 491, 507, 12,  28,  44,  60,  76,  92,
  108, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284, 300, 316, 332,
  348, 364, 380, 396, 412, 428, 444, 460, 476, 492, 508, 13,  29,  45,  61,
  77,  93,  109, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269, 285, 301,
  317, 333, 349, 365, 381, 397, 413, 429, 445, 461, 477, 493, 509, 14,  30,
  46,  62,  78,  94,  110, 126, 142, 158, 174, 190, 206, 222, 238, 254, 270,
  286, 302, 318, 334, 350, 366, 382, 398, 414, 430, 446, 462, 478, 494, 510,
  15,  31,  47,  63,  79,  95,  111, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479,
  495, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x32[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x16[512]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_16x16[256]) = {
  0,  16, 32, 48, 64, 80, 96,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  1,  17, 33, 49, 65, 81, 97,  113, 129, 145, 161, 177, 193, 209, 225, 241,
  2,  18, 34, 50, 66, 82, 98,  114, 130, 146, 162, 178, 194, 210, 226, 242,
  3,  19, 35, 51, 67, 83, 99,  115, 131, 147, 163, 179, 195, 211, 227, 243,
  4,  20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244,
  5,  21, 37, 53, 69, 85, 101, 117, 133, 149, 165, 181, 197, 213, 229, 245,
  6,  22, 38, 54, 70, 86, 102, 118, 134, 150, 166, 182, 198, 214, 230, 246,
  7,  23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  8,  24, 40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232, 248,
  9,  25, 41, 57, 73, 89, 105, 121, 137, 153, 169, 185, 201, 217, 233, 249,
  10, 26, 42, 58, 74, 90, 106, 122, 138, 154, 170, 186, 202, 218, 234, 250,
  11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251,
  12, 28, 44, 60, 76, 92, 108, 124, 140, 156, 172, 188, 204, 220, 236, 252,
  13, 29, 45, 61, 77, 93, 109, 125, 141, 157, 173, 189, 205, 221, 237, 253,
  14, 30, 46, 62, 78, 94, 110, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_16x16[256]) = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, av1_col_iscan_16x16[256]) = {
  0,  4,  11,  20,  31,  43,  59,  75,  85,  109, 130, 150, 165, 181, 195, 198,
  1,  6,  14,  23,  34,  47,  64,  81,  95,  114, 135, 153, 171, 188, 201, 212,
  2,  8,  16,  25,  38,  52,  67,  83,  101, 116, 136, 157, 172, 190, 205, 216,
  3,  10, 18,  29,  41,  55,  71,  89,  103, 119, 141, 159, 176, 194, 208, 218,
  5,  12, 21,  32,  45,  58,  74,  93,  104, 123, 144, 164, 179, 196, 210, 223,
  7,  15, 26,  37,  49,  63,  78,  96,  112, 129, 146, 166, 182, 200, 215, 228,
  9,  19, 28,  39,  54,  69,  86,  102, 117, 132, 151, 170, 187, 206, 220, 230,
  13, 24, 35,  46,  60,  73,  91,  108, 122, 137, 154, 174, 189, 207, 224, 235,
  17, 30, 40,  53,  66,  82,  98,  115, 126, 142, 161, 180, 197, 213, 227, 237,
  22, 36, 48,  62,  76,  92,  105, 120, 133, 147, 167, 186, 203, 219, 232, 240,
  27, 44, 56,  70,  84,  99,  113, 127, 140, 156, 175, 193, 209, 226, 236, 244,
  33, 51, 68,  79,  94,  110, 125, 138, 149, 162, 184, 202, 217, 229, 241, 247,
  42, 61, 77,  90,  106, 121, 134, 148, 160, 173, 191, 211, 225, 238, 245, 251,
  50, 72, 87,  100, 118, 128, 145, 158, 168, 183, 204, 222, 233, 242, 249, 253,
  57, 80, 97,  111, 131, 143, 155, 169, 178, 192, 214, 231, 239, 246, 250, 254,
  65, 88, 107, 124, 139, 152, 163, 177, 185, 199, 221, 234, 243, 248, 252, 255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_row_iscan_16x16[256]) = {
  0,   1,   2,   4,   6,   9,   12,  17,  22,  29,  36,  43,  54,  64,  76,
  86,  3,   5,   7,   11,  15,  19,  25,  32,  38,  48,  59,  68,  84,  99,
  115, 130, 8,   10,  13,  18,  23,  27,  33,  42,  51,  60,  72,  88,  103,
  119, 142, 167, 14,  16,  20,  26,  31,  37,  44,  53,  61,  73,  85,  100,
  116, 135, 161, 185, 21,  24,  30,  35,  40,  47,  55,  65,  74,  81,  94,
  112, 133, 154, 179, 205, 28,  34,  39,  45,  50,  58,  67,  77,  87,  96,
  106, 121, 146, 169, 196, 212, 41,  46,  49,  56,  63,  70,  79,  90,  98,
  107, 122, 138, 159, 182, 207, 222, 52,  57,  62,  69,  75,  83,  93,  102,
  110, 120, 134, 150, 176, 195, 215, 226, 66,  71,  78,  82,  91,  97,  108,
  113, 127, 136, 148, 168, 188, 202, 221, 232, 80,  89,  92,  101, 105, 114,
  125, 131, 139, 151, 162, 177, 192, 208, 223, 234, 95,  104, 109, 117, 123,
  128, 143, 144, 155, 165, 175, 190, 206, 219, 233, 239, 111, 118, 124, 129,
  140, 147, 157, 164, 170, 181, 191, 203, 224, 230, 240, 243, 126, 132, 137,
  145, 153, 160, 174, 178, 184, 197, 204, 216, 231, 237, 244, 246, 141, 149,
  156, 166, 172, 180, 189, 199, 200, 210, 220, 228, 238, 242, 249, 251, 152,
  163, 171, 183, 186, 193, 201, 211, 214, 218, 227, 236, 245, 247, 252, 253,
  158, 173, 187, 194, 198, 209, 213, 217, 225, 229, 235, 241, 248, 250, 254,
  255,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_16x16[256]) = {
  0,   2,   5,   9,   17,  24,  36,  44,  55,  72,  88,  104, 128, 143, 166,
  179, 1,   4,   8,   13,  20,  30,  40,  54,  66,  79,  96,  113, 141, 154,
  178, 196, 3,   7,   11,  18,  25,  33,  46,  57,  71,  86,  101, 119, 148,
  164, 186, 201, 6,   12,  16,  23,  31,  39,  53,  64,  78,  92,  110, 127,
  153, 169, 193, 208, 10,  14,  19,  28,  37,  47,  58,  67,  84,  98,  114,
  133, 161, 176, 198, 214, 15,  21,  26,  34,  43,  52,  65,  77,  91,  106,
  120, 140, 165, 185, 205, 221, 22,  27,  32,  41,  48,  60,  73,  85,  99,
  116, 130, 151, 175, 190, 211, 225, 29,  35,  42,  49,  59,  69,  81,  95,
  108, 125, 139, 155, 182, 197, 217, 229, 38,  45,  51,  61,  68,  80,  93,
  105, 118, 134, 150, 168, 191, 207, 223, 234, 50,  56,  63,  74,  83,  94,
  109, 117, 129, 147, 163, 177, 199, 213, 228, 238, 62,  70,  76,  87,  97,
  107, 122, 131, 145, 159, 172, 188, 210, 222, 235, 242, 75,  82,  90,  102,
  112, 124, 138, 146, 157, 173, 187, 202, 219, 230, 240, 245, 89,  100, 111,
  123, 132, 142, 156, 167, 180, 189, 203, 216, 231, 237, 246, 250, 103, 115,
  126, 136, 149, 162, 171, 183, 194, 204, 215, 224, 236, 241, 248, 252, 121,
  135, 144, 158, 170, 181, 192, 200, 209, 218, 227, 233, 243, 244, 251, 254,
  137, 152, 160, 174, 184, 195, 206, 212, 220, 226, 232, 239, 247, 249, 253,
  255,
};

#if CONFIG_EXT_TX
DECLARE_ALIGNED(16, static const int16_t, av1_mcol_iscan_32x32[1024]) = {
  0,   32,   64,  96,   128, 160,  192, 224,  256, 288,  320, 352,  384, 416,
  448, 480,  512, 544,  576, 608,  640, 672,  704, 736,  768, 800,  832, 864,
  896, 928,  960, 992,  1,   33,   65,  97,   129, 161,  193, 225,  257, 289,
  321, 353,  385, 417,  449, 481,  513, 545,  577, 609,  641, 673,  705, 737,
  769, 801,  833, 865,  897, 929,  961, 993,  2,   34,   66,  98,   130, 162,
  194, 226,  258, 290,  322, 354,  386, 418,  450, 482,  514, 546,  578, 610,
  642, 674,  706, 738,  770, 802,  834, 866,  898, 930,  962, 994,  3,   35,
  67,  99,   131, 163,  195, 227,  259, 291,  323, 355,  387, 419,  451, 483,
  515, 547,  579, 611,  643, 675,  707, 739,  771, 803,  835, 867,  899, 931,
  963, 995,  4,   36,   68,  100,  132, 164,  196, 228,  260, 292,  324, 356,
  388, 420,  452, 484,  516, 548,  580, 612,  644, 676,  708, 740,  772, 804,
  836, 868,  900, 932,  964, 996,  5,   37,   69,  101,  133, 165,  197, 229,
  261, 293,  325, 357,  389, 421,  453, 485,  517, 549,  581, 613,  645, 677,
  709, 741,  773, 805,  837, 869,  901, 933,  965, 997,  6,   38,   70,  102,
  134, 166,  198, 230,  262, 294,  326, 358,  390, 422,  454, 486,  518, 550,
  582, 614,  646, 678,  710, 742,  774, 806,  838, 870,  902, 934,  966, 998,
  7,   39,   71,  103,  135, 167,  199, 231,  263, 295,  327, 359,  391, 423,
  455, 487,  519, 551,  583, 615,  647, 679,  711, 743,  775, 807,  839, 871,
  903, 935,  967, 999,  8,   40,   72,  104,  136, 168,  200, 232,  264, 296,
  328, 360,  392, 424,  456, 488,  520, 552,  584, 616,  648, 680,  712, 744,
  776, 808,  840, 872,  904, 936,  968, 1000, 9,   41,   73,  105,  137, 169,
  201, 233,  265, 297,  329, 361,  393, 425,  457, 489,  521, 553,  585, 617,
  649, 681,  713, 745,  777, 809,  841, 873,  905, 937,  969, 1001, 10,  42,
  74,  106,  138, 170,  202, 234,  266, 298,  330, 362,  394, 426,  458, 490,
  522, 554,  586, 618,  650, 682,  714, 746,  778, 810,  842, 874,  906, 938,
  970, 1002, 11,  43,   75,  107,  139, 171,  203, 235,  267, 299,  331, 363,
  395, 427,  459, 491,  523, 555,  587, 619,  651, 683,  715, 747,  779, 811,
  843, 875,  907, 939,  971, 1003, 12,  44,   76,  108,  140, 172,  204, 236,
  268, 300,  332, 364,  396, 428,  460, 492,  524, 556,  588, 620,  652, 684,
  716, 748,  780, 812,  844, 876,  908, 940,  972, 1004, 13,  45,   77,  109,
  141, 173,  205, 237,  269, 301,  333, 365,  397, 429,  461, 493,  525, 557,
  589, 621,  653, 685,  717, 749,  781, 813,  845, 877,  909, 941,  973, 1005,
  14,  46,   78,  110,  142, 174,  206, 238,  270, 302,  334, 366,  398, 430,
  462, 494,  526, 558,  590, 622,  654, 686,  718, 750,  782, 814,  846, 878,
  910, 942,  974, 1006, 15,  47,   79,  111,  143, 175,  207, 239,  271, 303,
  335, 367,  399, 431,  463, 495,  527, 559,  591, 623,  655, 687,  719, 751,
  783, 815,  847, 879,  911, 943,  975, 1007, 16,  48,   80,  112,  144, 176,
  208, 240,  272, 304,  336, 368,  400, 432,  464, 496,  528, 560,  592, 624,
  656, 688,  720, 752,  784, 816,  848, 880,  912, 944,  976, 1008, 17,  49,
  81,  113,  145, 177,  209, 241,  273, 305,  337, 369,  401, 433,  465, 497,
  529, 561,  593, 625,  657, 689,  721, 753,  785, 817,  849, 881,  913, 945,
  977, 1009, 18,  50,   82,  114,  146, 178,  210, 242,  274, 306,  338, 370,
  402, 434,  466, 498,  530, 562,  594, 626,  658, 690,  722, 754,  786, 818,
  850, 882,  914, 946,  978, 1010, 19,  51,   83,  115,  147, 179,  211, 243,
  275, 307,  339, 371,  403, 435,  467, 499,  531, 563,  595, 627,  659, 691,
  723, 755,  787, 819,  851, 883,  915, 947,  979, 1011, 20,  52,   84,  116,
  148, 180,  212, 244,  276, 308,  340, 372,  404, 436,  468, 500,  532, 564,
  596, 628,  660, 692,  724, 756,  788, 820,  852, 884,  916, 948,  980, 1012,
  21,  53,   85,  117,  149, 181,  213, 245,  277, 309,  341, 373,  405, 437,
  469, 501,  533, 565,  597, 629,  661, 693,  725, 757,  789, 821,  853, 885,
  917, 949,  981, 1013, 22,  54,   86,  118,  150, 182,  214, 246,  278, 310,
  342, 374,  406, 438,  470, 502,  534, 566,  598, 630,  662, 694,  726, 758,
  790, 822,  854, 886,  918, 950,  982, 1014, 23,  55,   87,  119,  151, 183,
  215, 247,  279, 311,  343, 375,  407, 439,  471, 503,  535, 567,  599, 631,
  663, 695,  727, 759,  791, 823,  855, 887,  919, 951,  983, 1015, 24,  56,
  88,  120,  152, 184,  216, 248,  280, 312,  344, 376,  408, 440,  472, 504,
  536, 568,  600, 632,  664, 696,  728, 760,  792, 824,  856, 888,  920, 952,
  984, 1016, 25,  57,   89,  121,  153, 185,  217, 249,  281, 313,  345, 377,
  409, 441,  473, 505,  537, 569,  601, 633,  665, 697,  729, 761,  793, 825,
  857, 889,  921, 953,  985, 1017, 26,  58,   90,  122,  154, 186,  218, 250,
  282, 314,  346, 378,  410, 442,  474, 506,  538, 570,  602, 634,  666, 698,
  730, 762,  794, 826,  858, 890,  922, 954,  986, 1018, 27,  59,   91,  123,
  155, 187,  219, 251,  283, 315,  347, 379,  411, 443,  475, 507,  539, 571,
  603, 635,  667, 699,  731, 763,  795, 827,  859, 891,  923, 955,  987, 1019,
  28,  60,   92,  124,  156, 188,  220, 252,  284, 316,  348, 380,  412, 444,
  476, 508,  540, 572,  604, 636,  668, 700,  732, 764,  796, 828,  860, 892,
  924, 956,  988, 1020, 29,  61,   93,  125,  157, 189,  221, 253,  285, 317,
  349, 381,  413, 445,  477, 509,  541, 573,  605, 637,  669, 701,  733, 765,
  797, 829,  861, 893,  925, 957,  989, 1021, 30,  62,   94,  126,  158, 190,
  222, 254,  286, 318,  350, 382,  414, 446,  478, 510,  542, 574,  606, 638,
  670, 702,  734, 766,  798, 830,  862, 894,  926, 958,  990, 1022, 31,  63,
  95,  127,  159, 191,  223, 255,  287, 319,  351, 383,  415, 447,  479, 511,
  543, 575,  607, 639,  671, 703,  735, 767,  799, 831,  863, 895,  927, 959,
  991, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_mrow_iscan_32x32[1024]) = {
  0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,
  13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
  26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
  39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
  52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
  65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
  78,   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
  91,   92,   93,   94,   95,   96,   97,   98,   99,   100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,
  156,  157,  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,  168,
  169,  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
  208,  209,  210,  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  249,  250,  251,  252,  253,  254,  255,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  420,  421,  422,  423,  424,  425,  426,  427,  428,
  429,  430,  431,  432,  433,  434,  435,  436,  437,  438,  439,  440,  441,
  442,  443,  444,  445,  446,  447,  448,  449,  450,  451,  452,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,  465,  466,  467,
  468,  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,  479,  480,
  481,  482,  483,  484,  485,  486,  487,  488,  489,  490,  491,  492,  493,
  494,  495,  496,  497,  498,  499,  500,  501,  502,  503,  504,  505,  506,
  507,  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,  518,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,  532,
  533,  534,  535,  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  551,  552,  553,  554,  555,  556,  557,  558,
  559,  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,  573,  574,  575,  576,  577,  578,  579,  580,  581,  582,  583,  584,
  585,  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,  610,
  611,  612,  613,  614,  615,  616,  617,  618,  619,  620,  621,  622,  623,
  624,  625,  626,  627,  628,  629,  630,  631,  632,  633,  634,  635,  636,
  637,  638,  639,  640,  641,  642,  643,  644,  645,  646,  647,  648,  649,
  650,  651,  652,  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
  676,  677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,
  689,  690,  691,  692,  693,  694,  695,  696,  697,  698,  699,  700,  701,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,  712,  713,  714,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,  727,
  728,  729,  730,  731,  732,  733,  734,  735,  736,  737,  738,  739,  740,
  741,  742,  743,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,
  754,  755,  756,  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  767,  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,  778,  779,
  780,  781,  782,  783,  784,  785,  786,  787,  788,  789,  790,  791,  792,
  793,  794,  795,  796,  797,  798,  799,  800,  801,  802,  803,  804,  805,
  806,  807,  808,  809,  810,  811,  812,  813,  814,  815,  816,  817,  818,
  819,  820,  821,  822,  823,  824,  825,  826,  827,  828,  829,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,  842,  843,  844,
  845,  846,  847,  848,  849,  850,  851,  852,  853,  854,  855,  856,  857,
  858,  859,  860,  861,  862,  863,  864,  865,  866,  867,  868,  869,  870,
  871,  872,  873,  874,  875,  876,  877,  878,  879,  880,  881,  882,  883,
  884,  885,  886,  887,  888,  889,  890,  891,  892,  893,  894,  895,  896,
  897,  898,  899,  900,  901,  902,  903,  904,  905,  906,  907,  908,  909,
  910,  911,  912,  913,  914,  915,  916,  917,  918,  919,  920,  921,  922,
  923,  924,  925,  926,  927,  928,  929,  930,  931,  932,  933,  934,  935,
  936,  937,  938,  939,  940,  941,  942,  943,  944,  945,  946,  947,  948,
  949,  950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,
  962,  963,  964,  965,  966,  967,  968,  969,  970,  971,  972,  973,  974,
  975,  976,  977,  978,  979,  980,  981,  982,  983,  984,  985,  986,  987,
  988,  989,  990,  991,  992,  993,  994,  995,  996,  997,  998,  999,  1000,
  1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
  1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
};
#endif  // CONFIG_EXT_TX

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x32[1024]) = {
  0,    2,    5,    10,   17,   25,   38,   47,   62,   83,   101,  121,  145,
  170,  193,  204,  210,  219,  229,  233,  245,  257,  275,  299,  342,  356,
  377,  405,  455,  471,  495,  527,  1,    4,    8,    15,   22,   30,   45,
  58,   74,   92,   112,  133,  158,  184,  203,  215,  222,  228,  234,  237,
  256,  274,  298,  317,  355,  376,  404,  426,  470,  494,  526,  551,  3,
  7,    12,   18,   28,   36,   52,   64,   82,   102,  118,  142,  164,  189,
  208,  217,  224,  231,  235,  238,  273,  297,  316,  329,  375,  403,  425,
  440,  493,  525,  550,  567,  6,    11,   16,   23,   31,   43,   60,   73,
  90,   109,  126,  150,  173,  196,  211,  220,  226,  232,  236,  239,  296,
  315,  328,  335,  402,  424,  439,  447,  524,  549,  566,  575,  9,    14,
  19,   29,   37,   50,   65,   78,   95,   116,  134,  157,  179,  201,  214,
  223,  244,  255,  272,  295,  341,  354,  374,  401,  454,  469,  492,  523,
  582,  596,  617,  645,  13,   20,   26,   35,   44,   54,   72,   85,   105,
  123,  140,  163,  182,  205,  216,  225,  254,  271,  294,  314,  353,  373,
  400,  423,  468,  491,  522,  548,  595,  616,  644,  666,  21,   27,   33,
  42,   53,   63,   80,   94,   113,  132,  151,  172,  190,  209,  218,  227,
  270,  293,  313,  327,  372,  399,  422,  438,  490,  521,  547,  565,  615,
  643,  665,  680,  24,   32,   39,   48,   57,   71,   88,   104,  120,  139,
  159,  178,  197,  212,  221,  230,  292,  312,  326,  334,  398,  421,  437,
  446,  520,  546,  564,  574,  642,  664,  679,  687,  34,   40,   46,   56,
  68,   81,   96,   111,  130,  147,  167,  186,  243,  253,  269,  291,  340,
  352,  371,  397,  453,  467,  489,  519,  581,  594,  614,  641,  693,  705,
  723,  747,  41,   49,   55,   67,   77,   91,   107,  124,  138,  161,  177,
  194,  252,  268,  290,  311,  351,  370,  396,  420,  466,  488,  518,  545,
  593,  613,  640,  663,  704,  722,  746,  765,  51,   59,   66,   76,   89,
  99,   119,  131,  149,  168,  181,  200,  267,  289,  310,  325,  369,  395,
  419,  436,  487,  517,  544,  563,  612,  639,  662,  678,  721,  745,  764,
  777,  61,   69,   75,   87,   100,  114,  129,  144,  162,  180,  191,  207,
  288,  309,  324,  333,  394,  418,  435,  445,  516,  543,  562,  573,  638,
  661,  677,  686,  744,  763,  776,  783,  70,   79,   86,   97,   108,  122,
  137,  155,  242,  251,  266,  287,  339,  350,  368,  393,  452,  465,  486,
  515,  580,  592,  611,  637,  692,  703,  720,  743,  788,  798,  813,  833,
  84,   93,   103,  110,  125,  141,  154,  171,  250,  265,  286,  308,  349,
  367,  392,  417,  464,  485,  514,  542,  591,  610,  636,  660,  702,  719,
  742,  762,  797,  812,  832,  848,  98,   106,  115,  127,  143,  156,  169,
  185,  264,  285,  307,  323,  366,  391,  416,  434,  484,  513,  541,  561,
  609,  635,  659,  676,  718,  741,  761,  775,  811,  831,  847,  858,  117,
  128,  136,  148,  160,  175,  188,  198,  284,  306,  322,  332,  390,  415,
  433,  444,  512,  540,  560,  572,  634,  658,  675,  685,  740,  760,  774,
  782,  830,  846,  857,  863,  135,  146,  152,  165,  241,  249,  263,  283,
  338,  348,  365,  389,  451,  463,  483,  511,  579,  590,  608,  633,  691,
  701,  717,  739,  787,  796,  810,  829,  867,  875,  887,  903,  153,  166,
  174,  183,  248,  262,  282,  305,  347,  364,  388,  414,  462,  482,  510,
  539,  589,  607,  632,  657,  700,  716,  738,  759,  795,  809,  828,  845,
  874,  886,  902,  915,  176,  187,  195,  202,  261,  281,  304,  321,  363,
  387,  413,  432,  481,  509,  538,  559,  606,  631,  656,  674,  715,  737,
  758,  773,  808,  827,  844,  856,  885,  901,  914,  923,  192,  199,  206,
  213,  280,  303,  320,  331,  386,  412,  431,  443,  508,  537,  558,  571,
  630,  655,  673,  684,  736,  757,  772,  781,  826,  843,  855,  862,  900,
  913,  922,  927,  240,  247,  260,  279,  337,  346,  362,  385,  450,  461,
  480,  507,  578,  588,  605,  629,  690,  699,  714,  735,  786,  794,  807,
  825,  866,  873,  884,  899,  930,  936,  945,  957,  246,  259,  278,  302,
  345,  361,  384,  411,  460,  479,  506,  536,  587,  604,  628,  654,  698,
  713,  734,  756,  793,  806,  824,  842,  872,  883,  898,  912,  935,  944,
  956,  966,  258,  277,  301,  319,  360,  383,  410,  430,  478,  505,  535,
  557,  603,  627,  653,  672,  712,  733,  755,  771,  805,  823,  841,  854,
  882,  897,  911,  921,  943,  955,  965,  972,  276,  300,  318,  330,  382,
  409,  429,  442,  504,  534,  556,  570,  626,  652,  671,  683,  732,  754,
  770,  780,  822,  840,  853,  861,  896,  910,  920,  926,  954,  964,  971,
  975,  336,  344,  359,  381,  449,  459,  477,  503,  577,  586,  602,  625,
  689,  697,  711,  731,  785,  792,  804,  821,  865,  871,  881,  895,  929,
  934,  942,  953,  977,  981,  987,  995,  343,  358,  380,  408,  458,  476,
  502,  533,  585,  601,  624,  651,  696,  710,  730,  753,  791,  803,  820,
  839,  870,  880,  894,  909,  933,  941,  952,  963,  980,  986,  994,  1001,
  357,  379,  407,  428,  475,  501,  532,  555,  600,  623,  650,  670,  709,
  729,  752,  769,  802,  819,  838,  852,  879,  893,  908,  919,  940,  951,
  962,  970,  985,  993,  1000, 1005, 378,  406,  427,  441,  500,  531,  554,
  569,  622,  649,  669,  682,  728,  751,  768,  779,  818,  837,  851,  860,
  892,  907,  918,  925,  950,  961,  969,  974,  992,  999,  1004, 1007, 448,
  457,  474,  499,  576,  584,  599,  621,  688,  695,  708,  727,  784,  790,
  801,  817,  864,  869,  878,  891,  928,  932,  939,  949,  976,  979,  984,
  991,  1008, 1010, 1013, 1017, 456,  473,  498,  530,  583,  598,  620,  648,
  694,  707,  726,  750,  789,  800,  816,  836,  868,  877,  890,  906,  931,
  938,  948,  960,  978,  983,  990,  998,  1009, 1012, 1016, 1020, 472,  497,
  529,  553,  597,  619,  647,  668,  706,  725,  749,  767,  799,  815,  835,
  850,  876,  889,  905,  917,  937,  947,  959,  968,  982,  989,  997,  1003,
  1011, 1015, 1019, 1022, 496,  528,  552,  568,  618,  646,  667,  681,  724,
  748,  766,  778,  814,  834,  849,  859,  888,  904,  916,  924,  946,  958,
  967,  973,  988,  996,  1002, 1006, 1014, 1018, 1021, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_v2_iscan_32x32[1024]) = {
  0,    1,    4,    9,    15,   22,   33,   43,   56,   71,   86,   104,  121,
  142,  166,  189,  512,  518,  527,  539,  551,  566,  584,  602,  621,  644,
  668,  695,  721,  748,  780,  811,  2,    3,    6,    11,   17,   26,   35,
  45,   58,   73,   90,   106,  123,  146,  168,  193,  513,  519,  528,  540,
  553,  567,  585,  603,  622,  647,  670,  696,  722,  751,  783,  812,  5,
  7,    8,    13,   20,   28,   37,   50,   62,   75,   92,   108,  129,  150,
  170,  195,  514,  521,  530,  541,  554,  569,  587,  605,  625,  649,  671,
  699,  725,  752,  785,  815,  10,   12,   14,   19,   23,   31,   41,   52,
  65,   81,   96,   113,  133,  152,  175,  201,  515,  522,  531,  542,  556,
  572,  589,  607,  629,  651,  673,  700,  726,  757,  788,  819,  16,   18,
  21,   24,   30,   39,   48,   59,   69,   83,   100,  119,  137,  158,  181,
  203,  516,  523,  534,  545,  559,  574,  591,  610,  632,  654,  679,  704,
  730,  762,  791,  824,  25,   27,   29,   32,   40,   46,   54,   67,   79,
  94,   109,  127,  143,  164,  185,  210,  517,  525,  535,  547,  561,  578,
  595,  615,  635,  656,  684,  707,  737,  766,  793,  830,  34,   36,   38,
  42,   49,   55,   64,   76,   87,   102,  117,  135,  154,  176,  197,  219,
  520,  529,  538,  550,  565,  580,  598,  618,  639,  664,  687,  712,  741,
  769,  802,  833,  44,   47,   51,   53,   60,   68,   77,   85,   98,   114,
  131,  147,  162,  183,  208,  227,  524,  533,  544,  557,  571,  588,  606,
  623,  645,  667,  692,  720,  747,  776,  806,  838,  57,   61,   63,   66,
  70,   80,   88,   99,   112,  124,  140,  159,  179,  199,  216,  233,  526,
  536,  548,  562,  577,  593,  613,  633,  653,  676,  701,  727,  756,  786,
  814,  847,  72,   74,   78,   82,   84,   95,   103,  115,  125,  139,  156,
  173,  190,  211,  229,  246,  532,  543,  555,  568,  581,  601,  619,  637,
  663,  685,  709,  738,  763,  792,  826,  855,  89,   91,   93,   97,   101,
  110,  118,  132,  141,  157,  171,  186,  206,  224,  241,  255,  537,  549,
  560,  576,  592,  608,  628,  650,  669,  693,  719,  744,  773,  805,  834,
  862,  105,  107,  111,  116,  120,  128,  136,  148,  160,  174,  187,  205,
  221,  236,  251,  267,  546,  558,  570,  583,  600,  617,  636,  657,  680,
  706,  729,  758,  787,  813,  846,  871,  122,  126,  130,  134,  138,  144,
  155,  163,  180,  191,  207,  222,  232,  248,  264,  278,  552,  564,  579,
  594,  609,  630,  648,  666,  688,  715,  742,  768,  797,  827,  856,  877,
  145,  149,  151,  153,  161,  165,  177,  184,  200,  212,  225,  237,  249,
  262,  275,  289,  563,  575,  590,  604,  620,  638,  660,  683,  705,  728,
  753,  779,  809,  839,  866,  889,  167,  169,  172,  178,  182,  188,  198,
  209,  217,  230,  242,  252,  265,  276,  288,  301,  573,  586,  599,  616,
  634,  652,  672,  694,  716,  743,  767,  794,  825,  850,  874,  899,  192,
  194,  196,  202,  204,  213,  220,  228,  234,  247,  256,  268,  279,  290,
  302,  315,  582,  597,  614,  631,  646,  665,  686,  708,  732,  759,  784,
  810,  837,  863,  886,  908,  214,  215,  218,  223,  226,  231,  239,  244,
  253,  261,  271,  283,  292,  304,  317,  325,  596,  611,  626,  642,  661,
  681,  702,  723,  745,  770,  800,  828,  853,  875,  897,  919,  235,  238,
  240,  243,  245,  250,  257,  263,  270,  280,  287,  298,  307,  319,  329,
  340,  612,  624,  640,  658,  677,  697,  717,  739,  764,  789,  816,  844,
  867,  890,  909,  927,  254,  258,  259,  260,  266,  269,  272,  282,  286,
  296,  303,  312,  323,  333,  341,  355,  627,  641,  655,  674,  690,  713,
  735,  760,  781,  807,  835,  857,  880,  902,  921,  940,  273,  274,  277,
  281,  284,  285,  291,  299,  305,  310,  320,  327,  337,  346,  357,  369,
  643,  659,  675,  689,  710,  733,  754,  777,  803,  831,  851,  872,  892,
  913,  934,  950,  293,  294,  295,  297,  300,  306,  308,  314,  321,  326,
  335,  343,  352,  361,  372,  378,  662,  678,  691,  711,  731,  749,  774,
  798,  822,  848,  869,  887,  906,  925,  942,  961,  309,  311,  313,  316,
  318,  322,  324,  332,  338,  344,  351,  358,  367,  375,  386,  394,  682,
  698,  714,  734,  750,  772,  795,  820,  842,  864,  884,  904,  923,  938,
  954,  967,  328,  330,  331,  334,  336,  339,  342,  348,  354,  359,  366,
  374,  382,  391,  400,  409,  703,  718,  736,  755,  775,  796,  818,  840,
  860,  882,  900,  917,  936,  952,  965,  977,  345,  347,  349,  350,  353,
  356,  360,  364,  371,  376,  383,  389,  395,  406,  412,  423,  724,  740,
  761,  778,  799,  821,  841,  859,  878,  895,  915,  932,  948,  963,  975,
  986,  362,  363,  365,  368,  370,  373,  377,  379,  387,  392,  397,  405,
  411,  420,  428,  439,  746,  765,  782,  804,  823,  843,  861,  879,  894,
  911,  930,  946,  959,  973,  984,  994,  380,  381,  384,  385,  388,  390,
  393,  396,  403,  408,  413,  422,  427,  436,  444,  452,  771,  790,  808,
  832,  849,  865,  883,  896,  912,  928,  944,  957,  971,  982,  992,  1001,
  398,  399,  401,  402,  404,  407,  410,  414,  419,  425,  429,  437,  442,
  449,  458,  465,  801,  817,  836,  852,  870,  885,  901,  916,  931,  945,
  956,  969,  980,  990,  999,  1007, 415,  416,  417,  418,  421,  424,  426,
  430,  434,  441,  445,  453,  459,  463,  473,  480,  829,  845,  858,  873,
  888,  905,  918,  933,  947,  958,  970,  979,  988,  997,  1005, 1012, 431,
  432,  433,  435,  438,  440,  443,  446,  451,  456,  461,  468,  475,  479,
  488,  494,  854,  868,  881,  893,  907,  924,  937,  949,  960,  972,  981,
  989,  996,  1003, 1010, 1016, 447,  448,  450,  454,  455,  457,  460,  462,
  469,  472,  477,  482,  490,  495,  499,  503,  876,  891,  903,  914,  926,
  939,  953,  964,  974,  983,  991,  998,  1004, 1009, 1014, 1019, 464,  466,
  467,  470,  471,  474,  476,  478,  484,  489,  493,  497,  501,  504,  506,
  508,  898,  910,  922,  935,  943,  955,  966,  976,  985,  993,  1000, 1006,
  1011, 1015, 1018, 1021, 481,  483,  485,  486,  487,  491,  492,  496,  498,
  500,  502,  505,  507,  509,  510,  511,  920,  929,  941,  951,  962,  968,
  978,  987,  995,  1002, 1008, 1013, 1017, 1020, 1022, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_h2_iscan_32x32[1024]) = {
  0,    1,    4,    9,    15,   22,   33,   43,   56,   71,   86,   104,  121,
  142,  166,  189,  214,  233,  254,  273,  292,  309,  328,  345,  362,  378,
  397,  415,  431,  447,  464,  481,  2,    3,    6,    11,   17,   26,   35,
  45,   58,   73,   90,   106,  123,  146,  168,  193,  215,  236,  255,  274,
  294,  310,  329,  346,  363,  381,  399,  416,  432,  448,  465,  482,  5,
  7,    8,    13,   20,   28,   37,   50,   62,   75,   92,   108,  129,  150,
  170,  195,  216,  240,  259,  275,  295,  312,  331,  348,  365,  383,  400,
  417,  433,  449,  467,  485,  10,   12,   14,   19,   23,   31,   41,   52,
  65,   81,   96,   113,  133,  152,  175,  201,  221,  243,  260,  280,  297,
  315,  333,  350,  367,  385,  402,  418,  434,  452,  470,  486,  16,   18,
  21,   24,   30,   39,   48,   59,   69,   83,   100,  119,  137,  158,  181,
  203,  226,  244,  264,  283,  300,  318,  335,  353,  370,  388,  404,  420,
  438,  455,  471,  487,  25,   27,   29,   32,   40,   46,   54,   67,   79,
  94,   109,  127,  143,  164,  185,  210,  231,  250,  269,  285,  304,  322,
  339,  356,  373,  389,  407,  423,  440,  457,  473,  491,  34,   36,   38,
  42,   49,   55,   64,   76,   87,   102,  117,  135,  154,  176,  197,  219,
  239,  256,  272,  291,  308,  324,  341,  359,  377,  393,  410,  426,  442,
  460,  476,  492,  44,   47,   51,   53,   60,   68,   77,   85,   98,   114,
  131,  147,  162,  183,  208,  227,  245,  262,  282,  298,  314,  332,  349,
  364,  379,  396,  412,  430,  446,  462,  478,  495,  57,   61,   63,   66,
  70,   80,   88,   99,   112,  124,  140,  159,  179,  199,  217,  234,  253,
  270,  286,  305,  321,  337,  354,  371,  387,  403,  419,  435,  451,  468,
  484,  498,  72,   74,   78,   82,   84,   95,   103,  115,  125,  139,  156,
  173,  190,  211,  229,  246,  261,  281,  296,  311,  325,  344,  360,  375,
  392,  408,  425,  441,  456,  472,  489,  500,  89,   91,   93,   97,   101,
  110,  118,  132,  141,  157,  171,  186,  206,  224,  241,  257,  271,  287,
  303,  320,  336,  351,  366,  384,  398,  413,  429,  445,  461,  477,  493,
  502,  105,  107,  111,  116,  120,  128,  136,  148,  160,  174,  187,  205,
  222,  237,  251,  267,  284,  299,  313,  327,  343,  358,  374,  390,  405,
  422,  437,  453,  469,  483,  497,  505,  122,  126,  130,  134,  138,  144,
  155,  163,  180,  191,  207,  223,  232,  248,  265,  278,  293,  307,  323,
  338,  352,  368,  382,  395,  411,  427,  443,  459,  475,  490,  501,  507,
  145,  149,  151,  153,  161,  165,  177,  184,  200,  212,  225,  238,  249,
  263,  276,  289,  306,  319,  334,  347,  361,  376,  391,  406,  421,  436,
  450,  463,  479,  496,  504,  509,  167,  169,  172,  178,  182,  188,  198,
  209,  218,  230,  242,  252,  266,  277,  288,  301,  317,  330,  342,  357,
  372,  386,  401,  414,  428,  444,  458,  474,  488,  499,  506,  510,  192,
  194,  196,  202,  204,  213,  220,  228,  235,  247,  258,  268,  279,  290,
  302,  316,  326,  340,  355,  369,  380,  394,  409,  424,  439,  454,  466,
  480,  494,  503,  508,  511,  512,  513,  514,  515,  516,  517,  520,  523,
  526,  532,  537,  545,  551,  561,  573,  581,  596,  610,  625,  642,  661,
  680,  701,  722,  745,  770,  800,  827,  853,  875,  897,  919,  518,  519,
  521,  522,  524,  525,  528,  533,  536,  542,  549,  557,  564,  575,  585,
  597,  611,  623,  640,  656,  676,  696,  717,  739,  763,  789,  815,  844,
  867,  889,  909,  927,  527,  529,  530,  531,  534,  535,  538,  544,  548,
  555,  560,  569,  579,  589,  598,  614,  626,  641,  655,  673,  690,  712,
  735,  760,  780,  806,  834,  857,  880,  902,  921,  940,  539,  540,  541,
  543,  546,  547,  550,  558,  562,  567,  576,  583,  593,  603,  616,  631,
  643,  657,  674,  689,  710,  733,  752,  776,  803,  830,  850,  872,  892,
  913,  934,  950,  552,  553,  554,  556,  559,  563,  565,  571,  577,  582,
  591,  600,  609,  620,  634,  644,  662,  677,  691,  711,  730,  748,  773,
  798,  822,  847,  869,  887,  906,  925,  942,  961,  566,  568,  570,  572,
  574,  578,  580,  588,  594,  601,  608,  617,  629,  637,  652,  665,  681,
  697,  713,  734,  749,  772,  793,  819,  842,  863,  884,  904,  923,  938,
  954,  967,  584,  586,  587,  590,  592,  595,  599,  605,  613,  618,  628,
  636,  648,  660,  671,  686,  702,  718,  736,  753,  774,  794,  818,  840,
  860,  882,  900,  917,  936,  952,  965,  977,  602,  604,  606,  607,  612,
  615,  619,  624,  633,  638,  649,  658,  666,  683,  692,  707,  723,  740,
  761,  777,  799,  820,  841,  859,  877,  895,  915,  932,  948,  963,  975,
  986,  621,  622,  627,  630,  632,  635,  639,  645,  653,  663,  668,  682,
  688,  704,  716,  732,  746,  764,  781,  804,  823,  843,  861,  878,  894,
  911,  930,  946,  959,  973,  984,  994,  646,  647,  650,  651,  654,  659,
  664,  667,  678,  685,  693,  706,  715,  728,  743,  757,  771,  790,  807,
  831,  848,  864,  883,  896,  912,  928,  944,  957,  971,  982,  992,  1001,
  669,  670,  672,  675,  679,  684,  687,  694,  703,  709,  719,  729,  741,
  754,  767,  783,  801,  816,  835,  851,  870,  885,  901,  916,  931,  945,
  956,  969,  980,  990,  999,  1007, 695,  698,  699,  700,  705,  708,  714,
  720,  726,  738,  744,  758,  768,  779,  795,  810,  828,  845,  858,  873,
  888,  905,  918,  933,  947,  958,  970,  979,  988,  997,  1005, 1012, 721,
  724,  725,  727,  731,  737,  742,  747,  756,  765,  775,  786,  797,  809,
  825,  837,  854,  868,  881,  893,  907,  924,  937,  949,  960,  972,  981,
  989,  996,  1003, 1010, 1016, 750,  751,  755,  759,  762,  766,  769,  778,
  787,  792,  805,  812,  829,  838,  852,  865,  876,  890,  903,  914,  926,
  939,  953,  964,  974,  983,  991,  998,  1004, 1009, 1014, 1019, 782,  784,
  785,  788,  791,  796,  802,  808,  814,  826,  836,  846,  856,  866,  874,
  886,  898,  910,  922,  935,  943,  955,  966,  976,  985,  993,  1000, 1006,
  1011, 1015, 1018, 1021, 811,  813,  817,  821,  824,  832,  833,  839,  849,
  855,  862,  871,  879,  891,  899,  908,  920,  929,  941,  951,  962,  968,
  978,  987,  995,  1002, 1008, 1013, 1017, 1020, 1022, 1023,
};

DECLARE_ALIGNED(16, static const int16_t, av1_qtr_iscan_32x32[1024]) = {
  0,    1,    4,    9,    15,   22,   33,   43,   56,   71,   86,   104,  121,
  142,  166,  189,  256,  268,  286,  310,  334,  364,  400,  435,  471,  510,
  553,  598,  640,  683,  732,  780,  2,    3,    6,    11,   17,   26,   35,
  45,   58,   73,   90,   106,  123,  146,  168,  193,  258,  270,  288,  312,
  338,  366,  402,  437,  473,  516,  557,  600,  642,  687,  736,  782,  5,
  7,    8,    13,   20,   28,   37,   50,   62,   75,   92,   108,  129,  150,
  170,  195,  260,  274,  292,  314,  340,  370,  406,  441,  478,  520,  559,
  604,  646,  689,  740,  788,  10,   12,   14,   19,   23,   31,   41,   52,
  65,   81,   96,   113,  133,  152,  175,  201,  262,  276,  294,  316,  344,
  376,  410,  445,  484,  524,  563,  606,  648,  697,  746,  793,  16,   18,
  21,   24,   30,   39,   48,   59,   69,   83,   100,  119,  137,  158,  181,
  203,  264,  278,  300,  322,  350,  380,  414,  451,  490,  530,  571,  612,
  656,  705,  750,  799,  25,   27,   29,   32,   40,   46,   54,   67,   79,
  94,   109,  127,  143,  164,  185,  210,  266,  282,  302,  326,  354,  388,
  422,  459,  496,  533,  579,  618,  665,  711,  754,  809,  34,   36,   38,
  42,   49,   55,   64,   76,   87,   102,  117,  135,  154,  176,  197,  216,
  272,  289,  308,  332,  362,  392,  427,  465,  504,  545,  585,  626,  671,
  717,  766,  813,  44,   47,   51,   53,   60,   68,   77,   85,   98,   114,
  131,  147,  162,  183,  208,  222,  279,  298,  320,  346,  374,  408,  442,
  475,  511,  551,  592,  638,  681,  726,  772,  821,  57,   61,   63,   66,
  70,   80,   88,   99,   112,  124,  140,  159,  179,  199,  214,  227,  284,
  304,  328,  355,  386,  418,  455,  492,  528,  567,  608,  649,  695,  742,
  786,  833,  72,   74,   78,   82,   84,   95,   103,  115,  125,  139,  156,
  173,  190,  211,  224,  233,  296,  317,  342,  367,  394,  433,  466,  500,
  543,  581,  622,  667,  707,  752,  803,  843,  89,   91,   93,   97,   101,
  110,  118,  132,  141,  157,  171,  186,  206,  220,  231,  239,  306,  330,
  352,  384,  415,  447,  482,  521,  554,  593,  636,  677,  722,  770,  815,
  852,  105,  107,  111,  116,  120,  128,  136,  148,  160,  174,  187,  205,
  218,  229,  237,  244,  323,  347,  371,  398,  431,  463,  498,  534,  573,
  616,  654,  698,  743,  783,  831,  864,  122,  126,  130,  134,  138,  144,
  155,  163,  180,  191,  207,  219,  226,  235,  242,  248,  335,  360,  390,
  419,  449,  485,  518,  549,  587,  630,  672,  715,  760,  805,  845,  872,
  145,  149,  151,  153,  161,  165,  177,  184,  200,  212,  221,  230,  236,
  241,  246,  251,  356,  382,  411,  438,  469,  501,  539,  577,  613,  652,
  690,  730,  776,  822,  858,  886,  167,  169,  172,  178,  182,  188,  198,
  209,  215,  225,  232,  238,  243,  247,  250,  253,  378,  403,  428,  461,
  494,  526,  560,  594,  632,  675,  713,  755,  801,  837,  868,  897,  192,
  194,  196,  202,  204,  213,  217,  223,  228,  234,  240,  245,  249,  252,
  254,  255,  395,  425,  457,  488,  512,  547,  583,  619,  659,  699,  737,
  778,  819,  854,  882,  907,  257,  259,  261,  263,  265,  267,  273,  280,
  285,  297,  307,  324,  336,  357,  379,  396,  424,  452,  479,  508,  541,
  574,  609,  643,  679,  719,  764,  806,  841,  870,  895,  919,  269,  271,
  275,  277,  281,  283,  290,  299,  305,  318,  331,  348,  361,  383,  404,
  426,  453,  476,  506,  535,  568,  601,  634,  669,  708,  748,  789,  829,
  860,  887,  909,  927,  287,  291,  293,  295,  301,  303,  309,  321,  329,
  343,  353,  372,  391,  412,  429,  458,  480,  507,  532,  564,  590,  627,
  663,  703,  733,  773,  816,  847,  876,  901,  921,  940,  311,  313,  315,
  319,  325,  327,  333,  349,  358,  368,  385,  399,  420,  439,  462,  489,
  509,  536,  565,  589,  624,  661,  691,  727,  768,  810,  838,  866,  890,
  913,  934,  950,  337,  339,  341,  345,  351,  359,  363,  375,  387,  397,
  416,  432,  450,  470,  495,  513,  542,  569,  591,  625,  657,  684,  723,
  762,  797,  834,  862,  884,  905,  925,  942,  961,  365,  369,  373,  377,
  381,  389,  393,  409,  421,  434,  448,  464,  486,  502,  527,  548,  575,
  602,  628,  662,  685,  721,  756,  794,  827,  855,  880,  903,  923,  938,
  954,  967,  401,  405,  407,  413,  417,  423,  430,  443,  456,  467,  483,
  499,  519,  540,  561,  584,  610,  635,  664,  692,  724,  757,  792,  825,
  850,  878,  899,  917,  936,  952,  965,  977,  436,  440,  444,  446,  454,
  460,  468,  477,  493,  503,  522,  537,  550,  578,  595,  620,  644,  670,
  704,  728,  763,  795,  826,  849,  873,  893,  915,  932,  948,  963,  975,
  986,  472,  474,  481,  487,  491,  497,  505,  514,  529,  544,  555,  576,
  588,  614,  633,  660,  680,  709,  734,  769,  798,  828,  851,  874,  892,
  911,  930,  946,  959,  973,  984,  994,  515,  517,  523,  525,  531,  538,
  546,  552,  570,  582,  596,  617,  631,  653,  676,  700,  720,  749,  774,
  811,  835,  856,  879,  894,  912,  928,  944,  957,  971,  982,  992,  1001,
  556,  558,  562,  566,  572,  580,  586,  597,  611,  623,  637,  655,  673,
  693,  714,  738,  765,  790,  817,  839,  863,  881,  900,  916,  931,  945,
  956,  969,  980,  990,  999,  1007, 599,  603,  605,  607,  615,  621,  629,
  639,  650,  668,  678,  701,  716,  731,  758,  779,  807,  830,  848,  867,
  885,  904,  918,  933,  947,  958,  970,  979,  988,  997,  1005, 1012, 641,
  645,  647,  651,  658,  666,  674,  682,  696,  710,  725,  744,  761,  777,
  802,  820,  842,  861,  877,  891,  906,  924,  937,  949,  960,  972,  981,
  989,  996,  1003, 1010, 1016, 686,  688,  694,  702,  706,  712,  718,  729,
  745,  753,  771,  784,  808,  823,  840,  857,  871,  888,  902,  914,  926,
  939,  953,  964,  974,  983,  991,  998,  1004, 1009, 1014, 1019, 735,  739,
  741,  747,  751,  759,  767,  775,  787,  804,  818,  832,  846,  859,  869,
  883,  896,  910,  922,  935,  943,  955,  966,  976,  985,  993,  1000, 1006,
  1011, 1015, 1018, 1021, 781,  785,  791,  796,  800,  812,  814,  824,  836,
  844,  853,  865,  875,  889,  898,  908,  920,  929,  941,  951,  962,  968,
  978,  987,  995,  1002, 1008, 1013, 1017, 1020, 1022, 1023,
};

#if CONFIG_TX64X64
DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_32x64[2048]) = {
  0,    1,    3,    6,    10,   15,   21,   28,   36,   45,   55,   66,   78,
  91,   105,  120,  136,  153,  171,  190,  210,  231,  253,  276,  300,  325,
  351,  378,  406,  435,  465,  496,  2,    4,    7,    11,   16,   22,   29,
  37,   46,   56,   67,   79,   92,   106,  121,  137,  154,  172,  191,  211,
  232,  254,  277,  301,  326,  352,  379,  407,  436,  466,  497,  528,  5,
  8,    12,   17,   23,   30,   38,   47,   57,   68,   80,   93,   107,  122,
  138,  155,  173,  192,  212,  233,  255,  278,  302,  327,  353,  380,  408,
  437,  467,  498,  529,  560,  9,    13,   18,   24,   31,   39,   48,   58,
  69,   81,   94,   108,  123,  139,  156,  174,  193,  213,  234,  256,  279,
  303,  328,  354,  381,  409,  438,  468,  499,  530,  561,  592,  14,   19,
  25,   32,   40,   49,   59,   70,   82,   95,   109,  124,  140,  157,  175,
  194,  214,  235,  257,  280,  304,  329,  355,  382,  410,  439,  469,  500,
  531,  562,  593,  624,  20,   26,   33,   41,   50,   60,   71,   83,   96,
  110,  125,  141,  158,  176,  195,  215,  236,  258,  281,  305,  330,  356,
  383,  411,  440,  470,  501,  532,  563,  594,  625,  656,  27,   34,   42,
  51,   61,   72,   84,   97,   111,  126,  142,  159,  177,  196,  216,  237,
  259,  282,  306,  331,  357,  384,  412,  441,  471,  502,  533,  564,  595,
  626,  657,  688,  35,   43,   52,   62,   73,   85,   98,   112,  127,  143,
  160,  178,  197,  217,  238,  260,  283,  307,  332,  358,  385,  413,  442,
  472,  503,  534,  565,  596,  627,  658,  689,  720,  44,   53,   63,   74,
  86,   99,   113,  128,  144,  161,  179,  198,  218,  239,  261,  284,  308,
  333,  359,  386,  414,  443,  473,  504,  535,  566,  597,  628,  659,  690,
  721,  752,  54,   64,   75,   87,   100,  114,  129,  145,  162,  180,  199,
  219,  240,  262,  285,  309,  334,  360,  387,  415,  444,  474,  505,  536,
  567,  598,  629,  660,  691,  722,  753,  784,  65,   76,   88,   101,  115,
  130,  146,  163,  181,  200,  220,  241,  263,  286,  310,  335,  361,  388,
  416,  445,  475,  506,  537,  568,  599,  630,  661,  692,  723,  754,  785,
  816,  77,   89,   102,  116,  131,  147,  164,  182,  201,  221,  242,  264,
  287,  311,  336,  362,  389,  417,  446,  476,  507,  538,  569,  600,  631,
  662,  693,  724,  755,  786,  817,  848,  90,   103,  117,  132,  148,  165,
  183,  202,  222,  243,  265,  288,  312,  337,  363,  390,  418,  447,  477,
  508,  539,  570,  601,  632,  663,  694,  725,  756,  787,  818,  849,  880,
  104,  118,  133,  149,  166,  184,  203,  223,  244,  266,  289,  313,  338,
  364,  391,  419,  448,  478,  509,  540,  571,  602,  633,  664,  695,  726,
  757,  788,  819,  850,  881,  912,  119,  134,  150,  167,  185,  204,  224,
  245,  267,  290,  314,  339,  365,  392,  420,  449,  479,  510,  541,  572,
  603,  634,  665,  696,  727,  758,  789,  820,  851,  882,  913,  944,  135,
  151,  168,  186,  205,  225,  246,  268,  291,  315,  340,  366,  393,  421,
  450,  480,  511,  542,  573,  604,  635,  666,  697,  728,  759,  790,  821,
  852,  883,  914,  945,  976,  152,  169,  187,  206,  226,  247,  269,  292,
  316,  341,  367,  394,  422,  451,  481,  512,  543,  574,  605,  636,  667,
  698,  729,  760,  791,  822,  853,  884,  915,  946,  977,  1008, 170,  188,
  207,  227,  248,  270,  293,  317,  342,  368,  395,  423,  452,  482,  513,
  544,  575,  606,  637,  668,  699,  730,  761,  792,  823,  854,  885,  916,
  947,  978,  1009, 1040, 189,  208,  228,  249,  271,  294,  318,  343,  369,
  396,  424,  453,  483,  514,  545,  576,  607,  638,  669,  700,  731,  762,
  793,  824,  855,  886,  917,  948,  979,  1010, 1041, 1072, 209,  229,  250,
  272,  295,  319,  344,  370,  397,  425,  454,  484,  515,  546,  577,  608,
  639,  670,  701,  732,  763,  794,  825,  856,  887,  918,  949,  980,  1011,
  1042, 1073, 1104, 230,  251,  273,  296,  320,  345,  371,  398,  426,  455,
  485,  516,  547,  578,  609,  640,  671,  702,  733,  764,  795,  826,  857,
  888,  919,  950,  981,  1012, 1043, 1074, 1105, 1136, 252,  274,  297,  321,
  346,  372,  399,  427,  456,  486,  517,  548,  579,  610,  641,  672,  703,
  734,  765,  796,  827,  858,  889,  920,  951,  982,  1013, 1044, 1075, 1106,
  1137, 1168, 275,  298,  322,  347,  373,  400,  428,  457,  487,  518,  549,
  580,  611,  642,  673,  704,  735,  766,  797,  828,  859,  890,  921,  952,
  983,  1014, 1045, 1076, 1107, 1138, 1169, 1200, 299,  323,  348,  374,  401,
  429,  458,  488,  519,  550,  581,  612,  643,  674,  705,  736,  767,  798,
  829,  860,  891,  922,  953,  984,  1015, 1046, 1077, 1108, 1139, 1170, 1201,
  1232, 324,  349,  375,  402,  430,  459,  489,  520,  551,  582,  613,  644,
  675,  706,  737,  768,  799,  830,  861,  892,  923,  954,  985,  1016, 1047,
  1078, 1109, 1140, 1171, 1202, 1233, 1264, 350,  376,  403,  431,  460,  490,
  521,  552,  583,  614,  645,  676,  707,  738,  769,  800,  831,  862,  893,
  924,  955,  986,  1017, 1048, 1079, 1110, 1141, 1172, 1203, 1234, 1265, 1296,
  377,  404,  432,  461,  491,  522,  553,  584,  615,  646,  677,  708,  739,
  770,  801,  832,  863,  894,  925,  956,  987,  1018, 1049, 1080, 1111, 1142,
  1173, 1204, 1235, 1266, 1297, 1328, 405,  433,  462,  492,  523,  554,  585,
  616,  647,  678,  709,  740,  771,  802,  833,  864,  895,  926,  957,  988,
  1019, 1050, 1081, 1112, 1143, 1174, 1205, 1236, 1267, 1298, 1329, 1360, 434,
  463,  493,  524,  555,  586,  617,  648,  679,  710,  741,  772,  803,  834,
  865,  896,  927,  958,  989,  1020, 1051, 1082, 1113, 1144, 1175, 1206, 1237,
  1268, 1299, 1330, 1361, 1392, 464,  494,  525,  556,  587,  618,  649,  680,
  711,  742,  773,  804,  835,  866,  897,  928,  959,  990,  1021, 1052, 1083,
  1114, 1145, 1176, 1207, 1238, 1269, 1300, 1331, 1362, 1393, 1424, 495,  526,
  557,  588,  619,  650,  681,  712,  743,  774,  805,  836,  867,  898,  929,
  960,  991,  1022, 1053, 1084, 1115, 1146, 1177, 1208, 1239, 1270, 1301, 1332,
  1363, 1394, 1425, 1456, 527,  558,  589,  620,  651,  682,  713,  744,  775,
  806,  837,  868,  899,  930,  961,  992,  1023, 1054, 1085, 1116, 1147, 1178,
  1209, 1240, 1271, 1302, 1333, 1364, 1395, 1426, 1457, 1488, 559,  590,  621,
  652,  683,  714,  745,  776,  807,  838,  869,  900,  931,  962,  993,  1024,
  1055, 1086, 1117, 1148, 1179, 1210, 1241, 1272, 1303, 1334, 1365, 1396, 1427,
  1458, 1489, 1520, 591,  622,  653,  684,  715,  746,  777,  808,  839,  870,
  901,  932,  963,  994,  1025, 1056, 1087, 1118, 1149, 1180, 1211, 1242, 1273,
  1304, 1335, 1366, 1397, 1428, 1459, 1490, 1521, 1552, 623,  654,  685,  716,
  747,  778,  809,  840,  871,  902,  933,  964,  995,  1026, 1057, 1088, 1119,
  1150, 1181, 1212, 1243, 1274, 1305, 1336, 1367, 1398, 1429, 1460, 1491, 1522,
  1553, 1583, 655,  686,  717,  748,  779,  810,  841,  872,  903,  934,  965,
  996,  1027, 1058, 1089, 1120, 1151, 1182, 1213, 1244, 1275, 1306, 1337, 1368,
  1399, 1430, 1461, 1492, 1523, 1554, 1584, 1613, 687,  718,  749,  780,  811,
  842,  873,  904,  935,  966,  997,  1028, 1059, 1090, 1121, 1152, 1183, 1214,
  1245, 1276, 1307, 1338, 1369, 1400, 1431, 1462, 1493, 1524, 1555, 1585, 1614,
  1642, 719,  750,  781,  812,  843,  874,  905,  936,  967,  998,  1029, 1060,
  1091, 1122, 1153, 1184, 1215, 1246, 1277, 1308, 1339, 1370, 1401, 1432, 1463,
  1494, 1525, 1556, 1586, 1615, 1643, 1670, 751,  782,  813,  844,  875,  906,
  937,  968,  999,  1030, 1061, 1092, 1123, 1154, 1185, 1216, 1247, 1278, 1309,
  1340, 1371, 1402, 1433, 1464, 1495, 1526, 1557, 1587, 1616, 1644, 1671, 1697,
  783,  814,  845,  876,  907,  938,  969,  1000, 1031, 1062, 1093, 1124, 1155,
  1186, 1217, 1248, 1279, 1310, 1341, 1372, 1403, 1434, 1465, 1496, 1527, 1558,
  1588, 1617, 1645, 1672, 1698, 1723, 815,  846,  877,  908,  939,  970,  1001,
  1032, 1063, 1094, 1125, 1156, 1187, 1218, 1249, 1280, 1311, 1342, 1373, 1404,
  1435, 1466, 1497, 1528, 1559, 1589, 1618, 1646, 1673, 1699, 1724, 1748, 847,
  878,  909,  940,  971,  1002, 1033, 1064, 1095, 1126, 1157, 1188, 1219, 1250,
  1281, 1312, 1343, 1374, 1405, 1436, 1467, 1498, 1529, 1560, 1590, 1619, 1647,
  1674, 1700, 1725, 1749, 1772, 879,  910,  941,  972,  1003, 1034, 1065, 1096,
  1127, 1158, 1189, 1220, 1251, 1282, 1313, 1344, 1375, 1406, 1437, 1468, 1499,
  1530, 1561, 1591, 1620, 1648, 1675, 1701, 1726, 1750, 1773, 1795, 911,  942,
  973,  1004, 1035, 1066, 1097, 1128, 1159, 1190, 1221, 1252, 1283, 1314, 1345,
  1376, 1407, 1438, 1469, 1500, 1531, 1562, 1592, 1621, 1649, 1676, 1702, 1727,
  1751, 1774, 1796, 1817, 943,  974,  1005, 1036, 1067, 1098, 1129, 1160, 1191,
  1222, 1253, 1284, 1315, 1346, 1377, 1408, 1439, 1470, 1501, 1532, 1563, 1593,
  1622, 1650, 1677, 1703, 1728, 1752, 1775, 1797, 1818, 1838, 975,  1006, 1037,
  1068, 1099, 1130, 1161, 1192, 1223, 1254, 1285, 1316, 1347, 1378, 1409, 1440,
  1471, 1502, 1533, 1564, 1594, 1623, 1651, 1678, 1704, 1729, 1753, 1776, 1798,
  1819, 1839, 1858, 1007, 1038, 1069, 1100, 1131, 1162, 1193, 1224, 1255, 1286,
  1317, 1348, 1379, 1410, 1441, 1472, 1503, 1534, 1565, 1595, 1624, 1652, 1679,
  1705, 1730, 1754, 1777, 1799, 1820, 1840, 1859, 1877, 1039, 1070, 1101, 1132,
  1163, 1194, 1225, 1256, 1287, 1318, 1349, 1380, 1411, 1442, 1473, 1504, 1535,
  1566, 1596, 1625, 1653, 1680, 1706, 1731, 1755, 1778, 1800, 1821, 1841, 1860,
  1878, 1895, 1071, 1102, 1133, 1164, 1195, 1226, 1257, 1288, 1319, 1350, 1381,
  1412, 1443, 1474, 1505, 1536, 1567, 1597, 1626, 1654, 1681, 1707, 1732, 1756,
  1779, 1801, 1822, 1842, 1861, 1879, 1896, 1912, 1103, 1134, 1165, 1196, 1227,
  1258, 1289, 1320, 1351, 1382, 1413, 1444, 1475, 1506, 1537, 1568, 1598, 1627,
  1655, 1682, 1708, 1733, 1757, 1780, 1802, 1823, 1843, 1862, 1880, 1897, 1913,
  1928, 1135, 1166, 1197, 1228, 1259, 1290, 1321, 1352, 1383, 1414, 1445, 1476,
  1507, 1538, 1569, 1599, 1628, 1656, 1683, 1709, 1734, 1758, 1781, 1803, 1824,
  1844, 1863, 1881, 1898, 1914, 1929, 1943, 1167, 1198, 1229, 1260, 1291, 1322,
  1353, 1384, 1415, 1446, 1477, 1508, 1539, 1570, 1600, 1629, 1657, 1684, 1710,
  1735, 1759, 1782, 1804, 1825, 1845, 1864, 1882, 1899, 1915, 1930, 1944, 1957,
  1199, 1230, 1261, 1292, 1323, 1354, 1385, 1416, 1447, 1478, 1509, 1540, 1571,
  1601, 1630, 1658, 1685, 1711, 1736, 1760, 1783, 1805, 1826, 1846, 1865, 1883,
  1900, 1916, 1931, 1945, 1958, 1970, 1231, 1262, 1293, 1324, 1355, 1386, 1417,
  1448, 1479, 1510, 1541, 1572, 1602, 1631, 1659, 1686, 1712, 1737, 1761, 1784,
  1806, 1827, 1847, 1866, 1884, 1901, 1917, 1932, 1946, 1959, 1971, 1982, 1263,
  1294, 1325, 1356, 1387, 1418, 1449, 1480, 1511, 1542, 1573, 1603, 1632, 1660,
  1687, 1713, 1738, 1762, 1785, 1807, 1828, 1848, 1867, 1885, 1902, 1918, 1933,
  1947, 1960, 1972, 1983, 1993, 1295, 1326, 1357, 1388, 1419, 1450, 1481, 1512,
  1543, 1574, 1604, 1633, 1661, 1688, 1714, 1739, 1763, 1786, 1808, 1829, 1849,
  1868, 1886, 1903, 1919, 1934, 1948, 1961, 1973, 1984, 1994, 2003, 1327, 1358,
  1389, 1420, 1451, 1482, 1513, 1544, 1575, 1605, 1634, 1662, 1689, 1715, 1740,
  1764, 1787, 1809, 1830, 1850, 1869, 1887, 1904, 1920, 1935, 1949, 1962, 1974,
  1985, 1995, 2004, 2012, 1359, 1390, 1421, 1452, 1483, 1514, 1545, 1576, 1606,
  1635, 1663, 1690, 1716, 1741, 1765, 1788, 1810, 1831, 1851, 1870, 1888, 1905,
  1921, 1936, 1950, 1963, 1975, 1986, 1996, 2005, 2013, 2020, 1391, 1422, 1453,
  1484, 1515, 1546, 1577, 1607, 1636, 1664, 1691, 1717, 1742, 1766, 1789, 1811,
  1832, 1852, 1871, 1889, 1906, 1922, 1937, 1951, 1964, 1976, 1987, 1997, 2006,
  2014, 2021, 2027, 1423, 1454, 1485, 1516, 1547, 1578, 1608, 1637, 1665, 1692,
  1718, 1743, 1767, 1790, 1812, 1833, 1853, 1872, 1890, 1907, 1923, 1938, 1952,
  1965, 1977, 1988, 1998, 2007, 2015, 2022, 2028, 2033, 1455, 1486, 1517, 1548,
  1579, 1609, 1638, 1666, 1693, 1719, 1744, 1768, 1791, 1813, 1834, 1854, 1873,
  1891, 1908, 1924, 1939, 1953, 1966, 1978, 1989, 1999, 2008, 2016, 2023, 2029,
  2034, 2038, 1487, 1518, 1549, 1580, 1610, 1639, 1667, 1694, 1720, 1745, 1769,
  1792, 1814, 1835, 1855, 1874, 1892, 1909, 1925, 1940, 1954, 1967, 1979, 1990,
  2000, 2009, 2017, 2024, 2030, 2035, 2039, 2042, 1519, 1550, 1581, 1611, 1640,
  1668, 1695, 1721, 1746, 1770, 1793, 1815, 1836, 1856, 1875, 1893, 1910, 1926,
  1941, 1955, 1968, 1980, 1991, 2001, 2010, 2018, 2025, 2031, 2036, 2040, 2043,
  2045, 1551, 1582, 1612, 1641, 1669, 1696, 1722, 1747, 1771, 1794, 1816, 1837,
  1857, 1876, 1894, 1911, 1927, 1942, 1956, 1969, 1981, 1992, 2002, 2011, 2019,
  2026, 2032, 2037, 2041, 2044, 2046, 2047,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_64x32[2048]) = {
  0,    1,    3,    6,    10,   15,   21,   28,   36,   45,   55,   66,   78,
  91,   105,  120,  136,  153,  171,  190,  210,  231,  253,  276,  300,  325,
  351,  378,  406,  435,  465,  496,  528,  560,  592,  624,  656,  688,  720,
  752,  784,  816,  848,  880,  912,  944,  976,  1008, 1040, 1072, 1104, 1136,
  1168, 1200, 1232, 1264, 1296, 1328, 1360, 1392, 1424, 1456, 1488, 1520, 2,
  4,    7,    11,   16,   22,   29,   37,   46,   56,   67,   79,   92,   106,
  121,  137,  154,  172,  191,  211,  232,  254,  277,  301,  326,  352,  379,
  407,  436,  466,  497,  529,  561,  593,  625,  657,  689,  721,  753,  785,
  817,  849,  881,  913,  945,  977,  1009, 1041, 1073, 1105, 1137, 1169, 1201,
  1233, 1265, 1297, 1329, 1361, 1393, 1425, 1457, 1489, 1521, 1552, 5,    8,
  12,   17,   23,   30,   38,   47,   57,   68,   80,   93,   107,  122,  138,
  155,  173,  192,  212,  233,  255,  278,  302,  327,  353,  380,  408,  437,
  467,  498,  530,  562,  594,  626,  658,  690,  722,  754,  786,  818,  850,
  882,  914,  946,  978,  1010, 1042, 1074, 1106, 1138, 1170, 1202, 1234, 1266,
  1298, 1330, 1362, 1394, 1426, 1458, 1490, 1522, 1553, 1583, 9,    13,   18,
  24,   31,   39,   48,   58,   69,   81,   94,   108,  123,  139,  156,  174,
  193,  213,  234,  256,  279,  303,  328,  354,  381,  409,  438,  468,  499,
  531,  563,  595,  627,  659,  691,  723,  755,  787,  819,  851,  883,  915,
  947,  979,  1011, 1043, 1075, 1107, 1139, 1171, 1203, 1235, 1267, 1299, 1331,
  1363, 1395, 1427, 1459, 1491, 1523, 1554, 1584, 1613, 14,   19,   25,   32,
  40,   49,   59,   70,   82,   95,   109,  124,  140,  157,  175,  194,  214,
  235,  257,  280,  304,  329,  355,  382,  410,  439,  469,  500,  532,  564,
  596,  628,  660,  692,  724,  756,  788,  820,  852,  884,  916,  948,  980,
  1012, 1044, 1076, 1108, 1140, 1172, 1204, 1236, 1268, 1300, 1332, 1364, 1396,
  1428, 1460, 1492, 1524, 1555, 1585, 1614, 1642, 20,   26,   33,   41,   50,
  60,   71,   83,   96,   110,  125,  141,  158,  176,  195,  215,  236,  258,
  281,  305,  330,  356,  383,  411,  440,  470,  501,  533,  565,  597,  629,
  661,  693,  725,  757,  789,  821,  853,  885,  917,  949,  981,  1013, 1045,
  1077, 1109, 1141, 1173, 1205, 1237, 1269, 1301, 1333, 1365, 1397, 1429, 1461,
  1493, 1525, 1556, 1586, 1615, 1643, 1670, 27,   34,   42,   51,   61,   72,
  84,   97,   111,  126,  142,  159,  177,  196,  216,  237,  259,  282,  306,
  331,  357,  384,  412,  441,  471,  502,  534,  566,  598,  630,  662,  694,
  726,  758,  790,  822,  854,  886,  918,  950,  982,  1014, 1046, 1078, 1110,
  1142, 1174, 1206, 1238, 1270, 1302, 1334, 1366, 1398, 1430, 1462, 1494, 1526,
  1557, 1587, 1616, 1644, 1671, 1697, 35,   43,   52,   62,   73,   85,   98,
  112,  127,  143,  160,  178,  197,  217,  238,  260,  283,  307,  332,  358,
  385,  413,  442,  472,  503,  535,  567,  599,  631,  663,  695,  727,  759,
  791,  823,  855,  887,  919,  951,  983,  1015, 1047, 1079, 1111, 1143, 1175,
  1207, 1239, 1271, 1303, 1335, 1367, 1399, 1431, 1463, 1495, 1527, 1558, 1588,
  1617, 1645, 1672, 1698, 1723, 44,   53,   63,   74,   86,   99,   113,  128,
  144,  161,  179,  198,  218,  239,  261,  284,  308,  333,  359,  386,  414,
  443,  473,  504,  536,  568,  600,  632,  664,  696,  728,  760,  792,  824,
  856,  888,  920,  952,  984,  1016, 1048, 1080, 1112, 1144, 1176, 1208, 1240,
  1272, 1304, 1336, 1368, 1400, 1432, 1464, 1496, 1528, 1559, 1589, 1618, 1646,
  1673, 1699, 1724, 1748, 54,   64,   75,   87,   100,  114,  129,  145,  162,
  180,  199,  219,  240,  262,  285,  309,  334,  360,  387,  415,  444,  474,
  505,  537,  569,  601,  633,  665,  697,  729,  761,  793,  825,  857,  889,
  921,  953,  985,  1017, 1049, 1081, 1113, 1145, 1177, 1209, 1241, 1273, 1305,
  1337, 1369, 1401, 1433, 1465, 1497, 1529, 1560, 1590, 1619, 1647, 1674, 1700,
  1725, 1749, 1772, 65,   76,   88,   101,  115,  130,  146,  163,  181,  200,
  220,  241,  263,  286,  310,  335,  361,  388,  416,  445,  475,  506,  538,
  570,  602,  634,  666,  698,  730,  762,  794,  826,  858,  890,  922,  954,
  986,  1018, 1050, 1082, 1114, 1146, 1178, 1210, 1242, 1274, 1306, 1338, 1370,
  1402, 1434, 1466, 1498, 1530, 1561, 1591, 1620, 1648, 1675, 1701, 1726, 1750,
  1773, 1795, 77,   89,   102,  116,  131,  147,  164,  182,  201,  221,  242,
  264,  287,  311,  336,  362,  389,  417,  446,  476,  507,  539,  571,  603,
  635,  667,  699,  731,  763,  795,  827,  859,  891,  923,  955,  987,  1019,
  1051, 1083, 1115, 1147, 1179, 1211, 1243, 1275, 1307, 1339, 1371, 1403, 1435,
  1467, 1499, 1531, 1562, 1592, 1621, 1649, 1676, 1702, 1727, 1751, 1774, 1796,
  1817, 90,   103,  117,  132,  148,  165,  183,  202,  222,  243,  265,  288,
  312,  337,  363,  390,  418,  447,  477,  508,  540,  572,  604,  636,  668,
  700,  732,  764,  796,  828,  860,  892,  924,  956,  988,  1020, 1052, 1084,
  1116, 1148, 1180, 1212, 1244, 1276, 1308, 1340, 1372, 1404, 1436, 1468, 1500,
  1532, 1563, 1593, 1622, 1650, 1677, 1703, 1728, 1752, 1775, 1797, 1818, 1838,
  104,  118,  133,  149,  166,  184,  203,  223,  244,  266,  289,  313,  338,
  364,  391,  419,  448,  478,  509,  541,  573,  605,  637,  669,  701,  733,
  765,  797,  829,  861,  893,  925,  957,  989,  1021, 1053, 1085, 1117, 1149,
  1181, 1213, 1245, 1277, 1309, 1341, 1373, 1405, 1437, 1469, 1501, 1533, 1564,
  1594, 1623, 1651, 1678, 1704, 1729, 1753, 1776, 1798, 1819, 1839, 1858, 119,
  134,  150,  167,  185,  204,  224,  245,  267,  290,  314,  339,  365,  392,
  420,  449,  479,  510,  542,  574,  606,  638,  670,  702,  734,  766,  798,
  830,  862,  894,  926,  958,  990,  1022, 1054, 1086, 1118, 1150, 1182, 1214,
  1246, 1278, 1310, 1342, 1374, 1406, 1438, 1470, 1502, 1534, 1565, 1595, 1624,
  1652, 1679, 1705, 1730, 1754, 1777, 1799, 1820, 1840, 1859, 1877, 135,  151,
  168,  186,  205,  225,  246,  268,  291,  315,  340,  366,  393,  421,  450,
  480,  511,  543,  575,  607,  639,  671,  703,  735,  767,  799,  831,  863,
  895,  927,  959,  991,  1023, 1055, 1087, 1119, 1151, 1183, 1215, 1247, 1279,
  1311, 1343, 1375, 1407, 1439, 1471, 1503, 1535, 1566, 1596, 1625, 1653, 1680,
  1706, 1731, 1755, 1778, 1800, 1821, 1841, 1860, 1878, 1895, 152,  169,  187,
  206,  226,  247,  269,  292,  316,  341,  367,  394,  422,  451,  481,  512,
  544,  576,  608,  640,  672,  704,  736,  768,  800,  832,  864,  896,  928,
  960,  992,  1024, 1056, 1088, 1120, 1152, 1184, 1216, 1248, 1280, 1312, 1344,
  1376, 1408, 1440, 1472, 1504, 1536, 1567, 1597, 1626, 1654, 1681, 1707, 1732,
  1756, 1779, 1801, 1822, 1842, 1861, 1879, 1896, 1912, 170,  188,  207,  227,
  248,  270,  293,  317,  342,  368,  395,  423,  452,  482,  513,  545,  577,
  609,  641,  673,  705,  737,  769,  801,  833,  865,  897,  929,  961,  993,
  1025, 1057, 1089, 1121, 1153, 1185, 1217, 1249, 1281, 1313, 1345, 1377, 1409,
  1441, 1473, 1505, 1537, 1568, 1598, 1627, 1655, 1682, 1708, 1733, 1757, 1780,
  1802, 1823, 1843, 1862, 1880, 1897, 1913, 1928, 189,  208,  228,  249,  271,
  294,  318,  343,  369,  396,  424,  453,  483,  514,  546,  578,  610,  642,
  674,  706,  738,  770,  802,  834,  866,  898,  930,  962,  994,  1026, 1058,
  1090, 1122, 1154, 1186, 1218, 1250, 1282, 1314, 1346, 1378, 1410, 1442, 1474,
  1506, 1538, 1569, 1599, 1628, 1656, 1683, 1709, 1734, 1758, 1781, 1803, 1824,
  1844, 1863, 1881, 1898, 1914, 1929, 1943, 209,  229,  250,  272,  295,  319,
  344,  370,  397,  425,  454,  484,  515,  547,  579,  611,  643,  675,  707,
  739,  771,  803,  835,  867,  899,  931,  963,  995,  1027, 1059, 1091, 1123,
  1155, 1187, 1219, 1251, 1283, 1315, 1347, 1379, 1411, 1443, 1475, 1507, 1539,
  1570, 1600, 1629, 1657, 1684, 1710, 1735, 1759, 1782, 1804, 1825, 1845, 1864,
  1882, 1899, 1915, 1930, 1944, 1957, 230,  251,  273,  296,  320,  345,  371,
  398,  426,  455,  485,  516,  548,  580,  612,  644,  676,  708,  740,  772,
  804,  836,  868,  900,  932,  964,  996,  1028, 1060, 1092, 1124, 1156, 1188,
  1220, 1252, 1284, 1316, 1348, 1380, 1412, 1444, 1476, 1508, 1540, 1571, 1601,
  1630, 1658, 1685, 1711, 1736, 1760, 1783, 1805, 1826, 1846, 1865, 1883, 1900,
  1916, 1931, 1945, 1958, 1970, 252,  274,  297,  321,  346,  372,  399,  427,
  456,  486,  517,  549,  581,  613,  645,  677,  709,  741,  773,  805,  837,
  869,  901,  933,  965,  997,  1029, 1061, 1093, 1125, 1157, 1189, 1221, 1253,
  1285, 1317, 1349, 1381, 1413, 1445, 1477, 1509, 1541, 1572, 1602, 1631, 1659,
  1686, 1712, 1737, 1761, 1784, 1806, 1827, 1847, 1866, 1884, 1901, 1917, 1932,
  1946, 1959, 1971, 1982, 275,  298,  322,  347,  373,  400,  428,  457,  487,
  518,  550,  582,  614,  646,  678,  710,  742,  774,  806,  838,  870,  902,
  934,  966,  998,  1030, 1062, 1094, 1126, 1158, 1190, 1222, 1254, 1286, 1318,
  1350, 1382, 1414, 1446, 1478, 1510, 1542, 1573, 1603, 1632, 1660, 1687, 1713,
  1738, 1762, 1785, 1807, 1828, 1848, 1867, 1885, 1902, 1918, 1933, 1947, 1960,
  1972, 1983, 1993, 299,  323,  348,  374,  401,  429,  458,  488,  519,  551,
  583,  615,  647,  679,  711,  743,  775,  807,  839,  871,  903,  935,  967,
  999,  1031, 1063, 1095, 1127, 1159, 1191, 1223, 1255, 1287, 1319, 1351, 1383,
  1415, 1447, 1479, 1511, 1543, 1574, 1604, 1633, 1661, 1688, 1714, 1739, 1763,
  1786, 1808, 1829, 1849, 1868, 1886, 1903, 1919, 1934, 1948, 1961, 1973, 1984,
  1994, 2003, 324,  349,  375,  402,  430,  459,  489,  520,  552,  584,  616,
  648,  680,  712,  744,  776,  808,  840,  872,  904,  936,  968,  1000, 1032,
  1064, 1096, 1128, 1160, 1192, 1224, 1256, 1288, 1320, 1352, 1384, 1416, 1448,
  1480, 1512, 1544, 1575, 1605, 1634, 1662, 1689, 1715, 1740, 1764, 1787, 1809,
  1830, 1850, 1869, 1887, 1904, 1920, 1935, 1949, 1962, 1974, 1985, 1995, 2004,
  2012, 350,  376,  403,  431,  460,  490,  521,  553,  585,  617,  649,  681,
  713,  745,  777,  809,  841,  873,  905,  937,  969,  1001, 1033, 1065, 1097,
  1129, 1161, 1193, 1225, 1257, 1289, 1321, 1353, 1385, 1417, 1449, 1481, 1513,
  1545, 1576, 1606, 1635, 1663, 1690, 1716, 1741, 1765, 1788, 1810, 1831, 1851,
  1870, 1888, 1905, 1921, 1936, 1950, 1963, 1975, 1986, 1996, 2005, 2013, 2020,
  377,  404,  432,  461,  491,  522,  554,  586,  618,  650,  682,  714,  746,
  778,  810,  842,  874,  906,  938,  970,  1002, 1034, 1066, 1098, 1130, 1162,
  1194, 1226, 1258, 1290, 1322, 1354, 1386, 1418, 1450, 1482, 1514, 1546, 1577,
  1607, 1636, 1664, 1691, 1717, 1742, 1766, 1789, 1811, 1832, 1852, 1871, 1889,
  1906, 1922, 1937, 1951, 1964, 1976, 1987, 1997, 2006, 2014, 2021, 2027, 405,
  433,  462,  492,  523,  555,  587,  619,  651,  683,  715,  747,  779,  811,
  843,  875,  907,  939,  971,  1003, 1035, 1067, 1099, 1131, 1163, 1195, 1227,
  1259, 1291, 1323, 1355, 1387, 1419, 1451, 1483, 1515, 1547, 1578, 1608, 1637,
  1665, 1692, 1718, 1743, 1767, 1790, 1812, 1833, 1853, 1872, 1890, 1907, 1923,
  1938, 1952, 1965, 1977, 1988, 1998, 2007, 2015, 2022, 2028, 2033, 434,  463,
  493,  524,  556,  588,  620,  652,  684,  716,  748,  780,  812,  844,  876,
  908,  940,  972,  1004, 1036, 1068, 1100, 1132, 1164, 1196, 1228, 1260, 1292,
  1324, 1356, 1388, 1420, 1452, 1484, 1516, 1548, 1579, 1609, 1638, 1666, 1693,
  1719, 1744, 1768, 1791, 1813, 1834, 1854, 1873, 1891, 1908, 1924, 1939, 1953,
  1966, 1978, 1989, 1999, 2008, 2016, 2023, 2029, 2034, 2038, 464,  494,  525,
  557,  589,  621,  653,  685,  717,  749,  781,  813,  845,  877,  909,  941,
  973,  1005, 1037, 1069, 1101, 1133, 1165, 1197, 1229, 1261, 1293, 1325, 1357,
  1389, 1421, 1453, 1485, 1517, 1549, 1580, 1610, 1639, 1667, 1694, 1720, 1745,
  1769, 1792, 1814, 1835, 1855, 1874, 1892, 1909, 1925, 1940, 1954, 1967, 1979,
  1990, 2000, 2009, 2017, 2024, 2030, 2035, 2039, 2042, 495,  526,  558,  590,
  622,  654,  686,  718,  750,  782,  814,  846,  878,  910,  942,  974,  1006,
  1038, 1070, 1102, 1134, 1166, 1198, 1230, 1262, 1294, 1326, 1358, 1390, 1422,
  1454, 1486, 1518, 1550, 1581, 1611, 1640, 1668, 1695, 1721, 1746, 1770, 1793,
  1815, 1836, 1856, 1875, 1893, 1910, 1926, 1941, 1955, 1968, 1980, 1991, 2001,
  2010, 2018, 2025, 2031, 2036, 2040, 2043, 2045, 527,  559,  591,  623,  655,
  687,  719,  751,  783,  815,  847,  879,  911,  943,  975,  1007, 1039, 1071,
  1103, 1135, 1167, 1199, 1231, 1263, 1295, 1327, 1359, 1391, 1423, 1455, 1487,
  1519, 1551, 1582, 1612, 1641, 1669, 1696, 1722, 1747, 1771, 1794, 1816, 1837,
  1857, 1876, 1894, 1911, 1927, 1942, 1956, 1969, 1981, 1992, 2002, 2011, 2019,
  2026, 2032, 2037, 2041, 2044, 2046, 2047,
};

DECLARE_ALIGNED(16, static const int16_t, av1_default_iscan_64x64[4096]) = {
  0,    1,    4,    9,    15,   22,   33,   43,   56,   71,   86,   104,  121,
  142,  166,  189,  214,  239,  269,  300,  331,  363,  400,  435,  471,  510,
  553,  598,  640,  683,  732,  780,  833,  884,  937,  995,  1048, 1107, 1165,
  1230, 1293, 1353, 1422, 1489, 1562, 1632, 1701, 1776, 1850, 1929, 2006, 2091,
  2173, 2252, 2339, 2421, 2516, 2603, 2694, 2786, 2879, 2978, 3076, 3175, 2,
  3,    6,    11,   17,   26,   35,   45,   58,   73,   90,   106,  123,  146,
  168,  193,  216,  243,  271,  302,  335,  365,  402,  437,  473,  516,  557,
  600,  642,  687,  736,  782,  835,  886,  941,  999,  1050, 1111, 1167, 1234,
  1297, 1357, 1424, 1491, 1564, 1636, 1703, 1778, 1852, 1931, 2012, 2095, 2177,
  2256, 2341, 2425, 2518, 2605, 2698, 2788, 2883, 2982, 3078, 3177, 5,    7,
  8,    13,   20,   28,   37,   50,   62,   75,   92,   108,  129,  150,  170,
  195,  218,  249,  277,  304,  337,  369,  406,  441,  478,  520,  559,  604,
  646,  689,  740,  788,  841,  890,  945,  1001, 1052, 1115, 1173, 1236, 1301,
  1362, 1428, 1497, 1568, 1638, 1707, 1786, 1858, 1935, 2016, 2097, 2181, 2260,
  2343, 2431, 2520, 2613, 2702, 2790, 2889, 2984, 3082, 3181, 10,   12,   14,
  19,   23,   31,   41,   52,   65,   81,   96,   113,  133,  152,  175,  201,
  224,  253,  279,  310,  341,  375,  410,  445,  484,  524,  563,  606,  648,
  697,  746,  793,  843,  896,  949,  1005, 1060, 1119, 1181, 1242, 1303, 1366,
  1436, 1503, 1572, 1640, 1713, 1790, 1865, 1943, 2018, 2103, 2183, 2266, 2347,
  2437, 2526, 2617, 2708, 2800, 2893, 2992, 3086, 3189, 16,   18,   21,   24,
  30,   39,   48,   59,   69,   83,   100,  119,  137,  158,  181,  203,  230,
  255,  286,  316,  347,  380,  414,  451,  490,  530,  571,  612,  656,  705,
  750,  799,  849,  898,  959,  1009, 1066, 1127, 1184, 1246, 1307, 1376, 1440,
  1509, 1578, 1644, 1723, 1794, 1871, 1947, 2024, 2109, 2185, 2270, 2361, 2443,
  2536, 2619, 2710, 2806, 2899, 2998, 3090, 3193, 25,   27,   29,   32,   40,
  46,   54,   67,   79,   94,   109,  127,  143,  164,  185,  210,  236,  263,
  292,  320,  353,  388,  422,  459,  496,  533,  579,  618,  665,  711,  754,
  809,  857,  910,  961,  1015, 1074, 1131, 1194, 1254, 1315, 1384, 1448, 1517,
  1584, 1655, 1731, 1802, 1875, 1959, 2034, 2115, 2197, 2280, 2367, 2452, 2538,
  2625, 2722, 2816, 2907, 3004, 3100, 3203, 34,   36,   38,   42,   49,   55,
  64,   76,   87,   102,  117,  135,  154,  176,  197,  222,  247,  272,  298,
  329,  361,  392,  427,  465,  504,  545,  585,  626,  671,  717,  766,  813,
  862,  916,  971,  1028, 1084, 1139, 1200, 1264, 1325, 1390, 1452, 1523, 1594,
  1667, 1737, 1806, 1887, 1963, 2046, 2123, 2202, 2290, 2371, 2462, 2548, 2641,
  2732, 2822, 2917, 3010, 3111, 3211, 44,   47,   51,   53,   60,   68,   77,
  85,   98,   114,  131,  147,  162,  183,  208,  232,  256,  283,  314,  343,
  373,  408,  442,  475,  511,  551,  592,  638,  681,  726,  772,  821,  874,
  926,  979,  1034, 1088, 1153, 1214, 1271, 1335, 1396, 1469, 1533, 1600, 1673,
  1745, 1824, 1897, 1973, 2054, 2131, 2216, 2300, 2383, 2468, 2558, 2649, 2740,
  2829, 2923, 3022, 3123, 3221, 57,   61,   63,   66,   70,   80,   88,   99,
  112,  124,  140,  159,  179,  199,  219,  240,  267,  294,  322,  354,  386,
  418,  455,  492,  528,  567,  608,  649,  695,  742,  786,  836,  882,  933,
  989,  1046, 1101, 1161, 1216, 1279, 1343, 1410, 1479, 1543, 1614, 1687, 1758,
  1832, 1905, 1980, 2066, 2141, 2226, 2306, 2395, 2484, 2566, 2659, 2750, 2845,
  2939, 3032, 3133, 3225, 72,   74,   78,   82,   84,   95,   103,  115,  125,
  139,  156,  173,  190,  211,  234,  259,  281,  311,  339,  366,  394,  433,
  466,  500,  543,  581,  622,  667,  707,  752,  803,  853,  899,  955,  1007,
  1064, 1117, 1175, 1237, 1299, 1354, 1420, 1485, 1556, 1624, 1697, 1770, 1842,
  1919, 1998, 2074, 2155, 2234, 2319, 2409, 2492, 2581, 2671, 2760, 2859, 2949,
  3046, 3145, 3245, 89,   91,   93,   97,   101,  110,  118,  132,  141,  157,
  171,  186,  206,  228,  251,  273,  296,  324,  351,  384,  415,  447,  482,
  521,  554,  593,  636,  677,  722,  770,  815,  866,  914,  967,  1022, 1078,
  1135, 1195, 1252, 1313, 1378, 1444, 1507, 1576, 1642, 1714, 1788, 1860, 1933,
  2013, 2085, 2169, 2250, 2337, 2417, 2502, 2597, 2683, 2778, 2869, 2960, 3060,
  3157, 3256, 105,  107,  111,  116,  120,  128,  136,  148,  160,  174,  187,
  205,  225,  244,  265,  290,  317,  344,  370,  398,  431,  463,  498,  534,
  573,  616,  654,  698,  743,  783,  831,  880,  928,  983,  1036, 1092, 1149,
  1208, 1266, 1333, 1394, 1457, 1524, 1590, 1665, 1733, 1804, 1879, 1953, 2030,
  2111, 2189, 2271, 2357, 2441, 2534, 2615, 2704, 2791, 2887, 2979, 3072, 3167,
  3270, 122,  126,  130,  134,  138,  144,  155,  163,  180,  191,  207,  226,
  238,  261,  287,  308,  332,  359,  390,  419,  449,  485,  518,  549,  587,
  630,  672,  715,  760,  805,  855,  900,  953,  1003, 1053, 1108, 1163, 1220,
  1287, 1345, 1408, 1473, 1541, 1608, 1677, 1749, 1826, 1898, 1971, 2048, 2127,
  2208, 2294, 2373, 2458, 2542, 2631, 2726, 2818, 2908, 3002, 3094, 3199, 3286,
  145,  149,  151,  153,  161,  165,  177,  184,  200,  212,  229,  245,  262,
  284,  305,  327,  355,  382,  411,  438,  469,  501,  539,  577,  613,  652,
  690,  730,  776,  822,  872,  922,  973,  1024, 1079, 1132, 1188, 1250, 1305,
  1367, 1432, 1492, 1560, 1626, 1693, 1766, 1838, 1911, 1992, 2068, 2149, 2228,
  2307, 2393, 2478, 2564, 2655, 2742, 2833, 2927, 3020, 3119, 3219, 3298, 167,
  169,  172,  178,  182,  188,  198,  209,  220,  235,  252,  266,  288,  306,
  326,  349,  378,  403,  428,  461,  494,  526,  560,  594,  632,  675,  713,
  755,  801,  845,  892,  942,  990,  1042, 1096, 1155, 1212, 1267, 1329, 1391,
  1450, 1519, 1582, 1650, 1724, 1792, 1862, 1936, 2007, 2083, 2167, 2246, 2329,
  2413, 2496, 2585, 2675, 2761, 2855, 2947, 3040, 3135, 3233, 3320, 192,  194,
  196,  202,  204,  213,  223,  233,  241,  260,  274,  291,  309,  328,  350,
  376,  395,  425,  457,  488,  512,  547,  583,  619,  659,  699,  737,  778,
  819,  868,  917,  965,  1013, 1072, 1123, 1176, 1231, 1289, 1351, 1414, 1474,
  1539, 1604, 1674, 1741, 1816, 1891, 1961, 2040, 2116, 2191, 2276, 2353, 2438,
  2524, 2606, 2689, 2784, 2871, 2968, 3062, 3161, 3257, 3334, 215,  217,  221,
  227,  231,  237,  248,  257,  268,  282,  297,  318,  333,  356,  379,  396,
  424,  452,  479,  508,  541,  574,  609,  643,  679,  719,  764,  806,  850,
  894,  938,  987,  1038, 1089, 1145, 1204, 1258, 1316, 1379, 1438, 1501, 1565,
  1628, 1694, 1764, 1836, 1907, 1981, 2060, 2137, 2220, 2298, 2377, 2464, 2549,
  2635, 2724, 2812, 2903, 2999, 3088, 3185, 3278, 3350, 242,  246,  250,  254,
  258,  264,  275,  285,  295,  312,  325,  345,  360,  383,  404,  426,  453,
  476,  506,  535,  568,  601,  634,  669,  708,  748,  789,  829,  875,  923,
  968,  1016, 1068, 1120, 1168, 1224, 1280, 1341, 1402, 1465, 1531, 1591, 1661,
  1729, 1795, 1867, 1937, 2004, 2079, 2159, 2242, 2320, 2405, 2488, 2573, 2661,
  2744, 2839, 2933, 3023, 3117, 3215, 3296, 3373, 270,  276,  278,  280,  289,
  293,  299,  315,  323,  340,  352,  371,  391,  412,  429,  458,  480,  507,
  532,  564,  590,  627,  663,  703,  733,  773,  816,  859,  906,  950,  993,
  1043, 1094, 1147, 1201, 1256, 1311, 1372, 1429, 1486, 1550, 1618, 1685, 1751,
  1827, 1895, 1965, 2042, 2119, 2192, 2268, 2348, 2429, 2512, 2599, 2684, 2772,
  2863, 2951, 3048, 3143, 3239, 3324, 3393, 301,  303,  307,  313,  319,  321,
  330,  346,  357,  367,  385,  399,  420,  439,  462,  489,  509,  536,  565,
  589,  624,  661,  691,  727,  768,  810,  846,  887,  929,  977,  1029, 1076,
  1128, 1177, 1226, 1283, 1339, 1397, 1461, 1521, 1585, 1648, 1715, 1779, 1848,
  1923, 1996, 2069, 2142, 2224, 2302, 2381, 2465, 2544, 2627, 2720, 2807, 2895,
  2985, 3073, 3163, 3264, 3338, 3413, 334,  336,  338,  342,  348,  358,  362,
  374,  387,  397,  416,  432,  450,  470,  495,  513,  542,  569,  591,  625,
  657,  684,  723,  762,  797,  837,  878,  920,  963,  1010, 1054, 1105, 1157,
  1206, 1262, 1317, 1374, 1433, 1483, 1545, 1615, 1681, 1743, 1812, 1885, 1954,
  2025, 2101, 2174, 2248, 2330, 2411, 2490, 2579, 2663, 2745, 2835, 2924, 3018,
  3115, 3205, 3290, 3363, 3431, 364,  368,  372,  377,  381,  389,  393,  409,
  421,  434,  448,  464,  486,  502,  527,  548,  575,  602,  628,  662,  685,
  721,  756,  794,  827,  869,  912,  956,  996,  1040, 1086, 1137, 1189, 1243,
  1291, 1349, 1404, 1466, 1525, 1588, 1645, 1711, 1774, 1843, 1909, 1988, 2058,
  2132, 2209, 2288, 2368, 2445, 2527, 2607, 2687, 2780, 2865, 2953, 3049, 3139,
  3237, 3318, 3387, 3451, 401,  405,  407,  413,  417,  423,  430,  443,  456,
  467,  483,  499,  519,  540,  561,  584,  610,  635,  664,  692,  724,  757,
  792,  825,  863,  908,  946,  985,  1032, 1080, 1125, 1169, 1217, 1275, 1330,
  1386, 1441, 1498, 1554, 1619, 1683, 1746, 1810, 1883, 1949, 2019, 2086, 2165,
  2238, 2314, 2399, 2479, 2562, 2645, 2733, 2820, 2904, 2996, 3083, 3168, 3268,
  3339, 3407, 3474, 436,  440,  444,  446,  454,  460,  468,  477,  493,  503,
  522,  537,  550,  578,  595,  620,  644,  670,  704,  728,  763,  795,  826,
  861,  901,  935,  980,  1025, 1069, 1112, 1159, 1209, 1260, 1309, 1363, 1418,
  1475, 1534, 1598, 1656, 1721, 1780, 1846, 1912, 1982, 2056, 2129, 2199, 2278,
  2358, 2432, 2508, 2593, 2677, 2762, 2851, 2941, 3030, 3124, 3216, 3294, 3365,
  3433, 3488, 472,  474,  481,  487,  491,  497,  505,  514,  529,  544,  555,
  576,  588,  614,  633,  660,  680,  709,  734,  769,  798,  828,  864,  902,
  932,  975,  1020, 1061, 1102, 1150, 1198, 1247, 1294, 1346, 1400, 1455, 1513,
  1573, 1629, 1689, 1755, 1820, 1888, 1955, 2022, 2092, 2163, 2235, 2312, 2389,
  2472, 2554, 2632, 2716, 2804, 2884, 2974, 3063, 3153, 3250, 3326, 3395, 3454,
  3512, 515,  517,  523,  525,  531,  538,  546,  552,  570,  582,  596,  617,
  631,  653,  676,  700,  720,  749,  774,  811,  838,  870,  909,  936,  976,
  1017, 1058, 1099, 1143, 1192, 1238, 1284, 1336, 1388, 1445, 1493, 1546, 1610,
  1671, 1734, 1796, 1856, 1925, 1994, 2062, 2133, 2206, 2281, 2354, 2426, 2503,
  2587, 2669, 2754, 2843, 2928, 3016, 3105, 3201, 3284, 3351, 3421, 3480, 3534,
  556,  558,  562,  566,  572,  580,  586,  597,  611,  623,  637,  655,  673,
  693,  714,  738,  765,  790,  817,  847,  879,  913,  947,  981,  1021, 1059,
  1097, 1140, 1185, 1227, 1277, 1327, 1380, 1425, 1481, 1537, 1595, 1651, 1708,
  1771, 1834, 1901, 1966, 2035, 2107, 2170, 2244, 2315, 2396, 2474, 2552, 2628,
  2711, 2792, 2875, 2966, 3056, 3146, 3234, 3314, 3383, 3445, 3504, 3559, 599,
  603,  605,  607,  615,  621,  629,  639,  650,  668,  678,  701,  716,  731,
  758,  779,  807,  830,  860,  888,  921,  957,  986,  1026, 1062, 1100, 1141,
  1183, 1221, 1272, 1323, 1368, 1416, 1471, 1526, 1580, 1633, 1691, 1752, 1817,
  1876, 1944, 2002, 2072, 2143, 2218, 2291, 2363, 2435, 2509, 2589, 2672, 2752,
  2840, 2921, 3008, 3095, 3190, 3274, 3344, 3409, 3470, 3526, 3577, 641,  645,
  647,  651,  658,  666,  674,  682,  696,  710,  725,  744,  761,  777,  802,
  820,  851,  876,  907,  930,  964,  997,  1033, 1070, 1103, 1144, 1186, 1222,
  1270, 1318, 1360, 1411, 1463, 1515, 1569, 1622, 1678, 1739, 1800, 1853, 1917,
  1983, 2052, 2121, 2186, 2253, 2331, 2406, 2482, 2559, 2639, 2717, 2798, 2877,
  2961, 3052, 3137, 3226, 3306, 3379, 3437, 3492, 3553, 3601, 686,  688,  694,
  702,  706,  712,  718,  729,  745,  753,  771,  784,  808,  823,  848,  871,
  895,  924,  951,  978,  1011, 1041, 1081, 1113, 1151, 1193, 1228, 1273, 1319,
  1358, 1406, 1458, 1510, 1557, 1612, 1669, 1727, 1781, 1839, 1903, 1969, 2031,
  2098, 2160, 2232, 2304, 2375, 2453, 2528, 2601, 2679, 2758, 2846, 2929, 3011,
  3098, 3186, 3271, 3340, 3401, 3466, 3522, 3571, 3620, 735,  739,  741,  747,
  751,  759,  767,  775,  787,  804,  818,  832,  856,  873,  893,  918,  939,
  969,  994,  1030, 1055, 1087, 1126, 1160, 1199, 1239, 1278, 1324, 1361, 1407,
  1453, 1505, 1551, 1605, 1663, 1716, 1768, 1830, 1893, 1951, 2008, 2075, 2139,
  2214, 2284, 2349, 2418, 2494, 2571, 2653, 2734, 2810, 2890, 2972, 3058, 3147,
  3231, 3310, 3375, 3435, 3490, 3545, 3595, 3642, 781,  785,  791,  796,  800,
  812,  814,  824,  839,  854,  867,  881,  903,  925,  943,  966,  988,  1018,
  1044, 1077, 1106, 1138, 1170, 1210, 1248, 1285, 1328, 1369, 1412, 1459, 1506,
  1549, 1601, 1657, 1704, 1762, 1821, 1880, 1938, 1999, 2063, 2125, 2193, 2257,
  2327, 2401, 2475, 2545, 2620, 2691, 2776, 2860, 2942, 3024, 3109, 3197, 3276,
  3345, 3403, 3468, 3520, 3569, 3616, 3664, 834,  840,  842,  844,  852,  858,
  865,  877,  883,  904,  915,  931,  954,  974,  991,  1014, 1039, 1071, 1095,
  1129, 1158, 1190, 1218, 1261, 1295, 1337, 1381, 1417, 1464, 1511, 1552, 1602,
  1654, 1699, 1759, 1813, 1872, 1927, 1990, 2049, 2113, 2178, 2239, 2308, 2378,
  2450, 2521, 2594, 2667, 2746, 2824, 2909, 2990, 3070, 3154, 3243, 3316, 3381,
  3441, 3493, 3547, 3597, 3640, 3682, 885,  889,  891,  897,  905,  911,  919,
  927,  934,  958,  970,  984,  1004, 1027, 1045, 1073, 1090, 1121, 1148, 1178,
  1207, 1244, 1276, 1310, 1347, 1389, 1426, 1472, 1516, 1558, 1606, 1658, 1700,
  1757, 1807, 1868, 1920, 1978, 2043, 2104, 2157, 2229, 2296, 2364, 2422, 2498,
  2574, 2650, 2727, 2801, 2872, 2954, 3038, 3129, 3212, 3288, 3352, 3419, 3475,
  3524, 3573, 3621, 3668, 3707, 940,  944,  948,  952,  960,  962,  972,  982,
  992,  1008, 1023, 1037, 1056, 1082, 1098, 1124, 1146, 1171, 1202, 1229, 1263,
  1292, 1331, 1364, 1401, 1446, 1482, 1527, 1570, 1613, 1664, 1705, 1760, 1808,
  1863, 1915, 1976, 2036, 2087, 2153, 2221, 2286, 2344, 2414, 2486, 2556, 2623,
  2699, 2773, 2853, 2937, 3012, 3091, 3169, 3260, 3330, 3391, 3447, 3505, 3555,
  3603, 3646, 3684, 3727, 998,  1000, 1002, 1006, 1012, 1019, 1031, 1035, 1047,
  1065, 1083, 1093, 1109, 1133, 1156, 1179, 1205, 1225, 1257, 1286, 1320, 1350,
  1387, 1419, 1456, 1494, 1538, 1581, 1623, 1670, 1717, 1763, 1814, 1869, 1916,
  1974, 2028, 2081, 2150, 2212, 2272, 2335, 2403, 2469, 2539, 2608, 2680, 2755,
  2827, 2915, 2986, 3068, 3151, 3229, 3300, 3366, 3427, 3484, 3532, 3581, 3630,
  3672, 3709, 3745, 1049, 1051, 1057, 1063, 1067, 1075, 1085, 1091, 1104, 1118,
  1136, 1152, 1164, 1191, 1213, 1232, 1259, 1281, 1312, 1340, 1375, 1405, 1442,
  1476, 1514, 1547, 1596, 1634, 1679, 1728, 1769, 1822, 1873, 1921, 1977, 2029,
  2078, 2144, 2203, 2264, 2325, 2390, 2459, 2529, 2591, 2665, 2738, 2813, 2880,
  2957, 3041, 3127, 3206, 3282, 3348, 3399, 3460, 3513, 3565, 3609, 3650, 3695,
  3733, 3768, 1110, 1114, 1116, 1122, 1130, 1134, 1142, 1154, 1162, 1180, 1196,
  1211, 1223, 1251, 1268, 1290, 1321, 1342, 1373, 1398, 1434, 1467, 1499, 1535,
  1574, 1611, 1652, 1692, 1740, 1782, 1831, 1881, 1928, 1979, 2037, 2082, 2145,
  2200, 2261, 2321, 2387, 2454, 2513, 2583, 2656, 2730, 2793, 2867, 2945, 3025,
  3101, 3178, 3262, 3328, 3388, 3443, 3494, 3543, 3591, 3636, 3678, 3715, 3754,
  3790, 1166, 1172, 1174, 1182, 1187, 1197, 1203, 1215, 1219, 1240, 1253, 1269,
  1288, 1306, 1332, 1352, 1382, 1403, 1430, 1462, 1484, 1528, 1555, 1599, 1630,
  1672, 1709, 1753, 1801, 1840, 1894, 1939, 1991, 2044, 2088, 2151, 2204, 2262,
  2318, 2384, 2448, 2504, 2577, 2646, 2712, 2782, 2856, 2934, 3006, 3079, 3158,
  3240, 3307, 3371, 3425, 3481, 3530, 3575, 3618, 3660, 3701, 3741, 3774, 3807,
  1233, 1235, 1241, 1245, 1249, 1255, 1265, 1274, 1282, 1300, 1314, 1334, 1348,
  1370, 1392, 1415, 1439, 1468, 1487, 1522, 1548, 1589, 1620, 1659, 1690, 1735,
  1772, 1818, 1854, 1904, 1952, 2000, 2050, 2105, 2154, 2213, 2265, 2322, 2385,
  2446, 2500, 2569, 2642, 2705, 2770, 2849, 2919, 2993, 3064, 3140, 3223, 3292,
  3353, 3414, 3464, 3516, 3561, 3607, 3648, 3687, 3725, 3762, 3796, 3827, 1296,
  1298, 1302, 1304, 1308, 1322, 1326, 1338, 1344, 1355, 1383, 1395, 1409, 1435,
  1451, 1477, 1502, 1532, 1553, 1586, 1616, 1646, 1684, 1722, 1756, 1797, 1835,
  1877, 1918, 1970, 2009, 2064, 2114, 2158, 2222, 2273, 2326, 2388, 2449, 2501,
  2567, 2636, 2695, 2768, 2836, 2910, 2976, 3053, 3131, 3209, 3279, 3336, 3397,
  3449, 3500, 3549, 3593, 3634, 3676, 3713, 3747, 3784, 3817, 3845, 1356, 1359,
  1365, 1371, 1377, 1385, 1393, 1399, 1413, 1421, 1447, 1460, 1478, 1495, 1520,
  1540, 1566, 1592, 1621, 1649, 1682, 1712, 1747, 1783, 1823, 1857, 1902, 1945,
  1984, 2032, 2076, 2126, 2179, 2230, 2287, 2336, 2391, 2455, 2505, 2570, 2637,
  2692, 2763, 2830, 2901, 2969, 3044, 3120, 3194, 3265, 3331, 3385, 3439, 3486,
  3536, 3582, 3626, 3665, 3703, 3739, 3772, 3802, 3835, 3864, 1423, 1427, 1431,
  1437, 1443, 1449, 1454, 1470, 1480, 1488, 1508, 1529, 1542, 1561, 1583, 1607,
  1631, 1662, 1686, 1718, 1744, 1775, 1811, 1847, 1889, 1926, 1967, 2003, 2053,
  2099, 2140, 2194, 2240, 2297, 2345, 2404, 2460, 2514, 2578, 2643, 2696, 2764,
  2826, 2897, 2962, 3036, 3112, 3182, 3254, 3321, 3376, 3429, 3478, 3527, 3567,
  3611, 3652, 3693, 3731, 3764, 3794, 3825, 3853, 3882, 1490, 1496, 1500, 1504,
  1512, 1518, 1530, 1536, 1544, 1559, 1577, 1593, 1609, 1627, 1653, 1675, 1695,
  1730, 1754, 1784, 1815, 1844, 1884, 1913, 1956, 1995, 2038, 2073, 2122, 2161,
  2215, 2258, 2309, 2365, 2415, 2470, 2530, 2584, 2647, 2706, 2769, 2831, 2898,
  2959, 3033, 3106, 3170, 3252, 3312, 3367, 3423, 3471, 3518, 3563, 3605, 3644,
  3680, 3717, 3755, 3788, 3819, 3847, 3874, 3898, 1563, 1567, 1571, 1575, 1579,
  1587, 1597, 1603, 1617, 1625, 1643, 1666, 1680, 1696, 1725, 1742, 1765, 1798,
  1828, 1849, 1886, 1910, 1950, 1985, 2023, 2065, 2108, 2146, 2187, 2233, 2285,
  2328, 2379, 2423, 2487, 2540, 2592, 2657, 2713, 2771, 2837, 2902, 2963, 3034,
  3104, 3164, 3248, 3304, 3361, 3417, 3462, 3510, 3557, 3598, 3638, 3674, 3711,
  3743, 3776, 3811, 3839, 3868, 3892, 3917, 1635, 1637, 1639, 1641, 1647, 1660,
  1668, 1676, 1688, 1698, 1719, 1736, 1750, 1767, 1793, 1819, 1837, 1870, 1896,
  1924, 1957, 1989, 2020, 2057, 2093, 2134, 2171, 2219, 2254, 2305, 2350, 2402,
  2451, 2499, 2557, 2609, 2666, 2731, 2783, 2850, 2911, 2970, 3037, 3107, 3165,
  3246, 3301, 3359, 3410, 3458, 3508, 3551, 3589, 3632, 3670, 3705, 3737, 3770,
  3800, 3829, 3858, 3886, 3911, 3933, 1702, 1706, 1710, 1720, 1726, 1732, 1738,
  1748, 1761, 1773, 1789, 1805, 1829, 1841, 1864, 1892, 1908, 1940, 1968, 1997,
  2026, 2059, 2089, 2130, 2164, 2207, 2245, 2292, 2332, 2376, 2419, 2476, 2522,
  2575, 2624, 2681, 2739, 2794, 2857, 2920, 2977, 3045, 3113, 3171, 3249, 3302,
  3358, 3404, 3455, 3502, 3541, 3587, 3628, 3661, 3699, 3735, 3766, 3797, 3823,
  3851, 3876, 3903, 3927, 3950, 1777, 1785, 1787, 1791, 1799, 1803, 1809, 1825,
  1833, 1845, 1861, 1882, 1899, 1914, 1941, 1962, 1986, 2005, 2045, 2070, 2102,
  2135, 2166, 2201, 2236, 2282, 2316, 2366, 2407, 2456, 2495, 2546, 2595, 2651,
  2700, 2756, 2814, 2868, 2935, 2994, 3054, 3121, 3183, 3253, 3305, 3360, 3405,
  3453, 3498, 3539, 3585, 3622, 3658, 3697, 3728, 3760, 3792, 3821, 3849, 3872,
  3896, 3919, 3942, 3964, 1851, 1855, 1859, 1866, 1874, 1878, 1890, 1900, 1906,
  1922, 1934, 1958, 1972, 1993, 2010, 2041, 2061, 2080, 2120, 2147, 2175, 2210,
  2241, 2279, 2313, 2355, 2397, 2436, 2483, 2531, 2572, 2621, 2668, 2728, 2774,
  2828, 2881, 2946, 3007, 3065, 3132, 3195, 3255, 3313, 3362, 3411, 3456, 3499,
  3538, 3579, 3614, 3656, 3691, 3723, 3758, 3786, 3815, 3843, 3870, 3894, 3915,
  3937, 3956, 3975, 1930, 1932, 1942, 1946, 1948, 1960, 1964, 1975, 1987, 2001,
  2014, 2033, 2051, 2071, 2084, 2117, 2138, 2162, 2195, 2225, 2249, 2289, 2317,
  2359, 2392, 2427, 2477, 2510, 2560, 2602, 2654, 2693, 2747, 2802, 2854, 2916,
  2958, 3026, 3080, 3141, 3210, 3266, 3322, 3368, 3418, 3459, 3503, 3540, 3580,
  3613, 3654, 3688, 3721, 3752, 3782, 3813, 3841, 3865, 3890, 3913, 3935, 3954,
  3972, 3989, 2011, 2015, 2017, 2021, 2027, 2039, 2047, 2055, 2067, 2077, 2090,
  2112, 2128, 2152, 2168, 2196, 2223, 2243, 2269, 2303, 2333, 2369, 2400, 2433,
  2473, 2506, 2553, 2590, 2640, 2682, 2735, 2777, 2825, 2873, 2938, 2987, 3042,
  3102, 3159, 3224, 3280, 3332, 3377, 3424, 3463, 3509, 3542, 3586, 3615, 3655,
  3685, 3719, 3750, 3780, 3809, 3836, 3862, 3888, 3909, 3931, 3952, 3970, 3987,
  4003, 2094, 2096, 2100, 2106, 2110, 2118, 2124, 2136, 2148, 2156, 2172, 2190,
  2211, 2231, 2247, 2277, 2299, 2323, 2351, 2382, 2412, 2447, 2480, 2511, 2555,
  2588, 2629, 2673, 2718, 2759, 2811, 2861, 2912, 2955, 3013, 3069, 3128, 3179,
  3241, 3293, 3337, 3386, 3430, 3472, 3511, 3552, 3588, 3623, 3657, 3689, 3720,
  3749, 3778, 3805, 3833, 3860, 3884, 3907, 3929, 3948, 3968, 3985, 4001, 4016,
  2176, 2180, 2182, 2184, 2188, 2198, 2205, 2217, 2227, 2237, 2251, 2274, 2295,
  2310, 2334, 2356, 2380, 2408, 2430, 2466, 2491, 2532, 2563, 2596, 2633, 2670,
  2714, 2753, 2799, 2847, 2891, 2943, 2991, 3039, 3092, 3152, 3207, 3263, 3308,
  3354, 3398, 3440, 3479, 3519, 3558, 3590, 3629, 3659, 3692, 3722, 3751, 3779,
  3804, 3831, 3856, 3880, 3905, 3925, 3946, 3966, 3983, 3999, 4014, 4028, 2255,
  2259, 2263, 2267, 2275, 2283, 2293, 2301, 2311, 2324, 2338, 2360, 2374, 2394,
  2416, 2439, 2467, 2489, 2515, 2547, 2580, 2610, 2648, 2678, 2719, 2757, 2795,
  2841, 2878, 2930, 2973, 3027, 3071, 3130, 3172, 3230, 3283, 3329, 3372, 3415,
  3450, 3487, 3528, 3564, 3599, 3633, 3662, 3698, 3724, 3753, 3781, 3806, 3832,
  3855, 3878, 3901, 3923, 3944, 3962, 3981, 3997, 4012, 4026, 4039, 2340, 2342,
  2346, 2352, 2362, 2370, 2372, 2386, 2398, 2410, 2420, 2442, 2461, 2481, 2497,
  2525, 2550, 2576, 2600, 2630, 2664, 2688, 2736, 2765, 2805, 2844, 2876, 2922,
  2964, 3014, 3059, 3110, 3155, 3213, 3261, 3303, 3349, 3389, 3426, 3465, 3501,
  3537, 3568, 3606, 3639, 3671, 3700, 3729, 3759, 3783, 3810, 3834, 3857, 3879,
  3900, 3921, 3940, 3960, 3979, 3995, 4010, 4024, 4037, 4049, 2424, 2428, 2434,
  2440, 2444, 2457, 2463, 2471, 2485, 2493, 2507, 2535, 2543, 2565, 2586, 2611,
  2638, 2662, 2685, 2721, 2748, 2781, 2821, 2852, 2885, 2931, 2967, 3009, 3055,
  3099, 3148, 3198, 3244, 3289, 3333, 3369, 3400, 3444, 3482, 3517, 3550, 3583,
  3612, 3645, 3675, 3706, 3736, 3761, 3787, 3814, 3837, 3861, 3881, 3902, 3922,
  3939, 3958, 3977, 3993, 4008, 4022, 4035, 4047, 4058, 2517, 2519, 2523, 2533,
  2537, 2541, 2551, 2561, 2568, 2582, 2598, 2616, 2634, 2658, 2676, 2690, 2725,
  2749, 2775, 2808, 2838, 2866, 2905, 2944, 2975, 3017, 3057, 3096, 3138, 3187,
  3232, 3277, 3317, 3355, 3392, 3428, 3461, 3495, 3531, 3562, 3594, 3627, 3653,
  3681, 3712, 3738, 3767, 3793, 3816, 3842, 3863, 3885, 3906, 3924, 3941, 3959,
  3974, 3991, 4006, 4020, 4033, 4045, 4056, 4066, 2604, 2612, 2614, 2618, 2622,
  2626, 2644, 2652, 2660, 2674, 2686, 2707, 2729, 2743, 2766, 2785, 2815, 2842,
  2864, 2896, 2925, 2956, 2997, 3031, 3066, 3108, 3149, 3191, 3227, 3272, 3311,
  3346, 3382, 3420, 3448, 3485, 3514, 3544, 3576, 3608, 3635, 3666, 3694, 3718,
  3744, 3771, 3798, 3822, 3844, 3866, 3889, 3908, 3926, 3945, 3961, 3978, 3992,
  4005, 4018, 4031, 4043, 4054, 4064, 4073, 2697, 2701, 2703, 2709, 2715, 2723,
  2737, 2741, 2751, 2767, 2779, 2796, 2819, 2834, 2858, 2874, 2906, 2936, 2952,
  2988, 3019, 3050, 3084, 3125, 3156, 3202, 3235, 3275, 3309, 3341, 3378, 3406,
  3442, 3476, 3506, 3533, 3566, 3592, 3619, 3649, 3677, 3704, 3732, 3756, 3777,
  3801, 3824, 3850, 3871, 3891, 3910, 3930, 3947, 3963, 3980, 3994, 4007, 4019,
  4030, 4041, 4052, 4062, 4071, 4079, 2787, 2789, 2797, 2803, 2809, 2817, 2823,
  2832, 2848, 2862, 2870, 2888, 2913, 2932, 2948, 2971, 3000, 3028, 3051, 3074,
  3116, 3142, 3173, 3217, 3251, 3285, 3315, 3347, 3380, 3402, 3436, 3469, 3496,
  3525, 3556, 3584, 3610, 3637, 3663, 3690, 3714, 3740, 3765, 3789, 3812, 3830,
  3852, 3873, 3895, 3914, 3932, 3949, 3967, 3982, 3996, 4009, 4021, 4032, 4042,
  4051, 4060, 4069, 4077, 4084, 2882, 2886, 2892, 2894, 2900, 2914, 2918, 2926,
  2940, 2950, 2965, 2980, 3003, 3021, 3043, 3067, 3089, 3118, 3144, 3166, 3208,
  3238, 3269, 3295, 3327, 3356, 3384, 3412, 3438, 3467, 3491, 3521, 3548, 3574,
  3604, 3631, 3651, 3679, 3702, 3726, 3748, 3773, 3795, 3820, 3840, 3859, 3877,
  3897, 3916, 3936, 3953, 3969, 3984, 3998, 4011, 4023, 4034, 4044, 4053, 4061,
  4068, 4075, 4082, 4088, 2981, 2983, 2989, 2995, 3001, 3005, 3015, 3029, 3035,
  3047, 3061, 3075, 3097, 3122, 3136, 3162, 3188, 3218, 3242, 3267, 3291, 3319,
  3342, 3370, 3396, 3422, 3446, 3473, 3497, 3523, 3546, 3570, 3600, 3624, 3647,
  3673, 3696, 3716, 3742, 3763, 3785, 3803, 3826, 3848, 3869, 3887, 3904, 3920,
  3938, 3955, 3971, 3986, 4000, 4013, 4025, 4036, 4046, 4055, 4063, 4070, 4076,
  4081, 4086, 4091, 3077, 3081, 3085, 3087, 3093, 3103, 3114, 3126, 3134, 3150,
  3160, 3174, 3200, 3220, 3236, 3258, 3281, 3297, 3325, 3343, 3364, 3390, 3408,
  3434, 3457, 3483, 3507, 3529, 3554, 3572, 3596, 3617, 3641, 3669, 3686, 3710,
  3734, 3757, 3775, 3799, 3818, 3838, 3854, 3875, 3893, 3912, 3928, 3943, 3957,
  3973, 3988, 4002, 4015, 4027, 4038, 4048, 4057, 4065, 4072, 4078, 4083, 4087,
  4090, 4093, 3176, 3180, 3184, 3192, 3196, 3204, 3214, 3222, 3228, 3247, 3259,
  3273, 3287, 3299, 3323, 3335, 3357, 3374, 3394, 3416, 3432, 3452, 3477, 3489,
  3515, 3535, 3560, 3578, 3602, 3625, 3643, 3667, 3683, 3708, 3730, 3746, 3769,
  3791, 3808, 3828, 3846, 3867, 3883, 3899, 3918, 3934, 3951, 3965, 3976, 3990,
  4004, 4017, 4029, 4040, 4050, 4059, 4067, 4074, 4080, 4085, 4089, 4092, 4094,
  4095,
};
#endif  // CONFIG_TX64X64

const SCAN_ORDER av1_default_scan_orders[TX_SIZES] = {
#if CONFIG_CHROMA_2X2
  { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
#endif
  { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
  { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
  { default_scan_16x16, av1_default_iscan_16x16, default_scan_16x16_neighbors },
  { default_scan_32x32, av1_default_iscan_32x32, default_scan_32x32_neighbors },
#if CONFIG_TX64X64
  { default_scan_64x64, av1_default_iscan_64x64, default_scan_64x64_neighbors },
#endif  // CONFIG_TX64X64
};

const SCAN_ORDER av1_intra_scan_orders[TX_SIZES_ALL][TX_TYPES] = {
#if CONFIG_CHROMA_2X2
  {
      // TX_2X2
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
#endif
  {
      // TX_4X4
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
      { row_scan_4x4, av1_row_iscan_4x4, row_scan_4x4_neighbors },
      { col_scan_4x4, av1_col_iscan_4x4, col_scan_4x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X8
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { row_scan_8x8, av1_row_iscan_8x8, row_scan_8x8_neighbors },
      { col_scan_8x8, av1_col_iscan_8x8, col_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { row_scan_8x8, av1_row_iscan_8x8, row_scan_8x8_neighbors },
      { col_scan_8x8, av1_col_iscan_8x8, col_scan_8x8_neighbors },
      { row_scan_8x8, av1_row_iscan_8x8, row_scan_8x8_neighbors },
      { col_scan_8x8, av1_col_iscan_8x8, col_scan_8x8_neighbors },
      { row_scan_8x8, av1_row_iscan_8x8, row_scan_8x8_neighbors },
      { col_scan_8x8, av1_col_iscan_8x8, col_scan_8x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X16
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { row_scan_16x16, av1_row_iscan_16x16, row_scan_16x16_neighbors },
      { col_scan_16x16, av1_col_iscan_16x16, col_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { row_scan_16x16, av1_row_iscan_16x16, row_scan_16x16_neighbors },
      { col_scan_16x16, av1_col_iscan_16x16, col_scan_16x16_neighbors },
      { row_scan_16x16, av1_row_iscan_16x16, row_scan_16x16_neighbors },
      { col_scan_16x16, av1_col_iscan_16x16, col_scan_16x16_neighbors },
      { row_scan_16x16, av1_row_iscan_16x16, row_scan_16x16_neighbors },
      { col_scan_16x16, av1_col_iscan_16x16, col_scan_16x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_32X32
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { h2_scan_32x32, av1_h2_iscan_32x32, h2_scan_32x32_neighbors },
      { v2_scan_32x32, av1_v2_iscan_32x32, v2_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
#if CONFIG_EXT_TX
      { h2_scan_32x32, av1_h2_iscan_32x32, h2_scan_32x32_neighbors },
      { v2_scan_32x32, av1_v2_iscan_32x32, v2_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
#if CONFIG_TX64X64
  {
      // TX_64X64
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
#if CONFIG_EXT_TX
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
#endif  // CONFIG_EXT_TX
  },
#endif  // CONFIG_TX64X64
  {
      // TX_4X8
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X4
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X16
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X8
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X32
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_32X16
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
#if CONFIG_TX64X64
  {
      // TX_32X64
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
#if CONFIG_EXT_TX
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_64X32
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
#if CONFIG_EXT_TX
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
#endif  // CONFIG_EXT_TX
  }
#endif  // CONFIG_TX64X64
};

const SCAN_ORDER av1_inter_scan_orders[TX_SIZES_ALL][TX_TYPES] = {
#if CONFIG_CHROMA_2X2
  {
      // TX_2X2
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
      { default_scan_2x2, av1_default_iscan_2x2, default_scan_2x2_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
#endif
  {
      // TX_4X4
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { default_scan_4x4, av1_default_iscan_4x4, default_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
      { mrow_scan_4x4, av1_mrow_iscan_4x4, mrow_scan_4x4_neighbors },
      { mcol_scan_4x4, av1_mcol_iscan_4x4, mcol_scan_4x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X8
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { default_scan_8x8, av1_default_iscan_8x8, default_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
      { mrow_scan_8x8, av1_mrow_iscan_8x8, mrow_scan_8x8_neighbors },
      { mcol_scan_8x8, av1_mcol_iscan_8x8, mcol_scan_8x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X16
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { default_scan_16x16, av1_default_iscan_16x16,
        default_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
      { mrow_scan_16x16, av1_mrow_iscan_16x16, mrow_scan_16x16_neighbors },
      { mcol_scan_16x16, av1_mcol_iscan_16x16, mcol_scan_16x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_32X32
      { default_scan_32x32, av1_default_iscan_32x32,
        default_scan_32x32_neighbors },
      { h2_scan_32x32, av1_h2_iscan_32x32, h2_scan_32x32_neighbors },
      { v2_scan_32x32, av1_v2_iscan_32x32, v2_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
#if CONFIG_EXT_TX
      { h2_scan_32x32, av1_h2_iscan_32x32, h2_scan_32x32_neighbors },
      { v2_scan_32x32, av1_v2_iscan_32x32, v2_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { qtr_scan_32x32, av1_qtr_iscan_32x32, qtr_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
      { mrow_scan_32x32, av1_mrow_iscan_32x32, mrow_scan_32x32_neighbors },
      { mcol_scan_32x32, av1_mcol_iscan_32x32, mcol_scan_32x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
#if CONFIG_TX64X64
  {
      // TX_64X64
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
#if CONFIG_EXT_TX
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
      { default_scan_64x64, av1_default_iscan_64x64,
        default_scan_64x64_neighbors },
#endif  // CONFIG_EXT_TX
  },
#endif  // CONFIG_TX64X64
  {
      // TX_4X8
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { default_scan_4x8, av1_default_iscan_4x8, default_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
      { mrow_scan_4x8, av1_mrow_iscan_4x8, mrow_scan_4x8_neighbors },
      { mcol_scan_4x8, av1_mcol_iscan_4x8, mcol_scan_4x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X4
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { default_scan_8x4, av1_default_iscan_8x4, default_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
      { mrow_scan_8x4, av1_mrow_iscan_8x4, mrow_scan_8x4_neighbors },
      { mcol_scan_8x4, av1_mcol_iscan_8x4, mcol_scan_8x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X16
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { default_scan_8x16, av1_default_iscan_8x16,
        default_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
      { mrow_scan_8x16, av1_mrow_iscan_8x16, mrow_scan_8x16_neighbors },
      { mcol_scan_8x16, av1_mcol_iscan_8x16, mcol_scan_8x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X8
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { default_scan_16x8, av1_default_iscan_16x8,
        default_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
      { mrow_scan_16x8, av1_mrow_iscan_16x8, mrow_scan_16x8_neighbors },
      { mcol_scan_16x8, av1_mcol_iscan_16x8, mcol_scan_16x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X32
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { default_scan_16x32, av1_default_iscan_16x32,
        default_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
      { mrow_scan_16x32, av1_mrow_iscan_16x32, mrow_scan_16x32_neighbors },
      { mcol_scan_16x32, av1_mcol_iscan_16x32, mcol_scan_16x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_32X16
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { default_scan_32x16, av1_default_iscan_32x16,
        default_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
      { mrow_scan_32x16, av1_mrow_iscan_32x16, mrow_scan_32x16_neighbors },
      { mcol_scan_32x16, av1_mcol_iscan_32x16, mcol_scan_32x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
#if CONFIG_TX64X64
  {
      // TX_32X64
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
#if CONFIG_EXT_TX
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
      { default_scan_32x64, av1_default_iscan_32x64,
        default_scan_32x64_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_64X32
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
#if CONFIG_EXT_TX
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
      { default_scan_64x32, av1_default_iscan_64x32,
        default_scan_64x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
#endif  // CONFIG_TX64X64
  {
      // TX_4X16
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
#if CONFIG_EXT_TX
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { default_scan_4x16, av1_default_iscan_4x16,
        default_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
      { mrow_scan_4x16, av1_mrow_iscan_4x16, mrow_scan_4x16_neighbors },
      { mcol_scan_4x16, av1_mcol_iscan_4x16, mcol_scan_4x16_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_16X4
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
#if CONFIG_EXT_TX
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { default_scan_16x4, av1_default_iscan_16x4,
        default_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
      { mrow_scan_16x4, av1_mrow_iscan_16x4, mrow_scan_16x4_neighbors },
      { mcol_scan_16x4, av1_mcol_iscan_16x4, mcol_scan_16x4_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_8X32
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
#if CONFIG_EXT_TX
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { default_scan_8x32, av1_default_iscan_8x32,
        default_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
      { mrow_scan_8x32, av1_mrow_iscan_8x32, mrow_scan_8x32_neighbors },
      { mcol_scan_8x32, av1_mcol_iscan_8x32, mcol_scan_8x32_neighbors },
#endif  // CONFIG_EXT_TX
  },
  {
      // TX_32X8
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
#if CONFIG_EXT_TX
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { default_scan_32x8, av1_default_iscan_32x8,
        default_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
      { mrow_scan_32x8, av1_mrow_iscan_32x8, mrow_scan_32x8_neighbors },
      { mcol_scan_32x8, av1_mcol_iscan_32x8, mcol_scan_32x8_neighbors },
#endif  // CONFIG_EXT_TX
  },
};

#if CONFIG_ADAPT_SCAN
// TX_32X32 will has 1024 coefficients whose indexes can be represented in 10
// bits
#define COEFF_IDX_BITS (10 + CONFIG_TX64X64)
#define COEFF_IDX_SIZE (1 << COEFF_IDX_BITS)
#define COEFF_IDX_MASK (COEFF_IDX_SIZE - 1)

static uint32_t *get_non_zero_prob(FRAME_CONTEXT *fc, TX_SIZE tx_size,
                                   TX_TYPE tx_type) {
  switch (tx_size) {
#if CONFIG_CHROMA_2X2
    case TX_2X2: return fc->non_zero_prob_2x2[tx_type];
#endif
    case TX_4X4: return fc->non_zero_prob_4X4[tx_type];
    case TX_8X8: return fc->non_zero_prob_8X8[tx_type];
    case TX_16X16: return fc->non_zero_prob_16X16[tx_type];
    case TX_32X32: return fc->non_zero_prob_32X32[tx_type];
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    case TX_4X8: return fc->non_zero_prob_4X8[tx_type];
    case TX_8X4: return fc->non_zero_prob_8X4[tx_type];
    case TX_8X16: return fc->non_zero_prob_8X16[tx_type];
    case TX_16X8: return fc->non_zero_prob_16X8[tx_type];
    case TX_16X32: return fc->non_zero_prob_16X32[tx_type];
    case TX_32X16: return fc->non_zero_prob_32X16[tx_type];
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    default: assert(0); return NULL;
  }
}

static int16_t *get_adapt_scan(FRAME_CONTEXT *fc, TX_SIZE tx_size,
                               TX_TYPE tx_type) {
  switch (tx_size) {
#if CONFIG_CHROMA_2X2
    case TX_2X2: return fc->scan_2x2[tx_type];
#endif
    case TX_4X4: return fc->scan_4X4[tx_type];
    case TX_8X8: return fc->scan_8X8[tx_type];
    case TX_16X16: return fc->scan_16X16[tx_type];
    case TX_32X32: return fc->scan_32X32[tx_type];
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    case TX_4X8: return fc->scan_4X8[tx_type];
    case TX_8X4: return fc->scan_8X4[tx_type];
    case TX_8X16: return fc->scan_8X16[tx_type];
    case TX_16X8: return fc->scan_16X8[tx_type];
    case TX_16X32: return fc->scan_16X32[tx_type];
    case TX_32X16: return fc->scan_32X16[tx_type];
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    default: assert(0); return NULL;
  }
}

static int16_t *get_adapt_iscan(FRAME_CONTEXT *fc, TX_SIZE tx_size,
                                TX_TYPE tx_type) {
  switch (tx_size) {
#if CONFIG_CHROMA_2X2
    case TX_2X2: return fc->iscan_2x2[tx_type];
#endif
    case TX_4X4: return fc->iscan_4X4[tx_type];
    case TX_8X8: return fc->iscan_8X8[tx_type];
    case TX_16X16: return fc->iscan_16X16[tx_type];
    case TX_32X32: return fc->iscan_32X32[tx_type];
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    case TX_4X8: return fc->iscan_4X8[tx_type];
    case TX_8X4: return fc->iscan_8X4[tx_type];
    case TX_8X16: return fc->iscan_8X16[tx_type];
    case TX_16X8: return fc->iscan_16X8[tx_type];
    case TX_16X32: return fc->iscan_16X32[tx_type];
    case TX_32X16: return fc->iscan_32X16[tx_type];
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    default: assert(0); return NULL;
  }
}

static int16_t *get_adapt_nb(FRAME_CONTEXT *fc, TX_SIZE tx_size,
                             TX_TYPE tx_type) {
  switch (tx_size) {
#if CONFIG_CHROMA_2X2
    case TX_2X2: return fc->nb_2x2[tx_type];
#endif
    case TX_4X4: return fc->nb_4X4[tx_type];
    case TX_8X8: return fc->nb_8X8[tx_type];
    case TX_16X16: return fc->nb_16X16[tx_type];
    case TX_32X32: return fc->nb_32X32[tx_type];
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    case TX_4X8: return fc->nb_4X8[tx_type];
    case TX_8X4: return fc->nb_8X4[tx_type];
    case TX_8X16: return fc->nb_8X16[tx_type];
    case TX_16X8: return fc->nb_16X8[tx_type];
    case TX_16X32: return fc->nb_16X32[tx_type];
    case TX_32X16: return fc->nb_32X16[tx_type];
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    default: assert(0); return NULL;
  }
}

static uint32_t *get_non_zero_counts(FRAME_COUNTS *counts, TX_SIZE tx_size,
                                     TX_TYPE tx_type) {
  switch (tx_size) {
#if CONFIG_CHROMA_2X2
    case TX_2X2: return counts->non_zero_count_2x2[tx_type];
#endif
    case TX_4X4: return counts->non_zero_count_4X4[tx_type];
    case TX_8X8: return counts->non_zero_count_8X8[tx_type];
    case TX_16X16: return counts->non_zero_count_16X16[tx_type];
    case TX_32X32: return counts->non_zero_count_32X32[tx_type];
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    case TX_4X8: return counts->non_zero_count_4x8[tx_type];
    case TX_8X4: return counts->non_zero_count_8x4[tx_type];
    case TX_8X16: return counts->non_zero_count_8x16[tx_type];
    case TX_16X8: return counts->non_zero_count_16x8[tx_type];
    case TX_16X32: return counts->non_zero_count_16x32[tx_type];
    case TX_32X16: return counts->non_zero_count_32x16[tx_type];
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    default: assert(0); return NULL;
  }
}

static INLINE int clamp_64(int64_t value, int low, int high) {
  return value < low ? low : (value > high ? high : (int)value);
}

#if USE_2X2_PROB
static int do_down_sample(TX_SIZE tx_size) {
  const int tx_w = tx_size_wide[tx_size];
  const int tx_h = tx_size_high[tx_size];
  if (tx_w > 8 || tx_h > 8) {
    return 1;
  } else {
    return 0;
  }
}

void av1_down_sample_scan_count(uint32_t *non_zero_count_ds,
                                const uint32_t *non_zero_count,
                                TX_SIZE tx_size) {
  const int tx_w = tx_size_wide[tx_size];
  const int tx_h = tx_size_high[tx_size];
  if (tx_w > 8 && tx_h > 8) {
    const int tx_w_ds = tx_w >> 1;
    const int tx_h_ds = tx_h >> 1;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds << 1;
        const int c = c_ds << 1;
        const int ci = r * tx_w + c;
        non_zero_count_ds[ci_ds] = non_zero_count[ci];
      }
    }
  } else if (tx_w > 8 && tx_h <= 8) {
    const int tx_w_ds = tx_w >> 1;
    const int tx_h_ds = tx_h;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds;
        const int c = c_ds << 1;
        const int ci = r * tx_w + c;
        non_zero_count_ds[ci_ds] = non_zero_count[ci];
      }
    }
  } else if (tx_w <= 8 && tx_h > 8) {
    const int tx_w_ds = tx_w;
    const int tx_h_ds = tx_h >> 1;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds << 1;
        const int c = c_ds;
        const int ci = r * tx_w + c;
        non_zero_count_ds[ci_ds] = non_zero_count[ci];
      }
    }
  } else {
    assert(0);
  }
}

void av1_up_sample_scan_count(uint32_t *non_zero_count,
                              const uint32_t *non_zero_count_ds,
                              TX_SIZE tx_size, unsigned int block_num) {
  const int tx_w = tx_size_wide[tx_size];
  const int tx_h = tx_size_high[tx_size];
  if (tx_w > 8 && tx_h > 8) {
    const int tx_w_ds = tx_w >> 1;
    const int tx_h_ds = tx_h >> 1;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds << 1;
        const int c = c_ds << 1;
        const int ci = r * tx_w + c;
        non_zero_count[ci] = non_zero_count_ds[ci_ds];
        if (c_ds + 1 < tx_w_ds) {
          uint32_t count =
              non_zero_count_ds[ci_ds] + non_zero_count_ds[ci_ds + 1];
          count = ROUND_POWER_OF_TWO(count, 1);
          count = clamp32u(count, 0, block_num);
          non_zero_count[ci + 1] = count;
        } else {
          non_zero_count[ci + 1] = non_zero_count_ds[ci_ds];
        }
      }
    }
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c = 0; c < tx_w; ++c) {
        const int r = r_ds << 1;
        const int ci = r * tx_w + c;
        if (r + 2 < tx_h) {
          uint32_t count = non_zero_count[ci] + non_zero_count[ci + 2 * tx_w];
          count = ROUND_POWER_OF_TWO(count, 1);
          count = clamp32u(count, 0, block_num);
          non_zero_count[ci + tx_w] = count;
        } else {
          non_zero_count[ci + tx_w] = non_zero_count[ci];
        }
      }
    }
  } else if (tx_w > 8 && tx_h <= 8) {
    const int tx_w_ds = tx_w >> 1;
    const int tx_h_ds = tx_h;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds;
        const int c = c_ds << 1;
        const int ci = r * tx_w + c;
        non_zero_count[ci] = non_zero_count_ds[ci_ds];
        if (c_ds + 1 < tx_w_ds) {
          uint32_t count =
              non_zero_count_ds[ci_ds] + non_zero_count_ds[ci_ds + 1];
          count = ROUND_POWER_OF_TWO(count, 1);
          count = clamp32u(count, 0, block_num);
          non_zero_count[ci + 1] = count;
        } else {
          non_zero_count[ci + 1] = non_zero_count_ds[ci_ds];
        }
      }
    }
  } else if (tx_w <= 8 && tx_h > 8) {
    const int tx_w_ds = tx_w;
    const int tx_h_ds = tx_h >> 1;
    for (int r_ds = 0; r_ds < tx_h_ds; ++r_ds) {
      for (int c_ds = 0; c_ds < tx_w_ds; ++c_ds) {
        const int ci_ds = r_ds * tx_w_ds + c_ds;
        const int r = r_ds << 1;
        const int c = c_ds;
        const int ci = r * tx_w + c;
        non_zero_count[ci] = non_zero_count_ds[ci_ds];
        if (r_ds + 1 < tx_h_ds) {
          uint32_t count =
              non_zero_count_ds[ci_ds] + non_zero_count_ds[ci_ds + tx_w_ds];
          count = ROUND_POWER_OF_TWO(count, 1);
          count = clamp32u(count, 0, block_num);
          non_zero_count[ci + tx_w] = count;
        } else {
          non_zero_count[ci + tx_w] = non_zero_count_ds[ci_ds];
        }
      }
    }
  } else {
    assert(0);
  }
}
#endif

static void update_scan_prob(AV1_COMMON *cm, TX_SIZE tx_size, TX_TYPE tx_type,
                             int rate) {
  FRAME_CONTEXT *pre_fc = cm->pre_fc;
  uint32_t *prev_non_zero_prob = get_non_zero_prob(pre_fc, tx_size, tx_type);
  uint32_t *non_zero_prob = get_non_zero_prob(cm->fc, tx_size, tx_type);
  uint32_t *non_zero_count = get_non_zero_counts(&cm->counts, tx_size, tx_type);
  const int tx2d_size = tx_size_2d[tx_size];
  unsigned int block_num = cm->counts.txb_count[tx_size][tx_type];
#if USE_2X2_PROB
#if CONFIG_TX64X64
  DECLARE_ALIGNED(16, uint32_t, non_zero_count_ds[1024]);
  assert((tx2d_size >> 2) <= 1024);
#else   // CONFIG_TX64X64
  DECLARE_ALIGNED(16, uint32_t, non_zero_count_ds[256]);
  assert((tx2d_size >> 2) <= 256);
#endif  // CONFIG_TX64X64
  if (do_down_sample(tx_size)) {
    av1_down_sample_scan_count(non_zero_count_ds, non_zero_count, tx_size);
    av1_up_sample_scan_count(non_zero_count, non_zero_count_ds, tx_size,
                             block_num);
  }
#endif
  int i;
  const int inv_precision = 30;
  int32_t inv_block_num = block_num == 0 ? 0 : (1 << inv_precision) / block_num;
  for (i = 0; i < tx2d_size; i++) {
    int64_t curr_prob =
        block_num == 0 ? 0 : ((non_zero_count[i] * inv_block_num) >>
                              (inv_precision - ADAPT_SCAN_PROB_PRECISION));
    int64_t prev_prob = prev_non_zero_prob[i];
    int64_t pred_prob =
        (curr_prob * rate +
         prev_prob * ((1 << ADAPT_SCAN_PROB_PRECISION) - rate)) >>
        ADAPT_SCAN_PROB_PRECISION;
    // TODO(angiebird): reduce the bit usage of probabilities and remove
    // clamp_64()
    non_zero_prob[i] =
        clamp_64(pred_prob, 0, (1 << ADAPT_SCAN_PROB_PRECISION) - 1);
  }
}

static void update_scan_count(int16_t *scan, int max_scan,
                              const tran_low_t *dqcoeffs,
                              uint32_t *non_zero_count) {
  int i;
  for (i = 0; i < max_scan; ++i) {
    int coeff_idx = scan[i];
    non_zero_count[coeff_idx] += (dqcoeffs[coeff_idx] != 0);
  }
}

void av1_update_scan_count_facade(AV1_COMMON *cm, FRAME_COUNTS *counts,
                                  TX_SIZE tx_size, TX_TYPE tx_type,
                                  const tran_low_t *dqcoeffs, int max_scan) {
  if (cm->use_adapt_scan && do_adapt_scan(tx_size, tx_type)) {
    int16_t *scan = get_adapt_scan(cm->fc, tx_size, tx_type);
    uint32_t *non_zero_count = get_non_zero_counts(counts, tx_size, tx_type);
    update_scan_count(scan, max_scan, dqcoeffs, non_zero_count);
    ++counts->txb_count[tx_size][tx_type];
  }
}

static int cmp_prob(const void *a, const void *b) {
  return *(const uint32_t *)b > *(const uint32_t *)a ? 1 : -1;
}

void av1_augment_prob(TX_SIZE tx_size, TX_TYPE tx_type, uint32_t *prob) {
  // TODO(angiebird): check if we need is_inter here
  const SCAN_ORDER *sc = get_default_scan(tx_size, tx_type, 0);
  const int tx1d_wide = tx_size_wide[tx_size];
  const int tx1d_high = tx_size_high[tx_size];
  int r, c;
  for (r = 0; r < tx1d_high; r++) {
    for (c = 0; c < tx1d_wide; c++) {
      const int idx = r * tx1d_wide + c;
      const uint32_t mask_16 = ((1 << 16) - 1);
      const uint32_t tie_breaker = ~((uint32_t)sc->iscan[idx]);
      // prob[idx]: 16 bits  dummy: 6 bits  scan_idx: 10 bits
      prob[idx] = (prob[idx] << 16) | (mask_16 & tie_breaker);
    }
  }
}

void av1_update_neighbors(TX_SIZE tx_size, const int16_t *scan,
                          const int16_t *iscan, int16_t *neighbors) {
  const int tx1d_wide = tx_size_wide[tx_size];
  const int tx1d_high = tx_size_high[tx_size];
  const int tx2d_size = tx_size_2d[tx_size];
  int scan_idx;
  for (scan_idx = 0; scan_idx < tx2d_size; ++scan_idx) {
    const int coeff_idx = scan[scan_idx];
    const int r = coeff_idx / tx1d_wide;
    const int c = coeff_idx % tx1d_wide;
    const int nb_offset_r[5] = { -1, 0, -1, -1, 1 };
    const int nb_offset_c[5] = { 0, -1, -1, 1, -1 };
    const int nb_num = 5;
    int nb_count = 0;
    int nb_idx;

    for (nb_idx = 0; nb_idx < nb_num; ++nb_idx) {
      if (nb_count < 2) {
        int nb_r = r + nb_offset_r[nb_idx];
        int nb_c = c + nb_offset_c[nb_idx];
        int nb_coeff_idx = nb_r * tx1d_wide + nb_c;
        int valid_pos =
            nb_r >= 0 && nb_r < tx1d_high && nb_c >= 0 && nb_c < tx1d_wide;
        if (valid_pos && iscan[nb_coeff_idx] < scan_idx) {
          neighbors[scan_idx * MAX_NEIGHBORS + nb_count] = nb_coeff_idx;
          ++nb_count;
        }
      } else {
        break;
      }
    }

    if (nb_count == 1) {
      neighbors[scan_idx * MAX_NEIGHBORS + 1] =
          neighbors[scan_idx * MAX_NEIGHBORS + 0];
    } else if (nb_count == 0) {
      neighbors[scan_idx * MAX_NEIGHBORS + 0] = scan[0];
      neighbors[scan_idx * MAX_NEIGHBORS + 1] = scan[0];
    }
  }
  neighbors[tx2d_size * MAX_NEIGHBORS + 0] = scan[0];
  neighbors[tx2d_size * MAX_NEIGHBORS + 1] = scan[0];
}

#if USE_LIMIT_SCAN_DISTANCE
typedef struct SCAN_NB_QUEUE {
  int nb_ci_queue[COEFF_IDX_SIZE + 1];
  int pr_si_queue[COEFF_IDX_SIZE + 1];
  int size;
  int start;
  int end;
} SCAN_NB_QUEUE;

static void assign_scan_idx(int16_t coeff_idx, int16_t *scan_idx, int tx_width,
                            int tx_height, int16_t *scan, int16_t *iscan,
                            int16_t *visit, SCAN_NB_QUEUE *queue) {
  if (visit[coeff_idx] != 2) {
    assert(*scan_idx < tx_width * tx_height);
    scan[*scan_idx] = coeff_idx;
    iscan[coeff_idx] = *scan_idx;
    visit[coeff_idx] = 2;
    int row = coeff_idx / tx_width;
    int col = coeff_idx % tx_width;
    int right_ci = coeff_idx + 1;
    if (col + 1 < tx_width && visit[right_ci] == 0) {
      visit[right_ci] = 1;
      queue->pr_si_queue[queue->end] = *scan_idx;
      queue->nb_ci_queue[queue->end] = right_ci;
      queue->end = (queue->end + 1) % queue->size;
    }
    int down_ci = coeff_idx + tx_width;
    if (row + 1 < tx_height && visit[down_ci] == 0) {
      visit[down_ci] = 1;
      queue->pr_si_queue[queue->end] = *scan_idx;
      queue->nb_ci_queue[queue->end] = down_ci;
      queue->end = (queue->end + 1) % queue->size;
    }
    ++(*scan_idx);
  }
}
static void limit_nb_scan_distance(TX_SIZE tx_size, int16_t *scan,
                                   int16_t *iscan) {
  const int tx2d_size = tx_size_2d[tx_size];
  int16_t visit[COEFF_IDX_SIZE] = { 0 };
  int16_t org_scan[COEFF_IDX_SIZE];
  memcpy(org_scan, scan, tx2d_size * sizeof(*scan));
  const int tx_width = tx_size_wide[tx_size];
  const int tx_height = tx_size_high[tx_size];
  const int limit = 2 * AOMMAX(tx_width, tx_height);
  SCAN_NB_QUEUE queue;
  queue.size = tx2d_size;
  queue.start = 0;
  queue.end = 0;
  int16_t new_si = 0;
  for (int16_t si = 0; si < tx2d_size; ++si) {
    while (queue.start != queue.end &&
           queue.pr_si_queue[queue.start] + limit <= new_si) {
      int nb_ci = queue.nb_ci_queue[queue.start];
      assign_scan_idx(nb_ci, &new_si, tx_width, tx_height, scan, iscan, visit,
                      &queue);
      queue.start = (queue.start + 1) % queue.size;
    }

    int16_t ci = org_scan[si];
    assign_scan_idx(ci, &new_si, tx_width, tx_height, scan, iscan, visit,
                    &queue);
  }
  assert(new_si == tx2d_size);
}
#endif  // USE_LIMIT_SCAN_DISTANCE

#if USE_TOPOLOGICAL_SORT
void av1_update_sort_order(TX_SIZE tx_size, TX_TYPE tx_type,
                           const uint32_t *non_zero_prob, int16_t *sort_order) {
  const SCAN_ORDER *sc = get_default_scan(tx_size, tx_type, 0);
  uint32_t temp[COEFF_IDX_SIZE];
  const int tx2d_size = tx_size_2d[tx_size];
  int sort_idx;
  assert(tx2d_size <= COEFF_IDX_SIZE);
  memcpy(temp, non_zero_prob, tx2d_size * sizeof(*non_zero_prob));
  av1_augment_prob(tx_size, tx_type, temp);
  qsort(temp, tx2d_size, sizeof(*temp), cmp_prob);
  for (sort_idx = 0; sort_idx < tx2d_size; ++sort_idx) {
    const int default_scan_idx =
        (temp[sort_idx] & COEFF_IDX_MASK) ^ COEFF_IDX_MASK;
    const int coeff_idx = sc->scan[default_scan_idx];
    sort_order[sort_idx] = coeff_idx;
  }
}

// topological sort
static void dfs_scan(int tx1d_size, int *scan_idx, int coeff_idx, int16_t *scan,
                     int16_t *iscan) {
  const int r = coeff_idx / tx1d_size;
  const int c = coeff_idx % tx1d_size;

  if (iscan[coeff_idx] != -1) return;

  if (r > 0) dfs_scan(tx1d_size, scan_idx, coeff_idx - tx1d_size, scan, iscan);

  if (c > 0) dfs_scan(tx1d_size, scan_idx, coeff_idx - 1, scan, iscan);

  scan[*scan_idx] = coeff_idx;
  iscan[coeff_idx] = *scan_idx;
  ++(*scan_idx);
}

void av1_update_scan_order(TX_SIZE tx_size, int16_t *sort_order, int16_t *scan,
                           int16_t *iscan) {
  int coeff_idx;
  int scan_idx;
  int sort_idx;
  const int tx1d_size = tx_size_wide[tx_size];
  const int tx2d_size = tx_size_2d[tx_size];

  for (coeff_idx = 0; coeff_idx < tx2d_size; ++coeff_idx) {
    iscan[coeff_idx] = -1;
  }

  scan_idx = 0;
  for (sort_idx = 0; sort_idx < tx2d_size; ++sort_idx) {
    coeff_idx = sort_order[sort_idx];
    dfs_scan(tx1d_size, &scan_idx, coeff_idx, scan, iscan);
  }
}
#else

static void filter_prob(TX_SIZE tx_size, uint32_t *prob) {
  const int tx1d_wide = tx_size_wide[tx_size];
  const int tx1d_high = tx_size_high[tx_size];
  for (int r = tx1d_high - 1; r >= 0; --r) {
    for (int c = tx1d_wide - 1; c >= 0; --c) {
      int idx = r * tx1d_wide + c;
      uint32_t v = prob[idx];
      if (r > 0 && prob[idx - tx1d_wide] < v) prob[idx - tx1d_wide] = v;
      if (c > 0 && prob[idx - 1] < v) prob[idx - 1] = v;
    }
  }
}

void av1_update_scan_order(TX_SIZE tx_size, TX_TYPE tx_type,
                           uint32_t *non_zero_prob, int16_t *scan,
                           int16_t *iscan) {
  const SCAN_ORDER *sc = get_default_scan(tx_size, tx_type, 0);
  uint32_t temp[COEFF_IDX_SIZE];
  const int tx2d_size = tx_size_2d[tx_size];
  int scan_idx;
  assert(tx2d_size <= COEFF_IDX_SIZE);
  memcpy(temp, non_zero_prob, tx2d_size * sizeof(*non_zero_prob));
  filter_prob(tx_size, temp);
  av1_augment_prob(tx_size, tx_type, temp);
  qsort(temp, tx2d_size, sizeof(*temp), cmp_prob);
  for (scan_idx = 0; scan_idx < tx2d_size; ++scan_idx) {
    const int default_scan_idx =
        (temp[scan_idx] & COEFF_IDX_MASK) ^ COEFF_IDX_MASK;
    const int coeff_idx = sc->scan[default_scan_idx];
    scan[scan_idx] = coeff_idx;
    iscan[coeff_idx] = scan_idx;
  }
}
#endif

static void update_scan_order_facade(AV1_COMMON *cm, TX_SIZE tx_size,
                                     TX_TYPE tx_type, int use_curr_frame) {
#if USE_TOPOLOGICAL_SORT
  int16_t sort_order[COEFF_IDX_SIZE];
#endif
  uint32_t *non_zero_prob;
  if (use_curr_frame)
    non_zero_prob = get_non_zero_prob(cm->fc, tx_size, tx_type);
  else
    non_zero_prob = get_non_zero_prob(cm->pre_fc, tx_size, tx_type);
  int16_t *scan = get_adapt_scan(cm->fc, tx_size, tx_type);
  int16_t *iscan = get_adapt_iscan(cm->fc, tx_size, tx_type);
  int16_t *nb = get_adapt_nb(cm->fc, tx_size, tx_type);
  assert(tx_size_2d[tx_size] <= COEFF_IDX_SIZE);
#if USE_TOPOLOGICAL_SORT
  av1_update_sort_order(tx_size, tx_type, non_zero_prob, sort_order);
  av1_update_scan_order(tx_size, sort_order, scan, iscan);
#else
  av1_update_scan_order(tx_size, tx_type, non_zero_prob, scan, iscan);
#endif
#if USE_LIMIT_SCAN_DISTANCE
  limit_nb_scan_distance(tx_size, scan, iscan);
#endif  // USE_LIMIT_SCAN_DISTANCE
  av1_update_neighbors(tx_size, scan, iscan, nb);
}

static void update_eob_threshold(AV1_COMMON *cm, TX_SIZE tx_size,
                                 TX_TYPE tx_type) {
  int i, row, col, row_limit, col_limit, cal_idx = 0;
  const int tx_width = tx_size_wide[tx_size];
  const int tx_height = tx_size_high[tx_size];

  row_limit = tx_width >> 1;
  col_limit = tx_height >> 1;

  if (tx_width >= 8 && tx_height >= 8) {
    SCAN_ORDER *sc = &cm->fc->sc[tx_size][tx_type];
    int16_t *threshold = &cm->fc->eob_threshold[tx_size][tx_type][0];
    const int tx2d_size = tx_size_2d[tx_size];

    while (cal_idx < EOB_THRESHOLD_NUM) {
      for (i = 0; i < tx2d_size; ++i) {
        row = sc->scan[i] / tx_height;
        col = sc->scan[i] % tx_width;
        if (row >= row_limit || col >= col_limit) break;
      }
      row_limit >>= 1;
      col_limit >>= 1;
      threshold[cal_idx] = i;
      cal_idx++;
    }
  }
}

void av1_init_scan_order(AV1_COMMON *cm) {
  TX_SIZE tx_size;
  TX_TYPE tx_type;
  for (tx_size = 0; tx_size < TX_SIZES_ALL; ++tx_size) {
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    if (tx_size > TX_32X16) continue;
#else
    if (tx_size >= TX_SIZES) continue;
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    for (tx_type = DCT_DCT; tx_type < TX_TYPES; ++tx_type) {
      if (do_adapt_scan(tx_size, tx_type)) {
        uint32_t *non_zero_prob = get_non_zero_prob(cm->fc, tx_size, tx_type);
        const int tx2d_size = tx_size_2d[tx_size];
        int i;
        SCAN_ORDER *sc = &cm->fc->sc[tx_size][tx_type];
        for (i = 0; i < tx2d_size; ++i) {
          non_zero_prob[i] = (1 << ADAPT_SCAN_PROB_PRECISION) /
                             2;  // init non_zero_prob to 0.5
        }
        update_scan_order_facade(cm, tx_size, tx_type, 1);
        sc->scan = get_adapt_scan(cm->fc, tx_size, tx_type);
        sc->iscan = get_adapt_iscan(cm->fc, tx_size, tx_type);
        sc->neighbors = get_adapt_nb(cm->fc, tx_size, tx_type);
        update_eob_threshold(cm, tx_size, tx_type);
      }
    }
  }
}

void av1_adapt_scan_order(AV1_COMMON *cm) {
  if (cm->use_adapt_scan) {
    TX_SIZE tx_size;
#if CACHE_SCAN_PROB
    int use_curr_frame = 0;
#else   // CACHE_SCAN_PROB
    int use_curr_frame = 1;
#endif  // CACHE_SCAN_PROB

    for (tx_size = 0; tx_size < TX_SIZES_ALL; ++tx_size) {
#if CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
      if (tx_size > TX_32X16) continue;
#else
      if (tx_size >= TX_SIZES) continue;
#endif  // CONFIG_RECT_TX && (CONFIG_EXT_TX || CONFIG_VAR_TX)
      TX_TYPE tx_type;
      for (tx_type = DCT_DCT; tx_type < TX_TYPES; ++tx_type) {
        if (do_adapt_scan(tx_size, tx_type)) {
          update_scan_prob(cm, tx_size, tx_type, ADAPT_SCAN_UPDATE_RATE);
          update_scan_order_facade(cm, tx_size, tx_type, use_curr_frame);
          update_eob_threshold(cm, tx_size, tx_type);
        }
      }
    }
  }
}

void av1_deliver_eob_threshold(const AV1_COMMON *cm, MACROBLOCKD *xd) {
  xd->eob_threshold_md = (const EobThresholdMD *)cm->fc->eob_threshold;
}
#endif  // CONFIG_ADAPT_SCAN
