// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2018 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Tai_Viet`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v11.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00AA80, 0x00AAC2],
    [0x00AADB, 0x00AADF]
  ]
});
testPropertyEscapes(
  /^\p{Script=Tai_Viet}+$/u,
  matchSymbols,
  "\\p{Script=Tai_Viet}"
);
testPropertyEscapes(
  /^\p{Script=Tavt}+$/u,
  matchSymbols,
  "\\p{Script=Tavt}"
);
testPropertyEscapes(
  /^\p{sc=Tai_Viet}+$/u,
  matchSymbols,
  "\\p{sc=Tai_Viet}"
);
testPropertyEscapes(
  /^\p{sc=Tavt}+$/u,
  matchSymbols,
  "\\p{sc=Tavt}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00AA7F],
    [0x00AAC3, 0x00AADA],
    [0x00AAE0, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Tai_Viet}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tai_Viet}"
);
testPropertyEscapes(
  /^\P{Script=Tavt}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tavt}"
);
testPropertyEscapes(
  /^\P{sc=Tai_Viet}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tai_Viet}"
);
testPropertyEscapes(
  /^\P{sc=Tavt}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tavt}"
);

reportCompare(0, 0);
