# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# flake8: noqa

from Atom import Atom, InheritingAnonBoxAtom, NonInheritingAnonBoxAtom
from Atom import PseudoElementAtom
from HTMLAtoms import HTML_PARSER_ATOMS
import sys

# Static atom definitions, used to generate nsGkAtomList.h.
#
# Each atom is defined by a call to Atom, PseudoElementAtom,
# NonInheritingAnonBoxAtom or InheritingAnonBoxAtom.
#
# The first argument is the atom's identifier.
# The second argument is the atom's string value.
#
# It is not possible to conditionally define static atoms with #ifdef etc.
STATIC_ATOMS = [
    # --------------------------------------------------------------------------
    # Generic atoms
    # --------------------------------------------------------------------------

    Atom("_empty", ""),
    Atom("moz", "_moz"),
    Atom("mozframetype", "mozframetype"),
    Atom("_moz_abspos", "_moz_abspos"),
    Atom("_moz_activated", "_moz_activated"),
    Atom("_moz_anonclass", "_moz_anonclass"),
    Atom("_moz_resizing", "_moz_resizing"),
    Atom("mozallowfullscreen", "mozallowfullscreen"),
    Atom("moztype", "_moz-type"),
    Atom("mozdirty", "_moz_dirty"),
    Atom("mozdisallowselectionprint", "mozdisallowselectionprint"),
    Atom("mozdonotsend", "moz-do-not-send"),
    Atom("mozeditorbogusnode", "_moz_editor_bogus_node"),
    Atom("mozgeneratedcontentbefore", "_moz_generated_content_before"),
    Atom("mozgeneratedcontentafter", "_moz_generated_content_after"),
    Atom("mozgeneratedcontentimage", "_moz_generated_content_image"),
    Atom("mozquote", "_moz_quote"),
    Atom("mozsignature", "moz-signature"),
    Atom("_moz_is_glyph", "-moz-is-glyph"),
    Atom("_moz_original_size", "_moz_original_size"),
    Atom("menuactive", "_moz-menuactive"),
    Atom("_poundDefault", "#default"),
    Atom("_asterisk", "*"),
    Atom("a", "a"),
    Atom("abbr", "abbr"),
    Atom("abort", "abort"),
    Atom("acceltext", "acceltext"),
    Atom("accept", "accept"),
    Atom("acceptcharset", "accept-charset"),
    Atom("accessiblenode", "accessible-node"),
    Atom("accesskey", "accesskey"),
    Atom("acronym", "acronym"),
    Atom("action", "action"),
    Atom("active", "active"),
    Atom("activateontab", "activateontab"),
    Atom("actuate", "actuate"),
    Atom("address", "address"),
    Atom("after", "after"),
    Atom("align", "align"),
    Atom("alink", "alink"),
    Atom("allowdirs", "allowdirs"),
    Atom("allowevents", "allowevents"),
    Atom("allowforms", "allow-forms"),
    Atom("allowfullscreen", "allowfullscreen"),
    Atom("allowmodals", "allow-modals"),
    Atom("alloworientationlock", "allow-orientation-lock"),
    Atom("allowpaymentrequest", "allowpaymentrequest"),
    Atom("allowpointerlock", "allow-pointer-lock"),
    Atom("allowpopupstoescapesandbox", "allow-popups-to-escape-sandbox"),
    Atom("allowpopups", "allow-popups"),
    Atom("allowpresentation", "allow-presentation"),
    Atom("allowsameorigin", "allow-same-origin"),
    Atom("allowscripts", "allow-scripts"),
    Atom("allowtopnavigation", "allow-top-navigation"),
    Atom("allowuntrusted", "allowuntrusted"),
    Atom("alt", "alt"),
    Atom("alternate", "alternate"),
    Atom("always", "always"),
    Atom("ancestor", "ancestor"),
    Atom("ancestorOrSelf", "ancestor-or-self"),
    Atom("anchor", "anchor"),
    Atom("_and", "and"),
    Atom("animations", "animations"),
    Atom("anonid", "anonid"),
    Atom("anonlocation", "anonlocation"),
    Atom("any", "any"),
    Atom("applet", "applet"),
    Atom("applyImports", "apply-imports"),
    Atom("applyTemplates", "apply-templates"),
    Atom("archive", "archive"),
    Atom("area", "area"),
    Atom("aria_activedescendant", "aria-activedescendant"),
    Atom("aria_atomic", "aria-atomic"),
    Atom("aria_autocomplete", "aria-autocomplete"),
    Atom("aria_busy", "aria-busy"),
    Atom("aria_checked", "aria-checked"),
    Atom("aria_controls", "aria-controls"),
    Atom("aria_current", "aria-current"),
    Atom("aria_describedby", "aria-describedby"),
    Atom("aria_disabled", "aria-disabled"),
    Atom("aria_dropeffect", "aria-dropeffect"),
    Atom("aria_expanded", "aria-expanded"),
    Atom("aria_flowto", "aria-flowto"),
    Atom("aria_haspopup", "aria-haspopup"),
    Atom("aria_hidden", "aria-hidden"),
    Atom("aria_invalid", "aria-invalid"),
    Atom("aria_labelledby", "aria-labelledby"),
    Atom("aria_level", "aria-level"),
    Atom("aria_live", "aria-live"),
    Atom("aria_multiline", "aria-multiline"),
    Atom("aria_multiselectable", "aria-multiselectable"),
    Atom("aria_owns", "aria-owns"),
    Atom("aria_posinset", "aria-posinset"),
    Atom("aria_pressed", "aria-pressed"),
    Atom("aria_readonly", "aria-readonly"),
    Atom("aria_relevant", "aria-relevant"),
    Atom("aria_required", "aria-required"),
    Atom("aria_selected", "aria-selected"),
    Atom("aria_setsize", "aria-setsize"),
    Atom("aria_sort", "aria-sort"),
    Atom("aria_valuemax", "aria-valuemax"),
    Atom("aria_valuemin", "aria-valuemin"),
    Atom("aria_valuenow", "aria-valuenow"),
    Atom("arrow", "arrow"),
    Atom("article", "article"),
    Atom("as", "as"),
    Atom("ascending", "ascending"),
    Atom("aside", "aside"),
    Atom("aspectRatio", "aspect-ratio"),
    Atom("async", "async"),
    Atom("attribute", "attribute"),
    Atom("attributes", "attributes"),
    Atom("attributeSet", "attribute-set"),
    Atom("_auto", "auto"),
    Atom("autocheck", "autocheck"),
    Atom("autocomplete", "autocomplete"),
    Atom("autocomplete_richlistbox", "autocomplete-richlistbox"),
    Atom("autofocus", "autofocus"),
    Atom("autoplay", "autoplay"),
    Atom("axis", "axis"),
    Atom("b", "b"),
    Atom("background", "background"),
    Atom("base", "base"),
    Atom("basefont", "basefont"),
    Atom("baseline", "baseline"),
    Atom("bdi", "bdi"),
    Atom("bdo", "bdo"),
    Atom("before", "before"),
    Atom("bgcolor", "bgcolor"),
    Atom("bgsound", "bgsound"),
    Atom("big", "big"),
    Atom("binding", "binding"),
    Atom("bindings", "bindings"),
    Atom("bindToUntrustedContent", "bindToUntrustedContent"),
    Atom("block", "block"),
    Atom("blockquote", "blockquote"),
    Atom("body", "body"),
    Atom("boolean", "boolean"),
    Atom("border", "border"),
    Atom("bordercolor", "bordercolor"),
    Atom("both", "both"),
    Atom("bottom", "bottom"),
    Atom("bottomend", "bottomend"),
    Atom("bottomstart", "bottomstart"),
    Atom("bottomleft", "bottomleft"),
    Atom("bottommargin", "bottommargin"),
    Atom("bottomright", "bottomright"),
    Atom("box", "box"),
    Atom("br", "br"),
    Atom("browser", "browser"),
    Atom("mozbrowser", "mozbrowser"),
    Atom("button", "button"),
    Atom("brighttitlebarforeground", "brighttitlebarforeground"),
    Atom("callTemplate", "call-template"),
    Atom("canvas", "canvas"),
    Atom("caption", "caption"),
    Atom("caseOrder", "case-order"),
    Atom("cdataSectionElements", "cdata-section-elements"),
    Atom("ceiling", "ceiling"),
    Atom("cell", "cell"),
    Atom("cellpadding", "cellpadding"),
    Atom("cellspacing", "cellspacing"),
    Atom("center", "center"),
    Atom("change", "change"),
    Atom("_char", "char"),
    Atom("characterData", "characterData"),
    Atom("charcode", "charcode"),
    Atom("charoff", "charoff"),
    Atom("charset", "charset"),
    Atom("checkbox", "checkbox"),
    Atom("checked", "checked"),
    Atom("child", "child"),
    Atom("children", "children"),
    Atom("childList", "childList"),
    Atom("choose", "choose"),
    Atom("chromemargin", "chromemargin"),
    Atom("chromeOnlyContent", "chromeOnlyContent"),
    Atom("exposeToUntrustedContent", "exposeToUntrustedContent"),
    Atom("circ", "circ"),
    Atom("circle", "circle"),
    Atom("cite", "cite"),
    Atom("cjkDecimal", "cjk-decimal"),
    Atom("_class", "class"),
    Atom("classid", "classid"),
    Atom("clear", "clear"),
    Atom("click", "click"),
    Atom("clickcount", "clickcount"),
    Atom("clickthrough", "clickthrough"),
    Atom("movetoclick", "movetoclick"),
    Atom("clip", "clip"),
    Atom("close", "close"),
    Atom("closed", "closed"),
    Atom("closemenu", "closemenu"),
    Atom("code", "code"),
    Atom("codebase", "codebase"),
    Atom("codetype", "codetype"),
    Atom("col", "col"),
    Atom("colgroup", "colgroup"),
    Atom("collapse", "collapse"),
    Atom("collapsed", "collapsed"),
    Atom("color", "color"),
    Atom("colorIndex", "color-index"),
    Atom("cols", "cols"),
    Atom("colspan", "colspan"),
    Atom("combobox", "combobox"),
    Atom("command", "command"),
    Atom("commandupdater", "commandupdater"),
    Atom("comment", "comment"),
    Atom("compact", "compact"),
    Atom("concat", "concat"),
    Atom("constructor", "constructor"),
    Atom("consumeoutsideclicks", "consumeoutsideclicks"),
    Atom("container", "container"),
    Atom("contains", "contains"),
    Atom("content", "content"),
    Atom("contenteditable", "contenteditable"),
    Atom("headerContentDisposition", "content-disposition"),
    Atom("headerContentLanguage", "content-language"),
    Atom("contentLocation", "content-location"),
    Atom("headerContentScriptType", "content-script-type"),
    Atom("headerContentStyleType", "content-style-type"),
    Atom("headerContentType", "content-type"),
    Atom("consumeanchor", "consumeanchor"),
    Atom("context", "context"),
    Atom("contextmenu", "contextmenu"),
    Atom("control", "control"),
    Atom("controls", "controls"),
    Atom("coords", "coords"),
    Atom("copy", "copy"),
    Atom("copyOf", "copy-of"),
    Atom("count", "count"),
    Atom("crop", "crop"),
    Atom("crossorigin", "crossorigin"),
    Atom("curpos", "curpos"),
    Atom("current", "current"),
    Atom("cutoutregion", "cutoutregion"),
    Atom("cycler", "cycler"),
    Atom("data", "data"),
    Atom("datalist", "datalist"),
    Atom("datal10nid", "data-l10n-id"),
    Atom("datal10nargs", "data-l10n-args"),
    Atom("datal10nattrs", "data-l10n-attrs"),
    Atom("dataType", "data-type"),
    Atom("dateTime", "date-time"),
    Atom("date", "date"),
    Atom("datetime", "datetime"),
    Atom("datetimebox", "datetimebox"),
    Atom("dd", "dd"),
    Atom("decimal", "decimal"),
    Atom("decimalFormat", "decimal-format"),
    Atom("decimalSeparator", "decimal-separator"),
    Atom("declare", "declare"),
    Atom("decoderDoctor", "decoder-doctor"),
    Atom("decoding", "decoding"),
    Atom("decrement", "decrement"),
    Atom("_default", "default"),
    Atom("headerDefaultStyle", "default-style"),
    Atom("defer", "defer"),
    Atom("del", "del"),
    Atom("descendant", "descendant"),
    Atom("descendantOrSelf", "descendant-or-self"),
    Atom("descending", "descending"),
    Atom("description", "description"),
    Atom("destructor", "destructor"),
    Atom("details", "details"),
    Atom("deviceAspectRatio", "device-aspect-ratio"),
    Atom("deviceHeight", "device-height"),
    Atom("devicePixelRatio", "device-pixel-ratio"),
    Atom("deviceWidth", "device-width"),
    Atom("dfn", "dfn"),
    Atom("dialog", "dialog"),
    Atom("difference", "difference"),
    Atom("digit", "digit"),
    Atom("dir", "dir"),
    Atom("dirAutoSetBy", "dirAutoSetBy"),
    Atom("directory", "directory"),
    Atom("disableOutputEscaping", "disable-output-escaping"),
    Atom("disabled", "disabled"),
    Atom("disableglobalhistory", "disableglobalhistory"),
    Atom("disablehistory", "disablehistory"),
    Atom("disablefullscreen", "disablefullscreen"),
    Atom("disclosure_closed", "disclosure-closed"),
    Atom("disclosure_open", "disclosure-open"),
    Atom("display", "display"),
    Atom("displayMode", "display-mode"),
    Atom("distinct", "distinct"),
    Atom("div", "div"),
    Atom("dl", "dl"),
    Atom("docAbstract", "doc-abstract"),
    Atom("docAcknowledgments", "doc-acknowledgments"),
    Atom("docAfterword", "doc-afterword"),
    Atom("docAppendix", "doc-appendix"),
    Atom("docBacklink", "doc-backlink"),
    Atom("docBiblioentry", "doc-biblioentry"),
    Atom("docBibliography", "doc-bibliography"),
    Atom("docBiblioref", "doc-biblioref"),
    Atom("docChapter", "doc-chapter"),
    Atom("docColophon", "doc-colophon"),
    Atom("docConclusion", "doc-conclusion"),
    Atom("docCover", "doc-cover"),
    Atom("docCredit", "doc-credit"),
    Atom("docCredits", "doc-credits"),
    Atom("docDedication", "doc-dedication"),
    Atom("docEndnote", "doc-endnote"),
    Atom("docEndnotes", "doc-endnotes"),
    Atom("docEpigraph", "doc-epigraph"),
    Atom("docEpilogue", "doc-epilogue"),
    Atom("docErrata", "doc-errata"),
    Atom("docExample", "doc-example"),
    Atom("docFootnote", "doc-footnote"),
    Atom("docForeword", "doc-foreword"),
    Atom("docGlossary", "doc-glossary"),
    Atom("docGlossref", "doc-glossref"),
    Atom("docIndex", "doc-index"),
    Atom("docIntroduction", "doc-introduction"),
    Atom("docNoteref", "doc-noteref"),
    Atom("docNotice", "doc-notice"),
    Atom("docPagebreak", "doc-pagebreak"),
    Atom("docPagelist", "doc-pagelist"),
    Atom("docPart", "doc-part"),
    Atom("docPreface", "doc-preface"),
    Atom("docPrologue", "doc-prologue"),
    Atom("docPullquote", "doc-pullquote"),
    Atom("docQna", "doc-qna"),
    Atom("docSubtitle", "doc-subtitle"),
    Atom("docTip", "doc-tip"),
    Atom("docToc", "doc-toc"),
    Atom("doctypePublic", "doctype-public"),
    Atom("doctypeSystem", "doctype-system"),
    Atom("document", "document"),
    Atom("download", "download"),
    Atom("drag", "drag"),
    Atom("draggable", "draggable"),
    Atom("dragging", "dragging"),
    Atom("dragSession", "dragSession"),
    Atom("drawintitlebar", "drawintitlebar"),
    Atom("drawtitle", "drawtitle"),
    Atom("dropAfter", "dropAfter"),
    Atom("dropBefore", "dropBefore"),
    Atom("dropOn", "dropOn"),
    Atom("dropMarker", "dropmarker"),
    Atom("dt", "dt"),
    Atom("editable", "editable"),
    Atom("editing", "editing"),
    Atom("editor", "editor"),
    Atom("element", "element"),
    Atom("elementAvailable", "element-available"),
    Atom("elements", "elements"),
    Atom("em", "em"),
    Atom("embed", "embed"),
    Atom("empty", "empty"),
    Atom("encoding", "encoding"),
    Atom("enctype", "enctype"),
    Atom("end", "end"),
    Atom("endEvent", "endEvent"),
    Atom("equalsize", "equalsize"),
    Atom("error", "error"),
    Atom("ethiopic_numeric", "ethiopic-numeric"),
    Atom("even", "even"),
    Atom("event", "event"),
    Atom("events", "events"),
    Atom("excludeResultPrefixes", "exclude-result-prefixes"),
    Atom("extends", "extends"),
    Atom("extensionElementPrefixes", "extension-element-prefixes"),
    Atom("face", "face"),
    Atom("fallback", "fallback"),
    Atom("_false", "false"),
    Atom("farthest", "farthest"),
    Atom("field", "field"),
    Atom("fieldset", "fieldset"),
    Atom("file", "file"),
    Atom("figcaption", "figcaption"),
    Atom("figure", "figure"),
    Atom("findbar", "findbar"),
    Atom("fixed", "fixed"),
    Atom("flags", "flags"),
    Atom("flex", "flex"),
    Atom("flip", "flip"),
    Atom("floating", "floating"),
    Atom("floor", "floor"),
    Atom("flowlength", "flowlength"),
    Atom("focus", "focus"),
    Atom("focused", "focused"),
    Atom("followanchor", "followanchor"),
    Atom("following", "following"),
    Atom("followingSibling", "following-sibling"),
    Atom("font", "font"),
    Atom("fontWeight", "font-weight"),
    Atom("footer", "footer"),
    Atom("_for", "for"),
    Atom("forEach", "for-each"),
    Atom("forceOwnRefreshDriver", "forceOwnRefreshDriver"),
    Atom("form", "form"),
    Atom("formaction", "formaction"),
    Atom("format", "format"),
    Atom("formatNumber", "format-number"),
    Atom("formenctype", "formenctype"),
    Atom("formmethod", "formmethod"),
    Atom("formnovalidate", "formnovalidate"),
    Atom("formtarget", "formtarget"),
    Atom("frame", "frame"),
    Atom("frameborder", "frameborder"),
    Atom("frameset", "frameset"),
    Atom("from", "from"),
    Atom("fullscreenchange", "fullscreenchange"),
    Atom("fullscreenerror", "fullscreenerror"),
    Atom("functionAvailable", "function-available"),
    Atom("generateId", "generate-id"),
    Atom("getter", "getter"),
    Atom("graphicsDocument", "graphics-document"),
    Atom("graphicsObject", "graphics-object"),
    Atom("graphicsSymbol", "graphics-symbol"),
    Atom("grid", "grid"),
    Atom("group", "group"),
    Atom("groupbox", "groupbox"),
    Atom("groupingSeparator", "grouping-separator"),
    Atom("groupingSize", "grouping-size"),
    Atom("grow", "grow"),
    Atom("h1", "h1"),
    Atom("h2", "h2"),
    Atom("h3", "h3"),
    Atom("h4", "h4"),
    Atom("h5", "h5"),
    Atom("h6", "h6"),
    Atom("handheldFriendly", "HandheldFriendly"),
    Atom("handler", "handler"),
    Atom("handlers", "handlers"),
    Atom("HARD", "HARD"),
    Atom("hasSameNode", "has-same-node"),
    Atom("hbox", "hbox"),
    Atom("head", "head"),
    Atom("header", "header"),
    Atom("headers", "headers"),
    Atom("hebrew", "hebrew"),
    Atom("height", "height"),
    Atom("hgroup", "hgroup"),
    Atom("hidden", "hidden"),
    Atom("hidechrome", "hidechrome"),
    Atom("hidecolumnpicker", "hidecolumnpicker"),
    Atom("high", "high"),
    Atom("highest", "highest"),
    Atom("horizontal", "horizontal"),
    Atom("hover", "hover"),
    Atom("hr", "hr"),
    Atom("href", "href"),
    Atom("hreflang", "hreflang"),
    Atom("hspace", "hspace"),
    Atom("html", "html"),
    Atom("httpEquiv", "http-equiv"),
    Atom("i", "i"),
    Atom("icon", "icon"),
    Atom("id", "id"),
    Atom("_if", "if"),
    Atom("iframe", "iframe"),
    Atom("ignorekeys", "ignorekeys"),
    Atom("ignoreuserfocus", "ignoreuserfocus"),
    Atom("image", "image"),
    Atom("imageClickedPoint", "image-clicked-point"),
    Atom("img", "img"),
    Atom("implementation", "implementation"),
    Atom("implements", "implements"),
    Atom("import", "import"),
    Atom("include", "include"),
    Atom("includes", "includes"),
    Atom("increment", "increment"),
    Atom("indent", "indent"),
    Atom("indeterminate", "indeterminate"),
    Atom("index", "index"),
    Atom("infinity", "infinity"),
    Atom("inherits", "inherits"),
    Atom("inheritstyle", "inheritstyle"),
    Atom("initial_scale", "initial-scale"),
    Atom("input", "input"),
    Atom("inputmode", "inputmode"),
    Atom("ins", "ins"),
    Atom("insertafter", "insertafter"),
    Atom("insertbefore", "insertbefore"),
    Atom("integer", "integer"),
    Atom("integrity", "integrity"),
    Atom("intersection", "intersection"),
    Atom("intersectionobserverlist", "intersectionobserverlist"),
    Atom("is", "is"),
    Atom("ismap", "ismap"),
    Atom("itemid", "itemid"),
    Atom("itemprop", "itemprop"),
    Atom("itemref", "itemref"),
    Atom("itemscope", "itemscope"),
    Atom("itemtype", "itemtype"),
    Atom("japanese_formal", "japanese-formal"),
    Atom("japanese_informal", "japanese-informal"),
    Atom("kbd", "kbd"),
    Atom("keepcurrentinview", "keepcurrentinview"),
    Atom("keepobjectsalive", "keepobjectsalive"),
    Atom("key", "key"),
    Atom("keycode", "keycode"),
    Atom("keydown", "keydown"),
    Atom("keygen", "keygen"),
    Atom("keypress", "keypress"),
    Atom("keyset", "keyset"),
    Atom("keysystem", "keysystem"),
    Atom("keytext", "keytext"),
    Atom("keyup", "keyup"),
    Atom("kind", "kind"),
    Atom("korean_hangul_formal", "korean-hangul-formal"),
    Atom("korean_hanja_formal", "korean-hanja-formal"),
    Atom("korean_hanja_informal", "korean-hanja-informal"),
    Atom("label", "label"),
    Atom("lang", "lang"),
    Atom("language", "language"),
    Atom("last", "last"),
    Atom("layer", "layer"),
    Atom("LayerActivity", "LayerActivity"),
    Atom("leading", "leading"),
    Atom("leaf", "leaf"),
    Atom("left", "left"),
    Atom("leftmargin", "leftmargin"),
    Atom("legend", "legend"),
    Atom("length", "length"),
    Atom("letterValue", "letter-value"),
    Atom("level", "level"),
    Atom("li", "li"),
    Atom("line", "line"),
    Atom("link", "link"),
    # Atom("list", "list"),  # "list" is present below
    Atom("listbox", "listbox"),
    Atom("listener", "listener"),
    Atom("listheader", "listheader"),
    Atom("listing", "listing"),
    Atom("listitem", "listitem"),
    Atom("load", "load"),
    Atom("triggeringprincipal", "triggeringprincipal"),
    Atom("localedir", "localedir"),
    Atom("localName", "local-name"),
    Atom("longdesc", "longdesc"),
    Atom("loop", "loop"),
    Atom("low", "low"),
    Atom("lowerAlpha", "lower-alpha"),
    Atom("lowerFirst", "lower-first"),
    Atom("lowerRoman", "lower-roman"),
    Atom("lowest", "lowest"),
    Atom("lowsrc", "lowsrc"),
    Atom("ltr", "ltr"),
    Atom("lwtheme", "lwtheme"),
    Atom("lwthemetextcolor", "lwthemetextcolor"),
    Atom("main", "main"),
    Atom("map", "map"),
    Atom("manifest", "manifest"),
    Atom("marginBottom", "margin-bottom"),
    Atom("marginLeft", "margin-left"),
    Atom("marginRight", "margin-right"),
    Atom("marginTop", "margin-top"),
    Atom("marginheight", "marginheight"),
    Atom("marginwidth", "marginwidth"),
    Atom("mark", "mark"),
    Atom("marquee", "marquee"),
    Atom("match", "match"),
    Atom("max", "max"),
    Atom("maxheight", "maxheight"),
    Atom("maximum_scale", "maximum-scale"),
    Atom("maxlength", "maxlength"),
    Atom("maxpos", "maxpos"),
    Atom("maxwidth", "maxwidth"),
    Atom("media", "media"),
    Atom("mediaType", "media-type"),
    Atom("menu", "menu"),
    Atom("menubar", "menubar"),
    Atom("menubutton", "menubutton"),
    Atom("menucaption", "menucaption"),
    Atom("menugroup", "menugroup"),
    Atom("menuitem", "menuitem"),
    Atom("menulist", "menulist"),
    Atom("menupopup", "menupopup"),
    Atom("menuseparator", "menuseparator"),
    Atom("message", "message"),
    Atom("meta", "meta"),
    Atom("referrer", "referrer"),
    Atom("referrerpolicy", "referrerpolicy"),
    Atom("headerReferrerPolicy", "referrer-policy"),
    Atom("meter", "meter"),
    Atom("method", "method"),
    Atom("middle", "middle"),
    Atom("min", "min"),
    Atom("minheight", "minheight"),
    Atom("minimum_scale", "minimum-scale"),
    Atom("minlength", "minlength"),
    Atom("minpos", "minpos"),
    Atom("minusSign", "minus-sign"),
    Atom("minwidth", "minwidth"),
    Atom("mixed", "mixed"),
    Atom("messagemanagergroup", "messagemanagergroup"),
    Atom("mod", "mod"),
    Atom("mode", "mode"),
    Atom("modifiers", "modifiers"),
    Atom("monochrome", "monochrome"),
    Atom("mouseover", "mouseover"),
    Atom("mousethrough", "mousethrough"),
    Atom("mozprivatebrowsing", "mozprivatebrowsing"),
    Atom("moz_opaque", "moz-opaque"),
    Atom("moz_action_hint", "mozactionhint"),
    Atom("x_moz_errormessage", "x-moz-errormessage"),
    Atom("multicol", "multicol"),
    Atom("multiple", "multiple"),
    Atom("muted", "muted"),
    Atom("name", "name"),
    Atom("_namespace", "namespace"),
    Atom("namespaceAlias", "namespace-alias"),
    Atom("namespaceUri", "namespace-uri"),
    Atom("NaN", "NaN"),
    Atom("nativeAnonymousChildList", "nativeAnonymousChildList"),
    Atom("nav", "nav"),
    Atom("never", "never"),
    Atom("_new", "new"),
    Atom("newline", "newline"),
    Atom("nextTabParentId", "nextTabParentId"),
    Atom("no", "no"),
    Atom("noautofocus", "noautofocus"),
    Atom("noautohide", "noautohide"),
    Atom("norolluponanchor", "norolluponanchor"),
    Atom("nobr", "nobr"),
    Atom("nodefaultsrc", "nodefaultsrc"),
    Atom("nodeSet", "node-set"),
    Atom("noembed", "noembed"),
    Atom("noframes", "noframes"),
    Atom("nohref", "nohref"),
    Atom("noisolation", "noisolation"),
    Atom("nomodule", "nomodule"),
    Atom("nonce", "nonce"),
    Atom("none", "none"),
    Atom("noresize", "noresize"),
    Atom("normal", "normal"),
    Atom("normalizeSpace", "normalize-space"),
    Atom("noscript", "noscript"),
    Atom("noshade", "noshade"),
    Atom("notification", "notification"),
    Atom("novalidate", "novalidate"),
    Atom("_not", "not"),
    Atom("nowrap", "nowrap"),
    Atom("number", "number"),
    Atom("object", "object"),
    Atom("objectType", "object-type"),
    Atom("observes", "observes"),
    Atom("odd", "odd"),
    Atom("OFF", "OFF"),
    Atom("ol", "ol"),
    Atom("omitXmlDeclaration", "omit-xml-declaration"),
    Atom("onabort", "onabort"),
    Atom("onmozaccesskeynotfound", "onmozaccesskeynotfound"),
    Atom("onactivate", "onactivate"),
    Atom("onafterprint", "onafterprint"),
    Atom("onafterscriptexecute", "onafterscriptexecute"),
    Atom("onanimationcancel", "onanimationcancel"),
    Atom("onanimationend", "onanimationend"),
    Atom("onanimationiteration", "onanimationiteration"),
    Atom("onanimationstart", "onanimationstart"),
    Atom("onAppCommand", "onAppCommand"),
    Atom("onappinstalled", "onappinstalled"),
    Atom("onaudioprocess", "onaudioprocess"),
    Atom("onauxclick", "onauxclick"),
    Atom("onbeforecopy", "onbeforecopy"),
    Atom("onbeforecut", "onbeforecut"),
    Atom("onbeforepaste", "onbeforepaste"),
    Atom("onbeforeprint", "onbeforeprint"),
    Atom("onbeforescriptexecute", "onbeforescriptexecute"),
    Atom("onbeforeunload", "onbeforeunload"),
    Atom("onblocked", "onblocked"),
    Atom("onblur", "onblur"),
    Atom("onbounce", "onbounce"),
    Atom("onbroadcast", "onbroadcast"),
    Atom("onbufferedamountlow", "onbufferedamountlow"),
    Atom("oncached", "oncached"),
    Atom("oncancel", "oncancel"),
    Atom("onchange", "onchange"),
    Atom("onchargingchange", "onchargingchange"),
    Atom("onchargingtimechange", "onchargingtimechange"),
    Atom("onchecking", "onchecking"),
    Atom("onCheckboxStateChange", "onCheckboxStateChange"),
    Atom("onclick", "onclick"),
    Atom("onclose", "onclose"),
    Atom("oncommand", "oncommand"),
    Atom("oncommandupdate", "oncommandupdate"),
    Atom("oncomplete", "oncomplete"),
    Atom("oncompositionend", "oncompositionend"),
    Atom("oncompositionstart", "oncompositionstart"),
    Atom("oncompositionupdate", "oncompositionupdate"),
    Atom("onconnect", "onconnect"),
    Atom("onconnectionavailable", "onconnectionavailable"),
    Atom("oncontextmenu", "oncontextmenu"),
    Atom("oncopy", "oncopy"),
    Atom("oncut", "oncut"),
    Atom("ondblclick", "ondblclick"),
    Atom("ondischargingtimechange", "ondischargingtimechange"),
    Atom("ondownloading", "ondownloading"),
    Atom("onDOMActivate", "onDOMActivate"),
    Atom("onDOMAttrModified", "onDOMAttrModified"),
    Atom("onDOMCharacterDataModified", "onDOMCharacterDataModified"),
    Atom("onDOMFocusIn", "onDOMFocusIn"),
    Atom("onDOMFocusOut", "onDOMFocusOut"),
    Atom("onDOMMouseScroll", "onDOMMouseScroll"),
    Atom("onDOMNodeInserted", "onDOMNodeInserted"),
    Atom("onDOMNodeInsertedIntoDocument", "onDOMNodeInsertedIntoDocument"),
    Atom("onDOMNodeRemoved", "onDOMNodeRemoved"),
    Atom("onDOMNodeRemovedFromDocument", "onDOMNodeRemovedFromDocument"),
    Atom("onDOMSubtreeModified", "onDOMSubtreeModified"),
    Atom("ondata", "ondata"),
    Atom("ondrag", "ondrag"),
    Atom("ondragdrop", "ondragdrop"),
    Atom("ondragend", "ondragend"),
    Atom("ondragenter", "ondragenter"),
    Atom("ondragexit", "ondragexit"),
    Atom("ondragleave", "ondragleave"),
    Atom("ondragover", "ondragover"),
    Atom("ondragstart", "ondragstart"),
    Atom("ondrain", "ondrain"),
    Atom("ondrop", "ondrop"),
    Atom("onerror", "onerror"),
    Atom("onfinish", "onfinish"),
    Atom("onfocus", "onfocus"),
    Atom("onfocusin", "onfocusin"),
    Atom("onfocusout", "onfocusout"),
    Atom("onfullscreenchange", "onfullscreenchange"),
    Atom("onfullscreenerror", "onfullscreenerror"),
    Atom("onget", "onget"),
    Atom("onhashchange", "onhashchange"),
    Atom("oninput", "oninput"),
    Atom("oninstall", "oninstall"),
    Atom("oninvalid", "oninvalid"),
    Atom("onkeydown", "onkeydown"),
    Atom("onkeypress", "onkeypress"),
    Atom("onkeyup", "onkeyup"),
    Atom("onlanguagechange", "onlanguagechange"),
    Atom("onlevelchange", "onlevelchange"),
    Atom("onload", "onload"),
    Atom("onloading", "onloading"),
    Atom("onloadingdone", "onloadingdone"),
    Atom("onloadingerror", "onloadingerror"),
    Atom("onpopstate", "onpopstate"),
    Atom("only", "only"),               # this one is not an event
    Atom("onmessage", "onmessage"),
    Atom("onmessageerror", "onmessageerror"),
    Atom("onmidimessage", "onmidimessage"),
    Atom("onmousedown", "onmousedown"),
    Atom("onmouseenter", "onmouseenter"),
    Atom("onmouseleave", "onmouseleave"),
    Atom("onmouselongtap", "onmouselongtap"),
    Atom("onmousemove", "onmousemove"),
    Atom("onmouseout", "onmouseout"),
    Atom("onmouseover", "onmouseover"),
    Atom("onMozMouseHittest", "onMozMouseHittest"),
    Atom("onmouseup", "onmouseup"),
    Atom("onMozAfterPaint", "onMozAfterPaint"),
    Atom("onmozfullscreenchange", "onmozfullscreenchange"),
    Atom("onmozfullscreenerror", "onmozfullscreenerror"),
    Atom("onmozkeydownonplugin", "onmozkeydownonplugin"),
    Atom("onmozkeyuponplugin", "onmozkeyuponplugin"),
    Atom("onmozpointerlockchange", "onmozpointerlockchange"),
    Atom("onmozpointerlockerror", "onmozpointerlockerror"),
    Atom("onMozMousePixelScroll", "onMozMousePixelScroll"),
    Atom("onMozScrolledAreaChanged", "onMozScrolledAreaChanged"),
    Atom("onmute", "onmute"),
    Atom("onnotificationclick", "onnotificationclick"),
    Atom("onnotificationclose", "onnotificationclose"),
    Atom("onnoupdate", "onnoupdate"),
    Atom("onobsolete", "onobsolete"),
    Atom("ononline", "ononline"),
    Atom("onoffline", "onoffline"),
    Atom("onopen", "onopen"),
    Atom("onorientationchange", "onorientationchange"),
    Atom("onoverflow", "onoverflow"),
    Atom("onpagehide", "onpagehide"),
    Atom("onpageshow", "onpageshow"),
    Atom("onpaste", "onpaste"),
    Atom("onpaymentmethodchange", "onpaymentmethodchange"),
    Atom("onpointerlockchange", "onpointerlockchange"),
    Atom("onpointerlockerror", "onpointerlockerror"),
    Atom("onpopuphidden", "onpopuphidden"),
    Atom("onpopuphiding", "onpopuphiding"),
    Atom("onpopuppositioned", "onpopuppositioned"),
    Atom("onpopupshowing", "onpopupshowing"),
    Atom("onpopupshown", "onpopupshown"),
    Atom("onprocessorerror", "onprocessorerror"),
    Atom("onpush", "onpush"),
    Atom("onpushsubscriptionchange", "onpushsubscriptionchange"),
    Atom("onRadioStateChange", "onRadioStateChange"),
    Atom("onreadystatechange", "onreadystatechange"),
    Atom("onrequestprogress", "onrequestprogress"),
    Atom("onresourcetimingbufferfull", "onresourcetimingbufferfull"),
    Atom("onresponseprogress", "onresponseprogress"),
    Atom("onRequest", "onRequest"),
    Atom("onreset", "onreset"),
    Atom("onresize", "onresize"),
    Atom("onscroll", "onscroll"),
    Atom("onselect", "onselect"),
    Atom("onselectionchange", "onselectionchange"),
    Atom("onselectstart", "onselectstart"),
    Atom("onset", "onset"),
    Atom("onshippingaddresschange", "onshippingaddresschange"),
    Atom("onshippingoptionchange", "onshippingoptionchange"),
    Atom("onshow", "onshow"),
    Atom("onstatechange", "onstatechange"),
    Atom("onstorage", "onstorage"),
    Atom("onsubmit", "onsubmit"),
    Atom("onsuccess", "onsuccess"),
    Atom("ontypechange", "ontypechange"),
    Atom("onterminate", "onterminate"),
    Atom("ontext", "ontext"),
    Atom("ontoggle", "ontoggle"),
    Atom("ontouchstart", "ontouchstart"),
    Atom("ontouchend", "ontouchend"),
    Atom("ontouchmove", "ontouchmove"),
    Atom("ontouchcancel", "ontouchcancel"),
    Atom("ontransitioncancel", "ontransitioncancel"),
    Atom("ontransitionend", "ontransitionend"),
    Atom("ontransitionrun", "ontransitionrun"),
    Atom("ontransitionstart", "ontransitionstart"),
    Atom("onunderflow", "onunderflow"),
    Atom("onunload", "onunload"),
    Atom("onunmute", "onunmute"),
    Atom("onupdatefound", "onupdatefound"),
    Atom("onupdateready", "onupdateready"),
    Atom("onupgradeneeded", "onupgradeneeded"),
    Atom("onversionchange", "onversionchange"),
    Atom("onvisibilitychange", "onvisibilitychange"),
    Atom("onvoiceschanged", "onvoiceschanged"),
    Atom("onvrdisplayactivate", "onvrdisplayactivate"),
    Atom("onvrdisplayconnect", "onvrdisplayconnect"),
    Atom("onvrdisplaydeactivate", "onvrdisplaydeactivate"),
    Atom("onvrdisplaydisconnect", "onvrdisplaydisconnect"),
    Atom("onvrdisplaypresentchange", "onvrdisplaypresentchange"),
    Atom("onwebkitAnimationEnd", "onwebkitAnimationEnd"),
    Atom("onwebkitAnimationIteration", "onwebkitAnimationIteration"),
    Atom("onwebkitAnimationStart", "onwebkitAnimationStart"),
    Atom("onwebkitTransitionEnd", "onwebkitTransitionEnd"),
    Atom("onwebkitanimationend", "onwebkitanimationend"),
    Atom("onwebkitanimationiteration", "onwebkitanimationiteration"),
    Atom("onwebkitanimationstart", "onwebkitanimationstart"),
    Atom("onwebkittransitionend", "onwebkittransitionend"),
    Atom("onwheel", "onwheel"),
    Atom("open", "open"),
    Atom("optgroup", "optgroup"),
    Atom("optimum", "optimum"),
    Atom("option", "option"),
    Atom("_or", "or"),
    Atom("order", "order"),
    Atom("ordinal", "ordinal"),
    Atom("orient", "orient"),
    Atom("orientation", "orientation"),
    Atom("otherwise", "otherwise"),
    Atom("output", "output"),
    Atom("overflow", "overflow"),
    Atom("overlay", "overlay"),
    Atom("p", "p"),
    Atom("pack", "pack"),
    Atom("page", "page"),
    Atom("pageincrement", "pageincrement"),
    Atom("paint_order", "paint-order"),
    Atom("panel", "panel"),
    Atom("paragraph", "paragraph"),
    Atom("param", "param"),
    Atom("parameter", "parameter"),
    Atom("parent", "parent"),
    Atom("parentfocused", "parentfocused"),
    Atom("password", "password"),
    Atom("pattern", "pattern"),
    Atom("patternSeparator", "pattern-separator"),
    Atom("perMille", "per-mille"),
    Atom("percent", "percent"),
    Atom("persist", "persist"),
    Atom("phase", "phase"),
    Atom("picture", "picture"),
    Atom("ping", "ping"),
    Atom("pinned", "pinned"),
    Atom("placeholder", "placeholder"),
    Atom("plaintext", "plaintext"),
    Atom("playbackrate", "playbackrate"),
    Atom("pointSize", "point-size"),
    Atom("poly", "poly"),
    Atom("polygon", "polygon"),
    Atom("popup", "popup"),
    Atom("popupalign", "popupalign"),
    Atom("popupanchor", "popupanchor"),
    Atom("popupgroup", "popupgroup"),
    Atom("popupset", "popupset"),
    Atom("popupsinherittooltip", "popupsinherittooltip"),
    Atom("position", "position"),
    Atom("poster", "poster"),
    Atom("pre", "pre"),
    Atom("preceding", "preceding"),
    Atom("precedingSibling", "preceding-sibling"),
    Atom("prefersReducedMotion", "prefers-reduced-motion"),
    Atom("prefix", "prefix"),
    Atom("preload", "preload"),
    Atom("mozpresentation", "mozpresentation"),
    Atom("preserve", "preserve"),
    Atom("preserveSpace", "preserve-space"),
    Atom("preventdefault", "preventdefault"),
    Atom("primary", "primary"),
    Atom("print", "print"),
    Atom("priority", "priority"),
    Atom("processingInstruction", "processing-instruction"),
    Atom("profile", "profile"),
    Atom("progress", "progress"),
    Atom("progressmeter", "progressmeter"),
    Atom("prompt", "prompt"),
    Atom("properties", "properties"),
    Atom("property", "property"),
    Atom("pubdate", "pubdate"),
    Atom("q", "q"),
    Atom("radio", "radio"),
    Atom("radiogroup", "radiogroup"),
    Atom("range", "range"),
    Atom("readonly", "readonly"),
    Atom("rect", "rect"),
    Atom("rectangle", "rectangle"),
    Atom("refresh", "refresh"),
    Atom("rel", "rel"),
    Atom("rem", "rem"),
    Atom("remote", "remote"),
    Atom("removeelement", "removeelement"),
    Atom("renderingobserverlist", "renderingobserverlist"),
    Atom("repeat", "repeat"),
    Atom("replace", "replace"),
    Atom("requestcontextid", "requestcontextid"),
    Atom("required", "required"),
    Atom("reserved", "reserved"),
    Atom("reset", "reset"),
    Atom("resizeafter", "resizeafter"),
    Atom("resizebefore", "resizebefore"),
    Atom("resizer", "resizer"),
    Atom("resolution", "resolution"),
    Atom("resources", "resources"),
    Atom("result", "result"),
    Atom("resultPrefix", "result-prefix"),
    Atom("retargetdocumentfocus", "retargetdocumentfocus"),
    Atom("rev", "rev"),
    Atom("reverse", "reverse"),
    Atom("reversed", "reversed"),
    Atom("richlistbox", "richlistbox"),
    Atom("richlistitem", "richlistitem"),
    Atom("right", "right"),
    Atom("rightmargin", "rightmargin"),
    Atom("role", "role"),
    Atom("rolluponmousewheel", "rolluponmousewheel"),
    Atom("round", "round"),
    Atom("row", "row"),
    Atom("rows", "rows"),
    Atom("rowspan", "rowspan"),
    Atom("rb", "rb"),
    Atom("rp", "rp"),
    Atom("rt", "rt"),
    Atom("rtc", "rtc"),
    Atom("rtl", "rtl"),
    Atom("ruby", "ruby"),
    Atom("rubyBase", "ruby-base"),
    Atom("rubyBaseContainer", "ruby-base-container"),
    Atom("rubyText", "ruby-text"),
    Atom("rubyTextContainer", "ruby-text-container"),
    Atom("rules", "rules"),
    Atom("s", "s"),
    Atom("samp", "samp"),
    Atom("sandbox", "sandbox"),
    Atom("sbattr", "sbattr"),
    Atom("scale", "scale"),
    Atom("scan", "scan"),
    Atom("scheme", "scheme"),
    Atom("scope", "scope"),
    Atom("scoped", "scoped"),
    Atom("screen", "screen"),
    Atom("screenX", "screenX"),
    Atom("screenY", "screenY"),
    Atom("script", "script"),
    Atom("scriptEnabledBeforePrintOrPreview", "scriptEnabledBeforePrintOrPreview"),
    Atom("scrollbar", "scrollbar"),
    Atom("scrollbarbutton", "scrollbarbutton"),
    Atom("scrollbarDownBottom", "scrollbar-down-bottom"),
    Atom("scrollbarDownTop", "scrollbar-down-top"),
    Atom("scrollbarUpBottom", "scrollbar-up-bottom"),
    Atom("scrollbarUpTop", "scrollbar-up-top"),
    Atom("scrollbox", "scrollbox"),
    Atom("scrollcorner", "scrollcorner"),
    Atom("scrolling", "scrolling"),
    Atom("scrollPosition", "scroll-position"),
    Atom("section", "section"),
    Atom("select", "select"),
    Atom("selectable", "selectable"),
    Atom("selected", "selected"),
    Atom("selectedIndex", "selectedIndex"),
    Atom("selectedindex", "selectedindex"),
    Atom("self", "self"),
    Atom("seltype", "seltype"),
    Atom("setcookie", "set-cookie"),
    Atom("setter", "setter"),
    Atom("shape", "shape"),
    Atom("show", "show"),
    Atom("showcaret", "showcaret"),
    Atom("showresizer", "showresizer"),
    Atom("simple", "simple"),
    Atom("simp_chinese_formal", "simp-chinese-formal"),
    Atom("simp_chinese_informal", "simp-chinese-informal"),
    Atom("single", "single"),
    Atom("size", "size"),
    Atom("sizes", "sizes"),
    Atom("sizemode", "sizemode"),
    Atom("sizetopopup", "sizetopopup"),
    Atom("slider", "slider"),
    Atom("small", "small"),
    Atom("smooth", "smooth"),
    Atom("snap", "snap"),
    Atom("sort", "sort"),
    Atom("sortActive", "sortActive"),
    Atom("sortDirection", "sortDirection"),
    Atom("sorted", "sorted"),
    Atom("sorthints", "sorthints"),
    Atom("source", "source"),
    Atom("space", "space"),
    Atom("spacer", "spacer"),
    Atom("span", "span"),
    Atom("spellcheck", "spellcheck"),
    Atom("split", "split"),
    Atom("splitter", "splitter"),
    Atom("spring", "spring"),
    Atom("square", "square"),
    Atom("src", "src"),
    Atom("srcdoc", "srcdoc"),
    Atom("srclang", "srclang"),
    Atom("srcset", "srcset"),
    Atom("standalone", "standalone"),
    Atom("standby", "standby"),
    Atom("start", "start"),
    Atom("startsWith", "starts-with"),
    Atom("state", "state"),
    Atom("statusbar", "statusbar"),
    Atom("step", "step"),
    Atom("stop", "stop"),
    Atom("stretch", "stretch"),
    Atom("strike", "strike"),
    Atom("string", "string"),
    Atom("stringLength", "string-length"),
    Atom("stripSpace", "strip-space"),
    Atom("strong", "strong"),
    Atom("style", "style"),
    Atom("stylesheet", "stylesheet"),
    Atom("stylesheetPrefix", "stylesheet-prefix"),
    Atom("submit", "submit"),
    Atom("substate", "substate"),
    Atom("substring", "substring"),
    Atom("substringAfter", "substring-after"),
    Atom("substringBefore", "substring-before"),
    Atom("sub", "sub"),
    Atom("sum", "sum"),
    Atom("sup", "sup"),
    Atom("summary", "summary"),
    # Atom("_switch", "switch"),  # "switch" is present below
    Atom("systemProperty", "system-property"),
    Atom("tab", "tab"),
    Atom("tabindex", "tabindex"),
    Atom("table", "table"),
    Atom("tabpanel", "tabpanel"),
    Atom("tabpanels", "tabpanels"),
    Atom("tag", "tag"),
    Atom("target", "target"),
    Atom("targets", "targets"),
    Atom("tbody", "tbody"),
    Atom("td", "td"),
    Atom("_template", "template"),
    Atom("text_decoration", "text-decoration"),
    Atom("terminate", "terminate"),
    Atom("term", "term"),
    Atom("test", "test"),
    Atom("text", "text"),
    Atom("textAlign", "text-align"),
    Atom("textarea", "textarea"),
    Atom("textbox", "textbox"),
    Atom("textNodeDirectionalityMap", "textNodeDirectionalityMap"),
    Atom("tfoot", "tfoot"),
    Atom("th", "th"),
    Atom("thead", "thead"),
    Atom("thumb", "thumb"),
    Atom("time", "time"),
    Atom("title", "title"),
    Atom("titlebar", "titlebar"),
    Atom("titletip", "titletip"),
    Atom("token", "token"),
    Atom("tokenize", "tokenize"),
    Atom("toolbar", "toolbar"),
    Atom("toolbarbutton", "toolbarbutton"),
    Atom("toolbaritem", "toolbaritem"),
    Atom("toolbarpaletteitem", "toolbarpaletteitem"),
    Atom("toolbox", "toolbox"),
    Atom("tooltip", "tooltip"),
    Atom("tooltiptext", "tooltiptext"),
    Atom("top", "top"),
    Atom("topleft", "topleft"),
    Atom("topmargin", "topmargin"),
    Atom("topright", "topright"),
    Atom("tr", "tr"),
    Atom("track", "track"),
    Atom("trad_chinese_formal", "trad-chinese-formal"),
    Atom("trad_chinese_informal", "trad-chinese-informal"),
    Atom("trailing", "trailing"),
    Atom("transform", "transform"),
    Atom("transform_3d", "transform-3d"),
    Atom("transformiix", "transformiix"),
    Atom("translate", "translate"),
    Atom("transparent", "transparent"),
    Atom("tree", "tree"),
    Atom("treecell", "treecell"),
    Atom("treechildren", "treechildren"),
    Atom("treecol", "treecol"),
    Atom("treecolpicker", "treecolpicker"),
    Atom("treecols", "treecols"),
    Atom("treeitem", "treeitem"),
    Atom("treerow", "treerow"),
    Atom("treeseparator", "treeseparator"),
    Atom("_true", "true"),
    Atom("tt", "tt"),
    Atom("type", "type"),
    Atom("typemustmatch", "typemustmatch"),
    Atom("u", "u"),
    Atom("ul", "ul"),
    Atom("undetermined", "undetermined"),
    Atom("unparsedEntityUri", "unparsed-entity-uri"),
    Atom("upperAlpha", "upper-alpha"),
    Atom("upperFirst", "upper-first"),
    Atom("upperRoman", "upper-roman"),
    Atom("use", "use"),
    Atom("useAttributeSets", "use-attribute-sets"),
    Atom("usemap", "usemap"),
    Atom("user_scalable", "user-scalable"),
    Atom("validate", "validate"),
    Atom("valign", "valign"),
    Atom("value", "value"),
    Atom("values", "values"),
    Atom("valueOf", "value-of"),
    Atom("valuetype", "valuetype"),
    Atom("var", "var"),
    Atom("variable", "variable"),
    Atom("vendor", "vendor"),
    Atom("vendorUrl", "vendor-url"),
    Atom("version", "version"),
    Atom("vertical", "vertical"),
    Atom("audio", "audio"),
    Atom("video", "video"),
    Atom("videocontrols", "videocontrols"),
    Atom("viewport", "viewport"),
    Atom("viewport_height", "viewport-height"),
    Atom("viewport_initial_scale", "viewport-initial-scale"),
    Atom("viewport_maximum_scale", "viewport-maximum-scale"),
    Atom("viewport_minimum_scale", "viewport-minimum-scale"),
    Atom("viewport_user_scalable", "viewport-user-scalable"),
    Atom("viewport_width", "viewport-width"),
    Atom("visibility", "visibility"),
    Atom("visuallyselected", "visuallyselected"),
    Atom("vlink", "vlink"),
    Atom("vspace", "vspace"),
    Atom("wbr", "wbr"),
    Atom("webkitdirectory", "webkitdirectory"),
    Atom("when", "when"),
    Atom("width", "width"),
    Atom("willChange", "will-change"),
    Atom("window", "window"),
    Atom("headerWindowTarget", "window-target"),
    Atom("windowtype", "windowtype"),
    Atom("withParam", "with-param"),
    Atom("wizard", "wizard"),
    Atom("wrap", "wrap"),
    Atom("headerDNSPrefetchControl", "x-dns-prefetch-control"),
    Atom("headerCSP", "content-security-policy"),
    Atom("headerCSPReportOnly", "content-security-policy-report-only"),
    Atom("headerXFO", "x-frame-options"),
    Atom("x_western", "x-western"),
    Atom("xml", "xml"),
    Atom("xml_stylesheet", "xml-stylesheet"),
    Atom("xmlns", "xmlns"),
    Atom("xmp", "xmp"),
    Atom("yes", "yes"),
    Atom("z_index", "z-index"),
    Atom("zeroDigit", "zero-digit"),
    Atom("zlevel", "zlevel"),


    Atom("percentage", "%"),
    Atom("A", "A"),
    Atom("alignment_baseline", "alignment-baseline"),
    Atom("amplitude", "amplitude"),
    Atom("animate", "animate"),
    Atom("animateColor", "animateColor"),
    Atom("animateMotion", "animateMotion"),
    Atom("animateTransform", "animateTransform"),
    Atom("arithmetic", "arithmetic"),
    Atom("atop", "atop"),
    Atom("azimuth", "azimuth"),
    Atom("B", "B"),
    Atom("backgroundColor", "background-color"),
    Atom("background_image", "background-image"),
    Atom("baseFrequency", "baseFrequency"),
    Atom("baseline_shift", "baseline-shift"),
    Atom("bias", "bias"),
    Atom("caption_side", "caption-side"),
    Atom("clip_path", "clip-path"),
    Atom("clip_rule", "clip-rule"),
    Atom("clipPath", "clipPath"),
    Atom("clipPathUnits", "clipPathUnits"),
    Atom("cm", "cm"),
    Atom("colorBurn", "color-burn"),
    Atom("colorDodge", "color-dodge"),
    Atom("colorInterpolation", "color-interpolation"),
    Atom("colorInterpolationFilters", "color-interpolation-filters"),
    Atom("colorpicker", "colorpicker"),
    Atom("colorProfile", "color-profile"),
    Atom("cursor", "cursor"),
    Atom("cx", "cx"),
    Atom("cy", "cy"),
    Atom("d", "d"),
    Atom("darken", "darken"),
    Atom("defs", "defs"),
    Atom("deg", "deg"),
    Atom("desc", "desc"),
    Atom("diffuseConstant", "diffuseConstant"),
    Atom("dilate", "dilate"),
    Atom("direction", "direction"),
    Atom("disable", "disable"),
    Atom("disc", "disc"),
    Atom("discrete", "discrete"),
    Atom("divisor", "divisor"),
    Atom("dominant_baseline", "dominant-baseline"),
    Atom("duplicate", "duplicate"),
    Atom("dx", "dx"),
    Atom("dy", "dy"),
    Atom("edgeMode", "edgeMode"),
    Atom("ellipse", "ellipse"),
    Atom("elevation", "elevation"),
    Atom("erode", "erode"),
    Atom("ex", "ex"),
    Atom("exact", "exact"),
    Atom("exclusion", "exclusion"),
    Atom("exponent", "exponent"),
    Atom("feBlend", "feBlend"),
    Atom("feColorMatrix", "feColorMatrix"),
    Atom("feComponentTransfer", "feComponentTransfer"),
    Atom("feComposite", "feComposite"),
    Atom("feConvolveMatrix", "feConvolveMatrix"),
    Atom("feDiffuseLighting", "feDiffuseLighting"),
    Atom("feDisplacementMap", "feDisplacementMap"),
    Atom("feDistantLight", "feDistantLight"),
    Atom("feDropShadow", "feDropShadow"),
    Atom("feFlood", "feFlood"),
    Atom("feFuncA", "feFuncA"),
    Atom("feFuncB", "feFuncB"),
    Atom("feFuncG", "feFuncG"),
    Atom("feFuncR", "feFuncR"),
    Atom("feGaussianBlur", "feGaussianBlur"),
    Atom("feImage", "feImage"),
    Atom("feMerge", "feMerge"),
    Atom("feMergeNode", "feMergeNode"),
    Atom("feMorphology", "feMorphology"),
    Atom("feOffset", "feOffset"),
    Atom("fePointLight", "fePointLight"),
    Atom("feSpecularLighting", "feSpecularLighting"),
    Atom("feSpotLight", "feSpotLight"),
    Atom("feTile", "feTile"),
    Atom("feTurbulence", "feTurbulence"),
    Atom("fill", "fill"),
    Atom("fill_opacity", "fill-opacity"),
    Atom("fill_rule", "fill-rule"),
    Atom("filter", "filter"),
    Atom("filterUnits", "filterUnits"),
    Atom("_float", "float"),
    Atom("flood_color", "flood-color"),
    Atom("flood_opacity", "flood-opacity"),
    Atom("font_face", "font-face"),
    Atom("font_face_format", "font-face-format"),
    Atom("font_face_name", "font-face-name"),
    Atom("font_face_src", "font-face-src"),
    Atom("font_face_uri", "font-face-uri"),
    Atom("font_family", "font-family"),
    Atom("font_size", "font-size"),
    Atom("font_size_adjust", "font-size-adjust"),
    Atom("font_stretch", "font-stretch"),
    Atom("font_style", "font-style"),
    Atom("font_variant", "font-variant"),
    Atom("foreignObject", "foreignObject"),
    Atom("fractalNoise", "fractalNoise"),
    Atom("fr", "fr"),
    Atom("fx", "fx"),
    Atom("fy", "fy"),
    Atom("G", "G"),
    Atom("g", "g"),
    Atom("gamma", "gamma"),
    # 'generic' conflicts with msvc11 winrt compiler extensions
    Atom("generic_", "generic"),
    Atom("glyphRef", "glyphRef"),
    Atom("grad", "grad"),
    Atom("gradientTransform", "gradientTransform"),
    Atom("gradientUnits", "gradientUnits"),
    Atom("hardLight", "hard-light"),
    Atom("hue", "hue"),
    Atom("hueRotate", "hueRotate"),
    Atom("identity", "identity"),
    Atom("image_rendering", "image-rendering"),
    Atom("in", "in"),
    Atom("in2", "in2"),
    Atom("intercept", "intercept"),
    Atom("k1", "k1"),
    Atom("k2", "k2"),
    Atom("k3", "k3"),
    Atom("k4", "k4"),
    Atom("kernelMatrix", "kernelMatrix"),
    Atom("kernelUnitLength", "kernelUnitLength"),
    Atom("lengthAdjust", "lengthAdjust"),
    Atom("letter_spacing", "letter-spacing"),
    Atom("lighten", "lighten"),
    Atom("lighting_color", "lighting-color"),
    Atom("limitingConeAngle", "limitingConeAngle"),
    Atom("linear", "linear"),
    Atom("linearGradient", "linearGradient"),
    Atom("list_style_type", "list-style-type"),
    Atom("luminanceToAlpha", "luminanceToAlpha"),
    Atom("luminosity", "luminosity"),
    Atom("magnify", "magnify"),
    Atom("marker", "marker"),
    Atom("marker_end", "marker-end"),
    Atom("marker_mid", "marker-mid"),
    Atom("marker_start", "marker-start"),
    Atom("markerHeight", "markerHeight"),
    Atom("markerUnits", "markerUnits"),
    Atom("markerWidth", "markerWidth"),
    Atom("mask", "mask"),
    Atom("maskContentUnits", "maskContentUnits"),
    Atom("mask_type", "mask-type"),
    Atom("maskUnits", "maskUnits"),
    Atom("matrix", "matrix"),
    Atom("metadata", "metadata"),
    Atom("missingGlyph", "missing-glyph"),
    Atom("mm", "mm"),
    Atom("mpath", "mpath"),
    Atom("noStitch", "noStitch"),
    Atom("numOctaves", "numOctaves"),
    Atom("multiply", "multiply"),
    Atom("objectBoundingBox", "objectBoundingBox"),
    Atom("offset", "offset"),
    Atom("onSVGLoad", "onSVGLoad"),
    Atom("onSVGResize", "onSVGResize"),
    Atom("onSVGScroll", "onSVGScroll"),
    Atom("onSVGUnload", "onSVGUnload"),
    Atom("onSVGZoom", "onSVGZoom"),
    Atom("onzoom", "onzoom"),
    Atom("opacity", "opacity"),
    Atom("_operator", "operator"),
    Atom("out", "out"),
    Atom("over", "over"),
    Atom("overridePreserveAspectRatio", "overridePreserveAspectRatio"),
    Atom("pad", "pad"),
    Atom("path", "path"),
    Atom("pathLength", "pathLength"),
    Atom("patternContentUnits", "patternContentUnits"),
    Atom("patternTransform", "patternTransform"),
    Atom("patternUnits", "patternUnits"),
    Atom("pc", "pc"),
    Atom("pointer_events", "pointer-events"),
    Atom("points", "points"),
    Atom("pointsAtX", "pointsAtX"),
    Atom("pointsAtY", "pointsAtY"),
    Atom("pointsAtZ", "pointsAtZ"),
    Atom("polyline", "polyline"),
    Atom("preserveAlpha", "preserveAlpha"),
    Atom("preserveAspectRatio", "preserveAspectRatio"),
    Atom("primitiveUnits", "primitiveUnits"),
    Atom("pt", "pt"),
    Atom("px", "px"),
    Atom("R", "R"),
    Atom("r", "r"),
    Atom("rad", "rad"),
    Atom("radialGradient", "radialGradient"),
    Atom("radius", "radius"),
    Atom("reflect", "reflect"),
    Atom("refX", "refX"),
    Atom("refY", "refY"),
    Atom("requiredExtensions", "requiredExtensions"),
    Atom("requiredFeatures", "requiredFeatures"),
    Atom("rotate", "rotate"),
    Atom("rx", "rx"),
    Atom("ry", "ry"),
    Atom("saturate", "saturate"),
    Atom("saturation", "saturation"),
    Atom("set", "set"),
    Atom("seed", "seed"),
    Atom("shape_rendering", "shape-rendering"),
    Atom("simpleScopeChain", "simpleScopeChain"),
    Atom("skewX", "skewX"),
    Atom("skewY", "skewY"),
    Atom("slope", "slope"),
    Atom("slot", "slot"),
    Atom("softLight", "soft-light"),
    Atom("spacing", "spacing"),
    Atom("spacingAndGlyphs", "spacingAndGlyphs"),
    Atom("specularConstant", "specularConstant"),
    Atom("specularExponent", "specularExponent"),
    Atom("spreadMethod", "spreadMethod"),
    Atom("startOffset", "startOffset"),
    Atom("stdDeviation", "stdDeviation"),
    Atom("stitch", "stitch"),
    Atom("stitchTiles", "stitchTiles"),
    Atom("stop_color", "stop-color"),
    Atom("stop_opacity", "stop-opacity"),
    Atom("stroke", "stroke"),
    Atom("stroke_dasharray", "stroke-dasharray"),
    Atom("stroke_dashoffset", "stroke-dashoffset"),
    Atom("stroke_linecap", "stroke-linecap"),
    Atom("stroke_linejoin", "stroke-linejoin"),
    Atom("stroke_miterlimit", "stroke-miterlimit"),
    Atom("stroke_opacity", "stroke-opacity"),
    Atom("stroke_width", "stroke-width"),
    Atom("strokeWidth", "strokeWidth"),
    Atom("surfaceScale", "surfaceScale"),
    Atom("svg", "svg"),
    Atom("svgSwitch", "switch"),
    Atom("symbol", "symbol"),
    Atom("systemLanguage", "systemLanguage"),
    Atom("tableValues", "tableValues"),
    Atom("targetX", "targetX"),
    Atom("targetY", "targetY"),
    Atom("text_anchor", "text-anchor"),
    Atom("text_rendering", "text-rendering"),
    Atom("textLength", "textLength"),
    Atom("textPath", "textPath"),
    Atom("tref", "tref"),
    Atom("tspan", "tspan"),
    Atom("turbulence", "turbulence"),
    Atom("unicode_bidi", "unicode-bidi"),
    Atom("userSpaceOnUse", "userSpaceOnUse"),
    Atom("view", "view"),
    Atom("viewBox", "viewBox"),
    Atom("viewTarget", "viewTarget"),
    Atom("white_space", "white-space"),
    Atom("word_spacing", "word-spacing"),
    Atom("writing_mode", "writing-mode"),
    Atom("x", "x"),
    Atom("x1", "x1"),
    Atom("x2", "x2"),
    Atom("xChannelSelector", "xChannelSelector"),
    Atom("xor_", "xor"),
    Atom("y", "y"),
    Atom("y1", "y1"),
    Atom("y2", "y2"),
    Atom("yChannelSelector", "yChannelSelector"),
    Atom("z", "z"),
    Atom("zoomAndPan", "zoomAndPan"),
    Atom("vector_effect", "vector-effect"),
    Atom("vertical_align", "vertical-align"),

    Atom("accumulate", "accumulate"),
    Atom("additive", "additive"),
    Atom("attributeName", "attributeName"),
    Atom("attributeType", "attributeType"),
    Atom("auto_reverse", "auto-reverse"),
    Atom("begin", "begin"),
    Atom("beginEvent", "beginEvent"),
    Atom("by", "by"),
    Atom("calcMode", "calcMode"),
    Atom("dur", "dur"),
    Atom("keyPoints", "keyPoints"),
    Atom("keySplines", "keySplines"),
    Atom("keyTimes", "keyTimes"),
    Atom("mozAnimateMotionDummyAttr", "_mozAnimateMotionDummyAttr"),
    Atom("onbegin", "onbegin"),
    Atom("onbeginEvent", "onbeginEvent"),
    Atom("onend", "onend"),
    Atom("onendEvent", "onendEvent"),
    Atom("onrepeat", "onrepeat"),
    Atom("onrepeatEvent", "onrepeatEvent"),
    Atom("repeatCount", "repeatCount"),
    Atom("repeatDur", "repeatDur"),
    Atom("repeatEvent", "repeatEvent"),
    Atom("restart", "restart"),
    Atom("to", "to"),

    Atom("abs_", "abs"),
    Atom("accent_", "accent"),
    Atom("accentunder_", "accentunder"),
    Atom("actiontype_", "actiontype"),
    Atom("alignmentscope_", "alignmentscope"),
    Atom("altimg_", "altimg"),
    Atom("altimg_height_", "altimg-height"),
    Atom("altimg_valign_", "altimg-valign"),
    Atom("altimg_width_", "altimg-width"),
    Atom("annotation_", "annotation"),
    Atom("annotation_xml_", "annotation-xml"),
    Atom("apply_", "apply"),
    Atom("approx_", "approx"),
    Atom("arccos_", "arccos"),
    Atom("arccosh_", "arccosh"),
    Atom("arccot_", "arccot"),
    Atom("arccoth_", "arccoth"),
    Atom("arccsc_", "arccsc"),
    Atom("arccsch_", "arccsch"),
    Atom("arcsec_", "arcsec"),
    Atom("arcsech_", "arcsech"),
    Atom("arcsin_", "arcsin"),
    Atom("arcsinh_", "arcsinh"),
    Atom("arctan_", "arctan"),
    Atom("arctanh_", "arctanh"),
    Atom("arg_", "arg"),
    Atom("bevelled_", "bevelled"),
    Atom("bind_", "bind"),
    Atom("bvar_", "bvar"),
    Atom("card_", "card"),
    Atom("cartesianproduct_", "cartesianproduct"),
    Atom("cbytes_", "cbytes"),
    Atom("cd_", "cd"),
    Atom("cdgroup_", "cdgroup"),
    Atom("cerror_", "cerror"),
    Atom("charalign_", "charalign"),
    Atom("ci_", "ci"),
    Atom("closure_", "closure"),
    Atom("cn_", "cn"),
    Atom("codomain_", "codomain"),
    Atom("columnalign_", "columnalign"),
    Atom("columnalignment_", "columnalignment"),
    Atom("columnlines_", "columnlines"),
    Atom("columnspacing_", "columnspacing"),
    Atom("columnspan_", "columnspan"),
    Atom("columnwidth_", "columnwidth"),
    Atom("complexes_", "complexes"),
    Atom("compose_", "compose"),
    Atom("condition_", "condition"),
    Atom("conjugate_", "conjugate"),
    Atom("cos_", "cos"),
    Atom("cosh_", "cosh"),
    Atom("cot_", "cot"),
    Atom("coth_", "coth"),
    Atom("crossout_", "crossout"),
    Atom("csc_", "csc"),
    Atom("csch_", "csch"),
    Atom("cs_", "cs"),
    Atom("csymbol_", "csymbol"),
    Atom("curl_", "curl"),
    Atom("decimalpoint_", "decimalpoint"),
    Atom("definitionURL_", "definitionURL"),
    Atom("degree_", "degree"),
    Atom("denomalign_", "denomalign"),
    Atom("depth_", "depth"),
    Atom("determinant_", "determinant"),
    Atom("diff_", "diff"),
    Atom("displaystyle_", "displaystyle"),
    Atom("divergence_", "divergence"),
    Atom("divide_", "divide"),
    Atom("domain_", "domain"),
    Atom("domainofapplication_", "domainofapplication"),
    Atom("edge_", "edge"),
    Atom("el", "el"),
    Atom("emptyset_", "emptyset"),
    Atom("eq_", "eq"),
    Atom("equalcolumns_", "equalcolumns"),
    Atom("equalrows_", "equalrows"),
    Atom("equivalent_", "equivalent"),
    Atom("eulergamma_", "eulergamma"),
    Atom("exists_", "exists"),
    Atom("exp_", "exp"),
    Atom("exponentiale_", "exponentiale"),
    Atom("factorial_", "factorial"),
    Atom("factorof_", "factorof"),
    Atom("fence_", "fence"),
    Atom("fn_", "fn"),
    Atom("fontfamily_", "fontfamily"),
    Atom("fontsize_", "fontsize"),
    Atom("fontstyle_", "fontstyle"),
    Atom("fontweight_", "fontweight"),
    Atom("forall_", "forall"),
    Atom("framespacing_", "framespacing"),
    Atom("gcd_", "gcd"),
    Atom("geq_", "geq"),
    Atom("groupalign_", "groupalign"),
    Atom("gt_", "gt"),
    Atom("ident_", "ident"),
    Atom("imaginaryi_", "imaginaryi"),
    Atom("imaginary_", "imaginary"),
    Atom("implies_", "implies"),
    Atom("indentalignfirst_", "indentalignfirst"),
    Atom("indentalign_", "indentalign"),
    Atom("indentalignlast_", "indentalignlast"),
    Atom("indentshiftfirst_", "indentshiftfirst"),
    Atom("indentshift_", "indentshift"),
    Atom("indenttarget_", "indenttarget"),
    Atom("integers_", "integers"),
    Atom("intersect_", "intersect"),
    Atom("interval_", "interval"),
    Atom("int_", "int"),
    Atom("inverse_", "inverse"),
    Atom("lambda_", "lambda"),
    Atom("laplacian_", "laplacian"),
    Atom("largeop_", "largeop"),
    Atom("lcm_", "lcm"),
    Atom("leq_", "leq"),
    Atom("limit_", "limit"),
    Atom("linebreak_", "linebreak"),
    Atom("linebreakmultchar_", "linebreakmultchar"),
    Atom("linebreakstyle_", "linebreakstyle"),
    Atom("linethickness_", "linethickness"),
    Atom("list_", "list"),
    Atom("ln_", "ln"),
    Atom("location_", "location"),
    Atom("logbase_", "logbase"),
    Atom("log_", "log"),
    Atom("longdivstyle_", "longdivstyle"),
    Atom("lowlimit_", "lowlimit"),
    Atom("lquote_", "lquote"),
    Atom("lspace_", "lspace"),
    Atom("lt_", "lt"),
    Atom("maction_", "maction"),
    Atom("maligngroup_", "maligngroup"),
    Atom("malignmark_", "malignmark"),
    Atom("mathbackground_", "mathbackground"),
    Atom("mathcolor_", "mathcolor"),
    Atom("mathsize_", "mathsize"),
    Atom("mathvariant_", "mathvariant"),
    Atom("matrixrow_", "matrixrow"),
    Atom("maxsize_", "maxsize"),
    Atom("mean_", "mean"),
    Atom("median_", "median"),
    Atom("menclose_", "menclose"),
    Atom("merror_", "merror"),
    Atom("mfenced_", "mfenced"),
    Atom("mfrac_", "mfrac"),
    Atom("mglyph_", "mglyph"),
    Atom("mi_", "mi"),
    Atom("minlabelspacing_", "minlabelspacing"),
    Atom("minsize_", "minsize"),
    Atom("minus_", "minus"),
    Atom("mlabeledtr_", "mlabeledtr"),
    Atom("mlongdiv_", "mlongdiv"),
    Atom("mmultiscripts_", "mmultiscripts"),
    Atom("mn_", "mn"),
    Atom("momentabout_", "momentabout"),
    Atom("moment_", "moment"),
    Atom("mo_", "mo"),
    Atom("movablelimits_", "movablelimits"),
    Atom("mover_", "mover"),
    Atom("mpadded_", "mpadded"),
    Atom("mphantom_", "mphantom"),
    Atom("mprescripts_", "mprescripts"),
    Atom("mroot_", "mroot"),
    Atom("mrow_", "mrow"),
    Atom("mscarries_", "mscarries"),
    Atom("mscarry_", "mscarry"),
    Atom("msgroup_", "msgroup"),
    Atom("msline_", "msline"),
    Atom("ms_", "ms"),
    Atom("mspace_", "mspace"),
    Atom("msqrt_", "msqrt"),
    Atom("msrow_", "msrow"),
    Atom("mstack_", "mstack"),
    Atom("mstyle_", "mstyle"),
    Atom("msub_", "msub"),
    Atom("msubsup_", "msubsup"),
    Atom("msup_", "msup"),
    Atom("mtable_", "mtable"),
    Atom("mtd_", "mtd"),
    Atom("mtext_", "mtext"),
    Atom("mtr_", "mtr"),
    Atom("munder_", "munder"),
    Atom("munderover_", "munderover"),
    Atom("naturalnumbers_", "naturalnumbers"),
    Atom("neq_", "neq"),
    Atom("notanumber_", "notanumber"),
    Atom("notation_", "notation"),
    Atom("note_", "note"),
    Atom("notin_", "notin"),
    Atom("notprsubset_", "notprsubset"),
    Atom("notsubset_", "notsubset"),
    Atom("numalign_", "numalign"),
    Atom("other", "other"),
    Atom("outerproduct_", "outerproduct"),
    Atom("partialdiff_", "partialdiff"),
    Atom("piece_", "piece"),
    Atom("piecewise_", "piecewise"),
    Atom("pi_", "pi"),
    Atom("plus_", "plus"),
    Atom("power_", "power"),
    Atom("primes_", "primes"),
    Atom("product_", "product"),
    Atom("prsubset_", "prsubset"),
    Atom("quotient_", "quotient"),
    Atom("rationals_", "rationals"),
    Atom("real_", "real"),
    Atom("reals_", "reals"),
    Atom("reln_", "reln"),
    Atom("root_", "root"),
    Atom("rowalign_", "rowalign"),
    Atom("rowlines_", "rowlines"),
    Atom("rowspacing_", "rowspacing"),
    Atom("rquote_", "rquote"),
    Atom("rspace_", "rspace"),
    Atom("scalarproduct_", "scalarproduct"),
    Atom("schemaLocation_", "schemaLocation"),
    Atom("scriptlevel_", "scriptlevel"),
    Atom("scriptminsize_", "scriptminsize"),
    Atom("scriptsizemultiplier_", "scriptsizemultiplier"),
    Atom("scriptsize_", "scriptsize"),
    Atom("sdev_", "sdev"),
    Atom("sech_", "sech"),
    Atom("sec_", "sec"),
    Atom("selection_", "selection"),
    Atom("selector_", "selector"),
    Atom("semantics_", "semantics"),
    Atom("separator_", "separator"),
    Atom("separators_", "separators"),
    Atom("sep_", "sep"),
    Atom("setdiff_", "setdiff"),
    # Atom("set_", "set"),  # "set" is present above
    Atom("share_", "share"),
    Atom("shift_", "shift"),
    Atom("side_", "side"),
    Atom("sinh_", "sinh"),
    Atom("sin_", "sin"),
    Atom("stackalign_", "stackalign"),
    Atom("stretchy_", "stretchy"),
    Atom("subscriptshift_", "subscriptshift"),
    Atom("subset_", "subset"),
    Atom("superscriptshift_", "superscriptshift"),
    Atom("symmetric_", "symmetric"),
    Atom("tanh_", "tanh"),
    Atom("tan_", "tan"),
    Atom("tendsto_", "tendsto"),
    Atom("times_", "times"),
    Atom("transpose_", "transpose"),
    Atom("union_", "union"),
    Atom("uplimit_", "uplimit"),
    Atom("variance_", "variance"),
    Atom("vectorproduct_", "vectorproduct"),
    Atom("vector_", "vector"),
    Atom("voffset_", "voffset"),
    Atom("xref_", "xref"),
    Atom("math", "math"),  # the only one without an underscore
    Atom("booleanFromString", "boolean-from-string"),
    Atom("countNonEmpty", "count-non-empty"),
    Atom("daysFromDate", "days-from-date"),
    Atom("secondsFromDateTime", "seconds-from-dateTime"),

    # Simple gestures support
    Atom("onMozSwipeGestureMayStart", "onMozSwipeGestureMayStart"),
    Atom("onMozSwipeGestureStart", "onMozSwipeGestureStart"),
    Atom("onMozSwipeGestureUpdate", "onMozSwipeGestureUpdate"),
    Atom("onMozSwipeGestureEnd", "onMozSwipeGestureEnd"),
    Atom("onMozSwipeGesture", "onMozSwipeGesture"),
    Atom("onMozMagnifyGestureStart", "onMozMagnifyGestureStart"),
    Atom("onMozMagnifyGestureUpdate", "onMozMagnifyGestureUpdate"),
    Atom("onMozMagnifyGesture", "onMozMagnifyGesture"),
    Atom("onMozRotateGestureStart", "onMozRotateGestureStart"),
    Atom("onMozRotateGestureUpdate", "onMozRotateGestureUpdate"),
    Atom("onMozRotateGesture", "onMozRotateGesture"),
    Atom("onMozTapGesture", "onMozTapGesture"),
    Atom("onMozPressTapGesture", "onMozPressTapGesture"),
    Atom("onMozEdgeUIStarted", "onMozEdgeUIStarted"),
    Atom("onMozEdgeUICanceled", "onMozEdgeUICanceled"),
    Atom("onMozEdgeUICompleted", "onMozEdgeUICompleted"),

    # Pointer events
    Atom("onpointerdown", "onpointerdown"),
    Atom("onpointermove", "onpointermove"),
    Atom("onpointerup", "onpointerup"),
    Atom("onpointercancel", "onpointercancel"),
    Atom("onpointerover", "onpointerover"),
    Atom("onpointerout", "onpointerout"),
    Atom("onpointerenter", "onpointerenter"),
    Atom("onpointerleave", "onpointerleave"),
    Atom("ongotpointercapture", "ongotpointercapture"),
    Atom("onlostpointercapture", "onlostpointercapture"),

    # orientation support
    Atom("ondevicemotion", "ondevicemotion"),
    Atom("ondeviceorientation", "ondeviceorientation"),
    Atom("onabsolutedeviceorientation", "onabsolutedeviceorientation"),
    Atom("ondeviceproximity", "ondeviceproximity"),
    Atom("onmozorientationchange", "onmozorientationchange"),
    Atom("onuserproximity", "onuserproximity"),

    # light sensor support
    Atom("ondevicelight", "ondevicelight"),

    # MediaDevices device change event
    Atom("ondevicechange", "ondevicechange"),

    # WebExtensions
    Atom("moz_extension", "moz-extension"),
    Atom("all_urlsPermission", "<all_urls>"),
    Atom("clipboardRead", "clipboardRead"),
    Atom("clipboardWrite", "clipboardWrite"),
    Atom("debugger", "debugger"),
    Atom("mozillaAddons", "mozillaAddons"),
    Atom("tabs", "tabs"),
    Atom("webRequestBlocking", "webRequestBlocking"),
    Atom("http", "http"),
    Atom("https", "https"),
    Atom("proxy", "proxy"),

    # --------------------------------------------------------------------------
    # Special atoms
    # --------------------------------------------------------------------------

    # Node types
    Atom("cdataTagName", "#cdata-section"),
    Atom("commentTagName", "#comment"),
    Atom("documentNodeName", "#document"),
    Atom("documentFragmentNodeName", "#document-fragment"),
    Atom("documentTypeNodeName", "#document-type"),
    Atom("processingInstructionTagName", "#processing-instruction"),
    Atom("textTagName", "#text"),

    # Frame types
    #
    # TODO(emilio): Rename this? This is only used now to mark the style context of
    # the placeholder with a dummy pseudo.
    Atom("placeholderFrame", "PlaceholderFrame"),

    Atom("onloadend", "onloadend"),
    Atom("onloadstart", "onloadstart"),
    Atom("onprogress", "onprogress"),
    Atom("onsuspend", "onsuspend"),
    Atom("onemptied", "onemptied"),
    Atom("onstalled", "onstalled"),
    Atom("onplay", "onplay"),
    Atom("onpause", "onpause"),
    Atom("onloadedmetadata", "onloadedmetadata"),
    Atom("onloadeddata", "onloadeddata"),
    Atom("onwaiting", "onwaiting"),
    Atom("onplaying", "onplaying"),
    Atom("oncanplay", "oncanplay"),
    Atom("oncanplaythrough", "oncanplaythrough"),
    Atom("onseeking", "onseeking"),
    Atom("onseeked", "onseeked"),
    Atom("ontimeout", "ontimeout"),
    Atom("ontimeupdate", "ontimeupdate"),
    Atom("onended", "onended"),
    Atom("onratechange", "onratechange"),
    Atom("ondurationchange", "ondurationchange"),
    Atom("onvolumechange", "onvolumechange"),
    Atom("onaddtrack", "onaddtrack"),
    Atom("oncontrollerchange", "oncontrollerchange"),
    Atom("oncuechange", "oncuechange"),
    Atom("onenter", "onenter"),
    Atom("onexit", "onexit"),
    Atom("onencrypted", "onencrypted"),
    Atom("onwaitingforkey", "onwaitingforkey"),
    Atom("onkeystatuseschange", "onkeystatuseschange"),
    Atom("onremovetrack", "onremovetrack"),
    Atom("loadstart", "loadstart"),
    Atom("suspend", "suspend"),
    Atom("emptied", "emptied"),
    Atom("play", "play"),
    Atom("pause", "pause"),
    Atom("loadedmetadata", "loadedmetadata"),
    Atom("loadeddata", "loadeddata"),
    Atom("waiting", "waiting"),
    Atom("playing", "playing"),
    Atom("timeupdate", "timeupdate"),
    Atom("canplay", "canplay"),
    Atom("canplaythrough", "canplaythrough"),
    Atom("ondataavailable", "ondataavailable"),
    Atom("onwarning", "onwarning"),
    Atom("onstart", "onstart"),
    Atom("onstop", "onstop"),
    Atom("onphoto", "onphoto"),
    Atom("ongamepadbuttondown", "ongamepadbuttondown"),
    Atom("ongamepadbuttonup", "ongamepadbuttonup"),
    Atom("ongamepadaxismove", "ongamepadaxismove"),
    Atom("ongamepadconnected", "ongamepadconnected"),
    Atom("ongamepaddisconnected", "ongamepaddisconnected"),
    Atom("onfetch", "onfetch"),

    # Content property names
    Atom("afterPseudoProperty", "afterPseudoProperty"),  # nsXMLElement*
    Atom("animationsProperty", "AnimationsProperty"),        # FrameAnimations*
    Atom("animationsOfBeforeProperty", "AnimationsOfBeforeProperty"),  # FrameAnimations*
    Atom("animationsOfAfterProperty", "AnimationsOfAfterProperty"),  # FrameAnimations*
    Atom("animationEffectsProperty", "AnimationEffectsProperty"),  # EffectSet*
    Atom("animationEffectsForBeforeProperty", "AnimationsEffectsForBeforeProperty"),  # EffectSet*
    Atom("animationEffectsForAfterProperty", "AnimationsEffectsForAfterProperty"),  # EffectSet*
    Atom("beforePseudoProperty", "beforePseudoProperty"),  # nsXMLElement*
    Atom("cssPseudoElementBeforeProperty", "CSSPseudoElementBeforeProperty"),  # CSSPseudoElement*
    Atom("cssPseudoElementAfterProperty", "CSSPseudoElementAfterProperty"),  # CSSPseudoElement*
    Atom("transitionsProperty", "TransitionsProperty"),        # FrameTransitions*
    Atom("transitionsOfBeforeProperty", "TransitionsOfBeforeProperty"),  # FrameTransitions*
    Atom("transitionsOfAfterProperty", "TransitionsOfAfterProperty"),  # FrameTransitions*
    Atom("genConInitializerProperty", "QuoteNodeProperty"),
    Atom("labelMouseDownPtProperty", "LabelMouseDownPtProperty"),
    Atom("lockedStyleStates", "lockedStyleStates"),
    Atom("apzCallbackTransform", "apzCallbackTransform"),
    Atom("restylableAnonymousNode", "restylableAnonymousNode"),  # bool
    Atom("docLevelNativeAnonymousContent", "docLevelNativeAnonymousContent"),  # bool
    Atom("paintRequestTime", "PaintRequestTime"),
    Atom("pseudoProperty", "PseudoProperty"),  # CSSPseudoElementType
    Atom("manualNACProperty", "ManualNACProperty"),  # ManualNAC*

    # Languages for lang-specific transforms
    Atom("Japanese", "ja"),
    Atom("Chinese", "zh-CN"),
    Atom("Taiwanese", "zh-TW"),
    Atom("HongKongChinese", "zh-HK"),
    Atom("Unicode", "x-unicode"),

    # language codes specifically referenced in the gfx code
    Atom("ko", "ko"),
    Atom("zh_cn", "zh-cn"),
    Atom("zh_tw", "zh-tw"),

    # additional codes used in nsUnicodeRange.cpp
    Atom("x_cyrillic", "x-cyrillic"),
    Atom("he", "he"),
    Atom("ar", "ar"),
    Atom("x_devanagari", "x-devanagari"),
    Atom("x_tamil", "x-tamil"),
    Atom("x_armn", "x-armn"),
    Atom("x_beng", "x-beng"),
    Atom("x_cans", "x-cans"),
    Atom("x_ethi", "x-ethi"),
    Atom("x_geor", "x-geor"),
    Atom("x_gujr", "x-gujr"),
    Atom("x_guru", "x-guru"),
    Atom("x_khmr", "x-khmr"),
    Atom("x_knda", "x-knda"),
    Atom("x_mlym", "x-mlym"),
    Atom("x_orya", "x-orya"),
    Atom("x_sinh", "x-sinh"),
    Atom("x_telu", "x-telu"),
    Atom("x_tibt", "x-tibt"),

    # additional languages that have special case transformations
    Atom("az", "az"),
    Atom("ba", "ba"),
    Atom("crh", "crh"),
    # Atom("el", "el"),  # "el" is present above
    Atom("ga", "ga"),
    Atom("nl", "nl"),

    # mathematical language, used for MathML
    Atom("x_math", "x-math"),

    # Names for editor transactions
    Atom("TypingTxnName", "Typing"),
    Atom("IMETxnName", "IME"),
    Atom("DeleteTxnName", "Deleting"),

    # Font families
    Atom("serif", "serif"),
    Atom("sans_serif", "sans-serif"),
    Atom("cursive", "cursive"),
    Atom("fantasy", "fantasy"),
    Atom("monospace", "monospace"),
    Atom("mozfixed", "-moz-fixed"),

    # IPC stuff
    # Atom("Remote", "remote"),  # "remote" is present above
    Atom("RemoteId", "_remote_id"),
    Atom("RemoteType", "remoteType"),
    Atom("DisplayPort", "_displayport"),
    Atom("DisplayPortMargins", "_displayportmargins"),
    Atom("DisplayPortBase", "_displayportbase"),
    Atom("forcemessagemanager", "forcemessagemanager"),
    Atom("preloadedState", "preloadedState"),
    Atom("RecordExecution", "recordExecution"),
    Atom("ReplayExecution", "replayExecution"),

    # windows media query names
    Atom("windows_win7", "windows-win7"),
    Atom("windows_win8", "windows-win8"),
    Atom("windows_win10", "windows-win10"),

    # Names for system metrics.
    Atom("_moz_scrollbar_start_backward", "-moz-scrollbar-start-backward"),
    Atom("_moz_scrollbar_start_forward", "-moz-scrollbar-start-forward"),
    Atom("_moz_scrollbar_end_backward", "-moz-scrollbar-end-backward"),
    Atom("_moz_scrollbar_end_forward", "-moz-scrollbar-end-forward"),
    Atom("_moz_scrollbar_thumb_proportional", "-moz-scrollbar-thumb-proportional"),
    Atom("_moz_overlay_scrollbars", "-moz-overlay-scrollbars"),
    Atom("_moz_windows_accent_color_in_titlebar", "-moz-windows-accent-color-in-titlebar"),
    Atom("_moz_windows_default_theme", "-moz-windows-default-theme"),
    Atom("_moz_mac_graphite_theme", "-moz-mac-graphite-theme"),
    Atom("_moz_mac_yosemite_theme", "-moz-mac-yosemite-theme"),
    Atom("_moz_windows_compositor", "-moz-windows-compositor"),
    Atom("_moz_windows_classic", "-moz-windows-classic"),
    Atom("_moz_windows_glass", "-moz-windows-glass"),
    Atom("_moz_os_version", "-moz-os-version"),
    Atom("_moz_touch_enabled", "-moz-touch-enabled"),
    Atom("_moz_menubar_drag", "-moz-menubar-drag"),
    Atom("_moz_device_pixel_ratio", "-moz-device-pixel-ratio"),
    Atom("_moz_device_orientation", "-moz-device-orientation"),
    Atom("_moz_is_resource_document", "-moz-is-resource-document"),
    Atom("_moz_swipe_animation_enabled", "-moz-swipe-animation-enabled"),
    Atom("_moz_gtk_csd_available", "-moz-gtk-csd-available"),
    Atom("_moz_gtk_csd_minimize_button", "-moz-gtk-csd-minimize-button"),
    Atom("_moz_gtk_csd_maximize_button", "-moz-gtk-csd-maximize-button"),
    Atom("_moz_gtk_csd_close_button", "-moz-gtk-csd-close-button"),
    Atom("_moz_system_dark_theme", "-moz-system-dark-theme"),

    # application commands
    Atom("Back", "Back"),
    Atom("Forward", "Forward"),
    Atom("Reload", "Reload"),
    Atom("Stop", "Stop"),
    Atom("Search", "Search"),
    Atom("Bookmarks", "Bookmarks"),
    Atom("Home", "Home"),
    Atom("NextTrack", "NextTrack"),
    Atom("PreviousTrack", "PreviousTrack"),
    Atom("MediaStop", "MediaStop"),
    Atom("PlayPause", "PlayPause"),
    Atom("New", "New"),
    Atom("Open", "Open"),
    Atom("Close", "Close"),
    Atom("Save", "Save"),
    Atom("Find", "Find"),
    Atom("Help", "Help"),
    Atom("Print", "Print"),
    Atom("SendMail", "SendMail"),
    Atom("ForwardMail", "ForwardMail"),
    Atom("ReplyToMail", "ReplyToMail"),

    # Scroll origins (these are used in various scrolling functions in
    # nsIScrollableFrame and ScrollFrameHelper). These are divided into two lists
    # - origins in the first one have smooth-scrolling prefs associated with them,
    # under the "general.smoothScroll.<origin>.*" pref branch. Origins in the
    # second one do not.
    Atom("mouseWheel", "mouseWheel"),  # For discrete wheel events (e.g. not OSX magic mouse)
    Atom("pixels",     "pixels"),
    Atom("lines",      "lines"),
    Atom("pages",      "pages"),
    Atom("scrollbars", "scrollbars"),
    # Atom("other",      "other"),  # "other" is present above
    # Scroll origins without smooth-scrolling prefs
    Atom("apz",        "apz"),
    Atom("restore",    "restore"),

    Atom("alert", "alert"),
    Atom("alertdialog", "alertdialog"),
    Atom("application", "application"),
    Atom("aria_colcount", "aria-colcount"),
    Atom("aria_colindex", "aria-colindex"),
    Atom("aria_details", "aria-details"),
    Atom("aria_errormessage", "aria-errormessage"),
    Atom("aria_grabbed", "aria-grabbed"),
    Atom("aria_label", "aria-label"),
    Atom("aria_modal", "aria-modal"),
    Atom("aria_orientation", "aria-orientation"),
    Atom("aria_rowcount", "aria-rowcount"),
    Atom("aria_rowindex", "aria-rowindex"),
    Atom("aria_valuetext", "aria-valuetext"),
    Atom("auto_generated", "auto-generated"),
    Atom("banner", "banner"),
    Atom("checkable", "checkable"),
    Atom("columnheader", "columnheader"),
    Atom("complementary", "complementary"),
    Atom("containerAtomic", "container-atomic"),
    Atom("containerBusy", "container-busy"),
    Atom("containerLive", "container-live"),
    Atom("containerLiveRole", "container-live-role"),
    Atom("containerRelevant", "container-relevant"),
    Atom("contentinfo", "contentinfo"),
    Atom("cycles", "cycles"),
    Atom("datatable", "datatable"),
    Atom("eventFromInput", "event-from-input"),
    Atom("feed", "feed"),
    Atom("grammar", "grammar"),
    Atom("gridcell", "gridcell"),
    Atom("heading", "heading"),
    Atom("hitregion", "hitregion"),
    Atom("inlinevalue", "inline"),
    Atom("invalid", "invalid"),
    Atom("lineNumber", "line-number"),
    Atom("live", "live"),
    Atom("menuitemcheckbox", "menuitemcheckbox"),
    Atom("menuitemradio", "menuitemradio"),
    # Atom("mixed", "mixed"),  # "mixed" is present above
    Atom("navigation", "navigation"),
    Atom("polite", "polite"),
    Atom("posinset", "posinset"),
    Atom("presentation", "presentation"),
    Atom("progressbar", "progressbar"),
    Atom("region", "region"),
    Atom("rowgroup", "rowgroup"),
    Atom("rowheader", "rowheader"),
    Atom("search", "search"),
    Atom("searchbox", "searchbox"),
    Atom("setsize", "setsize"),
    Atom("spelling", "spelling"),
    Atom("spinbutton", "spinbutton"),
    Atom("status", "status"),
    Atom("tableCellIndex", "table-cell-index"),
    Atom("tablist", "tablist"),
    Atom("textIndent", "text-indent"),
    Atom("textInputType", "text-input-type"),
    Atom("textLineThroughColor", "text-line-through-color"),
    Atom("textLineThroughStyle", "text-line-through-style"),
    Atom("textPosition", "text-position"),
    Atom("textUnderlineColor", "text-underline-color"),
    Atom("textUnderlineStyle", "text-underline-style"),
    Atom("timer", "timer"),
    Atom("toolbarname", "toolbarname"),
    Atom("toolbarseparator", "toolbarseparator"),
    Atom("toolbarspacer", "toolbarspacer"),
    Atom("toolbarspring", "toolbarspring"),
    Atom("treegrid", "treegrid"),
    Atom("_undefined", "undefined"),
    Atom("xmlroles", "xml-roles"),

    # MathML xml roles
    Atom("close_fence", "close-fence"),
    Atom("denominator", "denominator"),
    Atom("numerator", "numerator"),
    Atom("open_fence", "open-fence"),
    Atom("overscript", "overscript"),
    Atom("presubscript", "presubscript"),
    Atom("presuperscript", "presuperscript"),
    Atom("root_index", "root-index"),
    Atom("subscript", "subscript"),
    Atom("superscript", "superscript"),
    Atom("underscript", "underscript"),

    Atom("onaudiostart", "onaudiostart"),
    Atom("onaudioend", "onaudioend"),
    Atom("onsoundstart", "onsoundstart"),
    Atom("onsoundend", "onsoundend"),
    Atom("onspeechstart", "onspeechstart"),
    Atom("onspeechend", "onspeechend"),
    Atom("onresult", "onresult"),
    Atom("onnomatch", "onnomatch"),
    Atom("onresume", "onresume"),
    Atom("onmark", "onmark"),
    Atom("onboundary", "onboundary"),

    # Contextual Identity / Containers
    Atom("usercontextid", "usercontextid"),

    # Namespaces
    Atom("nsuri_xmlns", "http://www.w3.org/2000/xmlns/"),
    Atom("nsuri_xml", "http://www.w3.org/XML/1998/namespace"),
    Atom("nsuri_xhtml", "http://www.w3.org/1999/xhtml"),
    Atom("nsuri_xlink", "http://www.w3.org/1999/xlink"),
    Atom("nsuri_xslt", "http://www.w3.org/1999/XSL/Transform"),
    Atom("nsuri_xbl", "http://www.mozilla.org/xbl"),
    Atom("nsuri_mathml", "http://www.w3.org/1998/Math/MathML"),
    Atom("nsuri_rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    Atom("nsuri_xul", "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul"),
    Atom("nsuri_svg", "http://www.w3.org/2000/svg"),

    # MSE
    Atom("onsourceopen", "onsourceopen"),
    Atom("onsourceended", "onsourceended"),
    Atom("onsourceclosed", "onsourceclosed"),
    Atom("onupdatestart", "onupdatestart"),
    Atom("onupdate", "onupdate"),
    Atom("onupdateend", "onupdateend"),
    Atom("onaddsourcebuffer", "onaddsourcebuffer"),
    Atom("onremovesourcebuffer", "onremovesourcebuffer"),

    # RDF
    Atom("about", "about"),
    Atom("ID", "ID"),
    Atom("nodeID", "nodeID"),
    Atom("aboutEach", "aboutEach"),
    Atom("resource", "resource"),
    Atom("RDF", "RDF"),
    Atom("Description", "Description"),
    Atom("Bag", "Bag"),
    Atom("Seq", "Seq"),
    Atom("Alt", "Alt"),
    # Atom("kLiAtom", "li"),  # "li" is present above
    # Atom("kXMLNSAtom", "xmlns"),  # "xmlns" is present above
    Atom("parseType", "parseType"),

    # Directory service
    Atom("DirectoryService_CurrentProcess", "XCurProcD"),
    Atom("DirectoryService_GRE_Directory", "GreD"),
    Atom("DirectoryService_GRE_BinDirectory", "GreBinD"),
    Atom("DirectoryService_OS_TemporaryDirectory", "TmpD"),
    Atom("DirectoryService_OS_CurrentProcessDirectory", "CurProcD"),
    Atom("DirectoryService_OS_CurrentWorkingDirectory", "CurWorkD"),
    # Atom("DirectoryService_OS_HomeDirectory", "Home"),  # "Home" is present above
    Atom("DirectoryService_OS_DesktopDirectory", "Desk"),
    Atom("DirectoryService_InitCurrentProcess_dummy", "MozBinD"),
    Atom("DirectoryService_SystemDirectory", "SysD"),
    Atom("DirectoryService_UserLibDirectory", "ULibDir"),
    Atom("DirectoryService_DefaultDownloadDirectory", "DfltDwnld"),
    Atom("DirectoryService_LocalApplicationsDirectory", "LocApp"),
    Atom("DirectoryService_UserPreferencesDirectory", "UsrPrfs"),
    Atom("DirectoryService_PictureDocumentsDirectory", "Pct"),
    Atom("DirectoryService_WindowsDirectory", "WinD"),
    Atom("DirectoryService_WindowsProgramFiles", "ProgF"),
    Atom("DirectoryService_Programs", "Progs"),
    Atom("DirectoryService_Favorites", "Favs"),
    Atom("DirectoryService_Appdata", "AppData"),
    Atom("DirectoryService_LocalAppdata", "LocalAppData"),
    Atom("DirectoryService_LocalAppdataLow", "LocalAppDataLow"),
    Atom("DirectoryService_LowIntegrityTempBase", "LowTmpDBase"),
    Atom("DirectoryService_WinCookiesDirectory", "CookD"),

    # CSS pseudo-elements -- these must appear in the same order as
    # in nsCSSPseudoElementList.h
    PseudoElementAtom("PseudoElement_after", ":after"),
    PseudoElementAtom("PseudoElement_before", ":before"),
    PseudoElementAtom("PseudoElement_backdrop", ":backdrop"),
    PseudoElementAtom("PseudoElement_cue", ":cue"),
    PseudoElementAtom("PseudoElement_firstLetter", ":first-letter"),
    PseudoElementAtom("PseudoElement_firstLine", ":first-line"),
    PseudoElementAtom("PseudoElement_selection", ":selection"),
    PseudoElementAtom("PseudoElement_mozFocusInner", ":-moz-focus-inner"),
    PseudoElementAtom("PseudoElement_mozFocusOuter", ":-moz-focus-outer"),
    PseudoElementAtom("PseudoElement_mozListBullet", ":-moz-list-bullet"),
    PseudoElementAtom("PseudoElement_mozListNumber", ":-moz-list-number"),
    PseudoElementAtom("PseudoElement_mozMathAnonymous", ":-moz-math-anonymous"),
    PseudoElementAtom("PseudoElement_mozNumberWrapper", ":-moz-number-wrapper"),
    PseudoElementAtom("PseudoElement_mozNumberText", ":-moz-number-text"),
    PseudoElementAtom("PseudoElement_mozNumberSpinBox", ":-moz-number-spin-box"),
    PseudoElementAtom("PseudoElement_mozNumberSpinUp", ":-moz-number-spin-up"),
    PseudoElementAtom("PseudoElement_mozNumberSpinDown", ":-moz-number-spin-down"),
    PseudoElementAtom("PseudoElement_mozProgressBar", ":-moz-progress-bar"),
    PseudoElementAtom("PseudoElement_mozRangeTrack", ":-moz-range-track"),
    PseudoElementAtom("PseudoElement_mozRangeProgress", ":-moz-range-progress"),
    PseudoElementAtom("PseudoElement_mozRangeThumb", ":-moz-range-thumb"),
    PseudoElementAtom("PseudoElement_mozMeterBar", ":-moz-meter-bar"),
    PseudoElementAtom("PseudoElement_placeholder", ":placeholder"),
    PseudoElementAtom("PseudoElement_mozColorSwatch", ":-moz-color-swatch"),

    # CSS anonymous boxes -- these must appear in the same order as
    # in nsCSSAnonBoxList.h
    NonInheritingAnonBoxAtom("AnonBox_oofPlaceholder", ":-moz-oof-placeholder"),
    NonInheritingAnonBoxAtom("AnonBox_horizontalFramesetBorder", ":-moz-hframeset-border"),
    NonInheritingAnonBoxAtom("AnonBox_verticalFramesetBorder", ":-moz-vframeset-border"),
    NonInheritingAnonBoxAtom("AnonBox_framesetBlank", ":-moz-frameset-blank"),
    NonInheritingAnonBoxAtom("AnonBox_tableColGroup", ":-moz-table-column-group"),
    NonInheritingAnonBoxAtom("AnonBox_tableCol", ":-moz-table-column"),
    NonInheritingAnonBoxAtom("AnonBox_pageBreak", ":-moz-pagebreak"),
    InheritingAnonBoxAtom("AnonBox_mozText", ":-moz-text"),
    InheritingAnonBoxAtom("AnonBox_firstLetterContinuation", ":-moz-first-letter-continuation"),
    InheritingAnonBoxAtom("AnonBox_mozBlockInsideInlineWrapper", ":-moz-block-inside-inline-wrapper"),
    InheritingAnonBoxAtom("AnonBox_mozMathMLAnonymousBlock", ":-moz-mathml-anonymous-block"),
    InheritingAnonBoxAtom("AnonBox_mozXULAnonymousBlock", ":-moz-xul-anonymous-block"),
    InheritingAnonBoxAtom("AnonBox_mozLineFrame", ":-moz-line-frame"),
    InheritingAnonBoxAtom("AnonBox_buttonContent", ":-moz-button-content"),
    InheritingAnonBoxAtom("AnonBox_cellContent", ":-moz-cell-content"),
    InheritingAnonBoxAtom("AnonBox_dropDownList", ":-moz-dropdown-list"),
    InheritingAnonBoxAtom("AnonBox_fieldsetContent", ":-moz-fieldset-content"),
    InheritingAnonBoxAtom("AnonBox_mozDisplayComboboxControlFrame", ":-moz-display-comboboxcontrol-frame"),
    InheritingAnonBoxAtom("AnonBox_htmlCanvasContent", ":-moz-html-canvas-content"),
    InheritingAnonBoxAtom("AnonBox_inlineTable", ":-moz-inline-table"),
    InheritingAnonBoxAtom("AnonBox_table", ":-moz-table"),
    InheritingAnonBoxAtom("AnonBox_tableCell", ":-moz-table-cell"),
    InheritingAnonBoxAtom("AnonBox_tableWrapper", ":-moz-table-wrapper"),
    InheritingAnonBoxAtom("AnonBox_tableRowGroup", ":-moz-table-row-group"),
    InheritingAnonBoxAtom("AnonBox_tableRow", ":-moz-table-row"),
    InheritingAnonBoxAtom("AnonBox_canvas", ":-moz-canvas"),
    InheritingAnonBoxAtom("AnonBox_page", ":-moz-page"),
    InheritingAnonBoxAtom("AnonBox_pageContent", ":-moz-pagecontent"),
    InheritingAnonBoxAtom("AnonBox_pageSequence", ":-moz-page-sequence"),
    InheritingAnonBoxAtom("AnonBox_scrolledContent", ":-moz-scrolled-content"),
    InheritingAnonBoxAtom("AnonBox_scrolledCanvas", ":-moz-scrolled-canvas"),
    InheritingAnonBoxAtom("AnonBox_scrolledPageSequence", ":-moz-scrolled-page-sequence"),
    InheritingAnonBoxAtom("AnonBox_columnContent", ":-moz-column-content"),
    InheritingAnonBoxAtom("AnonBox_viewport", ":-moz-viewport"),
    InheritingAnonBoxAtom("AnonBox_viewportScroll", ":-moz-viewport-scroll"),
    InheritingAnonBoxAtom("AnonBox_anonymousFlexItem", ":-moz-anonymous-flex-item"),
    InheritingAnonBoxAtom("AnonBox_anonymousGridItem", ":-moz-anonymous-grid-item"),
    InheritingAnonBoxAtom("AnonBox_ruby", ":-moz-ruby"),
    InheritingAnonBoxAtom("AnonBox_rubyBase", ":-moz-ruby-base"),
    InheritingAnonBoxAtom("AnonBox_rubyBaseContainer", ":-moz-ruby-base-container"),
    InheritingAnonBoxAtom("AnonBox_rubyText", ":-moz-ruby-text"),
    InheritingAnonBoxAtom("AnonBox_rubyTextContainer", ":-moz-ruby-text-container"),
    InheritingAnonBoxAtom("AnonBox_mozTreeColumn", ":-moz-tree-column"),
    InheritingAnonBoxAtom("AnonBox_mozTreeRow", ":-moz-tree-row"),
    InheritingAnonBoxAtom("AnonBox_mozTreeSeparator", ":-moz-tree-separator"),
    InheritingAnonBoxAtom("AnonBox_mozTreeCell", ":-moz-tree-cell"),
    InheritingAnonBoxAtom("AnonBox_mozTreeIndentation", ":-moz-tree-indentation"),
    InheritingAnonBoxAtom("AnonBox_mozTreeLine", ":-moz-tree-line"),
    InheritingAnonBoxAtom("AnonBox_mozTreeTwisty", ":-moz-tree-twisty"),
    InheritingAnonBoxAtom("AnonBox_mozTreeImage", ":-moz-tree-image"),
    InheritingAnonBoxAtom("AnonBox_mozTreeCellText", ":-moz-tree-cell-text"),
    InheritingAnonBoxAtom("AnonBox_mozTreeCheckbox", ":-moz-tree-checkbox"),
    InheritingAnonBoxAtom("AnonBox_mozTreeDropFeedback", ":-moz-tree-drop-feedback"),
    InheritingAnonBoxAtom("AnonBox_mozSVGMarkerAnonChild", ":-moz-svg-marker-anon-child"),
    InheritingAnonBoxAtom("AnonBox_mozSVGOuterSVGAnonChild", ":-moz-svg-outer-svg-anon-child"),
    InheritingAnonBoxAtom("AnonBox_mozSVGForeignContent", ":-moz-svg-foreign-content"),
    InheritingAnonBoxAtom("AnonBox_mozSVGText", ":-moz-svg-text"),
] + HTML_PARSER_ATOMS


def verify():
    idents = set()
    strings = set()
    failed = False
    for atom in STATIC_ATOMS:
        if atom.ident in idents:
            print("StaticAtoms.py: duplicate static atom ident: %s" % atom.ident)
            failed = True
        if atom.string in strings:
            print("StaticAtoms.py: duplicate static atom string: \"%s\"" % atom.string)
            failed = True
        idents.add(atom.ident)
        strings.add(atom.string)
    if failed:
        sys.exit(1)


def generate_nsgkatomlist_h(output, *ignore):
    verify()
    output.write("/* THIS FILE IS AUTOGENERATED BY StaticAtoms.py.  DO NOT EDIT */\n\n"
                 "#ifdef small\n"
                 "#undef small\n"
                 "#endif\n\n"
                 "// GK_ATOM(identifier, string, hash, gecko_type, atom_type)\n" +
                 "".join(["GK_ATOM(%s, \"%s\", 0x%08x, %s, %s)\n" %
                            (a.ident, a.string, a.hash, a.ty, a.atom_type)
                          for a in STATIC_ATOMS]))


def generate_nsgkatomconsts_h(output, *ignore):
    pseudo_index = None
    anon_box_index = None
    pseudo_count = 0
    anon_box_count = 0
    for i, atom in enumerate(STATIC_ATOMS):
        if atom.atom_type is "PseudoElementAtom":
            if pseudo_index is None:
                pseudo_index = i
            pseudo_count += 1
        elif atom.atom_type is "NonInheritingAnonBoxAtom" or atom.atom_type is "InheritingAnonBoxAtom":
            if anon_box_index is None:
                anon_box_index = i
            anon_box_count += 1
    output.write("/* THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT */\n\n"
                 "namespace mozilla {\n"
                 "  constexpr uint32_t kAtomIndex_PseudoElements = %d;\n"
                 "  constexpr uint32_t kAtomCount_PseudoElements = %d;\n"
                 "  constexpr uint32_t kAtomIndex_AnonBoxes = %d;\n"
                 "  constexpr uint32_t kAtomCount_AnonBoxes = %d;\n"
                 "}\n" % (pseudo_index, pseudo_count, anon_box_index, anon_box_count))


if __name__ == '__main__':
    generate_nsgkatomlist_h(sys.stdout)
