// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2018 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Ugaritic`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v11.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x01039F
  ],
  ranges: [
    [0x010380, 0x01039D]
  ]
});
testPropertyEscapes(
  /^\p{Script=Ugaritic}+$/u,
  matchSymbols,
  "\\p{Script=Ugaritic}"
);
testPropertyEscapes(
  /^\p{Script=Ugar}+$/u,
  matchSymbols,
  "\\p{Script=Ugar}"
);
testPropertyEscapes(
  /^\p{sc=Ugaritic}+$/u,
  matchSymbols,
  "\\p{sc=Ugaritic}"
);
testPropertyEscapes(
  /^\p{sc=Ugar}+$/u,
  matchSymbols,
  "\\p{sc=Ugar}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x01039E
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01037F],
    [0x0103A0, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Ugaritic}+$/u,
  nonMatchSymbols,
  "\\P{Script=Ugaritic}"
);
testPropertyEscapes(
  /^\P{Script=Ugar}+$/u,
  nonMatchSymbols,
  "\\P{Script=Ugar}"
);
testPropertyEscapes(
  /^\P{sc=Ugaritic}+$/u,
  nonMatchSymbols,
  "\\P{sc=Ugaritic}"
);
testPropertyEscapes(
  /^\P{sc=Ugar}+$/u,
  nonMatchSymbols,
  "\\P{sc=Ugar}"
);

reportCompare(0, 0);
