// GENERATED FILE - DO NOT EDIT.
// Generated by gen_load_functions_table.py using data from load_functions_data.json
//
// Copyright 2018 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// load_functions_table:
//   Contains the GetLoadFunctionsMap for texture_format_util.h
//

#include "libANGLE/renderer/load_functions_table.h"

#include "image_util/copyimage.h"
#include "image_util/generatemip.h"
#include "image_util/loadimage.h"

using namespace rx;

namespace angle
{

namespace
{

// ES3 image loading functions vary based on:
//    - the GL internal format (supplied to glTex*Image*D)
//    - the GL data type given (supplied to glTex*Image*D)
//    - the target DXGI_FORMAT that the image will be loaded into (which is chosen based on the D3D
//    device's capabilities)
// This map type determines which loading function to use, based on these three parameters.
// Source formats and types are taken from Tables 3.2 and 3.3 of the ES 3 spec.
void UnimplementedLoadFunction(size_t width,
                               size_t height,
                               size_t depth,
                               const uint8_t *input,
                               size_t inputRowPitch,
                               size_t inputDepthPitch,
                               uint8_t *output,
                               size_t outputRowPitch,
                               size_t outputDepthPitch)
{
    UNIMPLEMENTED();
}

void UnreachableLoadFunction(size_t width,
                             size_t height,
                             size_t depth,
                             const uint8_t *input,
                             size_t inputRowPitch,
                             size_t inputDepthPitch,
                             uint8_t *output,
                             size_t outputRowPitch,
                             size_t outputDepthPitch)
{
    UNREACHABLE();
}

LoadImageFunctionInfo ALPHA_to_R16G16B16A16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA_to_R32G32B32A32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadA32FToRGBA32F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA16F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadA16FToRGBA16F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA32F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadA32FToRGBA32F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA8_EXT_to_A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA8_EXT_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadA8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ALPHA8_EXT_to_R8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo BGR565_ANGLEX_to_B5G6R5_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        case GL_UNSIGNED_SHORT_5_6_5:
            return LoadImageFunctionInfo(LoadRGB565ToBGR565, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo BGR5_A1_ANGLEX_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        case GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT:
            return LoadImageFunctionInfo(LoadRGB5A1ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo BGRA4_ANGLEX_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        case GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT:
            return LoadImageFunctionInfo(LoadRGBA4ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo BGRA8_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo BGRA_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_R11_EAC_to_R16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadEACR11ToR16, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RG11_EAC_to_R16G16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadEACRG11ToRG16, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB8_ETC2_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2RGB8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB8_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGB_UNORM_BLOCK(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2RGB8ToBC1, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2RGB8A1ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo
COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGBA_UNORM_BLOCK(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2RGB8A1ToBC1, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGBA8_ETC2_EAC_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2RGBA8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGBA_BPTC_UNORM_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGBA_S3TC_DXT1_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 8>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGBA_S3TC_DXT3_ANGLE_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGBA_S3TC_DXT5_ANGLE_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_RGB_S3TC_DXT1_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 8>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SIGNED_R11_EAC_to_R16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadEACR11SToR16, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SIGNED_RG11_EAC_to_R16G16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadEACRG11SToRG16, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_to_R8G8B8A8_UNORM_SRGB(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2SRGBA8ToSRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB8_ETC2_to_R8G8B8A8_UNORM_SRGB(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2SRGB8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB8_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGB_UNORM_SRGB_BLOCK(
    GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2SRGB8ToBC1, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_to_R8G8B8A8_UNORM_SRGB(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2SRGB8A1ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo
COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGBA_UNORM_SRGB_BLOCK(
    GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC2SRGB8A1ToBC1, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 8>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 16>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo COMPRESSED_SRGB_S3TC_DXT1_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadCompressedToNative<4, 4, 8>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH24_STENCIL8_to_D24_UNORM_S8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT_24_8:
            return LoadImageFunctionInfo(LoadR32ToR24G8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH32F_STENCIL8_to_D32_FLOAT_S8X24_UINT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT_32_UNSIGNED_INT_24_8_REV:
            return LoadImageFunctionInfo(LoadD32FS8X24ToD32FS8X24, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH_COMPONENT16_to_D16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadR32ToR16, true);
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH_COMPONENT24_to_D24_UNORM_S8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadR32ToR24G8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH_COMPONENT32F_to_D32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadD32FToD32F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo DEPTH_COMPONENT32_OES_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadR32ToR24G8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ETC1_RGB8_LOSSY_DECODE_ANGLE_to_BC1_RGB_UNORM_BLOCK(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC1RGB8ToBC1, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo ETC1_RGB8_OES_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadETC1RGB8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_to_R16G16B16A16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_to_R32G32B32A32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadL32FToRGBA32F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE16F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadL16FToRGBA16F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE32F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadL32FToRGBA32F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE8_ALPHA8_EXT_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadLA8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE8_ALPHA8_EXT_to_R8G8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE8_EXT_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadL8ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE8_EXT_to_R8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_ALPHA_to_R16G16B16A16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_ALPHA_to_R32G32B32A32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadLA32FToRGBA32F, true);
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_ALPHA_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_ALPHA16F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadLA16FToRGBA16F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo LUMINANCE_ALPHA32F_EXT_to_default(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadLA32FToRGBA32F, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R11F_G11F_B10F_to_R11G11B10_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadRGB32FToRG11B10F, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadRGB16FToRG11B10F, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadRGB16FToRG11B10F, true);
        case GL_UNSIGNED_INT_10F_11F_11F_REV:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R16F_to_R16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(Load32FTo16F<1>, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 1>, false);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R16I_to_R16_SINT(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLshort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R16UI_to_R16_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R16_EXT_to_R16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R16_SNORM_EXT_to_R16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R32F_to_R32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLfloat, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R32I_to_R32_SINT(GLenum type)
{
    switch (type)
    {
        case GL_INT:
            return LoadImageFunctionInfo(LoadToNative<GLint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R32UI_to_R32_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R8_to_R8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R8I_to_R8_SINT(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R8UI_to_R8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo R8_SNORM_to_R8_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG16F_to_R16G16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(Load32FTo16F<2>, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 2>, false);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG16I_to_R16G16_SINT(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLshort, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG16UI_to_R16G16_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG16_EXT_to_R16G16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG16_SNORM_EXT_to_R16G16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG32F_to_R32G32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLfloat, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG32I_to_R32G32_SINT(GLenum type)
{
    switch (type)
    {
        case GL_INT:
            return LoadImageFunctionInfo(LoadToNative<GLint, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG32UI_to_R32G32_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG8_to_R8G8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG8I_to_R8G8_SINT(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG8UI_to_R8G8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RG8_SNORM_to_R8G8_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 2>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        case GL_UNSIGNED_SHORT_5_6_5:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB10_A2_to_R10G10B10A2_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT_2_10_10_10_REV:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB10_A2UI_to_R10G10B10A2_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT_2_10_10_10_REV:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB16F_to_R16G16B16A16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadRGB32FToRGBA16F, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLhalf, gl::Float16One>, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadToNative3To4<GLhalf, gl::Float16One>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB16I_to_R16G16B16A16_SINT(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLshort, 0x0001>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB16UI_to_R16G16B16A16_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLushort, 0x0001>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB16_EXT_to_R16G16B16A16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLushort, 0xFFFF>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB16_SNORM_EXT_to_R16G16B16A16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLushort, 0x7FFF>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB32F_to_R32G32B32A32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLfloat, gl::Float32One>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB32I_to_R32G32B32A32_SINT(GLenum type)
{
    switch (type)
    {
        case GL_INT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLint, 0x00000001>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB32UI_to_R32G32B32A32_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadToNative3To4<GLuint, 0x00000001>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB565_to_B5G6R5_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadRGB8ToBGR565, true);
        case GL_UNSIGNED_SHORT_5_6_5:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB565_to_R5G6B5_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT_5_6_5:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB565_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLubyte, 0xFF>, true);
        case GL_UNSIGNED_SHORT_5_6_5:
            return LoadImageFunctionInfo(LoadR5G6B5ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB5_A1_to_A1R5G5B5_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT_5_5_5_1:
            return LoadImageFunctionInfo(LoadRGB5A1ToA1RGB5, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB5_A1_to_B5G5R5A1_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadRGBA8ToBGR5A1, true);
        case GL_UNSIGNED_INT_2_10_10_10_REV:
            return LoadImageFunctionInfo(LoadRGB10A2ToBGR5A1, true);
        case GL_UNSIGNED_SHORT_5_5_5_1:
            return LoadImageFunctionInfo(LoadRGB5A1ToA1RGB5, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB5_A1_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        case GL_UNSIGNED_INT_2_10_10_10_REV:
            return LoadImageFunctionInfo(LoadRGB10A2ToRGBA8, true);
        case GL_UNSIGNED_SHORT_5_5_5_1:
            return LoadImageFunctionInfo(LoadRGB5A1ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB8_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLubyte, 0xFF>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB8I_to_R8G8B8A8_SINT(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLbyte, 0x01>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB8UI_to_R8G8B8A8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLubyte, 0x01>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB8_SNORM_to_R8G8B8A8_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLbyte, 0x7F>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGB9_E5_to_R9G9B9E5_SHAREDEXP(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadRGB32FToRGB9E5, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadRGB16FToRGB9E5, true);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadRGB16FToRGB9E5, true);
        case GL_UNSIGNED_INT_5_9_9_9_REV:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 1>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        case GL_UNSIGNED_SHORT_4_4_4_4:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        case GL_UNSIGNED_SHORT_5_5_5_1:
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA16F_to_R16G16B16A16_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(Load32FTo16F<4>, true);
        case GL_HALF_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 4>, false);
        case GL_HALF_FLOAT_OES:
            return LoadImageFunctionInfo(LoadToNative<GLhalf, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA16I_to_R16G16B16A16_SINT(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLshort, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA16UI_to_R16G16B16A16_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA16_EXT_to_R16G16B16A16_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA16_SNORM_EXT_to_R16G16B16A16_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_SHORT:
            return LoadImageFunctionInfo(LoadToNative<GLushort, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA32F_to_R32G32B32A32_FLOAT(GLenum type)
{
    switch (type)
    {
        case GL_FLOAT:
            return LoadImageFunctionInfo(LoadToNative<GLfloat, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA32I_to_R32G32B32A32_SINT(GLenum type)
{
    switch (type)
    {
        case GL_INT:
            return LoadImageFunctionInfo(LoadToNative<GLint, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA32UI_to_R32G32B32A32_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_INT:
            return LoadImageFunctionInfo(LoadToNative<GLuint, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA4_to_B4G4R4A4_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadRGBA8ToBGRA4, true);
        case GL_UNSIGNED_SHORT_4_4_4_4:
            return LoadImageFunctionInfo(LoadRGBA4ToARGB4, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA4_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        case GL_UNSIGNED_SHORT_4_4_4_4:
            return LoadImageFunctionInfo(LoadRGBA4ToRGBA8, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA8_to_R8G8B8A8_UNORM(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA8I_to_R8G8B8A8_SINT(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA8UI_to_R8G8B8A8_UINT(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo RGBA8_SNORM_to_R8G8B8A8_SNORM(GLenum type)
{
    switch (type)
    {
        case GL_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLbyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo SRGB8_to_R8G8B8A8_UNORM_SRGB(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative3To4<GLubyte, 0xFF>, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo SRGB8_ALPHA8_to_R8G8B8A8_UNORM_SRGB(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(LoadToNative<GLubyte, 4>, false);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

LoadImageFunctionInfo STENCIL_INDEX8_to_default(GLenum type)
{
    switch (type)
    {
        case GL_UNSIGNED_BYTE:
            return LoadImageFunctionInfo(UnimplementedLoadFunction, true);
        default:
            UNREACHABLE();
            return LoadImageFunctionInfo(UnreachableLoadFunction, true);
    }
}

}  // namespace

LoadFunctionMap GetLoadFunctionsMap(GLenum internalFormat, FormatID angleFormat)
{
    // clang-format off
    switch (internalFormat)
    {
        case GL_ALPHA:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_FLOAT:
                    return ALPHA_to_R16G16B16A16_FLOAT;
                case FormatID::R32G32B32A32_FLOAT:
                    return ALPHA_to_R32G32B32A32_FLOAT;
                default:
                    return ALPHA_to_default;
            }
        }
        case GL_ALPHA16F_EXT:
            return ALPHA16F_EXT_to_default;
        case GL_ALPHA32F_EXT:
            return ALPHA32F_EXT_to_default;
        case GL_ALPHA8_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::A8_UNORM:
                    return ALPHA8_EXT_to_A8_UNORM;
                case FormatID::R8G8B8A8_UNORM:
                    return ALPHA8_EXT_to_R8G8B8A8_UNORM;
                case FormatID::R8_UNORM:
                    return ALPHA8_EXT_to_R8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_BGR565_ANGLEX:
        {
            switch (angleFormat)
            {
                case FormatID::B5G6R5_UNORM:
                    return BGR565_ANGLEX_to_B5G6R5_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_BGR5_A1_ANGLEX:
            return BGR5_A1_ANGLEX_to_default;
        case GL_BGRA4_ANGLEX:
            return BGRA4_ANGLEX_to_default;
        case GL_BGRA8_EXT:
            return BGRA8_EXT_to_default;
        case GL_BGRA_EXT:
            return BGRA_EXT_to_default;
        case GL_COMPRESSED_R11_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R16_UNORM:
                    return COMPRESSED_R11_EAC_to_R16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RG11_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_UNORM:
                    return COMPRESSED_RG11_EAC_to_R16G16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGB8_ETC2:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return COMPRESSED_RGB8_ETC2_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGB8_LOSSY_DECODE_ETC2_ANGLE:
        {
            switch (angleFormat)
            {
                case FormatID::BC1_RGB_UNORM_BLOCK:
                    return COMPRESSED_RGB8_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGB_UNORM_BLOCK;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE:
        {
            switch (angleFormat)
            {
                case FormatID::BC1_RGBA_UNORM_BLOCK:
                    return COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGBA_UNORM_BLOCK;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGBA8_ETC2_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return COMPRESSED_RGBA8_ETC2_EAC_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_RGBA_BPTC_UNORM_EXT:
            return COMPRESSED_RGBA_BPTC_UNORM_EXT_to_default;
        case GL_COMPRESSED_RGBA_S3TC_DXT1_EXT:
            return COMPRESSED_RGBA_S3TC_DXT1_EXT_to_default;
        case GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE:
            return COMPRESSED_RGBA_S3TC_DXT3_ANGLE_to_default;
        case GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE:
            return COMPRESSED_RGBA_S3TC_DXT5_ANGLE_to_default;
        case GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT:
            return COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT_to_default;
        case GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT:
            return COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT_to_default;
        case GL_COMPRESSED_RGB_S3TC_DXT1_EXT:
            return COMPRESSED_RGB_S3TC_DXT1_EXT_to_default;
        case GL_COMPRESSED_SIGNED_R11_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R16_SNORM:
                    return COMPRESSED_SIGNED_R11_EAC_to_R16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SIGNED_RG11_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_SNORM:
                    return COMPRESSED_SIGNED_RG11_EAC_to_R16G16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM_SRGB:
                    return COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_to_R8G8B8A8_UNORM_SRGB;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB8_ETC2:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM_SRGB:
                    return COMPRESSED_SRGB8_ETC2_to_R8G8B8A8_UNORM_SRGB;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB8_LOSSY_DECODE_ETC2_ANGLE:
        {
            switch (angleFormat)
            {
                case FormatID::BC1_RGB_UNORM_SRGB_BLOCK:
                    return COMPRESSED_SRGB8_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGB_UNORM_SRGB_BLOCK;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM_SRGB:
                    return COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_to_R8G8B8A8_UNORM_SRGB;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE:
        {
            switch (angleFormat)
            {
                case FormatID::BC1_RGBA_UNORM_SRGB_BLOCK:
                    return COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_LOSSY_DECODE_ETC2_ANGLE_to_BC1_RGBA_UNORM_SRGB_BLOCK;
                default:
                    break;
            }
            break;
        }
        case GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:
            return COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT_to_default;
        case GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT:
            return COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT_to_default;
        case GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT:
            return COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT_to_default;
        case GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT:
            return COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT_to_default;
        case GL_COMPRESSED_SRGB_S3TC_DXT1_EXT:
            return COMPRESSED_SRGB_S3TC_DXT1_EXT_to_default;
        case GL_DEPTH24_STENCIL8:
        {
            switch (angleFormat)
            {
                case FormatID::D24_UNORM_S8_UINT:
                    return DEPTH24_STENCIL8_to_D24_UNORM_S8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_DEPTH32F_STENCIL8:
        {
            switch (angleFormat)
            {
                case FormatID::D32_FLOAT_S8X24_UINT:
                    return DEPTH32F_STENCIL8_to_D32_FLOAT_S8X24_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_DEPTH_COMPONENT16:
        {
            switch (angleFormat)
            {
                case FormatID::D16_UNORM:
                    return DEPTH_COMPONENT16_to_D16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_DEPTH_COMPONENT24:
        {
            switch (angleFormat)
            {
                case FormatID::D24_UNORM_S8_UINT:
                    return DEPTH_COMPONENT24_to_D24_UNORM_S8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_DEPTH_COMPONENT32F:
        {
            switch (angleFormat)
            {
                case FormatID::D32_FLOAT:
                    return DEPTH_COMPONENT32F_to_D32_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_DEPTH_COMPONENT32_OES:
            return DEPTH_COMPONENT32_OES_to_default;
        case GL_ETC1_RGB8_LOSSY_DECODE_ANGLE:
        {
            switch (angleFormat)
            {
                case FormatID::BC1_RGB_UNORM_BLOCK:
                    return ETC1_RGB8_LOSSY_DECODE_ANGLE_to_BC1_RGB_UNORM_BLOCK;
                default:
                    break;
            }
            break;
        }
        case GL_ETC1_RGB8_OES:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return ETC1_RGB8_OES_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_LUMINANCE:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_FLOAT:
                    return LUMINANCE_to_R16G16B16A16_FLOAT;
                case FormatID::R32G32B32A32_FLOAT:
                    return LUMINANCE_to_R32G32B32A32_FLOAT;
                default:
                    return LUMINANCE_to_default;
            }
        }
        case GL_LUMINANCE16F_EXT:
            return LUMINANCE16F_EXT_to_default;
        case GL_LUMINANCE32F_EXT:
            return LUMINANCE32F_EXT_to_default;
        case GL_LUMINANCE8_ALPHA8_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return LUMINANCE8_ALPHA8_EXT_to_R8G8B8A8_UNORM;
                case FormatID::R8G8_UNORM:
                    return LUMINANCE8_ALPHA8_EXT_to_R8G8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_LUMINANCE8_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return LUMINANCE8_EXT_to_R8G8B8A8_UNORM;
                case FormatID::R8_UNORM:
                    return LUMINANCE8_EXT_to_R8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_LUMINANCE_ALPHA:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_FLOAT:
                    return LUMINANCE_ALPHA_to_R16G16B16A16_FLOAT;
                case FormatID::R32G32B32A32_FLOAT:
                    return LUMINANCE_ALPHA_to_R32G32B32A32_FLOAT;
                default:
                    return LUMINANCE_ALPHA_to_default;
            }
        }
        case GL_LUMINANCE_ALPHA16F_EXT:
            return LUMINANCE_ALPHA16F_EXT_to_default;
        case GL_LUMINANCE_ALPHA32F_EXT:
            return LUMINANCE_ALPHA32F_EXT_to_default;
        case GL_R11F_G11F_B10F:
        {
            switch (angleFormat)
            {
                case FormatID::R11G11B10_FLOAT:
                    return R11F_G11F_B10F_to_R11G11B10_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_R16F:
        {
            switch (angleFormat)
            {
                case FormatID::R16_FLOAT:
                    return R16F_to_R16_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_R16I:
        {
            switch (angleFormat)
            {
                case FormatID::R16_SINT:
                    return R16I_to_R16_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_R16UI:
        {
            switch (angleFormat)
            {
                case FormatID::R16_UINT:
                    return R16UI_to_R16_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_R16_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16_UNORM:
                    return R16_EXT_to_R16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_R16_SNORM_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16_SNORM:
                    return R16_SNORM_EXT_to_R16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_R32F:
        {
            switch (angleFormat)
            {
                case FormatID::R32_FLOAT:
                    return R32F_to_R32_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_R32I:
        {
            switch (angleFormat)
            {
                case FormatID::R32_SINT:
                    return R32I_to_R32_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_R32UI:
        {
            switch (angleFormat)
            {
                case FormatID::R32_UINT:
                    return R32UI_to_R32_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_R8:
        {
            switch (angleFormat)
            {
                case FormatID::R8_UNORM:
                    return R8_to_R8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_R8I:
        {
            switch (angleFormat)
            {
                case FormatID::R8_SINT:
                    return R8I_to_R8_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_R8UI:
        {
            switch (angleFormat)
            {
                case FormatID::R8_UINT:
                    return R8UI_to_R8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_R8_SNORM:
        {
            switch (angleFormat)
            {
                case FormatID::R8_SNORM:
                    return R8_SNORM_to_R8_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RG16F:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_FLOAT:
                    return RG16F_to_R16G16_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RG16I:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_SINT:
                    return RG16I_to_R16G16_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG16UI:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_UINT:
                    return RG16UI_to_R16G16_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG16_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_UNORM:
                    return RG16_EXT_to_R16G16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RG16_SNORM_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16_SNORM:
                    return RG16_SNORM_EXT_to_R16G16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RG32F:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32_FLOAT:
                    return RG32F_to_R32G32_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RG32I:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32_SINT:
                    return RG32I_to_R32G32_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG32UI:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32_UINT:
                    return RG32UI_to_R32G32_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG8:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8_UNORM:
                    return RG8_to_R8G8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RG8I:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8_SINT:
                    return RG8I_to_R8G8_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG8UI:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8_UINT:
                    return RG8UI_to_R8G8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RG8_SNORM:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8_SNORM:
                    return RG8_SNORM_to_R8G8_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB:
            return RGB_to_default;
        case GL_RGB10_A2:
        {
            switch (angleFormat)
            {
                case FormatID::R10G10B10A2_UNORM:
                    return RGB10_A2_to_R10G10B10A2_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB10_A2UI:
        {
            switch (angleFormat)
            {
                case FormatID::R10G10B10A2_UINT:
                    return RGB10_A2UI_to_R10G10B10A2_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB16F:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_FLOAT:
                    return RGB16F_to_R16G16B16A16_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB16I:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_SINT:
                    return RGB16I_to_R16G16B16A16_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB16UI:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_UINT:
                    return RGB16UI_to_R16G16B16A16_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB16_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_UNORM:
                    return RGB16_EXT_to_R16G16B16A16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB16_SNORM_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_SNORM:
                    return RGB16_SNORM_EXT_to_R16G16B16A16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB32F:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_FLOAT:
                    return RGB32F_to_R32G32B32A32_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB32I:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_SINT:
                    return RGB32I_to_R32G32B32A32_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB32UI:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_UINT:
                    return RGB32UI_to_R32G32B32A32_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB565:
        {
            switch (angleFormat)
            {
                case FormatID::B5G6R5_UNORM:
                    return RGB565_to_B5G6R5_UNORM;
                case FormatID::R5G6B5_UNORM:
                    return RGB565_to_R5G6B5_UNORM;
                case FormatID::R8G8B8A8_UNORM:
                    return RGB565_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB5_A1:
        {
            switch (angleFormat)
            {
                case FormatID::A1R5G5B5_UNORM:
                    return RGB5_A1_to_A1R5G5B5_UNORM;
                case FormatID::B5G5R5A1_UNORM:
                    return RGB5_A1_to_B5G5R5A1_UNORM;
                case FormatID::R8G8B8A8_UNORM:
                    return RGB5_A1_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB8:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return RGB8_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB8I:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_SINT:
                    return RGB8I_to_R8G8B8A8_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB8UI:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UINT:
                    return RGB8UI_to_R8G8B8A8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGB8_SNORM:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_SNORM:
                    return RGB8_SNORM_to_R8G8B8A8_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGB9_E5:
        {
            switch (angleFormat)
            {
                case FormatID::R9G9B9E5_SHAREDEXP:
                    return RGB9_E5_to_R9G9B9E5_SHAREDEXP;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA:
            return RGBA_to_default;
        case GL_RGBA16F:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_FLOAT:
                    return RGBA16F_to_R16G16B16A16_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA16I:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_SINT:
                    return RGBA16I_to_R16G16B16A16_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA16UI:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_UINT:
                    return RGBA16UI_to_R16G16B16A16_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA16_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_UNORM:
                    return RGBA16_EXT_to_R16G16B16A16_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA16_SNORM_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R16G16B16A16_SNORM:
                    return RGBA16_SNORM_EXT_to_R16G16B16A16_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA32F:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_FLOAT:
                    return RGBA32F_to_R32G32B32A32_FLOAT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA32I:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_SINT:
                    return RGBA32I_to_R32G32B32A32_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA32UI:
        {
            switch (angleFormat)
            {
                case FormatID::R32G32B32A32_UINT:
                    return RGBA32UI_to_R32G32B32A32_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA4:
        {
            switch (angleFormat)
            {
                case FormatID::B4G4R4A4_UNORM:
                    return RGBA4_to_B4G4R4A4_UNORM;
                case FormatID::R8G8B8A8_UNORM:
                    return RGBA4_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA8:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM:
                    return RGBA8_to_R8G8B8A8_UNORM;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA8I:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_SINT:
                    return RGBA8I_to_R8G8B8A8_SINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA8UI:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UINT:
                    return RGBA8UI_to_R8G8B8A8_UINT;
                default:
                    break;
            }
            break;
        }
        case GL_RGBA8_SNORM:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_SNORM:
                    return RGBA8_SNORM_to_R8G8B8A8_SNORM;
                default:
                    break;
            }
            break;
        }
        case GL_SRGB8:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM_SRGB:
                    return SRGB8_to_R8G8B8A8_UNORM_SRGB;
                default:
                    break;
            }
            break;
        }
        case GL_SRGB8_ALPHA8:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8B8A8_UNORM_SRGB:
                    return SRGB8_ALPHA8_to_R8G8B8A8_UNORM_SRGB;
                default:
                    break;
            }
            break;
        }
        case GL_STENCIL_INDEX8:
            return STENCIL_INDEX8_to_default;

        default:
            break;
    }
    // clang-format on
    static LoadFunctionMap emptyLoadFunctionsMap;
    return emptyLoadFunctionsMap;

}  // GetLoadFunctionsMap

}  // namespace angle
