/* Copyright 2018 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//! This module exports the bindings generated by bindgen form the baldrapi.h file.
//!
//! The Baldr API consists of a set of C functions and some associated types.

#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]

// We need to allow dead code because the Rustc compiler complains about variants never being
// constructed in TypeCode, which is true because these values come from C++.
#![allow(dead_code)]

include!(concat!(env!("OUT_DIR"), "/bindings.rs"));
