// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Armenian`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.1.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x000531, 0x000556],
    [0x000559, 0x00058A],
    [0x00058D, 0x00058F],
    [0x00FB13, 0x00FB17]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Armenian}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Armenian}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Armn}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Armn}"
);
testPropertyEscapes(
  /^\p{scx=Armenian}+$/u,
  matchSymbols,
  "\\p{scx=Armenian}"
);
testPropertyEscapes(
  /^\p{scx=Armn}+$/u,
  matchSymbols,
  "\\p{scx=Armn}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000530],
    [0x000557, 0x000558],
    [0x00058B, 0x00058C],
    [0x000590, 0x00DBFF],
    [0x00E000, 0x00FB12],
    [0x00FB18, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Armenian}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Armenian}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Armn}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Armn}"
);
testPropertyEscapes(
  /^\P{scx=Armenian}+$/u,
  nonMatchSymbols,
  "\\P{scx=Armenian}"
);
testPropertyEscapes(
  /^\P{scx=Armn}+$/u,
  nonMatchSymbols,
  "\\P{scx=Armn}"
);

reportCompare(0, 0);
