// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Tirhuta`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.1.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x001CF2
  ],
  ranges: [
    [0x000951, 0x000952],
    [0x000964, 0x000965],
    [0x00A830, 0x00A839],
    [0x011480, 0x0114C7],
    [0x0114D0, 0x0114D9]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Tirhuta}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Tirhuta}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Tirh}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Tirh}"
);
testPropertyEscapes(
  /^\p{scx=Tirhuta}+$/u,
  matchSymbols,
  "\\p{scx=Tirhuta}"
);
testPropertyEscapes(
  /^\p{scx=Tirh}+$/u,
  matchSymbols,
  "\\p{scx=Tirh}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000950],
    [0x000953, 0x000963],
    [0x000966, 0x001CF1],
    [0x001CF3, 0x00A82F],
    [0x00A83A, 0x00DBFF],
    [0x00E000, 0x01147F],
    [0x0114C8, 0x0114CF],
    [0x0114DA, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Tirhuta}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Tirhuta}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Tirh}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Tirh}"
);
testPropertyEscapes(
  /^\P{scx=Tirhuta}+$/u,
  nonMatchSymbols,
  "\\P{scx=Tirhuta}"
);
testPropertyEscapes(
  /^\P{scx=Tirh}+$/u,
  nonMatchSymbols,
  "\\P{scx=Tirh}"
);

reportCompare(0, 0);
