/* Any copyright is dedicated to the Public Domain.
 http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

// Test that flexbox highlighter is hidden on page navigation.

const TEST_URI = `
  <style type='text/css'>
    #flex {
      display: flex;
    }
  </style>
  <div id="flex"></div>
`;

const TEST_URI_2 = "data:text/html,<html><body>test</body></html>";

add_task(async function() {
  await addTab("data:text/html;charset=utf-8," + encodeURIComponent(TEST_URI));
  const { inspector, view } = await openRuleView();
  const { highlighters } = view;

  await selectNode("#flex", inspector);
  const container = getRuleViewProperty(view, "#flex", "display").valueSpan;
  const flexboxToggle = container.querySelector(".ruleview-flex");

  info("Toggling ON the flexbox highlighter from the rule-view.");
  const onHighlighterShown = highlighters.once("flexbox-highlighter-shown");
  flexboxToggle.click();
  await onHighlighterShown;
  ok(highlighters.flexboxHighlighterShown, "Flexbox highlighter is shown.");

  await navigateTo(inspector, TEST_URI_2);
  ok(!highlighters.flexboxHighlighterShown, "Flexbox highlighter is hidden.");
});
