/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const createStore = require("devtools/client/shared/redux/create-store");
const reducers = require("devtools/client/inspector/reducers");

module.exports = services =>
  createStore(reducers, {
    // Enable log middleware in tests
    shouldLog: true,
    thunkOptions: {
      // Needed for the ObjectInspector
      client: {
        createObjectFront: services && services.createObjectFront,
        createLongStringFront: services && services.createLongStringFront,
        releaseActor: services && services.releaseActor,
      },
    },
  });
