/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const stubPackets = new Map();
stubPackets.set(`console.log('foobar', 'test')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foobar",
      "test"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867478499,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log(undefined)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867478640,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.warn('danger, will robinson!')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "danger, will robinson!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "warn",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867478968,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log(NaN)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867479180,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log(null)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "null"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867479211,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('鼬')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "鼬"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867479994,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.clear()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867480243,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": {
      "count": 1,
      "label": "bar"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867480460,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.assert(false, {message: 'foobar'})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj31",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "message": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "foobar"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "assert",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source30",
    "styles": [],
    "timeStamp": 1572867480691,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('úṇĩçödê țĕșť')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867480913,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.dirxml(window)`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj34",
        "class": "Window",
        "ownPropertyLength": 811,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "ObjectWithURL",
          "url": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html"
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dirxml",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867481147,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('myarray', ['red', 'green', 'blue'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myarray",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj36",
        "class": "Array",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "red",
            "green",
            "blue"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867481361,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('myregex', /a.b.c/)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myregex",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj38",
        "class": "RegExp",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "displayString": "/a.b.c/"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867481440,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.table(['red', 'green', 'blue']);`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj40",
        "class": "Array",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": null,
        "ownProperties": {
          "0": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "red"
          },
          "1": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "green"
          },
          "2": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "blue"
          }
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867481889,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myobject",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj42",
        "class": "Object",
        "ownPropertyLength": 3,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "red": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "redValue"
            },
            "green": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "greenValue"
            },
            "blue": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "blueValue"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 3,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867481960,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.debug('debug message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "debug message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "debug",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867482257,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.info('info message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "info message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "info",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867482321,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.error('error message');`, {
  "message": {
    "addonId": "",
    "arguments": [
      "error message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "error",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source30",
    "styles": [],
    "timeStamp": 1572867482624,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ],
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('mymap')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "mymap",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj47",
        "class": "Map",
        "ownPropertyLength": 0,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "MapLike",
          "size": 2,
          "entries": [
            [
              "key1",
              "value1"
            ],
            [
              "key2",
              "value2"
            ]
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source46",
    "styles": [],
    "timeStamp": 1572867482662,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log('myset')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "myset",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj49",
        "class": "Set",
        "ownPropertyLength": 0,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "ArrayLike",
          "length": 2,
          "items": [
            "a",
            "b"
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867483160,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.trace()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "testStacktraceFiltering",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source50",
    "timeStamp": 1572867483200,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 5,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.trace('bar', {'foo': 'bar'}, [1,2,3])`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj52",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "foo": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "bar"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      },
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj53",
        "class": "Array",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            1,
            2,
            3
          ]
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "testStacktraceWithLog",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source51",
    "timeStamp": 1572867483279,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceWithLog",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source51"
      },
      {
        "columnNumber": 5,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.time('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867483516,
    "timer": {
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`timerAlreadyExists`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483518,
    "timer": {
      "error": "timerAlreadyExists",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.timeLog('bar') - 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483519,
    "timer": {
      "duration": 4,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.timeLog('bar') - 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      "second call",
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj55",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "state": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": 1
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source46",
    "timeStamp": 1572867483521,
    "timer": {
      "duration": 5,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.timeEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483524,
    "timer": {
      "duration": 9,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`timeEnd.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483526,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`timeLog.timerDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867483527,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.table('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867483805,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.table(['a', 'b', 'c'])`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj58",
        "class": "Array",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": null,
        "ownProperties": {
          "0": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "a"
          },
          "1": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "b"
          },
          "2": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "c"
          }
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "timeStamp": 1572867484093,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.group('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867484276,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupEnd('bar')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867484277,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupCollapsed('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867484325,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupEnd('foo')`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867484326,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.group()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [],
    "timeStamp": 1572867484564,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupEnd()`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867484565,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log(%cfoobar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
      "color:red; line-height: 1.5; background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867484724,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log("%cHello%c|%cWorld")`, {
  "message": {
    "addonId": "",
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source63",
    "styles": [
      "color:red",
      "",
      "color: blue"
    ],
    "timeStamp": 1572867484739,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.group(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867484762,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupEnd(%cfoo%cbar)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867484763,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupCollapsed(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "baz"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source48",
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1572867484842,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.groupEnd(%cfoo%cbaz)`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source54",
    "timeStamp": 1572867484842,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.dir({C, M, Y, K})`, {
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server0.conn0.child1/obj67",
        "class": "Object",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "cyan": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "C"
            },
            "magenta": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "M"
            },
            "yellow": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "Y"
            },
            "black": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "K"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 4,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dir",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "timeStamp": 1572867484881,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | default: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 1,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485168,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | default: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 2,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485169,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | test counter: 1`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 1,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485170,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | test counter: 2`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 2,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485171,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | default: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 3,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485172,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | clear`, {
  "message": {
    "addonId": "",
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485175,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | default: 4`, {
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 4,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485176,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.count | test counter: 3`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 3,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 9,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485187,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.countReset | test counter: 0`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "count": 0,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 10,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485188,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.countReset | counterDoesntExist`, {
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "counter": {
      "error": "counterDoesntExist",
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 11,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source68",
    "timeStamp": 1572867485195,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

stubPackets.set(`console.log escaped characters`, {
  "message": {
    "addonId": "",
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "sourceId": "server0.conn0.child1/source22",
    "styles": [],
    "timeStamp": 1572867485291,
    "timer": null,
    "workerType": "none",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "type": "consoleAPICall"
});

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  stubPreparedMessages,
  stubPackets,
};
