/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const stubPackets = new Map();
stubPackets.set(`new Date(0)`, {
  "resultID": "1573385647471-0",
  "input": "new Date(0)",
  "result": {
    "type": "object",
    "actor": "server0.conn0.child1/obj23",
    "class": "Date",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "preview": {
      "timestamp": 0
    }
  },
  "timestamp": 1572868073590,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`asdf()`, {
  "resultID": "1573385647554-1",
  "errorMessageName": "JSMSG_NOT_DEFINED",
  "exception": {
    "type": "object",
    "actor": "server0.conn0.child1/obj25",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "preview": {
      "kind": "Error",
      "name": "ReferenceError",
      "message": "asdf is not defined",
      "stack": "@debugger eval code:1:1\n",
      "fileName": "debugger eval code",
      "lineNumber": 1,
      "columnNumber": 1
    }
  },
  "exceptionMessage": "ReferenceError: asdf is not defined",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 1
  },
  "input": "asdf()",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868073933,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`1 + @`, {
  "resultID": "1573385647562-2",
  "errorMessageName": "JSMSG_ILLEGAL_CHARACTER",
  "exception": {
    "type": "object",
    "actor": "server0.conn0.child1/obj26",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "preview": {
      "kind": "Error",
      "name": "SyntaxError",
      "message": "illegal character",
      "stack": "",
      "fileName": "debugger eval code",
      "lineNumber": 1,
      "columnNumber": 4
    }
  },
  "exceptionMessage": "SyntaxError: illegal character",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Illegal_character?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 4
  },
  "input": "1 + @",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868073955,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`inspect({a: 1})`, {
  "resultID": "1573385647565-3",
  "helperResult": {
    "type": "inspectObject",
    "input": "inspect({a: 1})",
    "object": {
      "type": "object",
      "actor": "server0.conn0.child1/obj28",
      "class": "Object",
      "ownPropertyLength": 1,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "a": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": 1
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  },
  "input": "inspect({a: 1})",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868073976,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`cd(document)`, {
  "resultID": "1573385647570-4",
  "helperResult": {
    "type": "error",
    "message": "cdFunctionInvalidArgument"
  },
  "input": "cd(document)",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868074010,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`undefined`, {
  "resultID": "1573385647572-5",
  "input": "undefined",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868074023,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`longString message Error`, {
  "resultID": "1573385647576-6",
  "exception": {
    "type": "object",
    "actor": "server0.conn0.child1/obj32",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": {
        "type": "longString",
        "actor": "server0.conn0.child1/longstractor33",
        "length": 110000,
        "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
      },
      "stack": "@debugger eval code:1:7\n",
      "fileName": "debugger eval code",
      "lineNumber": 1,
      "columnNumber": 7
    }
  },
  "exceptionMessage": {
    "type": "longString",
    "actor": "server0.conn0.child1/longstractor34",
    "length": 110007,
    "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
  },
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"Long error \".repeat(10000))",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868074038,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`eval throw ""`, {
  "resultID": "1573385647580-7",
  "exception": "",
  "exceptionMessage": "",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"\"",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868074059,
  "from": "server0.conn0.child1/consoleActor2"
});

stubPackets.set(`eval throw "tomato"`, {
  "resultID": "1573385647583-8",
  "exception": "tomato",
  "exceptionMessage": "tomato",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"tomato\"",
  "result": {
    "type": "undefined"
  },
  "timestamp": 1572868074071,
  "from": "server0.conn0.child1/consoleActor2"
});

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  stubPreparedMessages,
  stubPackets,
};
