// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Logical_Order_Exception`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.1.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x0019BA,
    0x00AAB9
  ],
  ranges: [
    [0x000E40, 0x000E44],
    [0x000EC0, 0x000EC4],
    [0x0019B5, 0x0019B7],
    [0x00AAB5, 0x00AAB6],
    [0x00AABB, 0x00AABC]
  ]
});
testPropertyEscapes(
  /^\p{Logical_Order_Exception}+$/u,
  matchSymbols,
  "\\p{Logical_Order_Exception}"
);
testPropertyEscapes(
  /^\p{LOE}+$/u,
  matchSymbols,
  "\\p{LOE}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x00AABA
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000E3F],
    [0x000E45, 0x000EBF],
    [0x000EC5, 0x0019B4],
    [0x0019B8, 0x0019B9],
    [0x0019BB, 0x00AAB4],
    [0x00AAB7, 0x00AAB8],
    [0x00AABD, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Logical_Order_Exception}+$/u,
  nonMatchSymbols,
  "\\P{Logical_Order_Exception}"
);
testPropertyEscapes(
  /^\P{LOE}+$/u,
  nonMatchSymbols,
  "\\P{LOE}"
);

reportCompare(0, 0);
