// |reftest| skip -- Intl.DisplayNames is not supported
// Copyright (C) 2019 Leo Balter. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-Intl.DisplayNames
description: >
  Return abrupt completion from GetOption localeMatcher
info: |
  Intl.DisplayNames ([ locales [ , options ]])

  1. If NewTarget is undefined, throw a TypeError exception.
  2. Let displayNames be ? OrdinaryCreateFromConstructor(NewTarget, "%DisplayNamesPrototype%",
    « [[InitializedDisplayNames]], [[Locale]], [[Style]], [[Type]], [[Fallback]], [[Fields]] »).
  ...
  4. If options is undefined, then
    a. Let options be ObjectCreate(null).
  5. Else
    a. Let options be ? ToObject(options).
  ...
  8. Let matcher be ? GetOption(options, "localeMatcher", "string", « "lookup", "best fit" », "best fit").

  GetOption ( options, property, type, values, fallback )

  1. Let value be ? Get(options, property).
  ...
features: [Intl.DisplayNames, Symbol]
locale: [en]
---*/

var options = {
  localeMatcher: {
    toString() {
      throw new Test262Error();
    }
  }
};

assert.throws(Test262Error, () => {
  new Intl.DisplayNames('en', options);
}, 'from toString');

options.localeMatcher = {
  toString: undefined,
  valueOf() {
    throw new Test262Error();
  }
};

assert.throws(Test262Error, () => {
  new Intl.DisplayNames('en', options);
}, 'from valueOf');

options.localeMatcher = {
  [Symbol.toPrimitive]() {
    throw new Test262Error();
  }
};

assert.throws(Test262Error, () => {
  new Intl.DisplayNames('en', options);
}, 'from ToPrimitive');

options.localeMatcher = Symbol();

assert.throws(TypeError, () => {
  new Intl.DisplayNames('en', options);
}, 'symbol value');

reportCompare(0, 0);
