// source: CLDR file common/bcp47/number.xml; version CLDR 37.
// https://github.com/unicode-org/cldr/blob/master/common/bcp47/number.xml
// https://github.com/unicode-org/cldr/blob/master/common/supplemental/numberingSystems.xml
const numberingSystems = {
    "adlm": {digits: "𞥐𞥑𞥒𞥓𞥔𞥕𞥖𞥗𞥘𞥙", algorithmic: false},
    "ahom": {digits: "𑜰𑜱𑜲𑜳𑜴𑜵𑜶𑜷𑜸𑜹", algorithmic: false},
    "arab": {digits: "٠١٢٣٤٥٦٧٨٩", algorithmic: false},
    "arabext": {digits: "۰۱۲۳۴۵۶۷۸۹", algorithmic: false},
    "armn": {algorithmic: true},
    "armnlow": {algorithmic: true},
    "bali": {digits: "᭐᭑᭒᭓᭔᭕᭖᭗᭘᭙", algorithmic: false},
    "beng": {digits: "০১২৩৪৫৬৭৮৯", algorithmic: false},
    "bhks": {digits: "𑱐𑱑𑱒𑱓𑱔𑱕𑱖𑱗𑱘𑱙", algorithmic: false},
    "brah": {digits: "𑁦𑁧𑁨𑁩𑁪𑁫𑁬𑁭𑁮𑁯", algorithmic: false},
    "cakm": {digits: "𑄶𑄷𑄸𑄹𑄺𑄻𑄼𑄽𑄾𑄿", algorithmic: false},
    "cham": {digits: "꩐꩑꩒꩓꩔꩕꩖꩗꩘꩙", algorithmic: false},
    "cyrl": {algorithmic: true},
    "deva": {digits: "०१२३४५६७८९", algorithmic: false},
    "diak": {digits: "𑥐𑥑𑥒𑥓𑥔𑥕𑥖𑥗𑥘𑥙", algorithmic: false},
    "ethi": {algorithmic: true},
    "fullwide": {digits: "０１２３４５６７８９", algorithmic: false},
    "geor": {algorithmic: true},
    "gong": {digits: "𑶠𑶡𑶢𑶣𑶤𑶥𑶦𑶧𑶨𑶩", algorithmic: false},
    "gonm": {digits: "𑵐𑵑𑵒𑵓𑵔𑵕𑵖𑵗𑵘𑵙", algorithmic: false},
    "grek": {algorithmic: true},
    "greklow": {algorithmic: true},
    "gujr": {digits: "૦૧૨૩૪૫૬૭૮૯", algorithmic: false},
    "guru": {digits: "੦੧੨੩੪੫੬੭੮੯", algorithmic: false},
    "hanidays": {algorithmic: true},
    "hanidec": {digits: "〇一二三四五六七八九", algorithmic: false},
    "hans": {algorithmic: true},
    "hansfin": {algorithmic: true},
    "hant": {algorithmic: true},
    "hantfin": {algorithmic: true},
    "hebr": {algorithmic: true},
    "hmng": {digits: "𖭐𖭑𖭒𖭓𖭔𖭕𖭖𖭗𖭘𖭙", algorithmic: false},
    "hmnp": {digits: "𞅀𞅁𞅂𞅃𞅄𞅅𞅆𞅇𞅈𞅉", algorithmic: false},
    "java": {digits: "꧐꧑꧒꧓꧔꧕꧖꧗꧘꧙", algorithmic: false},
    "jpan": {algorithmic: true},
    "jpanfin": {algorithmic: true},
    "jpanyear": {algorithmic: true},
    "kali": {digits: "꤀꤁꤂꤃꤄꤅꤆꤇꤈꤉", algorithmic: false},
    "khmr": {digits: "០១២៣៤៥៦៧៨៩", algorithmic: false},
    "knda": {digits: "೦೧೨೩೪೫೬೭೮೯", algorithmic: false},
    "lana": {digits: "᪀᪁᪂᪃᪄᪅᪆᪇᪈᪉", algorithmic: false},
    "lanatham": {digits: "᪐᪑᪒᪓᪔᪕᪖᪗᪘᪙", algorithmic: false},
    "laoo": {digits: "໐໑໒໓໔໕໖໗໘໙", algorithmic: false},
    "latn": {digits: "0123456789", algorithmic: false},
    "lepc": {digits: "᱀᱁᱂᱃᱄᱅᱆᱇᱈᱉", algorithmic: false},
    "limb": {digits: "᥆᥇᥈᥉᥊᥋᥌᥍᥎᥏", algorithmic: false},
    "mathbold": {digits: "𝟎𝟏𝟐𝟑𝟒𝟓𝟔𝟕𝟖𝟗", algorithmic: false},
    "mathdbl": {digits: "𝟘𝟙𝟚𝟛𝟜𝟝𝟞𝟟𝟠𝟡", algorithmic: false},
    "mathmono": {digits: "𝟶𝟷𝟸𝟹𝟺𝟻𝟼𝟽𝟾𝟿", algorithmic: false},
    "mathsanb": {digits: "𝟬𝟭𝟮𝟯𝟰𝟱𝟲𝟳𝟴𝟵", algorithmic: false},
    "mathsans": {digits: "𝟢𝟣𝟤𝟥𝟦𝟧𝟨𝟩𝟪𝟫", algorithmic: false},
    "mlym": {digits: "൦൧൨൩൪൫൬൭൮൯", algorithmic: false},
    "modi": {digits: "𑙐𑙑𑙒𑙓𑙔𑙕𑙖𑙗𑙘𑙙", algorithmic: false},
    "mong": {digits: "᠐᠑᠒᠓᠔᠕᠖᠗᠘᠙", algorithmic: false},
    "mroo": {digits: "𖩠𖩡𖩢𖩣𖩤𖩥𖩦𖩧𖩨𖩩", algorithmic: false},
    "mtei": {digits: "꯰꯱꯲꯳꯴꯵꯶꯷꯸꯹", algorithmic: false},
    "mymr": {digits: "၀၁၂၃၄၅၆၇၈၉", algorithmic: false},
    "mymrshan": {digits: "႐႑႒႓႔႕႖႗႘႙", algorithmic: false},
    "mymrtlng": {digits: "꧰꧱꧲꧳꧴꧵꧶꧷꧸꧹", algorithmic: false},
    "newa": {digits: "𑑐𑑑𑑒𑑓𑑔𑑕𑑖𑑗𑑘𑑙", algorithmic: false},
    "nkoo": {digits: "߀߁߂߃߄߅߆߇߈߉", algorithmic: false},
    "olck": {digits: "᱐᱑᱒᱓᱔᱕᱖᱗᱘᱙", algorithmic: false},
    "orya": {digits: "୦୧୨୩୪୫୬୭୮୯", algorithmic: false},
    "osma": {digits: "𐒠𐒡𐒢𐒣𐒤𐒥𐒦𐒧𐒨𐒩", algorithmic: false},
    "rohg": {digits: "𐴰𐴱𐴲𐴳𐴴𐴵𐴶𐴷𐴸𐴹", algorithmic: false},
    "roman": {algorithmic: true},
    "romanlow": {algorithmic: true},
    "saur": {digits: "꣐꣑꣒꣓꣔꣕꣖꣗꣘꣙", algorithmic: false},
    "segment": {digits: "🯰🯱🯲🯳🯴🯵🯶🯷🯸🯹", algorithmic: false},
    "shrd": {digits: "𑇐𑇑𑇒𑇓𑇔𑇕𑇖𑇗𑇘𑇙", algorithmic: false},
    "sind": {digits: "𑋰𑋱𑋲𑋳𑋴𑋵𑋶𑋷𑋸𑋹", algorithmic: false},
    "sinh": {digits: "෦෧෨෩෪෫෬෭෮෯", algorithmic: false},
    "sora": {digits: "𑃰𑃱𑃲𑃳𑃴𑃵𑃶𑃷𑃸𑃹", algorithmic: false},
    "sund": {digits: "᮰᮱᮲᮳᮴᮵᮶᮷᮸᮹", algorithmic: false},
    "takr": {digits: "𑛀𑛁𑛂𑛃𑛄𑛅𑛆𑛇𑛈𑛉", algorithmic: false},
    "talu": {digits: "᧐᧑᧒᧓᧔᧕᧖᧗᧘᧙", algorithmic: false},
    "taml": {algorithmic: true},
    "tamldec": {digits: "௦௧௨௩௪௫௬௭௮௯", algorithmic: false},
    "telu": {digits: "౦౧౨౩౪౫౬౭౮౯", algorithmic: false},
    "thai": {digits: "๐๑๒๓๔๕๖๗๘๙", algorithmic: false},
    "tibt": {digits: "༠༡༢༣༤༥༦༧༨༩", algorithmic: false},
    "tirh": {digits: "𑓐𑓑𑓒𑓓𑓔𑓕𑓖𑓗𑓘𑓙", algorithmic: false},
    "vaii": {digits: "꘠꘡꘢꘣꘤꘥꘦꘧꘨꘩", algorithmic: false},
    "wara": {digits: "𑣠𑣡𑣢𑣣𑣤𑣥𑣦𑣧𑣨𑣩", algorithmic: false},
    "wcho": {digits: "𞋰𞋱𞋲𞋳𞋴𞋵𞋶𞋷𞋸𞋹", algorithmic: false},
};
