/**
 * @fileoverview Defines the environment for jsm files.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

"use strict";

module.exports = {
  globals: {
    // This list of items is currently obtained manually from the list of
    // mozilla::dom::constructor::id::ID enumerations in an object directory
    // generated dom/bindings/RegisterBindings.cpp
    APZHitResultFlags: false,
    AbortController: false,
    AbortSignal: false,
    AccessibleNode: false,
    Addon: false,
    AddonEvent: false,
    AddonInstall: false,
    AddonManager: true,
    AddonManagerPermissions: false,
    AnalyserNode: false,
    Animation: false,
    AnimationEffect: false,
    AnimationEvent: false,
    AnimationPlaybackEvent: false,
    AnimationTimeline: false,
    AnonymousContent: false,
    Attr: false,
    AudioBuffer: false,
    AudioBufferSourceNode: false,
    AudioContext: false,
    AudioDestinationNode: false,
    AudioListener: false,
    AudioNode: false,
    AudioParam: false,
    AudioParamMap: false,
    AudioProcessingEvent: false,
    AudioScheduledSourceNode: false,
    AudioTrack: false,
    AudioTrackList: false,
    AudioWorklet: false,
    AudioWorkletNode: false,
    AuthenticatorAssertionResponse: false,
    AuthenticatorAttestationResponse: false,
    AuthenticatorResponse: false,
    BarProp: false,
    BaseAudioContext: false,
    BatteryManager: false,
    BeforeUnloadEvent: false,
    BiquadFilterNode: false,
    Blob: false,
    BlobEvent: false,
    BoxObject: false,
    BroadcastChannel: false,
    BrowsingContext: false,
    CanonicalBrowsingContext: false,
    CDATASection: false,
    CSS: false,
    CSS2Properties: false,
    CSSAnimation: false,
    CSSConditionRule: false,
    CSSCounterStyleRule: false,
    CSSFontFaceRule: false,
    CSSFontFeatureValuesRule: false,
    CSSGroupingRule: false,
    CSSImportRule: false,
    CSSKeyframeRule: false,
    CSSKeyframesRule: false,
    CSSMediaRule: false,
    CSSMozDocumentRule: false,
    CSSNamespaceRule: false,
    CSSPageRule: false,
    CSSPseudoElement: false,
    CSSRule: false,
    CSSRuleList: false,
    CSSStyleDeclaration: false,
    CSSStyleRule: false,
    CSSStyleSheet: false,
    CSSSupportsRule: false,
    CSSTransition: false,
    Cache: false,
    CacheStorage: false,
    CanvasCaptureMediaStream: false,
    CanvasGradient: false,
    CanvasPattern: false,
    CanvasRenderingContext2D: false,
    CaretPosition: false,
    CaretStateChangedEvent: false,
    ChannelMergerNode: false,
    ChannelSplitterNode: false,
    ChannelWrapper: false,
    CharacterData: false,
    CheckerboardReportService: false,
    ChildProcessMessageManager: false,
    ChildSHistory: false,
    ChromeMessageBroadcaster: false,
    ChromeMessageSender: false,
    ChromeNodeList: false,
    ChromeUtils: false,
    ChromeWorker: false,
    Clipboard: false,
    ClipboardEvent: false,
    ClonedErrorHolder: false,
    CloseEvent: false,
    CommandEvent: false,
    Comment: false,
    CompositionEvent: false,
    ConsoleInstance: false,
    ConstantSourceNode: false,
    ContentFrameMessageManager: false,
    ContentProcessMessageManager: false,
    ConvolverNode: false,
    CreateOfferRequest: false,
    Credential: false,
    CredentialsContainer: false,
    Crypto: false,
    CryptoKey: false,
    CustomElementRegistry: false,
    CustomEvent: false,
    DOMError: false,
    DOMException: false,
    DOMImplementation: false,
    DOMLocalization: false,
    DOMMatrix: false,
    DOMMatrixReadOnly: false,
    DOMParser: false,
    DOMPoint: false,
    DOMPointReadOnly: false,
    DOMQuad: false,
    DOMRect: false,
    DOMRectList: false,
    DOMRectReadOnly: false,
    DOMRequest: false,
    DOMStringList: false,
    DOMStringMap: false,
    DOMTokenList: false,
    DataTransfer: false,
    DataTransferItem: false,
    DataTransferItemList: false,
    DelayNode: false,
    DeprecationReportBody: false,
    DeviceLightEvent: false,
    DeviceMotionEvent: false,
    DeviceOrientationEvent: false,
    DeviceProximityEvent: false,
    Directory: false,
    Document: false,
    DocumentFragment: false,
    DocumentTimeline: false,
    DocumentType: false,
    DominatorTree: false,
    DragEvent: false,
    DynamicsCompressorNode: false,
    Element: false,
    ErrorEvent: false,
    Event: false,
    EventSource: false,
    EventTarget: false,
    FeaturePolicyViolationReportBody: false,
    FetchObserver: false,
    File: false,
    FileList: false,
    FileReader: false,
    FileSystem: false,
    FileSystemDirectoryEntry: false,
    FileSystemDirectoryReader: false,
    FileSystemEntry: false,
    FileSystemFileEntry: false,
    Flex: false,
    FlexItemValues: false,
    FlexLineValues: false,
    FluentBundle: false,
    FluentResource: false,
    FocusEvent: false,
    FontFace: false,
    FontFaceSet: false,
    FontFaceSetLoadEvent: false,
    FormData: false,
    FrameLoader: false,
    GainNode: false,
    Gamepad: false,
    GamepadAxisMoveEvent: false,
    GamepadButton: false,
    GamepadButtonEvent: false,
    GamepadEvent: false,
    GamepadHapticActuator: false,
    GamepadPose: false,
    GamepadServiceTest: false,
    Grid: false,
    GridArea: false,
    GridDimension: false,
    GridLine: false,
    GridLines: false,
    GridTrack: false,
    GridTracks: false,
    HTMLAllCollection: false,
    HTMLAnchorElement: false,
    HTMLAreaElement: false,
    HTMLAudioElement: false,
    Audio: false,
    HTMLBRElement: false,
    HTMLBaseElement: false,
    HTMLBodyElement: false,
    HTMLButtonElement: false,
    HTMLCanvasElement: false,
    HTMLCollection: false,
    HTMLDListElement: false,
    HTMLDataElement: false,
    HTMLDataListElement: false,
    HTMLDetailsElement: false,
    HTMLDialogElement: false,
    HTMLDirectoryElement: false,
    HTMLDivElement: false,
    HTMLDocument: false,
    HTMLElement: false,
    HTMLEmbedElement: false,
    HTMLFieldSetElement: false,
    HTMLFontElement: false,
    HTMLFormControlsCollection: false,
    HTMLFormElement: false,
    HTMLFrameElement: false,
    HTMLFrameSetElement: false,
    HTMLHRElement: false,
    HTMLHeadElement: false,
    HTMLHeadingElement: false,
    HTMLHtmlElement: false,
    HTMLIFrameElement: false,
    HTMLImageElement: false,
    Image: false,
    HTMLInputElement: false,
    HTMLLIElement: false,
    HTMLLabelElement: false,
    HTMLLegendElement: false,
    HTMLLinkElement: false,
    HTMLMapElement: false,
    HTMLMarqueeElement: false,
    HTMLMediaElement: false,
    HTMLMenuElement: false,
    HTMLMenuItemElement: false,
    HTMLMetaElement: false,
    HTMLMeterElement: false,
    HTMLModElement: false,
    HTMLOListElement: false,
    HTMLObjectElement: false,
    HTMLOptGroupElement: false,
    HTMLOptionElement: false,
    Option: false,
    HTMLOptionsCollection: false,
    HTMLOutputElement: false,
    HTMLParagraphElement: false,
    HTMLParamElement: false,
    HTMLPictureElement: false,
    HTMLPreElement: false,
    HTMLProgressElement: false,
    HTMLQuoteElement: false,
    HTMLScriptElement: false,
    HTMLSelectElement: false,
    HTMLSlotElement: false,
    HTMLSourceElement: false,
    HTMLSpanElement: false,
    HTMLStyleElement: false,
    HTMLTableCaptionElement: false,
    HTMLTableCellElement: false,
    HTMLTableColElement: false,
    HTMLTableElement: false,
    HTMLTableRowElement: false,
    HTMLTableSectionElement: false,
    HTMLTemplateElement: false,
    HTMLTextAreaElement: false,
    HTMLTimeElement: false,
    HTMLTitleElement: false,
    HTMLTrackElement: false,
    HTMLUListElement: false,
    HTMLUnknownElement: false,
    HTMLVideoElement: false,
    HashChangeEvent: false,
    Headers: false,
    HeapSnapshot: false,
    HiddenPluginEvent: false,
    History: false,
    IDBCursor: false,
    IDBCursorWithValue: false,
    IDBDatabase: false,
    IDBFactory: false,
    IDBFileHandle: false,
    IDBFileRequest: false,
    IDBIndex: false,
    IDBKeyRange: false,
    IDBLocaleAwareKeyRange: false,
    IDBMutableFile: false,
    IDBObjectStore: false,
    IDBOpenDBRequest: false,
    IDBRequest: false,
    IDBTransaction: false,
    IDBVersionChangeEvent: false,
    IIRFilterNode: false,
    IdleDeadline: false,
    ImageBitmap: false,
    ImageBitmapRenderingContext: false,
    ImageCapture: false,
    ImageCaptureErrorEvent: false,
    ImageData: false,
    ImageDocument: false,
    InputEvent: false,
    InspectorFontFace: false,
    InspectorUtils: false,
    InstallTriggerImpl: false,
    IntersectionObserver: false,
    IntersectionObserverEntry: false,
    IOUtils: false,
    JSProcessActorChild: false,
    JSProcessActorParent: false,
    JSWindowActorChild: false,
    JSWindowActorParent: false,
    KeyEvent: false,
    KeyboardEvent: false,
    KeyframeEffect: false,
    Localization: false,
    Location: false,
    MIDIAccess: false,
    MIDIConnectionEvent: false,
    MIDIInput: false,
    MIDIInputMap: false,
    MIDIMessageEvent: false,
    MIDIOutput: false,
    MIDIOutputMap: false,
    MIDIPort: false,
    MatchGlob: false,
    MatchPattern: false,
    MatchPatternSet: false,
    MediaCapabilities: false,
    MediaCapabilitiesInfo: false,
    MediaControlService: false,
    MediaDeviceInfo: false,
    MediaDevices: false,
    MediaElementAudioSourceNode: false,
    MediaEncryptedEvent: false,
    MediaError: false,
    MediaKeyError: false,
    MediaKeyMessageEvent: false,
    MediaKeySession: false,
    MediaKeyStatusMap: false,
    MediaKeySystemAccess: false,
    MediaKeys: false,
    MediaList: false,
    MediaQueryList: false,
    MediaQueryListEvent: false,
    MediaRecorder: false,
    MediaRecorderErrorEvent: false,
    MediaSource: false,
    MediaStream: false,
    MediaStreamAudioDestinationNode: false,
    MediaStreamAudioSourceNode: false,
    MediaStreamEvent: false,
    MediaStreamTrack: false,
    MediaStreamTrackEvent: false,
    MerchantValidationEvent: false,
    MessageBroadcaster: false,
    MessageChannel: false,
    MessageEvent: false,
    MessageListenerManager: false,
    MessagePort: false,
    MessageSender: false,
    MimeType: false,
    MimeTypeArray: false,
    MouseEvent: false,
    MouseScrollEvent: false,
    MozCanvasPrintState: false,
    MozDocumentMatcher: false,
    MozDocumentObserver: false,
    MozQueryInterface: false,
    MozSharedMap: false,
    MozSharedMapChangeEvent: false,
    MozStorageAsyncStatementParams: false,
    MozStorageStatementParams: false,
    MozStorageStatementRow: false,
    MozWritableSharedMap: false,
    MutationEvent: false,
    MutationObserver: false,
    MutationRecord: false,
    NamedNodeMap: false,
    Navigator: false,
    NetworkInformation: false,
    Node: false,
    NodeFilter: false,
    NodeIterator: false,
    NodeList: false,
    Notification: false,
    NotifyPaintEvent: false,
    OfflineAudioCompletionEvent: false,
    OfflineAudioContext: false,
    OfflineResourceList: false,
    OffscreenCanvas: false,
    OscillatorNode: false,
    PageTransitionEvent: false,
    PaintRequest: false,
    PaintRequestList: false,
    PannerNode: false,
    ParentProcessMessageManager: false,
    Path2D: false,
    PathUtils: false,
    PaymentAddress: false,
    PaymentMethodChangeEvent: false,
    PaymentRequest: false,
    PaymentRequestUpdateEvent: false,
    PaymentResponse: false,
    PeerConnectionImpl: false,
    PeerConnectionObserver: false,
    Performance: false,
    PerformanceEntry: false,
    PerformanceEntryEvent: false,
    PerformanceMark: false,
    PerformanceMeasure: false,
    PerformanceNavigation: false,
    PerformanceNavigationTiming: false,
    PerformanceObserver: false,
    PerformanceObserverEntryList: false,
    PerformanceResourceTiming: false,
    PerformanceServerTiming: false,
    PerformanceTiming: false,
    PeriodicWave: false,
    PermissionStatus: false,
    Permissions: false,
    PlacesBookmark: false,
    PlacesBookmarkAddition: false,
    PlacesBookmarkRemoved: false,
    PlacesEvent: false,
    PlacesObservers: false,
    PlacesVisit: false,
    PlacesWeakCallbackWrapper: false,
    Plugin: false,
    PluginArray: false,
    PluginCrashedEvent: false,
    PointerEvent: false,
    PopStateEvent: false,
    PopupBlockedEvent: false,
    PrecompiledScript: false,
    Presentation: false,
    PresentationAvailability: false,
    PresentationConnection: false,
    PresentationConnectionAvailableEvent: false,
    PresentationConnectionCloseEvent: false,
    PresentationConnectionList: false,
    PresentationReceiver: false,
    PresentationRequest: false,
    PrioEncoder: false,
    ProcessMessageManager: false,
    ProcessingInstruction: false,
    ProgressEvent: false,
    PromiseDebugging: false,
    PromiseRejectionEvent: false,
    PublicKeyCredential: false,
    PushManager: false,
    PushManagerImpl: false,
    PushSubscription: false,
    PushSubscriptionOptions: false,
    RTCCertificate: false,
    RTCDTMFSender: false,
    RTCDTMFToneChangeEvent: false,
    RTCDataChannel: false,
    RTCDataChannelEvent: false,
    RTCIceCandidate: false,
    RTCPeerConnection: false,
    RTCPeerConnectionIceEvent: false,
    RTCPeerConnectionStatic: false,
    RTCRtpReceiver: false,
    RTCRtpSender: false,
    RTCRtpTransceiver: false,
    RTCSessionDescription: false,
    RTCStatsReport: false,
    RTCTrackEvent: false,
    RadioNodeList: false,
    Range: false,
    Report: false,
    ReportBody: false,
    ReportingObserver: false,
    Request: false,
    Response: false,
    SessionStoreUtils: false,
    SVGAElement: false,
    SVGAngle: false,
    SVGAnimateElement: false,
    SVGAnimateMotionElement: false,
    SVGAnimateTransformElement: false,
    SVGAnimatedAngle: false,
    SVGAnimatedBoolean: false,
    SVGAnimatedEnumeration: false,
    SVGAnimatedInteger: false,
    SVGAnimatedLength: false,
    SVGAnimatedLengthList: false,
    SVGAnimatedNumber: false,
    SVGAnimatedNumberList: false,
    SVGAnimatedPreserveAspectRatio: false,
    SVGAnimatedRect: false,
    SVGAnimatedString: false,
    SVGAnimatedTransformList: false,
    SVGAnimationElement: false,
    SVGCircleElement: false,
    SVGClipPathElement: false,
    SVGComponentTransferFunctionElement: false,
    SVGDefsElement: false,
    SVGDescElement: false,
    SVGElement: false,
    SVGEllipseElement: false,
    SVGFEBlendElement: false,
    SVGFEColorMatrixElement: false,
    SVGFEComponentTransferElement: false,
    SVGFECompositeElement: false,
    SVGFEConvolveMatrixElement: false,
    SVGFEDiffuseLightingElement: false,
    SVGFEDisplacementMapElement: false,
    SVGFEDistantLightElement: false,
    SVGFEDropShadowElement: false,
    SVGFEFloodElement: false,
    SVGFEFuncAElement: false,
    SVGFEFuncBElement: false,
    SVGFEFuncGElement: false,
    SVGFEFuncRElement: false,
    SVGFEGaussianBlurElement: false,
    SVGFEImageElement: false,
    SVGFEMergeElement: false,
    SVGFEMergeNodeElement: false,
    SVGFEMorphologyElement: false,
    SVGFEOffsetElement: false,
    SVGFEPointLightElement: false,
    SVGFESpecularLightingElement: false,
    SVGFESpotLightElement: false,
    SVGFETileElement: false,
    SVGFETurbulenceElement: false,
    SVGFilterElement: false,
    SVGForeignObjectElement: false,
    SVGGElement: false,
    SVGGeometryElement: false,
    SVGGradientElement: false,
    SVGGraphicsElement: false,
    SVGImageElement: false,
    SVGLength: false,
    SVGLengthList: false,
    SVGLineElement: false,
    SVGLinearGradientElement: false,
    SVGMPathElement: false,
    SVGMarkerElement: false,
    SVGMaskElement: false,
    SVGMatrix: false,
    SVGMetadataElement: false,
    SVGNumber: false,
    SVGNumberList: false,
    SVGPathElement: false,
    SVGPathSegList: false,
    SVGPatternElement: false,
    SVGPoint: false,
    SVGPointList: false,
    SVGPolygonElement: false,
    SVGPolylineElement: false,
    SVGPreserveAspectRatio: false,
    SVGRadialGradientElement: false,
    SVGRect: false,
    SVGRectElement: false,
    SVGSVGElement: false,
    SVGScriptElement: false,
    SVGSetElement: false,
    SVGStopElement: false,
    SVGStringList: false,
    SVGStyleElement: false,
    SVGSwitchElement: false,
    SVGSymbolElement: false,
    SVGTSpanElement: false,
    SVGTextContentElement: false,
    SVGTextElement: false,
    SVGTextPathElement: false,
    SVGTextPositioningElement: false,
    SVGTitleElement: false,
    SVGTransform: false,
    SVGTransformList: false,
    SVGUnitTypes: false,
    SVGUseElement: false,
    SVGViewElement: false,
    SVGZoomAndPan: false,
    Screen: false,
    ScreenLuminance: false,
    ScreenOrientation: false,
    ScriptProcessorNode: false,
    ScrollAreaEvent: false,
    ScrollViewChangeEvent: false,
    SecurityPolicyViolationEvent: false,
    Selection: false,
    ServiceWorker: false,
    ServiceWorkerContainer: false,
    ServiceWorkerRegistration: false,
    ShadowRoot: false,
    SharedWorker: false,
    SimpleGestureEvent: false,
    SourceBuffer: false,
    SourceBufferList: false,
    SpeechGrammar: false,
    SpeechGrammarList: false,
    SpeechRecognition: false,
    SpeechRecognitionAlternative: false,
    SpeechRecognitionError: false,
    SpeechRecognitionEvent: false,
    SpeechRecognitionResult: false,
    SpeechRecognitionResultList: false,
    SpeechSynthesis: false,
    SpeechSynthesisErrorEvent: false,
    SpeechSynthesisEvent: false,
    SpeechSynthesisUtterance: false,
    SpeechSynthesisVoice: false,
    StereoPannerNode: false,
    Storage: false,
    StorageEvent: false,
    StorageManager: false,
    StreamFilter: false,
    StreamFilterDataEvent: false,
    StructuredCloneHolder: false,
    StructuredCloneTester: false,
    StyleSheet: false,
    StyleSheetApplicableStateChangeEvent: false,
    StyleSheetList: false,
    SubtleCrypto: false,
    SyncMessageSender: false,
    TCPServerSocket: false,
    TCPServerSocketEvent: false,
    TCPSocket: false,
    TCPSocketErrorEvent: false,
    TCPSocketEvent: false,
    TelemetryStopwatch: false,
    TestingDeprecatedInterface: false,
    Text: false,
    TextClause: false,
    TextDecoder: false,
    TextEncoder: false,
    TextMetrics: false,
    TextTrack: false,
    TextTrackCue: false,
    TextTrackCueList: false,
    TextTrackList: false,
    TimeEvent: false,
    TimeRanges: false,
    Touch: false,
    TouchEvent: false,
    TouchList: false,
    TrackEvent: false,
    TransceiverImpl: false,
    TransitionEvent: false,
    TreeColumn: false,
    TreeColumns: false,
    TreeContentView: false,
    TreeWalker: false,
    U2F: false,
    UDPMessageEvent: false,
    UDPSocket: false,
    UIEvent: false,
    URL: false,
    URLSearchParams: false,
    UserInteraction: false,
    UserProximityEvent: false,
    VRDisplay: false,
    VRDisplayCapabilities: false,
    VRDisplayEvent: false,
    VREyeParameters: false,
    VRFieldOfView: false,
    VRFrameData: false,
    VRMockController: false,
    VRMockDisplay: false,
    VRPose: false,
    VRServiceTest: false,
    VRStageParameters: false,
    VRSubmitFrameResult: false,
    VTTCue: false,
    VTTRegion: false,
    ValidityState: false,
    VideoPlaybackQuality: false,
    VideoTrack: false,
    VideoTrackList: false,
    VisualViewport: false,
    WaveShaperNode: false,
    WebExtensionContentScript: false,
    WebExtensionPolicy: false,
    WebGL2RenderingContext: false,
    WebGLActiveInfo: false,
    WebGLBuffer: false,
    WebGLContextEvent: false,
    WebGLFramebuffer: false,
    WebGLProgram: false,
    WebGLQuery: false,
    WebGLRenderbuffer: false,
    WebGLRenderingContext: false,
    WebGLSampler: false,
    WebGLShader: false,
    WebGLShaderPrecisionFormat: false,
    WebGLSync: false,
    WebGLTexture: false,
    WebGLTransformFeedback: false,
    WebGLUniformLocation: false,
    WebGLVertexArrayObject: false,
    WebGPU: false,
    WebGPUAdapter: false,
    WebGPUAttachmentState: false,
    WebGPUBindGroup: false,
    WebGPUBindGroupLayout: false,
    WebGPUBindingType: false,
    WebGPUBlendFactor: false,
    WebGPUBlendOperation: false,
    WebGPUBlendState: false,
    WebGPUBuffer: false,
    WebGPUBufferUsage: false,
    WebGPUColorWriteBits: false,
    WebGPUCommandBuffer: false,
    WebGPUCommandEncoder: false,
    WebGPUCompareFunction: false,
    WebGPUComputePipeline: false,
    WebGPUDepthStencilState: false,
    WebGPUDevice: false,
    WebGPUFence: false,
    WebGPUFilterMode: false,
    WebGPUIndexFormat: false,
    WebGPUInputState: false,
    WebGPUInputStepMode: false,
    WebGPULoadOp: false,
    WebGPULogEntry: false,
    WebGPUPipelineLayout: false,
    WebGPUPrimitiveTopology: false,
    WebGPUQueue: false,
    WebGPURenderPipeline: false,
    WebGPUSampler: false,
    WebGPUShaderModule: false,
    WebGPUShaderStage: false,
    WebGPUShaderStageBit: false,
    WebGPUStencilOperation: false,
    WebGPUStoreOp: false,
    WebGPUSwapChain: false,
    WebGPUTexture: false,
    WebGPUTextureDimension: false,
    WebGPUTextureFormat: false,
    WebGPUTextureUsage: false,
    WebGPUTextureView: false,
    WebGPUVertexFormat: false,
    WebKitCSSMatrix: false,
    WebSocket: false,
    WebrtcGlobalInformation: false,
    WheelEvent: false,
    Window: false,
    WindowGlobalChild: false,
    WindowGlobalParent: false,
    WindowRoot: false,
    Worker: false,
    Worklet: false,
    XMLDocument: false,
    XMLHttpRequest: false,
    XMLHttpRequestEventTarget: false,
    XMLHttpRequestUpload: false,
    XMLSerializer: false,
    XPathEvaluator: false,
    XPathExpression: false,
    XPathResult: false,
    XSLTProcessor: false,
    XULCommandEvent: false,
    XULElement: false,
    XULFrameElement: false,
    XULMenuElement: false,
    XULPopupElement: false,
    XULScrollElement: false,
    XULTextElement: false,
    console: false,
    mozRTCIceCandidate: false,
    mozRTCPeerConnection: false,
    mozRTCSessionDescription: false,
  },
};
