// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_3_0_autogen.cpp:
//   Defines the GLES 3.0 entry points.

#include "libGLESv2/entry_points_gles_3_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture_gles_3_0_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES3.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY BeginQuery(GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(BeginQuery, context, targetPacked, id);
        if (context->skipValidation() || ValidateBeginQuery(context, targetPacked, id))
        {
            context->beginQuery(targetPacked, id);
        }
    }
}

void GL_APIENTRY BeginTransformFeedback(GLenum primitiveMode)
{
    EVENT("(GLenum primitiveMode = 0x%X)", primitiveMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode primitiveModePacked = FromGLenum<PrimitiveMode>(primitiveMode);
        ANGLE_CAPTURE(BeginTransformFeedback, context, primitiveModePacked);
        if (context->skipValidation() ||
            ValidateBeginTransformFeedback(context, primitiveModePacked))
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
    }
}

void GL_APIENTRY BindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u)", target, index, buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferBase, context, targetPacked, index, buffer);
        if (context->skipValidation() ||
            ValidateBindBufferBase(context, targetPacked, index, buffer))
        {
            context->bindBufferBase(targetPacked, index, buffer);
        }
    }
}

void GL_APIENTRY
BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u, GLintptr offset = %llu, "
        "GLsizeiptr size = %llu)",
        target, index, buffer, static_cast<unsigned long long>(offset),
        static_cast<unsigned long long>(size));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferRange, context, targetPacked, index, buffer, offset, size);
        if (context->skipValidation() ||
            ValidateBindBufferRange(context, targetPacked, index, buffer, offset, size))
        {
            context->bindBufferRange(targetPacked, index, buffer, offset, size);
        }
    }
}

void GL_APIENTRY BindSampler(GLuint unit, GLuint sampler)
{
    EVENT("(GLuint unit = %u, GLuint sampler = %u)", unit, sampler);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindSampler, context, unit, sampler);
        if (context->skipValidation() || ValidateBindSampler(context, unit, sampler))
        {
            context->bindSampler(unit, sampler);
        }
    }
}

void GL_APIENTRY BindTransformFeedback(GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindTransformFeedback, context, target, id);
        if (context->skipValidation() || ValidateBindTransformFeedback(context, target, id))
        {
            context->bindTransformFeedback(target, id);
        }
    }
}

void GL_APIENTRY BindVertexArray(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindVertexArray, context, array);
        if (context->skipValidation() || ValidateBindVertexArray(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY BlitFramebuffer(GLint srcX0,
                                 GLint srcY0,
                                 GLint srcX1,
                                 GLint srcY1,
                                 GLint dstX0,
                                 GLint dstY0,
                                 GLint dstX1,
                                 GLint dstY1,
                                 GLbitfield mask,
                                 GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BlitFramebuffer, context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                      dstY1, mask, filter);
        if (context->skipValidation() ||
            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
                                    mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

void GL_APIENTRY ClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, GLfloat depth = %f, GLint stencil = %d)",
          buffer, drawbuffer, depth, stencil);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferfi, context, buffer, drawbuffer, depth, stencil);
        if (context->skipValidation() ||
            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil))
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
    }
}

void GL_APIENTRY ClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferfv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferfv(context, buffer, drawbuffer, value))
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClearBufferuiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferuiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
    }
}

GLenum GL_APIENTRY ClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ", GLbitfield flags = 0x%X, GLuint64 timeout = %llu)",
          (uintptr_t)sync, flags, static_cast<unsigned long long>(timeout));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ClientWaitSync, context, sync, flags, timeout);
        if (context->skipValidation() || ValidateClientWaitSync(context, sync, flags, timeout))
        {
            return context->clientWaitSync(sync, flags, timeout);
        }
    }

    return GetDefaultReturnValue<EntryPoint::ClientWaitSync, GLenum>();
}

void GL_APIENTRY CompressedTexImage3D(GLenum target,
                                      GLint level,
                                      GLenum internalformat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLint border,
                                      GLsizei imageSize,
                                      const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "const void *data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3D, context, targetPacked, level, internalformat, width,
                      height, depth, border, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexImage3D(context, targetPacked, level, internalformat, width,
                                         height, depth, border, imageSize, data))
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3D(GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLenum format,
                                         GLsizei imageSize,
                                         const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3D, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset,
                                            width, height, depth, format, imageSize, data))
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
    }
}

void GL_APIENTRY CopyBufferSubData(GLenum readTarget,
                                   GLenum writeTarget,
                                   GLintptr readOffset,
                                   GLintptr writeOffset,
                                   GLsizeiptr size)
{
    EVENT(
        "(GLenum readTarget = 0x%X, GLenum writeTarget = 0x%X, GLintptr readOffset = %llu, "
        "GLintptr writeOffset = %llu, GLsizeiptr size = %llu)",
        readTarget, writeTarget, static_cast<unsigned long long>(readOffset),
        static_cast<unsigned long long>(writeOffset), static_cast<unsigned long long>(size));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding readTargetPacked  = FromGLenum<BufferBinding>(readTarget);
        BufferBinding writeTargetPacked = FromGLenum<BufferBinding>(writeTarget);
        ANGLE_CAPTURE(CopyBufferSubData, context, readTargetPacked, writeTargetPacked, readOffset,
                      writeOffset, size);
        if (context->skipValidation() ||
            ValidateCopyBufferSubData(context, readTargetPacked, writeTargetPacked, readOffset,
                                      writeOffset, size))
        {
            context->copyBufferSubData(readTargetPacked, writeTargetPacked, readOffset, writeOffset,
                                       size);
        }
    }
}

void GL_APIENTRY CopyTexSubImage3D(GLenum target,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint zoffset,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, zoffset, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, x,
                      y, width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, x, y,
                                      width, height))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
    }
}

void GL_APIENTRY DeleteQueries(GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteQueries, context, n, ids);
        if (context->skipValidation() || ValidateDeleteQueries(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY DeleteSamplers(GLsizei count, const GLuint *samplers)
{
    EVENT("(GLsizei count = %d, const GLuint *samplers = 0x%016" PRIxPTR ")", count,
          (uintptr_t)samplers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteSamplers, context, count, samplers);
        if (context->skipValidation() || ValidateDeleteSamplers(context, count, samplers))
        {
            context->deleteSamplers(count, samplers);
        }
    }
}

void GL_APIENTRY DeleteSync(GLsync sync)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ")", (uintptr_t)sync);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteSync, context, sync);
        if (context->skipValidation() || ValidateDeleteSync(context, sync))
        {
            context->deleteSync(sync);
        }
    }
}

void GL_APIENTRY DeleteTransformFeedbacks(GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteTransformFeedbacks, context, n, ids);
        if (context->skipValidation() || ValidateDeleteTransformFeedbacks(context, n, ids))
        {
            context->deleteTransformFeedbacks(n, ids);
        }
    }
}

void GL_APIENTRY DeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY DrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d, GLsizei instancecount = %d)",
          mode, first, count, instancecount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstanced, context, modePacked, first, count, instancecount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstanced(context, modePacked, first, count, instancecount))
        {
            context->drawArraysInstanced(modePacked, first, count, instancecount);
        }
    }
}

void GL_APIENTRY DrawBuffers(GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR ")", n, (uintptr_t)bufs);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawBuffers, context, n, bufs);
        if (context->skipValidation() || ValidateDrawBuffers(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

void GL_APIENTRY DrawElementsInstanced(GLenum mode,
                                       GLsizei count,
                                       GLenum type,
                                       const void *indices,
                                       GLsizei instancecount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei instancecount = %d)",
        mode, count, type, (uintptr_t)indices, instancecount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstanced, context, modePacked, count, typePacked, indices,
                      instancecount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstanced(context, modePacked, count, typePacked, indices,
                                          instancecount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, instancecount);
        }
    }
}

void GL_APIENTRY DrawRangeElements(GLenum mode,
                                   GLuint start,
                                   GLuint end,
                                   GLsizei count,
                                   GLenum type,
                                   const void *indices)
{
    EVENT(
        "(GLenum mode = 0x%X, GLuint start = %u, GLuint end = %u, GLsizei count = %d, GLenum type "
        "= 0x%X, const void *indices = 0x%016" PRIxPTR ")",
        mode, start, end, count, type, (uintptr_t)indices);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawRangeElements, context, modePacked, start, end, count, typePacked,
                      indices);
        if (context->skipValidation() ||
            ValidateDrawRangeElements(context, modePacked, start, end, count, typePacked, indices))
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
    }
}

void GL_APIENTRY EndQuery(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(EndQuery, context, targetPacked);
        if (context->skipValidation() || ValidateEndQuery(context, targetPacked))
        {
            context->endQuery(targetPacked);
        }
    }
}

void GL_APIENTRY EndTransformFeedback()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EndTransformFeedback, context);
        if (context->skipValidation() || ValidateEndTransformFeedback(context))
        {
            context->endTransformFeedback();
        }
    }
}

GLsync GL_APIENTRY FenceSync(GLenum condition, GLbitfield flags)
{
    EVENT("(GLenum condition = 0x%X, GLbitfield flags = 0x%X)", condition, flags);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FenceSync, context, condition, flags);
        if (context->skipValidation() || ValidateFenceSync(context, condition, flags))
        {
            return context->fenceSync(condition, flags);
        }
    }

    return GetDefaultReturnValue<EntryPoint::FenceSync, GLsync>();
}

void GL_APIENTRY FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu)", target,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(FlushMappedBufferRange, context, targetPacked, offset, length);
        if (context->skipValidation() ||
            ValidateFlushMappedBufferRange(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void GL_APIENTRY
FramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d, "
        "GLint layer = %d)",
        target, attachment, texture, level, layer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferTextureLayer, context, target, attachment, texture, level, layer);
        if (context->skipValidation() ||
            ValidateFramebufferTextureLayer(context, target, attachment, texture, level, layer))
        {
            context->framebufferTextureLayer(target, attachment, texture, level, layer);
        }
    }
}

void GL_APIENTRY GenQueries(GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenQueries, context, n, ids);
        if (context->skipValidation() || ValidateGenQueries(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GenSamplers(GLsizei count, GLuint *samplers)
{
    EVENT("(GLsizei count = %d, GLuint *samplers = 0x%016" PRIxPTR ")", count, (uintptr_t)samplers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenSamplers, context, count, samplers);
        if (context->skipValidation() || ValidateGenSamplers(context, count, samplers))
        {
            context->genSamplers(count, samplers);
        }
    }
}

void GL_APIENTRY GenTransformFeedbacks(GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenTransformFeedbacks, context, n, ids);
        if (context->skipValidation() || ValidateGenTransformFeedbacks(context, n, ids))
        {
            context->genTransformFeedbacks(n, ids);
        }
    }
}

void GL_APIENTRY GenVertexArrays(GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateGenVertexArrays(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockName(GLuint program,
                                           GLuint uniformBlockIndex,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *uniformBlockName)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLsizei bufSize = %d, GLsizei "
        "*length = 0x%016" PRIxPTR ", GLchar *uniformBlockName = 0x%016" PRIxPTR ")",
        program, uniformBlockIndex, bufSize, (uintptr_t)length, (uintptr_t)uniformBlockName);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveUniformBlockName, context, program, uniformBlockIndex, bufSize,
                      length, uniformBlockName);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockName(context, program, uniformBlockIndex, bufSize, length,
                                              uniformBlockName))
        {
            context->getActiveUniformBlockName(program, uniformBlockIndex, bufSize, length,
                                               uniformBlockName);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockiv(GLuint program,
                                         GLuint uniformBlockIndex,
                                         GLenum pname,
                                         GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        program, uniformBlockIndex, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveUniformBlockiv, context, program, uniformBlockIndex, pname, params);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockiv(context, program, uniformBlockIndex, pname, params))
        {
            context->getActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
        }
    }
}

void GL_APIENTRY GetActiveUniformsiv(GLuint program,
                                     GLsizei uniformCount,
                                     const GLuint *uniformIndices,
                                     GLenum pname,
                                     GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLsizei uniformCount = %d, const GLuint *uniformIndices = "
        "0x%016" PRIxPTR ", GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")",
        program, uniformCount, (uintptr_t)uniformIndices, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveUniformsiv, context, program, uniformCount, uniformIndices, pname,
                      params);
        if (context->skipValidation() || ValidateGetActiveUniformsiv(context, program, uniformCount,
                                                                     uniformIndices, pname, params))
        {
            context->getActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint64 *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteri64v, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferParameteri64v(context, targetPacked, pname, params))
        {
            context->getBufferParameteri64v(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferPointerv(GLenum target, GLenum pname, void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointerv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferPointerv(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

GLint GL_APIENTRY GetFragDataLocation(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFragDataLocation, context, program, name);
        if (context->skipValidation() || ValidateGetFragDataLocation(context, program, name))
        {
            return context->getFragDataLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
}

void GL_APIENTRY GetInteger64i_v(GLenum target, GLuint index, GLint64 *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLint64 *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInteger64i_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetInteger64i_v(context, target, index, data))
        {
            context->getInteger64i_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetInteger64v(GLenum pname, GLint64 *data)
{
    EVENT("(GLenum pname = 0x%X, GLint64 *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInteger64v, context, pname, data);
        if (context->skipValidation() || ValidateGetInteger64v(context, pname, data))
        {
            context->getInteger64v(pname, data);
        }
    }
}

void GL_APIENTRY GetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLint *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetIntegeri_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data))
        {
            context->getIntegeri_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetInternalformativ(GLenum target,
                                     GLenum internalformat,
                                     GLenum pname,
                                     GLsizei bufSize,
                                     GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLint *params = 0x%016" PRIxPTR ")",
        target, internalformat, pname, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInternalformativ, context, target, internalformat, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetInternalformativ(context, target, internalformat, pname, bufSize, params))
        {
            context->getInternalformativ(target, internalformat, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY GetProgramBinary(GLuint program,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLenum *binaryFormat,
                                  void *binary)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat, (uintptr_t)binary);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramBinary, context, program, bufSize, length, binaryFormat, binary);
        if (context->skipValidation() ||
            ValidateGetProgramBinary(context, program, bufSize, length, binaryFormat, binary))
        {
            context->getProgramBinary(program, bufSize, length, binaryFormat, binary);
        }
    }
}

void GL_APIENTRY GetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectuiv, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectuiv(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryiv, context, targetPacked, pname, params);
        if (context->skipValidation() || ValidateGetQueryiv(context, targetPacked, pname, params))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterfv, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterfv(context, sampler, pname, params))
        {
            context->getSamplerParameterfv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameteriv, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameteriv(context, sampler, pname, params))
        {
            context->getSamplerParameteriv(sampler, pname, params);
        }
    }
}

const GLubyte *GL_APIENTRY GetStringi(GLenum name, GLuint index)
{
    EVENT("(GLenum name = 0x%X, GLuint index = %u)", name, index);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetStringi, context, name, index);
        if (context->skipValidation() || ValidateGetStringi(context, name, index))
        {
            return context->getStringi(name, index);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
}

void GL_APIENTRY
GetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR
          ", GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLint *values = 0x%016" PRIxPTR ")",
          (uintptr_t)sync, pname, bufSize, (uintptr_t)length, (uintptr_t)values);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSynciv, context, sync, pname, bufSize, length, values);
        if (context->skipValidation() ||
            ValidateGetSynciv(context, sync, pname, bufSize, length, values))
        {
            context->getSynciv(sync, pname, bufSize, length, values);
        }
    }
}

void GL_APIENTRY GetTransformFeedbackVarying(GLuint program,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLsizei *size,
                                             GLenum *type,
                                             GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLsizei *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTransformFeedbackVarying, context, program, index, bufSize, length, size,
                      type, name);
        if (context->skipValidation() ||
            ValidateGetTransformFeedbackVarying(context, program, index, bufSize, length, size,
                                                type, name))
        {
            context->getTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
        }
    }
}

GLuint GL_APIENTRY GetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
    EVENT("(GLuint program = %u, const GLchar *uniformBlockName = 0x%016" PRIxPTR ")", program,
          (uintptr_t)uniformBlockName);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformBlockIndex, context, program, uniformBlockName);
        if (context->skipValidation() ||
            ValidateGetUniformBlockIndex(context, program, uniformBlockName))
        {
            return context->getUniformBlockIndex(program, uniformBlockName);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformBlockIndex, GLuint>();
}

void GL_APIENTRY GetUniformIndices(GLuint program,
                                   GLsizei uniformCount,
                                   const GLchar *const *uniformNames,
                                   GLuint *uniformIndices)
{
    EVENT(
        "(GLuint program = %u, GLsizei uniformCount = %d, const GLchar *const*uniformNames = "
        "0x%016" PRIxPTR ", GLuint *uniformIndices = 0x%016" PRIxPTR ")",
        program, uniformCount, (uintptr_t)uniformNames, (uintptr_t)uniformIndices);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformIndices, context, program, uniformCount, uniformNames,
                      uniformIndices);
        if (context->skipValidation() ||
            ValidateGetUniformIndices(context, program, uniformCount, uniformNames, uniformIndices))
        {
            context->getUniformIndices(program, uniformCount, uniformNames, uniformIndices);
        }
    }
}

void GL_APIENTRY GetUniformuiv(GLuint program, GLint location, GLuint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformuiv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformuiv(context, program, location, params))
        {
            context->getUniformuiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIiv(context, index, pname, params))
        {
            context->getVertexAttribIiv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIuiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIuiv(context, index, pname, params))
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
    }
}

void GL_APIENTRY InvalidateFramebuffer(GLenum target,
                                       GLsizei numAttachments,
                                       const GLenum *attachments)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ")",
        target, numAttachments, (uintptr_t)attachments);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(InvalidateFramebuffer, context, target, numAttachments, attachments);
        if (context->skipValidation() ||
            ValidateInvalidateFramebuffer(context, target, numAttachments, attachments))
        {
            context->invalidateFramebuffer(target, numAttachments, attachments);
        }
    }
}

void GL_APIENTRY InvalidateSubFramebuffer(GLenum target,
                                          GLsizei numAttachments,
                                          const GLenum *attachments,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ", GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, numAttachments, (uintptr_t)attachments, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(InvalidateSubFramebuffer, context, target, numAttachments, attachments, x, y,
                      width, height);
        if (context->skipValidation() ||
            ValidateInvalidateSubFramebuffer(context, target, numAttachments, attachments, x, y,
                                             width, height))
        {
            context->invalidateSubFramebuffer(target, numAttachments, attachments, x, y, width,
                                              height);
        }
    }
}

GLboolean GL_APIENTRY IsQuery(GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsQuery, context, id);
        if (context->skipValidation() || ValidateIsQuery(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQuery, GLboolean>();
}

GLboolean GL_APIENTRY IsSampler(GLuint sampler)
{
    EVENT("(GLuint sampler = %u)", sampler);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsSampler, context, sampler);
        if (context->skipValidation() || ValidateIsSampler(context, sampler))
        {
            return context->isSampler(sampler);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
}

GLboolean GL_APIENTRY IsSync(GLsync sync)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ")", (uintptr_t)sync);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsSync, context, sync);
        if (context->skipValidation() || ValidateIsSync(context, sync))
        {
            return context->isSync(sync);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSync, GLboolean>();
}

GLboolean GL_APIENTRY IsTransformFeedback(GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsTransformFeedback, context, id);
        if (context->skipValidation() || ValidateIsTransformFeedback(context, id))
        {
            return context->isTransformFeedback(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
}

GLboolean GL_APIENTRY IsVertexArray(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsVertexArray, context, array);
        if (context->skipValidation() || ValidateIsVertexArray(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
}

void *GL_APIENTRY MapBufferRange(GLenum target,
                                 GLintptr offset,
                                 GLsizeiptr length,
                                 GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu, GLbitfield "
        "access = 0x%X)",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
        access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferRange, context, targetPacked, offset, length, access);
        if (context->skipValidation() ||
            ValidateMapBufferRange(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
}

void GL_APIENTRY PauseTransformFeedback()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PauseTransformFeedback, context);
        if (context->skipValidation() || ValidatePauseTransformFeedback(context))
        {
            context->pauseTransformFeedback();
        }
    }
}

void GL_APIENTRY ProgramBinary(GLuint program,
                               GLenum binaryFormat,
                               const void *binary,
                               GLsizei length)
{
    EVENT("(GLuint program = %u, GLenum binaryFormat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLsizei length = %d)",
          program, binaryFormat, (uintptr_t)binary, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ProgramBinary, context, program, binaryFormat, binary, length);
        if (context->skipValidation() ||
            ValidateProgramBinary(context, program, binaryFormat, binary, length))
        {
            context->programBinary(program, binaryFormat, binary, length);
        }
    }
}

void GL_APIENTRY ProgramParameteri(GLuint program, GLenum pname, GLint value)
{
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint value = %d)", program, pname, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ProgramParameteri, context, program, pname, value);
        if (context->skipValidation() || ValidateProgramParameteri(context, program, pname, value))
        {
            context->programParameteri(program, pname, value);
        }
    }
}

void GL_APIENTRY ReadBuffer(GLenum src)
{
    EVENT("(GLenum src = 0x%X)", src);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadBuffer, context, src);
        if (context->skipValidation() || ValidateReadBuffer(context, src))
        {
            context->readBuffer(src);
        }
    }
}

void GL_APIENTRY RenderbufferStorageMultisample(GLenum target,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderbufferStorageMultisample, context, target, samples, internalformat,
                      width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisample(context, target, samples, internalformat, width,
                                                   height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

void GL_APIENTRY ResumeTransformFeedback()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ResumeTransformFeedback, context);
        if (context->skipValidation() || ValidateResumeTransformFeedback(context))
        {
            context->resumeTransformFeedback();
        }
    }
}

void GL_APIENTRY SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLfloat param = %f)", sampler, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterf, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameterf(context, sampler, pname, param))
        {
            context->samplerParameterf(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLfloat *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterfv, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameterfv(context, sampler, pname, param))
        {
            context->samplerParameterfv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint param = %d)", sampler, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameteri, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameteri(context, sampler, pname, param))
        {
            context->samplerParameteri(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameteriv, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameteriv(context, sampler, pname, param))
        {
            context->samplerParameteriv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY TexImage3D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLsizei height,
                            GLsizei depth,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, GLenum "
        "type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3D, context, targetPacked, level, internalformat, width, height,
                      depth, border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3D(context, targetPacked, level, internalformat, width, height, depth,
                               border, format, type, pixels))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
    }
}

void GL_APIENTRY
TexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d)",
        target, levels, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2D, context, targetPacked, levels, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateTexStorage2D(context, targetPacked, levels, internalformat, width, height))
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexStorage3D(GLenum target,
                              GLsizei levels,
                              GLenum internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLsizei depth)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d)",
        target, levels, internalformat, width, height, depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3D, context, targetPacked, levels, internalformat, width, height,
                      depth);
        if (context->skipValidation() || ValidateTexStorage3D(context, targetPacked, levels,
                                                              internalformat, width, height, depth))
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
    }
}

void GL_APIENTRY TexSubImage3D(GLenum target,
                               GLint level,
                               GLint xoffset,
                               GLint yoffset,
                               GLint zoffset,
                               GLsizei width,
                               GLsizei height,
                               GLsizei depth,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, width,
                      height, depth, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                  height, depth, format, type, pixels))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
    }
}

void GL_APIENTRY TransformFeedbackVaryings(GLuint program,
                                           GLsizei count,
                                           const GLchar *const *varyings,
                                           GLenum bufferMode)
{
    EVENT("(GLuint program = %u, GLsizei count = %d, const GLchar *const*varyings = 0x%016" PRIxPTR
          ", GLenum bufferMode = 0x%X)",
          program, count, (uintptr_t)varyings, bufferMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TransformFeedbackVaryings, context, program, count, varyings, bufferMode);
        if (context->skipValidation() ||
            ValidateTransformFeedbackVaryings(context, program, count, varyings, bufferMode))
        {
            context->transformFeedbackVaryings(program, count, varyings, bufferMode);
        }
    }
}

void GL_APIENTRY Uniform1ui(GLint location, GLuint v0)
{
    EVENT("(GLint location = %d, GLuint v0 = %u)", location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1ui, context, location, v0);
        if (context->skipValidation() || ValidateUniform1ui(context, location, v0))
        {
            context->uniform1ui(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform1uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1uiv(context, location, count, value))
        {
            context->uniform1uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2ui(GLint location, GLuint v0, GLuint v1)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u)", location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2ui, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2ui(context, location, v0, v1))
        {
            context->uniform2ui(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform2uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2uiv(context, location, count, value))
        {
            context->uniform2uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u)", location, v0, v1,
          v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3ui, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3ui(context, location, v0, v1, v2))
        {
            context->uniform3ui(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform3uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3uiv(context, location, count, value))
        {
            context->uniform3uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u, GLuint v3 = %u)",
          location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4ui, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4ui(context, location, v0, v1, v2, v3))
        {
            context->uniform4ui(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(Uniform4uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4uiv(context, location, count, value))
        {
            context->uniform4uiv(location, count, value);
        }
    }
}

void GL_APIENTRY UniformBlockBinding(GLuint program,
                                     GLuint uniformBlockIndex,
                                     GLuint uniformBlockBinding)
{
    EVENT("(GLuint program = %u, GLuint uniformBlockIndex = %u, GLuint uniformBlockBinding = %u)",
          program, uniformBlockIndex, uniformBlockBinding);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformBlockBinding, context, program, uniformBlockIndex,
                      uniformBlockBinding);
        if (context->skipValidation() ||
            ValidateUniformBlockBinding(context, program, uniformBlockIndex, uniformBlockBinding))
        {
            context->uniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
        }
    }
}

void GL_APIENTRY UniformMatrix2x3fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix2x3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2x3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2x3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2x4fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix2x4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2x4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2x4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3x2fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix3x2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3x2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3x2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3x4fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix3x4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3x4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3x4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4x2fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix4x2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4x2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4x2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4x3fv(GLint location,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(UniformMatrix4x3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4x3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4x3fv(location, count, transpose, value);
        }
    }
}

GLboolean GL_APIENTRY UnmapBuffer(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(UnmapBuffer, context, targetPacked);
        if (context->skipValidation() || ValidateUnmapBuffer(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBuffer, GLboolean>();
}

void GL_APIENTRY VertexAttribDivisor(GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribDivisor, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisor(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

void GL_APIENTRY VertexAttribI4i(GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    EVENT("(GLuint index = %u, GLint x = %d, GLint y = %d, GLint z = %d, GLint w = %d)", index, x,
          y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4i, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4i(context, index, x, y, z, w))
        {
            context->vertexAttribI4i(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4iv(GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4iv(context, index, v))
        {
            context->vertexAttribI4iv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribI4ui(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    EVENT("(GLuint index = %u, GLuint x = %u, GLuint y = %u, GLuint z = %u, GLuint w = %u)", index,
          x, y, z, w);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4ui, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4ui(context, index, x, y, z, w))
        {
            context->vertexAttribI4ui(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4uiv(GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribI4uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4uiv(context, index, v))
        {
            context->vertexAttribI4uiv(index, v);
        }
    }
}

void GL_APIENTRY
VertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void "
        "*pointer = 0x%016" PRIxPTR ")",
        index, size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribIPointer, context, index, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateVertexAttribIPointer(context, index, size, typePacked, stride, pointer))
        {
            context->vertexAttribIPointer(index, size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY WaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ", GLbitfield flags = 0x%X, GLuint64 timeout = %llu)",
          (uintptr_t)sync, flags, static_cast<unsigned long long>(timeout));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(WaitSync, context, sync, flags, timeout);
        if (context->skipValidation() || ValidateWaitSync(context, sync, flags, timeout))
        {
            context->waitSync(sync, flags, timeout);
        }
    }
}
}  // namespace gl
