// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.drawing.style.spacing.measure
// Description:Testing letter spacing and word spacing
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Testing letter spacing and word spacing");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

var offscreenCanvas = new OffscreenCanvas(100, 50);
var ctx = offscreenCanvas.getContext('2d');

_assertSame(ctx.textLetterSpacing, 0, "ctx.textLetterSpacing", "0");
_assertSame(ctx.textWordSpacing, 0, "ctx.textWordSpacing", "0");
var width_normal = ctx.measureText('Hello World').width;

ctx.textLetterSpacing = 3;
_assertSame(ctx.textLetterSpacing, 3, "ctx.textLetterSpacing", "3");
_assertSame(ctx.textWordSpacing, 0, "ctx.textWordSpacing", "0");
var width_with_spacing = ctx.measureText('Hello World').width;
// Add letter spacing after each letter, so 11 * 3 = 33px longer.
_assertSame(width_with_spacing, width_normal + 33, "width_with_spacing", "width_normal + 33");

ctx.textWordSpacing = 5;
ctx.textLetterSpacing = 0;
_assertSame(ctx.textLetterSpacing, 0, "ctx.textLetterSpacing", "0");
_assertSame(ctx.textWordSpacing, 5, "ctx.textWordSpacing", "5");
// Add Word Spacing between "Hello" and "World", so it's 5px longer.
width_with_spacing = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal + 5, "width_with_spacing", "width_normal + 5");

ctx.textLetterSpacing = -2;
ctx.textWordSpacing = -1;
_assertSame(ctx.textLetterSpacing, -2, "ctx.textLetterSpacing", "-2");
_assertSame(ctx.textWordSpacing, -1, "ctx.textWordSpacing", "-1");
// Add Word Spacing and letter spacing, so it's -11*2 = -22px from
// letter spacing and -1px from word spacing.
width_with_spacing = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal - 23, "width_with_spacing", "width_normal - 23");
t.done();

});
done();
