/*
 * Copyright 2019 Google LLC.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/**************************************************************************************************
 *** This file was autogenerated from GrComposeLerpRedEffect.fp; do not modify.
 **************************************************************************************************/
#ifndef GrComposeLerpRedEffect_DEFINED
#define GrComposeLerpRedEffect_DEFINED
#include "include/core/SkTypes.h"

#include "src/gpu/GrCoordTransform.h"
#include "src/gpu/GrFragmentProcessor.h"
class GrComposeLerpRedEffect : public GrFragmentProcessor {
public:
    static std::unique_ptr<GrFragmentProcessor> Make(std::unique_ptr<GrFragmentProcessor> child1,
                                                     std::unique_ptr<GrFragmentProcessor> child2,
                                                     std::unique_ptr<GrFragmentProcessor> lerp) {
        return std::unique_ptr<GrFragmentProcessor>(
                new GrComposeLerpRedEffect(std::move(child1), std::move(child2), std::move(lerp)));
    }
    GrComposeLerpRedEffect(const GrComposeLerpRedEffect& src);
    std::unique_ptr<GrFragmentProcessor> clone() const override;
    const char* name() const override { return "ComposeLerpRedEffect"; }
    int child1_index = -1;
    int child2_index = -1;
    int lerp_index = -1;

private:
    GrComposeLerpRedEffect(std::unique_ptr<GrFragmentProcessor> child1,
                           std::unique_ptr<GrFragmentProcessor> child2,
                           std::unique_ptr<GrFragmentProcessor> lerp)
            : INHERITED(kGrComposeLerpRedEffect_ClassID, kNone_OptimizationFlags) {
        if (child1) {
            child1_index = this->numChildProcessors();
            this->registerChildProcessor(std::move(child1));
        }
        if (child2) {
            child2_index = this->numChildProcessors();
            this->registerChildProcessor(std::move(child2));
        }
        SkASSERT(lerp);
        lerp_index = this->numChildProcessors();
        this->registerChildProcessor(std::move(lerp));
    }
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    typedef GrFragmentProcessor INHERITED;
};
#endif
