// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["bold",""],["inserttext","a"]],
    "foo<b>a[]</b>bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["delete",""],["inserttext","a"]],
    "fo<b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["bold",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<b>a[]</b>bar</div>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["forwarddelete",""],["inserttext","a"]],
    "foo<b>a[]</b>ar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<b>a[]</b>bar</blockquote>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["bold",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<b>a[]</b>bar</li></ol>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><b>a[]</b>bar</p>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["bold",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<b>a[]</b>bar</li></ul>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["bold",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<b>a[]</b>bar</div>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["bold",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<b>a[]</b>bar</div>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["bold",""],["justifyleft",""],["inserttext","a"]],
    "foo<b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"bold":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["bold",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<b>a[]</b>bar</div>",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"bold":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["bold",""],["outdent",""],["inserttext","a"]],
    "foo<b>a[]</b>bar",
    [true,true,true],
    {"bold":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["inserttext","a"]],
    "foo<i>a[]</i>bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["delete",""],["inserttext","a"]],
    "fo<i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["italic",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<i>a[]</i>bar</div>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["forwarddelete",""],["inserttext","a"]],
    "foo<i>a[]</i>ar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<i>a[]</i>bar</blockquote>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["italic",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<i>a[]</i>bar</li></ol>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><i>a[]</i>bar</p>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["italic",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<i>a[]</i>bar</li></ul>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["italic",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<i>a[]</i>bar</div>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["italic",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<i>a[]</i>bar</div>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["italic",""],["justifyleft",""],["inserttext","a"]],
    "foo<i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"italic":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["italic",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<i>a[]</i>bar</div>",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"italic":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["italic",""],["outdent",""],["inserttext","a"]],
    "foo<i>a[]</i>bar",
    [true,true,true],
    {"italic":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["inserttext","a"]],
    "foo<s>a[]</s>bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["delete",""],["inserttext","a"]],
    "fo<s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["strikethrough",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<s>a[]</s>bar</div>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["forwarddelete",""],["inserttext","a"]],
    "foo<s>a[]</s>ar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<s>a[]</s>bar</blockquote>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["strikethrough",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<s>a[]</s>bar</li></ol>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><s>a[]</s>bar</p>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["strikethrough",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<s>a[]</s>bar</li></ul>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["strikethrough",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<s>a[]</s>bar</div>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["strikethrough",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<s>a[]</s>bar</div>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["strikethrough",""],["justifyleft",""],["inserttext","a"]],
    "foo<s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["strikethrough",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<s>a[]</s>bar</div>",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"strikethrough":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["strikethrough",""],["outdent",""],["inserttext","a"]],
    "foo<s>a[]</s>bar",
    [true,true,true],
    {"strikethrough":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["delete",""],["inserttext","a"]],
    "fo<sub><font size=\"3\">a[]</font></sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["subscript",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<sub>a[]</sub>bar</div>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["forwarddelete",""],["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>ar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<sub>a[]</sub>bar</blockquote>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["subscript",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<sub>a[]</sub>bar</li></ol>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><sub>a[]</sub>bar</p>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["subscript",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<sub>a[]</sub>bar</li></ul>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["subscript",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<sub>a[]</sub>bar</div>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["subscript",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<sub>a[]</sub>bar</div>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["subscript",""],["justifyleft",""],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["subscript",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<sub>a[]</sub>bar</div>",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"subscript":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["outdent",""],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["inserttext","a"]],
    "foo<sup>a[]</sup>bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["delete",""],["inserttext","a"]],
    "fo<sup><font size=\"3\">a[]</font></sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["superscript",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<sup>a[]</sup>bar</div>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["forwarddelete",""],["inserttext","a"]],
    "foo<sup><font size=\"3\">a[]</font></sup>ar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<sup>a[]</sup>bar</blockquote>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["superscript",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<sup>a[]</sup>bar</li></ol>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><sup>a[]</sup>bar</p>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["superscript",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<sup>a[]</sup>bar</li></ul>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["superscript",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<sup>a[]</sup>bar</div>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["superscript",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<sup>a[]</sup>bar</div>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["superscript",""],["justifyleft",""],["inserttext","a"]],
    "foo<sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["superscript",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<sup>a[]</sup>bar</div>",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"superscript":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["outdent",""],["inserttext","a"]],
    "foo<sup>a[]</sup>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["inserttext","a"]],
    "foo<u>a[]</u>bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["delete",""]],
    "fo[]bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["delete",""],["inserttext","a"]],
    "fo<u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["underline",""],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<u>a[]</u>bar</div>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["forwarddelete",""],["inserttext","a"]],
    "foo<u>a[]</u>ar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["indent",""],["inserttext","a"]],
    "<blockquote>foo<u>a[]</u>bar</blockquote>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["underline",""],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<u>a[]</u>bar</li></ol>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><u>a[]</u>bar</p>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["underline",""],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<u>a[]</u>bar</li></ul>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["underline",""],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<u>a[]</u>bar</div>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["underline",""],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<u>a[]</u>bar</div>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["underline",""],["justifyleft",""],["inserttext","a"]],
    "foo<u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"underline":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["underline",""],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<u>a[]</u>bar</div>",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"underline":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["outdent",""],["inserttext","a"]],
    "foo<u>a[]</u>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["delete",""],["inserttext","a"]],
    "fo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["forwarddelete",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>ar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</blockquote>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</li></ol>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</p>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</li></ul>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyleft",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","#00FFFF"],["outdent",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["delete",""],["inserttext","a"]],
    "fo<a href=\"http://www.google.com/\"><font color=\"#000000\">a[]</font></a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<a href=\"http://www.google.com/\">a[]</a>bar</div>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forwarddelete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\"><font color=\"#000000\">a[]</font></a>ar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<a href=\"http://www.google.com/\">a[]</a>bar</blockquote>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<a href=\"http://www.google.com/\">a[]</a>bar</li></ol>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><a href=\"http://www.google.com/\">a[]</a>bar</p>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<a href=\"http://www.google.com/\">a[]</a>bar</li></ul>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<a href=\"http://www.google.com/\">a[]</a>bar</div>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<a href=\"http://www.google.com/\">a[]</a>bar</div>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyleft",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<a href=\"http://www.google.com/\">a[]</a>bar</div>",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"createlink":[false,false,"",false,false,""],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["outdent",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["delete",""],["inserttext","a"]],
    "fo<font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["fontname","sans-serif"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<font face=\"sans-serif\">a[]</font>bar</div>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["forwarddelete",""],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>ar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<font face=\"sans-serif\">a[]</font>bar</blockquote>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<font face=\"sans-serif\">a[]</font>bar</li></ol>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><font face=\"sans-serif\">a[]</font>bar</p>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<font face=\"sans-serif\">a[]</font>bar</li></ul>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<font face=\"sans-serif\">a[]</font>bar</div>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<font face=\"sans-serif\">a[]</font>bar</div>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyleft",""],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["fontname","sans-serif"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<font face=\"sans-serif\">a[]</font>bar</div>",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontname","sans-serif"],["outdent",""],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>bar",
    [true,true,true],
    {"fontname":[false,false,"serif",false,false,"sans-serif"],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["delete",""],["inserttext","a"]],
    "fo<font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["fontsize","4"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<font size=\"4\">a[]</font>bar</div>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["forwarddelete",""],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>ar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<font size=\"4\">a[]</font>bar</blockquote>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["fontsize","4"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<font size=\"4\">a[]</font>bar</li></ol>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><font size=\"4\">a[]</font>bar</p>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["fontsize","4"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<font size=\"4\">a[]</font>bar</li></ul>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["fontsize","4"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<font size=\"4\">a[]</font>bar</div>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["fontsize","4"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<font size=\"4\">a[]</font>bar</div>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["fontsize","4"],["justifyleft",""],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["fontsize","4"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<font size=\"4\">a[]</font>bar</div>",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","4"],["outdent",""],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"4"],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["delete",""],["inserttext","a"]],
    "fo<font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["forecolor","#0000FF"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<font color=\"#0000ff\">a[]</font>bar</div>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["forwarddelete",""],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>ar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<font color=\"#0000ff\">a[]</font>bar</blockquote>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<font color=\"#0000ff\">a[]</font>bar</li></ol>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><font color=\"#0000ff\">a[]</font>bar</p>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<font color=\"#0000ff\">a[]</font>bar</li></ul>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<font color=\"#0000ff\">a[]</font>bar</div>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<font color=\"#0000ff\">a[]</font>bar</div>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyleft",""],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["forecolor","#0000FF"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<font color=\"#0000ff\">a[]</font>bar</div>",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["outdent",""],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["delete",""]],
    "fo[]bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"delete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["delete",""],["inserttext","a"]],
    "fo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["formatblock","<div>"]],
    "<div>foo[]bar</div>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"formatblock":[false,false,"",false,false,"div"]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["formatblock","<div>"],["inserttext","a"]],
    "<div>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"formatblock":[false,false,"",false,false,"div"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["forwarddelete",""]],
    "foo[]ar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"forwarddelete":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["forwarddelete",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>ar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"forwarddelete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["indent",""]],
    "<blockquote>foo[]bar</blockquote>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"indent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["indent",""],["inserttext","a"]],
    "<blockquote>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</blockquote>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"indent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["inserthorizontalrule",""]],
    "foo<hr>{}bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthorizontalrule":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["inserthorizontalrule",""],["inserttext","a"]],
    "foo<hr><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthorizontalrule":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["inserthtml","ab<b>c</b>d"]],
    "fooab<b>c</b>d{}bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthtml":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["inserthtml","ab<b>c</b>d"],["inserttext","a"]],
    "fooab<b>c</b>d<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserthtml":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertimage":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertimage","/img/lion.svg"],["inserttext","a"]],
    "foo<img src=\"/img/lion.svg\"><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertimage":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertlinebreak",""]],
    "foo<br>{}bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertlinebreak":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertlinebreak",""],["inserttext","a"]],
    "foo<br><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertlinebreak":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertorderedlist",""],["inserttext","a"]],
    "<ol><li>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</li></ol>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertparagraph",""]],
    "<p>foo</p><p>{}bar</p>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertparagraph":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertparagraph",""],["inserttext","a"]],
    "<p>foo</p><p><span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</p>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertparagraph":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["insertunorderedlist",""],["inserttext","a"]],
    "<ul><li>foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</li></ul>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"insertunorderedlist":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifycenter",""]],
    "<div style=\"text-align:center\">foo[]bar</div>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifycenter":[false,false,"left",false,true,"center"]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifycenter",""],["inserttext","a"]],
    "<div style=\"text-align:center\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifycenter":[false,false,"left",false,true,"center"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyfull",""]],
    "<div style=\"text-align:justify\">foo[]bar</div>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyfull":[false,false,"left",false,true,"justify"]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyfull",""],["inserttext","a"]],
    "<div style=\"text-align:justify\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyfull":[false,false,"left",false,true,"justify"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyleft",""]],
    "foo[]bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyleft",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyleft":[false,true,"left",false,true,"left"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyright",""]],
    "<div style=\"text-align:right\">foo[]bar</div>",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyright":[false,false,"left",false,true,"right"]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["justifyright",""],["inserttext","a"]],
    "<div style=\"text-align:right\">foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar</div>",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"justifyright":[false,false,"left",false,true,"right"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["outdent",""]],
    "foo[]bar",
    [true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"outdent":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","#00FFFF"],["outdent",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"outdent":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["superscript",""],["subscript",""],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true,true],
    {"superscript":[false,false,"",false,false,""],"subscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["superscript",""],["inserttext","a"]],
    "foo<sup>a[]</sup>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,false,""],"superscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forecolor","#0000FF"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","#0000FF"],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forecolor","blue"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","blue"],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 255)"],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forecolor","brown"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\"><font color=\"#a52a2a\">a[]</font></a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(165, 42, 42)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","brown"],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\"><font color=\"#a52a2a\">a[]</font></a>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(165, 42, 42)"],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["forecolor","black"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\"><font color=\"#000000\">a[]</font></a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["forecolor","black"],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\"><font color=\"#000000\">a[]</font></a>bar",
    [true,true,true],
    {"forecolor":[false,false,"rgb(0, 0, 0)",false,false,"rgb(0, 0, 0)"],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["underline",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"createlink":[false,false,"",false,false,""],"underline":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline",""],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true],
    {"underline":[false,false,"",false,true,""],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["createlink","http://www.google.com/"],["underline","","first application"],["underline","","second application"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true,true],
    {"createlink":[false,false,"",false,false,""],"underline":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["underline","","first application"],["underline","","second application"],["createlink","http://www.google.com/"],["inserttext","a"]],
    "foo<a href=\"http://www.google.com/\">a[]</a>bar",
    [true,true,true,true],
    {"underline":[false,false,"",false,true,""],"createlink":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["fontsize","2"],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"2"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","2"],["subscript",""],["inserttext","a"]],
    "foo<sub>a[]</sub>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"2"],"subscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["subscript",""],["fontsize","3"],["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>bar",
    [true,true,true],
    {"subscript":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"3"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["fontsize","3"],["subscript",""],["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>bar",
    [true,true,true],
    {"fontsize":[false,false,"3",false,false,"3"],"subscript":[false,false,"",false,true,""],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["hilitecolor","aqua"],["backcolor","tan"],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(210, 180, 140)\">a[]</span>bar",
    [true,true,true],
    {"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(210, 180, 140)"],"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(210, 180, 140)"],"inserttext":[false,false,"",false,false,""]}],
["foo[]bar",
    [["backcolor","tan"],["hilitecolor","aqua"],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>bar",
    [true,true,true],
    {"backcolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"hilitecolor":[false,false,"rgba(0, 0, 0, 0)",false,false,"rgb(0, 255, 255)"],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["delete",""],["inserttext","a"]],
    "foo<b>a[]</b>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar]</i>baz",
    [["delete",""],["inserttext","a"]],
    "foo<i>a[]</i>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["delete",""],["inserttext","a"]],
    "foo<s>a[]</s>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar]</sub>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar]</sup>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sup>a[]</sup>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar]</u>baz",
    [["delete",""],["inserttext","a"]],
    "foo<u>a[]</u>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar]</a>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar]</span>baz",
    [["delete",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar]</a></font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"#a52a2a\">a[]</font></a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar]</a></font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"#000000\">a[]</font></a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar]</u></a>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar]</a></u>baz",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar]</font></sub>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar]</sub></font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sub><font size=\"1\">a[]</font></sub>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar]</font></sub>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar]</sub></font>baz",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<b>bar]</b>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<i>bar]</i>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<s>bar]</s>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub>bar]</sub>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sup>bar]</sup>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u>bar]</u>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com>bar]</a>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font face=sans-serif>bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=4>bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=#0000FF>bar]</font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<span style=background-color:#00FFFF>bar]</span>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=blue>bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=blue><a href=http://www.google.com>bar]</a></font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=brown>bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font color=brown><a href=http://www.google.com>bar]</a></font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><font color=black>bar]</font></a>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com><u>bar]</u></a>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<u><a href=http://www.google.com>bar]</a></u>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=2>bar]</font></sub>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=2><sub>bar]</sub></font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<sub><font size=3>bar]</font></sub>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["[foo<font size=3><sub>bar]</sub></font>baz",
    [["delete",""],["inserttext","a"]],
    "a[]baz",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<b>[bar</b>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<b>a[]</b>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<i>[bar</i>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<i>a[]</i>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<s>[bar</s>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<s>a[]</s>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub>[bar</sub>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sup>[bar</sup>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sup>a[]</sup>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<u>[bar</u>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<u>a[]</u>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com>[bar</a>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font face=sans-serif>[bar</font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<font face=\"sans-serif\">a[]</font>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=4>[bar</font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<font size=\"4\">a[]</font>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=#0000FF>[bar</font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<font color=\"#0000ff\">a[]</font>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<span style=background-color:#00FFFF>[bar</span>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<span style=\"background-color:rgb(0, 255, 255)\">a[]</span>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=blue>[bar</font></a>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=blue><a href=http://www.google.com>[bar</a></font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=brown>[bar</font></a>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"#a52a2a\">a[]</font></a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font color=brown><a href=http://www.google.com>[bar</a></font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><font color=black>[bar</font></a>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\"><font color=\"#000000\">a[]</font></a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com><u>[bar</u></a>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<u><a href=http://www.google.com>[bar</a></u>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<a href=\"http://www.google.com\">a[]</a>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=2>[bar</font></sub>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=2><sub>[bar</sub></font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sub><font size=\"1\">a[]</font></sub>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<sub><font size=3>[bar</font></sub>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sub><font size=\"3\">a[]</font></sub>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["foo<font size=3><sub>[bar</sub></font>baz]",
    [["delete",""],["inserttext","a"]],
    "foo<sub>a[]</sub>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<blockquote><font color=blue>[foo]</font></blockquote>",
    [["delete",""],["inserttext","a"]],
    "<blockquote><font color=\"blue\">a[]</font></blockquote>",
    [true,true],
    {"delete":[false,false,"",false,false,""],"inserttext":[false,false,"",false,false,""]}],
["<div><b>[abc]</b></div>",
    [["styleWithCSS", "false"],["delete",""],["inserttext","a"]],
    ["<div><b>a</b></div>",
     "<div><b>a</b><br></div>"],
    [true,true,true],
    {"bold":[false,true,"",false,true,""]}],
["<div>abc<b>[def]</b></div>",
    [["styleWithCSS", "false"],["delete",""],["inserttext","d"]],
    ["<div>abc<b>d</b></div>",
     "<div>abc<b>d</b><br></div>"],
    [true,true,true],
    {"bold":[false,true,"",false,true,""]}],
["<div><b>[abc]</b></div>",
    [["styleWithCSS", "false"],["delete",""],["insertparagraph",""],["inserttext","a"]],
    ["<div><br></div><div><b>a</b></div>",
     "<div><br></div><div><b>a</b><br></div>"],
    [true,true,true,true],
    {"bold":[false,true,"",false,true,""]}],
["<div>abc<b>[def]</b></div>",
    [["styleWithCSS", "false"], ["delete",""],["insertparagraph",""],["inserttext","d"]],
    ["<div>abc</div><div><b>d</b></div>",
     "<div>abc</div><div><b>d</b><br></div>",
     "<div>abc<br></div><div><b>d</b></div>",
     "<div>abc<br></div><div><b>d</b><br></div>"],
    [true,true,true,true],
    {"bold":[false,true,"",false,true,""]}],
["<div><b>[abc]</b></div>",
    [["styleWithCSS", "false"],["insertparagraph",""],["inserttext","a"]],
    ["<div><br></div><div><b>a</b></div>",
     "<div><br></div><div><b>a</b><br></div>"],
    [true,true,true],
    {"bold":[false,true,"",false,true,""]}],
["<div>abc<b>[def]</b></div>",
    [["styleWithCSS", "false"],["insertparagraph",""],["inserttext","d"]],
    ["<div>abc</div><div><b>d</b></div>",
     "<div>abc</div><div><b>d</b><br></div>",
     "<div>abc<br></div><div><b>d</b></div>",
     "<div>abc<br></div><div><b>d</b><br></div>"],
    [true,true,true],
    {"bold":[false,true,"",false,true,""]}],
]
