// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

use icu_collections::codepointtrie::{CodePointTrieHeader, TrieType};
use zerovec::{ule::RawBytesULE, ZeroSlice};

#[rustfmt::skip]
pub static INDEX: &ZeroSlice<u16> = ZeroSlice::<u16>::from_ule_slice(&RawBytesULE::<2>::from_array([
  0,0x40,0x7f,0xbf,0xff,0x12e,0x16d,0x1ad,0x1e5,0x224,0x250,0x28e,0x2ce,0x2de,0x31e,0x34f,
  0x38c,0x3bc,0x3fa,0x43a,0x44a,0x47b,0x4b2,0x4f2,0x532,0x572,0x5a3,0x5cf,0x60f,0x644,0x65e,0x69e,
  0x6de,0x71e,0x756,0x78d,0x7ca,0x809,0x848,0x887,0x8c6,0x905,0x944,0x983,0x9c3,0xa01,0xa3f,0xa7f,
  0xabf,0xafe,0xb3e,0xb7e,0xbbe,0xbfd,0xc3d,0xc7d,0xcbc,0xcfc,0xd3b,0xd7b,0xdbb,0xdfb,0xe3b,0xe79,
  0xbbd,0xbd7,0xbe7,0xbfd,0xc1d,0xc3b,0xc58,0xc77,0xc97,0xc97,0xca4,0xcc1,0xce1,0xceb,0xceb,0xceb,
  0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,
  0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,
  0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xceb,0xd0b,0xceb,0xceb,0xceb,0xd2b,0xd2b,0xd2b,0xd2c,
  0xd2b,0xd2b,0xd2b,0xd2c,0,0x10,0x20,0x30,0x40,0x50,0x60,0x70,0x7f,0x8f,0x9f,0xaf,
  0xbf,0xcf,0xdf,0xef,0xff,0x10f,0x11f,0x12f,0x12e,0x13e,0x14e,0x15e,0x16d,0x17d,0x18d,0x19d,
  0x1ad,0x1bd,0x1cd,0x1dd,0x1e5,0x1f5,0x205,0x215,0x224,0x234,0x244,0x254,0x250,0x260,0x270,0x280,
  0x28e,0x29e,0x2ae,0x2be,0x2ce,0x2de,0x2ee,0x2fe,0x2de,0x2ee,0x2fe,0x30e,0x31e,0x32e,0x33e,0x34e,
  0x34f,0x35f,0x36f,0x37f,0x38c,0x39c,0x3ac,0x3bc,0x3bc,0x3cc,0x3dc,0x3ec,0x3fa,0x40a,0x41a,0x42a,
  0x43a,0x44a,0x45a,0x46a,0x44a,0x45a,0x46a,0x47a,0x47b,0x48b,0x49b,0x4ab,0x4b2,0x4c2,0x4d2,0x4e2,
  0x4f2,0x502,0x512,0x522,0x532,0x542,0x552,0x562,0x572,0x582,0x592,0x5a2,0x5a3,0x5b3,0x5c3,0x5d3,
  0x5cf,0x5df,0x5ef,0x5ff,0x60f,0x61f,0x62f,0x63f,0x644,0x654,0x664,0x674,0x65e,0x66e,0x67e,0x68e,
  0x69e,0x6ae,0x6be,0x6ce,0x6de,0x6ee,0x6fe,0x70e,0x71e,0x72e,0x73e,0x74e,0x756,0x766,0x776,0x786,
  0x78d,0x79d,0x7ad,0x7bd,0x7ca,0x7da,0x7ea,0x7fa,0x809,0x819,0x829,0x839,0x848,0x858,0x868,0x878,
  0x887,0x897,0x8a7,0x8b7,0x8c6,0x8d6,0x8e6,0x8f6,0x905,0x915,0x925,0x935,0x944,0x954,0x964,0x974,
  0x983,0x993,0x9a3,0x9b3,0x9c3,0x9d3,0x9e3,0x9f3,0xa01,0xa11,0xa21,0xa31,0xa3f,0xa4f,0xa5f,0xa6f,
  0xa7f,0xa8f,0xa9f,0xaaf,0xabf,0xacf,0xadf,0xaef,0xafe,0xb0e,0xb1e,0xb2e,0xb3e,0xb4e,0xb5e,0xb6e,
  0xb7e,0xb8e,0xb9e,0xbae,0xbbe,0xbce,0xbde,0xbee,0xbfd,0xc0d,0xc1d,0xc2d,0xc3d,0xc4d,0xc5d,0xc6d,
  0xc7d,0xc8d,0xc9d,0xcad,0xcbc,0xccc,0xcdc,0xcec,0xcfc,0xd0c,0xd1c,0xd2c,0xd3b,0xd4b,0xd5b,0xd6b,
  0xd7b,0xd8b,0xd9b,0xdab,0xdbb,0xdcb,0xddb,0xdeb,0xdfb,0xe0b,0xe1b,0xe2b,0xe3b,0xe4b,0xe5b,0xe6b,
  0xe79,0xe89,0xe99,0xea9,0x5a3,0x5a3,0xeb9,0xec8,0xed8,0xee8,0xef7,0xf06,0xf14,0xf24,0x41,0x41,
  0xf34,0x61,0x61,0xf44,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0xf54,0xf64,0x5a3,0x5a3,0xf54,0x5a3,0x5a3,0xf5c,0xf6c,0xae1,0x5a3,0x5a3,
  0x5a3,0xf6c,0x5a3,0x5a3,0x5a3,0xf74,0xf84,0xf8d,0x5a3,0xf9d,0x41,0x41,0x41,0x41,0x41,0xfad,
  0xfbd,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0xfc0,0x5a3,0xfd0,0xfd5,0x5a3,0x5a3,0x5a3,0x5a3,0xfe5,0xff4,0x5a3,0x1004,0x5a3,0x1013,0x5a3,0x1023,
  0x864,0x1033,0x5a3,0x5a3,0x5a3,0x1043,0x1051,0x105d,0xb24,0x106d,0x107d,0xb24,0x5a3,0x5a3,0x108d,0x5a3,
  0x5a3,0x1094,0x10a4,0x5a3,0x10ab,0x5a3,0x5a3,0x5a3,0x5a3,0x10bb,0x5a3,0x50e,0x10cb,0x10db,0x10eb,0x5a3,
  0x50f,0x10fb,0x5a3,0x5a3,0x511,0x5a3,0x1093,0x110b,0x1119,0x1119,0x5a3,0x1129,0x5a3,0x5a3,0x5a3,0x1139,
  0x1149,0x1156,0xb24,0xb24,0x1166,0x1176,0x640,0xd18,0xd18,0xd18,0x7c9,0x5a3,0x5a3,0x1186,0x1194,0xed8,
  0x11a4,0x11b0,0x7cb,0x5a3,0x11c0,0x69e,0x5a3,0x5a3,0x11ce,0x11dd,0x5a3,0x5a3,0x11ed,0x11f9,0x1209,0x69e,
  0x5a3,0x1216,0x1226,0x41,0x41,0x1236,0x1246,0x1256,0x1265,0x126e,0x61,0x61,0x274,0x280,0x280,0x280,
  0x127e,0x1289,0x61,0x275,0x280,0x280,0x2ce,0x2ce,0x2ce,0x2ce,0xff,0xff,0xff,0xff,0xff,0xff,
  0xff,0xff,0xff,0x1299,0xff,0xff,0xff,0xff,0xff,0xff,0x12a8,0x12b8,0x12a8,0x12a8,0x12b8,0x12c8,
  0x12a8,0x12d8,0x12e8,0x12e8,0x12e8,0x12f8,0x1307,0x1317,0x1327,0x1337,0x1347,0x1357,0x1367,0x1377,0x1386,0x1394,
  0x13a4,0x13b4,0x13c4,0x13d4,0x13e4,0x13e4,0x13f3,0x1403,0x1412,0x1421,0x1431,0x1441,0x144f,0x145f,0x146f,0x147f,
  0x148f,0x148f,0x149c,0x14ac,0x14bc,0x1119,0x14cb,0x14db,0x1119,0x14e7,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,
  0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14fb,0x1119,0x150b,0x1119,0x1119,0x1119,
  0x1119,0x1516,0x1119,0x14e0,0x14eb,0x1526,0x1119,0x152a,0x1538,0x1119,0x1119,0x1541,0xd18,0x153d,0xd18,0x147f,
  0x147f,0x147f,0x1551,0x1119,0x1119,0x1119,0x1119,0x155d,0x147f,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x14c3,0x14c9,0x1119,0x1119,0x14e3,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x156d,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x157d,
  0x1587,0x147f,0x1569,0x1119,0x1119,0x1597,0x14eb,0x15a1,0x14eb,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,
  0x14eb,0x15a4,0x15ac,0x14eb,0x14eb,0x14eb,0x15b5,0x14eb,0x15c1,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,
  0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x14eb,0x1119,0x1119,0x1119,0x14eb,0x15cf,0x1119,0x1119,
  0x15dc,0x1119,0x15e6,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x41,0x41,0x41,0x61,0x61,0x61,0x15f6,
  0x1605,0xff,0xff,0xff,0xff,0xff,0xff,0x1614,0x1623,0x61,0x61,0x1633,0x5a3,0x5a3,0x5a3,0x1643,
  0x1653,0x5a3,0x1663,0x86a,0x86a,0x86a,0x86a,0x2ce,0x2ce,0x1673,0x1681,0x1691,0x16a1,0x16b1,0x16c1,0xd18,
  0xd18,0x1119,0x15e2,0x1119,0x1119,0x1119,0x1119,0x1119,0x16d1,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x16e1,0xd18,0x153c,0x16f1,0x16ff,0x170f,0x171f,0x501,0x5a3,0x5a3,
  0x5a3,0x5a3,0x172f,0xfbd,0x5a3,0x5a3,0x5a3,0x5a3,0x173e,0x4fd,0x5a3,0x5a3,0x501,0x5a3,0x5a3,0x5a3,
  0x5a3,0x50e,0x174e,0x5a3,0x5a3,0x1119,0x1119,0x16d1,0x5a3,0x1119,0x1754,0x1553,0x1119,0x1764,0x147e,0x1119,
  0x1119,0x1553,0x1119,0x1119,0x147e,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1119,0x1119,0x1119,0x1119,0x5a3,0x56d,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x510,0x1119,0x1119,
  0x1119,0x1541,0x5a3,0x5a3,0x1216,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1774,0x5a3,0x1784,0xd18,0xff,0xff,0x1794,0x17a4,0xff,0x17b4,0x5a3,
  0x5a3,0x5a3,0x5a3,0x17c4,0x17d4,0x2bd,0x17e4,0x17f4,0xfd,0xff,0xff,0xff,0x1804,0x1812,0x1822,0x1828,
  0x1832,0x183e,0x184e,0xd18,0x185c,0x186a,0x5a3,0x1877,0x1887,0x5a3,0x5a3,0x5a3,0x1897,0x18a7,0x5a3,0x5a3,
  0x18b3,0x18bf,0xb24,0x2ce,0x18cf,0x69e,0x5a3,0x18df,0x5a3,0x576,0x18ef,0x5a3,0x510,0x7ca,0x5a3,0x5a3,
  0x18ff,0x190e,0x191e,0x192e,0x10f1,0x5a3,0x5a3,0x1935,0x1944,0x1954,0x1964,0x5a3,0x1974,0x5a3,0x5a3,0x5a3,
  0x1984,0x1994,0x1999,0x19a9,0x19b9,0x19c8,0x10ba,0x86a,0x61,0x61,0x19d8,0x19e8,0x61,0x61,0x61,0x61,
  0x61,0x5a3,0x5a3,0x19f8,0xb24,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd97,
  0x5a3,0x1a08,0x5a3,0x5a3,0x511,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,
  0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,
  0x1a18,0x1a18,0x1a18,0x1a18,0x1a18,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,
  0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,
  0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x50f,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1093,0xd18,0xd18,0x1a38,
  0x1a45,0x1a54,0x1a5e,0x1a6e,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1a7c,0x1a89,0x4ff,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x1a99,0x1119,0x5a3,0x5a3,0x5a3,0x5a3,0x500,0x5a3,0x5a3,0x1aa9,0xd18,0xd18,0x1ab9,0x2ce,0x1ac9,0x2ce,
  0x1ad9,0x1ae5,0x1af5,0x1b04,0xae3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1b14,0x1b24,0x30,0x40,
  0x50,0x60,0x1b34,0x1b44,0x1b54,0x5a3,0x1b56,0x5a3,0x50e,0x19c7,0x1b66,0x1b76,0x1b85,0x865,0x5a3,0xae1,
  0x1b95,0x50f,0x50f,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x73e,0x1ba5,0x147f,0x147f,
  0xf96,0x148f,0x148f,0x148f,0x1bb5,0x1bbe,0x153b,0x1bcc,0xd18,0xd18,0x1119,0x1119,0x1bdc,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x510,0x5a3,0x5a3,0x5a3,0x993,0x1bec,0x1bf0,0x5a3,0x5a3,0x1bf8,
  0x5a3,0x1c07,0x5a3,0x5a3,0x1c17,0x5a3,0x1c27,0x5a3,0x5a3,0x1c37,0x1c47,0xd18,0xd18,0x41,0x41,0x342,
  0x61,0x61,0x5a3,0x5a3,0x5a3,0x5a3,0x50f,0xb24,0x41,0x41,0x1c57,0x61,0x1c5f,0x5a3,0x5a3,0x1c6f,
  0x5a3,0x5a3,0x5a3,0x1c73,0x335,0x335,0x1c83,0x1c91,0x1c9f,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x1663,0x5a3,0x10bb,0x1c6f,0xd18,0x1caf,0x280,0x280,0x1cb4,0xd18,0xd18,0xd18,0xd18,0x1cc4,0x5a3,0x5a3,
  0x1cce,0x5a3,0x1cdd,0x5a3,0x1ced,0x5a3,0x50e,0x154a,0xd18,0xd18,0xd18,0x5a3,0x1cfd,0x5a3,0x1d0d,0x5a3,
  0x1d1d,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x1d2d,0x147f,0x1d3d,0x147f,0x147f,0x1d4d,0x94e,0x5a3,
  0x1d5d,0x1bf3,0x1d6d,0x5a3,0x1d7d,0x5a3,0x1d8d,0xd18,0xd18,0x1d9d,0x5a3,0x1da8,0x1db8,0x5a3,0x5a3,0x5a3,
  0x1dc8,0x5a3,0x1dd8,0x5a3,0x1de8,0x5a3,0x1df8,0x1548,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,
  0x5a3,0x1094,0xd18,0xd18,0xd18,0x41,0x41,0x41,0x1e08,0x61,0x61,0x61,0x1e18,0x5a3,0x5a3,0x1e28,
  0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x147f,0x1bed,0x5a3,
  0x5a3,0x1e38,0xd99,0xd18,0xd18,0xd18,0xd18,0x5a3,0x1d8d,0x1e48,0x5a3,0x577,0x1e58,0xd18,0x5a3,0x1e68,
  0xd18,0xd18,0x5a3,0x1e78,0xd18,0x5a3,0x1663,0x1e88,0x5a3,0x5a3,0x575,0x1e98,0x1d3d,0x1ea8,0x1eb8,0x7cb,
  0x5a3,0x5a3,0x1ec8,0x1ed6,0x5a3,0x1094,0xb24,0x773,0x5a3,0x1ee6,0x1ef3,0x1f03,0x5a3,0x5a3,0x1f13,0x7cb,
  0x5a3,0x5a3,0x1f23,0x1f32,0x1f42,0x1f52,0x1f5d,0x5a3,0x954,0x1f6d,0x1f7c,0xd18,0xd18,0xd18,0xd18,0x1f8c,
  0x863,0x1f9b,0x5a3,0x5a3,0x630,0x1fab,0xb24,0x1fbb,0x858,0x868,0x1fca,0x1fda,0x1fea,0x1ff8,0x141d,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x2008,0x2018,0x2028,0xd99,0xd18,0x5a3,
  0x5a3,0x5a3,0x2038,0x2047,0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,
  0x5a3,0x2057,0x2066,0x2075,0x207d,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x208d,0x209c,0xb24,0x20ac,0xd18,0x5a3,
  0x5a3,0x20bc,0x20cc,0xb24,0xd18,0xd18,0xd18,0x5a3,0xf74,0x20dc,0x20ec,0x1663,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x1f6d,0x20fc,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0x41,0x41,0x61,0x61,0xc23,0x210c,0x211b,0x2127,0x5a3,0x2137,0x2147,0xb24,0xd18,0xd18,0xd18,
  0xd18,0x2157,0x5a3,0x5a3,0x2166,0x2176,0xd18,0x2186,0x5a3,0x5a3,0x2193,0x21a2,0x21b2,0x5a3,0x5a3,0x573,
  0x21c2,0x21d0,0x5a3,0x5a3,0x5a3,0x5a3,0x1094,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x868,0x5a3,0x2057,0x21e0,0x21f0,0xc23,0xf8d,0x550,0x5a3,
  0xe2a,0x2200,0x220f,0xd18,0xd18,0xd18,0xd18,0x96e,0x5a3,0x5a3,0x221f,0x222e,0xb24,0x223e,0x5a3,0x2248,
  0x2258,0xb24,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0x5a3,0x2268,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x993,0x147f,0x2278,
  0x2287,0x2295,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1093,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x148f,0x148f,0x148f,0x148f,0x148f,0x148f,0x22a5,0x22b5,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd97,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x22c5,0x5a3,0x5a3,
  0x50e,0x22d5,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,
  0x5a3,0x5a3,0x1663,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,
  0x5a3,0x1094,0x5a3,0x50e,0x191e,0x5a3,0x5a3,0x5a3,0x5a3,0x50e,0xb24,0x5a3,0x50f,0x22e5,0x5a3,0x5a3,
  0x5a3,0x22f5,0x2305,0x2315,0x2323,0x741,0x5a3,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x41,0x41,
  0x61,0x61,0x147f,0x2333,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0xe1d,0x2343,
  0x2344,0x2344,0x234c,0x235b,0xd18,0xd18,0xd18,0xd18,0x2369,0x2379,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x1c6f,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x10bb,0xd18,0xd18,0x1094,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x2389,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd98,0xd18,0xd18,
  0xd98,0x2398,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x511,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x73e,0x510,0x1094,0x23a8,0x23b8,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x2ce,0x2ce,0x641,0x2ce,0x141b,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x16d1,0xd18,
  0xd18,0xd18,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x16e1,0x1119,0x1119,0x23c8,0x1119,0x1119,0x1119,0x23d3,0x23e0,0x23ed,0x1119,0x23f9,0x1119,0x1119,0x1119,
  0x153d,0xd18,0x1119,0x1119,0x1119,0x1119,0x2407,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0x147f,0x2417,0x1119,0x1119,0x1119,0x1119,0x1119,0x1541,0x147f,0x1bf3,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x41,0x3b2,0x61,0x2427,0x3ae,0x1c8e,0x12a8,0x41,0xdc,0x2437,0x2447,0x2455,0x1c8f,0x41,
  0x3b2,0x61,0x2462,0x246f,0x61,0x247d,0x248d,0x249c,0x24a0,0x41,0xd8,0x61,0x41,0x3b2,0x61,0x2427,
  0x3ae,0x61,0x12a8,0x41,0xdc,0x24a0,0x41,0xd8,0x61,0x41,0x3b2,0x61,0x24b0,0x41,0x24bf,0xeb,
  0x38a,0x24cf,0x61,0x24db,0x41,0x24bb,0xe7,0x24c9,0xc7,0x61,0xed,0x41,0x24e7,0x61,0x24f4,0x2502,
  0x2502,0x2502,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x2ce,0x2ce,0x2ce,0x2512,0x2ce,0x2ce,0x251d,0x252a,0x2536,0x13f8,0x4c2,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x25a,0x2546,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xe4c,0x2556,0x2564,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x5a3,0x5a3,0x510,0x2574,0x2584,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x5a3,0x2594,0xd18,0x5a3,0x5a3,0x633,0x25a4,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x25b4,0x50e,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x25c4,0x141b,0xd18,0xd18,0x41,0x41,0xdc,0x61,0x25d4,0x191e,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x1f52,0x147f,0x147f,0x25e4,0x25f4,0xd18,0xd18,
  0xd18,0xd18,0x1f52,0x147f,0x2604,0x1bee,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xae4,0x5a3,0x2614,0x2621,0x262f,0x263f,0x264d,0x2655,0x867,0x511,0x2664,0x511,0xd18,0xd18,
  0xd18,0x2674,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x1119,0x1119,0x153c,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x16d1,0x1754,0x1118,0x1118,0x1118,
  0x1119,0x16e1,0x2684,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x153a,0xd18,0xd18,0xd18,
  0x1bd6,0x1119,0x1bca,0x1119,0x1119,0x153c,0x153f,0x1bcb,0x16e1,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x2691,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x26a1,
  0x153b,0x153b,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x16d1,0x1119,0x1119,0x1119,0x1119,0x1119,0x153f,
  0x153c,0x1bcc,0x153c,0x1119,0x1119,0x1119,0x1540,0xf9d,0x1119,0x1119,0x1540,0x1119,0x153a,0x1bcb,0xd18,0xd18,
  0xd18,0xd18,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x16d1,0x153a,0x26ae,0x1541,0x1119,0x153b,0x153d,0x16e1,0xf9d,0x1540,0x1541,0x1119,0x1119,0x1119,
  0x1119,0x1119,0x1119,0x1119,0x1119,0x1119,0x26be,0x1119,0x1119,0x153d,0xd18,0xd18,0xb24,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd18,0xd18,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x1094,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x50f,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0xd99,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x993,0xd18,0x5a3,0x50f,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,
  0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x5a3,0x5a3,0x5a3,
  0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,0x5a3,
  0x5a3,0x73e,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x26ce,0xd18,0x26de,
  0x26de,0x26de,0x26de,0x26de,0x26de,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0xd18,0x2ce,0x2ce,0x2ce,
  0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0x2ce,0xd18,0x1a28,0x1a28,0x1a28,
  0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,
  0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x1a28,0x26ee,0x84,0xa4,0xc4,
  0xe4,0x104,0x124,0x144,0x164,0x184,0x1a0,0x1c0,0x1da,0x1fa,0x21a,0x23a,0x25a,0x27a,0x29a,0x2b9,
  0x2d9,0x2f9,0x319,0x339,0x359,0x379,0x399,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3bd,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3dd,0x3b9,0x3f5,0x415,0x435,0x455,0x3b9,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x475,0x495,0x495,0x495,0x495,0x4b5,0x4b5,0x4b5,
  0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4c5,0x4df,0x4fd,0x51d,0x53d,0x55d,0x57d,
  0x59d,0x5bd,0x5dd,0x5fd,0x617,0x637,0x657,0x677,0x697,0x6b7,0x6d7,0x6f7,0x712,0x3b9,0x732,0x752,
  0x767,0x767,0x767,0x767,0x76e,0x3b9,0x3b9,0x78e,0x767,0x767,0x767,0x767,0x767,0x3b9,0x7ae,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x3b9,
  0x7ce,0x767,0x7ea,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x80a,0x3b9,0x3b9,0x82a,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x83b,
  0x85b,0x872,0x767,0x767,0x767,0x767,0x892,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x8a2,0x8c2,
  0x8e2,0x902,0x922,0x942,0x962,0x767,0x972,0x992,0x9a9,0x767,0x9b9,0x9d9,0x767,0x9f2,0xa12,0xa32,
  0xa52,0x942,0xa72,0xa92,0xaad,0x767,0x767,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0xacd,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0xadd,
  0xafc,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0xb12,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,
  0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0xb1d,0x767,0x767,0x767,0x767,0x767,0x767,0x3b9,0xb3d,0x767,
  0x767,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0x3b9,0xb5d,0x767,0x767,0x767,0x767,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0xb7d,0x767,0x767,0x767,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,
  0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x767,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,
  0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,
  0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0x4b5,0xb9d
]));

#[rustfmt::skip]
pub static DATA: &ZeroSlice<u8> = ZeroSlice::<u8>::from_ule_slice(&[
  0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
  0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
  0xc,0x17,0x17,0x17,0x19,0x17,0x17,0x17,0x14,0x15,0x17,0x18,0x17,0x13,0x17,0x17,
  9,9,9,9,9,9,9,9,9,9,0x17,0x17,0x18,0x18,0x18,0x17,
  0x17,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,0x14,0x17,0x15,0x1a,0x16,
  0x1a,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,0x14,0x18,0x15,0x18,0xf,
  0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,
  0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xc,
  0x17,0x19,0x19,0x19,0x19,0x1b,0x17,0x1a,0x1b,5,0x1c,0x18,0x10,0x1b,0x1a,0x1b,
  0x18,0xb,0xb,0x1a,2,0x17,0x17,0x1a,0xb,5,0x1d,0xb,0xb,0xb,0x17,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,0x18,1,1,1,1,1,1,1,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,0x18,2,2,2,2,2,2,2,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,1,2,1,2,1,2,2,1,1,
  2,1,2,1,1,2,1,1,1,2,2,1,1,1,1,2,
  1,1,2,1,1,1,2,2,2,1,1,2,1,1,2,1,
  2,1,2,1,1,2,1,2,2,1,2,1,1,2,1,1,
  1,2,1,2,1,1,2,2,5,1,2,2,2,5,5,5,
  5,1,3,2,1,3,2,1,3,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,3,
  2,1,2,1,1,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,2,2,2,2,2,2,1,
  1,2,1,1,2,1,2,1,1,1,1,2,1,2,1,2,
  1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
  0x1a,0x1a,0x1a,0x1a,4,4,4,4,4,4,4,4,4,4,4,4,
  0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,4,
  4,4,4,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,0x1a,4,0x1a,0x1a,0x1a,
  0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,2,
  1,2,4,0x1a,1,2,0,0,4,2,2,2,0x17,1,0,0,
  0,0,0x1a,0x1a,1,0x17,1,1,1,0,1,0,1,1,2,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,
  2,1,1,1,2,2,2,1,2,1,2,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,
  2,2,2,1,2,0x18,1,2,1,1,2,2,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,0x1b,6,6,6,
  6,6,7,7,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,1,2,1,2,1,
  2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,1,2,1,2,1,2,0,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,0,0,4,0x17,0x17,0x17,0x17,0x17,0x17,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,2,2,2,2,2,0x17,0x13,0,0,0x1b,
  0x1b,0x19,0,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  0x13,6,0x17,6,6,0x17,6,6,0x17,6,0,0,0,0,0,0,
  0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,
  0,5,5,5,5,0x17,0x17,0,0,0,0,0,0,0,0,0,
  0,0,0x10,0x10,0x10,0x10,0x10,0x10,0x18,0x18,0x18,0x17,0x17,0x19,0x17,0x17,
  0x1b,0x1b,6,6,6,6,6,6,6,6,6,6,6,0x17,0x10,0x17,
  0x17,0x17,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,4,5,5,5,5,5,5,5,5,5,5,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,9,9,9,9,9,9,9,9,9,9,0x17,0x17,0x17,0x17,
  5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,0x17,5,6,6,6,6,6,6,6,0x10,0x1b,6,6,
  6,6,6,6,4,4,6,6,0x1b,6,6,6,6,5,5,9,
  9,9,9,9,9,9,9,9,9,5,5,5,0x1b,0x1b,5,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0x10,5,
  6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,
  0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,5,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,
  9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,
  6,6,4,4,0x1b,0x17,0x17,0x17,4,0,0,6,0x19,0x19,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,6,6,6,6,4,6,6,6,6,6,6,6,
  6,6,4,6,6,6,4,6,6,6,6,6,0,0,0x17,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,6,6,6,0,0,0x17,0,5,5,
  5,5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,0x1a,5,
  5,5,5,5,5,0,0x10,0x10,0,0,0,0,0,0,6,6,
  6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,4,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0x10,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,8,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,6,8,6,5,8,8,6,6,6,6,6,6,
  6,6,8,8,8,8,6,8,8,5,6,6,6,6,6,6,
  6,5,5,5,5,5,5,5,5,5,5,6,6,0x17,0x17,9,
  9,9,9,9,9,9,9,9,9,0x17,4,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,6,8,8,0,5,5,5,
  5,5,5,5,5,0,0,5,5,0,0,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,0,5,5,5,5,5,5,5,0,5,0,0,0,5,5,
  5,5,0,0,6,5,8,8,6,6,6,6,0,0,8,8,
  0,0,8,8,6,5,0,0,0,0,0,0,0,0,8,0,
  0,0,0,5,5,0,5,5,5,6,6,0,0,9,9,9,
  9,9,9,9,9,9,9,5,5,0x19,0x19,0xb,0xb,0xb,0xb,0xb,
  0xb,0x1b,0x19,5,0x17,6,0,6,6,8,0,5,5,5,5,5,
  5,0,0,0,0,5,5,0,0,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
  5,5,5,5,5,5,5,0,5,5,0,5,5,0,5,5,
  0,0,6,0,8,8,6,6,0,0,0,0,6,6,0,0,
  6,6,6,0,0,0,6,0,0,0,0,0,0,0,5,5,
  5,5,0,5,0,0,0,0,0,0,0,9,9,9,9,9,
  9,9,9,9,9,6,6,5,5,5,6,0x17,0,0,0,0,
  0,0,0,0,0,6,6,8,0,5,5,5,5,5,5,5,
  5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,
  5,5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,
  6,5,8,8,6,6,6,6,6,0,6,6,8,0,8,8,
  6,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,5,5,6,6,0,0,9,9,9,9,9,9,9,
  9,9,9,0x17,0x19,0,0,0,0,0,0,0,5,6,6,6,
  6,6,6,0,6,8,8,0,5,5,5,5,5,5,5,5,
  0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,
  5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,6,
  5,8,6,6,6,6,0,0,8,8,0,0,8,8,6,0,
  0,0,0,0,0,0,6,6,8,0,0,0,0,5,5,0,
  5,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,
  9,0x1b,5,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,
  0,6,5,0,5,5,5,5,5,5,0,0,0,5,5,5,
  0,5,5,5,5,0,0,0,5,5,0,5,0,5,5,0,
  0,0,5,5,0,0,0,5,5,5,0,0,0,5,5,5,
  5,5,5,5,5,5,5,5,5,0,0,0,0,8,8,6,
  8,8,0,0,0,8,8,8,0,8,8,8,6,0,0,5,
  0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0xb,
  0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x1b,0,0,0,0,0,6,
  8,8,8,6,5,5,5,5,5,5,5,5,0,5,5,5,
  0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,0,0,6,5,6,6,8,
  8,8,8,0,6,6,6,0,6,6,6,6,0,0,0,0,
  0,0,0,6,6,0,5,5,5,0,0,5,0,0,5,5,
  6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,0,
  0,0,0,0,0,0x17,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,5,6,
  8,8,0x17,5,5,5,5,5,5,5,5,0,5,5,5,0,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,
  5,5,0,5,5,5,5,5,0,0,6,5,8,6,8,8,
  8,8,8,0,6,8,8,0,8,8,6,6,0,0,0,0,
  0,0,0,8,8,0,0,0,0,0,0,5,5,0,5,5,
  6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,5,
  5,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,
  8,8,5,5,5,5,5,5,5,5,5,0,5,5,5,0,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,6,6,5,8,8,6,6,
  6,6,0,8,8,8,0,8,8,8,6,5,0x1b,0,0,0,
  0,5,5,5,8,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,6,
  6,0,0,9,9,9,9,9,9,9,9,9,9,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0x1b,5,5,5,5,5,5,0,6,8,
  8,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,0,0,0,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
  5,5,5,5,5,5,5,5,5,0,5,0,0,5,5,5,
  5,5,5,5,0,0,0,6,0,0,0,0,8,8,8,6,
  6,6,0,6,0,8,8,8,8,8,8,8,8,0,0,0,
  0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,8,
  8,0x17,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,5,
  6,6,6,6,6,6,6,0,0,0,0,0x19,5,5,5,5,
  5,5,4,6,6,6,6,6,6,6,6,0x17,9,9,9,9,
  9,9,9,9,9,9,0x17,0x17,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,5,5,0,5,
  0,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
  5,0,5,5,5,5,5,5,5,5,5,5,6,5,5,6,
  6,6,6,6,6,6,6,6,5,0,0,5,5,5,5,5,
  0,4,0,6,6,6,6,6,6,0,0,9,9,9,9,9,
  9,9,9,9,9,0,0,5,5,5,5,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,5,0x1b,0x1b,0x1b,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x1b,0x17,
  0x1b,0x1b,0x1b,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,9,9,9,9,9,
  9,9,9,9,9,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,
  6,0x1b,6,0x1b,6,0x14,0x15,0x14,0x15,8,8,5,5,5,5,5,
  5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,5,0,0,0,0,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,8,6,6,6,6,6,
  0x17,6,6,5,5,5,5,5,6,6,6,6,6,6,6,6,
  6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,6,6,6,6,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0x1b,0x1b,0x17,0x17,0x17,0x17,0x17,0x1b,0x1b,
  0x1b,0x1b,0x17,0x17,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,
  5,5,5,5,8,8,6,6,6,8,6,6,6,6,6,6,
  8,6,6,8,8,6,6,5,9,9,9,9,9,9,9,9,
  9,9,0x17,0x17,0x17,0x17,0x17,0x17,5,5,5,5,5,5,8,8,
  6,6,5,5,5,5,6,6,5,8,8,8,5,5,8,8,
  8,8,8,8,8,5,5,6,6,6,6,5,5,5,5,5,
  5,5,5,5,5,5,6,8,8,6,6,8,8,8,8,8,
  8,6,5,8,9,9,9,9,9,9,9,9,9,9,8,8,
  8,6,0x1b,0x1b,1,1,1,1,1,1,0,1,0,0,0,0,
  0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,0x17,
  4,2,2,2,5,5,5,5,5,5,5,5,5,0,5,5,
  5,5,0,0,5,5,5,5,5,5,5,0,5,0,5,5,
  5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,0,
  0,6,6,6,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,1,1,1,
  1,1,1,0,0,2,2,2,2,2,2,0,0,0x13,5,5,
  5,5,5,5,5,5,5,5,5,5,5,5,5,0x1b,0x17,5,
  0xc,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  0x14,0x15,0,0,0,5,5,5,5,5,5,5,5,5,5,5,
  0x17,0x17,0x17,0xa,0xa,5,5,5,5,5,5,5,5,0,0,0,
  0,0,0,0,5,5,6,6,6,8,0,0,0,0,0,0,
  0,0,0,5,5,6,6,8,0x17,0x17,0,0,0,0,0,0,
  0,0,0,5,5,6,6,0,0,0,0,0,0,0,0,0,
  0,0,0,5,0,6,6,0,0,0,0,0,0,0,0,0,
  0,0,0,5,5,5,5,6,6,8,6,6,6,6,6,6,
  6,8,8,8,8,8,8,6,8,8,6,6,6,6,6,6,
  6,0x17,0x17,0x17,4,0x17,0x17,0x17,0x19,5,6,0,0,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0x17,0x17,0x17,
  0x17,0x17,0x17,0x13,0x17,0x17,0x17,0x17,6,6,6,0x10,6,5,5,5,
  4,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,
  0,0,0,0,5,5,5,5,5,6,6,5,5,5,5,5,
  5,5,5,5,6,5,0,0,0,0,0,5,5,5,5,5,
  5,0,0,0,0,0,0,0,0,0,0,6,6,6,8,8,
  8,8,6,6,8,8,8,0,0,0,0,8,8,6,8,8,
  8,8,8,8,6,6,6,0,0,0,0,0x1b,0,0,0,0x17,
  0x17,9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,
  0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,9,
  9,9,9,9,9,0xb,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,5,5,5,5,5,5,5,
  6,6,8,8,6,0,0,0x17,0x17,5,5,5,5,5,8,6,
  8,6,6,6,6,6,6,6,0,6,8,6,8,8,6,6,
  6,6,6,6,6,6,8,8,8,6,6,6,6,6,6,6,
  6,6,6,0,0,6,0x17,0x17,0x17,0x17,0x17,0x17,0x17,4,0x17,0x17,
  0x17,0x17,0x17,0x17,0,0,6,6,6,6,6,6,6,6,6,6,
  6,6,6,6,7,6,5,5,5,5,6,8,6,6,6,6,
  6,8,6,8,8,8,6,8,8,5,5,5,5,5,5,5,
  5,0,0,0,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,
  6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x17,0x17,0,
  5,8,6,6,6,6,8,8,6,6,8,6,6,6,5,5,
  5,5,5,5,6,8,6,6,8,8,8,6,8,6,6,8,
  8,0,0,0,0,0,0,0,0,0x17,0x17,0x17,0x17,5,5,5,
  5,8,8,8,8,8,8,8,8,6,6,6,6,8,8,6,
  6,0,0,0,0x17,0x17,0x17,0x17,0x17,9,9,9,9,9,9,9,
  9,9,9,0,0,0,5,5,5,5,5,5,5,5,4,4,
  4,4,4,4,0x17,0x17,2,2,2,2,2,2,2,2,2,0,
  0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,
  1,0,0,1,1,1,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0,
  0,0,0,0,0,0,6,6,6,0x17,6,6,6,6,6,6,
  6,6,6,6,6,6,8,6,6,6,6,6,6,6,5,5,
  5,5,6,5,5,8,6,6,5,0,0,0,0,0,4,4,
  4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,
  2,4,2,2,2,2,2,2,2,1,2,1,2,1,2,2,
  2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,
  1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,
  1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,
  0,1,0,1,0,1,0,1,2,2,2,2,2,2,2,2,
  2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,
  3,3,3,3,3,3,3,3,2,2,2,2,2,0,2,2,
  1,1,1,1,3,0x1a,2,0x1a,0x1a,2,2,2,0,2,2,1,
  1,1,1,3,0x1a,0x1a,0x1a,2,2,2,2,0,0,2,2,1,
  1,1,1,0,0x1a,0x1a,0x1a,2,2,2,2,2,2,2,2,1,
  1,1,1,1,0x1a,0x1a,0x1a,0,0,2,2,2,0,2,2,1,
  1,1,1,3,0x1a,0x1a,0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,
  0xc,0xc,0x10,0x10,0x10,0x10,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x17,0x17,0x1c,
  0x1d,0x14,0x1c,0x1c,0x1d,0x14,0x1c,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0xd,
  0xe,0x10,0x10,0x10,0x10,0x10,0xc,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
  0x1c,0x1d,0x17,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x18,0x14,0x15,0x17,0x17,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x17,0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
  0x17,0x17,0x17,0xc,0x10,0x10,0x10,0x10,0x10,0,0x10,0x10,0x10,0x10,0x10,0x10,
  0x10,0x10,0x10,0x10,0xb,4,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0x18,0x18,
  0x18,0x14,0x15,4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x18,0x18,
  0x18,0x14,0x15,0,4,4,4,4,4,4,4,4,4,4,4,4,
  4,0,0,0,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
  0x19,0x19,0x19,0x19,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,
  7,7,7,6,7,7,7,6,6,6,6,6,6,6,6,6,
  6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0x1b,0x1b,1,0x1b,0x1b,0x1b,0x1b,1,0x1b,0x1b,2,1,1,1,2,
  2,1,1,1,2,0x1b,1,0x1b,0x1b,0x18,1,1,1,1,1,0x1b,
  0x1b,0x1b,0x1b,1,0x1b,1,0x1b,1,0x1b,1,1,1,1,0x1b,2,1,
  1,1,1,2,5,5,5,5,2,0x1b,0x1b,2,2,1,1,0x18,
  0x18,0x18,0x18,0x18,1,2,2,2,2,0x1b,0x18,0x1b,0x1b,2,0x1b,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xa,
  0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,1,
  2,0xa,0xa,0xa,0xa,0xb,0x1b,0x1b,0,0,0,0,0x18,0x18,0x18,0x18,
  0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x18,0x1b,0x1b,0x18,
  0x1b,0x1b,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1b,0x1b,0x18,0x1b,0x18,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,
  0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x14,0x15,0x14,0x15,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x14,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x18,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,0,
  0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x18,0x18,
  0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,
  0x15,0x14,0x15,0x14,0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x14,
  0x15,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x14,0x15,0x18,
  0x18,0x18,0x18,0x18,0x1b,0x1b,0x18,0x18,0x18,0x18,0x18,0x18,0x1b,0x1b,0x1b,0x1b,
  0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,1,2,1,1,1,2,2,1,2,1,
  2,1,2,1,1,1,2,1,2,2,1,2,2,2,2,2,
  2,4,4,1,1,2,1,2,2,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,1,
  2,1,2,6,6,1,2,0,0,0,0,0,0x17,0x17,0x17,0x17,
  0xb,0x17,0x17,2,2,2,2,2,2,0,2,0,0,0,0,0,
  2,0,0,5,5,5,5,5,5,5,5,0,0,0,0,0,
  0,0,4,0x17,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,6,5,5,5,5,5,5,5,0,0,0,0,0,0,
  0,0,0,0x17,0x17,0x1c,0x1d,0x1c,0x1d,0x17,0x17,0x17,0x1c,0x1d,0x17,0x1c,
  0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x13,0x17,0x17,0x13,0x17,0x1c,0x1d,0x17,
  0x17,0x1c,0x1d,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x17,0x17,0x17,0x17,0x17,
  4,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x13,0x13,0x17,0x17,0x17,
  0x17,0x13,0x17,0x14,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
  0x17,0x1b,0x1b,0x17,0x17,0x17,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x13,0,
  0,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,0,0,0,0,
  0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,0,0,
  0,0xc,0x17,0x17,0x17,0x1b,4,5,0xa,0x14,0x15,0x14,0x15,0x14,0x15,0x14,
  0x15,0x1b,0x1b,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x13,0x14,0x15,0x15,0x1b,
  0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,6,6,6,6,8,8,0x13,
  4,4,4,4,4,0x1b,0x1b,0xa,0xa,0xa,4,5,0x17,0x1b,0x1b,5,
  5,5,5,5,5,5,0,0,6,6,0x1a,0x1a,4,4,5,5,
  5,5,5,5,5,5,5,5,5,0x17,4,4,4,5,0x1b,0x1b,
  0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,5,5,5,5,5,5,5,5,5,5,5,5,
  4,0x17,0x17,0x17,9,9,9,9,9,9,9,9,9,9,5,5,
  0,0,0,0,1,2,1,2,1,2,1,2,1,2,1,2,
  1,2,5,6,7,7,7,0x17,6,6,6,6,6,6,6,6,
  6,6,0x17,4,1,2,1,2,1,2,1,2,1,2,1,2,
  4,4,6,6,5,5,5,5,5,5,0xa,0xa,0xa,0xa,0xa,0xa,
  0xa,0xa,0xa,0xa,6,6,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,0,
  0,0,0,0,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,4,4,4,4,4,
  4,4,4,4,0x1a,0x1a,1,2,1,2,1,2,1,2,1,2,
  1,2,1,2,4,2,2,2,2,2,2,2,2,1,2,1,
  2,1,1,2,1,2,1,2,1,2,4,0x1a,0x1a,1,2,1,
  2,5,1,2,1,2,2,2,1,2,1,2,1,2,1,2,
  1,2,1,1,1,1,1,2,1,2,1,2,1,2,1,2,
  1,2,1,1,1,1,2,1,2,0,0,0,0,0,1,2,
  0,2,0,2,1,2,1,2,0,0,0,0,0,0,4,4,
  4,1,2,5,4,4,2,5,5,5,5,5,6,5,5,5,
  6,5,5,5,5,6,5,5,5,5,8,8,6,6,8,0x1b,
  0x1b,0x1b,0x1b,6,0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x19,
  0x1b,0,0,0,0,0,0,5,5,5,5,0x17,0x17,0x17,0x17,0,
  0,0,0,0,0,0,0,8,8,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,
  8,8,8,6,6,0,0,0,0,0,0,0,0,0x17,0x17,6,
  6,5,5,5,5,5,5,0x17,0x17,0x17,5,0x17,5,5,6,5,
  5,5,5,5,5,6,6,6,6,6,6,6,6,0x17,0x17,6,
  6,8,8,0,0,0,0,0,0,0,0,0,0,0,0x17,5,
  5,5,6,8,8,6,6,6,6,8,8,6,6,8,8,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,4,9,9,
  9,9,9,9,9,9,9,9,0,0,0,0,0x17,0x17,5,5,
  5,5,5,6,4,5,5,5,5,5,5,5,5,5,6,6,
  6,6,6,6,8,6,6,8,8,6,6,0,0,0,0,0,
  0,0,0,0,5,5,5,6,5,5,5,5,5,5,5,5,
  6,8,0,0,9,9,9,9,9,9,9,9,9,9,0,0,
  0x17,0x17,0x17,0x17,4,5,5,5,5,5,5,0x1b,0x1b,0x1b,5,8,
  6,8,5,5,6,5,6,6,6,5,5,6,6,5,5,5,
  5,5,6,6,5,6,5,0,0,0,0,0,0,0,0,0,
  0,0,0,0,5,5,4,0x17,0x17,5,5,5,5,5,5,5,
  5,5,5,5,8,6,6,8,8,0x17,0x17,5,4,4,8,6,
  0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,0,
  0,5,5,5,5,5,5,0,2,2,2,2,2,2,2,2,
  2,2,2,0x1a,4,4,4,4,2,2,2,2,2,2,2,2,
  2,4,0x1a,0x1a,0,0,0,0,5,5,5,8,8,6,8,8,
  6,8,8,0x17,8,6,0,0,5,5,5,5,5,5,5,0,
  0,0,0,5,5,5,5,5,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
  0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
  0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,2,2,2,2,2,2,2,0,
  0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,
  0,0,5,6,5,5,5,5,5,5,5,5,5,0x18,5,5,
  5,5,5,5,5,0,5,5,5,5,5,0,5,0,5,5,
  0,5,5,0,5,5,5,5,5,5,5,5,5,5,0x1a,0x1a,
  0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0,0,0,0,
  0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,
  5,5,5,5,5,5,5,0x15,0x14,5,5,5,5,5,5,5,
  5,0,0,0,0,0,0,0,0x1b,5,5,5,5,5,5,5,
  5,5,5,5,5,0x19,0x1b,0x1b,0x1b,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
  0x14,0x15,0x17,0,0,0,0,0,0,0x17,0x13,0x13,0x16,0x16,0x14,0x15,
  0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x14,0x15,0x17,0x17,0x14,0x15,0x17,0x17,
  0x17,0x17,0x16,0x16,0x16,0x17,0x17,0x17,0,0x17,0x17,0x17,0x17,0x13,0x14,0x15,
  0x14,0x15,0x14,0x15,0x17,0x17,0x18,0x13,0x18,0x18,0x18,0,0x17,0x19,0x17,0x17,
  0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,
  5,0,0,0x10,0,0x17,0x17,0x17,0x19,0x17,0x17,0x17,0x14,0x15,0x17,0x18,
  0x17,0x13,0x17,0x17,2,2,2,2,2,2,2,2,2,2,2,0x14,
  0x18,0x15,0x18,0x14,0x15,0x17,0x14,0x15,0x17,0x17,5,5,5,5,5,5,
  5,5,5,5,4,5,5,5,5,5,5,5,5,5,5,5,
  5,5,5,5,4,4,0,0,5,5,5,5,5,5,0,0,
  5,5,5,0,0,0,0x19,0x19,0x18,0x1a,0x1b,0x19,0x19,0,0x1b,0x18,
  0x18,0x18,0x18,0x1b,0x1b,0,0,0,0,0,0,0,0,0,0x10,0x10,
  0x10,0x1b,0x1b,0,0,5,5,5,5,5,5,5,5,5,5,5,
  0,5,5,0,5,0x17,0x17,0x17,0,0,0,0,0xb,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xa,0xa,0xa,0xa,0xa,0xb,0xb,0xb,0xb,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0xb,0xb,0x1b,0x1b,0x1b,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,0,0,6,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0,
  0,0,0,0,0,5,5,5,0xa,5,5,5,5,5,5,5,
  5,0xa,0,0,0,0,0,5,5,5,5,5,5,6,6,6,
  6,6,0,0,0,0,0,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,0,0x17,5,5,5,5,0,0,0,0,5,
  5,5,5,5,5,5,5,0x17,0xa,0xa,0xa,0xa,0xa,0,0,0,
  0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,2,
  2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,5,
  5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,
  0,0,0x17,1,1,1,0,1,1,0,2,2,2,2,2,2,
  2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,
  2,0,2,2,2,2,2,2,2,0,2,2,0,0,0,4,
  4,4,4,4,4,0,4,4,4,4,4,4,4,4,4,0,
  0,0,0,0,5,5,5,5,5,5,0,0,5,0,5,5,
  5,5,5,5,0,5,5,0,0,0,5,0,0,5,5,5,
  5,5,5,0,0x17,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,
  5,5,5,5,0x1b,0x1b,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,
  0,5,5,0,0,0,0,0,0xb,0xb,0xb,0xb,0xb,5,5,5,
  5,5,5,0xb,0xb,0xb,0xb,0xb,0xb,0,0,0,0x17,5,5,5,
  5,5,5,5,5,5,5,0,0,0,0,0,0x17,5,5,5,
  5,5,5,5,5,0,0,0,0,0xb,0xb,5,5,0,0,0xb,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,6,6,
  6,0,6,6,0,0,0,0,0,6,6,6,6,5,5,5,
  5,5,5,0,0,6,6,6,0,0,0,0,6,0x17,0x17,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,0,5,5,5,
  5,5,5,5,5,5,5,5,5,5,0xb,0xb,0x17,5,5,5,
  5,5,5,5,5,5,5,5,5,5,0xb,0xb,0xb,5,5,5,
  5,5,5,5,5,0x1b,5,5,5,5,5,5,5,6,6,0,
  0,0,0,0xb,0xb,0xb,0xb,0xb,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,
  0,0,0,0,0,0,0,0,5,5,5,5,5,5,0,0,
  0,0x17,0x17,0x17,0x17,0x17,0x17,0x17,5,5,5,5,5,5,0,0,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,0,0,0,0,0,
  0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,5,0,0,0,0,0,0,
  0,0x17,0x17,0x17,0x17,0,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,
  0,0,0xb,0xb,0xb,0xb,0xb,0xb,5,5,5,5,6,6,6,6,
  0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
  5,5,0,6,6,0x13,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,5,
  0,0,0,0,0,0,0,0,6,0xb,0xb,0xb,0xb,0x17,0x17,0x17,
  0x17,0x17,0,0,0,0,0,0,5,5,6,6,6,6,0x17,0x17,
  0x17,0x17,0,0,0,0,0,0,5,5,5,5,5,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,0,0,0,0,8,6,8,5,5,5,5,5,
  5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0,0,0xb,0xb,0xb,0xb,0xb,0xb,9,9,
  9,9,9,9,9,9,9,9,6,5,5,6,6,5,0,0,
  0,0,0,0,0,0,0,6,8,8,8,6,6,6,6,8,
  8,6,6,0x17,0x17,0x10,0x17,0x17,6,0,0,0,0,0,0,0,
  0,0,0,0x10,0,0,5,5,5,5,5,5,5,6,6,6,
  6,6,8,6,6,6,6,6,0,9,9,9,9,9,9,9,
  9,9,9,0x17,0x17,0x17,0x17,5,8,8,5,0,0,0,0,0,
  0,0,0,5,5,5,6,0x17,0x17,5,0,0,0,0,0,0,
  0,0,0,5,5,5,8,8,8,6,6,6,6,6,6,6,
  6,6,8,5,5,5,5,0x17,0x17,0x17,0x17,6,6,6,6,0x17,
  8,6,9,9,9,9,9,9,9,9,9,9,5,0x17,5,0x17,
  0x17,0x17,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
  0xb,0xb,0,0,0,0,0,0,0,0,0,0,0,5,5,5,
  5,5,5,5,5,5,5,5,5,8,8,8,6,6,8,8,
  6,8,6,6,0x17,0x17,0x17,0x17,0x17,0x17,6,0,5,5,5,5,
  5,5,5,0,5,0,5,5,5,5,0,5,5,5,5,5,
  5,5,5,5,0x17,0,0,0,0,0,0,8,8,8,6,6,
  6,6,6,6,6,6,0,0,0,0,0,6,6,8,8,0,
  5,5,5,5,5,5,5,5,0,0,5,0,5,5,0,5,
  5,5,5,5,0,6,6,5,8,8,6,8,8,8,8,0,
  0,8,8,0,0,8,8,8,0,0,5,0,0,0,0,0,
  0,8,0,0,0,0,0,5,5,5,8,8,0,0,6,6,
  6,6,6,6,6,0,0,0,5,5,5,5,5,8,8,8,
  6,6,6,6,6,6,6,6,8,8,6,6,6,8,6,5,
  5,5,5,0x17,0x17,0x17,0x17,0x17,9,9,9,9,9,9,9,9,
  9,9,0x17,0x17,0,0x17,6,5,8,8,8,6,6,6,6,6,
  6,8,6,8,8,8,8,6,8,6,6,5,5,0x17,5,0,
  0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,
  5,5,5,5,5,5,8,8,6,6,6,6,0,0,8,8,
  8,8,6,6,8,6,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
  0x17,0x17,0x17,0x17,0x17,5,5,5,5,6,6,0,0,8,8,8,
  6,6,6,6,6,6,6,6,8,8,6,8,6,0x17,0x17,0x17,
  5,0,0,0,0,0,0,0,0,0,0,0,0x17,0x17,0x17,0x17,
  0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0,0,0,5,5,5,5,
  5,5,5,5,5,5,5,6,8,6,8,8,6,6,6,6,
  6,6,8,6,5,0x17,0,0,0,0,0,0,8,8,6,6,
  6,6,8,6,6,6,6,6,0,0,0,0,9,9,9,9,
  9,9,9,9,9,9,0xb,0xb,0x17,0x17,0x17,0x1b,6,6,6,6,
  6,6,6,6,8,6,6,0x17,0,0,0,0,0xb,0xb,0xb,0,
  0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,
  5,5,0,0,5,0,0,5,5,5,5,0,5,5,0,5,
  5,5,5,5,5,5,5,8,8,8,8,8,8,0,8,8,
  0,0,6,6,8,6,5,8,5,8,6,0x17,0x17,0x17,0,0,
  0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,0,
  0,5,5,5,5,5,5,8,8,8,6,6,6,6,0,0,
  6,6,8,8,8,8,6,5,0x17,5,8,0,0,0,0,0,
  0,0,0,0,0,0,5,6,6,6,6,6,6,6,6,6,
  6,5,5,5,5,5,6,6,6,6,6,6,8,5,6,6,
  6,6,0x17,0x17,0x17,0x17,0x17,0x17,0x17,6,0,0,0,0,0,0,
  0,0,5,6,6,6,6,6,6,8,8,6,6,6,5,5,
  5,5,6,6,6,6,6,6,6,8,6,6,0x17,0x17,0x17,5,
  0x17,0x17,0x17,0,0,0,0,0,0,0,0,0,0,0,0,0,
  6,6,6,6,6,6,6,0,6,6,6,6,6,6,8,6,
  5,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,0,0,0,0,
  6,6,6,6,6,6,6,6,0,8,6,6,6,6,6,6,
  8,6,6,8,6,6,0,0,0,0,0,0,0,0,0,5,
  6,6,6,6,6,6,0,0,0,6,0,6,6,0,6,6,
  6,6,6,6,5,6,0,0,0,0,0,0,0,0,5,5,
  5,5,5,5,0,5,5,0,5,5,5,5,5,5,5,5,
  5,5,8,8,8,8,8,0,6,6,0,8,8,6,8,6,
  5,0,0,0,0,0,0,0,5,5,5,6,6,8,8,0x17,
  0x17,0,0,0,0,0,0,0,0xb,0xb,0xb,0xb,0xb,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x19,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0x17,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,
  0xa,0xa,0xa,0xa,0,0x17,0x17,0x17,0x17,0x17,0,0,0,0,0,0,
  0,0,0,0,0,5,0x17,0x17,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0,0,
  0,0,0,0,0,6,6,6,6,6,0x17,0,0,0,0,0,
  0,0,0,0,0,6,6,6,6,6,6,6,0x17,0x17,0x17,0x17,
  0x17,0x1b,0x1b,0x1b,0x1b,4,4,4,4,0x17,0x1b,0,0,0,0,0,
  0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,
  0xb,0xb,0xb,0xb,0xb,0,5,5,5,5,5,5,5,5,5,5,
  5,5,5,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x17,0x17,0x17,0x17,0,0,
  0,0,0,5,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,0,0,0,0,0,0,0,6,6,6,4,4,
  4,4,4,4,4,4,4,4,4,4,4,0x17,4,6,0,0,
  0,0,0,0,0,0,0,0,0,8,8,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,4,4,4,4,0,4,4,
  4,4,4,4,4,0,4,4,0,0,0,0,5,5,5,5,
  0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
  5,5,0,0,0x1b,6,6,0x17,0x10,0x10,0x10,0x10,0,0,0,0,
  0,0,0,0,0,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,
  0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,8,8,6,6,6,0x1b,0x1b,0x1b,
  8,8,8,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,6,6,6,6,6,
  0x1b,0x1b,6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
  0x1b,0x1b,0x1b,6,6,6,6,0x1b,0x1b,6,6,6,0x1b,0,0,0,
  0,0,0,0,0,0,0,0xb,0xb,0xb,0xb,0,0,0,0,0,
  0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,
  1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,
  2,2,2,1,0,1,1,0,0,1,0,0,1,1,0,0,
  1,1,1,1,0,1,1,1,1,1,1,2,2,2,2,0,
  2,0,2,2,2,2,1,1,0,1,1,1,1,0,0,1,
  1,1,1,1,0,1,1,1,1,1,1,1,0,2,2,2,
  2,2,2,2,2,1,1,0,1,1,1,1,0,1,1,1,
  1,1,0,1,0,0,0,1,1,1,1,1,1,0,2,2,
  2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,
  2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,
  0x18,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,
  1,1,1,1,1,1,1,1,1,1,0x18,2,2,2,2,2,
  0x18,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,
  0x18,2,2,2,2,2,2,0x18,2,2,2,2,2,2,1,2,
  0,0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
  9,9,6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,6,6,6,
  6,6,6,6,6,6,6,6,6,6,0x1b,0x1b,0x1b,0x1b,0x1b,6,
  0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,6,0x1b,0x1b,0x17,0x17,0x17,
  0x17,0x17,0,0,0,0,2,2,2,2,2,2,2,2,2,2,
  2,2,2,2,2,0,6,6,6,6,6,6,6,6,6,0,
  0,6,6,6,6,6,0,6,6,0,6,6,6,6,6,0,
  0,0,0,0,6,6,6,6,6,6,6,4,4,4,4,4,
  4,4,0,0,9,9,9,9,9,9,9,9,9,9,0,0,
  0,0,5,0x1b,5,5,5,5,5,5,5,5,5,5,5,5,
  5,5,6,0,9,9,9,9,9,9,9,9,9,9,0,0,
  0,0,0,0x19,5,5,5,5,5,5,5,0,5,5,5,5,
  0,5,5,0,5,5,5,5,5,0,0,0xb,0xb,0xb,0xb,0xb,
  0xb,0xb,0xb,0xb,2,2,2,2,6,6,6,6,6,6,6,4,
  0,0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
  0x1b,0xb,0xb,0xb,0x19,0xb,0xb,0xb,0xb,0,0,0,0,0,0,0,
  0,0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
  0xb,0xb,0x1b,0xb,0,5,5,0,5,0,0,5,0,5,5,5,
  5,5,5,5,0,5,5,5,5,0,5,0,5,0,0,0,
  0,5,0,0,0,0,5,0,5,0,5,0,5,5,5,0,
  5,5,0,5,0,0,5,0,5,0,5,0,5,0,5,5,
  0,5,0,0,5,5,5,5,0,5,5,5,5,0,5,5,
  5,5,0,5,0,5,5,5,0,5,5,5,5,5,0,5,
  5,5,5,5,0x18,0x18,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,
  0xb,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
  0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0,0,0x1b,0x1b,
  0x1b,0x1b,0x1b,0,0,0,0x1b,0x1b,0x1b,0x1b,0x1b,0,0,0,0x1b,0x1b,
  0x1b,0,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0,0x10,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0x10,0x10,
  0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x11,
  0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0,0,0,0
]);

pub static HEADER: CodePointTrieHeader = CodePointTrieHeader {
    high_start: 0x110000,
    shifted12_high_start: 0x110,
    trie_type: TrieType::Small,
    index3_null_offset: 0x767,
    data_null_offset: 0xd18,
    null_value: 0x0,
};
